// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package voiceid

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateFraudster = "AssociateFraudster"

// AssociateFraudsterRequest generates a "aws/request.Request" representing the
// client's request for the AssociateFraudster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateFraudster for more information on using the AssociateFraudster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateFraudsterRequest method.
//	req, resp := client.AssociateFraudsterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/AssociateFraudster
func (c *VoiceID) AssociateFraudsterRequest(input *AssociateFraudsterInput) (req *request.Request, output *AssociateFraudsterOutput) {
	op := &request.Operation{
		Name:       opAssociateFraudster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateFraudsterInput{}
	}

	output = &AssociateFraudsterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateFraudster API operation for Amazon Voice ID.
//
// Associates the fraudsters with the watchlist specified in the same domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation AssociateFraudster for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request exceeded the service quota. Refer to Voice ID Service Quotas
//     (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas)
//     and try your request again.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - ConflictException
//     The request failed due to a conflict. Check the ConflictType and error message
//     for more details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/AssociateFraudster
func (c *VoiceID) AssociateFraudster(input *AssociateFraudsterInput) (*AssociateFraudsterOutput, error) {
	req, out := c.AssociateFraudsterRequest(input)
	return out, req.Send()
}

// AssociateFraudsterWithContext is the same as AssociateFraudster with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateFraudster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) AssociateFraudsterWithContext(ctx aws.Context, input *AssociateFraudsterInput, opts ...request.Option) (*AssociateFraudsterOutput, error) {
	req, out := c.AssociateFraudsterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomain for more information on using the CreateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDomainRequest method.
//	req, resp := client.CreateDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/CreateDomain
func (c *VoiceID) CreateDomainRequest(input *CreateDomainInput) (req *request.Request, output *CreateDomainOutput) {
	op := &request.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	output = &CreateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomain API operation for Amazon Voice ID.
//
// Creates a domain that contains all Amazon Connect Voice ID data, such as
// speakers, fraudsters, customer audio, and voiceprints. Every domain is created
// with a default watchlist that fraudsters can be a part of.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation CreateDomain for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request exceeded the service quota. Refer to Voice ID Service Quotas
//     (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas)
//     and try your request again.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - ConflictException
//     The request failed due to a conflict. Check the ConflictType and error message
//     for more details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/CreateDomain
func (c *VoiceID) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	return out, req.Send()
}

// CreateDomainWithContext is the same as CreateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) CreateDomainWithContext(ctx aws.Context, input *CreateDomainInput, opts ...request.Option) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWatchlist = "CreateWatchlist"

// CreateWatchlistRequest generates a "aws/request.Request" representing the
// client's request for the CreateWatchlist operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWatchlist for more information on using the CreateWatchlist
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWatchlistRequest method.
//	req, resp := client.CreateWatchlistRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/CreateWatchlist
func (c *VoiceID) CreateWatchlistRequest(input *CreateWatchlistInput) (req *request.Request, output *CreateWatchlistOutput) {
	op := &request.Operation{
		Name:       opCreateWatchlist,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWatchlistInput{}
	}

	output = &CreateWatchlistOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWatchlist API operation for Amazon Voice ID.
//
// Creates a watchlist that fraudsters can be a part of.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation CreateWatchlist for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request exceeded the service quota. Refer to Voice ID Service Quotas
//     (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas)
//     and try your request again.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - ConflictException
//     The request failed due to a conflict. Check the ConflictType and error message
//     for more details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/CreateWatchlist
func (c *VoiceID) CreateWatchlist(input *CreateWatchlistInput) (*CreateWatchlistOutput, error) {
	req, out := c.CreateWatchlistRequest(input)
	return out, req.Send()
}

// CreateWatchlistWithContext is the same as CreateWatchlist with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWatchlist for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) CreateWatchlistWithContext(ctx aws.Context, input *CreateWatchlistInput, opts ...request.Option) (*CreateWatchlistOutput, error) {
	req, out := c.CreateWatchlistRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomain for more information on using the DeleteDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDomainRequest method.
//	req, resp := client.DeleteDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteDomain
func (c *VoiceID) DeleteDomainRequest(input *DeleteDomainInput) (req *request.Request, output *DeleteDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	output = &DeleteDomainOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDomain API operation for Amazon Voice ID.
//
// Deletes the specified domain from Voice ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation DeleteDomain for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - ConflictException
//     The request failed due to a conflict. Check the ConflictType and error message
//     for more details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteDomain
func (c *VoiceID) DeleteDomain(input *DeleteDomainInput) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	return out, req.Send()
}

// DeleteDomainWithContext is the same as DeleteDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) DeleteDomainWithContext(ctx aws.Context, input *DeleteDomainInput, opts ...request.Option) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFraudster = "DeleteFraudster"

// DeleteFraudsterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFraudster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFraudster for more information on using the DeleteFraudster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFraudsterRequest method.
//	req, resp := client.DeleteFraudsterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteFraudster
func (c *VoiceID) DeleteFraudsterRequest(input *DeleteFraudsterInput) (req *request.Request, output *DeleteFraudsterOutput) {
	op := &request.Operation{
		Name:       opDeleteFraudster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFraudsterInput{}
	}

	output = &DeleteFraudsterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFraudster API operation for Amazon Voice ID.
//
// Deletes the specified fraudster from Voice ID. This action disassociates
// the fraudster from any watchlists it is a part of.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation DeleteFraudster for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - ConflictException
//     The request failed due to a conflict. Check the ConflictType and error message
//     for more details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteFraudster
func (c *VoiceID) DeleteFraudster(input *DeleteFraudsterInput) (*DeleteFraudsterOutput, error) {
	req, out := c.DeleteFraudsterRequest(input)
	return out, req.Send()
}

// DeleteFraudsterWithContext is the same as DeleteFraudster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFraudster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) DeleteFraudsterWithContext(ctx aws.Context, input *DeleteFraudsterInput, opts ...request.Option) (*DeleteFraudsterOutput, error) {
	req, out := c.DeleteFraudsterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSpeaker = "DeleteSpeaker"

// DeleteSpeakerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSpeaker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSpeaker for more information on using the DeleteSpeaker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSpeakerRequest method.
//	req, resp := client.DeleteSpeakerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteSpeaker
func (c *VoiceID) DeleteSpeakerRequest(input *DeleteSpeakerInput) (req *request.Request, output *DeleteSpeakerOutput) {
	op := &request.Operation{
		Name:       opDeleteSpeaker,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSpeakerInput{}
	}

	output = &DeleteSpeakerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSpeaker API operation for Amazon Voice ID.
//
// Deletes the specified speaker from Voice ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation DeleteSpeaker for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - ConflictException
//     The request failed due to a conflict. Check the ConflictType and error message
//     for more details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteSpeaker
func (c *VoiceID) DeleteSpeaker(input *DeleteSpeakerInput) (*DeleteSpeakerOutput, error) {
	req, out := c.DeleteSpeakerRequest(input)
	return out, req.Send()
}

// DeleteSpeakerWithContext is the same as DeleteSpeaker with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSpeaker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) DeleteSpeakerWithContext(ctx aws.Context, input *DeleteSpeakerInput, opts ...request.Option) (*DeleteSpeakerOutput, error) {
	req, out := c.DeleteSpeakerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWatchlist = "DeleteWatchlist"

// DeleteWatchlistRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWatchlist operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWatchlist for more information on using the DeleteWatchlist
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWatchlistRequest method.
//	req, resp := client.DeleteWatchlistRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteWatchlist
func (c *VoiceID) DeleteWatchlistRequest(input *DeleteWatchlistInput) (req *request.Request, output *DeleteWatchlistOutput) {
	op := &request.Operation{
		Name:       opDeleteWatchlist,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWatchlistInput{}
	}

	output = &DeleteWatchlistOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWatchlist API operation for Amazon Voice ID.
//
// Deletes the specified watchlist from Voice ID. This API throws an exception
// when there are fraudsters in the watchlist that you are trying to delete.
// You must delete the fraudsters, and then delete the watchlist. Every domain
// has a default watchlist which cannot be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation DeleteWatchlist for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - ConflictException
//     The request failed due to a conflict. Check the ConflictType and error message
//     for more details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DeleteWatchlist
func (c *VoiceID) DeleteWatchlist(input *DeleteWatchlistInput) (*DeleteWatchlistOutput, error) {
	req, out := c.DeleteWatchlistRequest(input)
	return out, req.Send()
}

// DeleteWatchlistWithContext is the same as DeleteWatchlist with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWatchlist for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) DeleteWatchlistWithContext(ctx aws.Context, input *DeleteWatchlistInput, opts ...request.Option) (*DeleteWatchlistOutput, error) {
	req, out := c.DeleteWatchlistRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomain = "DescribeDomain"

// DescribeDomainRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomain for more information on using the DescribeDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDomainRequest method.
//	req, resp := client.DescribeDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeDomain
func (c *VoiceID) DescribeDomainRequest(input *DescribeDomainInput) (req *request.Request, output *DescribeDomainOutput) {
	op := &request.Operation{
		Name:       opDescribeDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDomainInput{}
	}

	output = &DescribeDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomain API operation for Amazon Voice ID.
//
// Describes the specified domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation DescribeDomain for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeDomain
func (c *VoiceID) DescribeDomain(input *DescribeDomainInput) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	return out, req.Send()
}

// DescribeDomainWithContext is the same as DescribeDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) DescribeDomainWithContext(ctx aws.Context, input *DescribeDomainInput, opts ...request.Option) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFraudster = "DescribeFraudster"

// DescribeFraudsterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFraudster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFraudster for more information on using the DescribeFraudster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFraudsterRequest method.
//	req, resp := client.DescribeFraudsterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeFraudster
func (c *VoiceID) DescribeFraudsterRequest(input *DescribeFraudsterInput) (req *request.Request, output *DescribeFraudsterOutput) {
	op := &request.Operation{
		Name:       opDescribeFraudster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFraudsterInput{}
	}

	output = &DescribeFraudsterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFraudster API operation for Amazon Voice ID.
//
// Describes the specified fraudster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation DescribeFraudster for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeFraudster
func (c *VoiceID) DescribeFraudster(input *DescribeFraudsterInput) (*DescribeFraudsterOutput, error) {
	req, out := c.DescribeFraudsterRequest(input)
	return out, req.Send()
}

// DescribeFraudsterWithContext is the same as DescribeFraudster with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFraudster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) DescribeFraudsterWithContext(ctx aws.Context, input *DescribeFraudsterInput, opts ...request.Option) (*DescribeFraudsterOutput, error) {
	req, out := c.DescribeFraudsterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFraudsterRegistrationJob = "DescribeFraudsterRegistrationJob"

// DescribeFraudsterRegistrationJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFraudsterRegistrationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFraudsterRegistrationJob for more information on using the DescribeFraudsterRegistrationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFraudsterRegistrationJobRequest method.
//	req, resp := client.DescribeFraudsterRegistrationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeFraudsterRegistrationJob
func (c *VoiceID) DescribeFraudsterRegistrationJobRequest(input *DescribeFraudsterRegistrationJobInput) (req *request.Request, output *DescribeFraudsterRegistrationJobOutput) {
	op := &request.Operation{
		Name:       opDescribeFraudsterRegistrationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFraudsterRegistrationJobInput{}
	}

	output = &DescribeFraudsterRegistrationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFraudsterRegistrationJob API operation for Amazon Voice ID.
//
// Describes the specified fraudster registration job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation DescribeFraudsterRegistrationJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeFraudsterRegistrationJob
func (c *VoiceID) DescribeFraudsterRegistrationJob(input *DescribeFraudsterRegistrationJobInput) (*DescribeFraudsterRegistrationJobOutput, error) {
	req, out := c.DescribeFraudsterRegistrationJobRequest(input)
	return out, req.Send()
}

// DescribeFraudsterRegistrationJobWithContext is the same as DescribeFraudsterRegistrationJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFraudsterRegistrationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) DescribeFraudsterRegistrationJobWithContext(ctx aws.Context, input *DescribeFraudsterRegistrationJobInput, opts ...request.Option) (*DescribeFraudsterRegistrationJobOutput, error) {
	req, out := c.DescribeFraudsterRegistrationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSpeaker = "DescribeSpeaker"

// DescribeSpeakerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSpeaker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSpeaker for more information on using the DescribeSpeaker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSpeakerRequest method.
//	req, resp := client.DescribeSpeakerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeSpeaker
func (c *VoiceID) DescribeSpeakerRequest(input *DescribeSpeakerInput) (req *request.Request, output *DescribeSpeakerOutput) {
	op := &request.Operation{
		Name:       opDescribeSpeaker,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSpeakerInput{}
	}

	output = &DescribeSpeakerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSpeaker API operation for Amazon Voice ID.
//
// Describes the specified speaker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation DescribeSpeaker for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeSpeaker
func (c *VoiceID) DescribeSpeaker(input *DescribeSpeakerInput) (*DescribeSpeakerOutput, error) {
	req, out := c.DescribeSpeakerRequest(input)
	return out, req.Send()
}

// DescribeSpeakerWithContext is the same as DescribeSpeaker with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSpeaker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) DescribeSpeakerWithContext(ctx aws.Context, input *DescribeSpeakerInput, opts ...request.Option) (*DescribeSpeakerOutput, error) {
	req, out := c.DescribeSpeakerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSpeakerEnrollmentJob = "DescribeSpeakerEnrollmentJob"

// DescribeSpeakerEnrollmentJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSpeakerEnrollmentJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSpeakerEnrollmentJob for more information on using the DescribeSpeakerEnrollmentJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSpeakerEnrollmentJobRequest method.
//	req, resp := client.DescribeSpeakerEnrollmentJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeSpeakerEnrollmentJob
func (c *VoiceID) DescribeSpeakerEnrollmentJobRequest(input *DescribeSpeakerEnrollmentJobInput) (req *request.Request, output *DescribeSpeakerEnrollmentJobOutput) {
	op := &request.Operation{
		Name:       opDescribeSpeakerEnrollmentJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSpeakerEnrollmentJobInput{}
	}

	output = &DescribeSpeakerEnrollmentJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSpeakerEnrollmentJob API operation for Amazon Voice ID.
//
// Describes the specified speaker enrollment job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation DescribeSpeakerEnrollmentJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeSpeakerEnrollmentJob
func (c *VoiceID) DescribeSpeakerEnrollmentJob(input *DescribeSpeakerEnrollmentJobInput) (*DescribeSpeakerEnrollmentJobOutput, error) {
	req, out := c.DescribeSpeakerEnrollmentJobRequest(input)
	return out, req.Send()
}

// DescribeSpeakerEnrollmentJobWithContext is the same as DescribeSpeakerEnrollmentJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSpeakerEnrollmentJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) DescribeSpeakerEnrollmentJobWithContext(ctx aws.Context, input *DescribeSpeakerEnrollmentJobInput, opts ...request.Option) (*DescribeSpeakerEnrollmentJobOutput, error) {
	req, out := c.DescribeSpeakerEnrollmentJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWatchlist = "DescribeWatchlist"

// DescribeWatchlistRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWatchlist operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWatchlist for more information on using the DescribeWatchlist
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeWatchlistRequest method.
//	req, resp := client.DescribeWatchlistRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeWatchlist
func (c *VoiceID) DescribeWatchlistRequest(input *DescribeWatchlistInput) (req *request.Request, output *DescribeWatchlistOutput) {
	op := &request.Operation{
		Name:       opDescribeWatchlist,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWatchlistInput{}
	}

	output = &DescribeWatchlistOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWatchlist API operation for Amazon Voice ID.
//
// Describes the specified watchlist.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation DescribeWatchlist for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DescribeWatchlist
func (c *VoiceID) DescribeWatchlist(input *DescribeWatchlistInput) (*DescribeWatchlistOutput, error) {
	req, out := c.DescribeWatchlistRequest(input)
	return out, req.Send()
}

// DescribeWatchlistWithContext is the same as DescribeWatchlist with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWatchlist for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) DescribeWatchlistWithContext(ctx aws.Context, input *DescribeWatchlistInput, opts ...request.Option) (*DescribeWatchlistOutput, error) {
	req, out := c.DescribeWatchlistRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateFraudster = "DisassociateFraudster"

// DisassociateFraudsterRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateFraudster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateFraudster for more information on using the DisassociateFraudster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateFraudsterRequest method.
//	req, resp := client.DisassociateFraudsterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DisassociateFraudster
func (c *VoiceID) DisassociateFraudsterRequest(input *DisassociateFraudsterInput) (req *request.Request, output *DisassociateFraudsterOutput) {
	op := &request.Operation{
		Name:       opDisassociateFraudster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateFraudsterInput{}
	}

	output = &DisassociateFraudsterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateFraudster API operation for Amazon Voice ID.
//
// Disassociates the fraudsters from the watchlist specified. Voice ID always
// expects a fraudster to be a part of at least one watchlist. If you try to
// disassociate a fraudster from its only watchlist, a ValidationException is
// thrown.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation DisassociateFraudster for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - ConflictException
//     The request failed due to a conflict. Check the ConflictType and error message
//     for more details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/DisassociateFraudster
func (c *VoiceID) DisassociateFraudster(input *DisassociateFraudsterInput) (*DisassociateFraudsterOutput, error) {
	req, out := c.DisassociateFraudsterRequest(input)
	return out, req.Send()
}

// DisassociateFraudsterWithContext is the same as DisassociateFraudster with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateFraudster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) DisassociateFraudsterWithContext(ctx aws.Context, input *DisassociateFraudsterInput, opts ...request.Option) (*DisassociateFraudsterOutput, error) {
	req, out := c.DisassociateFraudsterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEvaluateSession = "EvaluateSession"

// EvaluateSessionRequest generates a "aws/request.Request" representing the
// client's request for the EvaluateSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EvaluateSession for more information on using the EvaluateSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EvaluateSessionRequest method.
//	req, resp := client.EvaluateSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/EvaluateSession
func (c *VoiceID) EvaluateSessionRequest(input *EvaluateSessionInput) (req *request.Request, output *EvaluateSessionOutput) {
	op := &request.Operation{
		Name:       opEvaluateSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EvaluateSessionInput{}
	}

	output = &EvaluateSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EvaluateSession API operation for Amazon Voice ID.
//
// Evaluates a specified session based on audio data accumulated during a streaming
// Amazon Connect Voice ID call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation EvaluateSession for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - ConflictException
//     The request failed due to a conflict. Check the ConflictType and error message
//     for more details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/EvaluateSession
func (c *VoiceID) EvaluateSession(input *EvaluateSessionInput) (*EvaluateSessionOutput, error) {
	req, out := c.EvaluateSessionRequest(input)
	return out, req.Send()
}

// EvaluateSessionWithContext is the same as EvaluateSession with the addition of
// the ability to pass a context and additional request options.
//
// See EvaluateSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) EvaluateSessionWithContext(ctx aws.Context, input *EvaluateSessionInput, opts ...request.Option) (*EvaluateSessionOutput, error) {
	req, out := c.EvaluateSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomains = "ListDomains"

// ListDomainsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomains for more information on using the ListDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDomainsRequest method.
//	req, resp := client.ListDomainsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListDomains
func (c *VoiceID) ListDomainsRequest(input *ListDomainsInput) (req *request.Request, output *ListDomainsOutput) {
	op := &request.Operation{
		Name:       opListDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsInput{}
	}

	output = &ListDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomains API operation for Amazon Voice ID.
//
// Lists all the domains in the Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation ListDomains for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListDomains
func (c *VoiceID) ListDomains(input *ListDomainsInput) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	return out, req.Send()
}

// ListDomainsWithContext is the same as ListDomains with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) ListDomainsWithContext(ctx aws.Context, input *ListDomainsInput, opts ...request.Option) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDomainsPages iterates over the pages of a ListDomains operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomains method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDomains operation.
//	pageNum := 0
//	err := client.ListDomainsPages(params,
//	    func(page *voiceid.ListDomainsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VoiceID) ListDomainsPages(input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool) error {
	return c.ListDomainsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDomainsPagesWithContext same as ListDomainsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) ListDomainsPagesWithContext(ctx aws.Context, input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDomainsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDomainsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDomainsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFraudsterRegistrationJobs = "ListFraudsterRegistrationJobs"

// ListFraudsterRegistrationJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListFraudsterRegistrationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFraudsterRegistrationJobs for more information on using the ListFraudsterRegistrationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFraudsterRegistrationJobsRequest method.
//	req, resp := client.ListFraudsterRegistrationJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListFraudsterRegistrationJobs
func (c *VoiceID) ListFraudsterRegistrationJobsRequest(input *ListFraudsterRegistrationJobsInput) (req *request.Request, output *ListFraudsterRegistrationJobsOutput) {
	op := &request.Operation{
		Name:       opListFraudsterRegistrationJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFraudsterRegistrationJobsInput{}
	}

	output = &ListFraudsterRegistrationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFraudsterRegistrationJobs API operation for Amazon Voice ID.
//
// Lists all the fraudster registration jobs in the domain with the given JobStatus.
// If JobStatus is not provided, this lists all fraudster registration jobs
// in the given domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation ListFraudsterRegistrationJobs for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListFraudsterRegistrationJobs
func (c *VoiceID) ListFraudsterRegistrationJobs(input *ListFraudsterRegistrationJobsInput) (*ListFraudsterRegistrationJobsOutput, error) {
	req, out := c.ListFraudsterRegistrationJobsRequest(input)
	return out, req.Send()
}

// ListFraudsterRegistrationJobsWithContext is the same as ListFraudsterRegistrationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListFraudsterRegistrationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) ListFraudsterRegistrationJobsWithContext(ctx aws.Context, input *ListFraudsterRegistrationJobsInput, opts ...request.Option) (*ListFraudsterRegistrationJobsOutput, error) {
	req, out := c.ListFraudsterRegistrationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFraudsterRegistrationJobsPages iterates over the pages of a ListFraudsterRegistrationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFraudsterRegistrationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFraudsterRegistrationJobs operation.
//	pageNum := 0
//	err := client.ListFraudsterRegistrationJobsPages(params,
//	    func(page *voiceid.ListFraudsterRegistrationJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VoiceID) ListFraudsterRegistrationJobsPages(input *ListFraudsterRegistrationJobsInput, fn func(*ListFraudsterRegistrationJobsOutput, bool) bool) error {
	return c.ListFraudsterRegistrationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFraudsterRegistrationJobsPagesWithContext same as ListFraudsterRegistrationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) ListFraudsterRegistrationJobsPagesWithContext(ctx aws.Context, input *ListFraudsterRegistrationJobsInput, fn func(*ListFraudsterRegistrationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFraudsterRegistrationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFraudsterRegistrationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFraudsterRegistrationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFraudsters = "ListFraudsters"

// ListFraudstersRequest generates a "aws/request.Request" representing the
// client's request for the ListFraudsters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFraudsters for more information on using the ListFraudsters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFraudstersRequest method.
//	req, resp := client.ListFraudstersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListFraudsters
func (c *VoiceID) ListFraudstersRequest(input *ListFraudstersInput) (req *request.Request, output *ListFraudstersOutput) {
	op := &request.Operation{
		Name:       opListFraudsters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFraudstersInput{}
	}

	output = &ListFraudstersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFraudsters API operation for Amazon Voice ID.
//
// Lists all fraudsters in a specified watchlist or domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation ListFraudsters for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListFraudsters
func (c *VoiceID) ListFraudsters(input *ListFraudstersInput) (*ListFraudstersOutput, error) {
	req, out := c.ListFraudstersRequest(input)
	return out, req.Send()
}

// ListFraudstersWithContext is the same as ListFraudsters with the addition of
// the ability to pass a context and additional request options.
//
// See ListFraudsters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) ListFraudstersWithContext(ctx aws.Context, input *ListFraudstersInput, opts ...request.Option) (*ListFraudstersOutput, error) {
	req, out := c.ListFraudstersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFraudstersPages iterates over the pages of a ListFraudsters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFraudsters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFraudsters operation.
//	pageNum := 0
//	err := client.ListFraudstersPages(params,
//	    func(page *voiceid.ListFraudstersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VoiceID) ListFraudstersPages(input *ListFraudstersInput, fn func(*ListFraudstersOutput, bool) bool) error {
	return c.ListFraudstersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFraudstersPagesWithContext same as ListFraudstersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) ListFraudstersPagesWithContext(ctx aws.Context, input *ListFraudstersInput, fn func(*ListFraudstersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFraudstersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFraudstersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFraudstersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSpeakerEnrollmentJobs = "ListSpeakerEnrollmentJobs"

// ListSpeakerEnrollmentJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListSpeakerEnrollmentJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSpeakerEnrollmentJobs for more information on using the ListSpeakerEnrollmentJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSpeakerEnrollmentJobsRequest method.
//	req, resp := client.ListSpeakerEnrollmentJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakerEnrollmentJobs
func (c *VoiceID) ListSpeakerEnrollmentJobsRequest(input *ListSpeakerEnrollmentJobsInput) (req *request.Request, output *ListSpeakerEnrollmentJobsOutput) {
	op := &request.Operation{
		Name:       opListSpeakerEnrollmentJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSpeakerEnrollmentJobsInput{}
	}

	output = &ListSpeakerEnrollmentJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSpeakerEnrollmentJobs API operation for Amazon Voice ID.
//
// Lists all the speaker enrollment jobs in the domain with the specified JobStatus.
// If JobStatus is not provided, this lists all jobs with all possible speaker
// enrollment job statuses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation ListSpeakerEnrollmentJobs for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakerEnrollmentJobs
func (c *VoiceID) ListSpeakerEnrollmentJobs(input *ListSpeakerEnrollmentJobsInput) (*ListSpeakerEnrollmentJobsOutput, error) {
	req, out := c.ListSpeakerEnrollmentJobsRequest(input)
	return out, req.Send()
}

// ListSpeakerEnrollmentJobsWithContext is the same as ListSpeakerEnrollmentJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListSpeakerEnrollmentJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) ListSpeakerEnrollmentJobsWithContext(ctx aws.Context, input *ListSpeakerEnrollmentJobsInput, opts ...request.Option) (*ListSpeakerEnrollmentJobsOutput, error) {
	req, out := c.ListSpeakerEnrollmentJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSpeakerEnrollmentJobsPages iterates over the pages of a ListSpeakerEnrollmentJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSpeakerEnrollmentJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSpeakerEnrollmentJobs operation.
//	pageNum := 0
//	err := client.ListSpeakerEnrollmentJobsPages(params,
//	    func(page *voiceid.ListSpeakerEnrollmentJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VoiceID) ListSpeakerEnrollmentJobsPages(input *ListSpeakerEnrollmentJobsInput, fn func(*ListSpeakerEnrollmentJobsOutput, bool) bool) error {
	return c.ListSpeakerEnrollmentJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSpeakerEnrollmentJobsPagesWithContext same as ListSpeakerEnrollmentJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) ListSpeakerEnrollmentJobsPagesWithContext(ctx aws.Context, input *ListSpeakerEnrollmentJobsInput, fn func(*ListSpeakerEnrollmentJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSpeakerEnrollmentJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSpeakerEnrollmentJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSpeakerEnrollmentJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSpeakers = "ListSpeakers"

// ListSpeakersRequest generates a "aws/request.Request" representing the
// client's request for the ListSpeakers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSpeakers for more information on using the ListSpeakers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSpeakersRequest method.
//	req, resp := client.ListSpeakersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakers
func (c *VoiceID) ListSpeakersRequest(input *ListSpeakersInput) (req *request.Request, output *ListSpeakersOutput) {
	op := &request.Operation{
		Name:       opListSpeakers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSpeakersInput{}
	}

	output = &ListSpeakersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSpeakers API operation for Amazon Voice ID.
//
// Lists all speakers in a specified domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation ListSpeakers for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListSpeakers
func (c *VoiceID) ListSpeakers(input *ListSpeakersInput) (*ListSpeakersOutput, error) {
	req, out := c.ListSpeakersRequest(input)
	return out, req.Send()
}

// ListSpeakersWithContext is the same as ListSpeakers with the addition of
// the ability to pass a context and additional request options.
//
// See ListSpeakers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) ListSpeakersWithContext(ctx aws.Context, input *ListSpeakersInput, opts ...request.Option) (*ListSpeakersOutput, error) {
	req, out := c.ListSpeakersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSpeakersPages iterates over the pages of a ListSpeakers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSpeakers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSpeakers operation.
//	pageNum := 0
//	err := client.ListSpeakersPages(params,
//	    func(page *voiceid.ListSpeakersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VoiceID) ListSpeakersPages(input *ListSpeakersInput, fn func(*ListSpeakersOutput, bool) bool) error {
	return c.ListSpeakersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSpeakersPagesWithContext same as ListSpeakersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) ListSpeakersPagesWithContext(ctx aws.Context, input *ListSpeakersInput, fn func(*ListSpeakersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSpeakersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSpeakersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSpeakersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListTagsForResource
func (c *VoiceID) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Voice ID.
//
// Lists all tags associated with a specified Voice ID resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListTagsForResource
func (c *VoiceID) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWatchlists = "ListWatchlists"

// ListWatchlistsRequest generates a "aws/request.Request" representing the
// client's request for the ListWatchlists operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWatchlists for more information on using the ListWatchlists
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWatchlistsRequest method.
//	req, resp := client.ListWatchlistsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListWatchlists
func (c *VoiceID) ListWatchlistsRequest(input *ListWatchlistsInput) (req *request.Request, output *ListWatchlistsOutput) {
	op := &request.Operation{
		Name:       opListWatchlists,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWatchlistsInput{}
	}

	output = &ListWatchlistsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWatchlists API operation for Amazon Voice ID.
//
// Lists all watchlists in a specified domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation ListWatchlists for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/ListWatchlists
func (c *VoiceID) ListWatchlists(input *ListWatchlistsInput) (*ListWatchlistsOutput, error) {
	req, out := c.ListWatchlistsRequest(input)
	return out, req.Send()
}

// ListWatchlistsWithContext is the same as ListWatchlists with the addition of
// the ability to pass a context and additional request options.
//
// See ListWatchlists for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) ListWatchlistsWithContext(ctx aws.Context, input *ListWatchlistsInput, opts ...request.Option) (*ListWatchlistsOutput, error) {
	req, out := c.ListWatchlistsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWatchlistsPages iterates over the pages of a ListWatchlists operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWatchlists method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWatchlists operation.
//	pageNum := 0
//	err := client.ListWatchlistsPages(params,
//	    func(page *voiceid.ListWatchlistsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *VoiceID) ListWatchlistsPages(input *ListWatchlistsInput, fn func(*ListWatchlistsOutput, bool) bool) error {
	return c.ListWatchlistsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWatchlistsPagesWithContext same as ListWatchlistsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) ListWatchlistsPagesWithContext(ctx aws.Context, input *ListWatchlistsInput, fn func(*ListWatchlistsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWatchlistsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWatchlistsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWatchlistsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opOptOutSpeaker = "OptOutSpeaker"

// OptOutSpeakerRequest generates a "aws/request.Request" representing the
// client's request for the OptOutSpeaker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See OptOutSpeaker for more information on using the OptOutSpeaker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the OptOutSpeakerRequest method.
//	req, resp := client.OptOutSpeakerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/OptOutSpeaker
func (c *VoiceID) OptOutSpeakerRequest(input *OptOutSpeakerInput) (req *request.Request, output *OptOutSpeakerOutput) {
	op := &request.Operation{
		Name:       opOptOutSpeaker,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &OptOutSpeakerInput{}
	}

	output = &OptOutSpeakerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// OptOutSpeaker API operation for Amazon Voice ID.
//
// Opts out a speaker from Voice ID. A speaker can be opted out regardless of
// whether or not they already exist in Voice ID. If they don't yet exist, a
// new speaker is created in an opted out state. If they already exist, their
// existing status is overridden and they are opted out. Enrollment and evaluation
// authentication requests are rejected for opted out speakers, and opted out
// speakers have no voice embeddings stored in Voice ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation OptOutSpeaker for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request exceeded the service quota. Refer to Voice ID Service Quotas
//     (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas)
//     and try your request again.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - ConflictException
//     The request failed due to a conflict. Check the ConflictType and error message
//     for more details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/OptOutSpeaker
func (c *VoiceID) OptOutSpeaker(input *OptOutSpeakerInput) (*OptOutSpeakerOutput, error) {
	req, out := c.OptOutSpeakerRequest(input)
	return out, req.Send()
}

// OptOutSpeakerWithContext is the same as OptOutSpeaker with the addition of
// the ability to pass a context and additional request options.
//
// See OptOutSpeaker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) OptOutSpeakerWithContext(ctx aws.Context, input *OptOutSpeakerInput, opts ...request.Option) (*OptOutSpeakerOutput, error) {
	req, out := c.OptOutSpeakerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartFraudsterRegistrationJob = "StartFraudsterRegistrationJob"

// StartFraudsterRegistrationJobRequest generates a "aws/request.Request" representing the
// client's request for the StartFraudsterRegistrationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartFraudsterRegistrationJob for more information on using the StartFraudsterRegistrationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartFraudsterRegistrationJobRequest method.
//	req, resp := client.StartFraudsterRegistrationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/StartFraudsterRegistrationJob
func (c *VoiceID) StartFraudsterRegistrationJobRequest(input *StartFraudsterRegistrationJobInput) (req *request.Request, output *StartFraudsterRegistrationJobOutput) {
	op := &request.Operation{
		Name:       opStartFraudsterRegistrationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartFraudsterRegistrationJobInput{}
	}

	output = &StartFraudsterRegistrationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartFraudsterRegistrationJob API operation for Amazon Voice ID.
//
// Starts a new batch fraudster registration job using provided details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation StartFraudsterRegistrationJob for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request exceeded the service quota. Refer to Voice ID Service Quotas
//     (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas)
//     and try your request again.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - ConflictException
//     The request failed due to a conflict. Check the ConflictType and error message
//     for more details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/StartFraudsterRegistrationJob
func (c *VoiceID) StartFraudsterRegistrationJob(input *StartFraudsterRegistrationJobInput) (*StartFraudsterRegistrationJobOutput, error) {
	req, out := c.StartFraudsterRegistrationJobRequest(input)
	return out, req.Send()
}

// StartFraudsterRegistrationJobWithContext is the same as StartFraudsterRegistrationJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartFraudsterRegistrationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) StartFraudsterRegistrationJobWithContext(ctx aws.Context, input *StartFraudsterRegistrationJobInput, opts ...request.Option) (*StartFraudsterRegistrationJobOutput, error) {
	req, out := c.StartFraudsterRegistrationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSpeakerEnrollmentJob = "StartSpeakerEnrollmentJob"

// StartSpeakerEnrollmentJobRequest generates a "aws/request.Request" representing the
// client's request for the StartSpeakerEnrollmentJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSpeakerEnrollmentJob for more information on using the StartSpeakerEnrollmentJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartSpeakerEnrollmentJobRequest method.
//	req, resp := client.StartSpeakerEnrollmentJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/StartSpeakerEnrollmentJob
func (c *VoiceID) StartSpeakerEnrollmentJobRequest(input *StartSpeakerEnrollmentJobInput) (req *request.Request, output *StartSpeakerEnrollmentJobOutput) {
	op := &request.Operation{
		Name:       opStartSpeakerEnrollmentJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartSpeakerEnrollmentJobInput{}
	}

	output = &StartSpeakerEnrollmentJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSpeakerEnrollmentJob API operation for Amazon Voice ID.
//
// Starts a new batch speaker enrollment job using specified details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation StartSpeakerEnrollmentJob for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request exceeded the service quota. Refer to Voice ID Service Quotas
//     (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas)
//     and try your request again.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - ConflictException
//     The request failed due to a conflict. Check the ConflictType and error message
//     for more details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/StartSpeakerEnrollmentJob
func (c *VoiceID) StartSpeakerEnrollmentJob(input *StartSpeakerEnrollmentJobInput) (*StartSpeakerEnrollmentJobOutput, error) {
	req, out := c.StartSpeakerEnrollmentJobRequest(input)
	return out, req.Send()
}

// StartSpeakerEnrollmentJobWithContext is the same as StartSpeakerEnrollmentJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartSpeakerEnrollmentJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) StartSpeakerEnrollmentJobWithContext(ctx aws.Context, input *StartSpeakerEnrollmentJobInput, opts ...request.Option) (*StartSpeakerEnrollmentJobOutput, error) {
	req, out := c.StartSpeakerEnrollmentJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/TagResource
func (c *VoiceID) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Voice ID.
//
// Tags a Voice ID resource with the provided list of tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - ConflictException
//     The request failed due to a conflict. Check the ConflictType and error message
//     for more details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/TagResource
func (c *VoiceID) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UntagResource
func (c *VoiceID) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Voice ID.
//
// Removes specified tags from a specified Amazon Connect Voice ID resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - ConflictException
//     The request failed due to a conflict. Check the ConflictType and error message
//     for more details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UntagResource
func (c *VoiceID) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDomain = "UpdateDomain"

// UpdateDomainRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDomain for more information on using the UpdateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDomainRequest method.
//	req, resp := client.UpdateDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UpdateDomain
func (c *VoiceID) UpdateDomainRequest(input *UpdateDomainInput) (req *request.Request, output *UpdateDomainOutput) {
	op := &request.Operation{
		Name:       opUpdateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDomainInput{}
	}

	output = &UpdateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDomain API operation for Amazon Voice ID.
//
// Updates the specified domain. This API has clobber behavior, and clears and
// replaces all attributes. If an optional field, such as 'Description' is not
// provided, it is removed from the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation UpdateDomain for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - ConflictException
//     The request failed due to a conflict. Check the ConflictType and error message
//     for more details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UpdateDomain
func (c *VoiceID) UpdateDomain(input *UpdateDomainInput) (*UpdateDomainOutput, error) {
	req, out := c.UpdateDomainRequest(input)
	return out, req.Send()
}

// UpdateDomainWithContext is the same as UpdateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) UpdateDomainWithContext(ctx aws.Context, input *UpdateDomainInput, opts ...request.Option) (*UpdateDomainOutput, error) {
	req, out := c.UpdateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWatchlist = "UpdateWatchlist"

// UpdateWatchlistRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWatchlist operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWatchlist for more information on using the UpdateWatchlist
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWatchlistRequest method.
//	req, resp := client.UpdateWatchlistRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UpdateWatchlist
func (c *VoiceID) UpdateWatchlistRequest(input *UpdateWatchlistInput) (req *request.Request, output *UpdateWatchlistOutput) {
	op := &request.Operation{
		Name:       opUpdateWatchlist,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWatchlistInput{}
	}

	output = &UpdateWatchlistOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWatchlist API operation for Amazon Voice ID.
//
// Updates the specified watchlist. Every domain has a default watchlist which
// cannot be updated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Voice ID's
// API operation UpdateWatchlist for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource cannot be found. Check the ResourceType and error
//     message for more details.
//
//   - ValidationException
//     The request failed one or more validations; check the error message for more
//     details.
//
//   - ConflictException
//     The request failed due to a conflict. Check the ConflictType and error message
//     for more details.
//
//   - InternalServerException
//     The request failed due to an unknown error on the server side.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please slow down your request
//     rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
//     and try your request again.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action. Check the
//     error message and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UpdateWatchlist
func (c *VoiceID) UpdateWatchlist(input *UpdateWatchlistInput) (*UpdateWatchlistOutput, error) {
	req, out := c.UpdateWatchlistRequest(input)
	return out, req.Send()
}

// UpdateWatchlistWithContext is the same as UpdateWatchlist with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWatchlist for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VoiceID) UpdateWatchlistWithContext(ctx aws.Context, input *UpdateWatchlistInput, opts ...request.Option) (*UpdateWatchlistOutput, error) {
	req, out := c.UpdateWatchlistRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient permissions to perform this action. Check the
// error message and try again.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AssociateFraudsterInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain that contains the fraudster.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The identifier of the fraudster to be associated with the watchlist.
	//
	// FraudsterId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssociateFraudsterInput's
	// String and GoString methods.
	//
	// FraudsterId is a required field
	FraudsterId *string `min:"25" type:"string" required:"true" sensitive:"true"`

	// The identifier of the watchlist you want to associate with the fraudster.
	//
	// WatchlistId is a required field
	WatchlistId *string `min:"22" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateFraudsterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateFraudsterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateFraudsterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateFraudsterInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.FraudsterId == nil {
		invalidParams.Add(request.NewErrParamRequired("FraudsterId"))
	}
	if s.FraudsterId != nil && len(*s.FraudsterId) < 25 {
		invalidParams.Add(request.NewErrParamMinLen("FraudsterId", 25))
	}
	if s.WatchlistId == nil {
		invalidParams.Add(request.NewErrParamRequired("WatchlistId"))
	}
	if s.WatchlistId != nil && len(*s.WatchlistId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("WatchlistId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *AssociateFraudsterInput) SetDomainId(v string) *AssociateFraudsterInput {
	s.DomainId = &v
	return s
}

// SetFraudsterId sets the FraudsterId field's value.
func (s *AssociateFraudsterInput) SetFraudsterId(v string) *AssociateFraudsterInput {
	s.FraudsterId = &v
	return s
}

// SetWatchlistId sets the WatchlistId field's value.
func (s *AssociateFraudsterInput) SetWatchlistId(v string) *AssociateFraudsterInput {
	s.WatchlistId = &v
	return s
}

type AssociateFraudsterOutput struct {
	_ struct{} `type:"structure"`

	// Contains all the information about a fraudster.
	Fraudster *Fraudster `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateFraudsterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateFraudsterOutput) GoString() string {
	return s.String()
}

// SetFraudster sets the Fraudster field's value.
func (s *AssociateFraudsterOutput) SetFraudster(v *Fraudster) *AssociateFraudsterOutput {
	s.Fraudster = v
	return s
}

// The configuration used to authenticate a speaker during a session.
type AuthenticationConfiguration struct {
	_ struct{} `type:"structure"`

	// The minimum threshold needed to successfully authenticate a speaker.
	//
	// AcceptanceThreshold is a required field
	AcceptanceThreshold *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationConfiguration) GoString() string {
	return s.String()
}

// SetAcceptanceThreshold sets the AcceptanceThreshold field's value.
func (s *AuthenticationConfiguration) SetAcceptanceThreshold(v int64) *AuthenticationConfiguration {
	s.AcceptanceThreshold = &v
	return s
}

// The authentication result produced by Voice ID, processed against the current
// session state and streamed audio of the speaker.
type AuthenticationResult struct {
	_ struct{} `type:"structure"`

	// A timestamp of when audio aggregation ended for this authentication result.
	AudioAggregationEndedAt *time.Time `type:"timestamp"`

	// A timestamp of when audio aggregation started for this authentication result.
	AudioAggregationStartedAt *time.Time `type:"timestamp"`

	// The unique identifier for this authentication result. Because there can be
	// multiple authentications for a given session, this field helps to identify
	// if the returned result is from a previous streaming activity or a new result.
	// Note that in absence of any new streaming activity, AcceptanceThreshold changes,
	// or SpeakerId changes, Voice ID always returns cached Authentication Result
	// for this API.
	AuthenticationResultId *string `min:"22" type:"string"`

	// The AuthenticationConfiguration used to generate this authentication result.
	Configuration *AuthenticationConfiguration `type:"structure"`

	// The client-provided identifier for the speaker whose authentication result
	// is produced. Only present if a SpeakerId is provided for the session.
	//
	// CustomerSpeakerId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AuthenticationResult's
	// String and GoString methods.
	CustomerSpeakerId *string `min:"1" type:"string" sensitive:"true"`

	// The authentication decision produced by Voice ID, processed against the current
	// session state and streamed audio of the speaker.
	Decision *string `type:"string" enum:"AuthenticationDecision"`

	// The service-generated identifier for the speaker whose authentication result
	// is produced.
	GeneratedSpeakerId *string `min:"25" type:"string"`

	// The authentication score for the speaker whose authentication result is produced.
	// This value is only present if the authentication decision is either ACCEPT
	// or REJECT.
	Score *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationResult) GoString() string {
	return s.String()
}

// SetAudioAggregationEndedAt sets the AudioAggregationEndedAt field's value.
func (s *AuthenticationResult) SetAudioAggregationEndedAt(v time.Time) *AuthenticationResult {
	s.AudioAggregationEndedAt = &v
	return s
}

// SetAudioAggregationStartedAt sets the AudioAggregationStartedAt field's value.
func (s *AuthenticationResult) SetAudioAggregationStartedAt(v time.Time) *AuthenticationResult {
	s.AudioAggregationStartedAt = &v
	return s
}

// SetAuthenticationResultId sets the AuthenticationResultId field's value.
func (s *AuthenticationResult) SetAuthenticationResultId(v string) *AuthenticationResult {
	s.AuthenticationResultId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *AuthenticationResult) SetConfiguration(v *AuthenticationConfiguration) *AuthenticationResult {
	s.Configuration = v
	return s
}

// SetCustomerSpeakerId sets the CustomerSpeakerId field's value.
func (s *AuthenticationResult) SetCustomerSpeakerId(v string) *AuthenticationResult {
	s.CustomerSpeakerId = &v
	return s
}

// SetDecision sets the Decision field's value.
func (s *AuthenticationResult) SetDecision(v string) *AuthenticationResult {
	s.Decision = &v
	return s
}

// SetGeneratedSpeakerId sets the GeneratedSpeakerId field's value.
func (s *AuthenticationResult) SetGeneratedSpeakerId(v string) *AuthenticationResult {
	s.GeneratedSpeakerId = &v
	return s
}

// SetScore sets the Score field's value.
func (s *AuthenticationResult) SetScore(v int64) *AuthenticationResult {
	s.Score = &v
	return s
}

// The request failed due to a conflict. Check the ConflictType and error message
// for more details.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The type of conflict which caused a ConflictException. Possible types and
	// the corresponding error messages are as follows:
	//
	//    * DOMAIN_NOT_ACTIVE: The domain is not active.
	//
	//    * CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT: You cannot change the speaker
	//    ID after an enrollment has been requested.
	//
	//    * ENROLLMENT_ALREADY_EXISTS: There is already an enrollment for this session.
	//
	//    * SPEAKER_NOT_SET: You must set the speaker ID before requesting an enrollment.
	//
	//    * SPEAKER_OPTED_OUT: You cannot request an enrollment for an opted out
	//    speaker.
	//
	//    * CONCURRENT_CHANGES: The request could not be processed as the resource
	//    was modified by another request during execution.
	ConflictType *string `type:"string" enum:"ConflictType"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A brief description of this domain.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateDomainInput's
	// String and GoString methods.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The name of the domain.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateDomainInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The configuration, containing the KMS key identifier, to be used by Voice
	// ID for the server-side encryption of your data. Refer to Amazon Connect Voice
	// ID encryption at rest (https://docs.aws.amazon.com/connect/latest/adminguide/encryption-at-rest.html#encryption-at-rest-voiceid)
	// for more details on how the KMS key is used.
	//
	// ServerSideEncryptionConfiguration is a required field
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `type:"structure" required:"true"`

	// A list of tags you want added to the domain.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ServerSideEncryptionConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerSideEncryptionConfiguration"))
	}
	if s.ServerSideEncryptionConfiguration != nil {
		if err := s.ServerSideEncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServerSideEncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDomainInput) SetClientToken(v string) *CreateDomainInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDomainInput) SetDescription(v string) *CreateDomainInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDomainInput) SetName(v string) *CreateDomainInput {
	s.Name = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *CreateDomainInput) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *CreateDomainInput {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDomainInput) SetTags(v []*Tag) *CreateDomainInput {
	s.Tags = v
	return s
}

type CreateDomainOutput struct {
	_ struct{} `type:"structure"`

	// Information about the newly created domain.
	Domain *Domain `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainOutput) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *CreateDomainOutput) SetDomain(v *Domain) *CreateDomainOutput {
	s.Domain = v
	return s
}

type CreateWatchlistInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A brief description of this watchlist.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateWatchlistInput's
	// String and GoString methods.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The identifier of the domain that contains the watchlist.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The name of the watchlist.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateWatchlistInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWatchlistInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWatchlistInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWatchlistInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWatchlistInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateWatchlistInput) SetClientToken(v string) *CreateWatchlistInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateWatchlistInput) SetDescription(v string) *CreateWatchlistInput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateWatchlistInput) SetDomainId(v string) *CreateWatchlistInput {
	s.DomainId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWatchlistInput) SetName(v string) *CreateWatchlistInput {
	s.Name = &v
	return s
}

type CreateWatchlistOutput struct {
	_ struct{} `type:"structure"`

	// Information about the newly created watchlist.
	Watchlist *Watchlist `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWatchlistOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWatchlistOutput) GoString() string {
	return s.String()
}

// SetWatchlist sets the Watchlist field's value.
func (s *CreateWatchlistOutput) SetWatchlist(v *Watchlist) *CreateWatchlistOutput {
	s.Watchlist = v
	return s
}

type DeleteDomainInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain you want to delete.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *DeleteDomainInput) SetDomainId(v string) *DeleteDomainInput {
	s.DomainId = &v
	return s
}

type DeleteDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainOutput) GoString() string {
	return s.String()
}

type DeleteFraudsterInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain that contains the fraudster.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The identifier of the fraudster you want to delete.
	//
	// FraudsterId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DeleteFraudsterInput's
	// String and GoString methods.
	//
	// FraudsterId is a required field
	FraudsterId *string `min:"25" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFraudsterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFraudsterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFraudsterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFraudsterInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.FraudsterId == nil {
		invalidParams.Add(request.NewErrParamRequired("FraudsterId"))
	}
	if s.FraudsterId != nil && len(*s.FraudsterId) < 25 {
		invalidParams.Add(request.NewErrParamMinLen("FraudsterId", 25))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *DeleteFraudsterInput) SetDomainId(v string) *DeleteFraudsterInput {
	s.DomainId = &v
	return s
}

// SetFraudsterId sets the FraudsterId field's value.
func (s *DeleteFraudsterInput) SetFraudsterId(v string) *DeleteFraudsterInput {
	s.FraudsterId = &v
	return s
}

type DeleteFraudsterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFraudsterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFraudsterOutput) GoString() string {
	return s.String()
}

type DeleteSpeakerInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain that contains the speaker.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The identifier of the speaker you want to delete.
	//
	// SpeakerId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DeleteSpeakerInput's
	// String and GoString methods.
	//
	// SpeakerId is a required field
	SpeakerId *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSpeakerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSpeakerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSpeakerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSpeakerInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.SpeakerId == nil {
		invalidParams.Add(request.NewErrParamRequired("SpeakerId"))
	}
	if s.SpeakerId != nil && len(*s.SpeakerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SpeakerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *DeleteSpeakerInput) SetDomainId(v string) *DeleteSpeakerInput {
	s.DomainId = &v
	return s
}

// SetSpeakerId sets the SpeakerId field's value.
func (s *DeleteSpeakerInput) SetSpeakerId(v string) *DeleteSpeakerInput {
	s.SpeakerId = &v
	return s
}

type DeleteSpeakerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSpeakerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSpeakerOutput) GoString() string {
	return s.String()
}

type DeleteWatchlistInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain that contains the watchlist.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The identifier of the watchlist to be deleted.
	//
	// WatchlistId is a required field
	WatchlistId *string `min:"22" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWatchlistInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWatchlistInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWatchlistInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWatchlistInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.WatchlistId == nil {
		invalidParams.Add(request.NewErrParamRequired("WatchlistId"))
	}
	if s.WatchlistId != nil && len(*s.WatchlistId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("WatchlistId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *DeleteWatchlistInput) SetDomainId(v string) *DeleteWatchlistInput {
	s.DomainId = &v
	return s
}

// SetWatchlistId sets the WatchlistId field's value.
func (s *DeleteWatchlistInput) SetWatchlistId(v string) *DeleteWatchlistInput {
	s.WatchlistId = &v
	return s
}

type DeleteWatchlistOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWatchlistOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWatchlistOutput) GoString() string {
	return s.String()
}

type DescribeDomainInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain that you are describing.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *DescribeDomainInput) SetDomainId(v string) *DescribeDomainInput {
	s.DomainId = &v
	return s
}

type DescribeDomainOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified domain.
	Domain *Domain `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDomainOutput) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *DescribeDomainOutput) SetDomain(v *Domain) *DescribeDomainOutput {
	s.Domain = v
	return s
}

type DescribeFraudsterInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain that contains the fraudster.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The identifier of the fraudster you are describing.
	//
	// FraudsterId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeFraudsterInput's
	// String and GoString methods.
	//
	// FraudsterId is a required field
	FraudsterId *string `min:"25" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFraudsterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFraudsterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFraudsterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFraudsterInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.FraudsterId == nil {
		invalidParams.Add(request.NewErrParamRequired("FraudsterId"))
	}
	if s.FraudsterId != nil && len(*s.FraudsterId) < 25 {
		invalidParams.Add(request.NewErrParamMinLen("FraudsterId", 25))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *DescribeFraudsterInput) SetDomainId(v string) *DescribeFraudsterInput {
	s.DomainId = &v
	return s
}

// SetFraudsterId sets the FraudsterId field's value.
func (s *DescribeFraudsterInput) SetFraudsterId(v string) *DescribeFraudsterInput {
	s.FraudsterId = &v
	return s
}

type DescribeFraudsterOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified fraudster.
	Fraudster *Fraudster `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFraudsterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFraudsterOutput) GoString() string {
	return s.String()
}

// SetFraudster sets the Fraudster field's value.
func (s *DescribeFraudsterOutput) SetFraudster(v *Fraudster) *DescribeFraudsterOutput {
	s.Fraudster = v
	return s
}

type DescribeFraudsterRegistrationJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain that contains the fraudster registration job.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The identifier of the fraudster registration job you are describing.
	//
	// JobId is a required field
	JobId *string `min:"22" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFraudsterRegistrationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFraudsterRegistrationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFraudsterRegistrationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFraudsterRegistrationJobInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *DescribeFraudsterRegistrationJobInput) SetDomainId(v string) *DescribeFraudsterRegistrationJobInput {
	s.DomainId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribeFraudsterRegistrationJobInput) SetJobId(v string) *DescribeFraudsterRegistrationJobInput {
	s.JobId = &v
	return s
}

type DescribeFraudsterRegistrationJobOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the specified fraudster registration job.
	Job *FraudsterRegistrationJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFraudsterRegistrationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFraudsterRegistrationJobOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *DescribeFraudsterRegistrationJobOutput) SetJob(v *FraudsterRegistrationJob) *DescribeFraudsterRegistrationJobOutput {
	s.Job = v
	return s
}

type DescribeSpeakerEnrollmentJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain that contains the speaker enrollment job.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The identifier of the speaker enrollment job you are describing.
	//
	// JobId is a required field
	JobId *string `min:"22" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSpeakerEnrollmentJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSpeakerEnrollmentJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSpeakerEnrollmentJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSpeakerEnrollmentJobInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *DescribeSpeakerEnrollmentJobInput) SetDomainId(v string) *DescribeSpeakerEnrollmentJobInput {
	s.DomainId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribeSpeakerEnrollmentJobInput) SetJobId(v string) *DescribeSpeakerEnrollmentJobInput {
	s.JobId = &v
	return s
}

type DescribeSpeakerEnrollmentJobOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the specified speaker enrollment job.
	Job *SpeakerEnrollmentJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSpeakerEnrollmentJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSpeakerEnrollmentJobOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *DescribeSpeakerEnrollmentJobOutput) SetJob(v *SpeakerEnrollmentJob) *DescribeSpeakerEnrollmentJobOutput {
	s.Job = v
	return s
}

type DescribeSpeakerInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain that contains the speaker.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The identifier of the speaker you are describing.
	//
	// SpeakerId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribeSpeakerInput's
	// String and GoString methods.
	//
	// SpeakerId is a required field
	SpeakerId *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSpeakerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSpeakerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSpeakerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSpeakerInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.SpeakerId == nil {
		invalidParams.Add(request.NewErrParamRequired("SpeakerId"))
	}
	if s.SpeakerId != nil && len(*s.SpeakerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SpeakerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *DescribeSpeakerInput) SetDomainId(v string) *DescribeSpeakerInput {
	s.DomainId = &v
	return s
}

// SetSpeakerId sets the SpeakerId field's value.
func (s *DescribeSpeakerInput) SetSpeakerId(v string) *DescribeSpeakerInput {
	s.SpeakerId = &v
	return s
}

type DescribeSpeakerOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified speaker.
	Speaker *Speaker `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSpeakerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSpeakerOutput) GoString() string {
	return s.String()
}

// SetSpeaker sets the Speaker field's value.
func (s *DescribeSpeakerOutput) SetSpeaker(v *Speaker) *DescribeSpeakerOutput {
	s.Speaker = v
	return s
}

type DescribeWatchlistInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain that contains the watchlist.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The identifier of the watchlist that you are describing.
	//
	// WatchlistId is a required field
	WatchlistId *string `min:"22" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWatchlistInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWatchlistInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWatchlistInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWatchlistInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.WatchlistId == nil {
		invalidParams.Add(request.NewErrParamRequired("WatchlistId"))
	}
	if s.WatchlistId != nil && len(*s.WatchlistId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("WatchlistId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *DescribeWatchlistInput) SetDomainId(v string) *DescribeWatchlistInput {
	s.DomainId = &v
	return s
}

// SetWatchlistId sets the WatchlistId field's value.
func (s *DescribeWatchlistInput) SetWatchlistId(v string) *DescribeWatchlistInput {
	s.WatchlistId = &v
	return s
}

type DescribeWatchlistOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified watchlist.
	Watchlist *Watchlist `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWatchlistOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWatchlistOutput) GoString() string {
	return s.String()
}

// SetWatchlist sets the Watchlist field's value.
func (s *DescribeWatchlistOutput) SetWatchlist(v *Watchlist) *DescribeWatchlistOutput {
	s.Watchlist = v
	return s
}

type DisassociateFraudsterInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain that contains the fraudster.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The identifier of the fraudster to be disassociated from the watchlist.
	//
	// FraudsterId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DisassociateFraudsterInput's
	// String and GoString methods.
	//
	// FraudsterId is a required field
	FraudsterId *string `min:"25" type:"string" required:"true" sensitive:"true"`

	// The identifier of the watchlist that you want to disassociate from the fraudster.
	//
	// WatchlistId is a required field
	WatchlistId *string `min:"22" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateFraudsterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateFraudsterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateFraudsterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateFraudsterInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.FraudsterId == nil {
		invalidParams.Add(request.NewErrParamRequired("FraudsterId"))
	}
	if s.FraudsterId != nil && len(*s.FraudsterId) < 25 {
		invalidParams.Add(request.NewErrParamMinLen("FraudsterId", 25))
	}
	if s.WatchlistId == nil {
		invalidParams.Add(request.NewErrParamRequired("WatchlistId"))
	}
	if s.WatchlistId != nil && len(*s.WatchlistId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("WatchlistId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *DisassociateFraudsterInput) SetDomainId(v string) *DisassociateFraudsterInput {
	s.DomainId = &v
	return s
}

// SetFraudsterId sets the FraudsterId field's value.
func (s *DisassociateFraudsterInput) SetFraudsterId(v string) *DisassociateFraudsterInput {
	s.FraudsterId = &v
	return s
}

// SetWatchlistId sets the WatchlistId field's value.
func (s *DisassociateFraudsterInput) SetWatchlistId(v string) *DisassociateFraudsterInput {
	s.WatchlistId = &v
	return s
}

type DisassociateFraudsterOutput struct {
	_ struct{} `type:"structure"`

	// Contains all the information about a fraudster.
	Fraudster *Fraudster `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateFraudsterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateFraudsterOutput) GoString() string {
	return s.String()
}

// SetFraudster sets the Fraudster field's value.
func (s *DisassociateFraudsterOutput) SetFraudster(v *Fraudster) *DisassociateFraudsterOutput {
	s.Fraudster = v
	return s
}

// Contains all the information about a domain.
type Domain struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the domain.
	Arn *string `type:"string"`

	// The timestamp of when the domain was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the domain.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Domain's
	// String and GoString methods.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The identifier of the domain.
	DomainId *string `min:"22" type:"string"`

	// The current status of the domain.
	DomainStatus *string `type:"string" enum:"DomainStatus"`

	// The name for the domain.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Domain's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The server-side encryption configuration containing the KMS key identifier
	// you want Voice ID to use to encrypt your data.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `type:"structure"`

	// Details about the most recent server-side encryption configuration update.
	// When the server-side encryption configuration is changed, dependency on the
	// old KMS key is removed through an asynchronous process. When this update
	// is complete, the domain's data can only be accessed using the new KMS key.
	ServerSideEncryptionUpdateDetails *ServerSideEncryptionUpdateDetails `type:"structure"`

	// The timestamp of when the domain was last update.
	UpdatedAt *time.Time `type:"timestamp"`

	// The watchlist details of a domain. Contains the default watchlist ID of the
	// domain.
	WatchlistDetails *WatchlistDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Domain) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Domain) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Domain) SetArn(v string) *Domain {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Domain) SetCreatedAt(v time.Time) *Domain {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Domain) SetDescription(v string) *Domain {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *Domain) SetDomainId(v string) *Domain {
	s.DomainId = &v
	return s
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *Domain) SetDomainStatus(v string) *Domain {
	s.DomainStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *Domain) SetName(v string) *Domain {
	s.Name = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *Domain) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *Domain {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetServerSideEncryptionUpdateDetails sets the ServerSideEncryptionUpdateDetails field's value.
func (s *Domain) SetServerSideEncryptionUpdateDetails(v *ServerSideEncryptionUpdateDetails) *Domain {
	s.ServerSideEncryptionUpdateDetails = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Domain) SetUpdatedAt(v time.Time) *Domain {
	s.UpdatedAt = &v
	return s
}

// SetWatchlistDetails sets the WatchlistDetails field's value.
func (s *Domain) SetWatchlistDetails(v *WatchlistDetails) *Domain {
	s.WatchlistDetails = v
	return s
}

// Contains a summary of information about a domain.
type DomainSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the domain.
	Arn *string `type:"string"`

	// The timestamp of when the domain was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the domain.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DomainSummary's
	// String and GoString methods.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The identifier of the domain.
	DomainId *string `min:"22" type:"string"`

	// The current status of the domain.
	DomainStatus *string `type:"string" enum:"DomainStatus"`

	// The client-provided name for the domain.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DomainSummary's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The server-side encryption configuration containing the KMS key identifier
	// you want Voice ID to use to encrypt your data.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `type:"structure"`

	// Details about the most recent server-side encryption configuration update.
	// When the server-side encryption configuration is changed, dependency on the
	// old KMS key is removed through an asynchronous process. When this update
	// is complete, the domain's data can only be accessed using the new KMS key.
	ServerSideEncryptionUpdateDetails *ServerSideEncryptionUpdateDetails `type:"structure"`

	// The timestamp of when the domain was last updated.
	UpdatedAt *time.Time `type:"timestamp"`

	// Provides information about watchlistDetails and DefaultWatchlistID.
	WatchlistDetails *WatchlistDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DomainSummary) SetArn(v string) *DomainSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DomainSummary) SetCreatedAt(v time.Time) *DomainSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DomainSummary) SetDescription(v string) *DomainSummary {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *DomainSummary) SetDomainId(v string) *DomainSummary {
	s.DomainId = &v
	return s
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *DomainSummary) SetDomainStatus(v string) *DomainSummary {
	s.DomainStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *DomainSummary) SetName(v string) *DomainSummary {
	s.Name = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *DomainSummary) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *DomainSummary {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetServerSideEncryptionUpdateDetails sets the ServerSideEncryptionUpdateDetails field's value.
func (s *DomainSummary) SetServerSideEncryptionUpdateDetails(v *ServerSideEncryptionUpdateDetails) *DomainSummary {
	s.ServerSideEncryptionUpdateDetails = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DomainSummary) SetUpdatedAt(v time.Time) *DomainSummary {
	s.UpdatedAt = &v
	return s
}

// SetWatchlistDetails sets the WatchlistDetails field's value.
func (s *DomainSummary) SetWatchlistDetails(v *WatchlistDetails) *DomainSummary {
	s.WatchlistDetails = v
	return s
}

// Contains configurations defining enrollment behavior for the batch job.
type EnrollmentConfig struct {
	_ struct{} `type:"structure"`

	// The action to take when the specified speaker is already enrolled in the
	// specified domain. The default value is SKIP, which skips the enrollment for
	// the existing speaker. Setting the value to OVERWRITE replaces the existing
	// voice prints and enrollment audio stored for that speaker with new data generated
	// from the latest audio.
	ExistingEnrollmentAction *string `type:"string" enum:"ExistingEnrollmentAction"`

	// The fraud detection configuration to use for the speaker enrollment job.
	FraudDetectionConfig *EnrollmentJobFraudDetectionConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnrollmentConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnrollmentConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnrollmentConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnrollmentConfig"}
	if s.FraudDetectionConfig != nil {
		if err := s.FraudDetectionConfig.Validate(); err != nil {
			invalidParams.AddNested("FraudDetectionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExistingEnrollmentAction sets the ExistingEnrollmentAction field's value.
func (s *EnrollmentConfig) SetExistingEnrollmentAction(v string) *EnrollmentConfig {
	s.ExistingEnrollmentAction = &v
	return s
}

// SetFraudDetectionConfig sets the FraudDetectionConfig field's value.
func (s *EnrollmentConfig) SetFraudDetectionConfig(v *EnrollmentJobFraudDetectionConfig) *EnrollmentConfig {
	s.FraudDetectionConfig = v
	return s
}

// The fraud detection configuration to be used during the batch speaker enrollment
// job.
type EnrollmentJobFraudDetectionConfig struct {
	_ struct{} `type:"structure"`

	// The action to take when the given speaker is flagged by the fraud detection
	// system. The default value is FAIL, which fails the speaker enrollment. Changing
	// this value to IGNORE results in the speaker being enrolled even if they are
	// flagged by the fraud detection system.
	FraudDetectionAction *string `type:"string" enum:"FraudDetectionAction"`

	// Threshold value for determining whether the speaker is a high risk to be
	// fraudulent. If the detected risk score calculated by Voice ID is greater
	// than or equal to the threshold, the speaker is considered a fraudster.
	RiskThreshold *int64 `type:"integer"`

	// The identifier of watchlists against which fraud detection is performed.
	WatchlistIds []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnrollmentJobFraudDetectionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnrollmentJobFraudDetectionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnrollmentJobFraudDetectionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnrollmentJobFraudDetectionConfig"}
	if s.WatchlistIds != nil && len(s.WatchlistIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WatchlistIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFraudDetectionAction sets the FraudDetectionAction field's value.
func (s *EnrollmentJobFraudDetectionConfig) SetFraudDetectionAction(v string) *EnrollmentJobFraudDetectionConfig {
	s.FraudDetectionAction = &v
	return s
}

// SetRiskThreshold sets the RiskThreshold field's value.
func (s *EnrollmentJobFraudDetectionConfig) SetRiskThreshold(v int64) *EnrollmentJobFraudDetectionConfig {
	s.RiskThreshold = &v
	return s
}

// SetWatchlistIds sets the WatchlistIds field's value.
func (s *EnrollmentJobFraudDetectionConfig) SetWatchlistIds(v []*string) *EnrollmentJobFraudDetectionConfig {
	s.WatchlistIds = v
	return s
}

type EvaluateSessionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain where the session started.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The session identifier, or name of the session, that you want to evaluate.
	// In Voice ID integration, this is the Contact-Id.
	//
	// SessionNameOrId is a required field
	SessionNameOrId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluateSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluateSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EvaluateSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EvaluateSessionInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.SessionNameOrId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionNameOrId"))
	}
	if s.SessionNameOrId != nil && len(*s.SessionNameOrId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionNameOrId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *EvaluateSessionInput) SetDomainId(v string) *EvaluateSessionInput {
	s.DomainId = &v
	return s
}

// SetSessionNameOrId sets the SessionNameOrId field's value.
func (s *EvaluateSessionInput) SetSessionNameOrId(v string) *EvaluateSessionInput {
	s.SessionNameOrId = &v
	return s
}

type EvaluateSessionOutput struct {
	_ struct{} `type:"structure"`

	// Details resulting from the authentication process, such as authentication
	// decision and authentication score.
	AuthenticationResult *AuthenticationResult `type:"structure"`

	// The identifier of the domain that contains the session.
	DomainId *string `min:"22" type:"string"`

	// Details resulting from the fraud detection process, such as fraud detection
	// decision and risk score.
	FraudDetectionResult *FraudDetectionResult `type:"structure"`

	// The service-generated identifier of the session.
	SessionId *string `min:"25" type:"string"`

	// The client-provided name of the session.
	SessionName *string `min:"1" type:"string"`

	// The current status of audio streaming for this session. This field is useful
	// to infer next steps when the Authentication or Fraud Detection results are
	// empty or the decision is NOT_ENOUGH_SPEECH. In this situation, if the StreamingStatus
	// is ONGOING/PENDING_CONFIGURATION, it can mean that the client should call
	// the API again later, after Voice ID has enough audio to produce a result.
	// If the decision remains NOT_ENOUGH_SPEECH even after StreamingStatus is ENDED,
	// it means that the previously streamed session did not have enough speech
	// to perform evaluation, and a new streaming session is needed to try again.
	StreamingStatus *string `type:"string" enum:"StreamingStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluateSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluateSessionOutput) GoString() string {
	return s.String()
}

// SetAuthenticationResult sets the AuthenticationResult field's value.
func (s *EvaluateSessionOutput) SetAuthenticationResult(v *AuthenticationResult) *EvaluateSessionOutput {
	s.AuthenticationResult = v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *EvaluateSessionOutput) SetDomainId(v string) *EvaluateSessionOutput {
	s.DomainId = &v
	return s
}

// SetFraudDetectionResult sets the FraudDetectionResult field's value.
func (s *EvaluateSessionOutput) SetFraudDetectionResult(v *FraudDetectionResult) *EvaluateSessionOutput {
	s.FraudDetectionResult = v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *EvaluateSessionOutput) SetSessionId(v string) *EvaluateSessionOutput {
	s.SessionId = &v
	return s
}

// SetSessionName sets the SessionName field's value.
func (s *EvaluateSessionOutput) SetSessionName(v string) *EvaluateSessionOutput {
	s.SessionName = &v
	return s
}

// SetStreamingStatus sets the StreamingStatus field's value.
func (s *EvaluateSessionOutput) SetStreamingStatus(v string) *EvaluateSessionOutput {
	s.StreamingStatus = &v
	return s
}

// Contains error details for a failed batch job.
type FailureDetails struct {
	_ struct{} `type:"structure"`

	// A description of the error that caused the batch job failure.
	Message *string `min:"1" type:"string"`

	// An HTTP status code representing the nature of the error.
	StatusCode *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailureDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailureDetails) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *FailureDetails) SetMessage(v string) *FailureDetails {
	s.Message = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *FailureDetails) SetStatusCode(v int64) *FailureDetails {
	s.StatusCode = &v
	return s
}

// The configuration used for performing fraud detection over a speaker during
// a session.
type FraudDetectionConfiguration struct {
	_ struct{} `type:"structure"`

	// Threshold value for determining whether the speaker is a fraudster. If the
	// detected risk score calculated by Voice ID is higher than the threshold,
	// the speaker is considered a fraudster.
	RiskThreshold *int64 `type:"integer"`

	// The identifier of the watchlist against which fraud detection is performed.
	WatchlistId *string `min:"22" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FraudDetectionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FraudDetectionConfiguration) GoString() string {
	return s.String()
}

// SetRiskThreshold sets the RiskThreshold field's value.
func (s *FraudDetectionConfiguration) SetRiskThreshold(v int64) *FraudDetectionConfiguration {
	s.RiskThreshold = &v
	return s
}

// SetWatchlistId sets the WatchlistId field's value.
func (s *FraudDetectionConfiguration) SetWatchlistId(v string) *FraudDetectionConfiguration {
	s.WatchlistId = &v
	return s
}

// The fraud detection result produced by Voice ID, processed against the current
// session state and streamed audio of the speaker.
type FraudDetectionResult struct {
	_ struct{} `type:"structure"`

	// A timestamp of when audio aggregation ended for this fraud detection result.
	AudioAggregationEndedAt *time.Time `type:"timestamp"`

	// A timestamp of when audio aggregation started for this fraud detection result.
	AudioAggregationStartedAt *time.Time `type:"timestamp"`

	// The FraudDetectionConfiguration used to generate this fraud detection result.
	Configuration *FraudDetectionConfiguration `type:"structure"`

	// The fraud detection decision produced by Voice ID, processed against the
	// current session state and streamed audio of the speaker.
	Decision *string `type:"string" enum:"FraudDetectionDecision"`

	// The unique identifier for this fraud detection result. Given there can be
	// multiple fraud detections for a given session, this field helps in identifying
	// if the returned result is from previous streaming activity or a new result.
	// Note that in the absence of any new streaming activity or risk threshold
	// changes, Voice ID always returns cached Fraud Detection result for this API.
	FraudDetectionResultId *string `min:"22" type:"string"`

	// The reason speaker was flagged by the fraud detection system. This is only
	// be populated if fraud detection Decision is HIGH_RISK, and the following
	// possible values: KNOWN_FRAUDSTER and VOICE_SPOOFING.
	Reasons []*string `type:"list" enum:"FraudDetectionReason"`

	// Details about each risk analyzed for this speaker. Currently, this contains
	// KnownFraudsterRisk and VoiceSpoofingRisk details.
	RiskDetails *FraudRiskDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FraudDetectionResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FraudDetectionResult) GoString() string {
	return s.String()
}

// SetAudioAggregationEndedAt sets the AudioAggregationEndedAt field's value.
func (s *FraudDetectionResult) SetAudioAggregationEndedAt(v time.Time) *FraudDetectionResult {
	s.AudioAggregationEndedAt = &v
	return s
}

// SetAudioAggregationStartedAt sets the AudioAggregationStartedAt field's value.
func (s *FraudDetectionResult) SetAudioAggregationStartedAt(v time.Time) *FraudDetectionResult {
	s.AudioAggregationStartedAt = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *FraudDetectionResult) SetConfiguration(v *FraudDetectionConfiguration) *FraudDetectionResult {
	s.Configuration = v
	return s
}

// SetDecision sets the Decision field's value.
func (s *FraudDetectionResult) SetDecision(v string) *FraudDetectionResult {
	s.Decision = &v
	return s
}

// SetFraudDetectionResultId sets the FraudDetectionResultId field's value.
func (s *FraudDetectionResult) SetFraudDetectionResultId(v string) *FraudDetectionResult {
	s.FraudDetectionResultId = &v
	return s
}

// SetReasons sets the Reasons field's value.
func (s *FraudDetectionResult) SetReasons(v []*string) *FraudDetectionResult {
	s.Reasons = v
	return s
}

// SetRiskDetails sets the RiskDetails field's value.
func (s *FraudDetectionResult) SetRiskDetails(v *FraudRiskDetails) *FraudDetectionResult {
	s.RiskDetails = v
	return s
}

// Details regarding various fraud risk analyses performed against the current
// session state and streamed audio of the speaker.
type FraudRiskDetails struct {
	_ struct{} `type:"structure"`

	// The details resulting from 'Known Fraudster Risk' analysis of the speaker.
	//
	// KnownFraudsterRisk is a required field
	KnownFraudsterRisk *KnownFraudsterRisk `type:"structure" required:"true"`

	// The details resulting from 'Voice Spoofing Risk' analysis of the speaker.
	//
	// VoiceSpoofingRisk is a required field
	VoiceSpoofingRisk *VoiceSpoofingRisk `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FraudRiskDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FraudRiskDetails) GoString() string {
	return s.String()
}

// SetKnownFraudsterRisk sets the KnownFraudsterRisk field's value.
func (s *FraudRiskDetails) SetKnownFraudsterRisk(v *KnownFraudsterRisk) *FraudRiskDetails {
	s.KnownFraudsterRisk = v
	return s
}

// SetVoiceSpoofingRisk sets the VoiceSpoofingRisk field's value.
func (s *FraudRiskDetails) SetVoiceSpoofingRisk(v *VoiceSpoofingRisk) *FraudRiskDetails {
	s.VoiceSpoofingRisk = v
	return s
}

// Contains all the information about a fraudster.
type Fraudster struct {
	_ struct{} `type:"structure"`

	// The timestamp of when Voice ID identified the fraudster.
	CreatedAt *time.Time `type:"timestamp"`

	// The identifier of the domain that contains the fraudster.
	DomainId *string `min:"22" type:"string"`

	// The service-generated identifier for the fraudster.
	GeneratedFraudsterId *string `min:"25" type:"string"`

	// The identifier of the watchlists the fraudster is a part of.
	WatchlistIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Fraudster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Fraudster) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Fraudster) SetCreatedAt(v time.Time) *Fraudster {
	s.CreatedAt = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *Fraudster) SetDomainId(v string) *Fraudster {
	s.DomainId = &v
	return s
}

// SetGeneratedFraudsterId sets the GeneratedFraudsterId field's value.
func (s *Fraudster) SetGeneratedFraudsterId(v string) *Fraudster {
	s.GeneratedFraudsterId = &v
	return s
}

// SetWatchlistIds sets the WatchlistIds field's value.
func (s *Fraudster) SetWatchlistIds(v []*string) *Fraudster {
	s.WatchlistIds = v
	return s
}

// Contains all the information about a fraudster registration job.
type FraudsterRegistrationJob struct {
	_ struct{} `type:"structure"`

	// A timestamp of when the fraudster registration job was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions
	// to access customer's buckets to read the input manifest file and write the
	// job output file.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The identifier of the domain that contains the fraudster registration job.
	DomainId *string `min:"22" type:"string"`

	// A timestamp of when the fraudster registration job ended.
	EndedAt *time.Time `type:"timestamp"`

	// Contains details that are populated when an entire batch job fails. In cases
	// of individual registration job failures, the batch job as a whole doesn't
	// fail; it is completed with a JobStatus of COMPLETED_WITH_ERRORS. You can
	// use the job output file to identify the individual registration requests
	// that failed.
	FailureDetails *FailureDetails `type:"structure"`

	// The input data config containing an S3 URI for the input manifest file that
	// contains the list of fraudster registration job requests.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The service-generated identifier for the fraudster registration job.
	JobId *string `min:"22" type:"string"`

	// The client-provided name for the fraudster registration job.
	//
	// JobName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FraudsterRegistrationJob's
	// String and GoString methods.
	JobName *string `min:"1" type:"string" sensitive:"true"`

	// Shows the completed percentage of registration requests listed in the input
	// file.
	JobProgress *JobProgress `type:"structure"`

	// The current status of the fraudster registration job.
	JobStatus *string `type:"string" enum:"FraudsterRegistrationJobStatus"`

	// The output data config containing the S3 location where you want Voice ID
	// to write your job output file; you must also include a KMS key ID in order
	// to encrypt the file.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The registration config containing details such as the action to take when
	// a duplicate fraudster is detected, and the similarity threshold to use for
	// detecting a duplicate fraudster.
	RegistrationConfig *RegistrationConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FraudsterRegistrationJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FraudsterRegistrationJob) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FraudsterRegistrationJob) SetCreatedAt(v time.Time) *FraudsterRegistrationJob {
	s.CreatedAt = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *FraudsterRegistrationJob) SetDataAccessRoleArn(v string) *FraudsterRegistrationJob {
	s.DataAccessRoleArn = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *FraudsterRegistrationJob) SetDomainId(v string) *FraudsterRegistrationJob {
	s.DomainId = &v
	return s
}

// SetEndedAt sets the EndedAt field's value.
func (s *FraudsterRegistrationJob) SetEndedAt(v time.Time) *FraudsterRegistrationJob {
	s.EndedAt = &v
	return s
}

// SetFailureDetails sets the FailureDetails field's value.
func (s *FraudsterRegistrationJob) SetFailureDetails(v *FailureDetails) *FraudsterRegistrationJob {
	s.FailureDetails = v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *FraudsterRegistrationJob) SetInputDataConfig(v *InputDataConfig) *FraudsterRegistrationJob {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *FraudsterRegistrationJob) SetJobId(v string) *FraudsterRegistrationJob {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *FraudsterRegistrationJob) SetJobName(v string) *FraudsterRegistrationJob {
	s.JobName = &v
	return s
}

// SetJobProgress sets the JobProgress field's value.
func (s *FraudsterRegistrationJob) SetJobProgress(v *JobProgress) *FraudsterRegistrationJob {
	s.JobProgress = v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *FraudsterRegistrationJob) SetJobStatus(v string) *FraudsterRegistrationJob {
	s.JobStatus = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *FraudsterRegistrationJob) SetOutputDataConfig(v *OutputDataConfig) *FraudsterRegistrationJob {
	s.OutputDataConfig = v
	return s
}

// SetRegistrationConfig sets the RegistrationConfig field's value.
func (s *FraudsterRegistrationJob) SetRegistrationConfig(v *RegistrationConfig) *FraudsterRegistrationJob {
	s.RegistrationConfig = v
	return s
}

// Contains a summary of information about a fraudster registration job.
type FraudsterRegistrationJobSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp of when the fraudster registration job was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The identifier of the domain that contains the fraudster registration job.
	DomainId *string `min:"22" type:"string"`

	// A timestamp of when the fraudster registration job ended.
	EndedAt *time.Time `type:"timestamp"`

	// Contains details that are populated when an entire batch job fails. In cases
	// of individual registration job failures, the batch job as a whole doesn't
	// fail; it is completed with a JobStatus of COMPLETED_WITH_ERRORS. You can
	// use the job output file to identify the individual registration requests
	// that failed.
	FailureDetails *FailureDetails `type:"structure"`

	// The service-generated identifier for the fraudster registration job.
	JobId *string `min:"22" type:"string"`

	// The client-provided name for the fraudster registration job.
	//
	// JobName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FraudsterRegistrationJobSummary's
	// String and GoString methods.
	JobName *string `min:"1" type:"string" sensitive:"true"`

	// Shows the completed percentage of registration requests listed in the input
	// file.
	JobProgress *JobProgress `type:"structure"`

	// The current status of the fraudster registration job.
	JobStatus *string `type:"string" enum:"FraudsterRegistrationJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FraudsterRegistrationJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FraudsterRegistrationJobSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FraudsterRegistrationJobSummary) SetCreatedAt(v time.Time) *FraudsterRegistrationJobSummary {
	s.CreatedAt = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *FraudsterRegistrationJobSummary) SetDomainId(v string) *FraudsterRegistrationJobSummary {
	s.DomainId = &v
	return s
}

// SetEndedAt sets the EndedAt field's value.
func (s *FraudsterRegistrationJobSummary) SetEndedAt(v time.Time) *FraudsterRegistrationJobSummary {
	s.EndedAt = &v
	return s
}

// SetFailureDetails sets the FailureDetails field's value.
func (s *FraudsterRegistrationJobSummary) SetFailureDetails(v *FailureDetails) *FraudsterRegistrationJobSummary {
	s.FailureDetails = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *FraudsterRegistrationJobSummary) SetJobId(v string) *FraudsterRegistrationJobSummary {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *FraudsterRegistrationJobSummary) SetJobName(v string) *FraudsterRegistrationJobSummary {
	s.JobName = &v
	return s
}

// SetJobProgress sets the JobProgress field's value.
func (s *FraudsterRegistrationJobSummary) SetJobProgress(v *JobProgress) *FraudsterRegistrationJobSummary {
	s.JobProgress = v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *FraudsterRegistrationJobSummary) SetJobStatus(v string) *FraudsterRegistrationJobSummary {
	s.JobStatus = &v
	return s
}

// Contains a summary of information about a fraudster.
type FraudsterSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the fraudster summary was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The identifier of the domain that contains the fraudster summary.
	DomainId *string `min:"22" type:"string"`

	// The service-generated identifier for the fraudster.
	GeneratedFraudsterId *string `min:"25" type:"string"`

	// The identifier of the watchlists the fraudster is a part of.
	WatchlistIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FraudsterSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FraudsterSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FraudsterSummary) SetCreatedAt(v time.Time) *FraudsterSummary {
	s.CreatedAt = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *FraudsterSummary) SetDomainId(v string) *FraudsterSummary {
	s.DomainId = &v
	return s
}

// SetGeneratedFraudsterId sets the GeneratedFraudsterId field's value.
func (s *FraudsterSummary) SetGeneratedFraudsterId(v string) *FraudsterSummary {
	s.GeneratedFraudsterId = &v
	return s
}

// SetWatchlistIds sets the WatchlistIds field's value.
func (s *FraudsterSummary) SetWatchlistIds(v []*string) *FraudsterSummary {
	s.WatchlistIds = v
	return s
}

// The configuration containing input file information for a batch job.
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// The S3 location for the input manifest file that contains the list of individual
	// enrollment or registration job requests.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputDataConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *InputDataConfig) SetS3Uri(v string) *InputDataConfig {
	s.S3Uri = &v
	return s
}

// The request failed due to an unknown error on the server side.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Indicates the completion progress for a batch job.
type JobProgress struct {
	_ struct{} `type:"structure"`

	// Shows the completed percentage of enrollment or registration requests listed
	// in the input file.
	PercentComplete *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobProgress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobProgress) GoString() string {
	return s.String()
}

// SetPercentComplete sets the PercentComplete field's value.
func (s *JobProgress) SetPercentComplete(v int64) *JobProgress {
	s.PercentComplete = &v
	return s
}

// Contains details produced as a result of performing known fraudster risk
// analysis on a speaker.
type KnownFraudsterRisk struct {
	_ struct{} `type:"structure"`

	// The identifier of the fraudster that is the closest match to the speaker.
	// If there are no fraudsters registered in a given domain, or if there are
	// no fraudsters with a non-zero RiskScore, this value is null.
	GeneratedFraudsterId *string `min:"25" type:"string"`

	// The score indicating the likelihood the speaker is a known fraudster.
	//
	// RiskScore is a required field
	RiskScore *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnownFraudsterRisk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnownFraudsterRisk) GoString() string {
	return s.String()
}

// SetGeneratedFraudsterId sets the GeneratedFraudsterId field's value.
func (s *KnownFraudsterRisk) SetGeneratedFraudsterId(v string) *KnownFraudsterRisk {
	s.GeneratedFraudsterId = &v
	return s
}

// SetRiskScore sets the RiskScore field's value.
func (s *KnownFraudsterRisk) SetRiskScore(v int64) *KnownFraudsterRisk {
	s.RiskScore = &v
	return s
}

type ListDomainsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that are returned per call. You can use NextToken
	// to obtain more pages of results. The default is 100; the maximum allowed
	// page size is also 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDomainsInput) SetMaxResults(v int64) *ListDomainsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsInput) SetNextToken(v string) *ListDomainsInput {
	s.NextToken = &v
	return s
}

type ListDomainsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing details about each domain in the Amazon Web Services account.
	DomainSummaries []*DomainSummary `type:"list"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsOutput) GoString() string {
	return s.String()
}

// SetDomainSummaries sets the DomainSummaries field's value.
func (s *ListDomainsOutput) SetDomainSummaries(v []*DomainSummary) *ListDomainsOutput {
	s.DomainSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsOutput) SetNextToken(v string) *ListDomainsOutput {
	s.NextToken = &v
	return s
}

type ListFraudsterRegistrationJobsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain that contains the fraudster registration Jobs.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// Provides the status of your fraudster registration job.
	JobStatus *string `type:"string" enum:"FraudsterRegistrationJobStatus"`

	// The maximum number of results that are returned per call. You can use NextToken
	// to obtain more pages of results. The default is 100; the maximum allowed
	// page size is also 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFraudsterRegistrationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFraudsterRegistrationJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFraudsterRegistrationJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFraudsterRegistrationJobsInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *ListFraudsterRegistrationJobsInput) SetDomainId(v string) *ListFraudsterRegistrationJobsInput {
	s.DomainId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ListFraudsterRegistrationJobsInput) SetJobStatus(v string) *ListFraudsterRegistrationJobsInput {
	s.JobStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFraudsterRegistrationJobsInput) SetMaxResults(v int64) *ListFraudsterRegistrationJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFraudsterRegistrationJobsInput) SetNextToken(v string) *ListFraudsterRegistrationJobsInput {
	s.NextToken = &v
	return s
}

type ListFraudsterRegistrationJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing details about each specified fraudster registration job.
	JobSummaries []*FraudsterRegistrationJobSummary `type:"list"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFraudsterRegistrationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFraudsterRegistrationJobsOutput) GoString() string {
	return s.String()
}

// SetJobSummaries sets the JobSummaries field's value.
func (s *ListFraudsterRegistrationJobsOutput) SetJobSummaries(v []*FraudsterRegistrationJobSummary) *ListFraudsterRegistrationJobsOutput {
	s.JobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFraudsterRegistrationJobsOutput) SetNextToken(v string) *ListFraudsterRegistrationJobsOutput {
	s.NextToken = &v
	return s
}

type ListFraudstersInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The maximum number of results that are returned per call. You can use NextToken
	// to obtain more pages of results. The default is 100; the maximum allowed
	// page size is also 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours.
	NextToken *string `type:"string"`

	// The identifier of the watchlist. If provided, all fraudsters in the watchlist
	// are listed. If not provided, all fraudsters in the domain are listed.
	WatchlistId *string `min:"22" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFraudstersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFraudstersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFraudstersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFraudstersInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.WatchlistId != nil && len(*s.WatchlistId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("WatchlistId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *ListFraudstersInput) SetDomainId(v string) *ListFraudstersInput {
	s.DomainId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFraudstersInput) SetMaxResults(v int64) *ListFraudstersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFraudstersInput) SetNextToken(v string) *ListFraudstersInput {
	s.NextToken = &v
	return s
}

// SetWatchlistId sets the WatchlistId field's value.
func (s *ListFraudstersInput) SetWatchlistId(v string) *ListFraudstersInput {
	s.WatchlistId = &v
	return s
}

type ListFraudstersOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains details about each fraudster in the Amazon Web Services
	// account.
	FraudsterSummaries []*FraudsterSummary `type:"list"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFraudstersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFraudstersOutput) GoString() string {
	return s.String()
}

// SetFraudsterSummaries sets the FraudsterSummaries field's value.
func (s *ListFraudstersOutput) SetFraudsterSummaries(v []*FraudsterSummary) *ListFraudstersOutput {
	s.FraudsterSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFraudstersOutput) SetNextToken(v string) *ListFraudstersOutput {
	s.NextToken = &v
	return s
}

type ListSpeakerEnrollmentJobsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain that contains the speaker enrollment jobs.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// Provides the status of your speaker enrollment Job.
	JobStatus *string `type:"string" enum:"SpeakerEnrollmentJobStatus"`

	// The maximum number of results that are returned per call. You can use NextToken
	// to obtain more pages of results. The default is 100; the maximum allowed
	// page size is also 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSpeakerEnrollmentJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSpeakerEnrollmentJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSpeakerEnrollmentJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSpeakerEnrollmentJobsInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *ListSpeakerEnrollmentJobsInput) SetDomainId(v string) *ListSpeakerEnrollmentJobsInput {
	s.DomainId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ListSpeakerEnrollmentJobsInput) SetJobStatus(v string) *ListSpeakerEnrollmentJobsInput {
	s.JobStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSpeakerEnrollmentJobsInput) SetMaxResults(v int64) *ListSpeakerEnrollmentJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSpeakerEnrollmentJobsInput) SetNextToken(v string) *ListSpeakerEnrollmentJobsInput {
	s.NextToken = &v
	return s
}

type ListSpeakerEnrollmentJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing details about each specified speaker enrollment job.
	JobSummaries []*SpeakerEnrollmentJobSummary `type:"list"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSpeakerEnrollmentJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSpeakerEnrollmentJobsOutput) GoString() string {
	return s.String()
}

// SetJobSummaries sets the JobSummaries field's value.
func (s *ListSpeakerEnrollmentJobsOutput) SetJobSummaries(v []*SpeakerEnrollmentJobSummary) *ListSpeakerEnrollmentJobsOutput {
	s.JobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSpeakerEnrollmentJobsOutput) SetNextToken(v string) *ListSpeakerEnrollmentJobsOutput {
	s.NextToken = &v
	return s
}

type ListSpeakersInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The maximum number of results that are returned per call. You can use NextToken
	// to obtain more pages of results. The default is 100; the maximum allowed
	// page size is also 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSpeakersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSpeakersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSpeakersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSpeakersInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *ListSpeakersInput) SetDomainId(v string) *ListSpeakersInput {
	s.DomainId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSpeakersInput) SetMaxResults(v int64) *ListSpeakersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSpeakersInput) SetNextToken(v string) *ListSpeakersInput {
	s.NextToken = &v
	return s
}

type ListSpeakersOutput struct {
	_ struct{} `type:"structure"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours.
	NextToken *string `min:"1" type:"string"`

	// A list containing details about each speaker in the Amazon Web Services account.
	SpeakerSummaries []*SpeakerSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSpeakersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSpeakersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSpeakersOutput) SetNextToken(v string) *ListSpeakersOutput {
	s.NextToken = &v
	return s
}

// SetSpeakerSummaries sets the SpeakerSummaries field's value.
func (s *ListSpeakersOutput) SetSpeakerSummaries(v []*SpeakerSummary) *ListSpeakersOutput {
	s.SpeakerSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Voice ID resource for which you want
	// to list the tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags associated with the specified resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListWatchlistsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The maximum number of results that are returned per call. You can use NextToken
	// to obtain more pages of results. The default is 100; the maximum allowed
	// page size is also 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWatchlistsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWatchlistsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWatchlistsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWatchlistsInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *ListWatchlistsInput) SetDomainId(v string) *ListWatchlistsInput {
	s.DomainId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWatchlistsInput) SetMaxResults(v int64) *ListWatchlistsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWatchlistsInput) SetNextToken(v string) *ListWatchlistsInput {
	s.NextToken = &v
	return s
}

type ListWatchlistsOutput struct {
	_ struct{} `type:"structure"`

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours.
	NextToken *string `min:"1" type:"string"`

	// A list that contains details about each watchlist in the Amazon Web Services
	// account.
	WatchlistSummaries []*WatchlistSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWatchlistsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWatchlistsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWatchlistsOutput) SetNextToken(v string) *ListWatchlistsOutput {
	s.NextToken = &v
	return s
}

// SetWatchlistSummaries sets the WatchlistSummaries field's value.
func (s *ListWatchlistsOutput) SetWatchlistSummaries(v []*WatchlistSummary) *ListWatchlistsOutput {
	s.WatchlistSummaries = v
	return s
}

type OptOutSpeakerInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the domain that contains the speaker.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The identifier of the speaker you want opted-out.
	//
	// SpeakerId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by OptOutSpeakerInput's
	// String and GoString methods.
	//
	// SpeakerId is a required field
	SpeakerId *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptOutSpeakerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptOutSpeakerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OptOutSpeakerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OptOutSpeakerInput"}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.SpeakerId == nil {
		invalidParams.Add(request.NewErrParamRequired("SpeakerId"))
	}
	if s.SpeakerId != nil && len(*s.SpeakerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SpeakerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainId sets the DomainId field's value.
func (s *OptOutSpeakerInput) SetDomainId(v string) *OptOutSpeakerInput {
	s.DomainId = &v
	return s
}

// SetSpeakerId sets the SpeakerId field's value.
func (s *OptOutSpeakerInput) SetSpeakerId(v string) *OptOutSpeakerInput {
	s.SpeakerId = &v
	return s
}

type OptOutSpeakerOutput struct {
	_ struct{} `type:"structure"`

	// Details about the opted-out speaker.
	Speaker *Speaker `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptOutSpeakerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OptOutSpeakerOutput) GoString() string {
	return s.String()
}

// SetSpeaker sets the Speaker field's value.
func (s *OptOutSpeakerOutput) SetSpeaker(v *Speaker) *OptOutSpeakerOutput {
	s.Speaker = v
	return s
}

// The configuration containing output file information for a batch job.
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// The identifier of the KMS key you want Voice ID to use to encrypt the output
	// file of a speaker enrollment job/fraudster registration job.
	KmsKeyId *string `min:"1" type:"string"`

	// The S3 path of the folder where Voice ID writes the job output file. It has
	// a *.out extension. For example, if the input file name is input-file.json
	// and the output folder path is s3://output-bucket/output-folder, the full
	// output file path is s3://output-bucket/output-folder/job-Id/input-file.json.out.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputDataConfig"}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *OutputDataConfig) SetKmsKeyId(v string) *OutputDataConfig {
	s.KmsKeyId = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *OutputDataConfig) SetS3Uri(v string) *OutputDataConfig {
	s.S3Uri = &v
	return s
}

// The registration configuration to be used during the batch fraudster registration
// job.
type RegistrationConfig struct {
	_ struct{} `type:"structure"`

	// The action to take when a fraudster is identified as a duplicate. The default
	// action is SKIP, which skips registering the duplicate fraudster. Setting
	// the value to REGISTER_AS_NEW always registers a new fraudster into the specified
	// domain.
	DuplicateRegistrationAction *string `type:"string" enum:"DuplicateRegistrationAction"`

	// The minimum similarity score between the new and old fraudsters in order
	// to consider the new fraudster a duplicate.
	FraudsterSimilarityThreshold *int64 `type:"integer"`

	// The identifiers of watchlists that a fraudster is registered to. If a watchlist
	// isn't provided, the fraudsters are registered to the default watchlist.
	WatchlistIds []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegistrationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegistrationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegistrationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegistrationConfig"}
	if s.WatchlistIds != nil && len(s.WatchlistIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WatchlistIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDuplicateRegistrationAction sets the DuplicateRegistrationAction field's value.
func (s *RegistrationConfig) SetDuplicateRegistrationAction(v string) *RegistrationConfig {
	s.DuplicateRegistrationAction = &v
	return s
}

// SetFraudsterSimilarityThreshold sets the FraudsterSimilarityThreshold field's value.
func (s *RegistrationConfig) SetFraudsterSimilarityThreshold(v int64) *RegistrationConfig {
	s.FraudsterSimilarityThreshold = &v
	return s
}

// SetWatchlistIds sets the WatchlistIds field's value.
func (s *RegistrationConfig) SetWatchlistIds(v []*string) *RegistrationConfig {
	s.WatchlistIds = v
	return s
}

// The specified resource cannot be found. Check the ResourceType and error
// message for more details.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`

	// The type of resource which cannot not be found. Possible types are BATCH_JOB,
	// COMPLIANCE_CONSENT, DOMAIN, FRAUDSTER, SESSION and SPEAKER.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration containing information about the customer managed key used
// for encrypting customer data.
type ServerSideEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The identifier of the KMS key to use to encrypt data stored by Voice ID.
	// Voice ID doesn't support asymmetric customer managed keys.
	//
	// KmsKeyId is a required field
	KmsKeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerSideEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerSideEncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServerSideEncryptionConfiguration"}
	if s.KmsKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsKeyId"))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ServerSideEncryptionConfiguration) SetKmsKeyId(v string) *ServerSideEncryptionConfiguration {
	s.KmsKeyId = &v
	return s
}

// Details about the most recent server-side encryption configuration update.
// When the server-side encryption configuration is changed, dependency on the
// old KMS key is removed through an asynchronous process. When this update
// is complete, the domain’s data can only be accessed using the new KMS key.
type ServerSideEncryptionUpdateDetails struct {
	_ struct{} `type:"structure"`

	// Message explaining the current UpdateStatus. When the UpdateStatus is FAILED,
	// this message explains the cause of the failure.
	Message *string `min:"1" type:"string"`

	// The previous KMS key ID the domain was encrypted with, before ServerSideEncryptionConfiguration
	// was updated to a new KMS key ID.
	OldKmsKeyId *string `min:"1" type:"string"`

	// Status of the server-side encryption update. During an update, if there is
	// an issue with the domain's current or old KMS key ID, such as an inaccessible
	// or disabled key, then the status is FAILED. In order to resolve this, the
	// key needs to be made accessible, and then an UpdateDomain call with the existing
	// server-side encryption configuration will re-attempt this update process.
	UpdateStatus *string `type:"string" enum:"ServerSideEncryptionUpdateStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerSideEncryptionUpdateDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerSideEncryptionUpdateDetails) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ServerSideEncryptionUpdateDetails) SetMessage(v string) *ServerSideEncryptionUpdateDetails {
	s.Message = &v
	return s
}

// SetOldKmsKeyId sets the OldKmsKeyId field's value.
func (s *ServerSideEncryptionUpdateDetails) SetOldKmsKeyId(v string) *ServerSideEncryptionUpdateDetails {
	s.OldKmsKeyId = &v
	return s
}

// SetUpdateStatus sets the UpdateStatus field's value.
func (s *ServerSideEncryptionUpdateDetails) SetUpdateStatus(v string) *ServerSideEncryptionUpdateDetails {
	s.UpdateStatus = &v
	return s
}

// The request exceeded the service quota. Refer to Voice ID Service Quotas
// (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas)
// and try your request again.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains all the information about a speaker.
type Speaker struct {
	_ struct{} `type:"structure"`

	// A timestamp of when the speaker was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The client-provided identifier for the speaker.
	//
	// CustomerSpeakerId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Speaker's
	// String and GoString methods.
	CustomerSpeakerId *string `min:"1" type:"string" sensitive:"true"`

	// The identifier of the domain that contains the speaker.
	DomainId *string `min:"22" type:"string"`

	// The service-generated identifier for the speaker.
	GeneratedSpeakerId *string `min:"25" type:"string"`

	// The timestamp of when the speaker was last accessed for enrollment, re-enrollment
	// or a successful authentication. This timestamp is accurate to one hour.
	LastAccessedAt *time.Time `type:"timestamp"`

	// The current status of the speaker.
	Status *string `type:"string" enum:"SpeakerStatus"`

	// A timestamp of the speaker's last update.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Speaker) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Speaker) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Speaker) SetCreatedAt(v time.Time) *Speaker {
	s.CreatedAt = &v
	return s
}

// SetCustomerSpeakerId sets the CustomerSpeakerId field's value.
func (s *Speaker) SetCustomerSpeakerId(v string) *Speaker {
	s.CustomerSpeakerId = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *Speaker) SetDomainId(v string) *Speaker {
	s.DomainId = &v
	return s
}

// SetGeneratedSpeakerId sets the GeneratedSpeakerId field's value.
func (s *Speaker) SetGeneratedSpeakerId(v string) *Speaker {
	s.GeneratedSpeakerId = &v
	return s
}

// SetLastAccessedAt sets the LastAccessedAt field's value.
func (s *Speaker) SetLastAccessedAt(v time.Time) *Speaker {
	s.LastAccessedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Speaker) SetStatus(v string) *Speaker {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Speaker) SetUpdatedAt(v time.Time) *Speaker {
	s.UpdatedAt = &v
	return s
}

// Contains all the information about a speaker enrollment job.
type SpeakerEnrollmentJob struct {
	_ struct{} `type:"structure"`

	// A timestamp of when the speaker enrollment job was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions
	// to access customer's buckets to read the input manifest file and write the
	// job output file.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The identifier of the domain that contains the speaker enrollment job.
	DomainId *string `min:"22" type:"string"`

	// A timestamp of when the speaker enrollment job ended.
	EndedAt *time.Time `type:"timestamp"`

	// The configuration that defines the action to take when the speaker is already
	// enrolled in Voice ID, and the FraudDetectionConfig to use.
	EnrollmentConfig *EnrollmentConfig `type:"structure"`

	// Contains details that are populated when an entire batch job fails. In cases
	// of individual registration job failures, the batch job as a whole doesn't
	// fail; it is completed with a JobStatus of COMPLETED_WITH_ERRORS. You can
	// use the job output file to identify the individual registration requests
	// that failed.
	FailureDetails *FailureDetails `type:"structure"`

	// The input data config containing an S3 URI for the input manifest file that
	// contains the list of speaker enrollment job requests.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The service-generated identifier for the speaker enrollment job.
	JobId *string `min:"22" type:"string"`

	// The client-provided name for the speaker enrollment job.
	//
	// JobName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SpeakerEnrollmentJob's
	// String and GoString methods.
	JobName *string `min:"1" type:"string" sensitive:"true"`

	// Provides details on job progress. This field shows the completed percentage
	// of registration requests listed in the input file.
	JobProgress *JobProgress `type:"structure"`

	// The current status of the speaker enrollment job.
	JobStatus *string `type:"string" enum:"SpeakerEnrollmentJobStatus"`

	// The output data config containing the S3 location where Voice ID writes the
	// job output file; you must also include a KMS key ID to encrypt the file.
	OutputDataConfig *OutputDataConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpeakerEnrollmentJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpeakerEnrollmentJob) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SpeakerEnrollmentJob) SetCreatedAt(v time.Time) *SpeakerEnrollmentJob {
	s.CreatedAt = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *SpeakerEnrollmentJob) SetDataAccessRoleArn(v string) *SpeakerEnrollmentJob {
	s.DataAccessRoleArn = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *SpeakerEnrollmentJob) SetDomainId(v string) *SpeakerEnrollmentJob {
	s.DomainId = &v
	return s
}

// SetEndedAt sets the EndedAt field's value.
func (s *SpeakerEnrollmentJob) SetEndedAt(v time.Time) *SpeakerEnrollmentJob {
	s.EndedAt = &v
	return s
}

// SetEnrollmentConfig sets the EnrollmentConfig field's value.
func (s *SpeakerEnrollmentJob) SetEnrollmentConfig(v *EnrollmentConfig) *SpeakerEnrollmentJob {
	s.EnrollmentConfig = v
	return s
}

// SetFailureDetails sets the FailureDetails field's value.
func (s *SpeakerEnrollmentJob) SetFailureDetails(v *FailureDetails) *SpeakerEnrollmentJob {
	s.FailureDetails = v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *SpeakerEnrollmentJob) SetInputDataConfig(v *InputDataConfig) *SpeakerEnrollmentJob {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *SpeakerEnrollmentJob) SetJobId(v string) *SpeakerEnrollmentJob {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *SpeakerEnrollmentJob) SetJobName(v string) *SpeakerEnrollmentJob {
	s.JobName = &v
	return s
}

// SetJobProgress sets the JobProgress field's value.
func (s *SpeakerEnrollmentJob) SetJobProgress(v *JobProgress) *SpeakerEnrollmentJob {
	s.JobProgress = v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *SpeakerEnrollmentJob) SetJobStatus(v string) *SpeakerEnrollmentJob {
	s.JobStatus = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *SpeakerEnrollmentJob) SetOutputDataConfig(v *OutputDataConfig) *SpeakerEnrollmentJob {
	s.OutputDataConfig = v
	return s
}

// Contains a summary of information about a speaker enrollment job.
type SpeakerEnrollmentJobSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp of when of the speaker enrollment job was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The identifier of the domain that contains the speaker enrollment job.
	DomainId *string `min:"22" type:"string"`

	// A timestamp of when the speaker enrollment job ended.
	EndedAt *time.Time `type:"timestamp"`

	// Contains details that are populated when an entire batch job fails. In cases
	// of individual registration job failures, the batch job as a whole doesn't
	// fail; it is completed with a JobStatus of COMPLETED_WITH_ERRORS. You can
	// use the job output file to identify the individual registration requests
	// that failed.
	FailureDetails *FailureDetails `type:"structure"`

	// The service-generated identifier for the speaker enrollment job.
	JobId *string `min:"22" type:"string"`

	// The client-provided name for the speaker enrollment job.
	//
	// JobName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SpeakerEnrollmentJobSummary's
	// String and GoString methods.
	JobName *string `min:"1" type:"string" sensitive:"true"`

	// Provides details regarding job progress. This field shows the completed percentage
	// of enrollment requests listed in the input file.
	JobProgress *JobProgress `type:"structure"`

	// The current status of the speaker enrollment job.
	JobStatus *string `type:"string" enum:"SpeakerEnrollmentJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpeakerEnrollmentJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpeakerEnrollmentJobSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SpeakerEnrollmentJobSummary) SetCreatedAt(v time.Time) *SpeakerEnrollmentJobSummary {
	s.CreatedAt = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *SpeakerEnrollmentJobSummary) SetDomainId(v string) *SpeakerEnrollmentJobSummary {
	s.DomainId = &v
	return s
}

// SetEndedAt sets the EndedAt field's value.
func (s *SpeakerEnrollmentJobSummary) SetEndedAt(v time.Time) *SpeakerEnrollmentJobSummary {
	s.EndedAt = &v
	return s
}

// SetFailureDetails sets the FailureDetails field's value.
func (s *SpeakerEnrollmentJobSummary) SetFailureDetails(v *FailureDetails) *SpeakerEnrollmentJobSummary {
	s.FailureDetails = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *SpeakerEnrollmentJobSummary) SetJobId(v string) *SpeakerEnrollmentJobSummary {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *SpeakerEnrollmentJobSummary) SetJobName(v string) *SpeakerEnrollmentJobSummary {
	s.JobName = &v
	return s
}

// SetJobProgress sets the JobProgress field's value.
func (s *SpeakerEnrollmentJobSummary) SetJobProgress(v *JobProgress) *SpeakerEnrollmentJobSummary {
	s.JobProgress = v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *SpeakerEnrollmentJobSummary) SetJobStatus(v string) *SpeakerEnrollmentJobSummary {
	s.JobStatus = &v
	return s
}

// Contains a summary of information about a speaker.
type SpeakerSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp showing the speaker's creation time.
	CreatedAt *time.Time `type:"timestamp"`

	// The client-provided identifier for the speaker.
	//
	// CustomerSpeakerId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SpeakerSummary's
	// String and GoString methods.
	CustomerSpeakerId *string `min:"1" type:"string" sensitive:"true"`

	// The identifier of the domain that contains the speaker.
	DomainId *string `min:"22" type:"string"`

	// The service-generated identifier for the speaker.
	GeneratedSpeakerId *string `min:"25" type:"string"`

	// The timestamp when the speaker was last accessed for enrollment, re-enrollment
	// or a successful authentication. This timestamp is accurate to one hour.
	LastAccessedAt *time.Time `type:"timestamp"`

	// The current status of the speaker.
	Status *string `type:"string" enum:"SpeakerStatus"`

	// A timestamp showing the speaker's last update.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpeakerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpeakerSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SpeakerSummary) SetCreatedAt(v time.Time) *SpeakerSummary {
	s.CreatedAt = &v
	return s
}

// SetCustomerSpeakerId sets the CustomerSpeakerId field's value.
func (s *SpeakerSummary) SetCustomerSpeakerId(v string) *SpeakerSummary {
	s.CustomerSpeakerId = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *SpeakerSummary) SetDomainId(v string) *SpeakerSummary {
	s.DomainId = &v
	return s
}

// SetGeneratedSpeakerId sets the GeneratedSpeakerId field's value.
func (s *SpeakerSummary) SetGeneratedSpeakerId(v string) *SpeakerSummary {
	s.GeneratedSpeakerId = &v
	return s
}

// SetLastAccessedAt sets the LastAccessedAt field's value.
func (s *SpeakerSummary) SetLastAccessedAt(v time.Time) *SpeakerSummary {
	s.LastAccessedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SpeakerSummary) SetStatus(v string) *SpeakerSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *SpeakerSummary) SetUpdatedAt(v time.Time) *SpeakerSummary {
	s.UpdatedAt = &v
	return s
}

type StartFraudsterRegistrationJobInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions
	// to access customer's buckets to read the input manifest file and write the
	// Job output file. Refer to the Create and edit a fraudster watchlist (https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-fraudster-watchlist.html)
	// documentation for the permissions needed in this role.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The identifier of the domain that contains the fraudster registration job
	// and in which the fraudsters are registered.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The input data config containing an S3 URI for the input manifest file that
	// contains the list of fraudster registration requests.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The name of the new fraudster registration job.
	//
	// JobName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartFraudsterRegistrationJobInput's
	// String and GoString methods.
	JobName *string `min:"1" type:"string" sensitive:"true"`

	// The output data config containing the S3 location where Voice ID writes the
	// job output file; you must also include a KMS key ID to encrypt the file.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// The registration config containing details such as the action to take when
	// a duplicate fraudster is detected, and the similarity threshold to use for
	// detecting a duplicate fraudster.
	RegistrationConfig *RegistrationConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFraudsterRegistrationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFraudsterRegistrationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFraudsterRegistrationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartFraudsterRegistrationJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.RegistrationConfig != nil {
		if err := s.RegistrationConfig.Validate(); err != nil {
			invalidParams.AddNested("RegistrationConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartFraudsterRegistrationJobInput) SetClientToken(v string) *StartFraudsterRegistrationJobInput {
	s.ClientToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartFraudsterRegistrationJobInput) SetDataAccessRoleArn(v string) *StartFraudsterRegistrationJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *StartFraudsterRegistrationJobInput) SetDomainId(v string) *StartFraudsterRegistrationJobInput {
	s.DomainId = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartFraudsterRegistrationJobInput) SetInputDataConfig(v *InputDataConfig) *StartFraudsterRegistrationJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartFraudsterRegistrationJobInput) SetJobName(v string) *StartFraudsterRegistrationJobInput {
	s.JobName = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartFraudsterRegistrationJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartFraudsterRegistrationJobInput {
	s.OutputDataConfig = v
	return s
}

// SetRegistrationConfig sets the RegistrationConfig field's value.
func (s *StartFraudsterRegistrationJobInput) SetRegistrationConfig(v *RegistrationConfig) *StartFraudsterRegistrationJobInput {
	s.RegistrationConfig = v
	return s
}

type StartFraudsterRegistrationJobOutput struct {
	_ struct{} `type:"structure"`

	// Details about the started fraudster registration job.
	Job *FraudsterRegistrationJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFraudsterRegistrationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFraudsterRegistrationJobOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *StartFraudsterRegistrationJobOutput) SetJob(v *FraudsterRegistrationJob) *StartFraudsterRegistrationJobOutput {
	s.Job = v
	return s
}

type StartSpeakerEnrollmentJobInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions
	// to access customer's buckets to read the input manifest file and write the
	// job output file. Refer to Batch enrollment using audio data from prior calls
	// (https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-batch-enrollment.html)
	// for the permissions needed in this role.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The identifier of the domain that contains the speaker enrollment job and
	// in which the speakers are enrolled.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The enrollment config that contains details such as the action to take when
	// a speaker is already enrolled in Voice ID or when a speaker is identified
	// as a fraudster.
	EnrollmentConfig *EnrollmentConfig `type:"structure"`

	// The input data config containing the S3 location for the input manifest file
	// that contains the list of speaker enrollment requests.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// A name for your speaker enrollment job.
	//
	// JobName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartSpeakerEnrollmentJobInput's
	// String and GoString methods.
	JobName *string `min:"1" type:"string" sensitive:"true"`

	// The output data config containing the S3 location where Voice ID writes the
	// job output file; you must also include a KMS key ID to encrypt the file.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSpeakerEnrollmentJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSpeakerEnrollmentJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSpeakerEnrollmentJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSpeakerEnrollmentJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.EnrollmentConfig != nil {
		if err := s.EnrollmentConfig.Validate(); err != nil {
			invalidParams.AddNested("EnrollmentConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartSpeakerEnrollmentJobInput) SetClientToken(v string) *StartSpeakerEnrollmentJobInput {
	s.ClientToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartSpeakerEnrollmentJobInput) SetDataAccessRoleArn(v string) *StartSpeakerEnrollmentJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *StartSpeakerEnrollmentJobInput) SetDomainId(v string) *StartSpeakerEnrollmentJobInput {
	s.DomainId = &v
	return s
}

// SetEnrollmentConfig sets the EnrollmentConfig field's value.
func (s *StartSpeakerEnrollmentJobInput) SetEnrollmentConfig(v *EnrollmentConfig) *StartSpeakerEnrollmentJobInput {
	s.EnrollmentConfig = v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartSpeakerEnrollmentJobInput) SetInputDataConfig(v *InputDataConfig) *StartSpeakerEnrollmentJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartSpeakerEnrollmentJobInput) SetJobName(v string) *StartSpeakerEnrollmentJobInput {
	s.JobName = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartSpeakerEnrollmentJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartSpeakerEnrollmentJobInput {
	s.OutputDataConfig = v
	return s
}

type StartSpeakerEnrollmentJobOutput struct {
	_ struct{} `type:"structure"`

	// Details about the started speaker enrollment job.
	Job *SpeakerEnrollmentJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSpeakerEnrollmentJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSpeakerEnrollmentJobOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *StartSpeakerEnrollmentJobOutput) SetJob(v *SpeakerEnrollmentJob) *StartSpeakerEnrollmentJobOutput {
	s.Job = v
	return s
}

// The tags used to organize, track, or control access for this resource. For
// example, { "tags": {"key1":"value1", "key2":"value2"} }.
type Tag struct {
	_ struct{} `type:"structure"`

	// The first part of a key:value pair that forms a tag associated with a given
	// resource. For example, in the tag 'Department':'Sales', the key is 'Department'.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Tag's
	// String and GoString methods.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The second part of a key:value pair that forms a tag associated with a given
	// resource. For example, in the tag 'Department':'Sales', the value is 'Sales'.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Tag's
	// String and GoString methods.
	//
	// Value is a required field
	Value *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Voice ID resource you want to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The list of tags to assign to the specified resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling. Please slow down your request
// rate. Refer to Amazon Connect Voice ID Service API throttling quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas)
// and try your request again.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Voice ID resource you want to remove
	// tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The list of tag keys you want to remove from the specified resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDomainInput struct {
	_ struct{} `type:"structure"`

	// A brief description about this domain.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateDomainInput's
	// String and GoString methods.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The identifier of the domain to be updated.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The name of the domain.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateDomainInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The configuration, containing the KMS key identifier, to be used by Voice
	// ID for the server-side encryption of your data. Changing the domain's associated
	// KMS key immediately triggers an asynchronous process to remove dependency
	// on the old KMS key, such that the domain's data can only be accessed using
	// the new KMS key. The domain's ServerSideEncryptionUpdateDetails contains
	// the details for this process.
	//
	// ServerSideEncryptionConfiguration is a required field
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDomainInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ServerSideEncryptionConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerSideEncryptionConfiguration"))
	}
	if s.ServerSideEncryptionConfiguration != nil {
		if err := s.ServerSideEncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServerSideEncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateDomainInput) SetDescription(v string) *UpdateDomainInput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *UpdateDomainInput) SetDomainId(v string) *UpdateDomainInput {
	s.DomainId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDomainInput) SetName(v string) *UpdateDomainInput {
	s.Name = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *UpdateDomainInput) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *UpdateDomainInput {
	s.ServerSideEncryptionConfiguration = v
	return s
}

type UpdateDomainOutput struct {
	_ struct{} `type:"structure"`

	// Details about the updated domain
	Domain *Domain `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainOutput) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *UpdateDomainOutput) SetDomain(v *Domain) *UpdateDomainOutput {
	s.Domain = v
	return s
}

type UpdateWatchlistInput struct {
	_ struct{} `type:"structure"`

	// A brief description about this watchlist.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateWatchlistInput's
	// String and GoString methods.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The identifier of the domain that contains the watchlist.
	//
	// DomainId is a required field
	DomainId *string `min:"22" type:"string" required:"true"`

	// The name of the watchlist.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateWatchlistInput's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The identifier of the watchlist to be updated.
	//
	// WatchlistId is a required field
	WatchlistId *string `min:"22" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWatchlistInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWatchlistInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWatchlistInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWatchlistInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DomainId == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainId"))
	}
	if s.DomainId != nil && len(*s.DomainId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("DomainId", 22))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.WatchlistId == nil {
		invalidParams.Add(request.NewErrParamRequired("WatchlistId"))
	}
	if s.WatchlistId != nil && len(*s.WatchlistId) < 22 {
		invalidParams.Add(request.NewErrParamMinLen("WatchlistId", 22))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateWatchlistInput) SetDescription(v string) *UpdateWatchlistInput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *UpdateWatchlistInput) SetDomainId(v string) *UpdateWatchlistInput {
	s.DomainId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWatchlistInput) SetName(v string) *UpdateWatchlistInput {
	s.Name = &v
	return s
}

// SetWatchlistId sets the WatchlistId field's value.
func (s *UpdateWatchlistInput) SetWatchlistId(v string) *UpdateWatchlistInput {
	s.WatchlistId = &v
	return s
}

type UpdateWatchlistOutput struct {
	_ struct{} `type:"structure"`

	// Details about the updated watchlist.
	Watchlist *Watchlist `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWatchlistOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWatchlistOutput) GoString() string {
	return s.String()
}

// SetWatchlist sets the Watchlist field's value.
func (s *UpdateWatchlistOutput) SetWatchlist(v *Watchlist) *UpdateWatchlistOutput {
	s.Watchlist = v
	return s
}

// The request failed one or more validations; check the error message for more
// details.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details resulting from 'Voice Spoofing Risk' analysis of the speaker.
type VoiceSpoofingRisk struct {
	_ struct{} `type:"structure"`

	// The score indicating the likelihood of speaker’s voice being spoofed.
	//
	// RiskScore is a required field
	RiskScore *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VoiceSpoofingRisk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VoiceSpoofingRisk) GoString() string {
	return s.String()
}

// SetRiskScore sets the RiskScore field's value.
func (s *VoiceSpoofingRisk) SetRiskScore(v int64) *VoiceSpoofingRisk {
	s.RiskScore = &v
	return s
}

// Contains all the information about a watchlist.
type Watchlist struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the watchlist was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Whether the specified watchlist is the default watchlist of a domain.
	DefaultWatchlist *bool `type:"boolean"`

	// The description of the watchlist.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Watchlist's
	// String and GoString methods.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The identifier of the domain that contains the watchlist.
	DomainId *string `min:"22" type:"string"`

	// The name for the watchlist.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Watchlist's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The timestamp of when the watchlist was updated.
	UpdatedAt *time.Time `type:"timestamp"`

	// The identifier of the watchlist.
	WatchlistId *string `min:"22" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Watchlist) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Watchlist) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Watchlist) SetCreatedAt(v time.Time) *Watchlist {
	s.CreatedAt = &v
	return s
}

// SetDefaultWatchlist sets the DefaultWatchlist field's value.
func (s *Watchlist) SetDefaultWatchlist(v bool) *Watchlist {
	s.DefaultWatchlist = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Watchlist) SetDescription(v string) *Watchlist {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *Watchlist) SetDomainId(v string) *Watchlist {
	s.DomainId = &v
	return s
}

// SetName sets the Name field's value.
func (s *Watchlist) SetName(v string) *Watchlist {
	s.Name = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Watchlist) SetUpdatedAt(v time.Time) *Watchlist {
	s.UpdatedAt = &v
	return s
}

// SetWatchlistId sets the WatchlistId field's value.
func (s *Watchlist) SetWatchlistId(v string) *Watchlist {
	s.WatchlistId = &v
	return s
}

// Details of the watchlists in a domain.
type WatchlistDetails struct {
	_ struct{} `type:"structure"`

	// The identifier of the default watchlist.
	//
	// DefaultWatchlistId is a required field
	DefaultWatchlistId *string `min:"22" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WatchlistDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WatchlistDetails) GoString() string {
	return s.String()
}

// SetDefaultWatchlistId sets the DefaultWatchlistId field's value.
func (s *WatchlistDetails) SetDefaultWatchlistId(v string) *WatchlistDetails {
	s.DefaultWatchlistId = &v
	return s
}

// Contains a summary of information about a watchlist.
type WatchlistSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the watchlist was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Whether the specified watchlist is the default watchlist of a domain.
	DefaultWatchlist *bool `type:"boolean"`

	// The description of the watchlist.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by WatchlistSummary's
	// String and GoString methods.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The identifier of the domain that contains the watchlist.
	DomainId *string `min:"22" type:"string"`

	// The name for the watchlist.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by WatchlistSummary's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The timestamp of when the watchlist was last updated.
	UpdatedAt *time.Time `type:"timestamp"`

	// The identifier of the watchlist.
	WatchlistId *string `min:"22" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WatchlistSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WatchlistSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *WatchlistSummary) SetCreatedAt(v time.Time) *WatchlistSummary {
	s.CreatedAt = &v
	return s
}

// SetDefaultWatchlist sets the DefaultWatchlist field's value.
func (s *WatchlistSummary) SetDefaultWatchlist(v bool) *WatchlistSummary {
	s.DefaultWatchlist = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WatchlistSummary) SetDescription(v string) *WatchlistSummary {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *WatchlistSummary) SetDomainId(v string) *WatchlistSummary {
	s.DomainId = &v
	return s
}

// SetName sets the Name field's value.
func (s *WatchlistSummary) SetName(v string) *WatchlistSummary {
	s.Name = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *WatchlistSummary) SetUpdatedAt(v time.Time) *WatchlistSummary {
	s.UpdatedAt = &v
	return s
}

// SetWatchlistId sets the WatchlistId field's value.
func (s *WatchlistSummary) SetWatchlistId(v string) *WatchlistSummary {
	s.WatchlistId = &v
	return s
}

const (
	// AuthenticationDecisionAccept is a AuthenticationDecision enum value
	AuthenticationDecisionAccept = "ACCEPT"

	// AuthenticationDecisionReject is a AuthenticationDecision enum value
	AuthenticationDecisionReject = "REJECT"

	// AuthenticationDecisionNotEnoughSpeech is a AuthenticationDecision enum value
	AuthenticationDecisionNotEnoughSpeech = "NOT_ENOUGH_SPEECH"

	// AuthenticationDecisionSpeakerNotEnrolled is a AuthenticationDecision enum value
	AuthenticationDecisionSpeakerNotEnrolled = "SPEAKER_NOT_ENROLLED"

	// AuthenticationDecisionSpeakerOptedOut is a AuthenticationDecision enum value
	AuthenticationDecisionSpeakerOptedOut = "SPEAKER_OPTED_OUT"

	// AuthenticationDecisionSpeakerIdNotProvided is a AuthenticationDecision enum value
	AuthenticationDecisionSpeakerIdNotProvided = "SPEAKER_ID_NOT_PROVIDED"

	// AuthenticationDecisionSpeakerExpired is a AuthenticationDecision enum value
	AuthenticationDecisionSpeakerExpired = "SPEAKER_EXPIRED"
)

// AuthenticationDecision_Values returns all elements of the AuthenticationDecision enum
func AuthenticationDecision_Values() []string {
	return []string{
		AuthenticationDecisionAccept,
		AuthenticationDecisionReject,
		AuthenticationDecisionNotEnoughSpeech,
		AuthenticationDecisionSpeakerNotEnrolled,
		AuthenticationDecisionSpeakerOptedOut,
		AuthenticationDecisionSpeakerIdNotProvided,
		AuthenticationDecisionSpeakerExpired,
	}
}

const (
	// ConflictTypeAnotherActiveStream is a ConflictType enum value
	ConflictTypeAnotherActiveStream = "ANOTHER_ACTIVE_STREAM"

	// ConflictTypeDomainNotActive is a ConflictType enum value
	ConflictTypeDomainNotActive = "DOMAIN_NOT_ACTIVE"

	// ConflictTypeCannotChangeSpeakerAfterEnrollment is a ConflictType enum value
	ConflictTypeCannotChangeSpeakerAfterEnrollment = "CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT"

	// ConflictTypeEnrollmentAlreadyExists is a ConflictType enum value
	ConflictTypeEnrollmentAlreadyExists = "ENROLLMENT_ALREADY_EXISTS"

	// ConflictTypeSpeakerNotSet is a ConflictType enum value
	ConflictTypeSpeakerNotSet = "SPEAKER_NOT_SET"

	// ConflictTypeSpeakerOptedOut is a ConflictType enum value
	ConflictTypeSpeakerOptedOut = "SPEAKER_OPTED_OUT"

	// ConflictTypeConcurrentChanges is a ConflictType enum value
	ConflictTypeConcurrentChanges = "CONCURRENT_CHANGES"

	// ConflictTypeDomainLockedFromEncryptionUpdates is a ConflictType enum value
	ConflictTypeDomainLockedFromEncryptionUpdates = "DOMAIN_LOCKED_FROM_ENCRYPTION_UPDATES"

	// ConflictTypeCannotDeleteNonEmptyWatchlist is a ConflictType enum value
	ConflictTypeCannotDeleteNonEmptyWatchlist = "CANNOT_DELETE_NON_EMPTY_WATCHLIST"

	// ConflictTypeFraudsterMustBelongToAtLeastOneWatchlist is a ConflictType enum value
	ConflictTypeFraudsterMustBelongToAtLeastOneWatchlist = "FRAUDSTER_MUST_BELONG_TO_AT_LEAST_ONE_WATCHLIST"
)

// ConflictType_Values returns all elements of the ConflictType enum
func ConflictType_Values() []string {
	return []string{
		ConflictTypeAnotherActiveStream,
		ConflictTypeDomainNotActive,
		ConflictTypeCannotChangeSpeakerAfterEnrollment,
		ConflictTypeEnrollmentAlreadyExists,
		ConflictTypeSpeakerNotSet,
		ConflictTypeSpeakerOptedOut,
		ConflictTypeConcurrentChanges,
		ConflictTypeDomainLockedFromEncryptionUpdates,
		ConflictTypeCannotDeleteNonEmptyWatchlist,
		ConflictTypeFraudsterMustBelongToAtLeastOneWatchlist,
	}
}

const (
	// DomainStatusActive is a DomainStatus enum value
	DomainStatusActive = "ACTIVE"

	// DomainStatusPending is a DomainStatus enum value
	DomainStatusPending = "PENDING"

	// DomainStatusSuspended is a DomainStatus enum value
	DomainStatusSuspended = "SUSPENDED"
)

// DomainStatus_Values returns all elements of the DomainStatus enum
func DomainStatus_Values() []string {
	return []string{
		DomainStatusActive,
		DomainStatusPending,
		DomainStatusSuspended,
	}
}

const (
	// DuplicateRegistrationActionSkip is a DuplicateRegistrationAction enum value
	DuplicateRegistrationActionSkip = "SKIP"

	// DuplicateRegistrationActionRegisterAsNew is a DuplicateRegistrationAction enum value
	DuplicateRegistrationActionRegisterAsNew = "REGISTER_AS_NEW"
)

// DuplicateRegistrationAction_Values returns all elements of the DuplicateRegistrationAction enum
func DuplicateRegistrationAction_Values() []string {
	return []string{
		DuplicateRegistrationActionSkip,
		DuplicateRegistrationActionRegisterAsNew,
	}
}

const (
	// ExistingEnrollmentActionSkip is a ExistingEnrollmentAction enum value
	ExistingEnrollmentActionSkip = "SKIP"

	// ExistingEnrollmentActionOverwrite is a ExistingEnrollmentAction enum value
	ExistingEnrollmentActionOverwrite = "OVERWRITE"
)

// ExistingEnrollmentAction_Values returns all elements of the ExistingEnrollmentAction enum
func ExistingEnrollmentAction_Values() []string {
	return []string{
		ExistingEnrollmentActionSkip,
		ExistingEnrollmentActionOverwrite,
	}
}

const (
	// FraudDetectionActionIgnore is a FraudDetectionAction enum value
	FraudDetectionActionIgnore = "IGNORE"

	// FraudDetectionActionFail is a FraudDetectionAction enum value
	FraudDetectionActionFail = "FAIL"
)

// FraudDetectionAction_Values returns all elements of the FraudDetectionAction enum
func FraudDetectionAction_Values() []string {
	return []string{
		FraudDetectionActionIgnore,
		FraudDetectionActionFail,
	}
}

const (
	// FraudDetectionDecisionHighRisk is a FraudDetectionDecision enum value
	FraudDetectionDecisionHighRisk = "HIGH_RISK"

	// FraudDetectionDecisionLowRisk is a FraudDetectionDecision enum value
	FraudDetectionDecisionLowRisk = "LOW_RISK"

	// FraudDetectionDecisionNotEnoughSpeech is a FraudDetectionDecision enum value
	FraudDetectionDecisionNotEnoughSpeech = "NOT_ENOUGH_SPEECH"
)

// FraudDetectionDecision_Values returns all elements of the FraudDetectionDecision enum
func FraudDetectionDecision_Values() []string {
	return []string{
		FraudDetectionDecisionHighRisk,
		FraudDetectionDecisionLowRisk,
		FraudDetectionDecisionNotEnoughSpeech,
	}
}

const (
	// FraudDetectionReasonKnownFraudster is a FraudDetectionReason enum value
	FraudDetectionReasonKnownFraudster = "KNOWN_FRAUDSTER"

	// FraudDetectionReasonVoiceSpoofing is a FraudDetectionReason enum value
	FraudDetectionReasonVoiceSpoofing = "VOICE_SPOOFING"
)

// FraudDetectionReason_Values returns all elements of the FraudDetectionReason enum
func FraudDetectionReason_Values() []string {
	return []string{
		FraudDetectionReasonKnownFraudster,
		FraudDetectionReasonVoiceSpoofing,
	}
}

const (
	// FraudsterRegistrationJobStatusSubmitted is a FraudsterRegistrationJobStatus enum value
	FraudsterRegistrationJobStatusSubmitted = "SUBMITTED"

	// FraudsterRegistrationJobStatusInProgress is a FraudsterRegistrationJobStatus enum value
	FraudsterRegistrationJobStatusInProgress = "IN_PROGRESS"

	// FraudsterRegistrationJobStatusCompleted is a FraudsterRegistrationJobStatus enum value
	FraudsterRegistrationJobStatusCompleted = "COMPLETED"

	// FraudsterRegistrationJobStatusCompletedWithErrors is a FraudsterRegistrationJobStatus enum value
	FraudsterRegistrationJobStatusCompletedWithErrors = "COMPLETED_WITH_ERRORS"

	// FraudsterRegistrationJobStatusFailed is a FraudsterRegistrationJobStatus enum value
	FraudsterRegistrationJobStatusFailed = "FAILED"
)

// FraudsterRegistrationJobStatus_Values returns all elements of the FraudsterRegistrationJobStatus enum
func FraudsterRegistrationJobStatus_Values() []string {
	return []string{
		FraudsterRegistrationJobStatusSubmitted,
		FraudsterRegistrationJobStatusInProgress,
		FraudsterRegistrationJobStatusCompleted,
		FraudsterRegistrationJobStatusCompletedWithErrors,
		FraudsterRegistrationJobStatusFailed,
	}
}

const (
	// ResourceTypeBatchJob is a ResourceType enum value
	ResourceTypeBatchJob = "BATCH_JOB"

	// ResourceTypeComplianceConsent is a ResourceType enum value
	ResourceTypeComplianceConsent = "COMPLIANCE_CONSENT"

	// ResourceTypeDomain is a ResourceType enum value
	ResourceTypeDomain = "DOMAIN"

	// ResourceTypeFraudster is a ResourceType enum value
	ResourceTypeFraudster = "FRAUDSTER"

	// ResourceTypeSession is a ResourceType enum value
	ResourceTypeSession = "SESSION"

	// ResourceTypeSpeaker is a ResourceType enum value
	ResourceTypeSpeaker = "SPEAKER"

	// ResourceTypeWatchlist is a ResourceType enum value
	ResourceTypeWatchlist = "WATCHLIST"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeBatchJob,
		ResourceTypeComplianceConsent,
		ResourceTypeDomain,
		ResourceTypeFraudster,
		ResourceTypeSession,
		ResourceTypeSpeaker,
		ResourceTypeWatchlist,
	}
}

const (
	// ServerSideEncryptionUpdateStatusInProgress is a ServerSideEncryptionUpdateStatus enum value
	ServerSideEncryptionUpdateStatusInProgress = "IN_PROGRESS"

	// ServerSideEncryptionUpdateStatusCompleted is a ServerSideEncryptionUpdateStatus enum value
	ServerSideEncryptionUpdateStatusCompleted = "COMPLETED"

	// ServerSideEncryptionUpdateStatusFailed is a ServerSideEncryptionUpdateStatus enum value
	ServerSideEncryptionUpdateStatusFailed = "FAILED"
)

// ServerSideEncryptionUpdateStatus_Values returns all elements of the ServerSideEncryptionUpdateStatus enum
func ServerSideEncryptionUpdateStatus_Values() []string {
	return []string{
		ServerSideEncryptionUpdateStatusInProgress,
		ServerSideEncryptionUpdateStatusCompleted,
		ServerSideEncryptionUpdateStatusFailed,
	}
}

const (
	// SpeakerEnrollmentJobStatusSubmitted is a SpeakerEnrollmentJobStatus enum value
	SpeakerEnrollmentJobStatusSubmitted = "SUBMITTED"

	// SpeakerEnrollmentJobStatusInProgress is a SpeakerEnrollmentJobStatus enum value
	SpeakerEnrollmentJobStatusInProgress = "IN_PROGRESS"

	// SpeakerEnrollmentJobStatusCompleted is a SpeakerEnrollmentJobStatus enum value
	SpeakerEnrollmentJobStatusCompleted = "COMPLETED"

	// SpeakerEnrollmentJobStatusCompletedWithErrors is a SpeakerEnrollmentJobStatus enum value
	SpeakerEnrollmentJobStatusCompletedWithErrors = "COMPLETED_WITH_ERRORS"

	// SpeakerEnrollmentJobStatusFailed is a SpeakerEnrollmentJobStatus enum value
	SpeakerEnrollmentJobStatusFailed = "FAILED"
)

// SpeakerEnrollmentJobStatus_Values returns all elements of the SpeakerEnrollmentJobStatus enum
func SpeakerEnrollmentJobStatus_Values() []string {
	return []string{
		SpeakerEnrollmentJobStatusSubmitted,
		SpeakerEnrollmentJobStatusInProgress,
		SpeakerEnrollmentJobStatusCompleted,
		SpeakerEnrollmentJobStatusCompletedWithErrors,
		SpeakerEnrollmentJobStatusFailed,
	}
}

const (
	// SpeakerStatusEnrolled is a SpeakerStatus enum value
	SpeakerStatusEnrolled = "ENROLLED"

	// SpeakerStatusExpired is a SpeakerStatus enum value
	SpeakerStatusExpired = "EXPIRED"

	// SpeakerStatusOptedOut is a SpeakerStatus enum value
	SpeakerStatusOptedOut = "OPTED_OUT"

	// SpeakerStatusPending is a SpeakerStatus enum value
	SpeakerStatusPending = "PENDING"
)

// SpeakerStatus_Values returns all elements of the SpeakerStatus enum
func SpeakerStatus_Values() []string {
	return []string{
		SpeakerStatusEnrolled,
		SpeakerStatusExpired,
		SpeakerStatusOptedOut,
		SpeakerStatusPending,
	}
}

const (
	// StreamingStatusPendingConfiguration is a StreamingStatus enum value
	StreamingStatusPendingConfiguration = "PENDING_CONFIGURATION"

	// StreamingStatusOngoing is a StreamingStatus enum value
	StreamingStatusOngoing = "ONGOING"

	// StreamingStatusEnded is a StreamingStatus enum value
	StreamingStatusEnded = "ENDED"
)

// StreamingStatus_Values returns all elements of the StreamingStatus enum
func StreamingStatus_Values() []string {
	return []string{
		StreamingStatusPendingConfiguration,
		StreamingStatusOngoing,
		StreamingStatusEnded,
	}
}
