package quota

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/quota/mgmt/2021-03-15-preview/quota"

// CommonResourceProperties resource properties.
type CommonResourceProperties struct {
	// ID - READ-ONLY; Resource ID
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type. Example: "Microsoft.Quota/quotas"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CommonResourceProperties.
func (crp CommonResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CreateGenericQuotaRequestParameters quota change requests information.
type CreateGenericQuotaRequestParameters struct {
	// Value - Quota change requests.
	Value *[]CurrentQuotaLimitBase `json:"value,omitempty"`
}

// CreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (CurrentQuotaLimitBase, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CreateOrUpdateFuture.Result.
func (future *CreateOrUpdateFuture) result(client Client) (cqlb CurrentQuotaLimitBase, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "quota.CreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cqlb.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("quota.CreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cqlb.Response.Response, err = future.GetResult(sender); err == nil && cqlb.Response.Response.StatusCode != http.StatusNoContent {
		cqlb, err = client.CreateOrUpdateResponder(cqlb.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "quota.CreateOrUpdateFuture", "Result", cqlb.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CurrentQuotaLimitBase quota limit.
type CurrentQuotaLimitBase struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Properties - Quota properties for the specified resource, based on the API called, Quotas or Usages.
	Properties *Properties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CurrentQuotaLimitBase.
func (cqlb CurrentQuotaLimitBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cqlb.Properties != nil {
		objectMap["properties"] = cqlb.Properties
	}
	return json.Marshal(objectMap)
}

// CurrentUsagesBase resource usage.
type CurrentUsagesBase struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Properties - Usage properties for the specified resource.
	Properties *UsagesProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CurrentUsagesBase.
func (cub CurrentUsagesBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cub.Properties != nil {
		objectMap["properties"] = cub.Properties
	}
	return json.Marshal(objectMap)
}

// ExceptionResponse error.
type ExceptionResponse struct {
	// Error - API error details.
	Error *ServiceError `json:"error,omitempty"`
}

// BasicLimitJSONObject limitJson abstract class.
type BasicLimitJSONObject interface {
	AsLimitJSONObject() (*LimitJSONObject, bool)
}

// LimitJSONObject limitJson abstract class.
type LimitJSONObject struct {
	// LimitObjectType - Possible values include: 'LimitObjectTypeLimitJSONObject'
	LimitObjectType LimitObjectType `json:"limitObjectType,omitempty"`
}

func unmarshalBasicLimitJSONObject(body []byte) (BasicLimitJSONObject, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["limitObjectType"] {
	default:
		var ljo LimitJSONObject
		err := json.Unmarshal(body, &ljo)
		return ljo, err
	}
}
func unmarshalBasicLimitJSONObjectArray(body []byte) ([]BasicLimitJSONObject, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ljoArray := make([]BasicLimitJSONObject, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ljo, err := unmarshalBasicLimitJSONObject(*rawMessage)
		if err != nil {
			return nil, err
		}
		ljoArray[index] = ljo
	}
	return ljoArray, nil
}

// MarshalJSON is the custom marshaler for LimitJSONObject.
func (ljo LimitJSONObject) MarshalJSON() ([]byte, error) {
	ljo.LimitObjectType = LimitObjectTypeLimitJSONObject
	objectMap := make(map[string]interface{})
	if ljo.LimitObjectType != "" {
		objectMap["limitObjectType"] = ljo.LimitObjectType
	}
	return json.Marshal(objectMap)
}

// AsLimitJSONObject is the BasicLimitJSONObject implementation for LimitJSONObject.
func (ljo LimitJSONObject) AsLimitJSONObject() (*LimitJSONObject, bool) {
	return &ljo, true
}

// AsBasicLimitJSONObject is the BasicLimitJSONObject implementation for LimitJSONObject.
func (ljo LimitJSONObject) AsBasicLimitJSONObject() (BasicLimitJSONObject, bool) {
	return &ljo, true
}

// LimitObject the resource quota limit value.
type LimitObject struct {
	// Value - The quota/limit value
	Value *int32 `json:"value,omitempty"`
	// LimitObjectType - Possible values include: 'LimitTypeLimitValue'
	LimitObjectType LimitType `json:"limitObjectType,omitempty"`
	// LimitType - Possible values include: 'LimitTypesIndependent', 'LimitTypesShared'
	LimitType LimitTypes `json:"limitType,omitempty"`
}

// Limits quota limits.
type Limits struct {
	autorest.Response `json:"-"`
	// Value - List of quota limits.
	Value *[]CurrentQuotaLimitBase `json:"value,omitempty"`
	// NextLink - The URI used to fetch the next page of quota limits. When there are no more pages, this string is null.
	NextLink *string `json:"nextLink,omitempty"`
}

// LimitsIterator provides access to a complete listing of CurrentQuotaLimitBase values.
type LimitsIterator struct {
	i    int
	page LimitsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LimitsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LimitsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LimitsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LimitsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LimitsIterator) Response() Limits {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LimitsIterator) Value() CurrentQuotaLimitBase {
	if !iter.page.NotDone() {
		return CurrentQuotaLimitBase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LimitsIterator type.
func NewLimitsIterator(page LimitsPage) LimitsIterator {
	return LimitsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (l Limits) IsEmpty() bool {
	return l.Value == nil || len(*l.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (l Limits) hasNextLink() bool {
	return l.NextLink != nil && len(*l.NextLink) != 0
}

// limitsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (l Limits) limitsPreparer(ctx context.Context) (*http.Request, error) {
	if !l.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(l.NextLink)))
}

// LimitsPage contains a page of CurrentQuotaLimitBase values.
type LimitsPage struct {
	fn func(context.Context, Limits) (Limits, error)
	l  Limits
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LimitsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LimitsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.l)
		if err != nil {
			return err
		}
		page.l = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LimitsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LimitsPage) NotDone() bool {
	return !page.l.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LimitsPage) Response() Limits {
	return page.l
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LimitsPage) Values() []CurrentQuotaLimitBase {
	if page.l.IsEmpty() {
		return nil
	}
	return *page.l.Value
}

// Creates a new instance of the LimitsPage type.
func NewLimitsPage(cur Limits, getNextPage func(context.Context, Limits) (Limits, error)) LimitsPage {
	return LimitsPage{
		fn: getNextPage,
		l:  cur,
	}
}

// LimitsResponse quota limits request response.
type LimitsResponse struct {
	// Value - List of quota limits with the quota request status.
	Value *[]CurrentQuotaLimitBase `json:"value,omitempty"`
	// NextLink - The URI used to fetch the next page of quota limits. When there are no more pages, this is null.
	NextLink *string `json:"nextLink,omitempty"`
}

// LimitValue the resource quota limit.
type LimitValue struct {
	LimitObjectType *string `json:"limitObjectType,omitempty"`
	// Value - The quota/limit value
	Value *int32 `json:"value,omitempty"`
	// LimitType - Possible values include: 'LimitTypesIndependent', 'LimitTypesShared'
	LimitType LimitTypes `json:"limitType,omitempty"`
}

// OperationDisplay ...
type OperationDisplay struct {
	// Provider - Provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource name.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation name.
	Operation *string `json:"operation,omitempty"`
	// Description - Operation description.
	Description *string `json:"description,omitempty"`
}

// OperationList ...
type OperationList struct {
	autorest.Response `json:"-"`
	Value             *[]OperationResponse `json:"value,omitempty"`
	// NextLink - URL to get the next page of items.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListIterator provides access to a complete listing of OperationResponse values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() OperationResponse {
	if !iter.page.NotDone() {
		return OperationResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of OperationResponse values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []OperationResponse {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// OperationResponse ...
type OperationResponse struct {
	Name    *string           `json:"name,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
	Origin  *string           `json:"origin,omitempty"`
}

// Properties quota properties for the specified resource.
type Properties struct {
	// Limit - Resource quota limit properties.
	Limit BasicLimitJSONObject `json:"limit,omitempty"`
	// Unit - READ-ONLY;  The quota units, such as Count and Bytes. When requesting quota, use the **unit** value returned in the GET response in the request body of your PUT operation.
	Unit *string `json:"unit,omitempty"`
	// Name - Resource name provided by the resource provider. Use this property name when requesting quota.
	Name *ResourceName `json:"name,omitempty"`
	// ResourceType - Resource type name.
	ResourceType *string `json:"resourceType,omitempty"`
	// QuotaPeriod - READ-ONLY; The time period over which the quota usage values are summarized. For example:
	// *P1D (per one day)
	// *PT1M (per one minute)
	// *PT1S (per one second).
	// This parameter is optional because, for some resources like compute, the period is irrelevant.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
	// IsQuotaApplicable - READ-ONLY; States if quota can be requested for this resource.
	IsQuotaApplicable *bool `json:"isQuotaApplicable,omitempty"`
	// Properties - Additional properties for the specific resource provider.
	Properties interface{} `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["limit"] = p.Limit
	if p.Name != nil {
		objectMap["name"] = p.Name
	}
	if p.ResourceType != nil {
		objectMap["resourceType"] = p.ResourceType
	}
	if p.Properties != nil {
		objectMap["properties"] = p.Properties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Properties struct.
func (p *Properties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "limit":
			if v != nil {
				limit, err := unmarshalBasicLimitJSONObject(*v)
				if err != nil {
					return err
				}
				p.Limit = limit
			}
		case "unit":
			if v != nil {
				var unit string
				err = json.Unmarshal(*v, &unit)
				if err != nil {
					return err
				}
				p.Unit = &unit
			}
		case "name":
			if v != nil {
				var name ResourceName
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "resourceType":
			if v != nil {
				var resourceType string
				err = json.Unmarshal(*v, &resourceType)
				if err != nil {
					return err
				}
				p.ResourceType = &resourceType
			}
		case "quotaPeriod":
			if v != nil {
				var quotaPeriod string
				err = json.Unmarshal(*v, &quotaPeriod)
				if err != nil {
					return err
				}
				p.QuotaPeriod = &quotaPeriod
			}
		case "isQuotaApplicable":
			if v != nil {
				var isQuotaApplicable bool
				err = json.Unmarshal(*v, &isQuotaApplicable)
				if err != nil {
					return err
				}
				p.IsQuotaApplicable = &isQuotaApplicable
			}
		case "properties":
			if v != nil {
				var properties interface{}
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				p.Properties = properties
			}
		}
	}

	return nil
}

// RequestDetails list of quota requests with details.
type RequestDetails struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Quota request ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Quota request name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type. "Microsoft.Quota/quotas".
	Type *string `json:"type,omitempty"`
	// RequestProperties - Quota request details.
	*RequestProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RequestDetails.
func (rd RequestDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rd.RequestProperties != nil {
		objectMap["properties"] = rd.RequestProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RequestDetails struct.
func (rd *RequestDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rd.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var requestProperties RequestProperties
				err = json.Unmarshal(*v, &requestProperties)
				if err != nil {
					return err
				}
				rd.RequestProperties = &requestProperties
			}
		}
	}

	return nil
}

// RequestDetailsList quota request information.
type RequestDetailsList struct {
	autorest.Response `json:"-"`
	// Value - Quota request details.
	Value *[]RequestDetails `json:"value,omitempty"`
	// NextLink - The URI for fetching the next page of quota limits. When there are no more pages, this string is null.
	NextLink *string `json:"nextLink,omitempty"`
}

// RequestDetailsListIterator provides access to a complete listing of RequestDetails values.
type RequestDetailsListIterator struct {
	i    int
	page RequestDetailsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RequestDetailsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RequestDetailsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RequestDetailsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RequestDetailsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RequestDetailsListIterator) Response() RequestDetailsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RequestDetailsListIterator) Value() RequestDetails {
	if !iter.page.NotDone() {
		return RequestDetails{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RequestDetailsListIterator type.
func NewRequestDetailsListIterator(page RequestDetailsListPage) RequestDetailsListIterator {
	return RequestDetailsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rdl RequestDetailsList) IsEmpty() bool {
	return rdl.Value == nil || len(*rdl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rdl RequestDetailsList) hasNextLink() bool {
	return rdl.NextLink != nil && len(*rdl.NextLink) != 0
}

// requestDetailsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rdl RequestDetailsList) requestDetailsListPreparer(ctx context.Context) (*http.Request, error) {
	if !rdl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rdl.NextLink)))
}

// RequestDetailsListPage contains a page of RequestDetails values.
type RequestDetailsListPage struct {
	fn  func(context.Context, RequestDetailsList) (RequestDetailsList, error)
	rdl RequestDetailsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RequestDetailsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RequestDetailsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rdl)
		if err != nil {
			return err
		}
		page.rdl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RequestDetailsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RequestDetailsListPage) NotDone() bool {
	return !page.rdl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RequestDetailsListPage) Response() RequestDetailsList {
	return page.rdl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RequestDetailsListPage) Values() []RequestDetails {
	if page.rdl.IsEmpty() {
		return nil
	}
	return *page.rdl.Value
}

// Creates a new instance of the RequestDetailsListPage type.
func NewRequestDetailsListPage(cur RequestDetailsList, getNextPage func(context.Context, RequestDetailsList) (RequestDetailsList, error)) RequestDetailsListPage {
	return RequestDetailsListPage{
		fn:  getNextPage,
		rdl: cur,
	}
}

// RequestOneResourceProperties quota request.
type RequestOneResourceProperties struct {
	// ProvisioningState - READ-ONLY; Quota request status. Possible values include: 'RequestStateAccepted', 'RequestStateInvalid', 'RequestStateSucceeded', 'RequestStateFailed', 'RequestStateInProgress'
	ProvisioningState RequestState `json:"provisioningState,omitempty"`
	// Message - READ-ONLY; User-friendly status message.
	Message *string `json:"message,omitempty"`
	// RequestSubmitTime - READ-ONLY; Quota request submission time. The date conforms to the following ISO 8601 standard format: yyyy-MM-ddTHH:mm:ssZ.
	RequestSubmitTime *date.Time `json:"requestSubmitTime,omitempty"`
	// Limit - Resource quota limit properties.
	Limit *LimitObject `json:"limit,omitempty"`
	// CurrentValue - READ-ONLY; Usage information for the current resource.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Unit -  The quota limit units, such as Count and Bytes. When requesting quota, use the **unit** value returned in the GET response in the request body of your PUT operation.
	Unit *string `json:"unit,omitempty"`
	// Name - Resource name provided by the resource provider. Use this property name when requesting quota.
	Name *ResourceName `json:"name,omitempty"`
	// ResourceType - Resource type name.
	ResourceType *string `json:"resourceType,omitempty"`
	// QuotaPeriod - READ-ONLY; The time period over which the quota usage values are summarized. For example:
	// *P1D (per one day)
	// *PT1M (per one minute)
	// *PT1S (per one second).
	// This parameter is optional because, for some resources like compute, the period is irrelevant.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
	// IsQuotaApplicable - READ-ONLY; States if quota can be requested for this resource.
	IsQuotaApplicable *bool `json:"isQuotaApplicable,omitempty"`
	// Error - Error details of the quota request.
	Error *ServiceErrorDetail `json:"error,omitempty"`
	// Properties - Additional properties for the specific resource provider.
	Properties interface{} `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RequestOneResourceProperties.
func (rorp RequestOneResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rorp.Limit != nil {
		objectMap["limit"] = rorp.Limit
	}
	if rorp.Unit != nil {
		objectMap["unit"] = rorp.Unit
	}
	if rorp.Name != nil {
		objectMap["name"] = rorp.Name
	}
	if rorp.ResourceType != nil {
		objectMap["resourceType"] = rorp.ResourceType
	}
	if rorp.Error != nil {
		objectMap["error"] = rorp.Error
	}
	if rorp.Properties != nil {
		objectMap["properties"] = rorp.Properties
	}
	return json.Marshal(objectMap)
}

// RequestOneResourceSubmitResponse quota request response.
type RequestOneResourceSubmitResponse struct {
	// ID - READ-ONLY; Quota request ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the quota request.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type. "Microsoft.Quota/ServiceLimitRequests"
	Type *string `json:"type,omitempty"`
	// RequestOneResourceProperties - Quota request details.
	*RequestOneResourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RequestOneResourceSubmitResponse.
func (rorsr RequestOneResourceSubmitResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rorsr.RequestOneResourceProperties != nil {
		objectMap["properties"] = rorsr.RequestOneResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RequestOneResourceSubmitResponse struct.
func (rorsr *RequestOneResourceSubmitResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rorsr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rorsr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rorsr.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var requestOneResourceProperties RequestOneResourceProperties
				err = json.Unmarshal(*v, &requestOneResourceProperties)
				if err != nil {
					return err
				}
				rorsr.RequestOneResourceProperties = &requestOneResourceProperties
			}
		}
	}

	return nil
}

// RequestProperties quota request properties.
type RequestProperties struct {
	// ProvisioningState - The quota request status. Possible values include: 'RequestStateAccepted', 'RequestStateInvalid', 'RequestStateSucceeded', 'RequestStateFailed', 'RequestStateInProgress'
	ProvisioningState RequestState `json:"provisioningState,omitempty"`
	// Message - READ-ONLY; User-friendly status message.
	Message *string `json:"message,omitempty"`
	// Error - Error details of the quota request.
	Error *ServiceErrorDetail `json:"error,omitempty"`
	// RequestSubmitTime - READ-ONLY; The quota request submission time. The date conforms to the following format specified by the ISO 8601 standard: yyyy-MM-ddTHH:mm:ssZ
	RequestSubmitTime *date.Time `json:"requestSubmitTime,omitempty"`
	// Value - Quota request details.
	Value *[]SubRequest `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for RequestProperties.
func (rp RequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.ProvisioningState != "" {
		objectMap["provisioningState"] = rp.ProvisioningState
	}
	if rp.Error != nil {
		objectMap["error"] = rp.Error
	}
	if rp.Value != nil {
		objectMap["value"] = rp.Value
	}
	return json.Marshal(objectMap)
}

// RequestStatusDetails quota request status details.
type RequestStatusDetails struct {
	// ProvisioningState - READ-ONLY; Quota request status. Possible values include: 'RequestStateAccepted', 'RequestStateInvalid', 'RequestStateSucceeded', 'RequestStateFailed', 'RequestStateInProgress'
	ProvisioningState RequestState `json:"provisioningState,omitempty"`
	// Message - READ-ONLY; User-friendly message.
	Message *string `json:"message,omitempty"`
	// Limit - Resource quota limit properties.
	Limit *LimitObject `json:"limit,omitempty"`
	// Unit -  The quota limit units, such as Count and Bytes. When requesting quota, use the **unit** value returned in the GET response in the request body of your PUT operation.
	Unit *string `json:"unit,omitempty"`
	// Name - Resource name provided by the resource provider. Use this property name when requesting quota.
	Name *ResourceName `json:"name,omitempty"`
	// ResourceType - Resource type name.
	ResourceType *string `json:"resourceType,omitempty"`
	// QuotaPeriod - READ-ONLY; The time period over which the quota usage values are summarized. For example:
	// *P1D (per one day)
	// *PT1M (per one minute)
	// *PT1S (per one second).
	// This parameter is optional because, for some resources like compute, the period is irrelevant.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
	// Properties - Additional properties for the specific resource provider.
	Properties interface{} `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RequestStatusDetails.
func (rsd RequestStatusDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rsd.Limit != nil {
		objectMap["limit"] = rsd.Limit
	}
	if rsd.Unit != nil {
		objectMap["unit"] = rsd.Unit
	}
	if rsd.Name != nil {
		objectMap["name"] = rsd.Name
	}
	if rsd.ResourceType != nil {
		objectMap["resourceType"] = rsd.ResourceType
	}
	if rsd.Properties != nil {
		objectMap["properties"] = rsd.Properties
	}
	return json.Marshal(objectMap)
}

// RequestSubmitResponse quota request response.
type RequestSubmitResponse struct {
	// ID - READ-ONLY; Quota request ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Quota request name.
	Name *string `json:"name,omitempty"`
	// Properties - Quota request details.
	Properties *RequestProperties `json:"properties,omitempty"`
	// Type - READ-ONLY; Resource type. "Microsoft.Quota/quotas".
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RequestSubmitResponse.
func (rsr RequestSubmitResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rsr.Properties != nil {
		objectMap["properties"] = rsr.Properties
	}
	return json.Marshal(objectMap)
}

// RequestSubmitResponse202 the quota request response with the quota request ID.
type RequestSubmitResponse202 struct {
	// ID - READ-ONLY; The quota request ID. To check the request status, use the **id** value in a [Quota Request Status](https://docs.microsoft.com/en-us/rest/api/reserved-vm-instances/quotarequeststatus/get) GET operation.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Operation ID.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// RequestStatusDetails - Quota request status.
	*RequestStatusDetails `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RequestSubmitResponse202.
func (rsr2 RequestSubmitResponse202) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rsr2.RequestStatusDetails != nil {
		objectMap["properties"] = rsr2.RequestStatusDetails
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RequestSubmitResponse202 struct.
func (rsr2 *RequestSubmitResponse202) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rsr2.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rsr2.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rsr2.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var requestStatusDetails RequestStatusDetails
				err = json.Unmarshal(*v, &requestStatusDetails)
				if err != nil {
					return err
				}
				rsr2.RequestStatusDetails = &requestStatusDetails
			}
		}
	}

	return nil
}

// ResourceName name of the resource provided by the resource Provider. When requesting quota, use this
// property name.
type ResourceName struct {
	// Value - Resource name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; Resource display name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceName.
func (rn ResourceName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rn.Value != nil {
		objectMap["value"] = rn.Value
	}
	return json.Marshal(objectMap)
}

// ServiceError API error details.
type ServiceError struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message.
	Message *string `json:"message,omitempty"`
	// Details - READ-ONLY; List of error details.
	Details *[]ServiceErrorDetail `json:"details,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceError.
func (se ServiceError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if se.Code != nil {
		objectMap["code"] = se.Code
	}
	if se.Message != nil {
		objectMap["message"] = se.Message
	}
	return json.Marshal(objectMap)
}

// ServiceErrorDetail error details.
type ServiceErrorDetail struct {
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error message.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceErrorDetail.
func (sed ServiceErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SubRequest request property.
type SubRequest struct {
	// Name - Resource name.
	Name *ResourceName `json:"name,omitempty"`
	// ResourceType - READ-ONLY; Resource type for which the quota properties were requested.
	ResourceType *string `json:"resourceType,omitempty"`
	// Unit -  Quota limit units, such as Count and Bytes. When requesting quota, use the **unit** value returned in the GET response in the request body of your PUT operation.
	Unit *string `json:"unit,omitempty"`
	// ProvisioningState - The quota request status. Possible values include: 'RequestStateAccepted', 'RequestStateInvalid', 'RequestStateSucceeded', 'RequestStateFailed', 'RequestStateInProgress'
	ProvisioningState RequestState `json:"provisioningState,omitempty"`
	// Message - READ-ONLY; User-friendly status message.
	Message *string `json:"message,omitempty"`
	// SubRequestID - READ-ONLY; Quota request ID.
	SubRequestID *string `json:"subRequestId,omitempty"`
	// Limit - Resource quota limit properties.
	Limit BasicLimitJSONObject `json:"limit,omitempty"`
}

// MarshalJSON is the custom marshaler for SubRequest.
func (sr SubRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Name != nil {
		objectMap["name"] = sr.Name
	}
	if sr.Unit != nil {
		objectMap["unit"] = sr.Unit
	}
	if sr.ProvisioningState != "" {
		objectMap["provisioningState"] = sr.ProvisioningState
	}
	objectMap["limit"] = sr.Limit
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubRequest struct.
func (sr *SubRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name ResourceName
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "resourceType":
			if v != nil {
				var resourceType string
				err = json.Unmarshal(*v, &resourceType)
				if err != nil {
					return err
				}
				sr.ResourceType = &resourceType
			}
		case "unit":
			if v != nil {
				var unit string
				err = json.Unmarshal(*v, &unit)
				if err != nil {
					return err
				}
				sr.Unit = &unit
			}
		case "provisioningState":
			if v != nil {
				var provisioningState RequestState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				sr.ProvisioningState = provisioningState
			}
		case "message":
			if v != nil {
				var message string
				err = json.Unmarshal(*v, &message)
				if err != nil {
					return err
				}
				sr.Message = &message
			}
		case "subRequestId":
			if v != nil {
				var subRequestID string
				err = json.Unmarshal(*v, &subRequestID)
				if err != nil {
					return err
				}
				sr.SubRequestID = &subRequestID
			}
		case "limit":
			if v != nil {
				limit, err := unmarshalBasicLimitJSONObject(*v)
				if err != nil {
					return err
				}
				sr.Limit = limit
			}
		}
	}

	return nil
}

// UpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (CurrentQuotaLimitBase, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UpdateFuture.Result.
func (future *UpdateFuture) result(client Client) (cqlb CurrentQuotaLimitBase, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "quota.UpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cqlb.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("quota.UpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cqlb.Response.Response, err = future.GetResult(sender); err == nil && cqlb.Response.Response.StatusCode != http.StatusNoContent {
		cqlb, err = client.UpdateResponder(cqlb.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "quota.UpdateFuture", "Result", cqlb.Response.Response, "Failure responding to request")
		}
	}
	return
}

// UsagesLimits quota limits.
type UsagesLimits struct {
	autorest.Response `json:"-"`
	// Value - List of quota limits.
	Value *[]CurrentUsagesBase `json:"value,omitempty"`
	// NextLink - The URI used to fetch the next page of quota limits. When there are no more pages, this is null.
	NextLink *string `json:"nextLink,omitempty"`
}

// UsagesLimitsIterator provides access to a complete listing of CurrentUsagesBase values.
type UsagesLimitsIterator struct {
	i    int
	page UsagesLimitsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UsagesLimitsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsagesLimitsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UsagesLimitsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UsagesLimitsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UsagesLimitsIterator) Response() UsagesLimits {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UsagesLimitsIterator) Value() CurrentUsagesBase {
	if !iter.page.NotDone() {
		return CurrentUsagesBase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UsagesLimitsIterator type.
func NewUsagesLimitsIterator(page UsagesLimitsPage) UsagesLimitsIterator {
	return UsagesLimitsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ul UsagesLimits) IsEmpty() bool {
	return ul.Value == nil || len(*ul.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ul UsagesLimits) hasNextLink() bool {
	return ul.NextLink != nil && len(*ul.NextLink) != 0
}

// usagesLimitsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ul UsagesLimits) usagesLimitsPreparer(ctx context.Context) (*http.Request, error) {
	if !ul.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ul.NextLink)))
}

// UsagesLimitsPage contains a page of CurrentUsagesBase values.
type UsagesLimitsPage struct {
	fn func(context.Context, UsagesLimits) (UsagesLimits, error)
	ul UsagesLimits
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UsagesLimitsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsagesLimitsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ul)
		if err != nil {
			return err
		}
		page.ul = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UsagesLimitsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UsagesLimitsPage) NotDone() bool {
	return !page.ul.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UsagesLimitsPage) Response() UsagesLimits {
	return page.ul
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UsagesLimitsPage) Values() []CurrentUsagesBase {
	if page.ul.IsEmpty() {
		return nil
	}
	return *page.ul.Value
}

// Creates a new instance of the UsagesLimitsPage type.
func NewUsagesLimitsPage(cur UsagesLimits, getNextPage func(context.Context, UsagesLimits) (UsagesLimits, error)) UsagesLimitsPage {
	return UsagesLimitsPage{
		fn: getNextPage,
		ul: cur,
	}
}

// UsagesObject the resource usages value.
type UsagesObject struct {
	// Value - The usages value.
	Value *int32 `json:"value,omitempty"`
	// UsagesType - Possible values include: 'UsagesTypesIndividual', 'UsagesTypesCombined'
	UsagesType UsagesTypes `json:"usagesType,omitempty"`
}

// UsagesProperties usage properties for the specified resource.
type UsagesProperties struct {
	// Usages - The quota limit properties for this resource.
	Usages *UsagesObject `json:"usages,omitempty"`
	// Unit - READ-ONLY;  The units for the quota usage, such as Count and Bytes. When requesting quota, use the **unit** value returned in the GET response in the request body of your PUT operation.
	Unit *string `json:"unit,omitempty"`
	// Name - Resource name provided by the resource provider. Use this property name when requesting quota.
	Name *ResourceName `json:"name,omitempty"`
	// ResourceType - The name of the resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// QuotaPeriod - READ-ONLY; The time period for the summary of the quota usage values. For example:
	// *P1D (per one day)
	// *PT1M (per one minute)
	// *PT1S (per one second).
	// This parameter is optional because it is not relevant for all resources such as compute.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
	// IsQuotaApplicable - READ-ONLY; States if quota can be requested for this resource.
	IsQuotaApplicable *bool `json:"isQuotaApplicable,omitempty"`
	// Properties - Additional properties for the specific resource provider.
	Properties interface{} `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UsagesProperties.
func (up UsagesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if up.Usages != nil {
		objectMap["usages"] = up.Usages
	}
	if up.Name != nil {
		objectMap["name"] = up.Name
	}
	if up.ResourceType != nil {
		objectMap["resourceType"] = up.ResourceType
	}
	if up.Properties != nil {
		objectMap["properties"] = up.Properties
	}
	return json.Marshal(objectMap)
}
