package quantum

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/quantum/mgmt/2019-11-04-preview/quantum"

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CheckNameAvailabilityParameters details of check name availability request body.
type CheckNameAvailabilityParameters struct {
	// Name - Name for checking availability.
	Name *string `json:"name,omitempty"`
	// Type - The resource type of Quantum Workspace.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResult result of check name availability.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - Indicator of availability of the Quantum Workspace resource name.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason of unavailability.
	Reason *string `json:"reason,omitempty"`
	// Message - READ-ONLY; The detailed info regarding the reason associated with the Namespace.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckNameAvailabilityResult.
func (cnar CheckNameAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cnar.NameAvailable != nil {
		objectMap["nameAvailable"] = cnar.NameAvailable
	}
	if cnar.Reason != nil {
		objectMap["reason"] = cnar.Reason
	}
	return json.Marshal(objectMap)
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// OfferingsListResult the response of a list Providers operation.
type OfferingsListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of a list Providers operation.
	Value *[]ProviderDescription `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of Providers.
	NextLink *string `json:"nextLink,omitempty"`
}

// OfferingsListResultIterator provides access to a complete listing of ProviderDescription values.
type OfferingsListResultIterator struct {
	i    int
	page OfferingsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OfferingsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OfferingsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OfferingsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OfferingsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OfferingsListResultIterator) Response() OfferingsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OfferingsListResultIterator) Value() ProviderDescription {
	if !iter.page.NotDone() {
		return ProviderDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OfferingsListResultIterator type.
func NewOfferingsListResultIterator(page OfferingsListResultPage) OfferingsListResultIterator {
	return OfferingsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OfferingsListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OfferingsListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// offeringsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OfferingsListResult) offeringsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OfferingsListResultPage contains a page of ProviderDescription values.
type OfferingsListResultPage struct {
	fn  func(context.Context, OfferingsListResult) (OfferingsListResult, error)
	olr OfferingsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OfferingsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OfferingsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OfferingsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OfferingsListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OfferingsListResultPage) Response() OfferingsListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OfferingsListResultPage) Values() []ProviderDescription {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OfferingsListResultPage type.
func NewOfferingsListResultPage(cur OfferingsListResult, getNextPage func(context.Context, OfferingsListResult) (OfferingsListResult, error)) OfferingsListResultPage {
	return OfferingsListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// Operation operation provided by provider
type Operation struct {
	// Name - Name of the operation
	Name *string `json:"name,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - Properties of the operation
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay properties of the operation
type OperationDisplay struct {
	// Provider - Provider name
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource name
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation name
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation
	Description *string `json:"description,omitempty"`
}

// OperationsList lists the operations available.
type OperationsList struct {
	autorest.Response `json:"-"`
	// NextLink - Url to follow for getting next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of operations
	Value *[]Operation `json:"value,omitempty"`
}

// OperationsListIterator provides access to a complete listing of Operation values.
type OperationsListIterator struct {
	i    int
	page OperationsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationsListIterator) Response() OperationsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationsListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationsListIterator type.
func NewOperationsListIterator(page OperationsListPage) OperationsListIterator {
	return OperationsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationsList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationsList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationsList) operationsListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationsListPage contains a page of Operation values.
type OperationsListPage struct {
	fn func(context.Context, OperationsList) (OperationsList, error)
	ol OperationsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationsListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationsListPage) Response() OperationsList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationsListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationsListPage type.
func NewOperationsListPage(cur OperationsList, getNextPage func(context.Context, OperationsList) (OperationsList, error)) OperationsListPage {
	return OperationsListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// PricingDetail detailed pricing information for an sku.
type PricingDetail struct {
	// ID - Unique id for this pricing information.
	ID *string `json:"id,omitempty"`
	// Value - The unit cost of this sku.
	Value *string `json:"value,omitempty"`
}

// PricingDimension information about pricing dimension.
type PricingDimension struct {
	// ID - Unique id of this pricing dimension.
	ID *string `json:"id,omitempty"`
	// Name - The display name of this pricing dimension.
	Name *string `json:"name,omitempty"`
}

// Provider information about a Provider. A Provider is an entity that offers Targets to run Azure Quantum
// Jobs.
type Provider struct {
	// ProviderID - Unique id of this provider.
	ProviderID *string `json:"providerId,omitempty"`
	// ProviderSku - The sku associated with pricing information for this provider.
	ProviderSku *string `json:"providerSku,omitempty"`
	// InstanceURI - A Uri identifying the specific instance of this provider.
	InstanceURI *string `json:"instanceUri,omitempty"`
	// ApplicationName - The provider's marketplace application display name.
	ApplicationName *string `json:"applicationName,omitempty"`
	// ProvisioningState - Provisioning status field. Possible values include: 'StatusSucceeded', 'StatusLaunching', 'StatusUpdating', 'StatusDeleting', 'StatusDeleted', 'StatusFailed'
	ProvisioningState Status `json:"provisioningState,omitempty"`
	// ResourceUsageID - Id to track resource usage for the provider.
	ResourceUsageID *string `json:"resourceUsageId,omitempty"`
}

// ProviderDescription information about an offering. A provider offering is an entity that offers Targets
// to run Azure Quantum Jobs.
type ProviderDescription struct {
	// ID - Unique provider's id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Provider's display name.
	Name *string `json:"name,omitempty"`
	// Properties - A list of provider-specific properties.
	Properties *ProviderProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ProviderDescription.
func (pd ProviderDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pd.ID != nil {
		objectMap["id"] = pd.ID
	}
	if pd.Properties != nil {
		objectMap["properties"] = pd.Properties
	}
	return json.Marshal(objectMap)
}

// ProviderProperties provider properties.
type ProviderProperties struct {
	// Description - READ-ONLY; A description about this provider.
	Description *string `json:"description,omitempty"`
	// ProviderType - READ-ONLY; Provider type.
	ProviderType *string `json:"providerType,omitempty"`
	// Company - READ-ONLY; Company name.
	Company *string `json:"company,omitempty"`
	// DefaultEndpoint - READ-ONLY; Provider's default endpoint.
	DefaultEndpoint *string `json:"defaultEndpoint,omitempty"`
	// Aad - Azure Active Directory info.
	Aad *ProviderPropertiesAad `json:"aad,omitempty"`
	// ManagedApplication - Provider's Managed-Application info
	ManagedApplication *ProviderPropertiesManagedApplication `json:"managedApplication,omitempty"`
	// Targets - The list of targets available from this provider.
	Targets *[]TargetDescription `json:"targets,omitempty"`
	// Skus - The list of skus available from this provider.
	Skus *[]SkuDescription `json:"skus,omitempty"`
	// QuotaDimensions - The list of quota dimensions from the provider.
	QuotaDimensions *[]QuotaDimension `json:"quotaDimensions,omitempty"`
	// PricingDimensions - The list of pricing dimensions from the provider.
	PricingDimensions *[]PricingDimension `json:"pricingDimensions,omitempty"`
}

// MarshalJSON is the custom marshaler for ProviderProperties.
func (pp ProviderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.Aad != nil {
		objectMap["aad"] = pp.Aad
	}
	if pp.ManagedApplication != nil {
		objectMap["managedApplication"] = pp.ManagedApplication
	}
	if pp.Targets != nil {
		objectMap["targets"] = pp.Targets
	}
	if pp.Skus != nil {
		objectMap["skus"] = pp.Skus
	}
	if pp.QuotaDimensions != nil {
		objectMap["quotaDimensions"] = pp.QuotaDimensions
	}
	if pp.PricingDimensions != nil {
		objectMap["pricingDimensions"] = pp.PricingDimensions
	}
	return json.Marshal(objectMap)
}

// ProviderPropertiesAad azure Active Directory info.
type ProviderPropertiesAad struct {
	// ApplicationID - READ-ONLY; Provider's application id.
	ApplicationID *string `json:"applicationId,omitempty"`
	// TenantID - READ-ONLY; Provider's tenant id.
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for ProviderPropertiesAad.
func (pp ProviderPropertiesAad) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ProviderPropertiesManagedApplication provider's Managed-Application info
type ProviderPropertiesManagedApplication struct {
	// PublisherID - READ-ONLY; Provider's publisher id.
	PublisherID *string `json:"publisherId,omitempty"`
	// OfferID - READ-ONLY; Provider's offer id.
	OfferID *string `json:"offerId,omitempty"`
}

// MarshalJSON is the custom marshaler for ProviderPropertiesManagedApplication.
func (ppA ProviderPropertiesManagedApplication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// QuotaDimension information about a specific quota dimension.
type QuotaDimension struct {
	// ID - Unique id of this dimension.
	ID *string `json:"id,omitempty"`
	// Scope - The scope of this quota dimension.
	Scope *string `json:"scope,omitempty"`
	// Period - The reset period of this quota dimension.
	Period *string `json:"period,omitempty"`
	// Quota - The max limit of this dimension.
	Quota *float64 `json:"quota,omitempty"`
	// Name - The display name of this quota dimension.
	Name *string `json:"name,omitempty"`
	// Description - A description about this quota dimension.
	Description *string `json:"description,omitempty"`
	// Unit - The standard unit of measurement used for this quota dimension.
	Unit *string `json:"unit,omitempty"`
	// UnitPlural - The standard unit of measurement used for this quota dimension in plural form.
	UnitPlural *string `json:"unitPlural,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SkuDescription information about a specific sku.
type SkuDescription struct {
	// ID - Unique sku id.
	ID *string `json:"id,omitempty"`
	// Name - Display name of this sku.
	Name *string `json:"name,omitempty"`
	// Version - Display name of this sku.
	Version *string `json:"version,omitempty"`
	// Description - Description about this sku.
	Description *string `json:"description,omitempty"`
	// RestrictedAccessURI - Uri to subscribe to the restricted access sku.
	RestrictedAccessURI *string `json:"restrictedAccessUri,omitempty"`
	// Targets - The list of targets available for this sku.
	Targets *[]string `json:"targets,omitempty"`
	// QuotaDimensions - The list of quota dimensions for this sku.
	QuotaDimensions *[]QuotaDimension `json:"quotaDimensions,omitempty"`
	// PricingDetails - The list of pricing details for the sku.
	PricingDetails *[]PricingDetail `json:"pricingDetails,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TagsObject tags object for patch operations.
type TagsObject struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsObject.
func (toVar TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if toVar.Tags != nil {
		objectMap["tags"] = toVar.Tags
	}
	return json.Marshal(objectMap)
}

// TargetDescription information about a Target. A target is the component that can process a specific type
// of Job.
type TargetDescription struct {
	// ID - Unique target id.
	ID *string `json:"id,omitempty"`
	// Name - Display name of this target.
	Name *string `json:"name,omitempty"`
	// Description - A description about this target.
	Description *string `json:"description,omitempty"`
	// AcceptedDataFormats - List of data formats accepted by this target.
	AcceptedDataFormats *[]string `json:"acceptedDataFormats,omitempty"`
	// AcceptedContentEncodings - List of content encodings accepted by this target.
	AcceptedContentEncodings *[]string `json:"acceptedContentEncodings,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// Workspace the resource proxy definition object for quantum workspace.
type Workspace struct {
	autorest.Response `json:"-"`
	// WorkspaceResourceProperties - Gets or sets the properties. Define quantum workspace's specific properties.
	*WorkspaceResourceProperties `json:"properties,omitempty"`
	// Identity - Managed Identity information.
	Identity *WorkspaceIdentity `json:"identity,omitempty"`
	// SystemData - READ-ONLY; System metadata
	SystemData *SystemData `json:"systemData,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WorkspaceResourceProperties != nil {
		objectMap["properties"] = w.WorkspaceResourceProperties
	}
	if w.Identity != nil {
		objectMap["identity"] = w.Identity
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workspace struct.
func (w *Workspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceResourceProperties WorkspaceResourceProperties
				err = json.Unmarshal(*v, &workspaceResourceProperties)
				if err != nil {
					return err
				}
				w.WorkspaceResourceProperties = &workspaceResourceProperties
			}
		case "identity":
			if v != nil {
				var identity WorkspaceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				w.Identity = &identity
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				w.SystemData = &systemData
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkspaceIdentity managed Identity information.
type WorkspaceIdentity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'SystemAssigned', 'None'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceIdentity.
func (w WorkspaceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.Type != "" {
		objectMap["type"] = w.Type
	}
	return json.Marshal(objectMap)
}

// WorkspaceListResult the response of a list Workspaces operation.
type WorkspaceListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of a list Workspaces operation.
	Value *[]Workspace `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of Workspaces.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkspaceListResultIterator provides access to a complete listing of Workspace values.
type WorkspaceListResultIterator struct {
	i    int
	page WorkspaceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkspaceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkspaceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkspaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkspaceListResultIterator) Response() WorkspaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkspaceListResultIterator) Value() Workspace {
	if !iter.page.NotDone() {
		return Workspace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkspaceListResultIterator type.
func NewWorkspaceListResultIterator(page WorkspaceListResultPage) WorkspaceListResultIterator {
	return WorkspaceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wlr WorkspaceListResult) IsEmpty() bool {
	return wlr.Value == nil || len(*wlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wlr WorkspaceListResult) hasNextLink() bool {
	return wlr.NextLink != nil && len(*wlr.NextLink) != 0
}

// workspaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wlr WorkspaceListResult) workspaceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wlr.NextLink)))
}

// WorkspaceListResultPage contains a page of Workspace values.
type WorkspaceListResultPage struct {
	fn  func(context.Context, WorkspaceListResult) (WorkspaceListResult, error)
	wlr WorkspaceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkspaceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wlr)
		if err != nil {
			return err
		}
		page.wlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkspaceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkspaceListResultPage) NotDone() bool {
	return !page.wlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkspaceListResultPage) Response() WorkspaceListResult {
	return page.wlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkspaceListResultPage) Values() []Workspace {
	if page.wlr.IsEmpty() {
		return nil
	}
	return *page.wlr.Value
}

// Creates a new instance of the WorkspaceListResultPage type.
func NewWorkspaceListResultPage(cur WorkspaceListResult, getNextPage func(context.Context, WorkspaceListResult) (WorkspaceListResult, error)) WorkspaceListResultPage {
	return WorkspaceListResultPage{
		fn:  getNextPage,
		wlr: cur,
	}
}

// WorkspaceResourceProperties properties of a Workspace
type WorkspaceResourceProperties struct {
	// Providers - List of Providers selected for this Workspace
	Providers *[]Provider `json:"providers,omitempty"`
	// Usable - READ-ONLY; Whether the current workspace is ready to accept Jobs. Possible values include: 'Yes', 'No', 'Partial'
	Usable UsableStatus `json:"usable,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status field. Possible values include: 'Succeeded', 'ProviderLaunching', 'ProviderUpdating', 'ProviderDeleting', 'ProviderProvisioning', 'Failed'
	ProvisioningState ProvisioningStatus `json:"provisioningState,omitempty"`
	// StorageAccount - ARM Resource Id of the storage account associated with this workspace.
	StorageAccount *string `json:"storageAccount,omitempty"`
	// EndpointURI - READ-ONLY; The URI of the workspace endpoint.
	EndpointURI *string `json:"endpointUri,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceResourceProperties.
func (wrp WorkspaceResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wrp.Providers != nil {
		objectMap["providers"] = wrp.Providers
	}
	if wrp.StorageAccount != nil {
		objectMap["storageAccount"] = wrp.StorageAccount
	}
	return json.Marshal(objectMap)
}

// WorkspacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspacesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (Workspace, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesCreateOrUpdateFuture.Result.
func (future *WorkspacesCreateOrUpdateFuture) result(client WorkspacesClient) (w Workspace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "quantum.WorkspacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		w.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("quantum.WorkspacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.CreateOrUpdateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "quantum.WorkspacesCreateOrUpdateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WorkspacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WorkspacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WorkspacesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WorkspacesDeleteFuture.Result.
func (future *WorkspacesDeleteFuture) result(client WorkspacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "quantum.WorkspacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("quantum.WorkspacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}
