package synapse

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// KustoPoolAttachedDatabaseConfigurationsClient is the azure Synapse Analytics Management Client
type KustoPoolAttachedDatabaseConfigurationsClient struct {
	BaseClient
}

// NewKustoPoolAttachedDatabaseConfigurationsClient creates an instance of the
// KustoPoolAttachedDatabaseConfigurationsClient client.
func NewKustoPoolAttachedDatabaseConfigurationsClient(subscriptionID string) KustoPoolAttachedDatabaseConfigurationsClient {
	return NewKustoPoolAttachedDatabaseConfigurationsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewKustoPoolAttachedDatabaseConfigurationsClientWithBaseURI creates an instance of the
// KustoPoolAttachedDatabaseConfigurationsClient client using a custom endpoint.  Use this when interacting with an
// Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewKustoPoolAttachedDatabaseConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) KustoPoolAttachedDatabaseConfigurationsClient {
	return KustoPoolAttachedDatabaseConfigurationsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate creates or updates an attached database configuration.
// Parameters:
// workspaceName - the name of the workspace
// kustoPoolName - the name of the Kusto pool.
// attachedDatabaseConfigurationName - the name of the attached database configuration.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// parameters - the database parameters supplied to the CreateOrUpdate operation.
func (client KustoPoolAttachedDatabaseConfigurationsClient) CreateOrUpdate(ctx context.Context, workspaceName string, kustoPoolName string, attachedDatabaseConfigurationName string, resourceGroupName string, parameters AttachedDatabaseConfiguration) (result KustoPoolAttachedDatabaseConfigurationsCreateOrUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolAttachedDatabaseConfigurationsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.AttachedDatabaseConfigurationProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.AttachedDatabaseConfigurationProperties.DatabaseName", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.AttachedDatabaseConfigurationProperties.KustoPoolResourceID", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolAttachedDatabaseConfigurationsClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, workspaceName, kustoPoolName, attachedDatabaseConfigurationName, resourceGroupName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolAttachedDatabaseConfigurationsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolAttachedDatabaseConfigurationsClient", "CreateOrUpdate", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client KustoPoolAttachedDatabaseConfigurationsClient) CreateOrUpdatePreparer(ctx context.Context, workspaceName string, kustoPoolName string, attachedDatabaseConfigurationName string, resourceGroupName string, parameters AttachedDatabaseConfiguration) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"attachedDatabaseConfigurationName": autorest.Encode("path", attachedDatabaseConfigurationName),
		"kustoPoolName":                     autorest.Encode("path", kustoPoolName),
		"resourceGroupName":                 autorest.Encode("path", resourceGroupName),
		"subscriptionId":                    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":                     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.SystemData = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/attachedDatabaseConfigurations/{attachedDatabaseConfigurationName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolAttachedDatabaseConfigurationsClient) CreateOrUpdateSender(req *http.Request) (future KustoPoolAttachedDatabaseConfigurationsCreateOrUpdateFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client KustoPoolAttachedDatabaseConfigurationsClient) CreateOrUpdateResponder(resp *http.Response) (result AttachedDatabaseConfiguration, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes the attached database configuration with the given name.
// Parameters:
// workspaceName - the name of the workspace
// kustoPoolName - the name of the Kusto pool.
// attachedDatabaseConfigurationName - the name of the attached database configuration.
// resourceGroupName - the name of the resource group. The name is case insensitive.
func (client KustoPoolAttachedDatabaseConfigurationsClient) Delete(ctx context.Context, workspaceName string, kustoPoolName string, attachedDatabaseConfigurationName string, resourceGroupName string) (result KustoPoolAttachedDatabaseConfigurationsDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolAttachedDatabaseConfigurationsClient.Delete")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolAttachedDatabaseConfigurationsClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, workspaceName, kustoPoolName, attachedDatabaseConfigurationName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolAttachedDatabaseConfigurationsClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolAttachedDatabaseConfigurationsClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client KustoPoolAttachedDatabaseConfigurationsClient) DeletePreparer(ctx context.Context, workspaceName string, kustoPoolName string, attachedDatabaseConfigurationName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"attachedDatabaseConfigurationName": autorest.Encode("path", attachedDatabaseConfigurationName),
		"kustoPoolName":                     autorest.Encode("path", kustoPoolName),
		"resourceGroupName":                 autorest.Encode("path", resourceGroupName),
		"subscriptionId":                    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":                     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/attachedDatabaseConfigurations/{attachedDatabaseConfigurationName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolAttachedDatabaseConfigurationsClient) DeleteSender(req *http.Request) (future KustoPoolAttachedDatabaseConfigurationsDeleteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client KustoPoolAttachedDatabaseConfigurationsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get returns an attached database configuration.
// Parameters:
// workspaceName - the name of the workspace
// kustoPoolName - the name of the Kusto pool.
// attachedDatabaseConfigurationName - the name of the attached database configuration.
// resourceGroupName - the name of the resource group. The name is case insensitive.
func (client KustoPoolAttachedDatabaseConfigurationsClient) Get(ctx context.Context, workspaceName string, kustoPoolName string, attachedDatabaseConfigurationName string, resourceGroupName string) (result AttachedDatabaseConfiguration, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolAttachedDatabaseConfigurationsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolAttachedDatabaseConfigurationsClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, workspaceName, kustoPoolName, attachedDatabaseConfigurationName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolAttachedDatabaseConfigurationsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolAttachedDatabaseConfigurationsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolAttachedDatabaseConfigurationsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client KustoPoolAttachedDatabaseConfigurationsClient) GetPreparer(ctx context.Context, workspaceName string, kustoPoolName string, attachedDatabaseConfigurationName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"attachedDatabaseConfigurationName": autorest.Encode("path", attachedDatabaseConfigurationName),
		"kustoPoolName":                     autorest.Encode("path", kustoPoolName),
		"resourceGroupName":                 autorest.Encode("path", resourceGroupName),
		"subscriptionId":                    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":                     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/attachedDatabaseConfigurations/{attachedDatabaseConfigurationName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolAttachedDatabaseConfigurationsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client KustoPoolAttachedDatabaseConfigurationsClient) GetResponder(resp *http.Response) (result AttachedDatabaseConfiguration, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByKustoPool returns the list of attached database configurations of the given Kusto Pool.
// Parameters:
// workspaceName - the name of the workspace
// kustoPoolName - the name of the Kusto pool.
// resourceGroupName - the name of the resource group. The name is case insensitive.
func (client KustoPoolAttachedDatabaseConfigurationsClient) ListByKustoPool(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string) (result AttachedDatabaseConfigurationListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KustoPoolAttachedDatabaseConfigurationsClient.ListByKustoPool")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("synapse.KustoPoolAttachedDatabaseConfigurationsClient", "ListByKustoPool", err.Error())
	}

	req, err := client.ListByKustoPoolPreparer(ctx, workspaceName, kustoPoolName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolAttachedDatabaseConfigurationsClient", "ListByKustoPool", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByKustoPoolSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolAttachedDatabaseConfigurationsClient", "ListByKustoPool", resp, "Failure sending request")
		return
	}

	result, err = client.ListByKustoPoolResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "synapse.KustoPoolAttachedDatabaseConfigurationsClient", "ListByKustoPool", resp, "Failure responding to request")
		return
	}

	return
}

// ListByKustoPoolPreparer prepares the ListByKustoPool request.
func (client KustoPoolAttachedDatabaseConfigurationsClient) ListByKustoPoolPreparer(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"kustoPoolName":     autorest.Encode("path", kustoPoolName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/attachedDatabaseConfigurations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByKustoPoolSender sends the ListByKustoPool request. The method will close the
// http.Response Body if it receives an error.
func (client KustoPoolAttachedDatabaseConfigurationsClient) ListByKustoPoolSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByKustoPoolResponder handles the response to the ListByKustoPool request. The method always
// closes the http.Response Body.
func (client KustoPoolAttachedDatabaseConfigurationsClient) ListByKustoPoolResponder(resp *http.Response) (result AttachedDatabaseConfigurationListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
