package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveTbAliyunUserMappingByTbUid invokes the cloudcallcenter.RemoveTbAliyunUserMappingByTbUid API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removetbaliyunusermappingbytbuid.html
func (client *Client) RemoveTbAliyunUserMappingByTbUid(request *RemoveTbAliyunUserMappingByTbUidRequest) (response *RemoveTbAliyunUserMappingByTbUidResponse, err error) {
	response = CreateRemoveTbAliyunUserMappingByTbUidResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveTbAliyunUserMappingByTbUidWithChan invokes the cloudcallcenter.RemoveTbAliyunUserMappingByTbUid API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removetbaliyunusermappingbytbuid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveTbAliyunUserMappingByTbUidWithChan(request *RemoveTbAliyunUserMappingByTbUidRequest) (<-chan *RemoveTbAliyunUserMappingByTbUidResponse, <-chan error) {
	responseChan := make(chan *RemoveTbAliyunUserMappingByTbUidResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveTbAliyunUserMappingByTbUid(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveTbAliyunUserMappingByTbUidWithCallback invokes the cloudcallcenter.RemoveTbAliyunUserMappingByTbUid API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removetbaliyunusermappingbytbuid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveTbAliyunUserMappingByTbUidWithCallback(request *RemoveTbAliyunUserMappingByTbUidRequest, callback func(response *RemoveTbAliyunUserMappingByTbUidResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveTbAliyunUserMappingByTbUidResponse
		var err error
		defer close(result)
		response, err = client.RemoveTbAliyunUserMappingByTbUid(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveTbAliyunUserMappingByTbUidRequest is the request struct for api RemoveTbAliyunUserMappingByTbUid
type RemoveTbAliyunUserMappingByTbUidRequest struct {
	*requests.RpcRequest
	TbUserid requests.Integer `position:"Query" name:"TbUserid"`
}

// RemoveTbAliyunUserMappingByTbUidResponse is the response struct for api RemoveTbAliyunUserMappingByTbUid
type RemoveTbAliyunUserMappingByTbUidResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateRemoveTbAliyunUserMappingByTbUidRequest creates a request to invoke RemoveTbAliyunUserMappingByTbUid API
func CreateRemoveTbAliyunUserMappingByTbUidRequest() (request *RemoveTbAliyunUserMappingByTbUidRequest) {
	request = &RemoveTbAliyunUserMappingByTbUidRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "RemoveTbAliyunUserMappingByTbUid", "", "")
	request.Method = requests.POST
	return
}

// CreateRemoveTbAliyunUserMappingByTbUidResponse creates a response to parse from RemoveTbAliyunUserMappingByTbUid response
func CreateRemoveTbAliyunUserMappingByTbUidResponse() (response *RemoveTbAliyunUserMappingByTbUidResponse) {
	response = &RemoveTbAliyunUserMappingByTbUidResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
