package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OemFlowrateOverview invokes the cloudwf.OemFlowrateOverview API synchronously
// api document: https://help.aliyun.com/api/cloudwf/oemflowrateoverview.html
func (client *Client) OemFlowrateOverview(request *OemFlowrateOverviewRequest) (response *OemFlowrateOverviewResponse, err error) {
	response = CreateOemFlowrateOverviewResponse()
	err = client.DoAction(request, response)
	return
}

// OemFlowrateOverviewWithChan invokes the cloudwf.OemFlowrateOverview API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemflowrateoverview.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemFlowrateOverviewWithChan(request *OemFlowrateOverviewRequest) (<-chan *OemFlowrateOverviewResponse, <-chan error) {
	responseChan := make(chan *OemFlowrateOverviewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OemFlowrateOverview(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OemFlowrateOverviewWithCallback invokes the cloudwf.OemFlowrateOverview API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemflowrateoverview.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemFlowrateOverviewWithCallback(request *OemFlowrateOverviewRequest, callback func(response *OemFlowrateOverviewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OemFlowrateOverviewResponse
		var err error
		defer close(result)
		response, err = client.OemFlowrateOverview(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OemFlowrateOverviewRequest is the request struct for api OemFlowrateOverview
type OemFlowrateOverviewRequest struct {
	*requests.RpcRequest
	Bid requests.Integer `position:"Query" name:"Bid"`
}

// OemFlowrateOverviewResponse is the response struct for api OemFlowrateOverview
type OemFlowrateOverviewResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateOemFlowrateOverviewRequest creates a request to invoke OemFlowrateOverview API
func CreateOemFlowrateOverviewRequest() (request *OemFlowrateOverviewRequest) {
	request = &OemFlowrateOverviewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "OemFlowrateOverview", "cloudwf", "openAPI")
	return
}

// CreateOemFlowrateOverviewResponse creates a response to parse from OemFlowrateOverview response
func CreateOemFlowrateOverviewResponse() (response *OemFlowrateOverviewResponse) {
	response = &OemFlowrateOverviewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
