package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShopUpdate invokes the cloudwf.ShopUpdate API synchronously
// api document: https://help.aliyun.com/api/cloudwf/shopupdate.html
func (client *Client) ShopUpdate(request *ShopUpdateRequest) (response *ShopUpdateResponse, err error) {
	response = CreateShopUpdateResponse()
	err = client.DoAction(request, response)
	return
}

// ShopUpdateWithChan invokes the cloudwf.ShopUpdate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopupdate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopUpdateWithChan(request *ShopUpdateRequest) (<-chan *ShopUpdateResponse, <-chan error) {
	responseChan := make(chan *ShopUpdateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShopUpdate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShopUpdateWithCallback invokes the cloudwf.ShopUpdate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopupdate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopUpdateWithCallback(request *ShopUpdateRequest, callback func(response *ShopUpdateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShopUpdateResponse
		var err error
		defer close(result)
		response, err = client.ShopUpdate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShopUpdateRequest is the request struct for api ShopUpdate
type ShopUpdateRequest struct {
	*requests.RpcRequest
	ShopCoordinate    string           `position:"Query" name:"ShopCoordinate"`
	ShopProvince      string           `position:"Query" name:"ShopProvince"`
	ShopTopType       requests.Integer `position:"Query" name:"ShopTopType"`
	ShopAddress       string           `position:"Query" name:"ShopAddress"`
	ShopType          requests.Integer `position:"Query" name:"ShopType"`
	WarnEmail         string           `position:"Query" name:"WarnEmail"`
	Sid               requests.Integer `position:"Query" name:"Sid"`
	ShopTel           string           `position:"Query" name:"ShopTel"`
	WarnpHone         string           `position:"Query" name:"WarnpHone"`
	Warn              requests.Integer `position:"Query" name:"Warn"`
	ShopArea          requests.Integer `position:"Query" name:"ShopArea"`
	ShopRemarks       string           `position:"Query" name:"ShopRemarks"`
	ShopCity          string           `position:"Query" name:"ShopCity"`
	ShopSubtype       requests.Integer `position:"Query" name:"ShopSubtype"`
	ShopBrand         string           `position:"Query" name:"ShopBrand"`
	ShopName          string           `position:"Query" name:"ShopName"`
	ShopCloseWarn     requests.Integer `position:"Query" name:"ShopCloseWarn"`
	ShopManager       string           `position:"Query" name:"ShopManager"`
	ShopBusinessHours string           `position:"Query" name:"ShopBusinessHours"`
}

// ShopUpdateResponse is the response struct for api ShopUpdate
type ShopUpdateResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateShopUpdateRequest creates a request to invoke ShopUpdate API
func CreateShopUpdateRequest() (request *ShopUpdateRequest) {
	request = &ShopUpdateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ShopUpdate", "cloudwf", "openAPI")
	return
}

// CreateShopUpdateResponse creates a response to parse from ShopUpdate response
func CreateShopUpdateResponse() (response *ShopUpdateResponse) {
	response = &ShopUpdateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
