package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchMetaTables invokes the dataworks_public.SearchMetaTables API synchronously
func (client *Client) SearchMetaTables(request *SearchMetaTablesRequest) (response *SearchMetaTablesResponse, err error) {
	response = CreateSearchMetaTablesResponse()
	err = client.DoAction(request, response)
	return
}

// SearchMetaTablesWithChan invokes the dataworks_public.SearchMetaTables API asynchronously
func (client *Client) SearchMetaTablesWithChan(request *SearchMetaTablesRequest) (<-chan *SearchMetaTablesResponse, <-chan error) {
	responseChan := make(chan *SearchMetaTablesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchMetaTables(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchMetaTablesWithCallback invokes the dataworks_public.SearchMetaTables API asynchronously
func (client *Client) SearchMetaTablesWithCallback(request *SearchMetaTablesRequest, callback func(response *SearchMetaTablesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchMetaTablesResponse
		var err error
		defer close(result)
		response, err = client.SearchMetaTables(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchMetaTablesRequest is the request struct for api SearchMetaTables
type SearchMetaTablesRequest struct {
	*requests.RpcRequest
	DataSourceType string           `position:"Query" name:"DataSourceType"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	EntityType     requests.Integer `position:"Query" name:"EntityType"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	AppGuid        string           `position:"Query" name:"AppGuid"`
	Keyword        string           `position:"Query" name:"Keyword"`
}

// SearchMetaTablesResponse is the response struct for api SearchMetaTables
type SearchMetaTablesResponse struct {
	*responses.BaseResponse
	RequestId      string                 `json:"RequestId" xml:"RequestId"`
	ErrorCode      string                 `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string                 `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int                    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Success        bool                   `json:"Success" xml:"Success"`
	Data           DataInSearchMetaTables `json:"Data" xml:"Data"`
}

// CreateSearchMetaTablesRequest creates a request to invoke SearchMetaTables API
func CreateSearchMetaTablesRequest() (request *SearchMetaTablesRequest) {
	request = &SearchMetaTablesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "SearchMetaTables", "", "")
	request.Method = requests.POST
	return
}

// CreateSearchMetaTablesResponse creates a response to parse from SearchMetaTables response
func CreateSearchMetaTablesResponse() (response *SearchMetaTablesResponse) {
	response = &SearchMetaTablesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
