package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePolarxInstance invokes the polardbx.CreatePolarxInstance API synchronously
func (client *Client) CreatePolarxInstance(request *CreatePolarxInstanceRequest) (response *CreatePolarxInstanceResponse, err error) {
	response = CreateCreatePolarxInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePolarxInstanceWithChan invokes the polardbx.CreatePolarxInstance API asynchronously
func (client *Client) CreatePolarxInstanceWithChan(request *CreatePolarxInstanceRequest) (<-chan *CreatePolarxInstanceResponse, <-chan error) {
	responseChan := make(chan *CreatePolarxInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePolarxInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePolarxInstanceWithCallback invokes the polardbx.CreatePolarxInstance API asynchronously
func (client *Client) CreatePolarxInstanceWithCallback(request *CreatePolarxInstanceRequest, callback func(response *CreatePolarxInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePolarxInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreatePolarxInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePolarxInstanceRequest is the request struct for api CreatePolarxInstance
type CreatePolarxInstanceRequest struct {
	*requests.RpcRequest
	IsAutoRenew    requests.Boolean `position:"Query" name:"IsAutoRenew"`
	ClientToken    string           `position:"Query" name:"ClientToken"`
	Description    string           `position:"Query" name:"Description"`
	Type           string           `position:"Query" name:"Type"`
	Duration       requests.Integer `position:"Query" name:"Duration"`
	IsHa           requests.Boolean `position:"Query" name:"isHa"`
	MySQLVersion   requests.Integer `position:"Query" name:"MySQLVersion"`
	InstanceSeries string           `position:"Query" name:"InstanceSeries"`
	MasterInstId   string           `position:"Query" name:"MasterInstId"`
	Quantity       requests.Integer `position:"Query" name:"Quantity"`
	Specification  string           `position:"Query" name:"Specification"`
	VswitchId      string           `position:"Query" name:"VswitchId"`
	VpcId          string           `position:"Query" name:"VpcId"`
	ZoneId         string           `position:"Query" name:"ZoneId"`
	PayType        string           `position:"Query" name:"PayType"`
	PricingCycle   string           `position:"Query" name:"PricingCycle"`
}

// CreatePolarxInstanceResponse is the response struct for api CreatePolarxInstance
type CreatePolarxInstanceResponse struct {
	*responses.BaseResponse
	RequestId string                     `json:"RequestId" xml:"RequestId"`
	Success   bool                       `json:"Success" xml:"Success"`
	Data      DataInCreatePolarxInstance `json:"Data" xml:"Data"`
}

// CreateCreatePolarxInstanceRequest creates a request to invoke CreatePolarxInstance API
func CreateCreatePolarxInstanceRequest() (request *CreatePolarxInstanceRequest) {
	request = &CreatePolarxInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "CreatePolarxInstance", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreatePolarxInstanceResponse creates a response to parse from CreatePolarxInstance response
func CreateCreatePolarxInstanceResponse() (response *CreatePolarxInstanceResponse) {
	response = &CreatePolarxInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
