package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWebLockEvents invokes the aegis.DescribeWebLockEvents API synchronously
// api document: https://help.aliyun.com/api/aegis/describeweblockevents.html
func (client *Client) DescribeWebLockEvents(request *DescribeWebLockEventsRequest) (response *DescribeWebLockEventsResponse, err error) {
	response = CreateDescribeWebLockEventsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWebLockEventsWithChan invokes the aegis.DescribeWebLockEvents API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeweblockevents.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWebLockEventsWithChan(request *DescribeWebLockEventsRequest) (<-chan *DescribeWebLockEventsResponse, <-chan error) {
	responseChan := make(chan *DescribeWebLockEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWebLockEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWebLockEventsWithCallback invokes the aegis.DescribeWebLockEvents API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeweblockevents.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWebLockEventsWithCallback(request *DescribeWebLockEventsRequest, callback func(response *DescribeWebLockEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWebLockEventsResponse
		var err error
		defer close(result)
		response, err = client.DescribeWebLockEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWebLockEventsRequest is the request struct for api DescribeWebLockEvents
type DescribeWebLockEventsRequest struct {
	*requests.RpcRequest
	StatusList  string           `position:"Query" name:"StatusList"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	Level       string           `position:"Query" name:"Level"`
	GroupId     string           `position:"Query" name:"GroupId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Remark      string           `position:"Query" name:"Remark"`
	Dealed      string           `position:"Query" name:"Dealed"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Tag         string           `position:"Query" name:"Tag"`
	Lang        string           `position:"Query" name:"Lang"`
	EventName   string           `position:"Query" name:"EventName"`
}

// DescribeWebLockEventsResponse is the response struct for api DescribeWebLockEvents
type DescribeWebLockEventsResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	CurrentPage int         `json:"CurrentPage" xml:"CurrentPage"`
	PageSize    int         `json:"PageSize" xml:"PageSize"`
	TotalCount  int         `json:"TotalCount" xml:"TotalCount"`
	EventList   []EventInfo `json:"EventList" xml:"EventList"`
}

// CreateDescribeWebLockEventsRequest creates a request to invoke DescribeWebLockEvents API
func CreateDescribeWebLockEventsRequest() (request *DescribeWebLockEventsRequest) {
	request = &DescribeWebLockEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeWebLockEvents", "vipaegis", "openAPI")
	return
}

// CreateDescribeWebLockEventsResponse creates a response to parse from DescribeWebLockEvents response
func CreateDescribeWebLockEventsResponse() (response *DescribeWebLockEventsResponse) {
	response = &DescribeWebLockEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
