package cloudphoto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RenameFace invokes the cloudphoto.RenameFace API synchronously
// api document: https://help.aliyun.com/api/cloudphoto/renameface.html
func (client *Client) RenameFace(request *RenameFaceRequest) (response *RenameFaceResponse, err error) {
	response = CreateRenameFaceResponse()
	err = client.DoAction(request, response)
	return
}

// RenameFaceWithChan invokes the cloudphoto.RenameFace API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/renameface.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RenameFaceWithChan(request *RenameFaceRequest) (<-chan *RenameFaceResponse, <-chan error) {
	responseChan := make(chan *RenameFaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RenameFace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RenameFaceWithCallback invokes the cloudphoto.RenameFace API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/renameface.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RenameFaceWithCallback(request *RenameFaceRequest, callback func(response *RenameFaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RenameFaceResponse
		var err error
		defer close(result)
		response, err = client.RenameFace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RenameFaceRequest is the request struct for api RenameFace
type RenameFaceRequest struct {
	*requests.RpcRequest
	LibraryId string           `position:"Query" name:"LibraryId"`
	StoreName string           `position:"Query" name:"StoreName"`
	FaceId    requests.Integer `position:"Query" name:"FaceId"`
	FaceName  string           `position:"Query" name:"FaceName"`
}

// RenameFaceResponse is the response struct for api RenameFace
type RenameFaceResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Action    string `json:"Action" xml:"Action"`
}

// CreateRenameFaceRequest creates a request to invoke RenameFace API
func CreateRenameFaceRequest() (request *RenameFaceRequest) {
	request = &RenameFaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudPhoto", "2017-07-11", "RenameFace", "cloudphoto", "openAPI")
	return
}

// CreateRenameFaceResponse creates a response to parse from RenameFace response
func CreateRenameFaceResponse() (response *RenameFaceResponse) {
	response = &RenameFaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
