package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetLoginPassword invokes the cr.ResetLoginPassword API synchronously
// api document: https://help.aliyun.com/api/cr/resetloginpassword.html
func (client *Client) ResetLoginPassword(request *ResetLoginPasswordRequest) (response *ResetLoginPasswordResponse, err error) {
	response = CreateResetLoginPasswordResponse()
	err = client.DoAction(request, response)
	return
}

// ResetLoginPasswordWithChan invokes the cr.ResetLoginPassword API asynchronously
// api document: https://help.aliyun.com/api/cr/resetloginpassword.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResetLoginPasswordWithChan(request *ResetLoginPasswordRequest) (<-chan *ResetLoginPasswordResponse, <-chan error) {
	responseChan := make(chan *ResetLoginPasswordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetLoginPassword(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetLoginPasswordWithCallback invokes the cr.ResetLoginPassword API asynchronously
// api document: https://help.aliyun.com/api/cr/resetloginpassword.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResetLoginPasswordWithCallback(request *ResetLoginPasswordRequest, callback func(response *ResetLoginPasswordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetLoginPasswordResponse
		var err error
		defer close(result)
		response, err = client.ResetLoginPassword(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetLoginPasswordRequest is the request struct for api ResetLoginPassword
type ResetLoginPasswordRequest struct {
	*requests.RpcRequest
	Password   string `position:"Query" name:"Password"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ResetLoginPasswordResponse is the response struct for api ResetLoginPassword
type ResetLoginPasswordResponse struct {
	*responses.BaseResponse
	ResetLoginPasswordIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
	Code                        string `json:"Code" xml:"Code"`
	RequestId                   string `json:"RequestId" xml:"RequestId"`
}

// CreateResetLoginPasswordRequest creates a request to invoke ResetLoginPassword API
func CreateResetLoginPasswordRequest() (request *ResetLoginPasswordRequest) {
	request = &ResetLoginPasswordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "ResetLoginPassword", "acr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateResetLoginPasswordResponse creates a response to parse from ResetLoginPassword response
func CreateResetLoginPasswordResponse() (response *ResetLoginPasswordResponse) {
	response = &ResetLoginPasswordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
