package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectIPCPedestrian invokes the facebody.DetectIPCPedestrian API synchronously
func (client *Client) DetectIPCPedestrian(request *DetectIPCPedestrianRequest) (response *DetectIPCPedestrianResponse, err error) {
	response = CreateDetectIPCPedestrianResponse()
	err = client.DoAction(request, response)
	return
}

// DetectIPCPedestrianWithChan invokes the facebody.DetectIPCPedestrian API asynchronously
func (client *Client) DetectIPCPedestrianWithChan(request *DetectIPCPedestrianRequest) (<-chan *DetectIPCPedestrianResponse, <-chan error) {
	responseChan := make(chan *DetectIPCPedestrianResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectIPCPedestrian(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectIPCPedestrianWithCallback invokes the facebody.DetectIPCPedestrian API asynchronously
func (client *Client) DetectIPCPedestrianWithCallback(request *DetectIPCPedestrianRequest, callback func(response *DetectIPCPedestrianResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectIPCPedestrianResponse
		var err error
		defer close(result)
		response, err = client.DetectIPCPedestrian(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectIPCPedestrianRequest is the request struct for api DetectIPCPedestrian
type DetectIPCPedestrianRequest struct {
	*requests.RpcRequest
	ContinueOnError requests.Boolean `position:"Body" name:"ContinueOnError"`
	Height          requests.Integer `position:"Body" name:"Height"`
	ImageData       string           `position:"Body" name:"ImageData"`
	DataId          string           `position:"Body" name:"DataId"`
	ImageURL        string           `position:"Body" name:"ImageURL"`
	Width           requests.Integer `position:"Body" name:"Width"`
}

// DetectIPCPedestrianResponse is the response struct for api DetectIPCPedestrian
type DetectIPCPedestrianResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetectIPCPedestrianRequest creates a request to invoke DetectIPCPedestrian API
func CreateDetectIPCPedestrianRequest() (request *DetectIPCPedestrianRequest) {
	request = &DetectIPCPedestrianRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "DetectIPCPedestrian", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectIPCPedestrianResponse creates a response to parse from DetectIPCPedestrian response
func CreateDetectIPCPedestrianResponse() (response *DetectIPCPedestrianResponse) {
	response = &DetectIPCPedestrianResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
