package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetImage invokes the mse.GetImage API synchronously
func (client *Client) GetImage(request *GetImageRequest) (response *GetImageResponse, err error) {
	response = CreateGetImageResponse()
	err = client.DoAction(request, response)
	return
}

// GetImageWithChan invokes the mse.GetImage API asynchronously
func (client *Client) GetImageWithChan(request *GetImageRequest) (<-chan *GetImageResponse, <-chan error) {
	responseChan := make(chan *GetImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetImageWithCallback invokes the mse.GetImage API asynchronously
func (client *Client) GetImageWithCallback(request *GetImageRequest, callback func(response *GetImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetImageResponse
		var err error
		defer close(result)
		response, err = client.GetImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetImageRequest is the request struct for api GetImage
type GetImageRequest struct {
	*requests.RpcRequest
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
	VersionCode    string `position:"Query" name:"VersionCode"`
}

// GetImageResponse is the response struct for api GetImage
type GetImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	HttpCode  string `json:"HttpCode" xml:"HttpCode"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetImageRequest creates a request to invoke GetImage API
func CreateGetImageRequest() (request *GetImageRequest) {
	request = &GetImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "GetImage", "", "")
	request.Method = requests.POST
	return
}

// CreateGetImageResponse creates a response to parse from GetImage response
func CreateGetImageResponse() (response *GetImageResponse) {
	response = &GetImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
