package petadata

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstancePerformance invokes the petadata.DescribeInstancePerformance API synchronously
// api document: https://help.aliyun.com/api/petadata/describeinstanceperformance.html
func (client *Client) DescribeInstancePerformance(request *DescribeInstancePerformanceRequest) (response *DescribeInstancePerformanceResponse, err error) {
	response = CreateDescribeInstancePerformanceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstancePerformanceWithChan invokes the petadata.DescribeInstancePerformance API asynchronously
// api document: https://help.aliyun.com/api/petadata/describeinstanceperformance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeInstancePerformanceWithChan(request *DescribeInstancePerformanceRequest) (<-chan *DescribeInstancePerformanceResponse, <-chan error) {
	responseChan := make(chan *DescribeInstancePerformanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstancePerformance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstancePerformanceWithCallback invokes the petadata.DescribeInstancePerformance API asynchronously
// api document: https://help.aliyun.com/api/petadata/describeinstanceperformance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeInstancePerformanceWithCallback(request *DescribeInstancePerformanceRequest, callback func(response *DescribeInstancePerformanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstancePerformanceResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstancePerformance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstancePerformanceRequest is the request struct for api DescribeInstancePerformance
type DescribeInstancePerformanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	EndTime              string           `position:"Query" name:"EndTime"`
	StartTime            string           `position:"Query" name:"StartTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	KeyList              string           `position:"Query" name:"KeyList"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	MonitorGroup         string           `position:"Query" name:"MonitorGroup"`
	Interval             string           `position:"Query" name:"Interval"`
}

// DescribeInstancePerformanceResponse is the response struct for api DescribeInstancePerformance
type DescribeInstancePerformanceResponse struct {
	*responses.BaseResponse
	RequestId    string                                    `json:"RequestId" xml:"RequestId"`
	MonitorDatas MonitorDatasInDescribeInstancePerformance `json:"MonitorDatas" xml:"MonitorDatas"`
}

// CreateDescribeInstancePerformanceRequest creates a request to invoke DescribeInstancePerformance API
func CreateDescribeInstancePerformanceRequest() (request *DescribeInstancePerformanceRequest) {
	request = &DescribeInstancePerformanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PetaData", "2016-01-01", "DescribeInstancePerformance", "petadata", "openAPI")
	return
}

// CreateDescribeInstancePerformanceResponse creates a response to parse from DescribeInstancePerformance response
func CreateDescribeInstancePerformanceResponse() (response *DescribeInstancePerformanceResponse) {
	response = &DescribeInstancePerformanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
