package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddResolverRule invokes the pvtz.AddResolverRule API synchronously
func (client *Client) AddResolverRule(request *AddResolverRuleRequest) (response *AddResolverRuleResponse, err error) {
	response = CreateAddResolverRuleResponse()
	err = client.DoAction(request, response)
	return
}

// AddResolverRuleWithChan invokes the pvtz.AddResolverRule API asynchronously
func (client *Client) AddResolverRuleWithChan(request *AddResolverRuleRequest) (<-chan *AddResolverRuleResponse, <-chan error) {
	responseChan := make(chan *AddResolverRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddResolverRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddResolverRuleWithCallback invokes the pvtz.AddResolverRule API asynchronously
func (client *Client) AddResolverRuleWithCallback(request *AddResolverRuleRequest, callback func(response *AddResolverRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddResolverRuleResponse
		var err error
		defer close(result)
		response, err = client.AddResolverRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddResolverRuleRequest is the request struct for api AddResolverRule
type AddResolverRuleRequest struct {
	*requests.RpcRequest
	EndpointId   string                      `position:"Query" name:"EndpointId"`
	ForwardIp    *[]AddResolverRuleForwardIp `position:"Query" name:"ForwardIp"  type:"Repeated"`
	Type         string                      `position:"Query" name:"Type"`
	ZoneName     string                      `position:"Query" name:"ZoneName"`
	UserClientIp string                      `position:"Query" name:"UserClientIp"`
	Name         string                      `position:"Query" name:"Name"`
	Lang         string                      `position:"Query" name:"Lang"`
}

// AddResolverRuleForwardIp is a repeated param struct in AddResolverRuleRequest
type AddResolverRuleForwardIp struct {
	Port string `name:"Port"`
	Ip   string `name:"Ip"`
}

// AddResolverRuleResponse is the response struct for api AddResolverRule
type AddResolverRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RuleId    string `json:"RuleId" xml:"RuleId"`
}

// CreateAddResolverRuleRequest creates a request to invoke AddResolverRule API
func CreateAddResolverRuleRequest() (request *AddResolverRuleRequest) {
	request = &AddResolverRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "AddResolverRule", "pvtz", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddResolverRuleResponse creates a response to parse from AddResolverRule response
func CreateAddResolverRuleResponse() (response *AddResolverRuleResponse) {
	response = &AddResolverRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
