package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGatewayTypes invokes the sgw.DescribeGatewayTypes API synchronously
func (client *Client) DescribeGatewayTypes(request *DescribeGatewayTypesRequest) (response *DescribeGatewayTypesResponse, err error) {
	response = CreateDescribeGatewayTypesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewayTypesWithChan invokes the sgw.DescribeGatewayTypes API asynchronously
func (client *Client) DescribeGatewayTypesWithChan(request *DescribeGatewayTypesRequest) (<-chan *DescribeGatewayTypesResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewayTypesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGatewayTypes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewayTypesWithCallback invokes the sgw.DescribeGatewayTypes API asynchronously
func (client *Client) DescribeGatewayTypesWithCallback(request *DescribeGatewayTypesRequest, callback func(response *DescribeGatewayTypesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewayTypesResponse
		var err error
		defer close(result)
		response, err = client.DescribeGatewayTypes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewayTypesRequest is the request struct for api DescribeGatewayTypes
type DescribeGatewayTypesRequest struct {
	*requests.RpcRequest
	GatewayCategory string `position:"Query" name:"GatewayCategory"`
	GatewayLocation string `position:"Query" name:"GatewayLocation"`
	SecurityToken   string `position:"Query" name:"SecurityToken"`
}

// DescribeGatewayTypesResponse is the response struct for api DescribeGatewayTypes
type DescribeGatewayTypesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Types     string `json:"Types" xml:"Types"`
}

// CreateDescribeGatewayTypesRequest creates a request to invoke DescribeGatewayTypes API
func CreateDescribeGatewayTypesRequest() (request *DescribeGatewayTypesRequest) {
	request = &DescribeGatewayTypesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGatewayTypes", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewayTypesResponse creates a response to parse from DescribeGatewayTypes response
func CreateDescribeGatewayTypesResponse() (response *DescribeGatewayTypesResponse) {
	response = &DescribeGatewayTypesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
