package version

import (
	"testing"
)

type VerTest struct {
	A string
	B string
	R int
}

type TestPkg struct {
	e int
	v string
	r string
}

func (c *TestPkg) Name() string    { return "test" }
func (c *TestPkg) Epoch() int      { return c.e }
func (c *TestPkg) Version() string { return c.v }
func (c *TestPkg) Release() string { return c.r }

func sign(r int) string {
	if r < 0 {
		return "<"
	} else if r > 0 {
		return ">"
	}

	return "=="
}

func TestRpmVerCmp(t *testing.T) {
	// tests generated with vercmp_test.py
	// tests generated with version_test.py
	tests := []VerTest{
		{"", "", 0},
		{"", "0", -1},
		{"", "1", -1},
		{"", "2", -1},
		{"", "10", -1},
		{"", "100", -1},
		{"", "0.0", -1},
		{"", "0.1", -1},
		{"", "0.10", -1},
		{"", "0.99", -1},
		{"", "1.0", -1},
		{"", "1.99", -1},
		{"", "2.0", -1},
		{"", "0.0.0", -1},
		{"", "0.0.1", -1},
		{"", "0.0.2", -1},
		{"", "0.0.10", -1},
		{"", "0.0.99", -1},
		{"", "0.1.0", -1},
		{"", "0.2.0", -1},
		{"", "0.10.0", -1},
		{"", "0.99.0", -1},
		{"", "0.100.0", -1},
		{"", "0.0.0.0", -1},
		{"", "0.0.0.1", -1},
		{"", "0.0.0.10", -1},
		{"", "0.0.1.0", -1},
		{"", "0.0.01.0", -1},
		{"", "1.2.3.4", -1},
		{"", "1-2-3-4", -1},
		{"", "20150101", -1},
		{"", "20151212", -1},
		{"", "20151212.0", -1},
		{"", "20151212.1", -1},
		{"", "2015.1.1", -1},
		{"", "2015.02.02", -1},
		{"", "2015.12.12", -1},
		{"", "1.2.3a", -1},
		{"", "1.2.3b", -1},
		{"", "R16B", -1},
		{"", "R16C", -1},
		{"", "1.2.3.2016.1.1", -1},
		{"", "0.5a1.dev", -1},
		{"", "1.8.B59BrZX", -1},
		{"", "0.07b4p1", -1},
		{"", "3.99.5final.SP07", -1},
		{"", "3.99.5final.SP08", -1},
		{"", "0.4.tbb.20100203", -1},
		{"", "0.5.20120830CVS.el7", -1},
		{"", "1.el7", -1},
		{"", "1.el6", -1},
		{"", "10.el7", -1},
		{"", "01.el7", -1},
		{"", "0.17.20140318svn632.el7", -1},
		{"", "0.17.20140318svn633.el7", -1},
		{"", "1.20140522gitad6fb3e.el7", -1},
		{"", "1.20140522hitad6fb3e.el7", -1},
		{"", "8.20140605hgacf1c26e3019.el7", -1},
		{"", "8.20140605hgacf1c26e3029.el7", -1},
		{"", "22.svn457.el7", -1},
		{"", "22.svn458.el7", -1},
		{"", "~", 1},
		{"", "~~", 1},
		{"", "~1", 1},
		{"", "~a", 1},
		{"", "1~", -1},
		{"", "2~", -1},
		{"0", "", 1},
		{"0", "0", 0},
		{"0", "1", -1},
		{"0", "2", -1},
		{"0", "10", -1},
		{"0", "100", -1},
		{"0", "0.0", -1},
		{"0", "0.1", -1},
		{"0", "0.10", -1},
		{"0", "0.99", -1},
		{"0", "1.0", -1},
		{"0", "1.99", -1},
		{"0", "2.0", -1},
		{"0", "0.0.0", -1},
		{"0", "0.0.1", -1},
		{"0", "0.0.2", -1},
		{"0", "0.0.10", -1},
		{"0", "0.0.99", -1},
		{"0", "0.1.0", -1},
		{"0", "0.2.0", -1},
		{"0", "0.10.0", -1},
		{"0", "0.99.0", -1},
		{"0", "0.100.0", -1},
		{"0", "0.0.0.0", -1},
		{"0", "0.0.0.1", -1},
		{"0", "0.0.0.10", -1},
		{"0", "0.0.1.0", -1},
		{"0", "0.0.01.0", -1},
		{"0", "1.2.3.4", -1},
		{"0", "1-2-3-4", -1},
		{"0", "20150101", -1},
		{"0", "20151212", -1},
		{"0", "20151212.0", -1},
		{"0", "20151212.1", -1},
		{"0", "2015.1.1", -1},
		{"0", "2015.02.02", -1},
		{"0", "2015.12.12", -1},
		{"0", "1.2.3a", -1},
		{"0", "1.2.3b", -1},
		{"0", "R16B", 1},
		{"0", "R16C", 1},
		{"0", "1.2.3.2016.1.1", -1},
		{"0", "0.5a1.dev", -1},
		{"0", "1.8.B59BrZX", -1},
		{"0", "0.07b4p1", -1},
		{"0", "3.99.5final.SP07", -1},
		{"0", "3.99.5final.SP08", -1},
		{"0", "0.4.tbb.20100203", -1},
		{"0", "0.5.20120830CVS.el7", -1},
		{"0", "1.el7", -1},
		{"0", "1.el6", -1},
		{"0", "10.el7", -1},
		{"0", "01.el7", -1},
		{"0", "0.17.20140318svn632.el7", -1},
		{"0", "0.17.20140318svn633.el7", -1},
		{"0", "1.20140522gitad6fb3e.el7", -1},
		{"0", "1.20140522hitad6fb3e.el7", -1},
		{"0", "8.20140605hgacf1c26e3019.el7", -1},
		{"0", "8.20140605hgacf1c26e3029.el7", -1},
		{"0", "22.svn457.el7", -1},
		{"0", "22.svn458.el7", -1},
		{"0", "~", 1},
		{"0", "~~", 1},
		{"0", "~1", 1},
		{"0", "~a", 1},
		{"0", "1~", -1},
		{"0", "2~", -1},
		{"1", "", 1},
		{"1", "0", 1},
		{"1", "1", 0},
		{"1", "2", -1},
		{"1", "10", -1},
		{"1", "100", -1},
		{"1", "0.0", 1},
		{"1", "0.1", 1},
		{"1", "0.10", 1},
		{"1", "0.99", 1},
		{"1", "1.0", -1},
		{"1", "1.99", -1},
		{"1", "2.0", -1},
		{"1", "0.0.0", 1},
		{"1", "0.0.1", 1},
		{"1", "0.0.2", 1},
		{"1", "0.0.10", 1},
		{"1", "0.0.99", 1},
		{"1", "0.1.0", 1},
		{"1", "0.2.0", 1},
		{"1", "0.10.0", 1},
		{"1", "0.99.0", 1},
		{"1", "0.100.0", 1},
		{"1", "0.0.0.0", 1},
		{"1", "0.0.0.1", 1},
		{"1", "0.0.0.10", 1},
		{"1", "0.0.1.0", 1},
		{"1", "0.0.01.0", 1},
		{"1", "1.2.3.4", -1},
		{"1", "1-2-3-4", -1},
		{"1", "20150101", -1},
		{"1", "20151212", -1},
		{"1", "20151212.0", -1},
		{"1", "20151212.1", -1},
		{"1", "2015.1.1", -1},
		{"1", "2015.02.02", -1},
		{"1", "2015.12.12", -1},
		{"1", "1.2.3a", -1},
		{"1", "1.2.3b", -1},
		{"1", "R16B", 1},
		{"1", "R16C", 1},
		{"1", "1.2.3.2016.1.1", -1},
		{"1", "0.5a1.dev", 1},
		{"1", "1.8.B59BrZX", -1},
		{"1", "0.07b4p1", 1},
		{"1", "3.99.5final.SP07", -1},
		{"1", "3.99.5final.SP08", -1},
		{"1", "0.4.tbb.20100203", 1},
		{"1", "0.5.20120830CVS.el7", 1},
		{"1", "1.el7", -1},
		{"1", "1.el6", -1},
		{"1", "10.el7", -1},
		{"1", "01.el7", -1},
		{"1", "0.17.20140318svn632.el7", 1},
		{"1", "0.17.20140318svn633.el7", 1},
		{"1", "1.20140522gitad6fb3e.el7", -1},
		{"1", "1.20140522hitad6fb3e.el7", -1},
		{"1", "8.20140605hgacf1c26e3019.el7", -1},
		{"1", "8.20140605hgacf1c26e3029.el7", -1},
		{"1", "22.svn457.el7", -1},
		{"1", "22.svn458.el7", -1},
		{"1", "~", 1},
		{"1", "~~", 1},
		{"1", "~1", 1},
		{"1", "~a", 1},
		{"1", "1~", 1},
		{"1", "2~", -1},
		{"2", "", 1},
		{"2", "0", 1},
		{"2", "1", 1},
		{"2", "2", 0},
		{"2", "10", -1},
		{"2", "100", -1},
		{"2", "0.0", 1},
		{"2", "0.1", 1},
		{"2", "0.10", 1},
		{"2", "0.99", 1},
		{"2", "1.0", 1},
		{"2", "1.99", 1},
		{"2", "2.0", -1},
		{"2", "0.0.0", 1},
		{"2", "0.0.1", 1},
		{"2", "0.0.2", 1},
		{"2", "0.0.10", 1},
		{"2", "0.0.99", 1},
		{"2", "0.1.0", 1},
		{"2", "0.2.0", 1},
		{"2", "0.10.0", 1},
		{"2", "0.99.0", 1},
		{"2", "0.100.0", 1},
		{"2", "0.0.0.0", 1},
		{"2", "0.0.0.1", 1},
		{"2", "0.0.0.10", 1},
		{"2", "0.0.1.0", 1},
		{"2", "0.0.01.0", 1},
		{"2", "1.2.3.4", 1},
		{"2", "1-2-3-4", 1},
		{"2", "20150101", -1},
		{"2", "20151212", -1},
		{"2", "20151212.0", -1},
		{"2", "20151212.1", -1},
		{"2", "2015.1.1", -1},
		{"2", "2015.02.02", -1},
		{"2", "2015.12.12", -1},
		{"2", "1.2.3a", 1},
		{"2", "1.2.3b", 1},
		{"2", "R16B", 1},
		{"2", "R16C", 1},
		{"2", "1.2.3.2016.1.1", 1},
		{"2", "0.5a1.dev", 1},
		{"2", "1.8.B59BrZX", 1},
		{"2", "0.07b4p1", 1},
		{"2", "3.99.5final.SP07", -1},
		{"2", "3.99.5final.SP08", -1},
		{"2", "0.4.tbb.20100203", 1},
		{"2", "0.5.20120830CVS.el7", 1},
		{"2", "1.el7", 1},
		{"2", "1.el6", 1},
		{"2", "10.el7", -1},
		{"2", "01.el7", 1},
		{"2", "0.17.20140318svn632.el7", 1},
		{"2", "0.17.20140318svn633.el7", 1},
		{"2", "1.20140522gitad6fb3e.el7", 1},
		{"2", "1.20140522hitad6fb3e.el7", 1},
		{"2", "8.20140605hgacf1c26e3019.el7", -1},
		{"2", "8.20140605hgacf1c26e3029.el7", -1},
		{"2", "22.svn457.el7", -1},
		{"2", "22.svn458.el7", -1},
		{"2", "~", 1},
		{"2", "~~", 1},
		{"2", "~1", 1},
		{"2", "~a", 1},
		{"2", "1~", 1},
		{"2", "2~", 1},
		{"10", "", 1},
		{"10", "0", 1},
		{"10", "1", 1},
		{"10", "2", 1},
		{"10", "10", 0},
		{"10", "100", -1},
		{"10", "0.0", 1},
		{"10", "0.1", 1},
		{"10", "0.10", 1},
		{"10", "0.99", 1},
		{"10", "1.0", 1},
		{"10", "1.99", 1},
		{"10", "2.0", 1},
		{"10", "0.0.0", 1},
		{"10", "0.0.1", 1},
		{"10", "0.0.2", 1},
		{"10", "0.0.10", 1},
		{"10", "0.0.99", 1},
		{"10", "0.1.0", 1},
		{"10", "0.2.0", 1},
		{"10", "0.10.0", 1},
		{"10", "0.99.0", 1},
		{"10", "0.100.0", 1},
		{"10", "0.0.0.0", 1},
		{"10", "0.0.0.1", 1},
		{"10", "0.0.0.10", 1},
		{"10", "0.0.1.0", 1},
		{"10", "0.0.01.0", 1},
		{"10", "1.2.3.4", 1},
		{"10", "1-2-3-4", 1},
		{"10", "20150101", -1},
		{"10", "20151212", -1},
		{"10", "20151212.0", -1},
		{"10", "20151212.1", -1},
		{"10", "2015.1.1", -1},
		{"10", "2015.02.02", -1},
		{"10", "2015.12.12", -1},
		{"10", "1.2.3a", 1},
		{"10", "1.2.3b", 1},
		{"10", "R16B", 1},
		{"10", "R16C", 1},
		{"10", "1.2.3.2016.1.1", 1},
		{"10", "0.5a1.dev", 1},
		{"10", "1.8.B59BrZX", 1},
		{"10", "0.07b4p1", 1},
		{"10", "3.99.5final.SP07", 1},
		{"10", "3.99.5final.SP08", 1},
		{"10", "0.4.tbb.20100203", 1},
		{"10", "0.5.20120830CVS.el7", 1},
		{"10", "1.el7", 1},
		{"10", "1.el6", 1},
		{"10", "10.el7", -1},
		{"10", "01.el7", 1},
		{"10", "0.17.20140318svn632.el7", 1},
		{"10", "0.17.20140318svn633.el7", 1},
		{"10", "1.20140522gitad6fb3e.el7", 1},
		{"10", "1.20140522hitad6fb3e.el7", 1},
		{"10", "8.20140605hgacf1c26e3019.el7", 1},
		{"10", "8.20140605hgacf1c26e3029.el7", 1},
		{"10", "22.svn457.el7", -1},
		{"10", "22.svn458.el7", -1},
		{"10", "~", 1},
		{"10", "~~", 1},
		{"10", "~1", 1},
		{"10", "~a", 1},
		{"10", "1~", 1},
		{"10", "2~", 1},
		{"100", "", 1},
		{"100", "0", 1},
		{"100", "1", 1},
		{"100", "2", 1},
		{"100", "10", 1},
		{"100", "100", 0},
		{"100", "0.0", 1},
		{"100", "0.1", 1},
		{"100", "0.10", 1},
		{"100", "0.99", 1},
		{"100", "1.0", 1},
		{"100", "1.99", 1},
		{"100", "2.0", 1},
		{"100", "0.0.0", 1},
		{"100", "0.0.1", 1},
		{"100", "0.0.2", 1},
		{"100", "0.0.10", 1},
		{"100", "0.0.99", 1},
		{"100", "0.1.0", 1},
		{"100", "0.2.0", 1},
		{"100", "0.10.0", 1},
		{"100", "0.99.0", 1},
		{"100", "0.100.0", 1},
		{"100", "0.0.0.0", 1},
		{"100", "0.0.0.1", 1},
		{"100", "0.0.0.10", 1},
		{"100", "0.0.1.0", 1},
		{"100", "0.0.01.0", 1},
		{"100", "1.2.3.4", 1},
		{"100", "1-2-3-4", 1},
		{"100", "20150101", -1},
		{"100", "20151212", -1},
		{"100", "20151212.0", -1},
		{"100", "20151212.1", -1},
		{"100", "2015.1.1", -1},
		{"100", "2015.02.02", -1},
		{"100", "2015.12.12", -1},
		{"100", "1.2.3a", 1},
		{"100", "1.2.3b", 1},
		{"100", "R16B", 1},
		{"100", "R16C", 1},
		{"100", "1.2.3.2016.1.1", 1},
		{"100", "0.5a1.dev", 1},
		{"100", "1.8.B59BrZX", 1},
		{"100", "0.07b4p1", 1},
		{"100", "3.99.5final.SP07", 1},
		{"100", "3.99.5final.SP08", 1},
		{"100", "0.4.tbb.20100203", 1},
		{"100", "0.5.20120830CVS.el7", 1},
		{"100", "1.el7", 1},
		{"100", "1.el6", 1},
		{"100", "10.el7", 1},
		{"100", "01.el7", 1},
		{"100", "0.17.20140318svn632.el7", 1},
		{"100", "0.17.20140318svn633.el7", 1},
		{"100", "1.20140522gitad6fb3e.el7", 1},
		{"100", "1.20140522hitad6fb3e.el7", 1},
		{"100", "8.20140605hgacf1c26e3019.el7", 1},
		{"100", "8.20140605hgacf1c26e3029.el7", 1},
		{"100", "22.svn457.el7", 1},
		{"100", "22.svn458.el7", 1},
		{"100", "~", 1},
		{"100", "~~", 1},
		{"100", "~1", 1},
		{"100", "~a", 1},
		{"100", "1~", 1},
		{"100", "2~", 1},
		{"0.0", "", 1},
		{"0.0", "0", 1},
		{"0.0", "1", -1},
		{"0.0", "2", -1},
		{"0.0", "10", -1},
		{"0.0", "100", -1},
		{"0.0", "0.0", 0},
		{"0.0", "0.1", -1},
		{"0.0", "0.10", -1},
		{"0.0", "0.99", -1},
		{"0.0", "1.0", -1},
		{"0.0", "1.99", -1},
		{"0.0", "2.0", -1},
		{"0.0", "0.0.0", -1},
		{"0.0", "0.0.1", -1},
		{"0.0", "0.0.2", -1},
		{"0.0", "0.0.10", -1},
		{"0.0", "0.0.99", -1},
		{"0.0", "0.1.0", -1},
		{"0.0", "0.2.0", -1},
		{"0.0", "0.10.0", -1},
		{"0.0", "0.99.0", -1},
		{"0.0", "0.100.0", -1},
		{"0.0", "0.0.0.0", -1},
		{"0.0", "0.0.0.1", -1},
		{"0.0", "0.0.0.10", -1},
		{"0.0", "0.0.1.0", -1},
		{"0.0", "0.0.01.0", -1},
		{"0.0", "1.2.3.4", -1},
		{"0.0", "1-2-3-4", -1},
		{"0.0", "20150101", -1},
		{"0.0", "20151212", -1},
		{"0.0", "20151212.0", -1},
		{"0.0", "20151212.1", -1},
		{"0.0", "2015.1.1", -1},
		{"0.0", "2015.02.02", -1},
		{"0.0", "2015.12.12", -1},
		{"0.0", "1.2.3a", -1},
		{"0.0", "1.2.3b", -1},
		{"0.0", "R16B", 1},
		{"0.0", "R16C", 1},
		{"0.0", "1.2.3.2016.1.1", -1},
		{"0.0", "0.5a1.dev", -1},
		{"0.0", "1.8.B59BrZX", -1},
		{"0.0", "0.07b4p1", -1},
		{"0.0", "3.99.5final.SP07", -1},
		{"0.0", "3.99.5final.SP08", -1},
		{"0.0", "0.4.tbb.20100203", -1},
		{"0.0", "0.5.20120830CVS.el7", -1},
		{"0.0", "1.el7", -1},
		{"0.0", "1.el6", -1},
		{"0.0", "10.el7", -1},
		{"0.0", "01.el7", -1},
		{"0.0", "0.17.20140318svn632.el7", -1},
		{"0.0", "0.17.20140318svn633.el7", -1},
		{"0.0", "1.20140522gitad6fb3e.el7", -1},
		{"0.0", "1.20140522hitad6fb3e.el7", -1},
		{"0.0", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.0", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.0", "22.svn457.el7", -1},
		{"0.0", "22.svn458.el7", -1},
		{"0.0", "~", 1},
		{"0.0", "~~", 1},
		{"0.0", "~1", 1},
		{"0.0", "~a", 1},
		{"0.0", "1~", -1},
		{"0.0", "2~", -1},
		{"0.1", "", 1},
		{"0.1", "0", 1},
		{"0.1", "1", -1},
		{"0.1", "2", -1},
		{"0.1", "10", -1},
		{"0.1", "100", -1},
		{"0.1", "0.0", 1},
		{"0.1", "0.1", 0},
		{"0.1", "0.10", -1},
		{"0.1", "0.99", -1},
		{"0.1", "1.0", -1},
		{"0.1", "1.99", -1},
		{"0.1", "2.0", -1},
		{"0.1", "0.0.0", 1},
		{"0.1", "0.0.1", 1},
		{"0.1", "0.0.2", 1},
		{"0.1", "0.0.10", 1},
		{"0.1", "0.0.99", 1},
		{"0.1", "0.1.0", -1},
		{"0.1", "0.2.0", -1},
		{"0.1", "0.10.0", -1},
		{"0.1", "0.99.0", -1},
		{"0.1", "0.100.0", -1},
		{"0.1", "0.0.0.0", 1},
		{"0.1", "0.0.0.1", 1},
		{"0.1", "0.0.0.10", 1},
		{"0.1", "0.0.1.0", 1},
		{"0.1", "0.0.01.0", 1},
		{"0.1", "1.2.3.4", -1},
		{"0.1", "1-2-3-4", -1},
		{"0.1", "20150101", -1},
		{"0.1", "20151212", -1},
		{"0.1", "20151212.0", -1},
		{"0.1", "20151212.1", -1},
		{"0.1", "2015.1.1", -1},
		{"0.1", "2015.02.02", -1},
		{"0.1", "2015.12.12", -1},
		{"0.1", "1.2.3a", -1},
		{"0.1", "1.2.3b", -1},
		{"0.1", "R16B", 1},
		{"0.1", "R16C", 1},
		{"0.1", "1.2.3.2016.1.1", -1},
		{"0.1", "0.5a1.dev", -1},
		{"0.1", "1.8.B59BrZX", -1},
		{"0.1", "0.07b4p1", -1},
		{"0.1", "3.99.5final.SP07", -1},
		{"0.1", "3.99.5final.SP08", -1},
		{"0.1", "0.4.tbb.20100203", -1},
		{"0.1", "0.5.20120830CVS.el7", -1},
		{"0.1", "1.el7", -1},
		{"0.1", "1.el6", -1},
		{"0.1", "10.el7", -1},
		{"0.1", "01.el7", -1},
		{"0.1", "0.17.20140318svn632.el7", -1},
		{"0.1", "0.17.20140318svn633.el7", -1},
		{"0.1", "1.20140522gitad6fb3e.el7", -1},
		{"0.1", "1.20140522hitad6fb3e.el7", -1},
		{"0.1", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.1", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.1", "22.svn457.el7", -1},
		{"0.1", "22.svn458.el7", -1},
		{"0.1", "~", 1},
		{"0.1", "~~", 1},
		{"0.1", "~1", 1},
		{"0.1", "~a", 1},
		{"0.1", "1~", -1},
		{"0.1", "2~", -1},
		{"0.10", "", 1},
		{"0.10", "0", 1},
		{"0.10", "1", -1},
		{"0.10", "2", -1},
		{"0.10", "10", -1},
		{"0.10", "100", -1},
		{"0.10", "0.0", 1},
		{"0.10", "0.1", 1},
		{"0.10", "0.10", 0},
		{"0.10", "0.99", -1},
		{"0.10", "1.0", -1},
		{"0.10", "1.99", -1},
		{"0.10", "2.0", -1},
		{"0.10", "0.0.0", 1},
		{"0.10", "0.0.1", 1},
		{"0.10", "0.0.2", 1},
		{"0.10", "0.0.10", 1},
		{"0.10", "0.0.99", 1},
		{"0.10", "0.1.0", 1},
		{"0.10", "0.2.0", 1},
		{"0.10", "0.10.0", -1},
		{"0.10", "0.99.0", -1},
		{"0.10", "0.100.0", -1},
		{"0.10", "0.0.0.0", 1},
		{"0.10", "0.0.0.1", 1},
		{"0.10", "0.0.0.10", 1},
		{"0.10", "0.0.1.0", 1},
		{"0.10", "0.0.01.0", 1},
		{"0.10", "1.2.3.4", -1},
		{"0.10", "1-2-3-4", -1},
		{"0.10", "20150101", -1},
		{"0.10", "20151212", -1},
		{"0.10", "20151212.0", -1},
		{"0.10", "20151212.1", -1},
		{"0.10", "2015.1.1", -1},
		{"0.10", "2015.02.02", -1},
		{"0.10", "2015.12.12", -1},
		{"0.10", "1.2.3a", -1},
		{"0.10", "1.2.3b", -1},
		{"0.10", "R16B", 1},
		{"0.10", "R16C", 1},
		{"0.10", "1.2.3.2016.1.1", -1},
		{"0.10", "0.5a1.dev", 1},
		{"0.10", "1.8.B59BrZX", -1},
		{"0.10", "0.07b4p1", 1},
		{"0.10", "3.99.5final.SP07", -1},
		{"0.10", "3.99.5final.SP08", -1},
		{"0.10", "0.4.tbb.20100203", 1},
		{"0.10", "0.5.20120830CVS.el7", 1},
		{"0.10", "1.el7", -1},
		{"0.10", "1.el6", -1},
		{"0.10", "10.el7", -1},
		{"0.10", "01.el7", -1},
		{"0.10", "0.17.20140318svn632.el7", -1},
		{"0.10", "0.17.20140318svn633.el7", -1},
		{"0.10", "1.20140522gitad6fb3e.el7", -1},
		{"0.10", "1.20140522hitad6fb3e.el7", -1},
		{"0.10", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.10", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.10", "22.svn457.el7", -1},
		{"0.10", "22.svn458.el7", -1},
		{"0.10", "~", 1},
		{"0.10", "~~", 1},
		{"0.10", "~1", 1},
		{"0.10", "~a", 1},
		{"0.10", "1~", -1},
		{"0.10", "2~", -1},
		{"0.99", "", 1},
		{"0.99", "0", 1},
		{"0.99", "1", -1},
		{"0.99", "2", -1},
		{"0.99", "10", -1},
		{"0.99", "100", -1},
		{"0.99", "0.0", 1},
		{"0.99", "0.1", 1},
		{"0.99", "0.10", 1},
		{"0.99", "0.99", 0},
		{"0.99", "1.0", -1},
		{"0.99", "1.99", -1},
		{"0.99", "2.0", -1},
		{"0.99", "0.0.0", 1},
		{"0.99", "0.0.1", 1},
		{"0.99", "0.0.2", 1},
		{"0.99", "0.0.10", 1},
		{"0.99", "0.0.99", 1},
		{"0.99", "0.1.0", 1},
		{"0.99", "0.2.0", 1},
		{"0.99", "0.10.0", 1},
		{"0.99", "0.99.0", -1},
		{"0.99", "0.100.0", -1},
		{"0.99", "0.0.0.0", 1},
		{"0.99", "0.0.0.1", 1},
		{"0.99", "0.0.0.10", 1},
		{"0.99", "0.0.1.0", 1},
		{"0.99", "0.0.01.0", 1},
		{"0.99", "1.2.3.4", -1},
		{"0.99", "1-2-3-4", -1},
		{"0.99", "20150101", -1},
		{"0.99", "20151212", -1},
		{"0.99", "20151212.0", -1},
		{"0.99", "20151212.1", -1},
		{"0.99", "2015.1.1", -1},
		{"0.99", "2015.02.02", -1},
		{"0.99", "2015.12.12", -1},
		{"0.99", "1.2.3a", -1},
		{"0.99", "1.2.3b", -1},
		{"0.99", "R16B", 1},
		{"0.99", "R16C", 1},
		{"0.99", "1.2.3.2016.1.1", -1},
		{"0.99", "0.5a1.dev", 1},
		{"0.99", "1.8.B59BrZX", -1},
		{"0.99", "0.07b4p1", 1},
		{"0.99", "3.99.5final.SP07", -1},
		{"0.99", "3.99.5final.SP08", -1},
		{"0.99", "0.4.tbb.20100203", 1},
		{"0.99", "0.5.20120830CVS.el7", 1},
		{"0.99", "1.el7", -1},
		{"0.99", "1.el6", -1},
		{"0.99", "10.el7", -1},
		{"0.99", "01.el7", -1},
		{"0.99", "0.17.20140318svn632.el7", 1},
		{"0.99", "0.17.20140318svn633.el7", 1},
		{"0.99", "1.20140522gitad6fb3e.el7", -1},
		{"0.99", "1.20140522hitad6fb3e.el7", -1},
		{"0.99", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.99", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.99", "22.svn457.el7", -1},
		{"0.99", "22.svn458.el7", -1},
		{"0.99", "~", 1},
		{"0.99", "~~", 1},
		{"0.99", "~1", 1},
		{"0.99", "~a", 1},
		{"0.99", "1~", -1},
		{"0.99", "2~", -1},
		{"1.0", "", 1},
		{"1.0", "0", 1},
		{"1.0", "1", 1},
		{"1.0", "2", -1},
		{"1.0", "10", -1},
		{"1.0", "100", -1},
		{"1.0", "0.0", 1},
		{"1.0", "0.1", 1},
		{"1.0", "0.10", 1},
		{"1.0", "0.99", 1},
		{"1.0", "1.0", 0},
		{"1.0", "1.99", -1},
		{"1.0", "2.0", -1},
		{"1.0", "0.0.0", 1},
		{"1.0", "0.0.1", 1},
		{"1.0", "0.0.2", 1},
		{"1.0", "0.0.10", 1},
		{"1.0", "0.0.99", 1},
		{"1.0", "0.1.0", 1},
		{"1.0", "0.2.0", 1},
		{"1.0", "0.10.0", 1},
		{"1.0", "0.99.0", 1},
		{"1.0", "0.100.0", 1},
		{"1.0", "0.0.0.0", 1},
		{"1.0", "0.0.0.1", 1},
		{"1.0", "0.0.0.10", 1},
		{"1.0", "0.0.1.0", 1},
		{"1.0", "0.0.01.0", 1},
		{"1.0", "1.2.3.4", -1},
		{"1.0", "1-2-3-4", -1},
		{"1.0", "20150101", -1},
		{"1.0", "20151212", -1},
		{"1.0", "20151212.0", -1},
		{"1.0", "20151212.1", -1},
		{"1.0", "2015.1.1", -1},
		{"1.0", "2015.02.02", -1},
		{"1.0", "2015.12.12", -1},
		{"1.0", "1.2.3a", -1},
		{"1.0", "1.2.3b", -1},
		{"1.0", "R16B", 1},
		{"1.0", "R16C", 1},
		{"1.0", "1.2.3.2016.1.1", -1},
		{"1.0", "0.5a1.dev", 1},
		{"1.0", "1.8.B59BrZX", -1},
		{"1.0", "0.07b4p1", 1},
		{"1.0", "3.99.5final.SP07", -1},
		{"1.0", "3.99.5final.SP08", -1},
		{"1.0", "0.4.tbb.20100203", 1},
		{"1.0", "0.5.20120830CVS.el7", 1},
		{"1.0", "1.el7", 1},
		{"1.0", "1.el6", 1},
		{"1.0", "10.el7", -1},
		{"1.0", "01.el7", 1},
		{"1.0", "0.17.20140318svn632.el7", 1},
		{"1.0", "0.17.20140318svn633.el7", 1},
		{"1.0", "1.20140522gitad6fb3e.el7", -1},
		{"1.0", "1.20140522hitad6fb3e.el7", -1},
		{"1.0", "8.20140605hgacf1c26e3019.el7", -1},
		{"1.0", "8.20140605hgacf1c26e3029.el7", -1},
		{"1.0", "22.svn457.el7", -1},
		{"1.0", "22.svn458.el7", -1},
		{"1.0", "~", 1},
		{"1.0", "~~", 1},
		{"1.0", "~1", 1},
		{"1.0", "~a", 1},
		{"1.0", "1~", 1},
		{"1.0", "2~", -1},
		{"1.99", "", 1},
		{"1.99", "0", 1},
		{"1.99", "1", 1},
		{"1.99", "2", -1},
		{"1.99", "10", -1},
		{"1.99", "100", -1},
		{"1.99", "0.0", 1},
		{"1.99", "0.1", 1},
		{"1.99", "0.10", 1},
		{"1.99", "0.99", 1},
		{"1.99", "1.0", 1},
		{"1.99", "1.99", 0},
		{"1.99", "2.0", -1},
		{"1.99", "0.0.0", 1},
		{"1.99", "0.0.1", 1},
		{"1.99", "0.0.2", 1},
		{"1.99", "0.0.10", 1},
		{"1.99", "0.0.99", 1},
		{"1.99", "0.1.0", 1},
		{"1.99", "0.2.0", 1},
		{"1.99", "0.10.0", 1},
		{"1.99", "0.99.0", 1},
		{"1.99", "0.100.0", 1},
		{"1.99", "0.0.0.0", 1},
		{"1.99", "0.0.0.1", 1},
		{"1.99", "0.0.0.10", 1},
		{"1.99", "0.0.1.0", 1},
		{"1.99", "0.0.01.0", 1},
		{"1.99", "1.2.3.4", 1},
		{"1.99", "1-2-3-4", 1},
		{"1.99", "20150101", -1},
		{"1.99", "20151212", -1},
		{"1.99", "20151212.0", -1},
		{"1.99", "20151212.1", -1},
		{"1.99", "2015.1.1", -1},
		{"1.99", "2015.02.02", -1},
		{"1.99", "2015.12.12", -1},
		{"1.99", "1.2.3a", 1},
		{"1.99", "1.2.3b", 1},
		{"1.99", "R16B", 1},
		{"1.99", "R16C", 1},
		{"1.99", "1.2.3.2016.1.1", 1},
		{"1.99", "0.5a1.dev", 1},
		{"1.99", "1.8.B59BrZX", 1},
		{"1.99", "0.07b4p1", 1},
		{"1.99", "3.99.5final.SP07", -1},
		{"1.99", "3.99.5final.SP08", -1},
		{"1.99", "0.4.tbb.20100203", 1},
		{"1.99", "0.5.20120830CVS.el7", 1},
		{"1.99", "1.el7", 1},
		{"1.99", "1.el6", 1},
		{"1.99", "10.el7", -1},
		{"1.99", "01.el7", 1},
		{"1.99", "0.17.20140318svn632.el7", 1},
		{"1.99", "0.17.20140318svn633.el7", 1},
		{"1.99", "1.20140522gitad6fb3e.el7", -1},
		{"1.99", "1.20140522hitad6fb3e.el7", -1},
		{"1.99", "8.20140605hgacf1c26e3019.el7", -1},
		{"1.99", "8.20140605hgacf1c26e3029.el7", -1},
		{"1.99", "22.svn457.el7", -1},
		{"1.99", "22.svn458.el7", -1},
		{"1.99", "~", 1},
		{"1.99", "~~", 1},
		{"1.99", "~1", 1},
		{"1.99", "~a", 1},
		{"1.99", "1~", 1},
		{"1.99", "2~", -1},
		{"2.0", "", 1},
		{"2.0", "0", 1},
		{"2.0", "1", 1},
		{"2.0", "2", 1},
		{"2.0", "10", -1},
		{"2.0", "100", -1},
		{"2.0", "0.0", 1},
		{"2.0", "0.1", 1},
		{"2.0", "0.10", 1},
		{"2.0", "0.99", 1},
		{"2.0", "1.0", 1},
		{"2.0", "1.99", 1},
		{"2.0", "2.0", 0},
		{"2.0", "0.0.0", 1},
		{"2.0", "0.0.1", 1},
		{"2.0", "0.0.2", 1},
		{"2.0", "0.0.10", 1},
		{"2.0", "0.0.99", 1},
		{"2.0", "0.1.0", 1},
		{"2.0", "0.2.0", 1},
		{"2.0", "0.10.0", 1},
		{"2.0", "0.99.0", 1},
		{"2.0", "0.100.0", 1},
		{"2.0", "0.0.0.0", 1},
		{"2.0", "0.0.0.1", 1},
		{"2.0", "0.0.0.10", 1},
		{"2.0", "0.0.1.0", 1},
		{"2.0", "0.0.01.0", 1},
		{"2.0", "1.2.3.4", 1},
		{"2.0", "1-2-3-4", 1},
		{"2.0", "20150101", -1},
		{"2.0", "20151212", -1},
		{"2.0", "20151212.0", -1},
		{"2.0", "20151212.1", -1},
		{"2.0", "2015.1.1", -1},
		{"2.0", "2015.02.02", -1},
		{"2.0", "2015.12.12", -1},
		{"2.0", "1.2.3a", 1},
		{"2.0", "1.2.3b", 1},
		{"2.0", "R16B", 1},
		{"2.0", "R16C", 1},
		{"2.0", "1.2.3.2016.1.1", 1},
		{"2.0", "0.5a1.dev", 1},
		{"2.0", "1.8.B59BrZX", 1},
		{"2.0", "0.07b4p1", 1},
		{"2.0", "3.99.5final.SP07", -1},
		{"2.0", "3.99.5final.SP08", -1},
		{"2.0", "0.4.tbb.20100203", 1},
		{"2.0", "0.5.20120830CVS.el7", 1},
		{"2.0", "1.el7", 1},
		{"2.0", "1.el6", 1},
		{"2.0", "10.el7", -1},
		{"2.0", "01.el7", 1},
		{"2.0", "0.17.20140318svn632.el7", 1},
		{"2.0", "0.17.20140318svn633.el7", 1},
		{"2.0", "1.20140522gitad6fb3e.el7", 1},
		{"2.0", "1.20140522hitad6fb3e.el7", 1},
		{"2.0", "8.20140605hgacf1c26e3019.el7", -1},
		{"2.0", "8.20140605hgacf1c26e3029.el7", -1},
		{"2.0", "22.svn457.el7", -1},
		{"2.0", "22.svn458.el7", -1},
		{"2.0", "~", 1},
		{"2.0", "~~", 1},
		{"2.0", "~1", 1},
		{"2.0", "~a", 1},
		{"2.0", "1~", 1},
		{"2.0", "2~", 1},
		{"0.0.0", "", 1},
		{"0.0.0", "0", 1},
		{"0.0.0", "1", -1},
		{"0.0.0", "2", -1},
		{"0.0.0", "10", -1},
		{"0.0.0", "100", -1},
		{"0.0.0", "0.0", 1},
		{"0.0.0", "0.1", -1},
		{"0.0.0", "0.10", -1},
		{"0.0.0", "0.99", -1},
		{"0.0.0", "1.0", -1},
		{"0.0.0", "1.99", -1},
		{"0.0.0", "2.0", -1},
		{"0.0.0", "0.0.0", 0},
		{"0.0.0", "0.0.1", -1},
		{"0.0.0", "0.0.2", -1},
		{"0.0.0", "0.0.10", -1},
		{"0.0.0", "0.0.99", -1},
		{"0.0.0", "0.1.0", -1},
		{"0.0.0", "0.2.0", -1},
		{"0.0.0", "0.10.0", -1},
		{"0.0.0", "0.99.0", -1},
		{"0.0.0", "0.100.0", -1},
		{"0.0.0", "0.0.0.0", -1},
		{"0.0.0", "0.0.0.1", -1},
		{"0.0.0", "0.0.0.10", -1},
		{"0.0.0", "0.0.1.0", -1},
		{"0.0.0", "0.0.01.0", -1},
		{"0.0.0", "1.2.3.4", -1},
		{"0.0.0", "1-2-3-4", -1},
		{"0.0.0", "20150101", -1},
		{"0.0.0", "20151212", -1},
		{"0.0.0", "20151212.0", -1},
		{"0.0.0", "20151212.1", -1},
		{"0.0.0", "2015.1.1", -1},
		{"0.0.0", "2015.02.02", -1},
		{"0.0.0", "2015.12.12", -1},
		{"0.0.0", "1.2.3a", -1},
		{"0.0.0", "1.2.3b", -1},
		{"0.0.0", "R16B", 1},
		{"0.0.0", "R16C", 1},
		{"0.0.0", "1.2.3.2016.1.1", -1},
		{"0.0.0", "0.5a1.dev", -1},
		{"0.0.0", "1.8.B59BrZX", -1},
		{"0.0.0", "0.07b4p1", -1},
		{"0.0.0", "3.99.5final.SP07", -1},
		{"0.0.0", "3.99.5final.SP08", -1},
		{"0.0.0", "0.4.tbb.20100203", -1},
		{"0.0.0", "0.5.20120830CVS.el7", -1},
		{"0.0.0", "1.el7", -1},
		{"0.0.0", "1.el6", -1},
		{"0.0.0", "10.el7", -1},
		{"0.0.0", "01.el7", -1},
		{"0.0.0", "0.17.20140318svn632.el7", -1},
		{"0.0.0", "0.17.20140318svn633.el7", -1},
		{"0.0.0", "1.20140522gitad6fb3e.el7", -1},
		{"0.0.0", "1.20140522hitad6fb3e.el7", -1},
		{"0.0.0", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.0.0", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.0.0", "22.svn457.el7", -1},
		{"0.0.0", "22.svn458.el7", -1},
		{"0.0.0", "~", 1},
		{"0.0.0", "~~", 1},
		{"0.0.0", "~1", 1},
		{"0.0.0", "~a", 1},
		{"0.0.0", "1~", -1},
		{"0.0.0", "2~", -1},
		{"0.0.1", "", 1},
		{"0.0.1", "0", 1},
		{"0.0.1", "1", -1},
		{"0.0.1", "2", -1},
		{"0.0.1", "10", -1},
		{"0.0.1", "100", -1},
		{"0.0.1", "0.0", 1},
		{"0.0.1", "0.1", -1},
		{"0.0.1", "0.10", -1},
		{"0.0.1", "0.99", -1},
		{"0.0.1", "1.0", -1},
		{"0.0.1", "1.99", -1},
		{"0.0.1", "2.0", -1},
		{"0.0.1", "0.0.0", 1},
		{"0.0.1", "0.0.1", 0},
		{"0.0.1", "0.0.2", -1},
		{"0.0.1", "0.0.10", -1},
		{"0.0.1", "0.0.99", -1},
		{"0.0.1", "0.1.0", -1},
		{"0.0.1", "0.2.0", -1},
		{"0.0.1", "0.10.0", -1},
		{"0.0.1", "0.99.0", -1},
		{"0.0.1", "0.100.0", -1},
		{"0.0.1", "0.0.0.0", 1},
		{"0.0.1", "0.0.0.1", 1},
		{"0.0.1", "0.0.0.10", 1},
		{"0.0.1", "0.0.1.0", -1},
		{"0.0.1", "0.0.01.0", -1},
		{"0.0.1", "1.2.3.4", -1},
		{"0.0.1", "1-2-3-4", -1},
		{"0.0.1", "20150101", -1},
		{"0.0.1", "20151212", -1},
		{"0.0.1", "20151212.0", -1},
		{"0.0.1", "20151212.1", -1},
		{"0.0.1", "2015.1.1", -1},
		{"0.0.1", "2015.02.02", -1},
		{"0.0.1", "2015.12.12", -1},
		{"0.0.1", "1.2.3a", -1},
		{"0.0.1", "1.2.3b", -1},
		{"0.0.1", "R16B", 1},
		{"0.0.1", "R16C", 1},
		{"0.0.1", "1.2.3.2016.1.1", -1},
		{"0.0.1", "0.5a1.dev", -1},
		{"0.0.1", "1.8.B59BrZX", -1},
		{"0.0.1", "0.07b4p1", -1},
		{"0.0.1", "3.99.5final.SP07", -1},
		{"0.0.1", "3.99.5final.SP08", -1},
		{"0.0.1", "0.4.tbb.20100203", -1},
		{"0.0.1", "0.5.20120830CVS.el7", -1},
		{"0.0.1", "1.el7", -1},
		{"0.0.1", "1.el6", -1},
		{"0.0.1", "10.el7", -1},
		{"0.0.1", "01.el7", -1},
		{"0.0.1", "0.17.20140318svn632.el7", -1},
		{"0.0.1", "0.17.20140318svn633.el7", -1},
		{"0.0.1", "1.20140522gitad6fb3e.el7", -1},
		{"0.0.1", "1.20140522hitad6fb3e.el7", -1},
		{"0.0.1", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.0.1", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.0.1", "22.svn457.el7", -1},
		{"0.0.1", "22.svn458.el7", -1},
		{"0.0.1", "~", 1},
		{"0.0.1", "~~", 1},
		{"0.0.1", "~1", 1},
		{"0.0.1", "~a", 1},
		{"0.0.1", "1~", -1},
		{"0.0.1", "2~", -1},
		{"0.0.2", "", 1},
		{"0.0.2", "0", 1},
		{"0.0.2", "1", -1},
		{"0.0.2", "2", -1},
		{"0.0.2", "10", -1},
		{"0.0.2", "100", -1},
		{"0.0.2", "0.0", 1},
		{"0.0.2", "0.1", -1},
		{"0.0.2", "0.10", -1},
		{"0.0.2", "0.99", -1},
		{"0.0.2", "1.0", -1},
		{"0.0.2", "1.99", -1},
		{"0.0.2", "2.0", -1},
		{"0.0.2", "0.0.0", 1},
		{"0.0.2", "0.0.1", 1},
		{"0.0.2", "0.0.2", 0},
		{"0.0.2", "0.0.10", -1},
		{"0.0.2", "0.0.99", -1},
		{"0.0.2", "0.1.0", -1},
		{"0.0.2", "0.2.0", -1},
		{"0.0.2", "0.10.0", -1},
		{"0.0.2", "0.99.0", -1},
		{"0.0.2", "0.100.0", -1},
		{"0.0.2", "0.0.0.0", 1},
		{"0.0.2", "0.0.0.1", 1},
		{"0.0.2", "0.0.0.10", 1},
		{"0.0.2", "0.0.1.0", 1},
		{"0.0.2", "0.0.01.0", 1},
		{"0.0.2", "1.2.3.4", -1},
		{"0.0.2", "1-2-3-4", -1},
		{"0.0.2", "20150101", -1},
		{"0.0.2", "20151212", -1},
		{"0.0.2", "20151212.0", -1},
		{"0.0.2", "20151212.1", -1},
		{"0.0.2", "2015.1.1", -1},
		{"0.0.2", "2015.02.02", -1},
		{"0.0.2", "2015.12.12", -1},
		{"0.0.2", "1.2.3a", -1},
		{"0.0.2", "1.2.3b", -1},
		{"0.0.2", "R16B", 1},
		{"0.0.2", "R16C", 1},
		{"0.0.2", "1.2.3.2016.1.1", -1},
		{"0.0.2", "0.5a1.dev", -1},
		{"0.0.2", "1.8.B59BrZX", -1},
		{"0.0.2", "0.07b4p1", -1},
		{"0.0.2", "3.99.5final.SP07", -1},
		{"0.0.2", "3.99.5final.SP08", -1},
		{"0.0.2", "0.4.tbb.20100203", -1},
		{"0.0.2", "0.5.20120830CVS.el7", -1},
		{"0.0.2", "1.el7", -1},
		{"0.0.2", "1.el6", -1},
		{"0.0.2", "10.el7", -1},
		{"0.0.2", "01.el7", -1},
		{"0.0.2", "0.17.20140318svn632.el7", -1},
		{"0.0.2", "0.17.20140318svn633.el7", -1},
		{"0.0.2", "1.20140522gitad6fb3e.el7", -1},
		{"0.0.2", "1.20140522hitad6fb3e.el7", -1},
		{"0.0.2", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.0.2", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.0.2", "22.svn457.el7", -1},
		{"0.0.2", "22.svn458.el7", -1},
		{"0.0.2", "~", 1},
		{"0.0.2", "~~", 1},
		{"0.0.2", "~1", 1},
		{"0.0.2", "~a", 1},
		{"0.0.2", "1~", -1},
		{"0.0.2", "2~", -1},
		{"0.0.10", "", 1},
		{"0.0.10", "0", 1},
		{"0.0.10", "1", -1},
		{"0.0.10", "2", -1},
		{"0.0.10", "10", -1},
		{"0.0.10", "100", -1},
		{"0.0.10", "0.0", 1},
		{"0.0.10", "0.1", -1},
		{"0.0.10", "0.10", -1},
		{"0.0.10", "0.99", -1},
		{"0.0.10", "1.0", -1},
		{"0.0.10", "1.99", -1},
		{"0.0.10", "2.0", -1},
		{"0.0.10", "0.0.0", 1},
		{"0.0.10", "0.0.1", 1},
		{"0.0.10", "0.0.2", 1},
		{"0.0.10", "0.0.10", 0},
		{"0.0.10", "0.0.99", -1},
		{"0.0.10", "0.1.0", -1},
		{"0.0.10", "0.2.0", -1},
		{"0.0.10", "0.10.0", -1},
		{"0.0.10", "0.99.0", -1},
		{"0.0.10", "0.100.0", -1},
		{"0.0.10", "0.0.0.0", 1},
		{"0.0.10", "0.0.0.1", 1},
		{"0.0.10", "0.0.0.10", 1},
		{"0.0.10", "0.0.1.0", 1},
		{"0.0.10", "0.0.01.0", 1},
		{"0.0.10", "1.2.3.4", -1},
		{"0.0.10", "1-2-3-4", -1},
		{"0.0.10", "20150101", -1},
		{"0.0.10", "20151212", -1},
		{"0.0.10", "20151212.0", -1},
		{"0.0.10", "20151212.1", -1},
		{"0.0.10", "2015.1.1", -1},
		{"0.0.10", "2015.02.02", -1},
		{"0.0.10", "2015.12.12", -1},
		{"0.0.10", "1.2.3a", -1},
		{"0.0.10", "1.2.3b", -1},
		{"0.0.10", "R16B", 1},
		{"0.0.10", "R16C", 1},
		{"0.0.10", "1.2.3.2016.1.1", -1},
		{"0.0.10", "0.5a1.dev", -1},
		{"0.0.10", "1.8.B59BrZX", -1},
		{"0.0.10", "0.07b4p1", -1},
		{"0.0.10", "3.99.5final.SP07", -1},
		{"0.0.10", "3.99.5final.SP08", -1},
		{"0.0.10", "0.4.tbb.20100203", -1},
		{"0.0.10", "0.5.20120830CVS.el7", -1},
		{"0.0.10", "1.el7", -1},
		{"0.0.10", "1.el6", -1},
		{"0.0.10", "10.el7", -1},
		{"0.0.10", "01.el7", -1},
		{"0.0.10", "0.17.20140318svn632.el7", -1},
		{"0.0.10", "0.17.20140318svn633.el7", -1},
		{"0.0.10", "1.20140522gitad6fb3e.el7", -1},
		{"0.0.10", "1.20140522hitad6fb3e.el7", -1},
		{"0.0.10", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.0.10", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.0.10", "22.svn457.el7", -1},
		{"0.0.10", "22.svn458.el7", -1},
		{"0.0.10", "~", 1},
		{"0.0.10", "~~", 1},
		{"0.0.10", "~1", 1},
		{"0.0.10", "~a", 1},
		{"0.0.10", "1~", -1},
		{"0.0.10", "2~", -1},
		{"0.0.99", "", 1},
		{"0.0.99", "0", 1},
		{"0.0.99", "1", -1},
		{"0.0.99", "2", -1},
		{"0.0.99", "10", -1},
		{"0.0.99", "100", -1},
		{"0.0.99", "0.0", 1},
		{"0.0.99", "0.1", -1},
		{"0.0.99", "0.10", -1},
		{"0.0.99", "0.99", -1},
		{"0.0.99", "1.0", -1},
		{"0.0.99", "1.99", -1},
		{"0.0.99", "2.0", -1},
		{"0.0.99", "0.0.0", 1},
		{"0.0.99", "0.0.1", 1},
		{"0.0.99", "0.0.2", 1},
		{"0.0.99", "0.0.10", 1},
		{"0.0.99", "0.0.99", 0},
		{"0.0.99", "0.1.0", -1},
		{"0.0.99", "0.2.0", -1},
		{"0.0.99", "0.10.0", -1},
		{"0.0.99", "0.99.0", -1},
		{"0.0.99", "0.100.0", -1},
		{"0.0.99", "0.0.0.0", 1},
		{"0.0.99", "0.0.0.1", 1},
		{"0.0.99", "0.0.0.10", 1},
		{"0.0.99", "0.0.1.0", 1},
		{"0.0.99", "0.0.01.0", 1},
		{"0.0.99", "1.2.3.4", -1},
		{"0.0.99", "1-2-3-4", -1},
		{"0.0.99", "20150101", -1},
		{"0.0.99", "20151212", -1},
		{"0.0.99", "20151212.0", -1},
		{"0.0.99", "20151212.1", -1},
		{"0.0.99", "2015.1.1", -1},
		{"0.0.99", "2015.02.02", -1},
		{"0.0.99", "2015.12.12", -1},
		{"0.0.99", "1.2.3a", -1},
		{"0.0.99", "1.2.3b", -1},
		{"0.0.99", "R16B", 1},
		{"0.0.99", "R16C", 1},
		{"0.0.99", "1.2.3.2016.1.1", -1},
		{"0.0.99", "0.5a1.dev", -1},
		{"0.0.99", "1.8.B59BrZX", -1},
		{"0.0.99", "0.07b4p1", -1},
		{"0.0.99", "3.99.5final.SP07", -1},
		{"0.0.99", "3.99.5final.SP08", -1},
		{"0.0.99", "0.4.tbb.20100203", -1},
		{"0.0.99", "0.5.20120830CVS.el7", -1},
		{"0.0.99", "1.el7", -1},
		{"0.0.99", "1.el6", -1},
		{"0.0.99", "10.el7", -1},
		{"0.0.99", "01.el7", -1},
		{"0.0.99", "0.17.20140318svn632.el7", -1},
		{"0.0.99", "0.17.20140318svn633.el7", -1},
		{"0.0.99", "1.20140522gitad6fb3e.el7", -1},
		{"0.0.99", "1.20140522hitad6fb3e.el7", -1},
		{"0.0.99", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.0.99", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.0.99", "22.svn457.el7", -1},
		{"0.0.99", "22.svn458.el7", -1},
		{"0.0.99", "~", 1},
		{"0.0.99", "~~", 1},
		{"0.0.99", "~1", 1},
		{"0.0.99", "~a", 1},
		{"0.0.99", "1~", -1},
		{"0.0.99", "2~", -1},
		{"0.1.0", "", 1},
		{"0.1.0", "0", 1},
		{"0.1.0", "1", -1},
		{"0.1.0", "2", -1},
		{"0.1.0", "10", -1},
		{"0.1.0", "100", -1},
		{"0.1.0", "0.0", 1},
		{"0.1.0", "0.1", 1},
		{"0.1.0", "0.10", -1},
		{"0.1.0", "0.99", -1},
		{"0.1.0", "1.0", -1},
		{"0.1.0", "1.99", -1},
		{"0.1.0", "2.0", -1},
		{"0.1.0", "0.0.0", 1},
		{"0.1.0", "0.0.1", 1},
		{"0.1.0", "0.0.2", 1},
		{"0.1.0", "0.0.10", 1},
		{"0.1.0", "0.0.99", 1},
		{"0.1.0", "0.1.0", 0},
		{"0.1.0", "0.2.0", -1},
		{"0.1.0", "0.10.0", -1},
		{"0.1.0", "0.99.0", -1},
		{"0.1.0", "0.100.0", -1},
		{"0.1.0", "0.0.0.0", 1},
		{"0.1.0", "0.0.0.1", 1},
		{"0.1.0", "0.0.0.10", 1},
		{"0.1.0", "0.0.1.0", 1},
		{"0.1.0", "0.0.01.0", 1},
		{"0.1.0", "1.2.3.4", -1},
		{"0.1.0", "1-2-3-4", -1},
		{"0.1.0", "20150101", -1},
		{"0.1.0", "20151212", -1},
		{"0.1.0", "20151212.0", -1},
		{"0.1.0", "20151212.1", -1},
		{"0.1.0", "2015.1.1", -1},
		{"0.1.0", "2015.02.02", -1},
		{"0.1.0", "2015.12.12", -1},
		{"0.1.0", "1.2.3a", -1},
		{"0.1.0", "1.2.3b", -1},
		{"0.1.0", "R16B", 1},
		{"0.1.0", "R16C", 1},
		{"0.1.0", "1.2.3.2016.1.1", -1},
		{"0.1.0", "0.5a1.dev", -1},
		{"0.1.0", "1.8.B59BrZX", -1},
		{"0.1.0", "0.07b4p1", -1},
		{"0.1.0", "3.99.5final.SP07", -1},
		{"0.1.0", "3.99.5final.SP08", -1},
		{"0.1.0", "0.4.tbb.20100203", -1},
		{"0.1.0", "0.5.20120830CVS.el7", -1},
		{"0.1.0", "1.el7", -1},
		{"0.1.0", "1.el6", -1},
		{"0.1.0", "10.el7", -1},
		{"0.1.0", "01.el7", -1},
		{"0.1.0", "0.17.20140318svn632.el7", -1},
		{"0.1.0", "0.17.20140318svn633.el7", -1},
		{"0.1.0", "1.20140522gitad6fb3e.el7", -1},
		{"0.1.0", "1.20140522hitad6fb3e.el7", -1},
		{"0.1.0", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.1.0", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.1.0", "22.svn457.el7", -1},
		{"0.1.0", "22.svn458.el7", -1},
		{"0.1.0", "~", 1},
		{"0.1.0", "~~", 1},
		{"0.1.0", "~1", 1},
		{"0.1.0", "~a", 1},
		{"0.1.0", "1~", -1},
		{"0.1.0", "2~", -1},
		{"0.2.0", "", 1},
		{"0.2.0", "0", 1},
		{"0.2.0", "1", -1},
		{"0.2.0", "2", -1},
		{"0.2.0", "10", -1},
		{"0.2.0", "100", -1},
		{"0.2.0", "0.0", 1},
		{"0.2.0", "0.1", 1},
		{"0.2.0", "0.10", -1},
		{"0.2.0", "0.99", -1},
		{"0.2.0", "1.0", -1},
		{"0.2.0", "1.99", -1},
		{"0.2.0", "2.0", -1},
		{"0.2.0", "0.0.0", 1},
		{"0.2.0", "0.0.1", 1},
		{"0.2.0", "0.0.2", 1},
		{"0.2.0", "0.0.10", 1},
		{"0.2.0", "0.0.99", 1},
		{"0.2.0", "0.1.0", 1},
		{"0.2.0", "0.2.0", 0},
		{"0.2.0", "0.10.0", -1},
		{"0.2.0", "0.99.0", -1},
		{"0.2.0", "0.100.0", -1},
		{"0.2.0", "0.0.0.0", 1},
		{"0.2.0", "0.0.0.1", 1},
		{"0.2.0", "0.0.0.10", 1},
		{"0.2.0", "0.0.1.0", 1},
		{"0.2.0", "0.0.01.0", 1},
		{"0.2.0", "1.2.3.4", -1},
		{"0.2.0", "1-2-3-4", -1},
		{"0.2.0", "20150101", -1},
		{"0.2.0", "20151212", -1},
		{"0.2.0", "20151212.0", -1},
		{"0.2.0", "20151212.1", -1},
		{"0.2.0", "2015.1.1", -1},
		{"0.2.0", "2015.02.02", -1},
		{"0.2.0", "2015.12.12", -1},
		{"0.2.0", "1.2.3a", -1},
		{"0.2.0", "1.2.3b", -1},
		{"0.2.0", "R16B", 1},
		{"0.2.0", "R16C", 1},
		{"0.2.0", "1.2.3.2016.1.1", -1},
		{"0.2.0", "0.5a1.dev", -1},
		{"0.2.0", "1.8.B59BrZX", -1},
		{"0.2.0", "0.07b4p1", -1},
		{"0.2.0", "3.99.5final.SP07", -1},
		{"0.2.0", "3.99.5final.SP08", -1},
		{"0.2.0", "0.4.tbb.20100203", -1},
		{"0.2.0", "0.5.20120830CVS.el7", -1},
		{"0.2.0", "1.el7", -1},
		{"0.2.0", "1.el6", -1},
		{"0.2.0", "10.el7", -1},
		{"0.2.0", "01.el7", -1},
		{"0.2.0", "0.17.20140318svn632.el7", -1},
		{"0.2.0", "0.17.20140318svn633.el7", -1},
		{"0.2.0", "1.20140522gitad6fb3e.el7", -1},
		{"0.2.0", "1.20140522hitad6fb3e.el7", -1},
		{"0.2.0", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.2.0", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.2.0", "22.svn457.el7", -1},
		{"0.2.0", "22.svn458.el7", -1},
		{"0.2.0", "~", 1},
		{"0.2.0", "~~", 1},
		{"0.2.0", "~1", 1},
		{"0.2.0", "~a", 1},
		{"0.2.0", "1~", -1},
		{"0.2.0", "2~", -1},
		{"0.10.0", "", 1},
		{"0.10.0", "0", 1},
		{"0.10.0", "1", -1},
		{"0.10.0", "2", -1},
		{"0.10.0", "10", -1},
		{"0.10.0", "100", -1},
		{"0.10.0", "0.0", 1},
		{"0.10.0", "0.1", 1},
		{"0.10.0", "0.10", 1},
		{"0.10.0", "0.99", -1},
		{"0.10.0", "1.0", -1},
		{"0.10.0", "1.99", -1},
		{"0.10.0", "2.0", -1},
		{"0.10.0", "0.0.0", 1},
		{"0.10.0", "0.0.1", 1},
		{"0.10.0", "0.0.2", 1},
		{"0.10.0", "0.0.10", 1},
		{"0.10.0", "0.0.99", 1},
		{"0.10.0", "0.1.0", 1},
		{"0.10.0", "0.2.0", 1},
		{"0.10.0", "0.10.0", 0},
		{"0.10.0", "0.99.0", -1},
		{"0.10.0", "0.100.0", -1},
		{"0.10.0", "0.0.0.0", 1},
		{"0.10.0", "0.0.0.1", 1},
		{"0.10.0", "0.0.0.10", 1},
		{"0.10.0", "0.0.1.0", 1},
		{"0.10.0", "0.0.01.0", 1},
		{"0.10.0", "1.2.3.4", -1},
		{"0.10.0", "1-2-3-4", -1},
		{"0.10.0", "20150101", -1},
		{"0.10.0", "20151212", -1},
		{"0.10.0", "20151212.0", -1},
		{"0.10.0", "20151212.1", -1},
		{"0.10.0", "2015.1.1", -1},
		{"0.10.0", "2015.02.02", -1},
		{"0.10.0", "2015.12.12", -1},
		{"0.10.0", "1.2.3a", -1},
		{"0.10.0", "1.2.3b", -1},
		{"0.10.0", "R16B", 1},
		{"0.10.0", "R16C", 1},
		{"0.10.0", "1.2.3.2016.1.1", -1},
		{"0.10.0", "0.5a1.dev", 1},
		{"0.10.0", "1.8.B59BrZX", -1},
		{"0.10.0", "0.07b4p1", 1},
		{"0.10.0", "3.99.5final.SP07", -1},
		{"0.10.0", "3.99.5final.SP08", -1},
		{"0.10.0", "0.4.tbb.20100203", 1},
		{"0.10.0", "0.5.20120830CVS.el7", 1},
		{"0.10.0", "1.el7", -1},
		{"0.10.0", "1.el6", -1},
		{"0.10.0", "10.el7", -1},
		{"0.10.0", "01.el7", -1},
		{"0.10.0", "0.17.20140318svn632.el7", -1},
		{"0.10.0", "0.17.20140318svn633.el7", -1},
		{"0.10.0", "1.20140522gitad6fb3e.el7", -1},
		{"0.10.0", "1.20140522hitad6fb3e.el7", -1},
		{"0.10.0", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.10.0", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.10.0", "22.svn457.el7", -1},
		{"0.10.0", "22.svn458.el7", -1},
		{"0.10.0", "~", 1},
		{"0.10.0", "~~", 1},
		{"0.10.0", "~1", 1},
		{"0.10.0", "~a", 1},
		{"0.10.0", "1~", -1},
		{"0.10.0", "2~", -1},
		{"0.99.0", "", 1},
		{"0.99.0", "0", 1},
		{"0.99.0", "1", -1},
		{"0.99.0", "2", -1},
		{"0.99.0", "10", -1},
		{"0.99.0", "100", -1},
		{"0.99.0", "0.0", 1},
		{"0.99.0", "0.1", 1},
		{"0.99.0", "0.10", 1},
		{"0.99.0", "0.99", 1},
		{"0.99.0", "1.0", -1},
		{"0.99.0", "1.99", -1},
		{"0.99.0", "2.0", -1},
		{"0.99.0", "0.0.0", 1},
		{"0.99.0", "0.0.1", 1},
		{"0.99.0", "0.0.2", 1},
		{"0.99.0", "0.0.10", 1},
		{"0.99.0", "0.0.99", 1},
		{"0.99.0", "0.1.0", 1},
		{"0.99.0", "0.2.0", 1},
		{"0.99.0", "0.10.0", 1},
		{"0.99.0", "0.99.0", 0},
		{"0.99.0", "0.100.0", -1},
		{"0.99.0", "0.0.0.0", 1},
		{"0.99.0", "0.0.0.1", 1},
		{"0.99.0", "0.0.0.10", 1},
		{"0.99.0", "0.0.1.0", 1},
		{"0.99.0", "0.0.01.0", 1},
		{"0.99.0", "1.2.3.4", -1},
		{"0.99.0", "1-2-3-4", -1},
		{"0.99.0", "20150101", -1},
		{"0.99.0", "20151212", -1},
		{"0.99.0", "20151212.0", -1},
		{"0.99.0", "20151212.1", -1},
		{"0.99.0", "2015.1.1", -1},
		{"0.99.0", "2015.02.02", -1},
		{"0.99.0", "2015.12.12", -1},
		{"0.99.0", "1.2.3a", -1},
		{"0.99.0", "1.2.3b", -1},
		{"0.99.0", "R16B", 1},
		{"0.99.0", "R16C", 1},
		{"0.99.0", "1.2.3.2016.1.1", -1},
		{"0.99.0", "0.5a1.dev", 1},
		{"0.99.0", "1.8.B59BrZX", -1},
		{"0.99.0", "0.07b4p1", 1},
		{"0.99.0", "3.99.5final.SP07", -1},
		{"0.99.0", "3.99.5final.SP08", -1},
		{"0.99.0", "0.4.tbb.20100203", 1},
		{"0.99.0", "0.5.20120830CVS.el7", 1},
		{"0.99.0", "1.el7", -1},
		{"0.99.0", "1.el6", -1},
		{"0.99.0", "10.el7", -1},
		{"0.99.0", "01.el7", -1},
		{"0.99.0", "0.17.20140318svn632.el7", 1},
		{"0.99.0", "0.17.20140318svn633.el7", 1},
		{"0.99.0", "1.20140522gitad6fb3e.el7", -1},
		{"0.99.0", "1.20140522hitad6fb3e.el7", -1},
		{"0.99.0", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.99.0", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.99.0", "22.svn457.el7", -1},
		{"0.99.0", "22.svn458.el7", -1},
		{"0.99.0", "~", 1},
		{"0.99.0", "~~", 1},
		{"0.99.0", "~1", 1},
		{"0.99.0", "~a", 1},
		{"0.99.0", "1~", -1},
		{"0.99.0", "2~", -1},
		{"0.100.0", "", 1},
		{"0.100.0", "0", 1},
		{"0.100.0", "1", -1},
		{"0.100.0", "2", -1},
		{"0.100.0", "10", -1},
		{"0.100.0", "100", -1},
		{"0.100.0", "0.0", 1},
		{"0.100.0", "0.1", 1},
		{"0.100.0", "0.10", 1},
		{"0.100.0", "0.99", 1},
		{"0.100.0", "1.0", -1},
		{"0.100.0", "1.99", -1},
		{"0.100.0", "2.0", -1},
		{"0.100.0", "0.0.0", 1},
		{"0.100.0", "0.0.1", 1},
		{"0.100.0", "0.0.2", 1},
		{"0.100.0", "0.0.10", 1},
		{"0.100.0", "0.0.99", 1},
		{"0.100.0", "0.1.0", 1},
		{"0.100.0", "0.2.0", 1},
		{"0.100.0", "0.10.0", 1},
		{"0.100.0", "0.99.0", 1},
		{"0.100.0", "0.100.0", 0},
		{"0.100.0", "0.0.0.0", 1},
		{"0.100.0", "0.0.0.1", 1},
		{"0.100.0", "0.0.0.10", 1},
		{"0.100.0", "0.0.1.0", 1},
		{"0.100.0", "0.0.01.0", 1},
		{"0.100.0", "1.2.3.4", -1},
		{"0.100.0", "1-2-3-4", -1},
		{"0.100.0", "20150101", -1},
		{"0.100.0", "20151212", -1},
		{"0.100.0", "20151212.0", -1},
		{"0.100.0", "20151212.1", -1},
		{"0.100.0", "2015.1.1", -1},
		{"0.100.0", "2015.02.02", -1},
		{"0.100.0", "2015.12.12", -1},
		{"0.100.0", "1.2.3a", -1},
		{"0.100.0", "1.2.3b", -1},
		{"0.100.0", "R16B", 1},
		{"0.100.0", "R16C", 1},
		{"0.100.0", "1.2.3.2016.1.1", -1},
		{"0.100.0", "0.5a1.dev", 1},
		{"0.100.0", "1.8.B59BrZX", -1},
		{"0.100.0", "0.07b4p1", 1},
		{"0.100.0", "3.99.5final.SP07", -1},
		{"0.100.0", "3.99.5final.SP08", -1},
		{"0.100.0", "0.4.tbb.20100203", 1},
		{"0.100.0", "0.5.20120830CVS.el7", 1},
		{"0.100.0", "1.el7", -1},
		{"0.100.0", "1.el6", -1},
		{"0.100.0", "10.el7", -1},
		{"0.100.0", "01.el7", -1},
		{"0.100.0", "0.17.20140318svn632.el7", 1},
		{"0.100.0", "0.17.20140318svn633.el7", 1},
		{"0.100.0", "1.20140522gitad6fb3e.el7", -1},
		{"0.100.0", "1.20140522hitad6fb3e.el7", -1},
		{"0.100.0", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.100.0", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.100.0", "22.svn457.el7", -1},
		{"0.100.0", "22.svn458.el7", -1},
		{"0.100.0", "~", 1},
		{"0.100.0", "~~", 1},
		{"0.100.0", "~1", 1},
		{"0.100.0", "~a", 1},
		{"0.100.0", "1~", -1},
		{"0.100.0", "2~", -1},
		{"0.0.0.0", "", 1},
		{"0.0.0.0", "0", 1},
		{"0.0.0.0", "1", -1},
		{"0.0.0.0", "2", -1},
		{"0.0.0.0", "10", -1},
		{"0.0.0.0", "100", -1},
		{"0.0.0.0", "0.0", 1},
		{"0.0.0.0", "0.1", -1},
		{"0.0.0.0", "0.10", -1},
		{"0.0.0.0", "0.99", -1},
		{"0.0.0.0", "1.0", -1},
		{"0.0.0.0", "1.99", -1},
		{"0.0.0.0", "2.0", -1},
		{"0.0.0.0", "0.0.0", 1},
		{"0.0.0.0", "0.0.1", -1},
		{"0.0.0.0", "0.0.2", -1},
		{"0.0.0.0", "0.0.10", -1},
		{"0.0.0.0", "0.0.99", -1},
		{"0.0.0.0", "0.1.0", -1},
		{"0.0.0.0", "0.2.0", -1},
		{"0.0.0.0", "0.10.0", -1},
		{"0.0.0.0", "0.99.0", -1},
		{"0.0.0.0", "0.100.0", -1},
		{"0.0.0.0", "0.0.0.0", 0},
		{"0.0.0.0", "0.0.0.1", -1},
		{"0.0.0.0", "0.0.0.10", -1},
		{"0.0.0.0", "0.0.1.0", -1},
		{"0.0.0.0", "0.0.01.0", -1},
		{"0.0.0.0", "1.2.3.4", -1},
		{"0.0.0.0", "1-2-3-4", -1},
		{"0.0.0.0", "20150101", -1},
		{"0.0.0.0", "20151212", -1},
		{"0.0.0.0", "20151212.0", -1},
		{"0.0.0.0", "20151212.1", -1},
		{"0.0.0.0", "2015.1.1", -1},
		{"0.0.0.0", "2015.02.02", -1},
		{"0.0.0.0", "2015.12.12", -1},
		{"0.0.0.0", "1.2.3a", -1},
		{"0.0.0.0", "1.2.3b", -1},
		{"0.0.0.0", "R16B", 1},
		{"0.0.0.0", "R16C", 1},
		{"0.0.0.0", "1.2.3.2016.1.1", -1},
		{"0.0.0.0", "0.5a1.dev", -1},
		{"0.0.0.0", "1.8.B59BrZX", -1},
		{"0.0.0.0", "0.07b4p1", -1},
		{"0.0.0.0", "3.99.5final.SP07", -1},
		{"0.0.0.0", "3.99.5final.SP08", -1},
		{"0.0.0.0", "0.4.tbb.20100203", -1},
		{"0.0.0.0", "0.5.20120830CVS.el7", -1},
		{"0.0.0.0", "1.el7", -1},
		{"0.0.0.0", "1.el6", -1},
		{"0.0.0.0", "10.el7", -1},
		{"0.0.0.0", "01.el7", -1},
		{"0.0.0.0", "0.17.20140318svn632.el7", -1},
		{"0.0.0.0", "0.17.20140318svn633.el7", -1},
		{"0.0.0.0", "1.20140522gitad6fb3e.el7", -1},
		{"0.0.0.0", "1.20140522hitad6fb3e.el7", -1},
		{"0.0.0.0", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.0.0.0", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.0.0.0", "22.svn457.el7", -1},
		{"0.0.0.0", "22.svn458.el7", -1},
		{"0.0.0.0", "~", 1},
		{"0.0.0.0", "~~", 1},
		{"0.0.0.0", "~1", 1},
		{"0.0.0.0", "~a", 1},
		{"0.0.0.0", "1~", -1},
		{"0.0.0.0", "2~", -1},
		{"0.0.0.1", "", 1},
		{"0.0.0.1", "0", 1},
		{"0.0.0.1", "1", -1},
		{"0.0.0.1", "2", -1},
		{"0.0.0.1", "10", -1},
		{"0.0.0.1", "100", -1},
		{"0.0.0.1", "0.0", 1},
		{"0.0.0.1", "0.1", -1},
		{"0.0.0.1", "0.10", -1},
		{"0.0.0.1", "0.99", -1},
		{"0.0.0.1", "1.0", -1},
		{"0.0.0.1", "1.99", -1},
		{"0.0.0.1", "2.0", -1},
		{"0.0.0.1", "0.0.0", 1},
		{"0.0.0.1", "0.0.1", -1},
		{"0.0.0.1", "0.0.2", -1},
		{"0.0.0.1", "0.0.10", -1},
		{"0.0.0.1", "0.0.99", -1},
		{"0.0.0.1", "0.1.0", -1},
		{"0.0.0.1", "0.2.0", -1},
		{"0.0.0.1", "0.10.0", -1},
		{"0.0.0.1", "0.99.0", -1},
		{"0.0.0.1", "0.100.0", -1},
		{"0.0.0.1", "0.0.0.0", 1},
		{"0.0.0.1", "0.0.0.1", 0},
		{"0.0.0.1", "0.0.0.10", -1},
		{"0.0.0.1", "0.0.1.0", -1},
		{"0.0.0.1", "0.0.01.0", -1},
		{"0.0.0.1", "1.2.3.4", -1},
		{"0.0.0.1", "1-2-3-4", -1},
		{"0.0.0.1", "20150101", -1},
		{"0.0.0.1", "20151212", -1},
		{"0.0.0.1", "20151212.0", -1},
		{"0.0.0.1", "20151212.1", -1},
		{"0.0.0.1", "2015.1.1", -1},
		{"0.0.0.1", "2015.02.02", -1},
		{"0.0.0.1", "2015.12.12", -1},
		{"0.0.0.1", "1.2.3a", -1},
		{"0.0.0.1", "1.2.3b", -1},
		{"0.0.0.1", "R16B", 1},
		{"0.0.0.1", "R16C", 1},
		{"0.0.0.1", "1.2.3.2016.1.1", -1},
		{"0.0.0.1", "0.5a1.dev", -1},
		{"0.0.0.1", "1.8.B59BrZX", -1},
		{"0.0.0.1", "0.07b4p1", -1},
		{"0.0.0.1", "3.99.5final.SP07", -1},
		{"0.0.0.1", "3.99.5final.SP08", -1},
		{"0.0.0.1", "0.4.tbb.20100203", -1},
		{"0.0.0.1", "0.5.20120830CVS.el7", -1},
		{"0.0.0.1", "1.el7", -1},
		{"0.0.0.1", "1.el6", -1},
		{"0.0.0.1", "10.el7", -1},
		{"0.0.0.1", "01.el7", -1},
		{"0.0.0.1", "0.17.20140318svn632.el7", -1},
		{"0.0.0.1", "0.17.20140318svn633.el7", -1},
		{"0.0.0.1", "1.20140522gitad6fb3e.el7", -1},
		{"0.0.0.1", "1.20140522hitad6fb3e.el7", -1},
		{"0.0.0.1", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.0.0.1", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.0.0.1", "22.svn457.el7", -1},
		{"0.0.0.1", "22.svn458.el7", -1},
		{"0.0.0.1", "~", 1},
		{"0.0.0.1", "~~", 1},
		{"0.0.0.1", "~1", 1},
		{"0.0.0.1", "~a", 1},
		{"0.0.0.1", "1~", -1},
		{"0.0.0.1", "2~", -1},
		{"0.0.0.10", "", 1},
		{"0.0.0.10", "0", 1},
		{"0.0.0.10", "1", -1},
		{"0.0.0.10", "2", -1},
		{"0.0.0.10", "10", -1},
		{"0.0.0.10", "100", -1},
		{"0.0.0.10", "0.0", 1},
		{"0.0.0.10", "0.1", -1},
		{"0.0.0.10", "0.10", -1},
		{"0.0.0.10", "0.99", -1},
		{"0.0.0.10", "1.0", -1},
		{"0.0.0.10", "1.99", -1},
		{"0.0.0.10", "2.0", -1},
		{"0.0.0.10", "0.0.0", 1},
		{"0.0.0.10", "0.0.1", -1},
		{"0.0.0.10", "0.0.2", -1},
		{"0.0.0.10", "0.0.10", -1},
		{"0.0.0.10", "0.0.99", -1},
		{"0.0.0.10", "0.1.0", -1},
		{"0.0.0.10", "0.2.0", -1},
		{"0.0.0.10", "0.10.0", -1},
		{"0.0.0.10", "0.99.0", -1},
		{"0.0.0.10", "0.100.0", -1},
		{"0.0.0.10", "0.0.0.0", 1},
		{"0.0.0.10", "0.0.0.1", 1},
		{"0.0.0.10", "0.0.0.10", 0},
		{"0.0.0.10", "0.0.1.0", -1},
		{"0.0.0.10", "0.0.01.0", -1},
		{"0.0.0.10", "1.2.3.4", -1},
		{"0.0.0.10", "1-2-3-4", -1},
		{"0.0.0.10", "20150101", -1},
		{"0.0.0.10", "20151212", -1},
		{"0.0.0.10", "20151212.0", -1},
		{"0.0.0.10", "20151212.1", -1},
		{"0.0.0.10", "2015.1.1", -1},
		{"0.0.0.10", "2015.02.02", -1},
		{"0.0.0.10", "2015.12.12", -1},
		{"0.0.0.10", "1.2.3a", -1},
		{"0.0.0.10", "1.2.3b", -1},
		{"0.0.0.10", "R16B", 1},
		{"0.0.0.10", "R16C", 1},
		{"0.0.0.10", "1.2.3.2016.1.1", -1},
		{"0.0.0.10", "0.5a1.dev", -1},
		{"0.0.0.10", "1.8.B59BrZX", -1},
		{"0.0.0.10", "0.07b4p1", -1},
		{"0.0.0.10", "3.99.5final.SP07", -1},
		{"0.0.0.10", "3.99.5final.SP08", -1},
		{"0.0.0.10", "0.4.tbb.20100203", -1},
		{"0.0.0.10", "0.5.20120830CVS.el7", -1},
		{"0.0.0.10", "1.el7", -1},
		{"0.0.0.10", "1.el6", -1},
		{"0.0.0.10", "10.el7", -1},
		{"0.0.0.10", "01.el7", -1},
		{"0.0.0.10", "0.17.20140318svn632.el7", -1},
		{"0.0.0.10", "0.17.20140318svn633.el7", -1},
		{"0.0.0.10", "1.20140522gitad6fb3e.el7", -1},
		{"0.0.0.10", "1.20140522hitad6fb3e.el7", -1},
		{"0.0.0.10", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.0.0.10", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.0.0.10", "22.svn457.el7", -1},
		{"0.0.0.10", "22.svn458.el7", -1},
		{"0.0.0.10", "~", 1},
		{"0.0.0.10", "~~", 1},
		{"0.0.0.10", "~1", 1},
		{"0.0.0.10", "~a", 1},
		{"0.0.0.10", "1~", -1},
		{"0.0.0.10", "2~", -1},
		{"0.0.1.0", "", 1},
		{"0.0.1.0", "0", 1},
		{"0.0.1.0", "1", -1},
		{"0.0.1.0", "2", -1},
		{"0.0.1.0", "10", -1},
		{"0.0.1.0", "100", -1},
		{"0.0.1.0", "0.0", 1},
		{"0.0.1.0", "0.1", -1},
		{"0.0.1.0", "0.10", -1},
		{"0.0.1.0", "0.99", -1},
		{"0.0.1.0", "1.0", -1},
		{"0.0.1.0", "1.99", -1},
		{"0.0.1.0", "2.0", -1},
		{"0.0.1.0", "0.0.0", 1},
		{"0.0.1.0", "0.0.1", 1},
		{"0.0.1.0", "0.0.2", -1},
		{"0.0.1.0", "0.0.10", -1},
		{"0.0.1.0", "0.0.99", -1},
		{"0.0.1.0", "0.1.0", -1},
		{"0.0.1.0", "0.2.0", -1},
		{"0.0.1.0", "0.10.0", -1},
		{"0.0.1.0", "0.99.0", -1},
		{"0.0.1.0", "0.100.0", -1},
		{"0.0.1.0", "0.0.0.0", 1},
		{"0.0.1.0", "0.0.0.1", 1},
		{"0.0.1.0", "0.0.0.10", 1},
		{"0.0.1.0", "0.0.1.0", 0},
		{"0.0.1.0", "0.0.01.0", 0},
		{"0.0.1.0", "1.2.3.4", -1},
		{"0.0.1.0", "1-2-3-4", -1},
		{"0.0.1.0", "20150101", -1},
		{"0.0.1.0", "20151212", -1},
		{"0.0.1.0", "20151212.0", -1},
		{"0.0.1.0", "20151212.1", -1},
		{"0.0.1.0", "2015.1.1", -1},
		{"0.0.1.0", "2015.02.02", -1},
		{"0.0.1.0", "2015.12.12", -1},
		{"0.0.1.0", "1.2.3a", -1},
		{"0.0.1.0", "1.2.3b", -1},
		{"0.0.1.0", "R16B", 1},
		{"0.0.1.0", "R16C", 1},
		{"0.0.1.0", "1.2.3.2016.1.1", -1},
		{"0.0.1.0", "0.5a1.dev", -1},
		{"0.0.1.0", "1.8.B59BrZX", -1},
		{"0.0.1.0", "0.07b4p1", -1},
		{"0.0.1.0", "3.99.5final.SP07", -1},
		{"0.0.1.0", "3.99.5final.SP08", -1},
		{"0.0.1.0", "0.4.tbb.20100203", -1},
		{"0.0.1.0", "0.5.20120830CVS.el7", -1},
		{"0.0.1.0", "1.el7", -1},
		{"0.0.1.0", "1.el6", -1},
		{"0.0.1.0", "10.el7", -1},
		{"0.0.1.0", "01.el7", -1},
		{"0.0.1.0", "0.17.20140318svn632.el7", -1},
		{"0.0.1.0", "0.17.20140318svn633.el7", -1},
		{"0.0.1.0", "1.20140522gitad6fb3e.el7", -1},
		{"0.0.1.0", "1.20140522hitad6fb3e.el7", -1},
		{"0.0.1.0", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.0.1.0", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.0.1.0", "22.svn457.el7", -1},
		{"0.0.1.0", "22.svn458.el7", -1},
		{"0.0.1.0", "~", 1},
		{"0.0.1.0", "~~", 1},
		{"0.0.1.0", "~1", 1},
		{"0.0.1.0", "~a", 1},
		{"0.0.1.0", "1~", -1},
		{"0.0.1.0", "2~", -1},
		{"0.0.01.0", "", 1},
		{"0.0.01.0", "0", 1},
		{"0.0.01.0", "1", -1},
		{"0.0.01.0", "2", -1},
		{"0.0.01.0", "10", -1},
		{"0.0.01.0", "100", -1},
		{"0.0.01.0", "0.0", 1},
		{"0.0.01.0", "0.1", -1},
		{"0.0.01.0", "0.10", -1},
		{"0.0.01.0", "0.99", -1},
		{"0.0.01.0", "1.0", -1},
		{"0.0.01.0", "1.99", -1},
		{"0.0.01.0", "2.0", -1},
		{"0.0.01.0", "0.0.0", 1},
		{"0.0.01.0", "0.0.1", 1},
		{"0.0.01.0", "0.0.2", -1},
		{"0.0.01.0", "0.0.10", -1},
		{"0.0.01.0", "0.0.99", -1},
		{"0.0.01.0", "0.1.0", -1},
		{"0.0.01.0", "0.2.0", -1},
		{"0.0.01.0", "0.10.0", -1},
		{"0.0.01.0", "0.99.0", -1},
		{"0.0.01.0", "0.100.0", -1},
		{"0.0.01.0", "0.0.0.0", 1},
		{"0.0.01.0", "0.0.0.1", 1},
		{"0.0.01.0", "0.0.0.10", 1},
		{"0.0.01.0", "0.0.1.0", 0},
		{"0.0.01.0", "0.0.01.0", 0},
		{"0.0.01.0", "1.2.3.4", -1},
		{"0.0.01.0", "1-2-3-4", -1},
		{"0.0.01.0", "20150101", -1},
		{"0.0.01.0", "20151212", -1},
		{"0.0.01.0", "20151212.0", -1},
		{"0.0.01.0", "20151212.1", -1},
		{"0.0.01.0", "2015.1.1", -1},
		{"0.0.01.0", "2015.02.02", -1},
		{"0.0.01.0", "2015.12.12", -1},
		{"0.0.01.0", "1.2.3a", -1},
		{"0.0.01.0", "1.2.3b", -1},
		{"0.0.01.0", "R16B", 1},
		{"0.0.01.0", "R16C", 1},
		{"0.0.01.0", "1.2.3.2016.1.1", -1},
		{"0.0.01.0", "0.5a1.dev", -1},
		{"0.0.01.0", "1.8.B59BrZX", -1},
		{"0.0.01.0", "0.07b4p1", -1},
		{"0.0.01.0", "3.99.5final.SP07", -1},
		{"0.0.01.0", "3.99.5final.SP08", -1},
		{"0.0.01.0", "0.4.tbb.20100203", -1},
		{"0.0.01.0", "0.5.20120830CVS.el7", -1},
		{"0.0.01.0", "1.el7", -1},
		{"0.0.01.0", "1.el6", -1},
		{"0.0.01.0", "10.el7", -1},
		{"0.0.01.0", "01.el7", -1},
		{"0.0.01.0", "0.17.20140318svn632.el7", -1},
		{"0.0.01.0", "0.17.20140318svn633.el7", -1},
		{"0.0.01.0", "1.20140522gitad6fb3e.el7", -1},
		{"0.0.01.0", "1.20140522hitad6fb3e.el7", -1},
		{"0.0.01.0", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.0.01.0", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.0.01.0", "22.svn457.el7", -1},
		{"0.0.01.0", "22.svn458.el7", -1},
		{"0.0.01.0", "~", 1},
		{"0.0.01.0", "~~", 1},
		{"0.0.01.0", "~1", 1},
		{"0.0.01.0", "~a", 1},
		{"0.0.01.0", "1~", -1},
		{"0.0.01.0", "2~", -1},
		{"1.2.3.4", "", 1},
		{"1.2.3.4", "0", 1},
		{"1.2.3.4", "1", 1},
		{"1.2.3.4", "2", -1},
		{"1.2.3.4", "10", -1},
		{"1.2.3.4", "100", -1},
		{"1.2.3.4", "0.0", 1},
		{"1.2.3.4", "0.1", 1},
		{"1.2.3.4", "0.10", 1},
		{"1.2.3.4", "0.99", 1},
		{"1.2.3.4", "1.0", 1},
		{"1.2.3.4", "1.99", -1},
		{"1.2.3.4", "2.0", -1},
		{"1.2.3.4", "0.0.0", 1},
		{"1.2.3.4", "0.0.1", 1},
		{"1.2.3.4", "0.0.2", 1},
		{"1.2.3.4", "0.0.10", 1},
		{"1.2.3.4", "0.0.99", 1},
		{"1.2.3.4", "0.1.0", 1},
		{"1.2.3.4", "0.2.0", 1},
		{"1.2.3.4", "0.10.0", 1},
		{"1.2.3.4", "0.99.0", 1},
		{"1.2.3.4", "0.100.0", 1},
		{"1.2.3.4", "0.0.0.0", 1},
		{"1.2.3.4", "0.0.0.1", 1},
		{"1.2.3.4", "0.0.0.10", 1},
		{"1.2.3.4", "0.0.1.0", 1},
		{"1.2.3.4", "0.0.01.0", 1},
		{"1.2.3.4", "1.2.3.4", 0},
		{"1.2.3.4", "1-2-3-4", 0},
		{"1.2.3.4", "20150101", -1},
		{"1.2.3.4", "20151212", -1},
		{"1.2.3.4", "20151212.0", -1},
		{"1.2.3.4", "20151212.1", -1},
		{"1.2.3.4", "2015.1.1", -1},
		{"1.2.3.4", "2015.02.02", -1},
		{"1.2.3.4", "2015.12.12", -1},
		{"1.2.3.4", "1.2.3a", 1},
		{"1.2.3.4", "1.2.3b", 1},
		{"1.2.3.4", "R16B", 1},
		{"1.2.3.4", "R16C", 1},
		{"1.2.3.4", "1.2.3.2016.1.1", -1},
		{"1.2.3.4", "0.5a1.dev", 1},
		{"1.2.3.4", "1.8.B59BrZX", -1},
		{"1.2.3.4", "0.07b4p1", 1},
		{"1.2.3.4", "3.99.5final.SP07", -1},
		{"1.2.3.4", "3.99.5final.SP08", -1},
		{"1.2.3.4", "0.4.tbb.20100203", 1},
		{"1.2.3.4", "0.5.20120830CVS.el7", 1},
		{"1.2.3.4", "1.el7", 1},
		{"1.2.3.4", "1.el6", 1},
		{"1.2.3.4", "10.el7", -1},
		{"1.2.3.4", "01.el7", 1},
		{"1.2.3.4", "0.17.20140318svn632.el7", 1},
		{"1.2.3.4", "0.17.20140318svn633.el7", 1},
		{"1.2.3.4", "1.20140522gitad6fb3e.el7", -1},
		{"1.2.3.4", "1.20140522hitad6fb3e.el7", -1},
		{"1.2.3.4", "8.20140605hgacf1c26e3019.el7", -1},
		{"1.2.3.4", "8.20140605hgacf1c26e3029.el7", -1},
		{"1.2.3.4", "22.svn457.el7", -1},
		{"1.2.3.4", "22.svn458.el7", -1},
		{"1.2.3.4", "~", 1},
		{"1.2.3.4", "~~", 1},
		{"1.2.3.4", "~1", 1},
		{"1.2.3.4", "~a", 1},
		{"1.2.3.4", "1~", 1},
		{"1.2.3.4", "2~", -1},
		{"1-2-3-4", "", 1},
		{"1-2-3-4", "0", 1},
		{"1-2-3-4", "1", 1},
		{"1-2-3-4", "2", -1},
		{"1-2-3-4", "10", -1},
		{"1-2-3-4", "100", -1},
		{"1-2-3-4", "0.0", 1},
		{"1-2-3-4", "0.1", 1},
		{"1-2-3-4", "0.10", 1},
		{"1-2-3-4", "0.99", 1},
		{"1-2-3-4", "1.0", 1},
		{"1-2-3-4", "1.99", -1},
		{"1-2-3-4", "2.0", -1},
		{"1-2-3-4", "0.0.0", 1},
		{"1-2-3-4", "0.0.1", 1},
		{"1-2-3-4", "0.0.2", 1},
		{"1-2-3-4", "0.0.10", 1},
		{"1-2-3-4", "0.0.99", 1},
		{"1-2-3-4", "0.1.0", 1},
		{"1-2-3-4", "0.2.0", 1},
		{"1-2-3-4", "0.10.0", 1},
		{"1-2-3-4", "0.99.0", 1},
		{"1-2-3-4", "0.100.0", 1},
		{"1-2-3-4", "0.0.0.0", 1},
		{"1-2-3-4", "0.0.0.1", 1},
		{"1-2-3-4", "0.0.0.10", 1},
		{"1-2-3-4", "0.0.1.0", 1},
		{"1-2-3-4", "0.0.01.0", 1},
		{"1-2-3-4", "1.2.3.4", 0},
		{"1-2-3-4", "1-2-3-4", 0},
		{"1-2-3-4", "20150101", -1},
		{"1-2-3-4", "20151212", -1},
		{"1-2-3-4", "20151212.0", -1},
		{"1-2-3-4", "20151212.1", -1},
		{"1-2-3-4", "2015.1.1", -1},
		{"1-2-3-4", "2015.02.02", -1},
		{"1-2-3-4", "2015.12.12", -1},
		{"1-2-3-4", "1.2.3a", 1},
		{"1-2-3-4", "1.2.3b", 1},
		{"1-2-3-4", "R16B", 1},
		{"1-2-3-4", "R16C", 1},
		{"1-2-3-4", "1.2.3.2016.1.1", -1},
		{"1-2-3-4", "0.5a1.dev", 1},
		{"1-2-3-4", "1.8.B59BrZX", -1},
		{"1-2-3-4", "0.07b4p1", 1},
		{"1-2-3-4", "3.99.5final.SP07", -1},
		{"1-2-3-4", "3.99.5final.SP08", -1},
		{"1-2-3-4", "0.4.tbb.20100203", 1},
		{"1-2-3-4", "0.5.20120830CVS.el7", 1},
		{"1-2-3-4", "1.el7", 1},
		{"1-2-3-4", "1.el6", 1},
		{"1-2-3-4", "10.el7", -1},
		{"1-2-3-4", "01.el7", 1},
		{"1-2-3-4", "0.17.20140318svn632.el7", 1},
		{"1-2-3-4", "0.17.20140318svn633.el7", 1},
		{"1-2-3-4", "1.20140522gitad6fb3e.el7", -1},
		{"1-2-3-4", "1.20140522hitad6fb3e.el7", -1},
		{"1-2-3-4", "8.20140605hgacf1c26e3019.el7", -1},
		{"1-2-3-4", "8.20140605hgacf1c26e3029.el7", -1},
		{"1-2-3-4", "22.svn457.el7", -1},
		{"1-2-3-4", "22.svn458.el7", -1},
		{"1-2-3-4", "~", 1},
		{"1-2-3-4", "~~", 1},
		{"1-2-3-4", "~1", 1},
		{"1-2-3-4", "~a", 1},
		{"1-2-3-4", "1~", 1},
		{"1-2-3-4", "2~", -1},
		{"20150101", "", 1},
		{"20150101", "0", 1},
		{"20150101", "1", 1},
		{"20150101", "2", 1},
		{"20150101", "10", 1},
		{"20150101", "100", 1},
		{"20150101", "0.0", 1},
		{"20150101", "0.1", 1},
		{"20150101", "0.10", 1},
		{"20150101", "0.99", 1},
		{"20150101", "1.0", 1},
		{"20150101", "1.99", 1},
		{"20150101", "2.0", 1},
		{"20150101", "0.0.0", 1},
		{"20150101", "0.0.1", 1},
		{"20150101", "0.0.2", 1},
		{"20150101", "0.0.10", 1},
		{"20150101", "0.0.99", 1},
		{"20150101", "0.1.0", 1},
		{"20150101", "0.2.0", 1},
		{"20150101", "0.10.0", 1},
		{"20150101", "0.99.0", 1},
		{"20150101", "0.100.0", 1},
		{"20150101", "0.0.0.0", 1},
		{"20150101", "0.0.0.1", 1},
		{"20150101", "0.0.0.10", 1},
		{"20150101", "0.0.1.0", 1},
		{"20150101", "0.0.01.0", 1},
		{"20150101", "1.2.3.4", 1},
		{"20150101", "1-2-3-4", 1},
		{"20150101", "20150101", 0},
		{"20150101", "20151212", -1},
		{"20150101", "20151212.0", -1},
		{"20150101", "20151212.1", -1},
		{"20150101", "2015.1.1", 1},
		{"20150101", "2015.02.02", 1},
		{"20150101", "2015.12.12", 1},
		{"20150101", "1.2.3a", 1},
		{"20150101", "1.2.3b", 1},
		{"20150101", "R16B", 1},
		{"20150101", "R16C", 1},
		{"20150101", "1.2.3.2016.1.1", 1},
		{"20150101", "0.5a1.dev", 1},
		{"20150101", "1.8.B59BrZX", 1},
		{"20150101", "0.07b4p1", 1},
		{"20150101", "3.99.5final.SP07", 1},
		{"20150101", "3.99.5final.SP08", 1},
		{"20150101", "0.4.tbb.20100203", 1},
		{"20150101", "0.5.20120830CVS.el7", 1},
		{"20150101", "1.el7", 1},
		{"20150101", "1.el6", 1},
		{"20150101", "10.el7", 1},
		{"20150101", "01.el7", 1},
		{"20150101", "0.17.20140318svn632.el7", 1},
		{"20150101", "0.17.20140318svn633.el7", 1},
		{"20150101", "1.20140522gitad6fb3e.el7", 1},
		{"20150101", "1.20140522hitad6fb3e.el7", 1},
		{"20150101", "8.20140605hgacf1c26e3019.el7", 1},
		{"20150101", "8.20140605hgacf1c26e3029.el7", 1},
		{"20150101", "22.svn457.el7", 1},
		{"20150101", "22.svn458.el7", 1},
		{"20150101", "~", 1},
		{"20150101", "~~", 1},
		{"20150101", "~1", 1},
		{"20150101", "~a", 1},
		{"20150101", "1~", 1},
		{"20150101", "2~", 1},
		{"20151212", "", 1},
		{"20151212", "0", 1},
		{"20151212", "1", 1},
		{"20151212", "2", 1},
		{"20151212", "10", 1},
		{"20151212", "100", 1},
		{"20151212", "0.0", 1},
		{"20151212", "0.1", 1},
		{"20151212", "0.10", 1},
		{"20151212", "0.99", 1},
		{"20151212", "1.0", 1},
		{"20151212", "1.99", 1},
		{"20151212", "2.0", 1},
		{"20151212", "0.0.0", 1},
		{"20151212", "0.0.1", 1},
		{"20151212", "0.0.2", 1},
		{"20151212", "0.0.10", 1},
		{"20151212", "0.0.99", 1},
		{"20151212", "0.1.0", 1},
		{"20151212", "0.2.0", 1},
		{"20151212", "0.10.0", 1},
		{"20151212", "0.99.0", 1},
		{"20151212", "0.100.0", 1},
		{"20151212", "0.0.0.0", 1},
		{"20151212", "0.0.0.1", 1},
		{"20151212", "0.0.0.10", 1},
		{"20151212", "0.0.1.0", 1},
		{"20151212", "0.0.01.0", 1},
		{"20151212", "1.2.3.4", 1},
		{"20151212", "1-2-3-4", 1},
		{"20151212", "20150101", 1},
		{"20151212", "20151212", 0},
		{"20151212", "20151212.0", -1},
		{"20151212", "20151212.1", -1},
		{"20151212", "2015.1.1", 1},
		{"20151212", "2015.02.02", 1},
		{"20151212", "2015.12.12", 1},
		{"20151212", "1.2.3a", 1},
		{"20151212", "1.2.3b", 1},
		{"20151212", "R16B", 1},
		{"20151212", "R16C", 1},
		{"20151212", "1.2.3.2016.1.1", 1},
		{"20151212", "0.5a1.dev", 1},
		{"20151212", "1.8.B59BrZX", 1},
		{"20151212", "0.07b4p1", 1},
		{"20151212", "3.99.5final.SP07", 1},
		{"20151212", "3.99.5final.SP08", 1},
		{"20151212", "0.4.tbb.20100203", 1},
		{"20151212", "0.5.20120830CVS.el7", 1},
		{"20151212", "1.el7", 1},
		{"20151212", "1.el6", 1},
		{"20151212", "10.el7", 1},
		{"20151212", "01.el7", 1},
		{"20151212", "0.17.20140318svn632.el7", 1},
		{"20151212", "0.17.20140318svn633.el7", 1},
		{"20151212", "1.20140522gitad6fb3e.el7", 1},
		{"20151212", "1.20140522hitad6fb3e.el7", 1},
		{"20151212", "8.20140605hgacf1c26e3019.el7", 1},
		{"20151212", "8.20140605hgacf1c26e3029.el7", 1},
		{"20151212", "22.svn457.el7", 1},
		{"20151212", "22.svn458.el7", 1},
		{"20151212", "~", 1},
		{"20151212", "~~", 1},
		{"20151212", "~1", 1},
		{"20151212", "~a", 1},
		{"20151212", "1~", 1},
		{"20151212", "2~", 1},
		{"20151212.0", "", 1},
		{"20151212.0", "0", 1},
		{"20151212.0", "1", 1},
		{"20151212.0", "2", 1},
		{"20151212.0", "10", 1},
		{"20151212.0", "100", 1},
		{"20151212.0", "0.0", 1},
		{"20151212.0", "0.1", 1},
		{"20151212.0", "0.10", 1},
		{"20151212.0", "0.99", 1},
		{"20151212.0", "1.0", 1},
		{"20151212.0", "1.99", 1},
		{"20151212.0", "2.0", 1},
		{"20151212.0", "0.0.0", 1},
		{"20151212.0", "0.0.1", 1},
		{"20151212.0", "0.0.2", 1},
		{"20151212.0", "0.0.10", 1},
		{"20151212.0", "0.0.99", 1},
		{"20151212.0", "0.1.0", 1},
		{"20151212.0", "0.2.0", 1},
		{"20151212.0", "0.10.0", 1},
		{"20151212.0", "0.99.0", 1},
		{"20151212.0", "0.100.0", 1},
		{"20151212.0", "0.0.0.0", 1},
		{"20151212.0", "0.0.0.1", 1},
		{"20151212.0", "0.0.0.10", 1},
		{"20151212.0", "0.0.1.0", 1},
		{"20151212.0", "0.0.01.0", 1},
		{"20151212.0", "1.2.3.4", 1},
		{"20151212.0", "1-2-3-4", 1},
		{"20151212.0", "20150101", 1},
		{"20151212.0", "20151212", 1},
		{"20151212.0", "20151212.0", 0},
		{"20151212.0", "20151212.1", -1},
		{"20151212.0", "2015.1.1", 1},
		{"20151212.0", "2015.02.02", 1},
		{"20151212.0", "2015.12.12", 1},
		{"20151212.0", "1.2.3a", 1},
		{"20151212.0", "1.2.3b", 1},
		{"20151212.0", "R16B", 1},
		{"20151212.0", "R16C", 1},
		{"20151212.0", "1.2.3.2016.1.1", 1},
		{"20151212.0", "0.5a1.dev", 1},
		{"20151212.0", "1.8.B59BrZX", 1},
		{"20151212.0", "0.07b4p1", 1},
		{"20151212.0", "3.99.5final.SP07", 1},
		{"20151212.0", "3.99.5final.SP08", 1},
		{"20151212.0", "0.4.tbb.20100203", 1},
		{"20151212.0", "0.5.20120830CVS.el7", 1},
		{"20151212.0", "1.el7", 1},
		{"20151212.0", "1.el6", 1},
		{"20151212.0", "10.el7", 1},
		{"20151212.0", "01.el7", 1},
		{"20151212.0", "0.17.20140318svn632.el7", 1},
		{"20151212.0", "0.17.20140318svn633.el7", 1},
		{"20151212.0", "1.20140522gitad6fb3e.el7", 1},
		{"20151212.0", "1.20140522hitad6fb3e.el7", 1},
		{"20151212.0", "8.20140605hgacf1c26e3019.el7", 1},
		{"20151212.0", "8.20140605hgacf1c26e3029.el7", 1},
		{"20151212.0", "22.svn457.el7", 1},
		{"20151212.0", "22.svn458.el7", 1},
		{"20151212.0", "~", 1},
		{"20151212.0", "~~", 1},
		{"20151212.0", "~1", 1},
		{"20151212.0", "~a", 1},
		{"20151212.0", "1~", 1},
		{"20151212.0", "2~", 1},
		{"20151212.1", "", 1},
		{"20151212.1", "0", 1},
		{"20151212.1", "1", 1},
		{"20151212.1", "2", 1},
		{"20151212.1", "10", 1},
		{"20151212.1", "100", 1},
		{"20151212.1", "0.0", 1},
		{"20151212.1", "0.1", 1},
		{"20151212.1", "0.10", 1},
		{"20151212.1", "0.99", 1},
		{"20151212.1", "1.0", 1},
		{"20151212.1", "1.99", 1},
		{"20151212.1", "2.0", 1},
		{"20151212.1", "0.0.0", 1},
		{"20151212.1", "0.0.1", 1},
		{"20151212.1", "0.0.2", 1},
		{"20151212.1", "0.0.10", 1},
		{"20151212.1", "0.0.99", 1},
		{"20151212.1", "0.1.0", 1},
		{"20151212.1", "0.2.0", 1},
		{"20151212.1", "0.10.0", 1},
		{"20151212.1", "0.99.0", 1},
		{"20151212.1", "0.100.0", 1},
		{"20151212.1", "0.0.0.0", 1},
		{"20151212.1", "0.0.0.1", 1},
		{"20151212.1", "0.0.0.10", 1},
		{"20151212.1", "0.0.1.0", 1},
		{"20151212.1", "0.0.01.0", 1},
		{"20151212.1", "1.2.3.4", 1},
		{"20151212.1", "1-2-3-4", 1},
		{"20151212.1", "20150101", 1},
		{"20151212.1", "20151212", 1},
		{"20151212.1", "20151212.0", 1},
		{"20151212.1", "20151212.1", 0},
		{"20151212.1", "2015.1.1", 1},
		{"20151212.1", "2015.02.02", 1},
		{"20151212.1", "2015.12.12", 1},
		{"20151212.1", "1.2.3a", 1},
		{"20151212.1", "1.2.3b", 1},
		{"20151212.1", "R16B", 1},
		{"20151212.1", "R16C", 1},
		{"20151212.1", "1.2.3.2016.1.1", 1},
		{"20151212.1", "0.5a1.dev", 1},
		{"20151212.1", "1.8.B59BrZX", 1},
		{"20151212.1", "0.07b4p1", 1},
		{"20151212.1", "3.99.5final.SP07", 1},
		{"20151212.1", "3.99.5final.SP08", 1},
		{"20151212.1", "0.4.tbb.20100203", 1},
		{"20151212.1", "0.5.20120830CVS.el7", 1},
		{"20151212.1", "1.el7", 1},
		{"20151212.1", "1.el6", 1},
		{"20151212.1", "10.el7", 1},
		{"20151212.1", "01.el7", 1},
		{"20151212.1", "0.17.20140318svn632.el7", 1},
		{"20151212.1", "0.17.20140318svn633.el7", 1},
		{"20151212.1", "1.20140522gitad6fb3e.el7", 1},
		{"20151212.1", "1.20140522hitad6fb3e.el7", 1},
		{"20151212.1", "8.20140605hgacf1c26e3019.el7", 1},
		{"20151212.1", "8.20140605hgacf1c26e3029.el7", 1},
		{"20151212.1", "22.svn457.el7", 1},
		{"20151212.1", "22.svn458.el7", 1},
		{"20151212.1", "~", 1},
		{"20151212.1", "~~", 1},
		{"20151212.1", "~1", 1},
		{"20151212.1", "~a", 1},
		{"20151212.1", "1~", 1},
		{"20151212.1", "2~", 1},
		{"2015.1.1", "", 1},
		{"2015.1.1", "0", 1},
		{"2015.1.1", "1", 1},
		{"2015.1.1", "2", 1},
		{"2015.1.1", "10", 1},
		{"2015.1.1", "100", 1},
		{"2015.1.1", "0.0", 1},
		{"2015.1.1", "0.1", 1},
		{"2015.1.1", "0.10", 1},
		{"2015.1.1", "0.99", 1},
		{"2015.1.1", "1.0", 1},
		{"2015.1.1", "1.99", 1},
		{"2015.1.1", "2.0", 1},
		{"2015.1.1", "0.0.0", 1},
		{"2015.1.1", "0.0.1", 1},
		{"2015.1.1", "0.0.2", 1},
		{"2015.1.1", "0.0.10", 1},
		{"2015.1.1", "0.0.99", 1},
		{"2015.1.1", "0.1.0", 1},
		{"2015.1.1", "0.2.0", 1},
		{"2015.1.1", "0.10.0", 1},
		{"2015.1.1", "0.99.0", 1},
		{"2015.1.1", "0.100.0", 1},
		{"2015.1.1", "0.0.0.0", 1},
		{"2015.1.1", "0.0.0.1", 1},
		{"2015.1.1", "0.0.0.10", 1},
		{"2015.1.1", "0.0.1.0", 1},
		{"2015.1.1", "0.0.01.0", 1},
		{"2015.1.1", "1.2.3.4", 1},
		{"2015.1.1", "1-2-3-4", 1},
		{"2015.1.1", "20150101", -1},
		{"2015.1.1", "20151212", -1},
		{"2015.1.1", "20151212.0", -1},
		{"2015.1.1", "20151212.1", -1},
		{"2015.1.1", "2015.1.1", 0},
		{"2015.1.1", "2015.02.02", -1},
		{"2015.1.1", "2015.12.12", -1},
		{"2015.1.1", "1.2.3a", 1},
		{"2015.1.1", "1.2.3b", 1},
		{"2015.1.1", "R16B", 1},
		{"2015.1.1", "R16C", 1},
		{"2015.1.1", "1.2.3.2016.1.1", 1},
		{"2015.1.1", "0.5a1.dev", 1},
		{"2015.1.1", "1.8.B59BrZX", 1},
		{"2015.1.1", "0.07b4p1", 1},
		{"2015.1.1", "3.99.5final.SP07", 1},
		{"2015.1.1", "3.99.5final.SP08", 1},
		{"2015.1.1", "0.4.tbb.20100203", 1},
		{"2015.1.1", "0.5.20120830CVS.el7", 1},
		{"2015.1.1", "1.el7", 1},
		{"2015.1.1", "1.el6", 1},
		{"2015.1.1", "10.el7", 1},
		{"2015.1.1", "01.el7", 1},
		{"2015.1.1", "0.17.20140318svn632.el7", 1},
		{"2015.1.1", "0.17.20140318svn633.el7", 1},
		{"2015.1.1", "1.20140522gitad6fb3e.el7", 1},
		{"2015.1.1", "1.20140522hitad6fb3e.el7", 1},
		{"2015.1.1", "8.20140605hgacf1c26e3019.el7", 1},
		{"2015.1.1", "8.20140605hgacf1c26e3029.el7", 1},
		{"2015.1.1", "22.svn457.el7", 1},
		{"2015.1.1", "22.svn458.el7", 1},
		{"2015.1.1", "~", 1},
		{"2015.1.1", "~~", 1},
		{"2015.1.1", "~1", 1},
		{"2015.1.1", "~a", 1},
		{"2015.1.1", "1~", 1},
		{"2015.1.1", "2~", 1},
		{"2015.02.02", "", 1},
		{"2015.02.02", "0", 1},
		{"2015.02.02", "1", 1},
		{"2015.02.02", "2", 1},
		{"2015.02.02", "10", 1},
		{"2015.02.02", "100", 1},
		{"2015.02.02", "0.0", 1},
		{"2015.02.02", "0.1", 1},
		{"2015.02.02", "0.10", 1},
		{"2015.02.02", "0.99", 1},
		{"2015.02.02", "1.0", 1},
		{"2015.02.02", "1.99", 1},
		{"2015.02.02", "2.0", 1},
		{"2015.02.02", "0.0.0", 1},
		{"2015.02.02", "0.0.1", 1},
		{"2015.02.02", "0.0.2", 1},
		{"2015.02.02", "0.0.10", 1},
		{"2015.02.02", "0.0.99", 1},
		{"2015.02.02", "0.1.0", 1},
		{"2015.02.02", "0.2.0", 1},
		{"2015.02.02", "0.10.0", 1},
		{"2015.02.02", "0.99.0", 1},
		{"2015.02.02", "0.100.0", 1},
		{"2015.02.02", "0.0.0.0", 1},
		{"2015.02.02", "0.0.0.1", 1},
		{"2015.02.02", "0.0.0.10", 1},
		{"2015.02.02", "0.0.1.0", 1},
		{"2015.02.02", "0.0.01.0", 1},
		{"2015.02.02", "1.2.3.4", 1},
		{"2015.02.02", "1-2-3-4", 1},
		{"2015.02.02", "20150101", -1},
		{"2015.02.02", "20151212", -1},
		{"2015.02.02", "20151212.0", -1},
		{"2015.02.02", "20151212.1", -1},
		{"2015.02.02", "2015.1.1", 1},
		{"2015.02.02", "2015.02.02", 0},
		{"2015.02.02", "2015.12.12", -1},
		{"2015.02.02", "1.2.3a", 1},
		{"2015.02.02", "1.2.3b", 1},
		{"2015.02.02", "R16B", 1},
		{"2015.02.02", "R16C", 1},
		{"2015.02.02", "1.2.3.2016.1.1", 1},
		{"2015.02.02", "0.5a1.dev", 1},
		{"2015.02.02", "1.8.B59BrZX", 1},
		{"2015.02.02", "0.07b4p1", 1},
		{"2015.02.02", "3.99.5final.SP07", 1},
		{"2015.02.02", "3.99.5final.SP08", 1},
		{"2015.02.02", "0.4.tbb.20100203", 1},
		{"2015.02.02", "0.5.20120830CVS.el7", 1},
		{"2015.02.02", "1.el7", 1},
		{"2015.02.02", "1.el6", 1},
		{"2015.02.02", "10.el7", 1},
		{"2015.02.02", "01.el7", 1},
		{"2015.02.02", "0.17.20140318svn632.el7", 1},
		{"2015.02.02", "0.17.20140318svn633.el7", 1},
		{"2015.02.02", "1.20140522gitad6fb3e.el7", 1},
		{"2015.02.02", "1.20140522hitad6fb3e.el7", 1},
		{"2015.02.02", "8.20140605hgacf1c26e3019.el7", 1},
		{"2015.02.02", "8.20140605hgacf1c26e3029.el7", 1},
		{"2015.02.02", "22.svn457.el7", 1},
		{"2015.02.02", "22.svn458.el7", 1},
		{"2015.02.02", "~", 1},
		{"2015.02.02", "~~", 1},
		{"2015.02.02", "~1", 1},
		{"2015.02.02", "~a", 1},
		{"2015.02.02", "1~", 1},
		{"2015.02.02", "2~", 1},
		{"2015.12.12", "", 1},
		{"2015.12.12", "0", 1},
		{"2015.12.12", "1", 1},
		{"2015.12.12", "2", 1},
		{"2015.12.12", "10", 1},
		{"2015.12.12", "100", 1},
		{"2015.12.12", "0.0", 1},
		{"2015.12.12", "0.1", 1},
		{"2015.12.12", "0.10", 1},
		{"2015.12.12", "0.99", 1},
		{"2015.12.12", "1.0", 1},
		{"2015.12.12", "1.99", 1},
		{"2015.12.12", "2.0", 1},
		{"2015.12.12", "0.0.0", 1},
		{"2015.12.12", "0.0.1", 1},
		{"2015.12.12", "0.0.2", 1},
		{"2015.12.12", "0.0.10", 1},
		{"2015.12.12", "0.0.99", 1},
		{"2015.12.12", "0.1.0", 1},
		{"2015.12.12", "0.2.0", 1},
		{"2015.12.12", "0.10.0", 1},
		{"2015.12.12", "0.99.0", 1},
		{"2015.12.12", "0.100.0", 1},
		{"2015.12.12", "0.0.0.0", 1},
		{"2015.12.12", "0.0.0.1", 1},
		{"2015.12.12", "0.0.0.10", 1},
		{"2015.12.12", "0.0.1.0", 1},
		{"2015.12.12", "0.0.01.0", 1},
		{"2015.12.12", "1.2.3.4", 1},
		{"2015.12.12", "1-2-3-4", 1},
		{"2015.12.12", "20150101", -1},
		{"2015.12.12", "20151212", -1},
		{"2015.12.12", "20151212.0", -1},
		{"2015.12.12", "20151212.1", -1},
		{"2015.12.12", "2015.1.1", 1},
		{"2015.12.12", "2015.02.02", 1},
		{"2015.12.12", "2015.12.12", 0},
		{"2015.12.12", "1.2.3a", 1},
		{"2015.12.12", "1.2.3b", 1},
		{"2015.12.12", "R16B", 1},
		{"2015.12.12", "R16C", 1},
		{"2015.12.12", "1.2.3.2016.1.1", 1},
		{"2015.12.12", "0.5a1.dev", 1},
		{"2015.12.12", "1.8.B59BrZX", 1},
		{"2015.12.12", "0.07b4p1", 1},
		{"2015.12.12", "3.99.5final.SP07", 1},
		{"2015.12.12", "3.99.5final.SP08", 1},
		{"2015.12.12", "0.4.tbb.20100203", 1},
		{"2015.12.12", "0.5.20120830CVS.el7", 1},
		{"2015.12.12", "1.el7", 1},
		{"2015.12.12", "1.el6", 1},
		{"2015.12.12", "10.el7", 1},
		{"2015.12.12", "01.el7", 1},
		{"2015.12.12", "0.17.20140318svn632.el7", 1},
		{"2015.12.12", "0.17.20140318svn633.el7", 1},
		{"2015.12.12", "1.20140522gitad6fb3e.el7", 1},
		{"2015.12.12", "1.20140522hitad6fb3e.el7", 1},
		{"2015.12.12", "8.20140605hgacf1c26e3019.el7", 1},
		{"2015.12.12", "8.20140605hgacf1c26e3029.el7", 1},
		{"2015.12.12", "22.svn457.el7", 1},
		{"2015.12.12", "22.svn458.el7", 1},
		{"2015.12.12", "~", 1},
		{"2015.12.12", "~~", 1},
		{"2015.12.12", "~1", 1},
		{"2015.12.12", "~a", 1},
		{"2015.12.12", "1~", 1},
		{"2015.12.12", "2~", 1},
		{"1.2.3a", "", 1},
		{"1.2.3a", "0", 1},
		{"1.2.3a", "1", 1},
		{"1.2.3a", "2", -1},
		{"1.2.3a", "10", -1},
		{"1.2.3a", "100", -1},
		{"1.2.3a", "0.0", 1},
		{"1.2.3a", "0.1", 1},
		{"1.2.3a", "0.10", 1},
		{"1.2.3a", "0.99", 1},
		{"1.2.3a", "1.0", 1},
		{"1.2.3a", "1.99", -1},
		{"1.2.3a", "2.0", -1},
		{"1.2.3a", "0.0.0", 1},
		{"1.2.3a", "0.0.1", 1},
		{"1.2.3a", "0.0.2", 1},
		{"1.2.3a", "0.0.10", 1},
		{"1.2.3a", "0.0.99", 1},
		{"1.2.3a", "0.1.0", 1},
		{"1.2.3a", "0.2.0", 1},
		{"1.2.3a", "0.10.0", 1},
		{"1.2.3a", "0.99.0", 1},
		{"1.2.3a", "0.100.0", 1},
		{"1.2.3a", "0.0.0.0", 1},
		{"1.2.3a", "0.0.0.1", 1},
		{"1.2.3a", "0.0.0.10", 1},
		{"1.2.3a", "0.0.1.0", 1},
		{"1.2.3a", "0.0.01.0", 1},
		{"1.2.3a", "1.2.3.4", -1},
		{"1.2.3a", "1-2-3-4", -1},
		{"1.2.3a", "20150101", -1},
		{"1.2.3a", "20151212", -1},
		{"1.2.3a", "20151212.0", -1},
		{"1.2.3a", "20151212.1", -1},
		{"1.2.3a", "2015.1.1", -1},
		{"1.2.3a", "2015.02.02", -1},
		{"1.2.3a", "2015.12.12", -1},
		{"1.2.3a", "1.2.3a", 0},
		{"1.2.3a", "1.2.3b", -1},
		{"1.2.3a", "R16B", 1},
		{"1.2.3a", "R16C", 1},
		{"1.2.3a", "1.2.3.2016.1.1", -1},
		{"1.2.3a", "0.5a1.dev", 1},
		{"1.2.3a", "1.8.B59BrZX", -1},
		{"1.2.3a", "0.07b4p1", 1},
		{"1.2.3a", "3.99.5final.SP07", -1},
		{"1.2.3a", "3.99.5final.SP08", -1},
		{"1.2.3a", "0.4.tbb.20100203", 1},
		{"1.2.3a", "0.5.20120830CVS.el7", 1},
		{"1.2.3a", "1.el7", 1},
		{"1.2.3a", "1.el6", 1},
		{"1.2.3a", "10.el7", -1},
		{"1.2.3a", "01.el7", 1},
		{"1.2.3a", "0.17.20140318svn632.el7", 1},
		{"1.2.3a", "0.17.20140318svn633.el7", 1},
		{"1.2.3a", "1.20140522gitad6fb3e.el7", -1},
		{"1.2.3a", "1.20140522hitad6fb3e.el7", -1},
		{"1.2.3a", "8.20140605hgacf1c26e3019.el7", -1},
		{"1.2.3a", "8.20140605hgacf1c26e3029.el7", -1},
		{"1.2.3a", "22.svn457.el7", -1},
		{"1.2.3a", "22.svn458.el7", -1},
		{"1.2.3a", "~", 1},
		{"1.2.3a", "~~", 1},
		{"1.2.3a", "~1", 1},
		{"1.2.3a", "~a", 1},
		{"1.2.3a", "1~", 1},
		{"1.2.3a", "2~", -1},
		{"1.2.3b", "", 1},
		{"1.2.3b", "0", 1},
		{"1.2.3b", "1", 1},
		{"1.2.3b", "2", -1},
		{"1.2.3b", "10", -1},
		{"1.2.3b", "100", -1},
		{"1.2.3b", "0.0", 1},
		{"1.2.3b", "0.1", 1},
		{"1.2.3b", "0.10", 1},
		{"1.2.3b", "0.99", 1},
		{"1.2.3b", "1.0", 1},
		{"1.2.3b", "1.99", -1},
		{"1.2.3b", "2.0", -1},
		{"1.2.3b", "0.0.0", 1},
		{"1.2.3b", "0.0.1", 1},
		{"1.2.3b", "0.0.2", 1},
		{"1.2.3b", "0.0.10", 1},
		{"1.2.3b", "0.0.99", 1},
		{"1.2.3b", "0.1.0", 1},
		{"1.2.3b", "0.2.0", 1},
		{"1.2.3b", "0.10.0", 1},
		{"1.2.3b", "0.99.0", 1},
		{"1.2.3b", "0.100.0", 1},
		{"1.2.3b", "0.0.0.0", 1},
		{"1.2.3b", "0.0.0.1", 1},
		{"1.2.3b", "0.0.0.10", 1},
		{"1.2.3b", "0.0.1.0", 1},
		{"1.2.3b", "0.0.01.0", 1},
		{"1.2.3b", "1.2.3.4", -1},
		{"1.2.3b", "1-2-3-4", -1},
		{"1.2.3b", "20150101", -1},
		{"1.2.3b", "20151212", -1},
		{"1.2.3b", "20151212.0", -1},
		{"1.2.3b", "20151212.1", -1},
		{"1.2.3b", "2015.1.1", -1},
		{"1.2.3b", "2015.02.02", -1},
		{"1.2.3b", "2015.12.12", -1},
		{"1.2.3b", "1.2.3a", 1},
		{"1.2.3b", "1.2.3b", 0},
		{"1.2.3b", "R16B", 1},
		{"1.2.3b", "R16C", 1},
		{"1.2.3b", "1.2.3.2016.1.1", -1},
		{"1.2.3b", "0.5a1.dev", 1},
		{"1.2.3b", "1.8.B59BrZX", -1},
		{"1.2.3b", "0.07b4p1", 1},
		{"1.2.3b", "3.99.5final.SP07", -1},
		{"1.2.3b", "3.99.5final.SP08", -1},
		{"1.2.3b", "0.4.tbb.20100203", 1},
		{"1.2.3b", "0.5.20120830CVS.el7", 1},
		{"1.2.3b", "1.el7", 1},
		{"1.2.3b", "1.el6", 1},
		{"1.2.3b", "10.el7", -1},
		{"1.2.3b", "01.el7", 1},
		{"1.2.3b", "0.17.20140318svn632.el7", 1},
		{"1.2.3b", "0.17.20140318svn633.el7", 1},
		{"1.2.3b", "1.20140522gitad6fb3e.el7", -1},
		{"1.2.3b", "1.20140522hitad6fb3e.el7", -1},
		{"1.2.3b", "8.20140605hgacf1c26e3019.el7", -1},
		{"1.2.3b", "8.20140605hgacf1c26e3029.el7", -1},
		{"1.2.3b", "22.svn457.el7", -1},
		{"1.2.3b", "22.svn458.el7", -1},
		{"1.2.3b", "~", 1},
		{"1.2.3b", "~~", 1},
		{"1.2.3b", "~1", 1},
		{"1.2.3b", "~a", 1},
		{"1.2.3b", "1~", 1},
		{"1.2.3b", "2~", -1},
		{"R16B", "", 1},
		{"R16B", "0", -1},
		{"R16B", "1", -1},
		{"R16B", "2", -1},
		{"R16B", "10", -1},
		{"R16B", "100", -1},
		{"R16B", "0.0", -1},
		{"R16B", "0.1", -1},
		{"R16B", "0.10", -1},
		{"R16B", "0.99", -1},
		{"R16B", "1.0", -1},
		{"R16B", "1.99", -1},
		{"R16B", "2.0", -1},
		{"R16B", "0.0.0", -1},
		{"R16B", "0.0.1", -1},
		{"R16B", "0.0.2", -1},
		{"R16B", "0.0.10", -1},
		{"R16B", "0.0.99", -1},
		{"R16B", "0.1.0", -1},
		{"R16B", "0.2.0", -1},
		{"R16B", "0.10.0", -1},
		{"R16B", "0.99.0", -1},
		{"R16B", "0.100.0", -1},
		{"R16B", "0.0.0.0", -1},
		{"R16B", "0.0.0.1", -1},
		{"R16B", "0.0.0.10", -1},
		{"R16B", "0.0.1.0", -1},
		{"R16B", "0.0.01.0", -1},
		{"R16B", "1.2.3.4", -1},
		{"R16B", "1-2-3-4", -1},
		{"R16B", "20150101", -1},
		{"R16B", "20151212", -1},
		{"R16B", "20151212.0", -1},
		{"R16B", "20151212.1", -1},
		{"R16B", "2015.1.1", -1},
		{"R16B", "2015.02.02", -1},
		{"R16B", "2015.12.12", -1},
		{"R16B", "1.2.3a", -1},
		{"R16B", "1.2.3b", -1},
		{"R16B", "R16B", 0},
		{"R16B", "R16C", -1},
		{"R16B", "1.2.3.2016.1.1", -1},
		{"R16B", "0.5a1.dev", -1},
		{"R16B", "1.8.B59BrZX", -1},
		{"R16B", "0.07b4p1", -1},
		{"R16B", "3.99.5final.SP07", -1},
		{"R16B", "3.99.5final.SP08", -1},
		{"R16B", "0.4.tbb.20100203", -1},
		{"R16B", "0.5.20120830CVS.el7", -1},
		{"R16B", "1.el7", -1},
		{"R16B", "1.el6", -1},
		{"R16B", "10.el7", -1},
		{"R16B", "01.el7", -1},
		{"R16B", "0.17.20140318svn632.el7", -1},
		{"R16B", "0.17.20140318svn633.el7", -1},
		{"R16B", "1.20140522gitad6fb3e.el7", -1},
		{"R16B", "1.20140522hitad6fb3e.el7", -1},
		{"R16B", "8.20140605hgacf1c26e3019.el7", -1},
		{"R16B", "8.20140605hgacf1c26e3029.el7", -1},
		{"R16B", "22.svn457.el7", -1},
		{"R16B", "22.svn458.el7", -1},
		{"R16B", "~", 1},
		{"R16B", "~~", 1},
		{"R16B", "~1", 1},
		{"R16B", "~a", 1},
		{"R16B", "1~", -1},
		{"R16B", "2~", -1},
		{"R16C", "", 1},
		{"R16C", "0", -1},
		{"R16C", "1", -1},
		{"R16C", "2", -1},
		{"R16C", "10", -1},
		{"R16C", "100", -1},
		{"R16C", "0.0", -1},
		{"R16C", "0.1", -1},
		{"R16C", "0.10", -1},
		{"R16C", "0.99", -1},
		{"R16C", "1.0", -1},
		{"R16C", "1.99", -1},
		{"R16C", "2.0", -1},
		{"R16C", "0.0.0", -1},
		{"R16C", "0.0.1", -1},
		{"R16C", "0.0.2", -1},
		{"R16C", "0.0.10", -1},
		{"R16C", "0.0.99", -1},
		{"R16C", "0.1.0", -1},
		{"R16C", "0.2.0", -1},
		{"R16C", "0.10.0", -1},
		{"R16C", "0.99.0", -1},
		{"R16C", "0.100.0", -1},
		{"R16C", "0.0.0.0", -1},
		{"R16C", "0.0.0.1", -1},
		{"R16C", "0.0.0.10", -1},
		{"R16C", "0.0.1.0", -1},
		{"R16C", "0.0.01.0", -1},
		{"R16C", "1.2.3.4", -1},
		{"R16C", "1-2-3-4", -1},
		{"R16C", "20150101", -1},
		{"R16C", "20151212", -1},
		{"R16C", "20151212.0", -1},
		{"R16C", "20151212.1", -1},
		{"R16C", "2015.1.1", -1},
		{"R16C", "2015.02.02", -1},
		{"R16C", "2015.12.12", -1},
		{"R16C", "1.2.3a", -1},
		{"R16C", "1.2.3b", -1},
		{"R16C", "R16B", 1},
		{"R16C", "R16C", 0},
		{"R16C", "1.2.3.2016.1.1", -1},
		{"R16C", "0.5a1.dev", -1},
		{"R16C", "1.8.B59BrZX", -1},
		{"R16C", "0.07b4p1", -1},
		{"R16C", "3.99.5final.SP07", -1},
		{"R16C", "3.99.5final.SP08", -1},
		{"R16C", "0.4.tbb.20100203", -1},
		{"R16C", "0.5.20120830CVS.el7", -1},
		{"R16C", "1.el7", -1},
		{"R16C", "1.el6", -1},
		{"R16C", "10.el7", -1},
		{"R16C", "01.el7", -1},
		{"R16C", "0.17.20140318svn632.el7", -1},
		{"R16C", "0.17.20140318svn633.el7", -1},
		{"R16C", "1.20140522gitad6fb3e.el7", -1},
		{"R16C", "1.20140522hitad6fb3e.el7", -1},
		{"R16C", "8.20140605hgacf1c26e3019.el7", -1},
		{"R16C", "8.20140605hgacf1c26e3029.el7", -1},
		{"R16C", "22.svn457.el7", -1},
		{"R16C", "22.svn458.el7", -1},
		{"R16C", "~", 1},
		{"R16C", "~~", 1},
		{"R16C", "~1", 1},
		{"R16C", "~a", 1},
		{"R16C", "1~", -1},
		{"R16C", "2~", -1},
		{"1.2.3.2016.1.1", "", 1},
		{"1.2.3.2016.1.1", "0", 1},
		{"1.2.3.2016.1.1", "1", 1},
		{"1.2.3.2016.1.1", "2", -1},
		{"1.2.3.2016.1.1", "10", -1},
		{"1.2.3.2016.1.1", "100", -1},
		{"1.2.3.2016.1.1", "0.0", 1},
		{"1.2.3.2016.1.1", "0.1", 1},
		{"1.2.3.2016.1.1", "0.10", 1},
		{"1.2.3.2016.1.1", "0.99", 1},
		{"1.2.3.2016.1.1", "1.0", 1},
		{"1.2.3.2016.1.1", "1.99", -1},
		{"1.2.3.2016.1.1", "2.0", -1},
		{"1.2.3.2016.1.1", "0.0.0", 1},
		{"1.2.3.2016.1.1", "0.0.1", 1},
		{"1.2.3.2016.1.1", "0.0.2", 1},
		{"1.2.3.2016.1.1", "0.0.10", 1},
		{"1.2.3.2016.1.1", "0.0.99", 1},
		{"1.2.3.2016.1.1", "0.1.0", 1},
		{"1.2.3.2016.1.1", "0.2.0", 1},
		{"1.2.3.2016.1.1", "0.10.0", 1},
		{"1.2.3.2016.1.1", "0.99.0", 1},
		{"1.2.3.2016.1.1", "0.100.0", 1},
		{"1.2.3.2016.1.1", "0.0.0.0", 1},
		{"1.2.3.2016.1.1", "0.0.0.1", 1},
		{"1.2.3.2016.1.1", "0.0.0.10", 1},
		{"1.2.3.2016.1.1", "0.0.1.0", 1},
		{"1.2.3.2016.1.1", "0.0.01.0", 1},
		{"1.2.3.2016.1.1", "1.2.3.4", 1},
		{"1.2.3.2016.1.1", "1-2-3-4", 1},
		{"1.2.3.2016.1.1", "20150101", -1},
		{"1.2.3.2016.1.1", "20151212", -1},
		{"1.2.3.2016.1.1", "20151212.0", -1},
		{"1.2.3.2016.1.1", "20151212.1", -1},
		{"1.2.3.2016.1.1", "2015.1.1", -1},
		{"1.2.3.2016.1.1", "2015.02.02", -1},
		{"1.2.3.2016.1.1", "2015.12.12", -1},
		{"1.2.3.2016.1.1", "1.2.3a", 1},
		{"1.2.3.2016.1.1", "1.2.3b", 1},
		{"1.2.3.2016.1.1", "R16B", 1},
		{"1.2.3.2016.1.1", "R16C", 1},
		{"1.2.3.2016.1.1", "1.2.3.2016.1.1", 0},
		{"1.2.3.2016.1.1", "0.5a1.dev", 1},
		{"1.2.3.2016.1.1", "1.8.B59BrZX", -1},
		{"1.2.3.2016.1.1", "0.07b4p1", 1},
		{"1.2.3.2016.1.1", "3.99.5final.SP07", -1},
		{"1.2.3.2016.1.1", "3.99.5final.SP08", -1},
		{"1.2.3.2016.1.1", "0.4.tbb.20100203", 1},
		{"1.2.3.2016.1.1", "0.5.20120830CVS.el7", 1},
		{"1.2.3.2016.1.1", "1.el7", 1},
		{"1.2.3.2016.1.1", "1.el6", 1},
		{"1.2.3.2016.1.1", "10.el7", -1},
		{"1.2.3.2016.1.1", "01.el7", 1},
		{"1.2.3.2016.1.1", "0.17.20140318svn632.el7", 1},
		{"1.2.3.2016.1.1", "0.17.20140318svn633.el7", 1},
		{"1.2.3.2016.1.1", "1.20140522gitad6fb3e.el7", -1},
		{"1.2.3.2016.1.1", "1.20140522hitad6fb3e.el7", -1},
		{"1.2.3.2016.1.1", "8.20140605hgacf1c26e3019.el7", -1},
		{"1.2.3.2016.1.1", "8.20140605hgacf1c26e3029.el7", -1},
		{"1.2.3.2016.1.1", "22.svn457.el7", -1},
		{"1.2.3.2016.1.1", "22.svn458.el7", -1},
		{"1.2.3.2016.1.1", "~", 1},
		{"1.2.3.2016.1.1", "~~", 1},
		{"1.2.3.2016.1.1", "~1", 1},
		{"1.2.3.2016.1.1", "~a", 1},
		{"1.2.3.2016.1.1", "1~", 1},
		{"1.2.3.2016.1.1", "2~", -1},
		{"0.5a1.dev", "", 1},
		{"0.5a1.dev", "0", 1},
		{"0.5a1.dev", "1", -1},
		{"0.5a1.dev", "2", -1},
		{"0.5a1.dev", "10", -1},
		{"0.5a1.dev", "100", -1},
		{"0.5a1.dev", "0.0", 1},
		{"0.5a1.dev", "0.1", 1},
		{"0.5a1.dev", "0.10", -1},
		{"0.5a1.dev", "0.99", -1},
		{"0.5a1.dev", "1.0", -1},
		{"0.5a1.dev", "1.99", -1},
		{"0.5a1.dev", "2.0", -1},
		{"0.5a1.dev", "0.0.0", 1},
		{"0.5a1.dev", "0.0.1", 1},
		{"0.5a1.dev", "0.0.2", 1},
		{"0.5a1.dev", "0.0.10", 1},
		{"0.5a1.dev", "0.0.99", 1},
		{"0.5a1.dev", "0.1.0", 1},
		{"0.5a1.dev", "0.2.0", 1},
		{"0.5a1.dev", "0.10.0", -1},
		{"0.5a1.dev", "0.99.0", -1},
		{"0.5a1.dev", "0.100.0", -1},
		{"0.5a1.dev", "0.0.0.0", 1},
		{"0.5a1.dev", "0.0.0.1", 1},
		{"0.5a1.dev", "0.0.0.10", 1},
		{"0.5a1.dev", "0.0.1.0", 1},
		{"0.5a1.dev", "0.0.01.0", 1},
		{"0.5a1.dev", "1.2.3.4", -1},
		{"0.5a1.dev", "1-2-3-4", -1},
		{"0.5a1.dev", "20150101", -1},
		{"0.5a1.dev", "20151212", -1},
		{"0.5a1.dev", "20151212.0", -1},
		{"0.5a1.dev", "20151212.1", -1},
		{"0.5a1.dev", "2015.1.1", -1},
		{"0.5a1.dev", "2015.02.02", -1},
		{"0.5a1.dev", "2015.12.12", -1},
		{"0.5a1.dev", "1.2.3a", -1},
		{"0.5a1.dev", "1.2.3b", -1},
		{"0.5a1.dev", "R16B", 1},
		{"0.5a1.dev", "R16C", 1},
		{"0.5a1.dev", "1.2.3.2016.1.1", -1},
		{"0.5a1.dev", "0.5a1.dev", 0},
		{"0.5a1.dev", "1.8.B59BrZX", -1},
		{"0.5a1.dev", "0.07b4p1", -1},
		{"0.5a1.dev", "3.99.5final.SP07", -1},
		{"0.5a1.dev", "3.99.5final.SP08", -1},
		{"0.5a1.dev", "0.4.tbb.20100203", 1},
		{"0.5a1.dev", "0.5.20120830CVS.el7", -1},
		{"0.5a1.dev", "1.el7", -1},
		{"0.5a1.dev", "1.el6", -1},
		{"0.5a1.dev", "10.el7", -1},
		{"0.5a1.dev", "01.el7", -1},
		{"0.5a1.dev", "0.17.20140318svn632.el7", -1},
		{"0.5a1.dev", "0.17.20140318svn633.el7", -1},
		{"0.5a1.dev", "1.20140522gitad6fb3e.el7", -1},
		{"0.5a1.dev", "1.20140522hitad6fb3e.el7", -1},
		{"0.5a1.dev", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.5a1.dev", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.5a1.dev", "22.svn457.el7", -1},
		{"0.5a1.dev", "22.svn458.el7", -1},
		{"0.5a1.dev", "~", 1},
		{"0.5a1.dev", "~~", 1},
		{"0.5a1.dev", "~1", 1},
		{"0.5a1.dev", "~a", 1},
		{"0.5a1.dev", "1~", -1},
		{"0.5a1.dev", "2~", -1},
		{"1.8.B59BrZX", "", 1},
		{"1.8.B59BrZX", "0", 1},
		{"1.8.B59BrZX", "1", 1},
		{"1.8.B59BrZX", "2", -1},
		{"1.8.B59BrZX", "10", -1},
		{"1.8.B59BrZX", "100", -1},
		{"1.8.B59BrZX", "0.0", 1},
		{"1.8.B59BrZX", "0.1", 1},
		{"1.8.B59BrZX", "0.10", 1},
		{"1.8.B59BrZX", "0.99", 1},
		{"1.8.B59BrZX", "1.0", 1},
		{"1.8.B59BrZX", "1.99", -1},
		{"1.8.B59BrZX", "2.0", -1},
		{"1.8.B59BrZX", "0.0.0", 1},
		{"1.8.B59BrZX", "0.0.1", 1},
		{"1.8.B59BrZX", "0.0.2", 1},
		{"1.8.B59BrZX", "0.0.10", 1},
		{"1.8.B59BrZX", "0.0.99", 1},
		{"1.8.B59BrZX", "0.1.0", 1},
		{"1.8.B59BrZX", "0.2.0", 1},
		{"1.8.B59BrZX", "0.10.0", 1},
		{"1.8.B59BrZX", "0.99.0", 1},
		{"1.8.B59BrZX", "0.100.0", 1},
		{"1.8.B59BrZX", "0.0.0.0", 1},
		{"1.8.B59BrZX", "0.0.0.1", 1},
		{"1.8.B59BrZX", "0.0.0.10", 1},
		{"1.8.B59BrZX", "0.0.1.0", 1},
		{"1.8.B59BrZX", "0.0.01.0", 1},
		{"1.8.B59BrZX", "1.2.3.4", 1},
		{"1.8.B59BrZX", "1-2-3-4", 1},
		{"1.8.B59BrZX", "20150101", -1},
		{"1.8.B59BrZX", "20151212", -1},
		{"1.8.B59BrZX", "20151212.0", -1},
		{"1.8.B59BrZX", "20151212.1", -1},
		{"1.8.B59BrZX", "2015.1.1", -1},
		{"1.8.B59BrZX", "2015.02.02", -1},
		{"1.8.B59BrZX", "2015.12.12", -1},
		{"1.8.B59BrZX", "1.2.3a", 1},
		{"1.8.B59BrZX", "1.2.3b", 1},
		{"1.8.B59BrZX", "R16B", 1},
		{"1.8.B59BrZX", "R16C", 1},
		{"1.8.B59BrZX", "1.2.3.2016.1.1", 1},
		{"1.8.B59BrZX", "0.5a1.dev", 1},
		{"1.8.B59BrZX", "1.8.B59BrZX", 0},
		{"1.8.B59BrZX", "0.07b4p1", 1},
		{"1.8.B59BrZX", "3.99.5final.SP07", -1},
		{"1.8.B59BrZX", "3.99.5final.SP08", -1},
		{"1.8.B59BrZX", "0.4.tbb.20100203", 1},
		{"1.8.B59BrZX", "0.5.20120830CVS.el7", 1},
		{"1.8.B59BrZX", "1.el7", 1},
		{"1.8.B59BrZX", "1.el6", 1},
		{"1.8.B59BrZX", "10.el7", -1},
		{"1.8.B59BrZX", "01.el7", 1},
		{"1.8.B59BrZX", "0.17.20140318svn632.el7", 1},
		{"1.8.B59BrZX", "0.17.20140318svn633.el7", 1},
		{"1.8.B59BrZX", "1.20140522gitad6fb3e.el7", -1},
		{"1.8.B59BrZX", "1.20140522hitad6fb3e.el7", -1},
		{"1.8.B59BrZX", "8.20140605hgacf1c26e3019.el7", -1},
		{"1.8.B59BrZX", "8.20140605hgacf1c26e3029.el7", -1},
		{"1.8.B59BrZX", "22.svn457.el7", -1},
		{"1.8.B59BrZX", "22.svn458.el7", -1},
		{"1.8.B59BrZX", "~", 1},
		{"1.8.B59BrZX", "~~", 1},
		{"1.8.B59BrZX", "~1", 1},
		{"1.8.B59BrZX", "~a", 1},
		{"1.8.B59BrZX", "1~", 1},
		{"1.8.B59BrZX", "2~", -1},
		{"0.07b4p1", "", 1},
		{"0.07b4p1", "0", 1},
		{"0.07b4p1", "1", -1},
		{"0.07b4p1", "2", -1},
		{"0.07b4p1", "10", -1},
		{"0.07b4p1", "100", -1},
		{"0.07b4p1", "0.0", 1},
		{"0.07b4p1", "0.1", 1},
		{"0.07b4p1", "0.10", -1},
		{"0.07b4p1", "0.99", -1},
		{"0.07b4p1", "1.0", -1},
		{"0.07b4p1", "1.99", -1},
		{"0.07b4p1", "2.0", -1},
		{"0.07b4p1", "0.0.0", 1},
		{"0.07b4p1", "0.0.1", 1},
		{"0.07b4p1", "0.0.2", 1},
		{"0.07b4p1", "0.0.10", 1},
		{"0.07b4p1", "0.0.99", 1},
		{"0.07b4p1", "0.1.0", 1},
		{"0.07b4p1", "0.2.0", 1},
		{"0.07b4p1", "0.10.0", -1},
		{"0.07b4p1", "0.99.0", -1},
		{"0.07b4p1", "0.100.0", -1},
		{"0.07b4p1", "0.0.0.0", 1},
		{"0.07b4p1", "0.0.0.1", 1},
		{"0.07b4p1", "0.0.0.10", 1},
		{"0.07b4p1", "0.0.1.0", 1},
		{"0.07b4p1", "0.0.01.0", 1},
		{"0.07b4p1", "1.2.3.4", -1},
		{"0.07b4p1", "1-2-3-4", -1},
		{"0.07b4p1", "20150101", -1},
		{"0.07b4p1", "20151212", -1},
		{"0.07b4p1", "20151212.0", -1},
		{"0.07b4p1", "20151212.1", -1},
		{"0.07b4p1", "2015.1.1", -1},
		{"0.07b4p1", "2015.02.02", -1},
		{"0.07b4p1", "2015.12.12", -1},
		{"0.07b4p1", "1.2.3a", -1},
		{"0.07b4p1", "1.2.3b", -1},
		{"0.07b4p1", "R16B", 1},
		{"0.07b4p1", "R16C", 1},
		{"0.07b4p1", "1.2.3.2016.1.1", -1},
		{"0.07b4p1", "0.5a1.dev", 1},
		{"0.07b4p1", "1.8.B59BrZX", -1},
		{"0.07b4p1", "0.07b4p1", 0},
		{"0.07b4p1", "3.99.5final.SP07", -1},
		{"0.07b4p1", "3.99.5final.SP08", -1},
		{"0.07b4p1", "0.4.tbb.20100203", 1},
		{"0.07b4p1", "0.5.20120830CVS.el7", 1},
		{"0.07b4p1", "1.el7", -1},
		{"0.07b4p1", "1.el6", -1},
		{"0.07b4p1", "10.el7", -1},
		{"0.07b4p1", "01.el7", -1},
		{"0.07b4p1", "0.17.20140318svn632.el7", -1},
		{"0.07b4p1", "0.17.20140318svn633.el7", -1},
		{"0.07b4p1", "1.20140522gitad6fb3e.el7", -1},
		{"0.07b4p1", "1.20140522hitad6fb3e.el7", -1},
		{"0.07b4p1", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.07b4p1", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.07b4p1", "22.svn457.el7", -1},
		{"0.07b4p1", "22.svn458.el7", -1},
		{"0.07b4p1", "~", 1},
		{"0.07b4p1", "~~", 1},
		{"0.07b4p1", "~1", 1},
		{"0.07b4p1", "~a", 1},
		{"0.07b4p1", "1~", -1},
		{"0.07b4p1", "2~", -1},
		{"3.99.5final.SP07", "", 1},
		{"3.99.5final.SP07", "0", 1},
		{"3.99.5final.SP07", "1", 1},
		{"3.99.5final.SP07", "2", 1},
		{"3.99.5final.SP07", "10", -1},
		{"3.99.5final.SP07", "100", -1},
		{"3.99.5final.SP07", "0.0", 1},
		{"3.99.5final.SP07", "0.1", 1},
		{"3.99.5final.SP07", "0.10", 1},
		{"3.99.5final.SP07", "0.99", 1},
		{"3.99.5final.SP07", "1.0", 1},
		{"3.99.5final.SP07", "1.99", 1},
		{"3.99.5final.SP07", "2.0", 1},
		{"3.99.5final.SP07", "0.0.0", 1},
		{"3.99.5final.SP07", "0.0.1", 1},
		{"3.99.5final.SP07", "0.0.2", 1},
		{"3.99.5final.SP07", "0.0.10", 1},
		{"3.99.5final.SP07", "0.0.99", 1},
		{"3.99.5final.SP07", "0.1.0", 1},
		{"3.99.5final.SP07", "0.2.0", 1},
		{"3.99.5final.SP07", "0.10.0", 1},
		{"3.99.5final.SP07", "0.99.0", 1},
		{"3.99.5final.SP07", "0.100.0", 1},
		{"3.99.5final.SP07", "0.0.0.0", 1},
		{"3.99.5final.SP07", "0.0.0.1", 1},
		{"3.99.5final.SP07", "0.0.0.10", 1},
		{"3.99.5final.SP07", "0.0.1.0", 1},
		{"3.99.5final.SP07", "0.0.01.0", 1},
		{"3.99.5final.SP07", "1.2.3.4", 1},
		{"3.99.5final.SP07", "1-2-3-4", 1},
		{"3.99.5final.SP07", "20150101", -1},
		{"3.99.5final.SP07", "20151212", -1},
		{"3.99.5final.SP07", "20151212.0", -1},
		{"3.99.5final.SP07", "20151212.1", -1},
		{"3.99.5final.SP07", "2015.1.1", -1},
		{"3.99.5final.SP07", "2015.02.02", -1},
		{"3.99.5final.SP07", "2015.12.12", -1},
		{"3.99.5final.SP07", "1.2.3a", 1},
		{"3.99.5final.SP07", "1.2.3b", 1},
		{"3.99.5final.SP07", "R16B", 1},
		{"3.99.5final.SP07", "R16C", 1},
		{"3.99.5final.SP07", "1.2.3.2016.1.1", 1},
		{"3.99.5final.SP07", "0.5a1.dev", 1},
		{"3.99.5final.SP07", "1.8.B59BrZX", 1},
		{"3.99.5final.SP07", "0.07b4p1", 1},
		{"3.99.5final.SP07", "3.99.5final.SP07", 0},
		{"3.99.5final.SP07", "3.99.5final.SP08", -1},
		{"3.99.5final.SP07", "0.4.tbb.20100203", 1},
		{"3.99.5final.SP07", "0.5.20120830CVS.el7", 1},
		{"3.99.5final.SP07", "1.el7", 1},
		{"3.99.5final.SP07", "1.el6", 1},
		{"3.99.5final.SP07", "10.el7", -1},
		{"3.99.5final.SP07", "01.el7", 1},
		{"3.99.5final.SP07", "0.17.20140318svn632.el7", 1},
		{"3.99.5final.SP07", "0.17.20140318svn633.el7", 1},
		{"3.99.5final.SP07", "1.20140522gitad6fb3e.el7", 1},
		{"3.99.5final.SP07", "1.20140522hitad6fb3e.el7", 1},
		{"3.99.5final.SP07", "8.20140605hgacf1c26e3019.el7", -1},
		{"3.99.5final.SP07", "8.20140605hgacf1c26e3029.el7", -1},
		{"3.99.5final.SP07", "22.svn457.el7", -1},
		{"3.99.5final.SP07", "22.svn458.el7", -1},
		{"3.99.5final.SP07", "~", 1},
		{"3.99.5final.SP07", "~~", 1},
		{"3.99.5final.SP07", "~1", 1},
		{"3.99.5final.SP07", "~a", 1},
		{"3.99.5final.SP07", "1~", 1},
		{"3.99.5final.SP07", "2~", 1},
		{"3.99.5final.SP08", "", 1},
		{"3.99.5final.SP08", "0", 1},
		{"3.99.5final.SP08", "1", 1},
		{"3.99.5final.SP08", "2", 1},
		{"3.99.5final.SP08", "10", -1},
		{"3.99.5final.SP08", "100", -1},
		{"3.99.5final.SP08", "0.0", 1},
		{"3.99.5final.SP08", "0.1", 1},
		{"3.99.5final.SP08", "0.10", 1},
		{"3.99.5final.SP08", "0.99", 1},
		{"3.99.5final.SP08", "1.0", 1},
		{"3.99.5final.SP08", "1.99", 1},
		{"3.99.5final.SP08", "2.0", 1},
		{"3.99.5final.SP08", "0.0.0", 1},
		{"3.99.5final.SP08", "0.0.1", 1},
		{"3.99.5final.SP08", "0.0.2", 1},
		{"3.99.5final.SP08", "0.0.10", 1},
		{"3.99.5final.SP08", "0.0.99", 1},
		{"3.99.5final.SP08", "0.1.0", 1},
		{"3.99.5final.SP08", "0.2.0", 1},
		{"3.99.5final.SP08", "0.10.0", 1},
		{"3.99.5final.SP08", "0.99.0", 1},
		{"3.99.5final.SP08", "0.100.0", 1},
		{"3.99.5final.SP08", "0.0.0.0", 1},
		{"3.99.5final.SP08", "0.0.0.1", 1},
		{"3.99.5final.SP08", "0.0.0.10", 1},
		{"3.99.5final.SP08", "0.0.1.0", 1},
		{"3.99.5final.SP08", "0.0.01.0", 1},
		{"3.99.5final.SP08", "1.2.3.4", 1},
		{"3.99.5final.SP08", "1-2-3-4", 1},
		{"3.99.5final.SP08", "20150101", -1},
		{"3.99.5final.SP08", "20151212", -1},
		{"3.99.5final.SP08", "20151212.0", -1},
		{"3.99.5final.SP08", "20151212.1", -1},
		{"3.99.5final.SP08", "2015.1.1", -1},
		{"3.99.5final.SP08", "2015.02.02", -1},
		{"3.99.5final.SP08", "2015.12.12", -1},
		{"3.99.5final.SP08", "1.2.3a", 1},
		{"3.99.5final.SP08", "1.2.3b", 1},
		{"3.99.5final.SP08", "R16B", 1},
		{"3.99.5final.SP08", "R16C", 1},
		{"3.99.5final.SP08", "1.2.3.2016.1.1", 1},
		{"3.99.5final.SP08", "0.5a1.dev", 1},
		{"3.99.5final.SP08", "1.8.B59BrZX", 1},
		{"3.99.5final.SP08", "0.07b4p1", 1},
		{"3.99.5final.SP08", "3.99.5final.SP07", 1},
		{"3.99.5final.SP08", "3.99.5final.SP08", 0},
		{"3.99.5final.SP08", "0.4.tbb.20100203", 1},
		{"3.99.5final.SP08", "0.5.20120830CVS.el7", 1},
		{"3.99.5final.SP08", "1.el7", 1},
		{"3.99.5final.SP08", "1.el6", 1},
		{"3.99.5final.SP08", "10.el7", -1},
		{"3.99.5final.SP08", "01.el7", 1},
		{"3.99.5final.SP08", "0.17.20140318svn632.el7", 1},
		{"3.99.5final.SP08", "0.17.20140318svn633.el7", 1},
		{"3.99.5final.SP08", "1.20140522gitad6fb3e.el7", 1},
		{"3.99.5final.SP08", "1.20140522hitad6fb3e.el7", 1},
		{"3.99.5final.SP08", "8.20140605hgacf1c26e3019.el7", -1},
		{"3.99.5final.SP08", "8.20140605hgacf1c26e3029.el7", -1},
		{"3.99.5final.SP08", "22.svn457.el7", -1},
		{"3.99.5final.SP08", "22.svn458.el7", -1},
		{"3.99.5final.SP08", "~", 1},
		{"3.99.5final.SP08", "~~", 1},
		{"3.99.5final.SP08", "~1", 1},
		{"3.99.5final.SP08", "~a", 1},
		{"3.99.5final.SP08", "1~", 1},
		{"3.99.5final.SP08", "2~", 1},
		{"0.4.tbb.20100203", "", 1},
		{"0.4.tbb.20100203", "0", 1},
		{"0.4.tbb.20100203", "1", -1},
		{"0.4.tbb.20100203", "2", -1},
		{"0.4.tbb.20100203", "10", -1},
		{"0.4.tbb.20100203", "100", -1},
		{"0.4.tbb.20100203", "0.0", 1},
		{"0.4.tbb.20100203", "0.1", 1},
		{"0.4.tbb.20100203", "0.10", -1},
		{"0.4.tbb.20100203", "0.99", -1},
		{"0.4.tbb.20100203", "1.0", -1},
		{"0.4.tbb.20100203", "1.99", -1},
		{"0.4.tbb.20100203", "2.0", -1},
		{"0.4.tbb.20100203", "0.0.0", 1},
		{"0.4.tbb.20100203", "0.0.1", 1},
		{"0.4.tbb.20100203", "0.0.2", 1},
		{"0.4.tbb.20100203", "0.0.10", 1},
		{"0.4.tbb.20100203", "0.0.99", 1},
		{"0.4.tbb.20100203", "0.1.0", 1},
		{"0.4.tbb.20100203", "0.2.0", 1},
		{"0.4.tbb.20100203", "0.10.0", -1},
		{"0.4.tbb.20100203", "0.99.0", -1},
		{"0.4.tbb.20100203", "0.100.0", -1},
		{"0.4.tbb.20100203", "0.0.0.0", 1},
		{"0.4.tbb.20100203", "0.0.0.1", 1},
		{"0.4.tbb.20100203", "0.0.0.10", 1},
		{"0.4.tbb.20100203", "0.0.1.0", 1},
		{"0.4.tbb.20100203", "0.0.01.0", 1},
		{"0.4.tbb.20100203", "1.2.3.4", -1},
		{"0.4.tbb.20100203", "1-2-3-4", -1},
		{"0.4.tbb.20100203", "20150101", -1},
		{"0.4.tbb.20100203", "20151212", -1},
		{"0.4.tbb.20100203", "20151212.0", -1},
		{"0.4.tbb.20100203", "20151212.1", -1},
		{"0.4.tbb.20100203", "2015.1.1", -1},
		{"0.4.tbb.20100203", "2015.02.02", -1},
		{"0.4.tbb.20100203", "2015.12.12", -1},
		{"0.4.tbb.20100203", "1.2.3a", -1},
		{"0.4.tbb.20100203", "1.2.3b", -1},
		{"0.4.tbb.20100203", "R16B", 1},
		{"0.4.tbb.20100203", "R16C", 1},
		{"0.4.tbb.20100203", "1.2.3.2016.1.1", -1},
		{"0.4.tbb.20100203", "0.5a1.dev", -1},
		{"0.4.tbb.20100203", "1.8.B59BrZX", -1},
		{"0.4.tbb.20100203", "0.07b4p1", -1},
		{"0.4.tbb.20100203", "3.99.5final.SP07", -1},
		{"0.4.tbb.20100203", "3.99.5final.SP08", -1},
		{"0.4.tbb.20100203", "0.4.tbb.20100203", 0},
		{"0.4.tbb.20100203", "0.5.20120830CVS.el7", -1},
		{"0.4.tbb.20100203", "1.el7", -1},
		{"0.4.tbb.20100203", "1.el6", -1},
		{"0.4.tbb.20100203", "10.el7", -1},
		{"0.4.tbb.20100203", "01.el7", -1},
		{"0.4.tbb.20100203", "0.17.20140318svn632.el7", -1},
		{"0.4.tbb.20100203", "0.17.20140318svn633.el7", -1},
		{"0.4.tbb.20100203", "1.20140522gitad6fb3e.el7", -1},
		{"0.4.tbb.20100203", "1.20140522hitad6fb3e.el7", -1},
		{"0.4.tbb.20100203", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.4.tbb.20100203", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.4.tbb.20100203", "22.svn457.el7", -1},
		{"0.4.tbb.20100203", "22.svn458.el7", -1},
		{"0.4.tbb.20100203", "~", 1},
		{"0.4.tbb.20100203", "~~", 1},
		{"0.4.tbb.20100203", "~1", 1},
		{"0.4.tbb.20100203", "~a", 1},
		{"0.4.tbb.20100203", "1~", -1},
		{"0.4.tbb.20100203", "2~", -1},
		{"0.5.20120830CVS.el7", "", 1},
		{"0.5.20120830CVS.el7", "0", 1},
		{"0.5.20120830CVS.el7", "1", -1},
		{"0.5.20120830CVS.el7", "2", -1},
		{"0.5.20120830CVS.el7", "10", -1},
		{"0.5.20120830CVS.el7", "100", -1},
		{"0.5.20120830CVS.el7", "0.0", 1},
		{"0.5.20120830CVS.el7", "0.1", 1},
		{"0.5.20120830CVS.el7", "0.10", -1},
		{"0.5.20120830CVS.el7", "0.99", -1},
		{"0.5.20120830CVS.el7", "1.0", -1},
		{"0.5.20120830CVS.el7", "1.99", -1},
		{"0.5.20120830CVS.el7", "2.0", -1},
		{"0.5.20120830CVS.el7", "0.0.0", 1},
		{"0.5.20120830CVS.el7", "0.0.1", 1},
		{"0.5.20120830CVS.el7", "0.0.2", 1},
		{"0.5.20120830CVS.el7", "0.0.10", 1},
		{"0.5.20120830CVS.el7", "0.0.99", 1},
		{"0.5.20120830CVS.el7", "0.1.0", 1},
		{"0.5.20120830CVS.el7", "0.2.0", 1},
		{"0.5.20120830CVS.el7", "0.10.0", -1},
		{"0.5.20120830CVS.el7", "0.99.0", -1},
		{"0.5.20120830CVS.el7", "0.100.0", -1},
		{"0.5.20120830CVS.el7", "0.0.0.0", 1},
		{"0.5.20120830CVS.el7", "0.0.0.1", 1},
		{"0.5.20120830CVS.el7", "0.0.0.10", 1},
		{"0.5.20120830CVS.el7", "0.0.1.0", 1},
		{"0.5.20120830CVS.el7", "0.0.01.0", 1},
		{"0.5.20120830CVS.el7", "1.2.3.4", -1},
		{"0.5.20120830CVS.el7", "1-2-3-4", -1},
		{"0.5.20120830CVS.el7", "20150101", -1},
		{"0.5.20120830CVS.el7", "20151212", -1},
		{"0.5.20120830CVS.el7", "20151212.0", -1},
		{"0.5.20120830CVS.el7", "20151212.1", -1},
		{"0.5.20120830CVS.el7", "2015.1.1", -1},
		{"0.5.20120830CVS.el7", "2015.02.02", -1},
		{"0.5.20120830CVS.el7", "2015.12.12", -1},
		{"0.5.20120830CVS.el7", "1.2.3a", -1},
		{"0.5.20120830CVS.el7", "1.2.3b", -1},
		{"0.5.20120830CVS.el7", "R16B", 1},
		{"0.5.20120830CVS.el7", "R16C", 1},
		{"0.5.20120830CVS.el7", "1.2.3.2016.1.1", -1},
		{"0.5.20120830CVS.el7", "0.5a1.dev", 1},
		{"0.5.20120830CVS.el7", "1.8.B59BrZX", -1},
		{"0.5.20120830CVS.el7", "0.07b4p1", -1},
		{"0.5.20120830CVS.el7", "3.99.5final.SP07", -1},
		{"0.5.20120830CVS.el7", "3.99.5final.SP08", -1},
		{"0.5.20120830CVS.el7", "0.4.tbb.20100203", 1},
		{"0.5.20120830CVS.el7", "0.5.20120830CVS.el7", 0},
		{"0.5.20120830CVS.el7", "1.el7", -1},
		{"0.5.20120830CVS.el7", "1.el6", -1},
		{"0.5.20120830CVS.el7", "10.el7", -1},
		{"0.5.20120830CVS.el7", "01.el7", -1},
		{"0.5.20120830CVS.el7", "0.17.20140318svn632.el7", -1},
		{"0.5.20120830CVS.el7", "0.17.20140318svn633.el7", -1},
		{"0.5.20120830CVS.el7", "1.20140522gitad6fb3e.el7", -1},
		{"0.5.20120830CVS.el7", "1.20140522hitad6fb3e.el7", -1},
		{"0.5.20120830CVS.el7", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.5.20120830CVS.el7", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.5.20120830CVS.el7", "22.svn457.el7", -1},
		{"0.5.20120830CVS.el7", "22.svn458.el7", -1},
		{"0.5.20120830CVS.el7", "~", 1},
		{"0.5.20120830CVS.el7", "~~", 1},
		{"0.5.20120830CVS.el7", "~1", 1},
		{"0.5.20120830CVS.el7", "~a", 1},
		{"0.5.20120830CVS.el7", "1~", -1},
		{"0.5.20120830CVS.el7", "2~", -1},
		{"1.el7", "", 1},
		{"1.el7", "0", 1},
		{"1.el7", "1", 1},
		{"1.el7", "2", -1},
		{"1.el7", "10", -1},
		{"1.el7", "100", -1},
		{"1.el7", "0.0", 1},
		{"1.el7", "0.1", 1},
		{"1.el7", "0.10", 1},
		{"1.el7", "0.99", 1},
		{"1.el7", "1.0", -1},
		{"1.el7", "1.99", -1},
		{"1.el7", "2.0", -1},
		{"1.el7", "0.0.0", 1},
		{"1.el7", "0.0.1", 1},
		{"1.el7", "0.0.2", 1},
		{"1.el7", "0.0.10", 1},
		{"1.el7", "0.0.99", 1},
		{"1.el7", "0.1.0", 1},
		{"1.el7", "0.2.0", 1},
		{"1.el7", "0.10.0", 1},
		{"1.el7", "0.99.0", 1},
		{"1.el7", "0.100.0", 1},
		{"1.el7", "0.0.0.0", 1},
		{"1.el7", "0.0.0.1", 1},
		{"1.el7", "0.0.0.10", 1},
		{"1.el7", "0.0.1.0", 1},
		{"1.el7", "0.0.01.0", 1},
		{"1.el7", "1.2.3.4", -1},
		{"1.el7", "1-2-3-4", -1},
		{"1.el7", "20150101", -1},
		{"1.el7", "20151212", -1},
		{"1.el7", "20151212.0", -1},
		{"1.el7", "20151212.1", -1},
		{"1.el7", "2015.1.1", -1},
		{"1.el7", "2015.02.02", -1},
		{"1.el7", "2015.12.12", -1},
		{"1.el7", "1.2.3a", -1},
		{"1.el7", "1.2.3b", -1},
		{"1.el7", "R16B", 1},
		{"1.el7", "R16C", 1},
		{"1.el7", "1.2.3.2016.1.1", -1},
		{"1.el7", "0.5a1.dev", 1},
		{"1.el7", "1.8.B59BrZX", -1},
		{"1.el7", "0.07b4p1", 1},
		{"1.el7", "3.99.5final.SP07", -1},
		{"1.el7", "3.99.5final.SP08", -1},
		{"1.el7", "0.4.tbb.20100203", 1},
		{"1.el7", "0.5.20120830CVS.el7", 1},
		{"1.el7", "1.el7", 0},
		{"1.el7", "1.el6", 1},
		{"1.el7", "10.el7", -1},
		{"1.el7", "01.el7", 0},
		{"1.el7", "0.17.20140318svn632.el7", 1},
		{"1.el7", "0.17.20140318svn633.el7", 1},
		{"1.el7", "1.20140522gitad6fb3e.el7", -1},
		{"1.el7", "1.20140522hitad6fb3e.el7", -1},
		{"1.el7", "8.20140605hgacf1c26e3019.el7", -1},
		{"1.el7", "8.20140605hgacf1c26e3029.el7", -1},
		{"1.el7", "22.svn457.el7", -1},
		{"1.el7", "22.svn458.el7", -1},
		{"1.el7", "~", 1},
		{"1.el7", "~~", 1},
		{"1.el7", "~1", 1},
		{"1.el7", "~a", 1},
		{"1.el7", "1~", 1},
		{"1.el7", "2~", -1},
		{"1.el6", "", 1},
		{"1.el6", "0", 1},
		{"1.el6", "1", 1},
		{"1.el6", "2", -1},
		{"1.el6", "10", -1},
		{"1.el6", "100", -1},
		{"1.el6", "0.0", 1},
		{"1.el6", "0.1", 1},
		{"1.el6", "0.10", 1},
		{"1.el6", "0.99", 1},
		{"1.el6", "1.0", -1},
		{"1.el6", "1.99", -1},
		{"1.el6", "2.0", -1},
		{"1.el6", "0.0.0", 1},
		{"1.el6", "0.0.1", 1},
		{"1.el6", "0.0.2", 1},
		{"1.el6", "0.0.10", 1},
		{"1.el6", "0.0.99", 1},
		{"1.el6", "0.1.0", 1},
		{"1.el6", "0.2.0", 1},
		{"1.el6", "0.10.0", 1},
		{"1.el6", "0.99.0", 1},
		{"1.el6", "0.100.0", 1},
		{"1.el6", "0.0.0.0", 1},
		{"1.el6", "0.0.0.1", 1},
		{"1.el6", "0.0.0.10", 1},
		{"1.el6", "0.0.1.0", 1},
		{"1.el6", "0.0.01.0", 1},
		{"1.el6", "1.2.3.4", -1},
		{"1.el6", "1-2-3-4", -1},
		{"1.el6", "20150101", -1},
		{"1.el6", "20151212", -1},
		{"1.el6", "20151212.0", -1},
		{"1.el6", "20151212.1", -1},
		{"1.el6", "2015.1.1", -1},
		{"1.el6", "2015.02.02", -1},
		{"1.el6", "2015.12.12", -1},
		{"1.el6", "1.2.3a", -1},
		{"1.el6", "1.2.3b", -1},
		{"1.el6", "R16B", 1},
		{"1.el6", "R16C", 1},
		{"1.el6", "1.2.3.2016.1.1", -1},
		{"1.el6", "0.5a1.dev", 1},
		{"1.el6", "1.8.B59BrZX", -1},
		{"1.el6", "0.07b4p1", 1},
		{"1.el6", "3.99.5final.SP07", -1},
		{"1.el6", "3.99.5final.SP08", -1},
		{"1.el6", "0.4.tbb.20100203", 1},
		{"1.el6", "0.5.20120830CVS.el7", 1},
		{"1.el6", "1.el7", -1},
		{"1.el6", "1.el6", 0},
		{"1.el6", "10.el7", -1},
		{"1.el6", "01.el7", -1},
		{"1.el6", "0.17.20140318svn632.el7", 1},
		{"1.el6", "0.17.20140318svn633.el7", 1},
		{"1.el6", "1.20140522gitad6fb3e.el7", -1},
		{"1.el6", "1.20140522hitad6fb3e.el7", -1},
		{"1.el6", "8.20140605hgacf1c26e3019.el7", -1},
		{"1.el6", "8.20140605hgacf1c26e3029.el7", -1},
		{"1.el6", "22.svn457.el7", -1},
		{"1.el6", "22.svn458.el7", -1},
		{"1.el6", "~", 1},
		{"1.el6", "~~", 1},
		{"1.el6", "~1", 1},
		{"1.el6", "~a", 1},
		{"1.el6", "1~", 1},
		{"1.el6", "2~", -1},
		{"10.el7", "", 1},
		{"10.el7", "0", 1},
		{"10.el7", "1", 1},
		{"10.el7", "2", 1},
		{"10.el7", "10", 1},
		{"10.el7", "100", -1},
		{"10.el7", "0.0", 1},
		{"10.el7", "0.1", 1},
		{"10.el7", "0.10", 1},
		{"10.el7", "0.99", 1},
		{"10.el7", "1.0", 1},
		{"10.el7", "1.99", 1},
		{"10.el7", "2.0", 1},
		{"10.el7", "0.0.0", 1},
		{"10.el7", "0.0.1", 1},
		{"10.el7", "0.0.2", 1},
		{"10.el7", "0.0.10", 1},
		{"10.el7", "0.0.99", 1},
		{"10.el7", "0.1.0", 1},
		{"10.el7", "0.2.0", 1},
		{"10.el7", "0.10.0", 1},
		{"10.el7", "0.99.0", 1},
		{"10.el7", "0.100.0", 1},
		{"10.el7", "0.0.0.0", 1},
		{"10.el7", "0.0.0.1", 1},
		{"10.el7", "0.0.0.10", 1},
		{"10.el7", "0.0.1.0", 1},
		{"10.el7", "0.0.01.0", 1},
		{"10.el7", "1.2.3.4", 1},
		{"10.el7", "1-2-3-4", 1},
		{"10.el7", "20150101", -1},
		{"10.el7", "20151212", -1},
		{"10.el7", "20151212.0", -1},
		{"10.el7", "20151212.1", -1},
		{"10.el7", "2015.1.1", -1},
		{"10.el7", "2015.02.02", -1},
		{"10.el7", "2015.12.12", -1},
		{"10.el7", "1.2.3a", 1},
		{"10.el7", "1.2.3b", 1},
		{"10.el7", "R16B", 1},
		{"10.el7", "R16C", 1},
		{"10.el7", "1.2.3.2016.1.1", 1},
		{"10.el7", "0.5a1.dev", 1},
		{"10.el7", "1.8.B59BrZX", 1},
		{"10.el7", "0.07b4p1", 1},
		{"10.el7", "3.99.5final.SP07", 1},
		{"10.el7", "3.99.5final.SP08", 1},
		{"10.el7", "0.4.tbb.20100203", 1},
		{"10.el7", "0.5.20120830CVS.el7", 1},
		{"10.el7", "1.el7", 1},
		{"10.el7", "1.el6", 1},
		{"10.el7", "10.el7", 0},
		{"10.el7", "01.el7", 1},
		{"10.el7", "0.17.20140318svn632.el7", 1},
		{"10.el7", "0.17.20140318svn633.el7", 1},
		{"10.el7", "1.20140522gitad6fb3e.el7", 1},
		{"10.el7", "1.20140522hitad6fb3e.el7", 1},
		{"10.el7", "8.20140605hgacf1c26e3019.el7", 1},
		{"10.el7", "8.20140605hgacf1c26e3029.el7", 1},
		{"10.el7", "22.svn457.el7", -1},
		{"10.el7", "22.svn458.el7", -1},
		{"10.el7", "~", 1},
		{"10.el7", "~~", 1},
		{"10.el7", "~1", 1},
		{"10.el7", "~a", 1},
		{"10.el7", "1~", 1},
		{"10.el7", "2~", 1},
		{"01.el7", "", 1},
		{"01.el7", "0", 1},
		{"01.el7", "1", 1},
		{"01.el7", "2", -1},
		{"01.el7", "10", -1},
		{"01.el7", "100", -1},
		{"01.el7", "0.0", 1},
		{"01.el7", "0.1", 1},
		{"01.el7", "0.10", 1},
		{"01.el7", "0.99", 1},
		{"01.el7", "1.0", -1},
		{"01.el7", "1.99", -1},
		{"01.el7", "2.0", -1},
		{"01.el7", "0.0.0", 1},
		{"01.el7", "0.0.1", 1},
		{"01.el7", "0.0.2", 1},
		{"01.el7", "0.0.10", 1},
		{"01.el7", "0.0.99", 1},
		{"01.el7", "0.1.0", 1},
		{"01.el7", "0.2.0", 1},
		{"01.el7", "0.10.0", 1},
		{"01.el7", "0.99.0", 1},
		{"01.el7", "0.100.0", 1},
		{"01.el7", "0.0.0.0", 1},
		{"01.el7", "0.0.0.1", 1},
		{"01.el7", "0.0.0.10", 1},
		{"01.el7", "0.0.1.0", 1},
		{"01.el7", "0.0.01.0", 1},
		{"01.el7", "1.2.3.4", -1},
		{"01.el7", "1-2-3-4", -1},
		{"01.el7", "20150101", -1},
		{"01.el7", "20151212", -1},
		{"01.el7", "20151212.0", -1},
		{"01.el7", "20151212.1", -1},
		{"01.el7", "2015.1.1", -1},
		{"01.el7", "2015.02.02", -1},
		{"01.el7", "2015.12.12", -1},
		{"01.el7", "1.2.3a", -1},
		{"01.el7", "1.2.3b", -1},
		{"01.el7", "R16B", 1},
		{"01.el7", "R16C", 1},
		{"01.el7", "1.2.3.2016.1.1", -1},
		{"01.el7", "0.5a1.dev", 1},
		{"01.el7", "1.8.B59BrZX", -1},
		{"01.el7", "0.07b4p1", 1},
		{"01.el7", "3.99.5final.SP07", -1},
		{"01.el7", "3.99.5final.SP08", -1},
		{"01.el7", "0.4.tbb.20100203", 1},
		{"01.el7", "0.5.20120830CVS.el7", 1},
		{"01.el7", "1.el7", 0},
		{"01.el7", "1.el6", 1},
		{"01.el7", "10.el7", -1},
		{"01.el7", "01.el7", 0},
		{"01.el7", "0.17.20140318svn632.el7", 1},
		{"01.el7", "0.17.20140318svn633.el7", 1},
		{"01.el7", "1.20140522gitad6fb3e.el7", -1},
		{"01.el7", "1.20140522hitad6fb3e.el7", -1},
		{"01.el7", "8.20140605hgacf1c26e3019.el7", -1},
		{"01.el7", "8.20140605hgacf1c26e3029.el7", -1},
		{"01.el7", "22.svn457.el7", -1},
		{"01.el7", "22.svn458.el7", -1},
		{"01.el7", "~", 1},
		{"01.el7", "~~", 1},
		{"01.el7", "~1", 1},
		{"01.el7", "~a", 1},
		{"01.el7", "1~", 1},
		{"01.el7", "2~", -1},
		{"0.17.20140318svn632.el7", "", 1},
		{"0.17.20140318svn632.el7", "0", 1},
		{"0.17.20140318svn632.el7", "1", -1},
		{"0.17.20140318svn632.el7", "2", -1},
		{"0.17.20140318svn632.el7", "10", -1},
		{"0.17.20140318svn632.el7", "100", -1},
		{"0.17.20140318svn632.el7", "0.0", 1},
		{"0.17.20140318svn632.el7", "0.1", 1},
		{"0.17.20140318svn632.el7", "0.10", 1},
		{"0.17.20140318svn632.el7", "0.99", -1},
		{"0.17.20140318svn632.el7", "1.0", -1},
		{"0.17.20140318svn632.el7", "1.99", -1},
		{"0.17.20140318svn632.el7", "2.0", -1},
		{"0.17.20140318svn632.el7", "0.0.0", 1},
		{"0.17.20140318svn632.el7", "0.0.1", 1},
		{"0.17.20140318svn632.el7", "0.0.2", 1},
		{"0.17.20140318svn632.el7", "0.0.10", 1},
		{"0.17.20140318svn632.el7", "0.0.99", 1},
		{"0.17.20140318svn632.el7", "0.1.0", 1},
		{"0.17.20140318svn632.el7", "0.2.0", 1},
		{"0.17.20140318svn632.el7", "0.10.0", 1},
		{"0.17.20140318svn632.el7", "0.99.0", -1},
		{"0.17.20140318svn632.el7", "0.100.0", -1},
		{"0.17.20140318svn632.el7", "0.0.0.0", 1},
		{"0.17.20140318svn632.el7", "0.0.0.1", 1},
		{"0.17.20140318svn632.el7", "0.0.0.10", 1},
		{"0.17.20140318svn632.el7", "0.0.1.0", 1},
		{"0.17.20140318svn632.el7", "0.0.01.0", 1},
		{"0.17.20140318svn632.el7", "1.2.3.4", -1},
		{"0.17.20140318svn632.el7", "1-2-3-4", -1},
		{"0.17.20140318svn632.el7", "20150101", -1},
		{"0.17.20140318svn632.el7", "20151212", -1},
		{"0.17.20140318svn632.el7", "20151212.0", -1},
		{"0.17.20140318svn632.el7", "20151212.1", -1},
		{"0.17.20140318svn632.el7", "2015.1.1", -1},
		{"0.17.20140318svn632.el7", "2015.02.02", -1},
		{"0.17.20140318svn632.el7", "2015.12.12", -1},
		{"0.17.20140318svn632.el7", "1.2.3a", -1},
		{"0.17.20140318svn632.el7", "1.2.3b", -1},
		{"0.17.20140318svn632.el7", "R16B", 1},
		{"0.17.20140318svn632.el7", "R16C", 1},
		{"0.17.20140318svn632.el7", "1.2.3.2016.1.1", -1},
		{"0.17.20140318svn632.el7", "0.5a1.dev", 1},
		{"0.17.20140318svn632.el7", "1.8.B59BrZX", -1},
		{"0.17.20140318svn632.el7", "0.07b4p1", 1},
		{"0.17.20140318svn632.el7", "3.99.5final.SP07", -1},
		{"0.17.20140318svn632.el7", "3.99.5final.SP08", -1},
		{"0.17.20140318svn632.el7", "0.4.tbb.20100203", 1},
		{"0.17.20140318svn632.el7", "0.5.20120830CVS.el7", 1},
		{"0.17.20140318svn632.el7", "1.el7", -1},
		{"0.17.20140318svn632.el7", "1.el6", -1},
		{"0.17.20140318svn632.el7", "10.el7", -1},
		{"0.17.20140318svn632.el7", "01.el7", -1},
		{"0.17.20140318svn632.el7", "0.17.20140318svn632.el7", 0},
		{"0.17.20140318svn632.el7", "0.17.20140318svn633.el7", -1},
		{"0.17.20140318svn632.el7", "1.20140522gitad6fb3e.el7", -1},
		{"0.17.20140318svn632.el7", "1.20140522hitad6fb3e.el7", -1},
		{"0.17.20140318svn632.el7", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.17.20140318svn632.el7", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.17.20140318svn632.el7", "22.svn457.el7", -1},
		{"0.17.20140318svn632.el7", "22.svn458.el7", -1},
		{"0.17.20140318svn632.el7", "~", 1},
		{"0.17.20140318svn632.el7", "~~", 1},
		{"0.17.20140318svn632.el7", "~1", 1},
		{"0.17.20140318svn632.el7", "~a", 1},
		{"0.17.20140318svn632.el7", "1~", -1},
		{"0.17.20140318svn632.el7", "2~", -1},
		{"0.17.20140318svn633.el7", "", 1},
		{"0.17.20140318svn633.el7", "0", 1},
		{"0.17.20140318svn633.el7", "1", -1},
		{"0.17.20140318svn633.el7", "2", -1},
		{"0.17.20140318svn633.el7", "10", -1},
		{"0.17.20140318svn633.el7", "100", -1},
		{"0.17.20140318svn633.el7", "0.0", 1},
		{"0.17.20140318svn633.el7", "0.1", 1},
		{"0.17.20140318svn633.el7", "0.10", 1},
		{"0.17.20140318svn633.el7", "0.99", -1},
		{"0.17.20140318svn633.el7", "1.0", -1},
		{"0.17.20140318svn633.el7", "1.99", -1},
		{"0.17.20140318svn633.el7", "2.0", -1},
		{"0.17.20140318svn633.el7", "0.0.0", 1},
		{"0.17.20140318svn633.el7", "0.0.1", 1},
		{"0.17.20140318svn633.el7", "0.0.2", 1},
		{"0.17.20140318svn633.el7", "0.0.10", 1},
		{"0.17.20140318svn633.el7", "0.0.99", 1},
		{"0.17.20140318svn633.el7", "0.1.0", 1},
		{"0.17.20140318svn633.el7", "0.2.0", 1},
		{"0.17.20140318svn633.el7", "0.10.0", 1},
		{"0.17.20140318svn633.el7", "0.99.0", -1},
		{"0.17.20140318svn633.el7", "0.100.0", -1},
		{"0.17.20140318svn633.el7", "0.0.0.0", 1},
		{"0.17.20140318svn633.el7", "0.0.0.1", 1},
		{"0.17.20140318svn633.el7", "0.0.0.10", 1},
		{"0.17.20140318svn633.el7", "0.0.1.0", 1},
		{"0.17.20140318svn633.el7", "0.0.01.0", 1},
		{"0.17.20140318svn633.el7", "1.2.3.4", -1},
		{"0.17.20140318svn633.el7", "1-2-3-4", -1},
		{"0.17.20140318svn633.el7", "20150101", -1},
		{"0.17.20140318svn633.el7", "20151212", -1},
		{"0.17.20140318svn633.el7", "20151212.0", -1},
		{"0.17.20140318svn633.el7", "20151212.1", -1},
		{"0.17.20140318svn633.el7", "2015.1.1", -1},
		{"0.17.20140318svn633.el7", "2015.02.02", -1},
		{"0.17.20140318svn633.el7", "2015.12.12", -1},
		{"0.17.20140318svn633.el7", "1.2.3a", -1},
		{"0.17.20140318svn633.el7", "1.2.3b", -1},
		{"0.17.20140318svn633.el7", "R16B", 1},
		{"0.17.20140318svn633.el7", "R16C", 1},
		{"0.17.20140318svn633.el7", "1.2.3.2016.1.1", -1},
		{"0.17.20140318svn633.el7", "0.5a1.dev", 1},
		{"0.17.20140318svn633.el7", "1.8.B59BrZX", -1},
		{"0.17.20140318svn633.el7", "0.07b4p1", 1},
		{"0.17.20140318svn633.el7", "3.99.5final.SP07", -1},
		{"0.17.20140318svn633.el7", "3.99.5final.SP08", -1},
		{"0.17.20140318svn633.el7", "0.4.tbb.20100203", 1},
		{"0.17.20140318svn633.el7", "0.5.20120830CVS.el7", 1},
		{"0.17.20140318svn633.el7", "1.el7", -1},
		{"0.17.20140318svn633.el7", "1.el6", -1},
		{"0.17.20140318svn633.el7", "10.el7", -1},
		{"0.17.20140318svn633.el7", "01.el7", -1},
		{"0.17.20140318svn633.el7", "0.17.20140318svn632.el7", 1},
		{"0.17.20140318svn633.el7", "0.17.20140318svn633.el7", 0},
		{"0.17.20140318svn633.el7", "1.20140522gitad6fb3e.el7", -1},
		{"0.17.20140318svn633.el7", "1.20140522hitad6fb3e.el7", -1},
		{"0.17.20140318svn633.el7", "8.20140605hgacf1c26e3019.el7", -1},
		{"0.17.20140318svn633.el7", "8.20140605hgacf1c26e3029.el7", -1},
		{"0.17.20140318svn633.el7", "22.svn457.el7", -1},
		{"0.17.20140318svn633.el7", "22.svn458.el7", -1},
		{"0.17.20140318svn633.el7", "~", 1},
		{"0.17.20140318svn633.el7", "~~", 1},
		{"0.17.20140318svn633.el7", "~1", 1},
		{"0.17.20140318svn633.el7", "~a", 1},
		{"0.17.20140318svn633.el7", "1~", -1},
		{"0.17.20140318svn633.el7", "2~", -1},
		{"1.20140522gitad6fb3e.el7", "", 1},
		{"1.20140522gitad6fb3e.el7", "0", 1},
		{"1.20140522gitad6fb3e.el7", "1", 1},
		{"1.20140522gitad6fb3e.el7", "2", -1},
		{"1.20140522gitad6fb3e.el7", "10", -1},
		{"1.20140522gitad6fb3e.el7", "100", -1},
		{"1.20140522gitad6fb3e.el7", "0.0", 1},
		{"1.20140522gitad6fb3e.el7", "0.1", 1},
		{"1.20140522gitad6fb3e.el7", "0.10", 1},
		{"1.20140522gitad6fb3e.el7", "0.99", 1},
		{"1.20140522gitad6fb3e.el7", "1.0", 1},
		{"1.20140522gitad6fb3e.el7", "1.99", 1},
		{"1.20140522gitad6fb3e.el7", "2.0", -1},
		{"1.20140522gitad6fb3e.el7", "0.0.0", 1},
		{"1.20140522gitad6fb3e.el7", "0.0.1", 1},
		{"1.20140522gitad6fb3e.el7", "0.0.2", 1},
		{"1.20140522gitad6fb3e.el7", "0.0.10", 1},
		{"1.20140522gitad6fb3e.el7", "0.0.99", 1},
		{"1.20140522gitad6fb3e.el7", "0.1.0", 1},
		{"1.20140522gitad6fb3e.el7", "0.2.0", 1},
		{"1.20140522gitad6fb3e.el7", "0.10.0", 1},
		{"1.20140522gitad6fb3e.el7", "0.99.0", 1},
		{"1.20140522gitad6fb3e.el7", "0.100.0", 1},
		{"1.20140522gitad6fb3e.el7", "0.0.0.0", 1},
		{"1.20140522gitad6fb3e.el7", "0.0.0.1", 1},
		{"1.20140522gitad6fb3e.el7", "0.0.0.10", 1},
		{"1.20140522gitad6fb3e.el7", "0.0.1.0", 1},
		{"1.20140522gitad6fb3e.el7", "0.0.01.0", 1},
		{"1.20140522gitad6fb3e.el7", "1.2.3.4", 1},
		{"1.20140522gitad6fb3e.el7", "1-2-3-4", 1},
		{"1.20140522gitad6fb3e.el7", "20150101", -1},
		{"1.20140522gitad6fb3e.el7", "20151212", -1},
		{"1.20140522gitad6fb3e.el7", "20151212.0", -1},
		{"1.20140522gitad6fb3e.el7", "20151212.1", -1},
		{"1.20140522gitad6fb3e.el7", "2015.1.1", -1},
		{"1.20140522gitad6fb3e.el7", "2015.02.02", -1},
		{"1.20140522gitad6fb3e.el7", "2015.12.12", -1},
		{"1.20140522gitad6fb3e.el7", "1.2.3a", 1},
		{"1.20140522gitad6fb3e.el7", "1.2.3b", 1},
		{"1.20140522gitad6fb3e.el7", "R16B", 1},
		{"1.20140522gitad6fb3e.el7", "R16C", 1},
		{"1.20140522gitad6fb3e.el7", "1.2.3.2016.1.1", 1},
		{"1.20140522gitad6fb3e.el7", "0.5a1.dev", 1},
		{"1.20140522gitad6fb3e.el7", "1.8.B59BrZX", 1},
		{"1.20140522gitad6fb3e.el7", "0.07b4p1", 1},
		{"1.20140522gitad6fb3e.el7", "3.99.5final.SP07", -1},
		{"1.20140522gitad6fb3e.el7", "3.99.5final.SP08", -1},
		{"1.20140522gitad6fb3e.el7", "0.4.tbb.20100203", 1},
		{"1.20140522gitad6fb3e.el7", "0.5.20120830CVS.el7", 1},
		{"1.20140522gitad6fb3e.el7", "1.el7", 1},
		{"1.20140522gitad6fb3e.el7", "1.el6", 1},
		{"1.20140522gitad6fb3e.el7", "10.el7", -1},
		{"1.20140522gitad6fb3e.el7", "01.el7", 1},
		{"1.20140522gitad6fb3e.el7", "0.17.20140318svn632.el7", 1},
		{"1.20140522gitad6fb3e.el7", "0.17.20140318svn633.el7", 1},
		{"1.20140522gitad6fb3e.el7", "1.20140522gitad6fb3e.el7", 0},
		{"1.20140522gitad6fb3e.el7", "1.20140522hitad6fb3e.el7", -1},
		{"1.20140522gitad6fb3e.el7", "8.20140605hgacf1c26e3019.el7", -1},
		{"1.20140522gitad6fb3e.el7", "8.20140605hgacf1c26e3029.el7", -1},
		{"1.20140522gitad6fb3e.el7", "22.svn457.el7", -1},
		{"1.20140522gitad6fb3e.el7", "22.svn458.el7", -1},
		{"1.20140522gitad6fb3e.el7", "~", 1},
		{"1.20140522gitad6fb3e.el7", "~~", 1},
		{"1.20140522gitad6fb3e.el7", "~1", 1},
		{"1.20140522gitad6fb3e.el7", "~a", 1},
		{"1.20140522gitad6fb3e.el7", "1~", 1},
		{"1.20140522gitad6fb3e.el7", "2~", -1},
		{"1.20140522hitad6fb3e.el7", "", 1},
		{"1.20140522hitad6fb3e.el7", "0", 1},
		{"1.20140522hitad6fb3e.el7", "1", 1},
		{"1.20140522hitad6fb3e.el7", "2", -1},
		{"1.20140522hitad6fb3e.el7", "10", -1},
		{"1.20140522hitad6fb3e.el7", "100", -1},
		{"1.20140522hitad6fb3e.el7", "0.0", 1},
		{"1.20140522hitad6fb3e.el7", "0.1", 1},
		{"1.20140522hitad6fb3e.el7", "0.10", 1},
		{"1.20140522hitad6fb3e.el7", "0.99", 1},
		{"1.20140522hitad6fb3e.el7", "1.0", 1},
		{"1.20140522hitad6fb3e.el7", "1.99", 1},
		{"1.20140522hitad6fb3e.el7", "2.0", -1},
		{"1.20140522hitad6fb3e.el7", "0.0.0", 1},
		{"1.20140522hitad6fb3e.el7", "0.0.1", 1},
		{"1.20140522hitad6fb3e.el7", "0.0.2", 1},
		{"1.20140522hitad6fb3e.el7", "0.0.10", 1},
		{"1.20140522hitad6fb3e.el7", "0.0.99", 1},
		{"1.20140522hitad6fb3e.el7", "0.1.0", 1},
		{"1.20140522hitad6fb3e.el7", "0.2.0", 1},
		{"1.20140522hitad6fb3e.el7", "0.10.0", 1},
		{"1.20140522hitad6fb3e.el7", "0.99.0", 1},
		{"1.20140522hitad6fb3e.el7", "0.100.0", 1},
		{"1.20140522hitad6fb3e.el7", "0.0.0.0", 1},
		{"1.20140522hitad6fb3e.el7", "0.0.0.1", 1},
		{"1.20140522hitad6fb3e.el7", "0.0.0.10", 1},
		{"1.20140522hitad6fb3e.el7", "0.0.1.0", 1},
		{"1.20140522hitad6fb3e.el7", "0.0.01.0", 1},
		{"1.20140522hitad6fb3e.el7", "1.2.3.4", 1},
		{"1.20140522hitad6fb3e.el7", "1-2-3-4", 1},
		{"1.20140522hitad6fb3e.el7", "20150101", -1},
		{"1.20140522hitad6fb3e.el7", "20151212", -1},
		{"1.20140522hitad6fb3e.el7", "20151212.0", -1},
		{"1.20140522hitad6fb3e.el7", "20151212.1", -1},
		{"1.20140522hitad6fb3e.el7", "2015.1.1", -1},
		{"1.20140522hitad6fb3e.el7", "2015.02.02", -1},
		{"1.20140522hitad6fb3e.el7", "2015.12.12", -1},
		{"1.20140522hitad6fb3e.el7", "1.2.3a", 1},
		{"1.20140522hitad6fb3e.el7", "1.2.3b", 1},
		{"1.20140522hitad6fb3e.el7", "R16B", 1},
		{"1.20140522hitad6fb3e.el7", "R16C", 1},
		{"1.20140522hitad6fb3e.el7", "1.2.3.2016.1.1", 1},
		{"1.20140522hitad6fb3e.el7", "0.5a1.dev", 1},
		{"1.20140522hitad6fb3e.el7", "1.8.B59BrZX", 1},
		{"1.20140522hitad6fb3e.el7", "0.07b4p1", 1},
		{"1.20140522hitad6fb3e.el7", "3.99.5final.SP07", -1},
		{"1.20140522hitad6fb3e.el7", "3.99.5final.SP08", -1},
		{"1.20140522hitad6fb3e.el7", "0.4.tbb.20100203", 1},
		{"1.20140522hitad6fb3e.el7", "0.5.20120830CVS.el7", 1},
		{"1.20140522hitad6fb3e.el7", "1.el7", 1},
		{"1.20140522hitad6fb3e.el7", "1.el6", 1},
		{"1.20140522hitad6fb3e.el7", "10.el7", -1},
		{"1.20140522hitad6fb3e.el7", "01.el7", 1},
		{"1.20140522hitad6fb3e.el7", "0.17.20140318svn632.el7", 1},
		{"1.20140522hitad6fb3e.el7", "0.17.20140318svn633.el7", 1},
		{"1.20140522hitad6fb3e.el7", "1.20140522gitad6fb3e.el7", 1},
		{"1.20140522hitad6fb3e.el7", "1.20140522hitad6fb3e.el7", 0},
		{"1.20140522hitad6fb3e.el7", "8.20140605hgacf1c26e3019.el7", -1},
		{"1.20140522hitad6fb3e.el7", "8.20140605hgacf1c26e3029.el7", -1},
		{"1.20140522hitad6fb3e.el7", "22.svn457.el7", -1},
		{"1.20140522hitad6fb3e.el7", "22.svn458.el7", -1},
		{"1.20140522hitad6fb3e.el7", "~", 1},
		{"1.20140522hitad6fb3e.el7", "~~", 1},
		{"1.20140522hitad6fb3e.el7", "~1", 1},
		{"1.20140522hitad6fb3e.el7", "~a", 1},
		{"1.20140522hitad6fb3e.el7", "1~", 1},
		{"1.20140522hitad6fb3e.el7", "2~", -1},
		{"8.20140605hgacf1c26e3019.el7", "", 1},
		{"8.20140605hgacf1c26e3019.el7", "0", 1},
		{"8.20140605hgacf1c26e3019.el7", "1", 1},
		{"8.20140605hgacf1c26e3019.el7", "2", 1},
		{"8.20140605hgacf1c26e3019.el7", "10", -1},
		{"8.20140605hgacf1c26e3019.el7", "100", -1},
		{"8.20140605hgacf1c26e3019.el7", "0.0", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.1", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.10", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.99", 1},
		{"8.20140605hgacf1c26e3019.el7", "1.0", 1},
		{"8.20140605hgacf1c26e3019.el7", "1.99", 1},
		{"8.20140605hgacf1c26e3019.el7", "2.0", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.0.0", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.0.1", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.0.2", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.0.10", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.0.99", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.1.0", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.2.0", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.10.0", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.99.0", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.100.0", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.0.0.0", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.0.0.1", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.0.0.10", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.0.1.0", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.0.01.0", 1},
		{"8.20140605hgacf1c26e3019.el7", "1.2.3.4", 1},
		{"8.20140605hgacf1c26e3019.el7", "1-2-3-4", 1},
		{"8.20140605hgacf1c26e3019.el7", "20150101", -1},
		{"8.20140605hgacf1c26e3019.el7", "20151212", -1},
		{"8.20140605hgacf1c26e3019.el7", "20151212.0", -1},
		{"8.20140605hgacf1c26e3019.el7", "20151212.1", -1},
		{"8.20140605hgacf1c26e3019.el7", "2015.1.1", -1},
		{"8.20140605hgacf1c26e3019.el7", "2015.02.02", -1},
		{"8.20140605hgacf1c26e3019.el7", "2015.12.12", -1},
		{"8.20140605hgacf1c26e3019.el7", "1.2.3a", 1},
		{"8.20140605hgacf1c26e3019.el7", "1.2.3b", 1},
		{"8.20140605hgacf1c26e3019.el7", "R16B", 1},
		{"8.20140605hgacf1c26e3019.el7", "R16C", 1},
		{"8.20140605hgacf1c26e3019.el7", "1.2.3.2016.1.1", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.5a1.dev", 1},
		{"8.20140605hgacf1c26e3019.el7", "1.8.B59BrZX", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.07b4p1", 1},
		{"8.20140605hgacf1c26e3019.el7", "3.99.5final.SP07", 1},
		{"8.20140605hgacf1c26e3019.el7", "3.99.5final.SP08", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.4.tbb.20100203", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.5.20120830CVS.el7", 1},
		{"8.20140605hgacf1c26e3019.el7", "1.el7", 1},
		{"8.20140605hgacf1c26e3019.el7", "1.el6", 1},
		{"8.20140605hgacf1c26e3019.el7", "10.el7", -1},
		{"8.20140605hgacf1c26e3019.el7", "01.el7", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.17.20140318svn632.el7", 1},
		{"8.20140605hgacf1c26e3019.el7", "0.17.20140318svn633.el7", 1},
		{"8.20140605hgacf1c26e3019.el7", "1.20140522gitad6fb3e.el7", 1},
		{"8.20140605hgacf1c26e3019.el7", "1.20140522hitad6fb3e.el7", 1},
		{"8.20140605hgacf1c26e3019.el7", "8.20140605hgacf1c26e3019.el7", 0},
		{"8.20140605hgacf1c26e3019.el7", "8.20140605hgacf1c26e3029.el7", -1},
		{"8.20140605hgacf1c26e3019.el7", "22.svn457.el7", -1},
		{"8.20140605hgacf1c26e3019.el7", "22.svn458.el7", -1},
		{"8.20140605hgacf1c26e3019.el7", "~", 1},
		{"8.20140605hgacf1c26e3019.el7", "~~", 1},
		{"8.20140605hgacf1c26e3019.el7", "~1", 1},
		{"8.20140605hgacf1c26e3019.el7", "~a", 1},
		{"8.20140605hgacf1c26e3019.el7", "1~", 1},
		{"8.20140605hgacf1c26e3019.el7", "2~", 1},
		{"8.20140605hgacf1c26e3029.el7", "", 1},
		{"8.20140605hgacf1c26e3029.el7", "0", 1},
		{"8.20140605hgacf1c26e3029.el7", "1", 1},
		{"8.20140605hgacf1c26e3029.el7", "2", 1},
		{"8.20140605hgacf1c26e3029.el7", "10", -1},
		{"8.20140605hgacf1c26e3029.el7", "100", -1},
		{"8.20140605hgacf1c26e3029.el7", "0.0", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.1", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.10", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.99", 1},
		{"8.20140605hgacf1c26e3029.el7", "1.0", 1},
		{"8.20140605hgacf1c26e3029.el7", "1.99", 1},
		{"8.20140605hgacf1c26e3029.el7", "2.0", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.0.0", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.0.1", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.0.2", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.0.10", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.0.99", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.1.0", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.2.0", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.10.0", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.99.0", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.100.0", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.0.0.0", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.0.0.1", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.0.0.10", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.0.1.0", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.0.01.0", 1},
		{"8.20140605hgacf1c26e3029.el7", "1.2.3.4", 1},
		{"8.20140605hgacf1c26e3029.el7", "1-2-3-4", 1},
		{"8.20140605hgacf1c26e3029.el7", "20150101", -1},
		{"8.20140605hgacf1c26e3029.el7", "20151212", -1},
		{"8.20140605hgacf1c26e3029.el7", "20151212.0", -1},
		{"8.20140605hgacf1c26e3029.el7", "20151212.1", -1},
		{"8.20140605hgacf1c26e3029.el7", "2015.1.1", -1},
		{"8.20140605hgacf1c26e3029.el7", "2015.02.02", -1},
		{"8.20140605hgacf1c26e3029.el7", "2015.12.12", -1},
		{"8.20140605hgacf1c26e3029.el7", "1.2.3a", 1},
		{"8.20140605hgacf1c26e3029.el7", "1.2.3b", 1},
		{"8.20140605hgacf1c26e3029.el7", "R16B", 1},
		{"8.20140605hgacf1c26e3029.el7", "R16C", 1},
		{"8.20140605hgacf1c26e3029.el7", "1.2.3.2016.1.1", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.5a1.dev", 1},
		{"8.20140605hgacf1c26e3029.el7", "1.8.B59BrZX", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.07b4p1", 1},
		{"8.20140605hgacf1c26e3029.el7", "3.99.5final.SP07", 1},
		{"8.20140605hgacf1c26e3029.el7", "3.99.5final.SP08", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.4.tbb.20100203", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.5.20120830CVS.el7", 1},
		{"8.20140605hgacf1c26e3029.el7", "1.el7", 1},
		{"8.20140605hgacf1c26e3029.el7", "1.el6", 1},
		{"8.20140605hgacf1c26e3029.el7", "10.el7", -1},
		{"8.20140605hgacf1c26e3029.el7", "01.el7", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.17.20140318svn632.el7", 1},
		{"8.20140605hgacf1c26e3029.el7", "0.17.20140318svn633.el7", 1},
		{"8.20140605hgacf1c26e3029.el7", "1.20140522gitad6fb3e.el7", 1},
		{"8.20140605hgacf1c26e3029.el7", "1.20140522hitad6fb3e.el7", 1},
		{"8.20140605hgacf1c26e3029.el7", "8.20140605hgacf1c26e3019.el7", 1},
		{"8.20140605hgacf1c26e3029.el7", "8.20140605hgacf1c26e3029.el7", 0},
		{"8.20140605hgacf1c26e3029.el7", "22.svn457.el7", -1},
		{"8.20140605hgacf1c26e3029.el7", "22.svn458.el7", -1},
		{"8.20140605hgacf1c26e3029.el7", "~", 1},
		{"8.20140605hgacf1c26e3029.el7", "~~", 1},
		{"8.20140605hgacf1c26e3029.el7", "~1", 1},
		{"8.20140605hgacf1c26e3029.el7", "~a", 1},
		{"8.20140605hgacf1c26e3029.el7", "1~", 1},
		{"8.20140605hgacf1c26e3029.el7", "2~", 1},
		{"22.svn457.el7", "", 1},
		{"22.svn457.el7", "0", 1},
		{"22.svn457.el7", "1", 1},
		{"22.svn457.el7", "2", 1},
		{"22.svn457.el7", "10", 1},
		{"22.svn457.el7", "100", -1},
		{"22.svn457.el7", "0.0", 1},
		{"22.svn457.el7", "0.1", 1},
		{"22.svn457.el7", "0.10", 1},
		{"22.svn457.el7", "0.99", 1},
		{"22.svn457.el7", "1.0", 1},
		{"22.svn457.el7", "1.99", 1},
		{"22.svn457.el7", "2.0", 1},
		{"22.svn457.el7", "0.0.0", 1},
		{"22.svn457.el7", "0.0.1", 1},
		{"22.svn457.el7", "0.0.2", 1},
		{"22.svn457.el7", "0.0.10", 1},
		{"22.svn457.el7", "0.0.99", 1},
		{"22.svn457.el7", "0.1.0", 1},
		{"22.svn457.el7", "0.2.0", 1},
		{"22.svn457.el7", "0.10.0", 1},
		{"22.svn457.el7", "0.99.0", 1},
		{"22.svn457.el7", "0.100.0", 1},
		{"22.svn457.el7", "0.0.0.0", 1},
		{"22.svn457.el7", "0.0.0.1", 1},
		{"22.svn457.el7", "0.0.0.10", 1},
		{"22.svn457.el7", "0.0.1.0", 1},
		{"22.svn457.el7", "0.0.01.0", 1},
		{"22.svn457.el7", "1.2.3.4", 1},
		{"22.svn457.el7", "1-2-3-4", 1},
		{"22.svn457.el7", "20150101", -1},
		{"22.svn457.el7", "20151212", -1},
		{"22.svn457.el7", "20151212.0", -1},
		{"22.svn457.el7", "20151212.1", -1},
		{"22.svn457.el7", "2015.1.1", -1},
		{"22.svn457.el7", "2015.02.02", -1},
		{"22.svn457.el7", "2015.12.12", -1},
		{"22.svn457.el7", "1.2.3a", 1},
		{"22.svn457.el7", "1.2.3b", 1},
		{"22.svn457.el7", "R16B", 1},
		{"22.svn457.el7", "R16C", 1},
		{"22.svn457.el7", "1.2.3.2016.1.1", 1},
		{"22.svn457.el7", "0.5a1.dev", 1},
		{"22.svn457.el7", "1.8.B59BrZX", 1},
		{"22.svn457.el7", "0.07b4p1", 1},
		{"22.svn457.el7", "3.99.5final.SP07", 1},
		{"22.svn457.el7", "3.99.5final.SP08", 1},
		{"22.svn457.el7", "0.4.tbb.20100203", 1},
		{"22.svn457.el7", "0.5.20120830CVS.el7", 1},
		{"22.svn457.el7", "1.el7", 1},
		{"22.svn457.el7", "1.el6", 1},
		{"22.svn457.el7", "10.el7", 1},
		{"22.svn457.el7", "01.el7", 1},
		{"22.svn457.el7", "0.17.20140318svn632.el7", 1},
		{"22.svn457.el7", "0.17.20140318svn633.el7", 1},
		{"22.svn457.el7", "1.20140522gitad6fb3e.el7", 1},
		{"22.svn457.el7", "1.20140522hitad6fb3e.el7", 1},
		{"22.svn457.el7", "8.20140605hgacf1c26e3019.el7", 1},
		{"22.svn457.el7", "8.20140605hgacf1c26e3029.el7", 1},
		{"22.svn457.el7", "22.svn457.el7", 0},
		{"22.svn457.el7", "22.svn458.el7", -1},
		{"22.svn457.el7", "~", 1},
		{"22.svn457.el7", "~~", 1},
		{"22.svn457.el7", "~1", 1},
		{"22.svn457.el7", "~a", 1},
		{"22.svn457.el7", "1~", 1},
		{"22.svn457.el7", "2~", 1},
		{"22.svn458.el7", "", 1},
		{"22.svn458.el7", "0", 1},
		{"22.svn458.el7", "1", 1},
		{"22.svn458.el7", "2", 1},
		{"22.svn458.el7", "10", 1},
		{"22.svn458.el7", "100", -1},
		{"22.svn458.el7", "0.0", 1},
		{"22.svn458.el7", "0.1", 1},
		{"22.svn458.el7", "0.10", 1},
		{"22.svn458.el7", "0.99", 1},
		{"22.svn458.el7", "1.0", 1},
		{"22.svn458.el7", "1.99", 1},
		{"22.svn458.el7", "2.0", 1},
		{"22.svn458.el7", "0.0.0", 1},
		{"22.svn458.el7", "0.0.1", 1},
		{"22.svn458.el7", "0.0.2", 1},
		{"22.svn458.el7", "0.0.10", 1},
		{"22.svn458.el7", "0.0.99", 1},
		{"22.svn458.el7", "0.1.0", 1},
		{"22.svn458.el7", "0.2.0", 1},
		{"22.svn458.el7", "0.10.0", 1},
		{"22.svn458.el7", "0.99.0", 1},
		{"22.svn458.el7", "0.100.0", 1},
		{"22.svn458.el7", "0.0.0.0", 1},
		{"22.svn458.el7", "0.0.0.1", 1},
		{"22.svn458.el7", "0.0.0.10", 1},
		{"22.svn458.el7", "0.0.1.0", 1},
		{"22.svn458.el7", "0.0.01.0", 1},
		{"22.svn458.el7", "1.2.3.4", 1},
		{"22.svn458.el7", "1-2-3-4", 1},
		{"22.svn458.el7", "20150101", -1},
		{"22.svn458.el7", "20151212", -1},
		{"22.svn458.el7", "20151212.0", -1},
		{"22.svn458.el7", "20151212.1", -1},
		{"22.svn458.el7", "2015.1.1", -1},
		{"22.svn458.el7", "2015.02.02", -1},
		{"22.svn458.el7", "2015.12.12", -1},
		{"22.svn458.el7", "1.2.3a", 1},
		{"22.svn458.el7", "1.2.3b", 1},
		{"22.svn458.el7", "R16B", 1},
		{"22.svn458.el7", "R16C", 1},
		{"22.svn458.el7", "1.2.3.2016.1.1", 1},
		{"22.svn458.el7", "0.5a1.dev", 1},
		{"22.svn458.el7", "1.8.B59BrZX", 1},
		{"22.svn458.el7", "0.07b4p1", 1},
		{"22.svn458.el7", "3.99.5final.SP07", 1},
		{"22.svn458.el7", "3.99.5final.SP08", 1},
		{"22.svn458.el7", "0.4.tbb.20100203", 1},
		{"22.svn458.el7", "0.5.20120830CVS.el7", 1},
		{"22.svn458.el7", "1.el7", 1},
		{"22.svn458.el7", "1.el6", 1},
		{"22.svn458.el7", "10.el7", 1},
		{"22.svn458.el7", "01.el7", 1},
		{"22.svn458.el7", "0.17.20140318svn632.el7", 1},
		{"22.svn458.el7", "0.17.20140318svn633.el7", 1},
		{"22.svn458.el7", "1.20140522gitad6fb3e.el7", 1},
		{"22.svn458.el7", "1.20140522hitad6fb3e.el7", 1},
		{"22.svn458.el7", "8.20140605hgacf1c26e3019.el7", 1},
		{"22.svn458.el7", "8.20140605hgacf1c26e3029.el7", 1},
		{"22.svn458.el7", "22.svn457.el7", 1},
		{"22.svn458.el7", "22.svn458.el7", 0},
		{"22.svn458.el7", "~", 1},
		{"22.svn458.el7", "~~", 1},
		{"22.svn458.el7", "~1", 1},
		{"22.svn458.el7", "~a", 1},
		{"22.svn458.el7", "1~", 1},
		{"22.svn458.el7", "2~", 1},
		{"~", "", -1},
		{"~", "0", -1},
		{"~", "1", -1},
		{"~", "2", -1},
		{"~", "10", -1},
		{"~", "100", -1},
		{"~", "0.0", -1},
		{"~", "0.1", -1},
		{"~", "0.10", -1},
		{"~", "0.99", -1},
		{"~", "1.0", -1},
		{"~", "1.99", -1},
		{"~", "2.0", -1},
		{"~", "0.0.0", -1},
		{"~", "0.0.1", -1},
		{"~", "0.0.2", -1},
		{"~", "0.0.10", -1},
		{"~", "0.0.99", -1},
		{"~", "0.1.0", -1},
		{"~", "0.2.0", -1},
		{"~", "0.10.0", -1},
		{"~", "0.99.0", -1},
		{"~", "0.100.0", -1},
		{"~", "0.0.0.0", -1},
		{"~", "0.0.0.1", -1},
		{"~", "0.0.0.10", -1},
		{"~", "0.0.1.0", -1},
		{"~", "0.0.01.0", -1},
		{"~", "1.2.3.4", -1},
		{"~", "1-2-3-4", -1},
		{"~", "20150101", -1},
		{"~", "20151212", -1},
		{"~", "20151212.0", -1},
		{"~", "20151212.1", -1},
		{"~", "2015.1.1", -1},
		{"~", "2015.02.02", -1},
		{"~", "2015.12.12", -1},
		{"~", "1.2.3a", -1},
		{"~", "1.2.3b", -1},
		{"~", "R16B", -1},
		{"~", "R16C", -1},
		{"~", "1.2.3.2016.1.1", -1},
		{"~", "0.5a1.dev", -1},
		{"~", "1.8.B59BrZX", -1},
		{"~", "0.07b4p1", -1},
		{"~", "3.99.5final.SP07", -1},
		{"~", "3.99.5final.SP08", -1},
		{"~", "0.4.tbb.20100203", -1},
		{"~", "0.5.20120830CVS.el7", -1},
		{"~", "1.el7", -1},
		{"~", "1.el6", -1},
		{"~", "10.el7", -1},
		{"~", "01.el7", -1},
		{"~", "0.17.20140318svn632.el7", -1},
		{"~", "0.17.20140318svn633.el7", -1},
		{"~", "1.20140522gitad6fb3e.el7", -1},
		{"~", "1.20140522hitad6fb3e.el7", -1},
		{"~", "8.20140605hgacf1c26e3019.el7", -1},
		{"~", "8.20140605hgacf1c26e3029.el7", -1},
		{"~", "22.svn457.el7", -1},
		{"~", "22.svn458.el7", -1},
		{"~", "~", 0},
		{"~", "~~", 1},
		{"~", "~1", -1},
		{"~", "~a", -1},
		{"~", "1~", -1},
		{"~", "2~", -1},
		{"~~", "", -1},
		{"~~", "0", -1},
		{"~~", "1", -1},
		{"~~", "2", -1},
		{"~~", "10", -1},
		{"~~", "100", -1},
		{"~~", "0.0", -1},
		{"~~", "0.1", -1},
		{"~~", "0.10", -1},
		{"~~", "0.99", -1},
		{"~~", "1.0", -1},
		{"~~", "1.99", -1},
		{"~~", "2.0", -1},
		{"~~", "0.0.0", -1},
		{"~~", "0.0.1", -1},
		{"~~", "0.0.2", -1},
		{"~~", "0.0.10", -1},
		{"~~", "0.0.99", -1},
		{"~~", "0.1.0", -1},
		{"~~", "0.2.0", -1},
		{"~~", "0.10.0", -1},
		{"~~", "0.99.0", -1},
		{"~~", "0.100.0", -1},
		{"~~", "0.0.0.0", -1},
		{"~~", "0.0.0.1", -1},
		{"~~", "0.0.0.10", -1},
		{"~~", "0.0.1.0", -1},
		{"~~", "0.0.01.0", -1},
		{"~~", "1.2.3.4", -1},
		{"~~", "1-2-3-4", -1},
		{"~~", "20150101", -1},
		{"~~", "20151212", -1},
		{"~~", "20151212.0", -1},
		{"~~", "20151212.1", -1},
		{"~~", "2015.1.1", -1},
		{"~~", "2015.02.02", -1},
		{"~~", "2015.12.12", -1},
		{"~~", "1.2.3a", -1},
		{"~~", "1.2.3b", -1},
		{"~~", "R16B", -1},
		{"~~", "R16C", -1},
		{"~~", "1.2.3.2016.1.1", -1},
		{"~~", "0.5a1.dev", -1},
		{"~~", "1.8.B59BrZX", -1},
		{"~~", "0.07b4p1", -1},
		{"~~", "3.99.5final.SP07", -1},
		{"~~", "3.99.5final.SP08", -1},
		{"~~", "0.4.tbb.20100203", -1},
		{"~~", "0.5.20120830CVS.el7", -1},
		{"~~", "1.el7", -1},
		{"~~", "1.el6", -1},
		{"~~", "10.el7", -1},
		{"~~", "01.el7", -1},
		{"~~", "0.17.20140318svn632.el7", -1},
		{"~~", "0.17.20140318svn633.el7", -1},
		{"~~", "1.20140522gitad6fb3e.el7", -1},
		{"~~", "1.20140522hitad6fb3e.el7", -1},
		{"~~", "8.20140605hgacf1c26e3019.el7", -1},
		{"~~", "8.20140605hgacf1c26e3029.el7", -1},
		{"~~", "22.svn457.el7", -1},
		{"~~", "22.svn458.el7", -1},
		{"~~", "~", -1},
		{"~~", "~~", 0},
		{"~~", "~1", -1},
		{"~~", "~a", -1},
		{"~~", "1~", -1},
		{"~~", "2~", -1},
		{"~1", "", -1},
		{"~1", "0", -1},
		{"~1", "1", -1},
		{"~1", "2", -1},
		{"~1", "10", -1},
		{"~1", "100", -1},
		{"~1", "0.0", -1},
		{"~1", "0.1", -1},
		{"~1", "0.10", -1},
		{"~1", "0.99", -1},
		{"~1", "1.0", -1},
		{"~1", "1.99", -1},
		{"~1", "2.0", -1},
		{"~1", "0.0.0", -1},
		{"~1", "0.0.1", -1},
		{"~1", "0.0.2", -1},
		{"~1", "0.0.10", -1},
		{"~1", "0.0.99", -1},
		{"~1", "0.1.0", -1},
		{"~1", "0.2.0", -1},
		{"~1", "0.10.0", -1},
		{"~1", "0.99.0", -1},
		{"~1", "0.100.0", -1},
		{"~1", "0.0.0.0", -1},
		{"~1", "0.0.0.1", -1},
		{"~1", "0.0.0.10", -1},
		{"~1", "0.0.1.0", -1},
		{"~1", "0.0.01.0", -1},
		{"~1", "1.2.3.4", -1},
		{"~1", "1-2-3-4", -1},
		{"~1", "20150101", -1},
		{"~1", "20151212", -1},
		{"~1", "20151212.0", -1},
		{"~1", "20151212.1", -1},
		{"~1", "2015.1.1", -1},
		{"~1", "2015.02.02", -1},
		{"~1", "2015.12.12", -1},
		{"~1", "1.2.3a", -1},
		{"~1", "1.2.3b", -1},
		{"~1", "R16B", -1},
		{"~1", "R16C", -1},
		{"~1", "1.2.3.2016.1.1", -1},
		{"~1", "0.5a1.dev", -1},
		{"~1", "1.8.B59BrZX", -1},
		{"~1", "0.07b4p1", -1},
		{"~1", "3.99.5final.SP07", -1},
		{"~1", "3.99.5final.SP08", -1},
		{"~1", "0.4.tbb.20100203", -1},
		{"~1", "0.5.20120830CVS.el7", -1},
		{"~1", "1.el7", -1},
		{"~1", "1.el6", -1},
		{"~1", "10.el7", -1},
		{"~1", "01.el7", -1},
		{"~1", "0.17.20140318svn632.el7", -1},
		{"~1", "0.17.20140318svn633.el7", -1},
		{"~1", "1.20140522gitad6fb3e.el7", -1},
		{"~1", "1.20140522hitad6fb3e.el7", -1},
		{"~1", "8.20140605hgacf1c26e3019.el7", -1},
		{"~1", "8.20140605hgacf1c26e3029.el7", -1},
		{"~1", "22.svn457.el7", -1},
		{"~1", "22.svn458.el7", -1},
		{"~1", "~", 1},
		{"~1", "~~", 1},
		{"~1", "~1", 0},
		{"~1", "~a", 1},
		{"~1", "1~", -1},
		{"~1", "2~", -1},
		{"~a", "", -1},
		{"~a", "0", -1},
		{"~a", "1", -1},
		{"~a", "2", -1},
		{"~a", "10", -1},
		{"~a", "100", -1},
		{"~a", "0.0", -1},
		{"~a", "0.1", -1},
		{"~a", "0.10", -1},
		{"~a", "0.99", -1},
		{"~a", "1.0", -1},
		{"~a", "1.99", -1},
		{"~a", "2.0", -1},
		{"~a", "0.0.0", -1},
		{"~a", "0.0.1", -1},
		{"~a", "0.0.2", -1},
		{"~a", "0.0.10", -1},
		{"~a", "0.0.99", -1},
		{"~a", "0.1.0", -1},
		{"~a", "0.2.0", -1},
		{"~a", "0.10.0", -1},
		{"~a", "0.99.0", -1},
		{"~a", "0.100.0", -1},
		{"~a", "0.0.0.0", -1},
		{"~a", "0.0.0.1", -1},
		{"~a", "0.0.0.10", -1},
		{"~a", "0.0.1.0", -1},
		{"~a", "0.0.01.0", -1},
		{"~a", "1.2.3.4", -1},
		{"~a", "1-2-3-4", -1},
		{"~a", "20150101", -1},
		{"~a", "20151212", -1},
		{"~a", "20151212.0", -1},
		{"~a", "20151212.1", -1},
		{"~a", "2015.1.1", -1},
		{"~a", "2015.02.02", -1},
		{"~a", "2015.12.12", -1},
		{"~a", "1.2.3a", -1},
		{"~a", "1.2.3b", -1},
		{"~a", "R16B", -1},
		{"~a", "R16C", -1},
		{"~a", "1.2.3.2016.1.1", -1},
		{"~a", "0.5a1.dev", -1},
		{"~a", "1.8.B59BrZX", -1},
		{"~a", "0.07b4p1", -1},
		{"~a", "3.99.5final.SP07", -1},
		{"~a", "3.99.5final.SP08", -1},
		{"~a", "0.4.tbb.20100203", -1},
		{"~a", "0.5.20120830CVS.el7", -1},
		{"~a", "1.el7", -1},
		{"~a", "1.el6", -1},
		{"~a", "10.el7", -1},
		{"~a", "01.el7", -1},
		{"~a", "0.17.20140318svn632.el7", -1},
		{"~a", "0.17.20140318svn633.el7", -1},
		{"~a", "1.20140522gitad6fb3e.el7", -1},
		{"~a", "1.20140522hitad6fb3e.el7", -1},
		{"~a", "8.20140605hgacf1c26e3019.el7", -1},
		{"~a", "8.20140605hgacf1c26e3029.el7", -1},
		{"~a", "22.svn457.el7", -1},
		{"~a", "22.svn458.el7", -1},
		{"~a", "~", 1},
		{"~a", "~~", 1},
		{"~a", "~1", -1},
		{"~a", "~a", 0},
		{"~a", "1~", -1},
		{"~a", "2~", -1},
		{"1~", "", 1},
		{"1~", "0", 1},
		{"1~", "1", -1},
		{"1~", "2", -1},
		{"1~", "10", -1},
		{"1~", "100", -1},
		{"1~", "0.0", 1},
		{"1~", "0.1", 1},
		{"1~", "0.10", 1},
		{"1~", "0.99", 1},
		{"1~", "1.0", -1},
		{"1~", "1.99", -1},
		{"1~", "2.0", -1},
		{"1~", "0.0.0", 1},
		{"1~", "0.0.1", 1},
		{"1~", "0.0.2", 1},
		{"1~", "0.0.10", 1},
		{"1~", "0.0.99", 1},
		{"1~", "0.1.0", 1},
		{"1~", "0.2.0", 1},
		{"1~", "0.10.0", 1},
		{"1~", "0.99.0", 1},
		{"1~", "0.100.0", 1},
		{"1~", "0.0.0.0", 1},
		{"1~", "0.0.0.1", 1},
		{"1~", "0.0.0.10", 1},
		{"1~", "0.0.1.0", 1},
		{"1~", "0.0.01.0", 1},
		{"1~", "1.2.3.4", -1},
		{"1~", "1-2-3-4", -1},
		{"1~", "20150101", -1},
		{"1~", "20151212", -1},
		{"1~", "20151212.0", -1},
		{"1~", "20151212.1", -1},
		{"1~", "2015.1.1", -1},
		{"1~", "2015.02.02", -1},
		{"1~", "2015.12.12", -1},
		{"1~", "1.2.3a", -1},
		{"1~", "1.2.3b", -1},
		{"1~", "R16B", 1},
		{"1~", "R16C", 1},
		{"1~", "1.2.3.2016.1.1", -1},
		{"1~", "0.5a1.dev", 1},
		{"1~", "1.8.B59BrZX", -1},
		{"1~", "0.07b4p1", 1},
		{"1~", "3.99.5final.SP07", -1},
		{"1~", "3.99.5final.SP08", -1},
		{"1~", "0.4.tbb.20100203", 1},
		{"1~", "0.5.20120830CVS.el7", 1},
		{"1~", "1.el7", -1},
		{"1~", "1.el6", -1},
		{"1~", "10.el7", -1},
		{"1~", "01.el7", -1},
		{"1~", "0.17.20140318svn632.el7", 1},
		{"1~", "0.17.20140318svn633.el7", 1},
		{"1~", "1.20140522gitad6fb3e.el7", -1},
		{"1~", "1.20140522hitad6fb3e.el7", -1},
		{"1~", "8.20140605hgacf1c26e3019.el7", -1},
		{"1~", "8.20140605hgacf1c26e3029.el7", -1},
		{"1~", "22.svn457.el7", -1},
		{"1~", "22.svn458.el7", -1},
		{"1~", "~", 1},
		{"1~", "~~", 1},
		{"1~", "~1", 1},
		{"1~", "~a", 1},
		{"1~", "1~", 0},
		{"1~", "2~", -1},
		{"2~", "", 1},
		{"2~", "0", 1},
		{"2~", "1", 1},
		{"2~", "2", -1},
		{"2~", "10", -1},
		{"2~", "100", -1},
		{"2~", "0.0", 1},
		{"2~", "0.1", 1},
		{"2~", "0.10", 1},
		{"2~", "0.99", 1},
		{"2~", "1.0", 1},
		{"2~", "1.99", 1},
		{"2~", "2.0", -1},
		{"2~", "0.0.0", 1},
		{"2~", "0.0.1", 1},
		{"2~", "0.0.2", 1},
		{"2~", "0.0.10", 1},
		{"2~", "0.0.99", 1},
		{"2~", "0.1.0", 1},
		{"2~", "0.2.0", 1},
		{"2~", "0.10.0", 1},
		{"2~", "0.99.0", 1},
		{"2~", "0.100.0", 1},
		{"2~", "0.0.0.0", 1},
		{"2~", "0.0.0.1", 1},
		{"2~", "0.0.0.10", 1},
		{"2~", "0.0.1.0", 1},
		{"2~", "0.0.01.0", 1},
		{"2~", "1.2.3.4", 1},
		{"2~", "1-2-3-4", 1},
		{"2~", "20150101", -1},
		{"2~", "20151212", -1},
		{"2~", "20151212.0", -1},
		{"2~", "20151212.1", -1},
		{"2~", "2015.1.1", -1},
		{"2~", "2015.02.02", -1},
		{"2~", "2015.12.12", -1},
		{"2~", "1.2.3a", 1},
		{"2~", "1.2.3b", 1},
		{"2~", "R16B", 1},
		{"2~", "R16C", 1},
		{"2~", "1.2.3.2016.1.1", 1},
		{"2~", "0.5a1.dev", 1},
		{"2~", "1.8.B59BrZX", 1},
		{"2~", "0.07b4p1", 1},
		{"2~", "3.99.5final.SP07", -1},
		{"2~", "3.99.5final.SP08", -1},
		{"2~", "0.4.tbb.20100203", 1},
		{"2~", "0.5.20120830CVS.el7", 1},
		{"2~", "1.el7", 1},
		{"2~", "1.el6", 1},
		{"2~", "10.el7", -1},
		{"2~", "01.el7", 1},
		{"2~", "0.17.20140318svn632.el7", 1},
		{"2~", "0.17.20140318svn633.el7", 1},
		{"2~", "1.20140522gitad6fb3e.el7", 1},
		{"2~", "1.20140522hitad6fb3e.el7", 1},
		{"2~", "8.20140605hgacf1c26e3019.el7", -1},
		{"2~", "8.20140605hgacf1c26e3029.el7", -1},
		{"2~", "22.svn457.el7", -1},
		{"2~", "22.svn458.el7", -1},
		{"2~", "~", 1},
		{"2~", "~~", 1},
		{"2~", "~1", 1},
		{"2~", "~a", 1},
		{"2~", "1~", 1},
		{"2~", "2~", 0},
	}

	errCount := 0
	for _, test := range tests {
		// compare 'version'
		a := &TestPkg{0, test.A, ""}
		b := &TestPkg{0, test.B, ""}
		if r := Compare(a, b); r != test.R {
			errCount++
			t.Errorf("Expected %s %s %s; got %s %s %s", test.A, sign(test.R), test.B, test.A, sign(r), test.B)
		}

		// compare 'release'
		a = &TestPkg{0, "", test.A}
		b = &TestPkg{0, "", test.B}
		if r := Compare(a, b); r != test.R {
			errCount++
			t.Errorf("Expected %s %s %s; got %s %s %s", test.A, sign(test.R), test.B, test.A, sign(r), test.B)
		}
	}

	// compare nil
	if r := Compare(nil, nil); r != 0 {
		t.Errorf("Expected <nil> == <nil>; got <nil> %s <nil>", sign(r))
	}

	if r := Compare(nil, &TestPkg{1, "", ""}); r != -1 {
		t.Errorf("Expected <nil> < <nil>; got <nil> %s <nil>", sign(r))
	}

	if r := Compare(&TestPkg{1, "", ""}, nil); r != 1 {
		t.Errorf("Expected <nil> > <nil>; got <nil> %s <nil>", sign(r))
	}

	// log stats
	if errCount > 0 {
		t.Errorf("%d/%d version compare errors", errCount, len(tests))
	} else {
		t.Logf("%d version comparisons validated", len(tests))
	}
}
