// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Application Dependency Management API
//
// Use the Application Dependency Management API to create knowledge bases and vulnerability audits.  For more information, see ADM (https://docs.cloud.oracle.com/Content/application-dependency-management/home.htm).
//

package adm

import (
	"strings"
)

// VulnerabilitySeverityEnum Enum with underlying type: string
type VulnerabilitySeverityEnum string

// Set of constants representing the allowable values for VulnerabilitySeverityEnum
const (
	VulnerabilitySeverityNone     VulnerabilitySeverityEnum = "NONE"
	VulnerabilitySeverityLow      VulnerabilitySeverityEnum = "LOW"
	VulnerabilitySeverityMedium   VulnerabilitySeverityEnum = "MEDIUM"
	VulnerabilitySeverityHigh     VulnerabilitySeverityEnum = "HIGH"
	VulnerabilitySeverityCritical VulnerabilitySeverityEnum = "CRITICAL"
)

var mappingVulnerabilitySeverityEnum = map[string]VulnerabilitySeverityEnum{
	"NONE":     VulnerabilitySeverityNone,
	"LOW":      VulnerabilitySeverityLow,
	"MEDIUM":   VulnerabilitySeverityMedium,
	"HIGH":     VulnerabilitySeverityHigh,
	"CRITICAL": VulnerabilitySeverityCritical,
}

var mappingVulnerabilitySeverityEnumLowerCase = map[string]VulnerabilitySeverityEnum{
	"none":     VulnerabilitySeverityNone,
	"low":      VulnerabilitySeverityLow,
	"medium":   VulnerabilitySeverityMedium,
	"high":     VulnerabilitySeverityHigh,
	"critical": VulnerabilitySeverityCritical,
}

// GetVulnerabilitySeverityEnumValues Enumerates the set of values for VulnerabilitySeverityEnum
func GetVulnerabilitySeverityEnumValues() []VulnerabilitySeverityEnum {
	values := make([]VulnerabilitySeverityEnum, 0)
	for _, v := range mappingVulnerabilitySeverityEnum {
		values = append(values, v)
	}
	return values
}

// GetVulnerabilitySeverityEnumStringValues Enumerates the set of values in String for VulnerabilitySeverityEnum
func GetVulnerabilitySeverityEnumStringValues() []string {
	return []string{
		"NONE",
		"LOW",
		"MEDIUM",
		"HIGH",
		"CRITICAL",
	}
}

// GetMappingVulnerabilitySeverityEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingVulnerabilitySeverityEnum(val string) (VulnerabilitySeverityEnum, bool) {
	enum, ok := mappingVulnerabilitySeverityEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
