// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Database Service API
//
// The API for the Database Service. Use this API to manage resources such as databases and DB Systems. For more information, see Overview of the Database Service (https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/databaseoverview.htm).
//

package database

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// AppVersionSummary The version details specific to an app.
type AppVersionSummary struct {

	// The Autonomous Container Database version release date.
	ReleaseDate *string `mandatory:"true" json:"releaseDate"`

	// The Autonomous Container Database version end of support date.
	EndOfSupport *string `mandatory:"true" json:"endOfSupport"`

	// The name of the supported application.
	SupportedAppName *string `mandatory:"true" json:"supportedAppName"`

	// Indicates if the image is certified.
	IsCertified *bool `mandatory:"true" json:"isCertified"`
}

func (m AppVersionSummary) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m AppVersionSummary) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
