// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.cloud.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// HostCisBenchmarkScanResultSortByEnum Enum with underlying type: string
type HostCisBenchmarkScanResultSortByEnum string

// Set of constants representing the allowable values for HostCisBenchmarkScanResultSortByEnum
const (
	HostCisBenchmarkScanResultSortByTimeStarted                 HostCisBenchmarkScanResultSortByEnum = "timeStarted"
	HostCisBenchmarkScanResultSortByTimeFinished                HostCisBenchmarkScanResultSortByEnum = "timeFinished"
	HostCisBenchmarkScanResultSortByCisBenchmarkScanIssuesCount HostCisBenchmarkScanResultSortByEnum = "cisBenchmarkScanIssuesCount"
)

var mappingHostCisBenchmarkScanResultSortByEnum = map[string]HostCisBenchmarkScanResultSortByEnum{
	"timeStarted":                 HostCisBenchmarkScanResultSortByTimeStarted,
	"timeFinished":                HostCisBenchmarkScanResultSortByTimeFinished,
	"cisBenchmarkScanIssuesCount": HostCisBenchmarkScanResultSortByCisBenchmarkScanIssuesCount,
}

var mappingHostCisBenchmarkScanResultSortByEnumLowerCase = map[string]HostCisBenchmarkScanResultSortByEnum{
	"timestarted":                 HostCisBenchmarkScanResultSortByTimeStarted,
	"timefinished":                HostCisBenchmarkScanResultSortByTimeFinished,
	"cisbenchmarkscanissuescount": HostCisBenchmarkScanResultSortByCisBenchmarkScanIssuesCount,
}

// GetHostCisBenchmarkScanResultSortByEnumValues Enumerates the set of values for HostCisBenchmarkScanResultSortByEnum
func GetHostCisBenchmarkScanResultSortByEnumValues() []HostCisBenchmarkScanResultSortByEnum {
	values := make([]HostCisBenchmarkScanResultSortByEnum, 0)
	for _, v := range mappingHostCisBenchmarkScanResultSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetHostCisBenchmarkScanResultSortByEnumStringValues Enumerates the set of values in String for HostCisBenchmarkScanResultSortByEnum
func GetHostCisBenchmarkScanResultSortByEnumStringValues() []string {
	return []string{
		"timeStarted",
		"timeFinished",
		"cisBenchmarkScanIssuesCount",
	}
}

// GetMappingHostCisBenchmarkScanResultSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingHostCisBenchmarkScanResultSortByEnum(val string) (HostCisBenchmarkScanResultSortByEnum, bool) {
	enum, ok := mappingHostCisBenchmarkScanResultSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
