// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.cloud.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// VendorTypeEnum Enum with underlying type: string
type VendorTypeEnum string

// Set of constants representing the allowable values for VendorTypeEnum
const (
	VendorTypeOci    VendorTypeEnum = "OCI"
	VendorTypeQualys VendorTypeEnum = "QUALYS"
)

var mappingVendorTypeEnum = map[string]VendorTypeEnum{
	"OCI":    VendorTypeOci,
	"QUALYS": VendorTypeQualys,
}

var mappingVendorTypeEnumLowerCase = map[string]VendorTypeEnum{
	"oci":    VendorTypeOci,
	"qualys": VendorTypeQualys,
}

// GetVendorTypeEnumValues Enumerates the set of values for VendorTypeEnum
func GetVendorTypeEnumValues() []VendorTypeEnum {
	values := make([]VendorTypeEnum, 0)
	for _, v := range mappingVendorTypeEnum {
		values = append(values, v)
	}
	return values
}

// GetVendorTypeEnumStringValues Enumerates the set of values in String for VendorTypeEnum
func GetVendorTypeEnumStringValues() []string {
	return []string{
		"OCI",
		"QUALYS",
	}
}

// GetMappingVendorTypeEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingVendorTypeEnum(val string) (VendorTypeEnum, bool) {
	enum, ok := mappingVendorTypeEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
