// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package taxsettingsiface provides an interface to enable mocking the Tax Settings service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package taxsettingsiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/taxsettings"
)

// TaxSettingsAPI provides an interface to enable mocking the
// taxsettings.TaxSettings service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Tax Settings.
//	func myFunc(svc taxsettingsiface.TaxSettingsAPI) bool {
//	    // Make svc.BatchDeleteTaxRegistration request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := taxsettings.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockTaxSettingsClient struct {
//	    taxsettingsiface.TaxSettingsAPI
//	}
//	func (m *mockTaxSettingsClient) BatchDeleteTaxRegistration(input *taxsettings.BatchDeleteTaxRegistrationInput) (*taxsettings.BatchDeleteTaxRegistrationOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockTaxSettingsClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type TaxSettingsAPI interface {
	BatchDeleteTaxRegistration(*taxsettings.BatchDeleteTaxRegistrationInput) (*taxsettings.BatchDeleteTaxRegistrationOutput, error)
	BatchDeleteTaxRegistrationWithContext(aws.Context, *taxsettings.BatchDeleteTaxRegistrationInput, ...request.Option) (*taxsettings.BatchDeleteTaxRegistrationOutput, error)
	BatchDeleteTaxRegistrationRequest(*taxsettings.BatchDeleteTaxRegistrationInput) (*request.Request, *taxsettings.BatchDeleteTaxRegistrationOutput)

	BatchPutTaxRegistration(*taxsettings.BatchPutTaxRegistrationInput) (*taxsettings.BatchPutTaxRegistrationOutput, error)
	BatchPutTaxRegistrationWithContext(aws.Context, *taxsettings.BatchPutTaxRegistrationInput, ...request.Option) (*taxsettings.BatchPutTaxRegistrationOutput, error)
	BatchPutTaxRegistrationRequest(*taxsettings.BatchPutTaxRegistrationInput) (*request.Request, *taxsettings.BatchPutTaxRegistrationOutput)

	DeleteTaxRegistration(*taxsettings.DeleteTaxRegistrationInput) (*taxsettings.DeleteTaxRegistrationOutput, error)
	DeleteTaxRegistrationWithContext(aws.Context, *taxsettings.DeleteTaxRegistrationInput, ...request.Option) (*taxsettings.DeleteTaxRegistrationOutput, error)
	DeleteTaxRegistrationRequest(*taxsettings.DeleteTaxRegistrationInput) (*request.Request, *taxsettings.DeleteTaxRegistrationOutput)

	GetTaxRegistration(*taxsettings.GetTaxRegistrationInput) (*taxsettings.GetTaxRegistrationOutput, error)
	GetTaxRegistrationWithContext(aws.Context, *taxsettings.GetTaxRegistrationInput, ...request.Option) (*taxsettings.GetTaxRegistrationOutput, error)
	GetTaxRegistrationRequest(*taxsettings.GetTaxRegistrationInput) (*request.Request, *taxsettings.GetTaxRegistrationOutput)

	GetTaxRegistrationDocument(*taxsettings.GetTaxRegistrationDocumentInput) (*taxsettings.GetTaxRegistrationDocumentOutput, error)
	GetTaxRegistrationDocumentWithContext(aws.Context, *taxsettings.GetTaxRegistrationDocumentInput, ...request.Option) (*taxsettings.GetTaxRegistrationDocumentOutput, error)
	GetTaxRegistrationDocumentRequest(*taxsettings.GetTaxRegistrationDocumentInput) (*request.Request, *taxsettings.GetTaxRegistrationDocumentOutput)

	ListTaxRegistrations(*taxsettings.ListTaxRegistrationsInput) (*taxsettings.ListTaxRegistrationsOutput, error)
	ListTaxRegistrationsWithContext(aws.Context, *taxsettings.ListTaxRegistrationsInput, ...request.Option) (*taxsettings.ListTaxRegistrationsOutput, error)
	ListTaxRegistrationsRequest(*taxsettings.ListTaxRegistrationsInput) (*request.Request, *taxsettings.ListTaxRegistrationsOutput)

	ListTaxRegistrationsPages(*taxsettings.ListTaxRegistrationsInput, func(*taxsettings.ListTaxRegistrationsOutput, bool) bool) error
	ListTaxRegistrationsPagesWithContext(aws.Context, *taxsettings.ListTaxRegistrationsInput, func(*taxsettings.ListTaxRegistrationsOutput, bool) bool, ...request.Option) error

	PutTaxRegistration(*taxsettings.PutTaxRegistrationInput) (*taxsettings.PutTaxRegistrationOutput, error)
	PutTaxRegistrationWithContext(aws.Context, *taxsettings.PutTaxRegistrationInput, ...request.Option) (*taxsettings.PutTaxRegistrationOutput, error)
	PutTaxRegistrationRequest(*taxsettings.PutTaxRegistrationInput) (*request.Request, *taxsettings.PutTaxRegistrationOutput)
}

var _ TaxSettingsAPI = (*taxsettings.TaxSettings)(nil)
