/**
 * @file monstdat.cpp
 *
 * Implementation of all monster data.
 */
#include "monstdat.h"

#include <cstdint>

#include "items.h"
#include "monster.h"
#include "textdat.h"
#include "utils/language.h"

namespace devilution {

namespace {

// Returns a `treasure` value for the given item.
constexpr uint16_t Uniq(_unique_items item)
{
	return static_cast<uint16_t>(T_UNIQ) + item;
}

} // namespace

/** Contains the data related to each monster ID. */
const MonsterData MonstersData[] = {
	// clang-format off
// _monster_id     name,                                     assetsSuffix,       soundSuffix,      trnFile,             availability,                 width,  image, hasSpecial,  hasSpecialSound,  frames[6],                  rate[6],               minDunLvl,  maxDunLvl,  level,  hitPointsMinimum,  hitPointsMaximum, ai,                          abilityFlags,                                          intelligence,  toHit,  animFrameNum,  minDamage,  maxDamage,  toHitSpecial,  animFrameNumSpecial,  minDamageSpecial,  maxDamageSpecial,  armorClass, monsterClass,         resistance,                                                  resistanceHell,                                               selectionType, treasure,              exp

// TRANSLATORS: Monster Block start
/* MT_NZOMBIE */ { P_("monster", "Zombie"),                  "zombie\\zombie",   nullptr,          nullptr,             MonsterAvailability::Always,    128,    799, false,       false,            { 11, 24, 12,  6, 16,  0 }, { 4, 1, 1, 1, 1, 1 },          1,          2,      1,                 4,                 7, MonsterAIID::Zombie,         0,                                                                0,     10,             8,          2,          5,             0,                    0,                 0,                 0,           5, MonsterClass::Undead, IMMUNE_MAGIC,                                                IMMUNE_MAGIC,                                                             3, 0,                      54 },
/* MT_BZOMBIE */ { P_("monster", "Ghoul"),                   "zombie\\zombie",   nullptr,          "zombie\\bluered",   MonsterAvailability::Always,    128,    799, false,       false,            { 11, 24, 12,  6, 16,  0 }, { 4, 1, 1, 1, 1, 1 },          2,          3,      2,                 7,                11, MonsterAIID::Zombie,         0,                                                                1,     10,             8,          3,         10,             0,                    0,                 0,                 0,          10, MonsterClass::Undead, IMMUNE_MAGIC,                                                IMMUNE_MAGIC,                                                             3, 0,                      58 },
/* MT_GZOMBIE */ { P_("monster", "Rotting Carcass"),         "zombie\\zombie",   nullptr,          "zombie\\grey",      MonsterAvailability::Always,    128,    799, false,       false,            { 11, 24, 12,  6, 16,  0 }, { 4, 1, 1, 1, 1, 1 },          2,          4,      4,                15,                25, MonsterAIID::Zombie,         0,                                                                2,     25,             8,          5,         15,             0,                    0,                 0,                 0,          15, MonsterClass::Undead, IMMUNE_MAGIC,                                                IMMUNE_MAGIC | RESIST_FIRE,                                               3, 0,                     136 },
/* MT_YZOMBIE */ { P_("monster", "Black Death"),             "zombie\\zombie",   nullptr,          "zombie\\yellow",    MonsterAvailability::Always,    128,    799, false,       false,            { 11, 24, 12,  6, 16,  0 }, { 4, 1, 1, 1, 1, 1 },          3,          5,      6,                25,                40, MonsterAIID::Zombie,         0,                                                                3,     30,             8,          6,         22,             0,                    0,                 0,                 0,          20, MonsterClass::Undead, IMMUNE_MAGIC,                                                IMMUNE_MAGIC |               RESIST_LIGHTNING,                            3, 0,                     240 },
/* MT_RFALLSP */ { P_("monster", "Fallen One"),              "falspear\\phall",  nullptr,          "falspear\\fallent", MonsterAvailability::Always,    128,    543, true,        true,             { 11, 11, 13, 11, 18, 13 }, { 3, 1, 1, 1, 1, 1 },          1,          2,      1,                 1,                 4, MonsterAIID::Fallen,         0,                                                                0,     15,             7,          1,          3,             0,                    5,                 0,                 0,           0, MonsterClass::Animal, 0,                                                           0,                                                                        3, 0,                      46 },
/* MT_DFALLSP */ { P_("monster", "Carver"),                  "falspear\\phall",  nullptr,          "falspear\\dark",    MonsterAvailability::Always,    128,    543, true,        true,             { 11, 11, 13, 11, 18, 13 }, { 3, 1, 1, 1, 1, 1 },          2,          3,      3,                 4,                 8, MonsterAIID::Fallen,         0,                                                                2,     20,             7,          2,          5,             0,                    5,                 0,                 0,           5, MonsterClass::Animal, 0,                                                           0,                                                                        3, 0,                      80 },
/* MT_YFALLSP */ { P_("monster", "Devil Kin"),               "falspear\\phall",  nullptr,          nullptr,             MonsterAvailability::Always,    128,    543, true,        true,             { 11, 11, 13, 11, 18, 13 }, { 3, 1, 1, 1, 1, 1 },          2,          4,      5,                12,                24, MonsterAIID::Fallen,         0,                                                                2,     25,             7,          3,          7,             0,                    5,                 0,                 0,          10, MonsterClass::Animal, 0,                                                           RESIST_FIRE,                                                              3, 0,                     155 },
/* MT_BFALLSP */ { P_("monster", "Dark One"),                "falspear\\phall",  nullptr,          "falspear\\blue",    MonsterAvailability::Always,    128,    543, true,        true,             { 11, 11, 13, 11, 18, 13 }, { 3, 1, 1, 1, 1, 1 },          3,          5,      7,                20,                36, MonsterAIID::Fallen,         0,                                                                3,     30,             7,          4,          8,             0,                    5,                 0,                 0,          15, MonsterClass::Animal, 0,                                                           RESIST_LIGHTNING,                                                         3, 0,                     255 },
/* MT_WSKELAX */ { P_("monster", "Skeleton"),                "skelaxe\\sklax",   nullptr,          "skelaxe\\white",    MonsterAvailability::Always,    128,    553, true,        false,            { 12,  8, 13,  6, 17, 16 }, { 5, 1, 1, 1, 1, 1 },          1,          2,      1,                 2,                 4, MonsterAIID::SkeletonMelee,  0,                                                                0,     20,             8,          1,          4,             0,                    0,                 0,                 0,           0, MonsterClass::Undead, IMMUNE_MAGIC,                                                IMMUNE_MAGIC,                                                             3, 0,                      64 },
/* MT_TSKELAX */ { P_("monster", "Corpse Axe"),              "skelaxe\\sklax",   nullptr,          "skelaxe\\skelt",    MonsterAvailability::Always,    128,    553, true,        false,            { 12,  8, 13,  6, 17, 16 }, { 4, 1, 1, 1, 1, 1 },          2,          3,      2,                 4,                 7, MonsterAIID::SkeletonMelee,  0,                                                                1,     25,             8,          3,          5,             0,                    0,                 0,                 0,           0, MonsterClass::Undead, IMMUNE_MAGIC,                                                IMMUNE_MAGIC,                                                             3, 0,                      68 },
/* MT_RSKELAX */ { P_("monster", "Burning Dead"),            "skelaxe\\sklax",   nullptr,          nullptr,             MonsterAvailability::Always,    128,    553, true,        false,            { 12,  8, 13,  6, 17, 16 }, { 2, 1, 1, 1, 1, 1 },          2,          4,      4,                 8,                12, MonsterAIID::SkeletonMelee,  0,                                                                2,     30,             8,          3,          7,             0,                    0,                 0,                 0,           5, MonsterClass::Undead, IMMUNE_MAGIC | RESIST_FIRE,                                  IMMUNE_MAGIC | IMMUNE_FIRE,                                               3, 0,                     154 },
/* MT_XSKELAX */ { P_("monster", "Horror"),                  "skelaxe\\sklax",   nullptr,          "skelaxe\\black",    MonsterAvailability::Always,    128,    553, true,        false,            { 12,  8, 13,  6, 17, 16 }, { 3, 1, 1, 1, 1, 1 },          3,          5,      6,                12,                20, MonsterAIID::SkeletonMelee,  0,                                                                3,     35,             8,          4,          9,             0,                    0,                 0,                 0,          15, MonsterClass::Undead, IMMUNE_MAGIC |               RESIST_LIGHTNING,               IMMUNE_MAGIC |               RESIST_LIGHTNING,                            3, 0,                     264 },
/* MT_RFALLSD */ { P_("monster", "Fallen One"),              "falsword\\fall",   nullptr,          "falsword\\fallent", MonsterAvailability::Always,    128,    623, true,        true,             { 12, 12, 13, 11, 14, 15 }, { 3, 1, 1, 1, 1, 1 },          1,          2,      1,                 2,                 5, MonsterAIID::Fallen,         0,                                                                0,     15,             8,          1,          4,             0,                    5,                 0,                 0,          10, MonsterClass::Animal, 0,                                                           0,                                                                        3, 0,                      52 },
/* MT_DFALLSD */ { P_("monster", "Carver"),                  "falsword\\fall",   nullptr,          "falsword\\dark",    MonsterAvailability::Always,    128,    623, true,        true,             { 12, 12, 13, 11, 14, 15 }, { 3, 1, 1, 1, 1, 1 },          2,          3,      3,                 5,                 9, MonsterAIID::Fallen,         0,                                                                1,     20,             8,          2,          7,             0,                    5,                 0,                 0,          15, MonsterClass::Animal, 0,                                                           0,                                                                        3, 0,                      90 },
/* MT_YFALLSD */ { P_("monster", "Devil Kin"),               "falsword\\fall",   nullptr,          nullptr,             MonsterAvailability::Always,    128,    623, true,        true,             { 12, 12, 13, 11, 14, 15 }, { 3, 1, 1, 1, 1, 1 },          2,          4,      5,                16,                24, MonsterAIID::Fallen,         0,                                                                2,     25,             8,          4,         10,             0,                    5,                 0,                 0,          20, MonsterClass::Animal, 0,                                                           RESIST_FIRE,                                                              3, 0,                     180 },
/* MT_BFALLSD */ { P_("monster", "Dark One"),                "falsword\\fall",   nullptr,          "falsword\\blue",    MonsterAvailability::Always,    128,    623, true,        true,             { 12, 12, 13, 11, 14, 15 }, { 3, 1, 1, 1, 1, 1 },          3,          5,      7,                24,                36, MonsterAIID::Fallen,         0,                                                                3,     30,             8,          4,         12,             0,                    5,                 0,                 0,          25, MonsterClass::Animal, 0,                                                           RESIST_LIGHTNING,                                                         3, 0,                     280 },
/* MT_NSCAV   */ { P_("monster", "Scavenger"),               "scav\\scav",       nullptr,          nullptr,             MonsterAvailability::Always,    128,    410, true,        false,            { 12,  8, 12,  6, 20, 11 }, { 2, 1, 1, 1, 1, 1 },          1,          3,      2,                 3,                 6, MonsterAIID::Scavenger,      0,                                                                0,     20,             7,          1,          5,             0,                    0,                 0,                 0,          10, MonsterClass::Animal, 0,                                                           RESIST_FIRE,                                                              3, 0,                      80 },
/* MT_BSCAV   */ { P_("monster", "Plague Eater"),            "scav\\scav",       nullptr,          "scav\\scavbr",      MonsterAvailability::Always,    128,    410, true,        false,            { 12,  8, 12,  6, 20, 11 }, { 2, 1, 1, 1, 1, 1 },          2,          4,      4,                12,                24, MonsterAIID::Scavenger,      0,                                                                1,     30,             7,          1,          8,             0,                    0,                 0,                 0,          20, MonsterClass::Animal, 0,                                                           RESIST_LIGHTNING,                                                         3, 0,                     188 },
/* MT_WSCAV   */ { P_("monster", "Shadow Beast"),            "scav\\scav",       nullptr,          "scav\\scavbe",      MonsterAvailability::Always,    128,    410, true,        false,            { 12,  8, 12,  6, 20, 11 }, { 2, 1, 1, 1, 1, 1 },          3,          5,      6,                24,                36, MonsterAIID::Scavenger,      0,                                                                2,     35,             7,          3,         12,             0,                    0,                 0,                 0,          25, MonsterClass::Animal, 0,                                                           RESIST_FIRE,                                                              3, 0,                     375 },
/* MT_YSCAV   */ { P_("monster", "Bone Gasher"),             "scav\\scav",       nullptr,          "scav\\scavw",       MonsterAvailability::Always,    128,    410, true,        false,            { 12,  8, 12,  6, 20, 11 }, { 2, 1, 1, 1, 1, 1 },          4,          6,      8,                28,                40, MonsterAIID::Scavenger,      0,                                                                3,     35,             7,          5,         15,             0,                    0,                 0,                 0,          30, MonsterClass::Animal, RESIST_MAGIC,                                                RESIST_LIGHTNING,                                                         3, 0,                     552 },
/* MT_WSKELBW */ { P_("monster", "Skeleton"),                "skelbow\\sklbw",   nullptr,          "skelbow\\white",    MonsterAvailability::Always,    128,    567, true,        false,            {  9,  8, 16,  5, 16, 16 }, { 4, 1, 1, 1, 1, 1 },          2,          3,      3,                 2,                 4, MonsterAIID::SkeletonRanged, 0,                                                                0,     15,            12,          1,          2,             0,                    0,                 0,                 0,           0, MonsterClass::Undead, IMMUNE_MAGIC,                                                IMMUNE_MAGIC,                                                             3, 0,                     110 },
/* MT_TSKELBW */ { P_("monster", "Corpse Bow"),              "skelbow\\sklbw",   nullptr,          "skelbow\\skelt",    MonsterAvailability::Always,    128,    567, true,        false,            {  9,  8, 16,  5, 16, 16 }, { 4, 1, 1, 1, 1, 1 },          2,          4,      5,                 8,                16, MonsterAIID::SkeletonRanged, 0,                                                                1,     25,            12,          1,          4,             0,                    0,                 0,                 0,           0, MonsterClass::Undead, IMMUNE_MAGIC,                                                IMMUNE_MAGIC,                                                             3, 0,                     210 },
/* MT_RSKELBW */ { P_("monster", "Burning Dead"),            "skelbow\\sklbw",   nullptr,          nullptr,             MonsterAvailability::Always,    128,    567, true,        false,            {  9,  8, 16,  5, 16, 16 }, { 2, 1, 1, 1, 1, 1 },          3,          5,      7,                10,                24, MonsterAIID::SkeletonRanged, 0,                                                                2,     30,            12,          1,          6,             0,                    0,                 0,                 0,           5, MonsterClass::Undead, IMMUNE_MAGIC | RESIST_FIRE,                                  IMMUNE_MAGIC | IMMUNE_FIRE,                                               3, 0,                     364 },
/* MT_XSKELBW */ { P_("monster", "Horror"),                  "skelbow\\sklbw",   nullptr,          "skelbow\\black",    MonsterAvailability::Always,    128,    567, true,        false,            {  9,  8, 16,  5, 16, 16 }, { 3, 1, 1, 1, 1, 1 },          4,          6,      9,                15,                45, MonsterAIID::SkeletonRanged, 0,                                                                3,     35,            12,          2,          9,             0,                    0,                 0,                 0,          15, MonsterClass::Undead, IMMUNE_MAGIC |               RESIST_LIGHTNING,               IMMUNE_MAGIC |               RESIST_LIGHTNING,                            3, 0,                     594 },
/* MT_WSKELSD */ { P_("monster", "Skeleton Captain"),        "skelsd\\sklsr",    nullptr,          "skelsd\\white",     MonsterAvailability::Always,    128,    575, true,        true,             { 13,  8, 12,  7, 15, 16 }, { 4, 1, 1, 1, 1, 1 },          1,          3,      2,                 3,                 6, MonsterAIID::SkeletonMelee,  0,                                                                0,     20,             8,          2,          7,             0,                    0,                 0,                 0,          10, MonsterClass::Undead, IMMUNE_MAGIC,                                                IMMUNE_MAGIC,                                                             3, 0,                      90 },
/* MT_TSKELSD */ { P_("monster", "Corpse Captain"),          "skelsd\\sklsr",    nullptr,          "skelsd\\skelt",     MonsterAvailability::Always,    128,    575, true,        false,            { 13,  8, 12,  7, 15, 16 }, { 4, 1, 1, 1, 1, 1 },          2,          4,      4,                12,                20, MonsterAIID::SkeletonMelee,  0,                                                                1,     30,             8,          3,          9,             0,                    0,                 0,                 0,           5, MonsterClass::Undead, IMMUNE_MAGIC,                                                IMMUNE_MAGIC,                                                             3, 0,                     200 },
/* MT_RSKELSD */ { P_("monster", "Burning Dead Captain"),    "skelsd\\sklsr",    nullptr,          nullptr,             MonsterAvailability::Always,    128,    575, true,        false,            { 13,  8, 12,  7, 15, 16 }, { 4, 1, 1, 1, 1, 1 },          3,          5,      6,                16,                30, MonsterAIID::SkeletonMelee,  0,                                                                2,     35,             8,          4,         10,             0,                    0,                 0,                 0,          15, MonsterClass::Undead, IMMUNE_MAGIC | RESIST_FIRE,                                  IMMUNE_MAGIC | IMMUNE_FIRE,                                               3, 0,                     393 },
/* MT_XSKELSD */ { P_("monster", "Horror Captain"),          "skelsd\\sklsr",    nullptr,          "skelsd\\black",     MonsterAvailability::Always,    128,    575, true,        false,            { 13,  8, 12,  7, 15, 16 }, { 4, 1, 1, 1, 1, 1 },          4,          6,      8,                35,                50, MonsterAIID::SkeletonMelee,  MFLAG_SEARCH,                                                     3,     40,             8,          5,         14,             0,                    0,                 0,                 0,          30, MonsterClass::Undead, IMMUNE_MAGIC |               RESIST_LIGHTNING,               IMMUNE_MAGIC |               RESIST_LIGHTNING,                            3, 0,                     604 },
/* MT_INVILORD*/ { P_("monster", "Invisible Lord"),          "tsneak\\tsneak",   nullptr,          nullptr,             MonsterAvailability::Never,     128,    800, false,       false,            { 13, 13, 15, 11, 16,  0 }, { 2, 1, 1, 1, 1, 1 },         19,         20,     14,               278,               278, MonsterAIID::SkeletonMelee,  MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               3,     65,             8,         16,         30,             0,                    0,                 0,                 0,          60, MonsterClass::Demon,  RESIST_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,               RESIST_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,                            3, 0,                    2000 },
/* MT_SNEAK   */ { P_("monster", "Hidden"),                  "sneak\\sneak",     nullptr,          nullptr,             MonsterAvailability::Retail,    128,    992, true,        false,            { 16,  8, 12,  8, 24, 15 }, { 2, 1, 1, 1, 1, 1 },          2,          5,      5,                 8,                24, MonsterAIID::Sneak,          MFLAG_HIDDEN,                                                     0,     35,             8,          3,          6,             0,                    0,                 0,                 0,          25, MonsterClass::Demon,  0,                                                           0,                                                                        3, 0,                     278 },
/* MT_STALKER */ { P_("monster", "Stalker"),                 "sneak\\sneak",     nullptr,          "sneak\\sneakv2",    MonsterAvailability::Retail,    128,    992, true,        false,            { 16,  8, 12,  8, 24, 15 }, { 2, 1, 1, 1, 1, 1 },          5,          7,      9,                30,                45, MonsterAIID::Sneak,          MFLAG_HIDDEN |                   MFLAG_SEARCH,                    1,     40,             8,          8,         16,             0,                    0,                 0,                 0,          30, MonsterClass::Demon,  0,                                                           0,                                                                        3, 0,                     630 },
/* MT_UNSEEN  */ { P_("monster", "Unseen"),                  "sneak\\sneak",     nullptr,          "sneak\\sneakv3",    MonsterAvailability::Retail,    128,    992, true,        false,            { 16,  8, 12,  8, 24, 15 }, { 2, 1, 1, 1, 1, 1 },          6,          8,     11,                35,                50, MonsterAIID::Sneak,          MFLAG_HIDDEN |                   MFLAG_SEARCH,                    2,     45,             8,         12,         20,             0,                    0,                 0,                 0,          30, MonsterClass::Demon,  RESIST_MAGIC,                                                IMMUNE_MAGIC,                                                             3, 0,                     935 },
/* MT_ILLWEAV */ { P_("monster", "Illusion Weaver"),         "sneak\\sneak",     nullptr,          "sneak\\sneakv1",    MonsterAvailability::Retail,    128,    992, true,        false,            { 16,  8, 12,  8, 24, 15 }, { 2, 1, 1, 1, 1, 1 },          8,         10,     13,                40,                60, MonsterAIID::Sneak,          MFLAG_HIDDEN |                   MFLAG_SEARCH,                    3,     60,             8,         16,         24,             0,                    0,                 0,                 0,          30, MonsterClass::Demon,  RESIST_MAGIC | RESIST_FIRE,                                  IMMUNE_MAGIC | RESIST_FIRE,                                               3, 0,                    1500 },
/* MT_LRDSAYTR*/ { P_("monster", "Satyr Lord"),              "goatlord\\goatl",  "newsfx\\satyr",  nullptr,             MonsterAvailability::Retail,    160,    800, false,       false,            { 13, 13, 14,  9, 16,  0 }, { 2, 1, 1, 1, 1, 1 },         21,         22,     28,               160,               200, MonsterAIID::SkeletonMelee,  MFLAG_SEARCH,                                                     3,     90,             8,         20,         30,             0,                    0,                 0,                 0,          70, MonsterClass::Animal, RESIST_FIRE | RESIST_LIGHTNING,                              RESIST_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,                            3, 0,                    2800 },
/* MT_NGOATMC */ { P_("monster", "Flesh Clan"),              "goatmace\\goat",   nullptr,          nullptr,             MonsterAvailability::Retail,    128,   1030, true,        false,            { 12,  8, 12,  6, 20, 12 }, { 2, 1, 1, 1, 1, 1 },          4,          6,      8,                30,                45, MonsterAIID::GoatMelee,      MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               0,     50,             8,          4,         10,             0,                    0,                 0,                 0,          40, MonsterClass::Demon,  0,                                                           0,                                                                        3, 0,                     460 },
/* MT_BGOATMC */ { P_("monster", "Stone Clan"),              "goatmace\\goat",   nullptr,          "goatmace\\beige",   MonsterAvailability::Retail,    128,   1030, true,        false,            { 12,  8, 12,  6, 20, 12 }, { 2, 1, 1, 1, 1, 1 },          5,          7,     10,                40,                55, MonsterAIID::GoatMelee,      MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               1,     60,             8,          6,         12,             0,                    0,                 0,                 0,          40, MonsterClass::Demon,  RESIST_MAGIC,                                                IMMUNE_MAGIC,                                                             3, 0,                     685 },
/* MT_RGOATMC */ { P_("monster", "Fire Clan"),               "goatmace\\goat",   nullptr,          "goatmace\\red",     MonsterAvailability::Retail,    128,   1030, true,        false,            { 12,  8, 12,  6, 20, 12 }, { 2, 1, 1, 1, 1, 1 },          6,          8,     12,                50,                65, MonsterAIID::GoatMelee,      MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               2,     70,             8,          8,         16,             0,                    0,                 0,                 0,          45, MonsterClass::Demon,  RESIST_FIRE,                                                 IMMUNE_FIRE,                                                              3, 0,                     906 },
/* MT_GGOATMC */ { P_("monster", "Night Clan"),              "goatmace\\goat",   nullptr,          "goatmace\\gray",    MonsterAvailability::Retail,    128,   1030, true,        false,            { 12,  8, 12,  6, 20, 12 }, { 2, 1, 1, 1, 1, 1 },          7,          9,     14,                55,                70, MonsterAIID::GoatMelee,      MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               3,     80,             8,         10,         20,            15,                    0,                30,                30,          50, MonsterClass::Demon,  RESIST_MAGIC,                                                IMMUNE_MAGIC,                                                             3, 0,                    1190 },
/* MT_FIEND   */ { P_("monster", "Fiend"),                   "bat\\bat",         nullptr,          "bat\\red",          MonsterAvailability::Always,     96,    364, false,       false,            {  9, 13, 10,  9, 13,  0 }, { 1, 1, 1, 1, 1, 1 },          2,          3,      3,                 3,                 6, MonsterAIID::Bat,            0,                                                                0,     35,             5,          1,          6,             0,                    0,                 0,                 0,           0, MonsterClass::Animal, 0,                                                           0,                                                                        6, T_NODROP,              102 },
/* MT_BLINK   */ { P_("monster", "Blink"),                   "bat\\bat",         nullptr,          nullptr,             MonsterAvailability::Always,     96,    364, false,       false,            {  9, 13, 10,  9, 13,  0 }, { 1, 1, 1, 1, 1, 1 },          3,          5,      7,                12,                28, MonsterAIID::Bat,            0,                                                                1,     45,             5,          1,          8,             0,                    0,                 0,                 0,          15, MonsterClass::Animal, 0,                                                           0,                                                                        6, T_NODROP,              340 },
/* MT_GLOOM   */ { P_("monster", "Gloom"),                   "bat\\bat",         nullptr,          "bat\\grey",         MonsterAvailability::Always,     96,    364, false,       false,            {  9, 13, 10,  9, 13,  0 }, { 1, 1, 1, 1, 1, 1 },          4,          6,      9,                28,                36, MonsterAIID::Bat,            MFLAG_SEARCH,                                                     2,     70,             5,          4,         12,             0,                    0,                 0,                 0,          35, MonsterClass::Animal, RESIST_MAGIC,                                                RESIST_MAGIC,                                                             6, T_NODROP,              509 },
/* MT_FAMILIAR*/ { P_("monster", "Familiar"),                "bat\\bat",         nullptr,          "bat\\orange",       MonsterAvailability::Always,     96,    364, false,       false,            {  9, 13, 10,  9, 13,  0 }, { 1, 1, 1, 1, 1, 1 },          6,          8,     13,                20,                35, MonsterAIID::Bat,            MFLAG_SEARCH,                                                     3,     50,             5,          4,         16,             0,                    0,                 0,                 0,          35, MonsterClass::Demon,  RESIST_MAGIC |               IMMUNE_LIGHTNING,               RESIST_MAGIC |               IMMUNE_LIGHTNING,                            6, T_NODROP,              448 },
/* MT_NGOATBW */ { P_("monster", "Flesh Clan"),              "goatbow\\goatb",   nullptr,          nullptr,             MonsterAvailability::Retail,    128,   1040, false,       false,            { 12,  8, 16,  6, 20,  0 }, { 3, 1, 1, 1, 1, 1 },          4,          6,      8,                20,                35, MonsterAIID::GoatRanged,     MFLAG_CAN_OPEN_DOOR,                                              0,     35,            13,          1,          7,             0,                    0,                 0,                 0,          35, MonsterClass::Demon,  0,                                                           0,                                                                        3, 0,                     448 },
/* MT_BGOATBW */ { P_("monster", "Stone Clan"),              "goatbow\\goatb",   nullptr,          "goatbow\\beige",    MonsterAvailability::Retail,    128,   1040, false,       false,            { 12,  8, 16,  6, 20,  0 }, { 3, 1, 1, 1, 1, 1 },          5,          7,     10,                30,                40, MonsterAIID::GoatRanged,     MFLAG_CAN_OPEN_DOOR,                                              1,     40,            13,          2,          9,             0,                    0,                 0,                 0,          35, MonsterClass::Demon,  RESIST_MAGIC,                                                IMMUNE_MAGIC,                                                             3, 0,                     645 },
/* MT_RGOATBW */ { P_("monster", "Fire Clan"),               "goatbow\\goatb",   nullptr,          "goatbow\\red",      MonsterAvailability::Retail,    128,   1040, false,       false,            { 12,  8, 16,  6, 20,  0 }, { 3, 1, 1, 1, 1, 1 },          6,          8,     12,                40,                50, MonsterAIID::GoatRanged,     MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               2,     45,            13,          3,         11,             0,                    0,                 0,                 0,          35, MonsterClass::Demon,  RESIST_FIRE,                                                 IMMUNE_FIRE,                                                              3, 0,                     822 },
/* MT_GGOATBW */ { P_("monster", "Night Clan"),              "goatbow\\goatb",   nullptr,          "goatbow\\gray",     MonsterAvailability::Retail,    128,   1040, false,       false,            { 12,  8, 16,  6, 20,  0 }, { 3, 1, 1, 1, 1, 1 },          7,          9,     14,                50,                65, MonsterAIID::GoatRanged,     MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               3,     50,            13,          4,         13,            15,                    0,                 0,                 0,          40, MonsterClass::Demon,  RESIST_MAGIC,                                                IMMUNE_MAGIC,                                                             3, 0,                    1092 },
/* MT_NACID   */ { P_("monster", "Acid Beast"),              "acid\\acid",       nullptr,          nullptr,             MonsterAvailability::Retail,    128,    716, true,        true,             { 13,  8, 12,  8, 16, 12 }, { 1, 1, 1, 1, 1, 1 },          6,          8,     11,                40,                66, MonsterAIID::Acid,           0,                                                                0,     40,             8,          4,         12,            25,                    8,                 0,                 0,          30, MonsterClass::Animal, IMMUNE_ACID,                                                 IMMUNE_MAGIC |                                  IMMUNE_ACID,              3, 0,                     846 },
/* MT_RACID   */ { P_("monster", "Poison Spitter"),          "acid\\acid",       nullptr,          "acid\\acidblk",     MonsterAvailability::Retail,    128,    716, true,        true,             { 13,  8, 12,  8, 16, 12 }, { 1, 1, 1, 1, 1, 1 },          8,         10,     15,                60,                85, MonsterAIID::Acid,           0,                                                                1,     45,             8,          4,         16,            25,                    8,                 0,                 0,          30, MonsterClass::Animal, IMMUNE_ACID,                                                 IMMUNE_MAGIC |                                  IMMUNE_ACID,              3, 0,                    1248 },
/* MT_BACID   */ { P_("monster", "Pit Beast"),               "acid\\acid",       nullptr,          "acid\\acidb",       MonsterAvailability::Retail,    128,    716, true,        true,             { 13,  8, 12,  8, 16, 12 }, { 1, 1, 1, 1, 1, 1 },         10,         12,     21,                80,               110, MonsterAIID::Acid,           0,                                                                2,     55,             8,          8,         18,            35,                    8,                 0,                 0,          35, MonsterClass::Animal, RESIST_MAGIC |                                  IMMUNE_ACID, IMMUNE_MAGIC |               RESIST_LIGHTNING | IMMUNE_ACID,              3, 0,                    2060 },
/* MT_XACID   */ { P_("monster", "Lava Maw"),                "acid\\acid",       nullptr,          "acid\\acidr",       MonsterAvailability::Retail,    128,    716, true,        true,             { 13,  8, 12,  8, 16, 12 }, { 1, 1, 1, 1, 1, 1 },         12,         14,     25,               100,               150, MonsterAIID::Acid,           0,                                                                3,     65,             8,         10,         20,            40,                    8,                 0,                 0,          35, MonsterClass::Animal, RESIST_MAGIC | IMMUNE_FIRE |                    IMMUNE_ACID, IMMUNE_MAGIC | IMMUNE_FIRE |                    IMMUNE_ACID,              3, 0,                    2940 },
/* MT_SKING   */ { P_("monster", "Skeleton King"),           "sking\\sking",     nullptr,          "skelaxe\\white",    MonsterAvailability::Never,     160,   1010, true,        true,             {  8,  6, 16,  6, 16,  6 }, { 2, 1, 1, 1, 1, 2 },          4,          4,      9,               140,               140, MonsterAIID::SkeletonKing,   MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               3,     60,             8,          6,         16,             0,                    0,                 0,                 0,          70, MonsterClass::Undead, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,               IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,                            7, Uniq(UITEM_SKCROWN),   570 },
/* MT_CLEAVER */ { P_("monster", "The Butcher"),             "fatc\\fatc",       nullptr,          nullptr,             MonsterAvailability::Never,     128,    980, false,       false,            { 10,  8, 12,  6, 16,  0 }, { 1, 1, 1, 1, 1, 1 },          1,          1,      1,               320,               320, MonsterAIID::Butcher,        0,                                                                3,     50,             8,          6,         12,             0,                    0,                 0,                 0,          50, MonsterClass::Demon,  RESIST_FIRE | RESIST_LIGHTNING,                              RESIST_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,                            3, Uniq(UITEM_CLEAVER),   710 },
/* MT_FAT     */ { P_("monster", "Overlord"),                "fat\\fat",         nullptr,          nullptr,             MonsterAvailability::Retail,    128,   1130, true,        false,            {  8, 10, 15,  6, 16, 10 }, { 4, 1, 1, 1, 1, 1 },          5,          7,     10,                60,                80, MonsterAIID::Fat,            0,                                                                0,     55,             8,          6,         12,             0,                    0,                 0,                 0,          55, MonsterClass::Demon,  0,                                                           RESIST_FIRE,                                                              3, 0,                     635 },
/* MT_MUDMAN, */ { P_("monster", "Mud Man"),                 "fat\\fat",         nullptr,          "fat\\blue",         MonsterAvailability::Retail,    128,   1130, true,        false,            {  8, 10, 15,  6, 16, 10 }, { 4, 1, 1, 1, 1, 1 },          7,          9,     14,               100,               125, MonsterAIID::Fat,            MFLAG_SEARCH,                                                     1,     60,             8,          8,         16,             0,                    0,                 0,                 0,          60, MonsterClass::Demon,  0,                                                           IMMUNE_LIGHTNING,                                                         3, 0,                    1165 },
/* MT_TOAD    */ { P_("monster", "Toad Demon"),              "fat\\fat",         nullptr,          "fat\\fatb",         MonsterAvailability::Retail,    128,   1130, true,        false,            {  8, 10, 15,  6, 16, 10 }, { 4, 1, 1, 1, 1, 1 },          8,         10,     16,               135,               160, MonsterAIID::Fat,            MFLAG_SEARCH,                                                     2,     70,             8,          8,         16,            40,                    0,                 8,                20,          65, MonsterClass::Demon,  IMMUNE_MAGIC,                                                IMMUNE_MAGIC |               RESIST_LIGHTNING,                            3, 0,                    1380 },
/* MT_FLAYED  */ { P_("monster", "Flayed One"),              "fat\\fat",         nullptr,          "fat\\fatf",         MonsterAvailability::Retail,    128,   1130, true,        false,            {  8, 10, 15,  6, 16, 10 }, { 4, 1, 1, 1, 1, 1 },         10,         12,     20,               160,               200, MonsterAIID::Fat,            MFLAG_SEARCH,                                                     3,     85,             8,         10,         20,             0,                    0,                 0,                 0,          70, MonsterClass::Demon,  RESIST_MAGIC | IMMUNE_FIRE,                                  IMMUNE_MAGIC | IMMUNE_FIRE,                                               3, 0,                    2058 },
/* MT_WYRM    */ { P_("monster", "Wyrm"),                    "worm\\worm",       nullptr,          nullptr,             MonsterAvailability::Never,     160,   2420, false,       false,            { 13, 13, 13, 11, 19,  0 }, { 1, 1, 1, 1, 1, 1 },          5,          7,     11,                60,                90, MonsterAIID::SkeletonMelee,  0,                                                                0,     40,             8,          4,         10,             0,                    0,                 0,                 0,          25, MonsterClass::Animal, RESIST_MAGIC,                                                RESIST_MAGIC,                                                             3, 0,                     660 },
/* MT_CAVSLUG */ { P_("monster", "Cave Slug"),               "worm\\worm",       nullptr,          nullptr,             MonsterAvailability::Never,     160,   2420, false,       false,            { 13, 13, 13, 11, 19,  0 }, { 1, 1, 1, 1, 1, 1 },          6,          8,     13,                75,               110, MonsterAIID::SkeletonMelee,  0,                                                                1,     50,             8,          6,         13,             0,                    0,                 0,                 0,          30, MonsterClass::Animal, RESIST_MAGIC,                                                RESIST_MAGIC,                                                             3, 0,                     994 },
/* MT_DVLWYRM */ { P_("monster", "Devil Wyrm"),              "worm\\worm",       nullptr,          nullptr,             MonsterAvailability::Never,     160,   2420, false,       false,            { 13, 13, 13, 11, 19,  0 }, { 1, 1, 1, 1, 1, 1 },          7,          9,     15,               100,               140, MonsterAIID::SkeletonMelee,  0,                                                                2,     55,             8,          8,         16,             0,                    0,                 0,                 0,          30, MonsterClass::Animal, RESIST_MAGIC | RESIST_FIRE,                                  RESIST_MAGIC | RESIST_FIRE,                                               3, 0,                    1320 },
/* MT_DEVOUR  */ { P_("monster", "Devourer"),                "worm\\worm",       nullptr,          nullptr,             MonsterAvailability::Never,     160,   2420, false,       false,            { 13, 13, 13, 11, 19,  0 }, { 1, 1, 1, 1, 1, 1 },          8,         10,     17,               125,               200, MonsterAIID::SkeletonMelee,  0,                                                                3,     60,             8,         10,         20,             0,                    0,                 0,                 0,          35, MonsterClass::Animal, RESIST_MAGIC | RESIST_FIRE,                                  RESIST_MAGIC | RESIST_FIRE,                                               3, 0,                    1827 },
/* MT_NMAGMA  */ { P_("monster", "Magma Demon"),             "magma\\magma",     nullptr,          nullptr,             MonsterAvailability::Retail,    128,   1680, true,        true,             {  8, 10, 14,  7, 18, 18 }, { 2, 1, 1, 1, 1, 1 },          8,          9,     13,                50,                70, MonsterAIID::Magma,          MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               0,     45,             4,          2,         10,            50,                   13,                 0,                 0,          45, MonsterClass::Demon,  IMMUNE_MAGIC | RESIST_FIRE,                                  IMMUNE_MAGIC | IMMUNE_FIRE,                                               7, 0,                    1076 },
/* MT_YMAGMA  */ { P_("monster", "Blood Stone"),             "magma\\magma",     nullptr,          "magma\\yellow",     MonsterAvailability::Retail,    128,   1680, true,        true,             {  8, 10, 14,  7, 18, 18 }, { 2, 1, 1, 1, 1, 1 },          8,         10,     14,                55,                75, MonsterAIID::Magma,          MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               1,     50,             4,          2,         12,            50,                   14,                 0,                 0,          45, MonsterClass::Demon,  IMMUNE_MAGIC | IMMUNE_FIRE,                                  IMMUNE_MAGIC | IMMUNE_FIRE,                                               7, 0,                    1309 },
/* MT_BMAGMA  */ { P_("monster", "Hell Stone"),              "magma\\magma",     nullptr,          "magma\\blue",       MonsterAvailability::Retail,    128,   1680, true,        true,             {  8, 10, 14,  7, 18, 18 }, { 2, 1, 1, 1, 1, 1 },          9,         11,     16,                60,                80, MonsterAIID::Magma,          MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               2,     60,             4,          2,         20,            60,                   14,                 0,                 0,          50, MonsterClass::Demon,  IMMUNE_MAGIC | IMMUNE_FIRE,                                  IMMUNE_MAGIC | IMMUNE_FIRE,                                               7, 0,                    1680 },
/* MT_WMAGMA  */ { P_("monster", "Lava Lord"),               "magma\\magma",     nullptr,          "magma\\wierd",      MonsterAvailability::Retail,    128,   1680, true,        true,             {  8, 10, 14,  7, 18, 18 }, { 2, 1, 1, 1, 1, 1 },          9,         11,     18,                70,                85, MonsterAIID::Magma,          MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               3,     75,             4,          4,         24,            60,                   14,                 0,                 0,          60, MonsterClass::Demon,  IMMUNE_MAGIC | IMMUNE_FIRE,                                  IMMUNE_MAGIC | IMMUNE_FIRE,                                               7, 0,                    2124 },
/* MT_HORNED  */ { P_("monster", "Horned Demon"),            "rhino\\rhino",     nullptr,          nullptr,             MonsterAvailability::Retail,    160,   1630, true,        true,             {  8,  8, 14,  6, 16,  6 }, { 2, 1, 1, 1, 1, 1 },          7,          9,     13,                40,                80, MonsterAIID::Rhino,          MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               0,     60,             7,          2,         16,           100,                    0,                 5,                32,          40, MonsterClass::Animal, 0,                                                           RESIST_FIRE,                                                              7, 0,                    1172 },
/* MT_MUDRUN  */ { P_("monster", "Mud Runner"),              "rhino\\rhino",     nullptr,          "rhino\\orange",     MonsterAvailability::Retail,    160,   1630, true,        true,             {  8,  8, 14,  6, 16,  6 }, { 2, 1, 1, 1, 1, 1 },          8,         10,     15,                50,                90, MonsterAIID::Rhino,          MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               1,     70,             7,          6,         18,           100,                    0,                12,                36,          45, MonsterClass::Animal, 0,                                                           RESIST_FIRE,                                                              7, 0,                    1404 },
/* MT_FROSTC  */ { P_("monster", "Frost Charger"),           "rhino\\rhino",     nullptr,          "rhino\\blue",       MonsterAvailability::Retail,    160,   1630, true,        true,             {  8,  8, 14,  6, 16,  6 }, { 2, 1, 1, 1, 1, 1 },          9,         11,     17,                60,               100, MonsterAIID::Rhino,          MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               2,     80,             7,          8,         20,           100,                    0,                20,                40,          50, MonsterClass::Animal, IMMUNE_MAGIC |               RESIST_LIGHTNING,               IMMUNE_MAGIC |               RESIST_LIGHTNING,                            7, 0,                    1720 },
/* MT_OBLORD  */ { P_("monster", "Obsidian Lord"),           "rhino\\rhino",     nullptr,          "rhino\\rhinob",     MonsterAvailability::Retail,    160,   1630, true,        true,             {  8,  8, 14,  6, 16,  6 }, { 2, 1, 1, 1, 1, 1 },         10,         12,     19,                70,               110, MonsterAIID::Rhino,          MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               3,     90,             7,         10,         22,           100,                    0,                20,                50,          55, MonsterClass::Animal, IMMUNE_MAGIC |               RESIST_LIGHTNING,               IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,                            7, 0,                    1809 },
/* MT_BONEDMN */ { P_("monster", "oldboned"),                "demskel\\demskl",  nullptr,          nullptr,             MonsterAvailability::Never,     128,   1740, true,        true,             { 10,  8, 20,  6, 24, 16 }, { 3, 1, 1, 1, 1, 1 },         24,         24,     12,                70,                70, MonsterAIID::Storm,          0,                                                                0,     60,             8,          6,         14,            12,                    0,                 0,                 0,          50, MonsterClass::Demon,  IMMUNE_MAGIC,                                                IMMUNE_MAGIC,                                                             7, 0,                    1344 },
/* MT_REDDTH  */ { P_("monster", "Red Death"),               "thin\\thin",       nullptr,          "thin\\thinv3",      MonsterAvailability::Never,     160,   1740, true,        true,             {  8,  8, 18,  4, 17, 14 }, { 3, 1, 1, 1, 1, 1 },          8,         10,     16,                96,                96, MonsterAIID::Storm,          0,                                                                1,     75,             5,         10,         20,             0,                    0,                 0,                 0,          60, MonsterClass::Demon,  IMMUNE_MAGIC | IMMUNE_FIRE,                                  IMMUNE_MAGIC | IMMUNE_FIRE,                                               7, 0,                    2168 },
/* MT_LTCHDMN */ { P_("monster", "Litch Demon"),             "thin\\thin",       nullptr,          "thin\\thinv3",      MonsterAvailability::Never,     160,   1740, true,        true,             {  8,  8, 18,  4, 17, 14 }, { 3, 1, 1, 1, 1, 1 },          9,         11,     18,               110,               110, MonsterAIID::Storm,          0,                                                                2,     80,             5,         10,         24,             0,                    0,                 0,                 0,          45, MonsterClass::Demon,  IMMUNE_MAGIC |               IMMUNE_LIGHTNING,               IMMUNE_MAGIC |               IMMUNE_LIGHTNING,                            7, 0,                    2736 },
/* MT_UDEDBLRG*/ { P_("monster", "Undead Balrog"),           "thin\\thin",       nullptr,          "thin\\thinv3",      MonsterAvailability::Never,     160,   1740, true,        true,             {  8,  8, 18,  4, 17, 14 }, { 3, 1, 1, 1, 1, 1 },         11,         13,     22,               130,               130, MonsterAIID::Storm,          0,                                                                3,     85,             5,         12,         30,             0,                    0,                 0,                 0,          65, MonsterClass::Demon,  IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,               IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,                            7, 0,                    3575 },
/* MT_INCIN   */ { P_("monster", "Incinerator"),             "fireman\\firem",   nullptr,          nullptr,             MonsterAvailability::Never,     128,   1460, true,        false,            { 14, 19, 20,  8, 14, 23 }, { 1, 1, 1, 1, 1, 1 },         21,         22,     16,                30,                45, MonsterAIID::FireMan,        0,                                                                0,     75,             8,          8,         16,             0,                    0,                 0,                 0,          25, MonsterClass::Demon,  IMMUNE_MAGIC | IMMUNE_FIRE,                                  IMMUNE_MAGIC | IMMUNE_FIRE,                                               3, 0,                    1888 },
/* MT_FLAMLRD */ { P_("monster", "Flame Lord"),              "fireman\\firem",   nullptr,          nullptr,             MonsterAvailability::Never,     128,   1460, true,        false,            { 14, 19, 20,  8, 14, 23 }, { 1, 1, 1, 1, 1, 1 },         22,         23,     18,                40,                55, MonsterAIID::FireMan,        0,                                                                1,     75,             8,         10,         20,             0,                    0,                 0,                 0,          25, MonsterClass::Demon,  IMMUNE_MAGIC | IMMUNE_FIRE,                                  IMMUNE_MAGIC | IMMUNE_FIRE,                                               3, 0,                    2250 },
/* MT_DOOMFIRE*/ { P_("monster", "Doom Fire"),               "fireman\\firem",   nullptr,          nullptr,             MonsterAvailability::Never,     128,   1460, true,        false,            { 14, 19, 20,  8, 14, 23 }, { 1, 1, 1, 1, 1, 1 },         23,         24,     20,                50,                65, MonsterAIID::FireMan,        0,                                                                2,     80,             8,         12,         24,             0,                    0,                 0,                 0,          30, MonsterClass::Demon,  IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,               IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,                            3, 0,                    2740 },
/* MT_HELLBURN*/ { P_("monster", "Hell Burner"),             "fireman\\firem",   nullptr,          nullptr,             MonsterAvailability::Never,     128,   1460, true,        false,            { 14, 19, 20,  8, 14, 23 }, { 1, 1, 1, 1, 1, 1 },         24,         24,     22,                60,                80, MonsterAIID::FireMan,        0,                                                                3,     85,             8,         15,         30,             0,                    0,                 0,                 0,          30, MonsterClass::Demon,  IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,               IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,                            3, 0,                    3355 },
/* MT_STORM   */ { P_("monster", "Red Storm"),               "thin\\thin",       nullptr,          "thin\\thinv3",      MonsterAvailability::Retail,    160,   1740, true,        true,             {  8,  8, 18,  4, 17, 14 }, { 3, 1, 1, 1, 1, 1 },          9,         11,     18,                55,               110, MonsterAIID::Storm,          MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               0,     80,             5,          8,         18,            75,                    8,                 4,                16,          30, MonsterClass::Demon,  IMMUNE_MAGIC |               RESIST_LIGHTNING,               IMMUNE_MAGIC |               IMMUNE_LIGHTNING,                            7, 0,                    2160 },
/* MT_RSTORM  */ { P_("monster", "Storm Rider"),             "thin\\thin",       nullptr,          nullptr,             MonsterAvailability::Retail,    160,   1740, true,        true,             {  8,  8, 18,  4, 17, 14 }, { 3, 1, 1, 1, 1, 1 },         10,         12,     20,                60,               120, MonsterAIID::Storm,          MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               1,     80,             5,          8,         18,            80,                    8,                 4,                16,          30, MonsterClass::Demon,  RESIST_MAGIC |               IMMUNE_LIGHTNING,               IMMUNE_MAGIC |               IMMUNE_LIGHTNING,                            7, 0,                    2391 },
/* MT_STORML  */ { P_("monster", "Storm Lord"),              "thin\\thin",       nullptr,          "thin\\thinv2",      MonsterAvailability::Retail,    160,   1740, true,        true,             {  8,  8, 18,  4, 17, 14 }, { 3, 1, 1, 1, 1, 1 },         11,         13,     22,                75,               135, MonsterAIID::Storm,          MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               2,     85,             5,         12,         24,            75,                    8,                 4,                16,          35, MonsterClass::Demon,  RESIST_MAGIC |               IMMUNE_LIGHTNING,               IMMUNE_MAGIC |               IMMUNE_LIGHTNING,                            7, 0,                    2775 },
/* MT_MAEL    */ { P_("monster", "Maelstrom"),               "thin\\thin",       nullptr,          "thin\\thinv1",      MonsterAvailability::Retail,    160,   1740, true,        true,             {  8,  8, 18,  4, 17, 14 }, { 3, 1, 1, 1, 1, 1 },         12,         14,     24,                90,               150, MonsterAIID::Storm,          MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               3,     90,             5,         12,         28,            75,                    8,                 4,                16,          40, MonsterClass::Demon,  RESIST_MAGIC |               IMMUNE_LIGHTNING,               IMMUNE_MAGIC |               IMMUNE_LIGHTNING,                            7, 0,                    3177 },
/* MT_BIGFALL */ { P_("monster", "Devil Kin Brute"),         "bigfall\\fallg",   "newsfx\\kbrute", nullptr,             MonsterAvailability::Retail,    128,    800, true,        false,            { 10,  8, 11,  8, 17,  0 }, { 1, 1, 1, 1, 2, 2 },         21,         22,     27,               120,               160, MonsterAIID::SkeletonMelee,  MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               3,    100,             6,         18,         24,             0,                    0,                 0,                 0,          70, MonsterClass::Animal, RESIST_FIRE | RESIST_LIGHTNING,                              RESIST_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,                            3, 0,                    2400 },
/* MT_WINGED  */ { P_("monster", "Winged-Demon"),            "gargoyle\\gargo",  nullptr,          nullptr,             MonsterAvailability::Retail,    160,   1650, true,        false,            { 14, 14, 14, 10, 18, 14 }, { 1, 1, 1, 1, 1, 2 },          5,          7,      9,                45,                60, MonsterAIID::Gargoyle,       MFLAG_CAN_OPEN_DOOR,                                              0,     50,             7,         10,         16,             0,                    0,                 0,                 0,          45, MonsterClass::Demon,  IMMUNE_MAGIC | RESIST_FIRE,                                  IMMUNE_MAGIC | IMMUNE_FIRE,                                               6, 0,                     662 },
/* MT_GARGOYLE*/ { P_("monster", "Gargoyle"),                "gargoyle\\gargo",  nullptr,          "gargoyle\\gare",    MonsterAvailability::Retail,    160,   1650, true,        false,            { 14, 14, 14, 10, 18, 14 }, { 1, 1, 1, 1, 1, 2 },          7,          9,     13,                60,                90, MonsterAIID::Gargoyle,       MFLAG_CAN_OPEN_DOOR,                                              1,     65,             7,         10,         16,             0,                    0,                 0,                 0,          45, MonsterClass::Demon,  IMMUNE_MAGIC |               RESIST_LIGHTNING,               IMMUNE_MAGIC |               IMMUNE_LIGHTNING,                            6, 0,                    1205 },
/* MT_BLOODCLW*/ { P_("monster", "Blood Claw"),              "gargoyle\\gargo",  nullptr,          "gargoyle\\gargbr",  MonsterAvailability::Retail,    160,   1650, true,        false,            { 14, 14, 14, 10, 18, 14 }, { 1, 1, 1, 1, 1, 1 },          9,         11,     19,                75,               125, MonsterAIID::Gargoyle,       MFLAG_CAN_OPEN_DOOR,                                              2,     80,             7,         14,         22,             0,                    0,                 0,                 0,          50, MonsterClass::Demon,  IMMUNE_MAGIC | IMMUNE_FIRE,                                  IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,                            6, 0,                    1873 },
/* MT_DEATHW  */ { P_("monster", "Death Wing"),              "gargoyle\\gargo",  nullptr,          "gargoyle\\gargb",   MonsterAvailability::Retail,    160,   1650, true,        false,            { 14, 14, 14, 10, 18, 14 }, { 1, 1, 1, 1, 1, 1 },         10,         12,     23,                90,               150, MonsterAIID::Gargoyle,       MFLAG_CAN_OPEN_DOOR,                                              3,     95,             7,         16,         28,             0,                    0,                 0,                 0,          60, MonsterClass::Demon,  IMMUNE_MAGIC |               IMMUNE_LIGHTNING,               IMMUNE_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING,                            6, 0,                    2278 },
/* MT_MEGA    */ { P_("monster", "Slayer"),                  "mega\\mega",       nullptr,          nullptr,             MonsterAvailability::Retail,    160,   2220, true,        true,             {  6,  7, 14,  1, 24,  5 }, { 3, 1, 1, 1, 2, 1 },         10,         12,     20,               120,               140, MonsterAIID::Mega,           MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               0,    100,             8,         12,         20,             0,                    3,                 0,                 0,          60, MonsterClass::Demon,  RESIST_MAGIC | IMMUNE_FIRE,                                  RESIST_MAGIC | IMMUNE_FIRE,                                               7, 0,                    2300 },
/* MT_GUARD   */ { P_("monster", "Guardian"),                "mega\\mega",       nullptr,          "mega\\guard",       MonsterAvailability::Retail,    160,   2220, true,        true,             {  6,  7, 14,  1, 24,  5 }, { 3, 1, 1, 1, 2, 1 },         11,         13,     22,               140,               160, MonsterAIID::Mega,           MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               1,    110,             8,         14,         22,             0,                    3,                 0,                 0,          65, MonsterClass::Demon,  RESIST_MAGIC | IMMUNE_FIRE,                                  RESIST_MAGIC | IMMUNE_FIRE,                                               7, 0,                    2714 },
/* MT_VTEXLRD */ { P_("monster", "Vortex Lord"),             "mega\\mega",       nullptr,          "mega\\vtexl",       MonsterAvailability::Retail,    160,   2220, true,        true,             {  6,  7, 14,  1, 24,  5 }, { 3, 1, 1, 1, 2, 1 },         12,         14,     24,               160,               180, MonsterAIID::Mega,           MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               2,    120,             8,         18,         24,             0,                    3,                 0,                 0,          70, MonsterClass::Demon,  RESIST_MAGIC | IMMUNE_FIRE,                                  RESIST_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,                            7, 0,                    3252 },
/* MT_BALROG  */ { P_("monster", "Balrog"),                  "mega\\mega",       nullptr,          "mega\\balr",        MonsterAvailability::Retail,    160,   2220, true,        true,             {  6,  7, 14,  1, 24,  5 }, { 3, 1, 1, 1, 2, 1 },         13,         15,     26,               180,               200, MonsterAIID::Mega,           MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               3,    130,             8,         22,         30,             0,                    3,                 0,                 0,          75, MonsterClass::Demon,  RESIST_MAGIC | IMMUNE_FIRE,                                  RESIST_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,                            7, 0,                    3643 },
/* MT_NSNAKE  */ { P_("monster", "Cave Viper"),              "snake\\snake",     nullptr,          nullptr,             MonsterAvailability::Retail,    160,   1270, false,       false,            { 12, 11, 13,  5, 18,  0 }, { 2, 1, 1, 1, 1, 1 },         11,         13,     21,               100,               150, MonsterAIID::Snake,          MFLAG_SEARCH,                                                     0,     90,             8,          8,         20,             0,                    0,                 0,                 0,          60, MonsterClass::Demon,  IMMUNE_MAGIC,                                                IMMUNE_MAGIC,                                                             7, 0,                    2725 },
/* MT_RSNAKE  */ { P_("monster", "Fire Drake"),              "snake\\snake",     nullptr,          "snake\\snakr",      MonsterAvailability::Retail,    160,   1270, false,       false,            { 12, 11, 13,  5, 18,  0 }, { 2, 1, 1, 1, 1, 1 },         12,         14,     23,               120,               170, MonsterAIID::Snake,          MFLAG_SEARCH,                                                     1,    105,             8,         12,         24,             0,                    0,                 0,                 0,          65, MonsterClass::Demon,  IMMUNE_MAGIC | RESIST_FIRE,                                  IMMUNE_MAGIC | IMMUNE_FIRE,                                               7, 0,                    3139 },
/* MT_BSNAKE  */ { P_("monster", "Gold Viper"),              "snake\\snake",     nullptr,          "snake\\snakg",      MonsterAvailability::Retail,    160,   1270, false,       false,            { 12, 11, 13,  5, 18,  0 }, { 2, 1, 1, 1, 1, 1 },         13,         14,     25,               140,               180, MonsterAIID::Snake,          MFLAG_SEARCH,                                                     2,    120,             8,         15,         26,             0,                    0,                 0,                 0,          70, MonsterClass::Demon,  IMMUNE_MAGIC |               RESIST_LIGHTNING,               IMMUNE_MAGIC |               RESIST_LIGHTNING,                            7, 0,                    3540 },
/* MT_GSNAKE  */ { P_("monster", "Azure Drake"),             "snake\\snake",     nullptr,          "snake\\snakb",      MonsterAvailability::Retail,    160,   1270, false,       false,            { 12, 11, 13,  5, 18,  0 }, { 2, 1, 1, 1, 1, 1 },         15,         16,     27,               160,               200, MonsterAIID::Snake,          MFLAG_SEARCH,                                                     3,    130,             8,         18,         30,             0,                    0,                 0,                 0,          75, MonsterClass::Demon,  RESIST_FIRE | RESIST_LIGHTNING,                              IMMUNE_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING,                            7, 0,                    3791 },
/* MT_NBLACK  */ { P_("monster", "Black Knight"),            "black\\black",     nullptr,          nullptr,             MonsterAvailability::Retail,    160,   2120, false,       false,            {  8,  8, 16,  4, 24,  0 }, { 2, 1, 1, 1, 1, 1 },         12,         14,     24,               150,               150, MonsterAIID::SkeletonMelee,  MFLAG_SEARCH,                                                     0,    110,             8,         15,         20,             0,                    0,                 0,                 0,          75, MonsterClass::Demon,  RESIST_MAGIC |               RESIST_LIGHTNING,               RESIST_MAGIC |               IMMUNE_LIGHTNING,                            7, 0,                    3360 },
/* MT_RTBLACK */ { P_("monster", "Doom Guard"),              "black\\black",     nullptr,          "black\\blkkntrt",   MonsterAvailability::Retail,    160,   2120, false,       false,            {  8,  8, 16,  4, 24,  0 }, { 2, 1, 1, 1, 1, 1 },         13,         15,     26,               165,               165, MonsterAIID::SkeletonMelee,  MFLAG_SEARCH,                                                     0,    130,             8,         18,         25,             0,                    0,                 0,                 0,          75, MonsterClass::Demon,  RESIST_MAGIC | RESIST_FIRE,                                  RESIST_MAGIC | IMMUNE_FIRE,                                               7, 0,                    3650 },
/* MT_BTBLACK */ { P_("monster", "Steel Lord"),              "black\\black",     nullptr,          "black\\blkkntbt",   MonsterAvailability::Retail,    160,   2120, false,       false,            {  8,  8, 16,  4, 24,  0 }, { 2, 1, 1, 1, 1, 1 },         14,         16,     28,               180,               180, MonsterAIID::SkeletonMelee,  MFLAG_SEARCH,                                                     1,    120,             8,         20,         30,             0,                    0,                 0,                 0,          80, MonsterClass::Demon,  RESIST_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,               IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,                            7, 0,                    4252 },
/* MT_RBLACK  */ { P_("monster", "Blood Knight"),            "black\\black",     nullptr,          "black\\blkkntbe",   MonsterAvailability::Retail,    160,   2120, false,       false,            {  8,  8, 16,  4, 24,  0 }, { 2, 1, 1, 1, 1, 1 },         13,         14,     30,               200,               200, MonsterAIID::SkeletonMelee,  MFLAG_SEARCH,                                                     1,    130,             8,         25,         35,             0,                    0,                 0,                 0,          85, MonsterClass::Demon,  IMMUNE_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING,               IMMUNE_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING,                            7, 0,                    5130 },
/* MT_UNRAV   */ { P_("monster", "The Shredded"),            "unrav\\unrav",     "newsfx\\shred",  nullptr,             MonsterAvailability::Retail,     96,    484, false,       false,            { 10, 10, 12,  5, 16,  0 }, { 1, 1, 1, 1, 1, 1 },         17,         18,     23,                70,                90, MonsterAIID::SkeletonMelee,  0,                                                                0,     75,             7,          4,         12,             0,                    0,                 0,                 0,          65, MonsterClass::Undead, RESIST_FIRE | RESIST_LIGHTNING,                              RESIST_FIRE | RESIST_LIGHTNING,                                           3, 0,                     900 },
/* MT_HOLOWONE*/ { P_("monster", "Hollow One"),              "unrav\\unrav",     "acid\\acid",     nullptr,             MonsterAvailability::Never,      96,    484, false,       false,            { 10, 10, 12,  5, 16,  0 }, { 1, 1, 1, 1, 1, 1 },         18,         19,     27,               135,               240, MonsterAIID::SkeletonMelee,  0,                                                                1,     75,             7,         12,         24,             0,                    0,                 0,                 0,          75, MonsterClass::Undead, IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,               IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,                            3, 0,                    4374 },
/* MT_PAINMSTR*/ { P_("monster", "Pain Master"),             "unrav\\unrav",     "acid\\acid",     nullptr,             MonsterAvailability::Never,      96,    484, false,       false,            { 10, 10, 12,  5, 16,  0 }, { 1, 1, 1, 1, 1, 1 },         19,         20,     29,               110,               200, MonsterAIID::SkeletonMelee,  0,                                                                2,     80,             7,         16,         30,             0,                    0,                 0,                 0,          80, MonsterClass::Undead, IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,               IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,                            3, 0,                    5147 },
/* MT_REALWEAV*/ { P_("monster", "Reality Weaver"),          "unrav\\unrav",     "acid\\acid",     nullptr,             MonsterAvailability::Never,      96,    484, false,       false,            { 10, 10, 12,  5, 16,  0 }, { 1, 1, 1, 1, 1, 1 },         20,         20,     30,               135,               240, MonsterAIID::SkeletonMelee,  0,                                                                3,     85,             7,         20,         35,             0,                    0,                 0,                 0,          85, MonsterClass::Undead, RESIST_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,               RESIST_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,                            3, 0,                    5925 },
/* MT_SUCCUBUS*/ { P_("monster", "Succubus"),                "succ\\scbs",       nullptr,          nullptr,             MonsterAvailability::Retail,    128,    980, false,       false,            { 14,  8, 16,  7, 24,  0 }, { 1, 1, 1, 1, 1, 1 },         12,         14,     24,               120,               150, MonsterAIID::Succubus,       MFLAG_CAN_OPEN_DOOR,                                              0,    100,            10,          1,         20,             0,                    0,                 0,                 0,          60, MonsterClass::Demon,  RESIST_MAGIC,                                                IMMUNE_MAGIC | RESIST_FIRE,                                               3, 0,                    3696 },
/* MT_SNOWWICH*/ { P_("monster", "Snow Witch"),              "succ\\scbs",       nullptr,          "succ\\succb",       MonsterAvailability::Retail,    128,    980, false,       false,            { 14,  8, 16,  7, 24,  0 }, { 1, 1, 1, 1, 1, 1 },         13,         15,     26,               135,               175, MonsterAIID::Succubus,       MFLAG_CAN_OPEN_DOOR,                                              1,    110,            10,          1,         24,             0,                    0,                 0,                 0,          65, MonsterClass::Demon,  RESIST_LIGHTNING,                                            IMMUNE_MAGIC |               RESIST_LIGHTNING,                            3, 0,                    4084 },
/* MT_HLSPWN  */ { P_("monster", "Hell Spawn"),              "succ\\scbs",       nullptr,          "succ\\succrw",      MonsterAvailability::Retail,    128,    980, false,       false,            { 14,  8, 16,  7, 24,  0 }, { 1, 1, 1, 1, 1, 1 },         14,         16,     28,               150,               200, MonsterAIID::Succubus,       MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               2,    115,            10,          1,         30,             0,                    0,                 0,                 0,          75, MonsterClass::Demon,  RESIST_MAGIC |               IMMUNE_LIGHTNING,               IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,                            3, 0,                    4480 },
/* MT_SOLBRNR */ { P_("monster", "Soul Burner"),             "succ\\scbs",       nullptr,          "succ\\succbw",      MonsterAvailability::Retail,    128,    980, false,       false,            { 14,  8, 16,  7, 24,  0 }, { 1, 1, 1, 1, 1, 1 },         15,         16,     30,               140,               225, MonsterAIID::Succubus,       MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               3,    120,            10,          1,         35,             0,                    0,                 0,                 0,          85, MonsterClass::Demon,  RESIST_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,               IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,                            3, 0,                    4644 },
/* MT_COUNSLR */ { P_("monster", "Counselor"),               "mage\\mage",       nullptr,          nullptr,             MonsterAvailability::Retail,    128,   2000, true,        false,            { 12,  1, 20,  8, 28, 20 }, { 1, 1, 1, 1, 1, 1 },         13,         14,     25,                70,                70, MonsterAIID::Counselor,      MFLAG_CAN_OPEN_DOOR,                                              0,     90,             8,          8,         20,             0,                    0,                 0,                 0,           0, MonsterClass::Demon,  RESIST_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,               RESIST_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,                            7, 0,                    4070 },
/* MT_MAGISTR */ { P_("monster", "Magistrate"),              "mage\\mage",       nullptr,          "mage\\cnselg",      MonsterAvailability::Retail,    128,   2000, true,        false,            { 12,  1, 20,  8, 28, 20 }, { 1, 1, 1, 1, 1, 1 },         14,         15,     27,                85,                85, MonsterAIID::Counselor,      MFLAG_CAN_OPEN_DOOR,                                              1,    100,             8,         10,         24,             0,                    0,                 0,                 0,           0, MonsterClass::Demon,  RESIST_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,               IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,                            7, 0,                    4478 },
/* MT_CABALIST*/ { P_("monster", "Cabalist"),                "mage\\mage",       nullptr,          "mage\\cnselgd",     MonsterAvailability::Retail,    128,   2000, true,        false,            { 12,  1, 20,  8, 28, 20 }, { 1, 1, 1, 1, 1, 1 },         15,         16,     29,               120,               120, MonsterAIID::Counselor,      MFLAG_CAN_OPEN_DOOR,                                              2,    110,             8,         14,         30,             0,                    0,                 0,                 0,           0, MonsterClass::Demon,  RESIST_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING,               IMMUNE_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING,                            7, 0,                    4929 },
/* MT_ADVOCATE*/ { P_("monster", "Advocate"),                "mage\\mage",       nullptr,          "mage\\cnselbk",     MonsterAvailability::Retail,    128,   2000, true,        false,            { 12,  1, 20,  8, 28, 20 }, { 1, 1, 1, 1, 1, 1 },         16,         16,     30,               145,               145, MonsterAIID::Counselor,      MFLAG_CAN_OPEN_DOOR,                                              3,    120,             8,         15,         25,             0,                    0,                 0,                 0,           0, MonsterClass::Demon,  IMMUNE_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING,               IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,                            7, 0,                    4968 },
/* MT_GOLEM   */ { P_("monster", "Golem"),                   "golem\\golem",     "golem\\golm",    nullptr,             MonsterAvailability::Never,      96,    386, true,        false,            {  0, 16, 12,  0, 12, 20 }, { 1, 1, 1, 1, 1, 1 },          1,          1,     12,                 1,                 1, MonsterAIID::Golem,          MFLAG_CAN_OPEN_DOOR,                                              0,      0,             7,          1,          1,             0,                    0,                 0,                 0,           1, MonsterClass::Demon,  0,                                                           0,                                                                        0, 0,                       0 },
/* MT_DIABLO  */ { P_("monster", "The Dark Lord"),           "diablo\\diablo",   nullptr,          nullptr,             MonsterAvailability::Never,     160,   2000, true,        true,             { 16,  6, 16,  6, 16, 16 }, { 1, 1, 1, 1, 1, 1 },         26,         26,     45,              3333,              3333, MonsterAIID::Diablo,         MFLAG_KNOCKBACK | MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,             3,    220,             4,         30,         60,             0,                   11,                 0,                 0,          90, MonsterClass::Demon,  IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,               IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,                            7, 0,                   31666 },
/* MT_DARKMAGE*/ { P_("monster", "The Arch-Litch Malignus"), "darkmage\\dmage",  "darkmage\\dmag", nullptr,             MonsterAvailability::Never,     128,   1060, true,        false,            {  6,  1, 21,  6, 23, 18 }, { 1, 1, 1, 1, 1, 1 },         21,         21,     30,               160,               160, MonsterAIID::Counselor,      MFLAG_CAN_OPEN_DOOR,                                              3,    120,             8,         20,         40,             0,                    0,                 0,                 0,          70, MonsterClass::Demon,  RESIST_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,               IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,                            7, 0,                    4968 },
/* MT_HELLBOAR*/ { P_("monster", "Hellboar"),                "fork\\fork",       "newsfx\\hboar",  nullptr,             MonsterAvailability::Retail,    188,    800, false,       false,            { 10, 10, 15,  6, 16,  0 }, { 2, 1, 1, 1, 1, 1 },         17,         18,     23,                80,               100, MonsterAIID::SkeletonMelee,  MFLAG_KNOCKBACK | MFLAG_SEARCH,                                   2,     70,             7,         16,         24,             0,                    0,                 0,                 0,          60, MonsterClass::Demon,  0,                                                           RESIST_FIRE | RESIST_LIGHTNING,                                           3, 0,                     750 },
/* MT_STINGER */ { P_("monster", "Stinger"),                 "scorp\\scorp",     "newsfx\\stingr", nullptr,             MonsterAvailability::Retail,     64,    305, false,       false,            { 10, 10, 12,  6, 15,  0 }, { 2, 1, 1, 1, 1, 1 },         17,         18,     22,                30,                40, MonsterAIID::SkeletonMelee,  0,                                                                3,     85,             8,          1,         20,             0,                    0,                 0,                 0,          50, MonsterClass::Animal, 0,                                                           RESIST_LIGHTNING,                                                         1, 0,                     500 },
/* MT_PSYCHORB*/ { P_("monster", "Psychorb"),                "eye\\eye",         "newsfx\\psyco",  nullptr,             MonsterAvailability::Retail,    156,    800, false,       false,            { 12, 13, 13,  7, 21,  0 }, { 2, 1, 1, 1, 1, 1 },         17,         18,     22,                20,                30, MonsterAIID::Psychorb,       0,                                                                3,     80,             8,         10,         10,             0,                    0,                 0,                 0,          40, MonsterClass::Animal, 0,                                                           RESIST_FIRE,                                                              6, 0,                     450 },
/* MT_ARACHNON*/ { P_("monster", "Arachnon"),                "spider\\spider",   "newsfx\\slord",  nullptr,             MonsterAvailability::Retail,    148,    800, false,       false,            { 12, 10, 15,  6, 20,  0 }, { 2, 1, 1, 1, 1, 1 },         17,         18,     22,                60,                80, MonsterAIID::SkeletonMelee,  MFLAG_SEARCH,                                                     3,     50,             8,          5,         15,             0,                    0,                 0,                 0,          50, MonsterClass::Animal, 0,                                                           RESIST_LIGHTNING,                                                         7, 0,                     500 },
/* MT_FELLTWIN*/ { P_("monster", "Felltwin"),                "tsneak\\tsneak",   "newsfx\\ftwin",  nullptr,             MonsterAvailability::Retail,    128,    800, false,       false,            { 13, 13, 15, 11, 16,  0 }, { 2, 1, 1, 1, 1, 1 },         17,         18,     22,                50,                70, MonsterAIID::SkeletonMelee,  MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,                               3,     70,             8,         10,         18,             0,                    0,                 0,                 0,          50, MonsterClass::Demon,  0,                                                           RESIST_FIRE | RESIST_LIGHTNING,                                           3, 0,                     600 },
/* MT_HORKSPWN*/ { P_("monster", "Hork Spawn"),              "spawn\\spawn",     "newsfx\\hspawn", nullptr,             MonsterAvailability::Retail,    164,    520, false,       true,             { 15, 12, 14, 11, 14,  0 }, { 1, 1, 1, 1, 1, 1 },         18,         19,     22,                30,                30, MonsterAIID::SkeletonMelee,  0,                                                                3,     60,             8,         10,         25,             0,                    0,                 0,                 0,          25, MonsterClass::Demon,  RESIST_MAGIC,                                                RESIST_MAGIC,                                                             3, 0,                     250 },
/* MT_VENMTAIL*/ { P_("monster", "Venomtail"),               "wscorp\\wscorp",   "newsfx\\stingr", nullptr,             MonsterAvailability::Retail,     86,    305, false,       false,            { 10, 10, 12,  6, 15,  0 }, { 2, 1, 1, 1, 1, 1 },         19,         20,     24,                40,                50, MonsterAIID::SkeletonMelee,  0,                                                                3,     85,             8,          1,         30,             0,                    0,                 0,                 0,          60, MonsterClass::Animal, RESIST_LIGHTNING,                                            IMMUNE_LIGHTNING,                                                         1, 0,                    1000 },
/* MT_NECRMORB*/ { P_("monster", "Necromorb"),               "eye2\\eye2",       "newsfx\\psyco",  nullptr,             MonsterAvailability::Retail,    140,    800, false,       false,            { 12, 13, 13,  7, 21,  0 }, { 2, 1, 1, 1, 1, 1 },         19,         20,     24,                30,                40, MonsterAIID::Necromorb,      0,                                                                3,     80,             8,         20,         20,             0,                    0,                 0,                 0,          50, MonsterClass::Animal, RESIST_FIRE,                                                 IMMUNE_FIRE | RESIST_LIGHTNING,                                           6, 0,                    1100 },
/* MT_SPIDLORD*/ { P_("monster", "Spider Lord"),             "bspidr\\bspidr",   "newsfx\\slord",  nullptr,             MonsterAvailability::Retail,    148,    800, true,        true,             { 12, 10, 15,  6, 20, 10 }, { 2, 1, 1, 1, 1, 1 },         19,         20,     24,                80,               100, MonsterAIID::Acid,           MFLAG_SEARCH,                                                     3,     60,             8,          8,         20,            75,                    8,                10,                10,          60, MonsterClass::Animal, RESIST_LIGHTNING,                                            RESIST_FIRE | IMMUNE_LIGHTNING,                                           7, 0,                    1250 },
/* MT_LASHWORM*/ { P_("monster", "Lashworm"),                "clasp\\clasp",     "newsfx\\lworm",  nullptr,             MonsterAvailability::Retail,    176,    800, false,       false,            { 10, 12, 15,  6, 16,  0 }, { 1, 1, 1, 1, 1, 1 },         19,         20,     20,                30,                30, MonsterAIID::SkeletonMelee,  0,                                                                3,     90,             8,         12,         20,             0,                    0,                 0,                 0,          50, MonsterClass::Animal, 0,                                                           RESIST_FIRE,                                                              3, 0,                     600 },
/* MT_TORCHANT*/ { P_("monster", "Torchant"),                "antworm\\worm",    "newsfx\\tchant", nullptr,             MonsterAvailability::Retail,    192,    800, false,       false,            { 14, 12, 12,  6, 20,  0 }, { 2, 1, 1, 1, 1, 1 },         19,         20,     22,                60,                80, MonsterAIID::Torchant,       0,                                                                3,     75,             8,         20,         30,             0,                    0,                 0,                 0,          70, MonsterClass::Animal, IMMUNE_FIRE,                                                 RESIST_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,                            7, 0,                    1250 },
/* MT_HORKDMN */ { P_("monster", "Hork Demon"),              "horkd\\horkd",     "newsfx\\hdemon", nullptr,             MonsterAvailability::Never,     138,    800, true,        true,             { 15,  8, 16,  6, 16,  9 }, { 2, 1, 1, 1, 1, 2 },         19,         19,     27,               120,               160, MonsterAIID::SkeletonMelee,  0,                                                                3,     60,             8,         20,         35,            80,                    8,                 0,                 0,          80, MonsterClass::Demon,  RESIST_LIGHTNING,                                            RESIST_MAGIC |               IMMUNE_LIGHTNING,                            7, 0,                    2000 },
/* MT_DEFILER */ { P_("monster", "Hell Bug"),                "hellbug\\hellbg",  "newsfx\\defile", nullptr,             MonsterAvailability::Never,     198,    800, true,        true,             {  8,  8, 14,  6, 14, 12 }, { 1, 1, 1, 1, 1, 1 },         20,         20,     30,               240,               240, MonsterAIID::SkeletonMelee,  MFLAG_SEARCH,                                                     3,    110,             8,         20,         30,            90,                    8,                50,                60,          80, MonsterClass::Demon,  RESIST_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING,               RESIST_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,                            7, 0,                    5000 },
/* MT_GRAVEDIG*/ { P_("monster", "Gravedigger"),             "gravdg\\gravdg",   "newsfx\\gdiggr", nullptr,             MonsterAvailability::Retail,    124,    800, true,        true,             { 24, 24, 12,  6, 16, 16 }, { 2, 1, 1, 1, 1, 1 },         21,         21,     26,               120,               240, MonsterAIID::Scavenger,      MFLAG_CAN_OPEN_DOOR,                                              3,     80,             6,          2,         12,             0,                    0,                 0,                 0,          20, MonsterClass::Undead, IMMUNE_LIGHTNING,                                            RESIST_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING,                            3, 0,                    2000 },
/* MT_TOMBRAT */ { P_("monster", "Tomb Rat"),                "rat\\rat",         "newsfx\\tmbrat", nullptr,             MonsterAvailability::Retail,    104,    550, false,       false,            { 11,  8, 12,  6, 20,  0 }, { 2, 1, 1, 1, 1, 1 },         21,         22,     24,                80,               120, MonsterAIID::SkeletonMelee,  0,                                                                3,    120,             8,         12,         25,             0,                    0,                 0,                 0,          30, MonsterClass::Animal, 0,                                                           RESIST_FIRE | RESIST_LIGHTNING,                                           3, 0,                    1800 },
/* MT_FIREBAT */ { P_("monster", "Firebat"),                 "hellbat\\helbat",  "newsfx\\helbat", nullptr,             MonsterAvailability::Retail,     96,    550, false,       false,            { 18, 16, 14,  6, 18, 11 }, { 2, 1, 1, 1, 1, 1 },         21,         22,     24,                60,                80, MonsterAIID::FireBat,        0,                                                                3,    100,             8,         15,         20,             0,                    0,                 0,                 0,          70, MonsterClass::Animal, IMMUNE_FIRE,                                                 RESIST_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,                            7, 0,                    2400 },
/* MT_SKLWING */ { P_("monster", "Skullwing"),               "demskel\\demskl",  "newsfx\\swing",  "skelaxe\\skelt",    MonsterAvailability::Retail,    128,   1740, true,        false,            { 10,  8, 20,  6, 24, 16 }, { 3, 1, 1, 1, 1, 1 },         21,         22,     27,                70,                70, MonsterAIID::SkeletonMelee,  0,                                                                0,     75,             7,         15,         20,            75,                    9,                15,                20,          80, MonsterClass::Undead, RESIST_FIRE | RESIST_LIGHTNING,                              RESIST_FIRE | RESIST_LIGHTNING,                                           7, 0,                    3000 },
/* MT_LICH    */ { P_("monster", "Lich"),                    "lich\\lich",       "newsfx\\lich",   nullptr,             MonsterAvailability::Retail,     96,    800, false,       true,             { 12, 10, 10,  7, 21,  0 }, { 2, 1, 1, 1, 2, 1 },         21,         22,     25,                80,               100, MonsterAIID::Lich,           0,                                                                3,    100,             8,         15,         20,             0,                    0,                 0,                 0,          60, MonsterClass::Undead, RESIST_LIGHTNING,                                            RESIST_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING,                            3, 0,                    3000 },
/* MT_CRYPTDMN*/ { P_("monster", "Crypt Demon"),             "bubba\\bubba",     "newsfx\\crypt",  nullptr,             MonsterAvailability::Retail,    154,    800, false,       true,             {  8, 18, 12,  8, 21,  0 }, { 3, 1, 1, 1, 1, 1 },         22,         23,     28,               200,               240, MonsterAIID::SkeletonMelee,  0,                                                                3,    100,             8,         20,         40,             0,                    0,                 0,                 0,          85, MonsterClass::Demon,  IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,               IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,                            3, 0,                    3200 },
/* MT_HELLBAT */ { P_("monster", "Hellbat"),                 "hellbat2\\bhelbt", "newsfx\\helbat", nullptr,             MonsterAvailability::Retail,     96,    550, true,        false,            { 18, 16, 14,  6, 18, 11 }, { 2, 1, 1, 1, 1, 1 },         23,         24,     29,               100,               140, MonsterAIID::Torchant,       0,                                                                3,    110,             8,         30,         30,             0,                    0,                 0,                 0,          80, MonsterClass::Demon,  RESIST_MAGIC | IMMUNE_FIRE  | RESIST_LIGHTNING,              RESIST_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,                            7, 0,                    3600 },
/* MT_BONEDEMN*/ { P_("monster", "Bone Demon"),              "demskel\\demskl",  "newsfx\\swing",  nullptr,             MonsterAvailability::Retail,    128,   1740, true,        true,             { 10,  8, 20,  6, 24, 16 }, { 3, 1, 1, 1, 1, 1 },         23,         24,     30,               240,               280, MonsterAIID::BoneDemon,      0,                                                                0,    100,             8,         40,         50,           160,                   12,                50,                50,          50, MonsterClass::Undead, IMMUNE_FIRE  | IMMUNE_LIGHTNING,                             IMMUNE_FIRE | IMMUNE_LIGHTNING,                                           7, 0,                    5000 },
/* MT_ARCHLICH*/ { P_("monster", "Arch Lich"),               "lich2\\lich2",     "newsfx\\lich",   nullptr,             MonsterAvailability::Retail,    136,    800, false,       true,             { 12, 10, 10,  7, 21,  0 }, { 2, 1, 1, 1, 2, 1 },         23,         24,     30,               180,               200, MonsterAIID::ArchLich,       0,                                                                3,    120,             8,         30,         30,             0,                    0,                 0,                 0,          75, MonsterClass::Undead, RESIST_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING,               IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,                            3, 0,                    4000 },
/* MT_BICLOPS */ { P_("monster", "Biclops"),                 "byclps\\byclps",   "newsfx\\biclop", nullptr,             MonsterAvailability::Retail,    180,    800, false,       false,            { 10, 11, 16,  6, 16,  0 }, { 2, 1, 1, 1, 2, 1 },         23,         24,     30,               200,               240, MonsterAIID::SkeletonMelee,  MFLAG_KNOCKBACK |                MFLAG_CAN_OPEN_DOOR,             3,     90,             8,         40,         50,             0,                    0,                 0,                 0,          80, MonsterClass::Demon,  RESIST_LIGHTNING,                                            RESIST_FIRE | RESIST_LIGHTNING,                                           3, 0,                    4000 },
/* MT_FLESTHNG*/ { P_("monster", "Flesh Thing"),             "flesh\\flesh",     "newsfx\\flesht", nullptr,             MonsterAvailability::Retail,    164,    800, false,       true,             { 15, 24, 15,  6, 16,  0 }, { 1, 1, 1, 1, 1, 1 },         23,         24,     28,               300,               400, MonsterAIID::SkeletonMelee,  0,                                                                3,    150,             8,         12,         18,             0,                    0,                 0,                 0,          70, MonsterClass::Demon,  RESIST_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,               RESIST_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,                            3, 0,                    4000 },
/* MT_REAPER  */ { P_("monster", "Reaper"),                  "reaper\\reap",     "newsfx\\reaper", nullptr,             MonsterAvailability::Retail,    180,    800, false,       false,            { 12, 10, 14,  6, 16,  0 }, { 2, 1, 1, 1, 1, 1 },         23,         24,     30,               260,               300, MonsterAIID::SkeletonMelee,  0,                                                                3,    120,             8,         30,         35,             0,                    0,                 0,                 0,          90, MonsterClass::Demon,  IMMUNE_MAGIC | IMMUNE_FIRE  | RESIST_LIGHTNING,              IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,                            3, 0,                    6000 },
// TRANSLATORS: Monster Block end
/* MT_NAKRUL  */ { P_("monster", "Na-Krul"),                 "nkr\\nkr",         "newsfx\\nakrul", nullptr,             MonsterAvailability::Never,     226,   1200, true,        true,             {  2,  6, 16,  3, 16, 16 }, { 1, 1, 1, 1, 1, 1 },         31,         31,     40,              1332,              1332, MonsterAIID::SkeletonMelee,  MFLAG_KNOCKBACK | MFLAG_SEARCH | MFLAG_CAN_OPEN_DOOR,             3,    150,             7,         40,         50,           150,                   10,                40,                50,         125, MonsterClass::Demon,  IMMUNE_MAGIC | IMMUNE_FIRE  | RESIST_LIGHTNING,              IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,                            7, 0,                   13333 },
	// clang-format on
};

/**
 * Map between .DUN file value and monster type enum
 */
const _monster_id MonstConvTbl[] = {
	MT_NZOMBIE,
	MT_BZOMBIE,
	MT_GZOMBIE,
	MT_YZOMBIE,
	MT_RFALLSP,
	MT_DFALLSP,
	MT_YFALLSP,
	MT_BFALLSP,
	MT_WSKELAX,
	MT_TSKELAX,
	MT_RSKELAX,
	MT_XSKELAX,
	MT_RFALLSD,
	MT_DFALLSD,
	MT_YFALLSD,
	MT_BFALLSD,
	MT_NSCAV,
	MT_BSCAV,
	MT_WSCAV,
	MT_YSCAV,
	MT_WSKELBW,
	MT_TSKELBW,
	MT_RSKELBW,
	MT_XSKELBW,
	MT_WSKELSD,
	MT_TSKELSD,
	MT_RSKELSD,
	MT_XSKELSD,
	MT_SNEAK,
	MT_STALKER,
	MT_UNSEEN,
	MT_ILLWEAV,
	MT_NGOATMC,
	MT_BGOATMC,
	MT_RGOATMC,
	MT_GGOATMC,
	MT_FIEND,
	MT_GLOOM,
	MT_BLINK,
	MT_FAMILIAR,
	MT_NGOATBW,
	MT_BGOATBW,
	MT_RGOATBW,
	MT_GGOATBW,
	MT_NACID,
	MT_RACID,
	MT_BACID,
	MT_XACID,
	MT_SKING,
	MT_FAT,
	MT_MUDMAN,
	MT_TOAD,
	MT_FLAYED,
	MT_WYRM,
	MT_CAVSLUG,
	MT_DEVOUR,
	MT_DVLWYRM,
	MT_NMAGMA,
	MT_YMAGMA,
	MT_BMAGMA,
	MT_WMAGMA,
	MT_HORNED,
	MT_MUDRUN,
	MT_FROSTC,
	MT_OBLORD,
	MT_BONEDMN,
	MT_REDDTH,
	MT_LTCHDMN,
	MT_UDEDBLRG,
	MT_INVALID,
	MT_INVALID,
	MT_INVALID,
	MT_INVALID,
	MT_INCIN,
	MT_FLAMLRD,
	MT_DOOMFIRE,
	MT_HELLBURN,
	MT_INVALID,
	MT_INVALID,
	MT_INVALID,
	MT_INVALID,
	MT_RSTORM,
	MT_STORM,
	MT_STORML,
	MT_MAEL,
	MT_WINGED,
	MT_GARGOYLE,
	MT_BLOODCLW,
	MT_DEATHW,
	MT_MEGA,
	MT_GUARD,
	MT_VTEXLRD,
	MT_BALROG,
	MT_NSNAKE,
	MT_RSNAKE,
	MT_GSNAKE,
	MT_BSNAKE,
	MT_NBLACK,
	MT_RTBLACK,
	MT_BTBLACK,
	MT_RBLACK,
	MT_UNRAV,
	MT_HOLOWONE,
	MT_PAINMSTR,
	MT_REALWEAV,
	MT_SUCCUBUS,
	MT_SNOWWICH,
	MT_HLSPWN,
	MT_SOLBRNR,
	MT_COUNSLR,
	MT_MAGISTR,
	MT_CABALIST,
	MT_ADVOCATE,
	MT_INVALID,
	MT_DIABLO,
	MT_INVALID,
	MT_GOLEM,
	MT_INVALID,
	MT_INVALID,
	MT_INVALID, // Monster from blood1.dun and blood2.dun
	MT_INVALID,
	MT_INVALID,
	MT_INVALID,
	MT_INVALID, // Snotspill from banner2.dun
	MT_INVALID,
	MT_INVALID,
	MT_BIGFALL,
	MT_DARKMAGE,
	MT_HELLBOAR,
	MT_STINGER,
	MT_PSYCHORB,
	MT_ARACHNON,
	MT_FELLTWIN,
	MT_HORKSPWN,
	MT_VENMTAIL,
	MT_NECRMORB,
	MT_SPIDLORD,
	MT_LASHWORM,
	MT_TORCHANT,
	MT_HORKDMN,
	MT_DEFILER,
	MT_GRAVEDIG,
	MT_TOMBRAT,
	MT_FIREBAT,
	MT_SKLWING,
	MT_LICH,
	MT_CRYPTDMN,
	MT_HELLBAT,
	MT_BONEDEMN,
	MT_LICH,
	MT_BICLOPS,
	MT_FLESTHNG,
	MT_REAPER,
	MT_NAKRUL,
	MT_CLEAVER,
	MT_INVILORD,
	MT_LRDSAYTR,
};

/** Contains the data related to each unique monster ID. */
const UniqueMonsterData UniqueMonstersData[] = {
	// clang-format off
// mtype,      mName,                                     mTrnName,   mlevel,  mmaxhp, mAi,                           mint,  mMinDamage,  mMaxDamage, mMagicRes,                                      monsterPack,                     customToHit,  customArmorClass, mtalkmsg
	// TRANSLATORS: Unique Monster Block start
{ MT_NGOATMC,  P_("monster", "Gharbad the Weak"),         "bsdb",          4,     120, MonsterAIID::Gharbad,             3,           8,          16, IMMUNE_LIGHTNING,                               UniqueMonsterPack::None,                   0,                 0, TEXT_GARBUD1  },
{ MT_SKING,    P_("monster", "Skeleton King"),            "genrl",         0,     240, MonsterAIID::SkeletonKing,        3,           6,          16, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,  UniqueMonsterPack::Independent,            0,                 0, TEXT_NONE     },
{ MT_COUNSLR,  P_("monster", "Zhar the Mad"),             "general",       8,     360, MonsterAIID::Zhar,                3,          16,          40, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,  UniqueMonsterPack::None,                   0,                 0, TEXT_ZHAR1    },
{ MT_BFALLSP,  P_("monster", "Snotspill"),                "bng",           4,     220, MonsterAIID::Snotspill,           3,          10,          18, RESIST_LIGHTNING,                               UniqueMonsterPack::None,                   0,                 0, TEXT_BANNER10 },
{ MT_ADVOCATE, P_("monster", "Arch-Bishop Lazarus"),      "general",       0,     600, MonsterAIID::Lazarus,             3,          30,          50, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,  UniqueMonsterPack::None,                   0,                 0, TEXT_VILE13   },
{ MT_HLSPWN,   P_("monster", "Red Vex"),                  "redv",          0,     400, MonsterAIID::LazarusSuccubus,     3,          30,          50, IMMUNE_MAGIC | RESIST_FIRE,                     UniqueMonsterPack::None,                   0,                 0, TEXT_VILE13   },
{ MT_HLSPWN,   P_("monster", "Black Jade"),               "blkjd",         0,     400, MonsterAIID::LazarusSuccubus,     3,          30,          50, IMMUNE_MAGIC |               RESIST_LIGHTNING,  UniqueMonsterPack::None,                   0,                 0, TEXT_VILE13   },
{ MT_RBLACK,   P_("monster", "Lachdanan"),                "bhka",         14,     500, MonsterAIID::Lachdanan,           3,           0,           0, 0,                                              UniqueMonsterPack::None,                   0,                 0, TEXT_VEIL9    },
{ MT_BTBLACK,  P_("monster", "Warlord of Blood"),         "general",      13,     850, MonsterAIID::Warlord,             3,          35,          50, IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,  UniqueMonsterPack::None,                   0,                 0, TEXT_WARLRD9  },
{ MT_CLEAVER,  P_("monster", "The Butcher"),              "genrl",         0,     220, MonsterAIID::Butcher,             3,           6,          12, RESIST_FIRE | RESIST_LIGHTNING,                 UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_HORKDMN,  P_("monster", "Hork Demon"),               "genrl",        19,     300, MonsterAIID::HorkDemon,           3,          20,          35, RESIST_LIGHTNING,                               UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_DEFILER,  P_("monster", "The Defiler"),              "genrl",        20,     480, MonsterAIID::SkeletonMelee,       3,          30,          40, RESIST_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING,  UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_NAKRUL,   P_("monster", "Na-Krul"),                  "genrl",         0,    1332, MonsterAIID::SkeletonMelee,       3,          40,          50, IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_TSKELAX,  P_("monster", "Bonehead Keenaxe"),         "bhka",          2,      91, MonsterAIID::SkeletonMelee,       2,           4,          10, IMMUNE_MAGIC,                                   UniqueMonsterPack::Leashed,              100,                 0, TEXT_NONE     },
{ MT_RFALLSD,  P_("monster", "Bladeskin the Slasher"),    "bsts",          2,      51, MonsterAIID::Fallen,              0,           6,          18, RESIST_FIRE,                                    UniqueMonsterPack::Leashed,                0,                45, TEXT_NONE     },
{ MT_NZOMBIE,  P_("monster", "Soulpus"),                  "general",       2,     133, MonsterAIID::Zombie,              0,           4,           8, RESIST_FIRE | RESIST_LIGHTNING,                 UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_RFALLSP,  P_("monster", "Pukerat the Unclean"),      "ptu",           2,      77, MonsterAIID::Fallen,              3,           1,           5, RESIST_FIRE,                                    UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_WSKELAX,  P_("monster", "Boneripper"),               "br",            2,      54, MonsterAIID::Bat,                 0,           6,          15, IMMUNE_MAGIC | IMMUNE_FIRE,                     UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_NZOMBIE,  P_("monster", "Rotfeast the Hungry"),      "eth",           2,      85, MonsterAIID::SkeletonMelee,       3,           4,          12, IMMUNE_MAGIC,                                   UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_DFALLSD,  P_("monster", "Gutshank the Quick"),       "gtq",           3,      66, MonsterAIID::Bat,                 2,           6,          16, RESIST_FIRE,                                    UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_TSKELSD,  P_("monster", "Brokenhead Bangshield"),    "bhbs",          3,     108, MonsterAIID::SkeletonMelee,       3,          12,          20, IMMUNE_MAGIC |               RESIST_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_YFALLSP,  P_("monster", "Bongo"),                    "bng",           3,     178, MonsterAIID::Fallen,              3,           9,          21, 0,                                              UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_BZOMBIE,  P_("monster", "Rotcarnage"),               "rcrn",          3,     102, MonsterAIID::Zombie,              3,           9,          24, IMMUNE_MAGIC |               RESIST_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                45, TEXT_NONE     },
{ MT_NSCAV,    P_("monster", "Shadowbite"),               "shbt",          2,      60, MonsterAIID::SkeletonMelee,       3,           3,          20, IMMUNE_FIRE,                                    UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_WSKELBW,  P_("monster", "Deadeye"),                  "de",            2,      49, MonsterAIID::GoatRanged,          0,           6,           9, IMMUNE_MAGIC | RESIST_FIRE,                     UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_RSKELAX,  P_("monster", "Madeye the Dead"),          "mtd",           4,      75, MonsterAIID::Bat,                 0,           9,          21, IMMUNE_MAGIC | IMMUNE_FIRE,                     UniqueMonsterPack::Leashed,                0,                30, TEXT_NONE     },
{ MT_BSCAV,    P_("monster", "El Chupacabras"),           "general",       3,     120, MonsterAIID::GoatMelee,           0,          10,          18, RESIST_FIRE,                                    UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_TSKELBW,  P_("monster", "Skullfire"),                "skfr",          3,     125, MonsterAIID::GoatRanged,          1,           6,          10, IMMUNE_FIRE,                                    UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_SNEAK,    P_("monster", "Warpskull"),                "tspo",          3,     117, MonsterAIID::Sneak,               2,           6,          18, RESIST_FIRE | RESIST_LIGHTNING,                 UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_GZOMBIE,  P_("monster", "Goretongue"),               "pmr",           3,     156, MonsterAIID::SkeletonMelee,       1,          15,          30, IMMUNE_MAGIC,                                   UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_WSCAV,    P_("monster", "Pulsecrawler"),             "bhka",          4,     150, MonsterAIID::Scavenger,           0,          16,          20, IMMUNE_FIRE | RESIST_LIGHTNING,                 UniqueMonsterPack::Leashed,                0,                45, TEXT_NONE     },
{ MT_BLINK,    P_("monster", "Moonbender"),               "general",       4,     135, MonsterAIID::Bat,                 0,           9,          27, IMMUNE_FIRE,                                    UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_BLINK,    P_("monster", "Wrathraven"),               "general",       5,     135, MonsterAIID::Bat,                 2,           9,          22, IMMUNE_FIRE,                                    UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_YSCAV,    P_("monster", "Spineeater"),               "general",       4,     180, MonsterAIID::Scavenger,           1,          18,          25, IMMUNE_LIGHTNING,                               UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_RSKELBW,  P_("monster", "Blackash the Burning"),     "bashtb",        4,     120, MonsterAIID::GoatRanged,          0,           6,          16, IMMUNE_MAGIC | IMMUNE_FIRE,                     UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_BFALLSD,  P_("monster", "Shadowcrow"),               "general",       5,     270, MonsterAIID::Sneak,               2,          12,          25, 0,                                              UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_LRDSAYTR, P_("monster", "Blightstone the Weak"),     "bhka",          4,     360, MonsterAIID::SkeletonMelee,       0,           4,          12, IMMUNE_MAGIC |               RESIST_LIGHTNING,  UniqueMonsterPack::Leashed,               70,                 0, TEXT_NONE     },
{ MT_FAT,      P_("monster", "Bilefroth the Pit Master"), "bftp",          6,     210, MonsterAIID::Bat,                 1,          16,          23, IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_NGOATBW,  P_("monster", "Bloodskin Darkbow"),        "bsdb",          5,     207, MonsterAIID::GoatRanged,          0,           3,          16, RESIST_FIRE | RESIST_LIGHTNING,                 UniqueMonsterPack::Leashed,                0,                55, TEXT_NONE     },
{ MT_GLOOM,    P_("monster", "Foulwing"),                 "db",            5,     246, MonsterAIID::Rhino,               3,          12,          28, RESIST_FIRE,                                    UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_XSKELSD,  P_("monster", "Shadowdrinker"),            "shdr",          5,     300, MonsterAIID::Sneak,               1,          18,          26, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,  UniqueMonsterPack::None,                   0,                45, TEXT_NONE     },
{ MT_UNSEEN,   P_("monster", "Hazeshifter"),              "bhka",          5,     285, MonsterAIID::Sneak,               3,          18,          30, IMMUNE_LIGHTNING,                               UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_NACID,    P_("monster", "Deathspit"),                "bfds",          6,     303, MonsterAIID::AcidUnique,          0,          12,          32, RESIST_FIRE | RESIST_LIGHTNING,                 UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_RGOATMC,  P_("monster", "Bloodgutter"),              "bgbl",          6,     315, MonsterAIID::Bat,                 1,          24,          34, IMMUNE_FIRE,                                    UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_BGOATMC,  P_("monster", "Deathshade Fleshmaul"),     "dsfm",          6,     276, MonsterAIID::Rhino,               0,          12,          24, IMMUNE_MAGIC | RESIST_FIRE,                     UniqueMonsterPack::None,                   0,                65, TEXT_NONE     },
{ MT_WYRM,     P_("monster", "Warmaggot the Mad"),        "general",       6,     246, MonsterAIID::Bat,                 3,          15,          30, RESIST_LIGHTNING,                               UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_STORM,    P_("monster", "Glasskull the Jagged"),     "bhka",          7,     354, MonsterAIID::Storm,               0,          18,          30, IMMUNE_MAGIC | IMMUNE_FIRE,                     UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_RGOATBW,  P_("monster", "Blightfire"),               "blf",           7,     321, MonsterAIID::Succubus,            2,          13,          21, IMMUNE_FIRE,                                    UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_GARGOYLE, P_("monster", "Nightwing the Cold"),       "general",       7,     342, MonsterAIID::Bat,                 1,          18,          26, IMMUNE_MAGIC |               RESIST_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_GGOATBW,  P_("monster", "Gorestone"),                "general",       7,     303, MonsterAIID::GoatRanged,          1,          15,          28, RESIST_LIGHTNING,                               UniqueMonsterPack::Leashed,               70,                 0, TEXT_NONE     },
{ MT_BMAGMA,   P_("monster", "Bronzefist Firestone"),     "general",       8,     360, MonsterAIID::Magma,               0,          30,          36, IMMUNE_MAGIC | RESIST_FIRE,                     UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_INCIN,    P_("monster", "Wrathfire the Doomed"),     "wftd",          8,     270, MonsterAIID::SkeletonMelee,       2,          20,          30, IMMUNE_MAGIC | RESIST_FIRE |  RESIST_LIGHTNING, UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_NMAGMA,   P_("monster", "Firewound the Grim"),       "bhka",          8,     303, MonsterAIID::Magma,               0,          18,          22, IMMUNE_MAGIC | RESIST_FIRE,                     UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_MUDMAN,   P_("monster", "Baron Sludge"),             "bsm",           8,     315, MonsterAIID::Sneak,               3,          25,          34, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                75, TEXT_NONE     },
{ MT_GGOATMC,  P_("monster", "Blighthorn Steelmace"),     "bhsm",          7,     250, MonsterAIID::Rhino,               0,          20,          28, RESIST_LIGHTNING,                               UniqueMonsterPack::Leashed,                0,                45, TEXT_NONE     },
{ MT_RACID,    P_("monster", "Chaoshowler"),              "general",       8,     240, MonsterAIID::AcidUnique,          0,          12,          20, 0,                                              UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_REDDTH,   P_("monster", "Doomgrin the Rotting"),     "general",       8,     405, MonsterAIID::Storm,               3,          25,          50, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_FLAMLRD,  P_("monster", "Madburner"),                "general",       9,     270, MonsterAIID::Storm,               0,          20,          40, IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_LTCHDMN,  P_("monster", "Bonesaw the Litch"),        "general",       9,     495, MonsterAIID::Storm,               2,          30,          55, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_MUDRUN,   P_("monster", "Breakspine"),               "general",       9,     351, MonsterAIID::Rhino,               0,          25,          34, RESIST_FIRE,                                    UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_REDDTH,   P_("monster", "Devilskull Sharpbone"),     "general",       9,     444, MonsterAIID::Storm,               1,          25,          40, IMMUNE_FIRE,                                    UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_STORM,    P_("monster", "Brokenstorm"),              "general",       9,     411, MonsterAIID::Storm,               2,          25,          36, IMMUNE_LIGHTNING,                               UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_RSTORM,   P_("monster", "Stormbane"),                "general",       9,     555, MonsterAIID::Storm,               3,          30,          30, IMMUNE_LIGHTNING,                               UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_TOAD,     P_("monster", "Oozedrool"),                "general",       9,     483, MonsterAIID::Fat,                 3,          25,          30, RESIST_LIGHTNING,                               UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_BLOODCLW, P_("monster", "Goldblight of the Flame"),  "general",      10,     405, MonsterAIID::Gargoyle,            0,          15,          35, IMMUNE_MAGIC | IMMUNE_FIRE,                     UniqueMonsterPack::Leashed,                0,                80, TEXT_NONE     },
{ MT_OBLORD,   P_("monster", "Blackstorm"),               "general",      10,     525, MonsterAIID::Rhino,               3,          20,          40, IMMUNE_MAGIC |               IMMUNE_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                90, TEXT_NONE     },
{ MT_RACID,    P_("monster", "Plaguewrath"),              "general",      10,     450, MonsterAIID::AcidUnique,          2,          20,          30, IMMUNE_MAGIC | RESIST_FIRE,                     UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_RSTORM,   P_("monster", "The Flayer"),               "general",      10,     501, MonsterAIID::Storm,               1,          20,          35, RESIST_MAGIC | RESIST_FIRE | IMMUNE_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_FROSTC,   P_("monster", "Bluehorn"),                 "general",      11,     477, MonsterAIID::Rhino,               1,          25,          30, IMMUNE_MAGIC | RESIST_FIRE,                     UniqueMonsterPack::Leashed,                0,                90, TEXT_NONE     },
{ MT_HELLBURN, P_("monster", "Warpfire Hellspawn"),       "general",      11,     525, MonsterAIID::FireMan,             3,          10,          40, RESIST_MAGIC | IMMUNE_FIRE,                     UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_NSNAKE,   P_("monster", "Fangspeir"),                "general",      11,     444, MonsterAIID::SkeletonMelee,       1,          15,          32, IMMUNE_FIRE,                                    UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_UDEDBLRG, P_("monster", "Festerskull"),              "general",      11,     600, MonsterAIID::Storm,               2,          15,          30, IMMUNE_MAGIC,                                   UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_NBLACK,   P_("monster", "Lionskull the Bent"),       "general",      12,     525, MonsterAIID::SkeletonMelee,       2,          25,          25, IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_COUNSLR,  P_("monster", "Blacktongue"),              "general",      12,     360, MonsterAIID::Counselor,           3,          15,          30, RESIST_FIRE,                                    UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_DEATHW,   P_("monster", "Viletouch"),                "general",      12,     525, MonsterAIID::Gargoyle,            3,          20,          40, IMMUNE_LIGHTNING,                               UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_RSNAKE,   P_("monster", "Viperflame"),               "general",      12,     570, MonsterAIID::SkeletonMelee,       1,          25,          35, IMMUNE_FIRE | RESIST_LIGHTNING,                 UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_BSNAKE,   P_("monster", "Fangskin"),                 "bhka",         14,     681, MonsterAIID::SkeletonMelee,       2,          15,          50, IMMUNE_MAGIC |               RESIST_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_SUCCUBUS, P_("monster", "Witchfire the Unholy"),     "general",      12,     444, MonsterAIID::Succubus,            3,          10,          20, IMMUNE_MAGIC | IMMUNE_FIRE | RESIST_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_BALROG,   P_("monster", "Blackskull"),               "bhka",         13,     750, MonsterAIID::SkeletonMelee,       3,          25,          40, IMMUNE_MAGIC |               RESIST_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_UNRAV,    P_("monster", "Soulslash"),                "general",      12,     450, MonsterAIID::SkeletonMelee,       0,          25,          25, IMMUNE_MAGIC,                                   UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_VTEXLRD,  P_("monster", "Windspawn"),                "general",      12,     711, MonsterAIID::SkeletonMelee,       1,          35,          40, IMMUNE_MAGIC | IMMUNE_FIRE,                     UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_GSNAKE,   P_("monster", "Lord of the Pit"),          "general",      13,     762, MonsterAIID::SkeletonMelee,       2,          25,          42, RESIST_FIRE,                                    UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_RTBLACK,  P_("monster", "Rustweaver"),               "general",      13,     400, MonsterAIID::SkeletonMelee,       3,           1,          60, IMMUNE_MAGIC | IMMUNE_FIRE | IMMUNE_LIGHTNING,  UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_HOLOWONE, P_("monster", "Howlingire the Shade"),     "general",      13,     450, MonsterAIID::SkeletonMelee,       2,          40,          75, RESIST_FIRE | RESIST_LIGHTNING,                 UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_MAEL,     P_("monster", "Doomcloud"),                "general",      13,     612, MonsterAIID::Storm,               1,           1,          60, RESIST_FIRE | IMMUNE_LIGHTNING,                 UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_PAINMSTR, P_("monster", "Bloodmoon Soulfire"),       "general",      13,     684, MonsterAIID::SkeletonMelee,       1,          15,          40, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_SNOWWICH, P_("monster", "Witchmoon"),                "general",      13,     310, MonsterAIID::Succubus,            3,          30,          40, RESIST_LIGHTNING,                               UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_VTEXLRD,  P_("monster", "Gorefeast"),                "general",      13,     771, MonsterAIID::SkeletonMelee,       3,          20,          55, RESIST_FIRE,                                    UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_RTBLACK,  P_("monster", "Graywar the Slayer"),       "general",      14,     672, MonsterAIID::SkeletonMelee,       1,          30,          50, RESIST_LIGHTNING,                               UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_MAGISTR,  P_("monster", "Dreadjudge"),               "general",      14,     540, MonsterAIID::Counselor,           1,          30,          40, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_HLSPWN,   P_("monster", "Stareye the Witch"),        "general",      14,     726, MonsterAIID::Succubus,            2,          30,          50, IMMUNE_FIRE,                                    UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_BTBLACK,  P_("monster", "Steelskull the Hunter"),    "general",      14,     831, MonsterAIID::SkeletonMelee,       3,          40,          50, RESIST_LIGHTNING,                               UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_RBLACK,   P_("monster", "Sir Gorash"),               "general",      16,    1050, MonsterAIID::SkeletonMelee,       1,          20,          60, 0,                                              UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_CABALIST, P_("monster", "The Vizier"),               "general",      15,     850, MonsterAIID::Counselor,           2,          25,          40, IMMUNE_FIRE,                                    UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_REALWEAV, P_("monster", "Zamphir"),                  "general",      15,     891, MonsterAIID::SkeletonMelee,       2,          30,          50, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_HLSPWN,   P_("monster", "Bloodlust"),                "general",      15,     825, MonsterAIID::Succubus,            1,          20,          55, IMMUNE_MAGIC |               IMMUNE_LIGHTNING,  UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_HLSPWN,   P_("monster", "Webwidow"),                 "general",      16,     774, MonsterAIID::Succubus,            1,          20,          50, IMMUNE_MAGIC | IMMUNE_FIRE,                     UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_SOLBRNR,  P_("monster", "Fleshdancer"),              "general",      16,     999, MonsterAIID::Succubus,            3,          30,          50, IMMUNE_MAGIC | RESIST_FIRE,                     UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
{ MT_OBLORD,   P_("monster", "Grimspike"),                "general",      19,     534, MonsterAIID::Sneak,               1,          25,          40, IMMUNE_MAGIC | RESIST_FIRE,                     UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
// TRANSLATORS: Unique Monster Block end
{ MT_STORML,   P_("monster", "Doomlock"),                 "general",      28,     534, MonsterAIID::Sneak,               1,          35,          55, IMMUNE_MAGIC | RESIST_FIRE | RESIST_LIGHTNING,  UniqueMonsterPack::Leashed,                0,                 0, TEXT_NONE     },
{ MT_INVALID,  nullptr,                                   nullptr,         0,       0, MonsterAIID::Invalid,             0,           0,           0, 0,                                              UniqueMonsterPack::None,                   0,                 0, TEXT_NONE     },
	// clang-format on
};

} // namespace devilution
