// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package comprehendiface provides an interface to enable mocking the Amazon Comprehend service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package comprehendiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/comprehend"
)

// ComprehendAPI provides an interface to enable mocking the
// comprehend.Comprehend service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Comprehend.
//	func myFunc(svc comprehendiface.ComprehendAPI) bool {
//	    // Make svc.BatchDetectDominantLanguage request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := comprehend.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockComprehendClient struct {
//	    comprehendiface.ComprehendAPI
//	}
//	func (m *mockComprehendClient) BatchDetectDominantLanguage(input *comprehend.BatchDetectDominantLanguageInput) (*comprehend.BatchDetectDominantLanguageOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockComprehendClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ComprehendAPI interface {
	BatchDetectDominantLanguage(*comprehend.BatchDetectDominantLanguageInput) (*comprehend.BatchDetectDominantLanguageOutput, error)
	BatchDetectDominantLanguageWithContext(aws.Context, *comprehend.BatchDetectDominantLanguageInput, ...request.Option) (*comprehend.BatchDetectDominantLanguageOutput, error)
	BatchDetectDominantLanguageRequest(*comprehend.BatchDetectDominantLanguageInput) (*request.Request, *comprehend.BatchDetectDominantLanguageOutput)

	BatchDetectEntities(*comprehend.BatchDetectEntitiesInput) (*comprehend.BatchDetectEntitiesOutput, error)
	BatchDetectEntitiesWithContext(aws.Context, *comprehend.BatchDetectEntitiesInput, ...request.Option) (*comprehend.BatchDetectEntitiesOutput, error)
	BatchDetectEntitiesRequest(*comprehend.BatchDetectEntitiesInput) (*request.Request, *comprehend.BatchDetectEntitiesOutput)

	BatchDetectKeyPhrases(*comprehend.BatchDetectKeyPhrasesInput) (*comprehend.BatchDetectKeyPhrasesOutput, error)
	BatchDetectKeyPhrasesWithContext(aws.Context, *comprehend.BatchDetectKeyPhrasesInput, ...request.Option) (*comprehend.BatchDetectKeyPhrasesOutput, error)
	BatchDetectKeyPhrasesRequest(*comprehend.BatchDetectKeyPhrasesInput) (*request.Request, *comprehend.BatchDetectKeyPhrasesOutput)

	BatchDetectSentiment(*comprehend.BatchDetectSentimentInput) (*comprehend.BatchDetectSentimentOutput, error)
	BatchDetectSentimentWithContext(aws.Context, *comprehend.BatchDetectSentimentInput, ...request.Option) (*comprehend.BatchDetectSentimentOutput, error)
	BatchDetectSentimentRequest(*comprehend.BatchDetectSentimentInput) (*request.Request, *comprehend.BatchDetectSentimentOutput)

	BatchDetectSyntax(*comprehend.BatchDetectSyntaxInput) (*comprehend.BatchDetectSyntaxOutput, error)
	BatchDetectSyntaxWithContext(aws.Context, *comprehend.BatchDetectSyntaxInput, ...request.Option) (*comprehend.BatchDetectSyntaxOutput, error)
	BatchDetectSyntaxRequest(*comprehend.BatchDetectSyntaxInput) (*request.Request, *comprehend.BatchDetectSyntaxOutput)

	BatchDetectTargetedSentiment(*comprehend.BatchDetectTargetedSentimentInput) (*comprehend.BatchDetectTargetedSentimentOutput, error)
	BatchDetectTargetedSentimentWithContext(aws.Context, *comprehend.BatchDetectTargetedSentimentInput, ...request.Option) (*comprehend.BatchDetectTargetedSentimentOutput, error)
	BatchDetectTargetedSentimentRequest(*comprehend.BatchDetectTargetedSentimentInput) (*request.Request, *comprehend.BatchDetectTargetedSentimentOutput)

	ClassifyDocument(*comprehend.ClassifyDocumentInput) (*comprehend.ClassifyDocumentOutput, error)
	ClassifyDocumentWithContext(aws.Context, *comprehend.ClassifyDocumentInput, ...request.Option) (*comprehend.ClassifyDocumentOutput, error)
	ClassifyDocumentRequest(*comprehend.ClassifyDocumentInput) (*request.Request, *comprehend.ClassifyDocumentOutput)

	ContainsPiiEntities(*comprehend.ContainsPiiEntitiesInput) (*comprehend.ContainsPiiEntitiesOutput, error)
	ContainsPiiEntitiesWithContext(aws.Context, *comprehend.ContainsPiiEntitiesInput, ...request.Option) (*comprehend.ContainsPiiEntitiesOutput, error)
	ContainsPiiEntitiesRequest(*comprehend.ContainsPiiEntitiesInput) (*request.Request, *comprehend.ContainsPiiEntitiesOutput)

	CreateDataset(*comprehend.CreateDatasetInput) (*comprehend.CreateDatasetOutput, error)
	CreateDatasetWithContext(aws.Context, *comprehend.CreateDatasetInput, ...request.Option) (*comprehend.CreateDatasetOutput, error)
	CreateDatasetRequest(*comprehend.CreateDatasetInput) (*request.Request, *comprehend.CreateDatasetOutput)

	CreateDocumentClassifier(*comprehend.CreateDocumentClassifierInput) (*comprehend.CreateDocumentClassifierOutput, error)
	CreateDocumentClassifierWithContext(aws.Context, *comprehend.CreateDocumentClassifierInput, ...request.Option) (*comprehend.CreateDocumentClassifierOutput, error)
	CreateDocumentClassifierRequest(*comprehend.CreateDocumentClassifierInput) (*request.Request, *comprehend.CreateDocumentClassifierOutput)

	CreateEndpoint(*comprehend.CreateEndpointInput) (*comprehend.CreateEndpointOutput, error)
	CreateEndpointWithContext(aws.Context, *comprehend.CreateEndpointInput, ...request.Option) (*comprehend.CreateEndpointOutput, error)
	CreateEndpointRequest(*comprehend.CreateEndpointInput) (*request.Request, *comprehend.CreateEndpointOutput)

	CreateEntityRecognizer(*comprehend.CreateEntityRecognizerInput) (*comprehend.CreateEntityRecognizerOutput, error)
	CreateEntityRecognizerWithContext(aws.Context, *comprehend.CreateEntityRecognizerInput, ...request.Option) (*comprehend.CreateEntityRecognizerOutput, error)
	CreateEntityRecognizerRequest(*comprehend.CreateEntityRecognizerInput) (*request.Request, *comprehend.CreateEntityRecognizerOutput)

	CreateFlywheel(*comprehend.CreateFlywheelInput) (*comprehend.CreateFlywheelOutput, error)
	CreateFlywheelWithContext(aws.Context, *comprehend.CreateFlywheelInput, ...request.Option) (*comprehend.CreateFlywheelOutput, error)
	CreateFlywheelRequest(*comprehend.CreateFlywheelInput) (*request.Request, *comprehend.CreateFlywheelOutput)

	DeleteDocumentClassifier(*comprehend.DeleteDocumentClassifierInput) (*comprehend.DeleteDocumentClassifierOutput, error)
	DeleteDocumentClassifierWithContext(aws.Context, *comprehend.DeleteDocumentClassifierInput, ...request.Option) (*comprehend.DeleteDocumentClassifierOutput, error)
	DeleteDocumentClassifierRequest(*comprehend.DeleteDocumentClassifierInput) (*request.Request, *comprehend.DeleteDocumentClassifierOutput)

	DeleteEndpoint(*comprehend.DeleteEndpointInput) (*comprehend.DeleteEndpointOutput, error)
	DeleteEndpointWithContext(aws.Context, *comprehend.DeleteEndpointInput, ...request.Option) (*comprehend.DeleteEndpointOutput, error)
	DeleteEndpointRequest(*comprehend.DeleteEndpointInput) (*request.Request, *comprehend.DeleteEndpointOutput)

	DeleteEntityRecognizer(*comprehend.DeleteEntityRecognizerInput) (*comprehend.DeleteEntityRecognizerOutput, error)
	DeleteEntityRecognizerWithContext(aws.Context, *comprehend.DeleteEntityRecognizerInput, ...request.Option) (*comprehend.DeleteEntityRecognizerOutput, error)
	DeleteEntityRecognizerRequest(*comprehend.DeleteEntityRecognizerInput) (*request.Request, *comprehend.DeleteEntityRecognizerOutput)

	DeleteFlywheel(*comprehend.DeleteFlywheelInput) (*comprehend.DeleteFlywheelOutput, error)
	DeleteFlywheelWithContext(aws.Context, *comprehend.DeleteFlywheelInput, ...request.Option) (*comprehend.DeleteFlywheelOutput, error)
	DeleteFlywheelRequest(*comprehend.DeleteFlywheelInput) (*request.Request, *comprehend.DeleteFlywheelOutput)

	DeleteResourcePolicy(*comprehend.DeleteResourcePolicyInput) (*comprehend.DeleteResourcePolicyOutput, error)
	DeleteResourcePolicyWithContext(aws.Context, *comprehend.DeleteResourcePolicyInput, ...request.Option) (*comprehend.DeleteResourcePolicyOutput, error)
	DeleteResourcePolicyRequest(*comprehend.DeleteResourcePolicyInput) (*request.Request, *comprehend.DeleteResourcePolicyOutput)

	DescribeDataset(*comprehend.DescribeDatasetInput) (*comprehend.DescribeDatasetOutput, error)
	DescribeDatasetWithContext(aws.Context, *comprehend.DescribeDatasetInput, ...request.Option) (*comprehend.DescribeDatasetOutput, error)
	DescribeDatasetRequest(*comprehend.DescribeDatasetInput) (*request.Request, *comprehend.DescribeDatasetOutput)

	DescribeDocumentClassificationJob(*comprehend.DescribeDocumentClassificationJobInput) (*comprehend.DescribeDocumentClassificationJobOutput, error)
	DescribeDocumentClassificationJobWithContext(aws.Context, *comprehend.DescribeDocumentClassificationJobInput, ...request.Option) (*comprehend.DescribeDocumentClassificationJobOutput, error)
	DescribeDocumentClassificationJobRequest(*comprehend.DescribeDocumentClassificationJobInput) (*request.Request, *comprehend.DescribeDocumentClassificationJobOutput)

	DescribeDocumentClassifier(*comprehend.DescribeDocumentClassifierInput) (*comprehend.DescribeDocumentClassifierOutput, error)
	DescribeDocumentClassifierWithContext(aws.Context, *comprehend.DescribeDocumentClassifierInput, ...request.Option) (*comprehend.DescribeDocumentClassifierOutput, error)
	DescribeDocumentClassifierRequest(*comprehend.DescribeDocumentClassifierInput) (*request.Request, *comprehend.DescribeDocumentClassifierOutput)

	DescribeDominantLanguageDetectionJob(*comprehend.DescribeDominantLanguageDetectionJobInput) (*comprehend.DescribeDominantLanguageDetectionJobOutput, error)
	DescribeDominantLanguageDetectionJobWithContext(aws.Context, *comprehend.DescribeDominantLanguageDetectionJobInput, ...request.Option) (*comprehend.DescribeDominantLanguageDetectionJobOutput, error)
	DescribeDominantLanguageDetectionJobRequest(*comprehend.DescribeDominantLanguageDetectionJobInput) (*request.Request, *comprehend.DescribeDominantLanguageDetectionJobOutput)

	DescribeEndpoint(*comprehend.DescribeEndpointInput) (*comprehend.DescribeEndpointOutput, error)
	DescribeEndpointWithContext(aws.Context, *comprehend.DescribeEndpointInput, ...request.Option) (*comprehend.DescribeEndpointOutput, error)
	DescribeEndpointRequest(*comprehend.DescribeEndpointInput) (*request.Request, *comprehend.DescribeEndpointOutput)

	DescribeEntitiesDetectionJob(*comprehend.DescribeEntitiesDetectionJobInput) (*comprehend.DescribeEntitiesDetectionJobOutput, error)
	DescribeEntitiesDetectionJobWithContext(aws.Context, *comprehend.DescribeEntitiesDetectionJobInput, ...request.Option) (*comprehend.DescribeEntitiesDetectionJobOutput, error)
	DescribeEntitiesDetectionJobRequest(*comprehend.DescribeEntitiesDetectionJobInput) (*request.Request, *comprehend.DescribeEntitiesDetectionJobOutput)

	DescribeEntityRecognizer(*comprehend.DescribeEntityRecognizerInput) (*comprehend.DescribeEntityRecognizerOutput, error)
	DescribeEntityRecognizerWithContext(aws.Context, *comprehend.DescribeEntityRecognizerInput, ...request.Option) (*comprehend.DescribeEntityRecognizerOutput, error)
	DescribeEntityRecognizerRequest(*comprehend.DescribeEntityRecognizerInput) (*request.Request, *comprehend.DescribeEntityRecognizerOutput)

	DescribeEventsDetectionJob(*comprehend.DescribeEventsDetectionJobInput) (*comprehend.DescribeEventsDetectionJobOutput, error)
	DescribeEventsDetectionJobWithContext(aws.Context, *comprehend.DescribeEventsDetectionJobInput, ...request.Option) (*comprehend.DescribeEventsDetectionJobOutput, error)
	DescribeEventsDetectionJobRequest(*comprehend.DescribeEventsDetectionJobInput) (*request.Request, *comprehend.DescribeEventsDetectionJobOutput)

	DescribeFlywheel(*comprehend.DescribeFlywheelInput) (*comprehend.DescribeFlywheelOutput, error)
	DescribeFlywheelWithContext(aws.Context, *comprehend.DescribeFlywheelInput, ...request.Option) (*comprehend.DescribeFlywheelOutput, error)
	DescribeFlywheelRequest(*comprehend.DescribeFlywheelInput) (*request.Request, *comprehend.DescribeFlywheelOutput)

	DescribeFlywheelIteration(*comprehend.DescribeFlywheelIterationInput) (*comprehend.DescribeFlywheelIterationOutput, error)
	DescribeFlywheelIterationWithContext(aws.Context, *comprehend.DescribeFlywheelIterationInput, ...request.Option) (*comprehend.DescribeFlywheelIterationOutput, error)
	DescribeFlywheelIterationRequest(*comprehend.DescribeFlywheelIterationInput) (*request.Request, *comprehend.DescribeFlywheelIterationOutput)

	DescribeKeyPhrasesDetectionJob(*comprehend.DescribeKeyPhrasesDetectionJobInput) (*comprehend.DescribeKeyPhrasesDetectionJobOutput, error)
	DescribeKeyPhrasesDetectionJobWithContext(aws.Context, *comprehend.DescribeKeyPhrasesDetectionJobInput, ...request.Option) (*comprehend.DescribeKeyPhrasesDetectionJobOutput, error)
	DescribeKeyPhrasesDetectionJobRequest(*comprehend.DescribeKeyPhrasesDetectionJobInput) (*request.Request, *comprehend.DescribeKeyPhrasesDetectionJobOutput)

	DescribePiiEntitiesDetectionJob(*comprehend.DescribePiiEntitiesDetectionJobInput) (*comprehend.DescribePiiEntitiesDetectionJobOutput, error)
	DescribePiiEntitiesDetectionJobWithContext(aws.Context, *comprehend.DescribePiiEntitiesDetectionJobInput, ...request.Option) (*comprehend.DescribePiiEntitiesDetectionJobOutput, error)
	DescribePiiEntitiesDetectionJobRequest(*comprehend.DescribePiiEntitiesDetectionJobInput) (*request.Request, *comprehend.DescribePiiEntitiesDetectionJobOutput)

	DescribeResourcePolicy(*comprehend.DescribeResourcePolicyInput) (*comprehend.DescribeResourcePolicyOutput, error)
	DescribeResourcePolicyWithContext(aws.Context, *comprehend.DescribeResourcePolicyInput, ...request.Option) (*comprehend.DescribeResourcePolicyOutput, error)
	DescribeResourcePolicyRequest(*comprehend.DescribeResourcePolicyInput) (*request.Request, *comprehend.DescribeResourcePolicyOutput)

	DescribeSentimentDetectionJob(*comprehend.DescribeSentimentDetectionJobInput) (*comprehend.DescribeSentimentDetectionJobOutput, error)
	DescribeSentimentDetectionJobWithContext(aws.Context, *comprehend.DescribeSentimentDetectionJobInput, ...request.Option) (*comprehend.DescribeSentimentDetectionJobOutput, error)
	DescribeSentimentDetectionJobRequest(*comprehend.DescribeSentimentDetectionJobInput) (*request.Request, *comprehend.DescribeSentimentDetectionJobOutput)

	DescribeTargetedSentimentDetectionJob(*comprehend.DescribeTargetedSentimentDetectionJobInput) (*comprehend.DescribeTargetedSentimentDetectionJobOutput, error)
	DescribeTargetedSentimentDetectionJobWithContext(aws.Context, *comprehend.DescribeTargetedSentimentDetectionJobInput, ...request.Option) (*comprehend.DescribeTargetedSentimentDetectionJobOutput, error)
	DescribeTargetedSentimentDetectionJobRequest(*comprehend.DescribeTargetedSentimentDetectionJobInput) (*request.Request, *comprehend.DescribeTargetedSentimentDetectionJobOutput)

	DescribeTopicsDetectionJob(*comprehend.DescribeTopicsDetectionJobInput) (*comprehend.DescribeTopicsDetectionJobOutput, error)
	DescribeTopicsDetectionJobWithContext(aws.Context, *comprehend.DescribeTopicsDetectionJobInput, ...request.Option) (*comprehend.DescribeTopicsDetectionJobOutput, error)
	DescribeTopicsDetectionJobRequest(*comprehend.DescribeTopicsDetectionJobInput) (*request.Request, *comprehend.DescribeTopicsDetectionJobOutput)

	DetectDominantLanguage(*comprehend.DetectDominantLanguageInput) (*comprehend.DetectDominantLanguageOutput, error)
	DetectDominantLanguageWithContext(aws.Context, *comprehend.DetectDominantLanguageInput, ...request.Option) (*comprehend.DetectDominantLanguageOutput, error)
	DetectDominantLanguageRequest(*comprehend.DetectDominantLanguageInput) (*request.Request, *comprehend.DetectDominantLanguageOutput)

	DetectEntities(*comprehend.DetectEntitiesInput) (*comprehend.DetectEntitiesOutput, error)
	DetectEntitiesWithContext(aws.Context, *comprehend.DetectEntitiesInput, ...request.Option) (*comprehend.DetectEntitiesOutput, error)
	DetectEntitiesRequest(*comprehend.DetectEntitiesInput) (*request.Request, *comprehend.DetectEntitiesOutput)

	DetectKeyPhrases(*comprehend.DetectKeyPhrasesInput) (*comprehend.DetectKeyPhrasesOutput, error)
	DetectKeyPhrasesWithContext(aws.Context, *comprehend.DetectKeyPhrasesInput, ...request.Option) (*comprehend.DetectKeyPhrasesOutput, error)
	DetectKeyPhrasesRequest(*comprehend.DetectKeyPhrasesInput) (*request.Request, *comprehend.DetectKeyPhrasesOutput)

	DetectPiiEntities(*comprehend.DetectPiiEntitiesInput) (*comprehend.DetectPiiEntitiesOutput, error)
	DetectPiiEntitiesWithContext(aws.Context, *comprehend.DetectPiiEntitiesInput, ...request.Option) (*comprehend.DetectPiiEntitiesOutput, error)
	DetectPiiEntitiesRequest(*comprehend.DetectPiiEntitiesInput) (*request.Request, *comprehend.DetectPiiEntitiesOutput)

	DetectSentiment(*comprehend.DetectSentimentInput) (*comprehend.DetectSentimentOutput, error)
	DetectSentimentWithContext(aws.Context, *comprehend.DetectSentimentInput, ...request.Option) (*comprehend.DetectSentimentOutput, error)
	DetectSentimentRequest(*comprehend.DetectSentimentInput) (*request.Request, *comprehend.DetectSentimentOutput)

	DetectSyntax(*comprehend.DetectSyntaxInput) (*comprehend.DetectSyntaxOutput, error)
	DetectSyntaxWithContext(aws.Context, *comprehend.DetectSyntaxInput, ...request.Option) (*comprehend.DetectSyntaxOutput, error)
	DetectSyntaxRequest(*comprehend.DetectSyntaxInput) (*request.Request, *comprehend.DetectSyntaxOutput)

	DetectTargetedSentiment(*comprehend.DetectTargetedSentimentInput) (*comprehend.DetectTargetedSentimentOutput, error)
	DetectTargetedSentimentWithContext(aws.Context, *comprehend.DetectTargetedSentimentInput, ...request.Option) (*comprehend.DetectTargetedSentimentOutput, error)
	DetectTargetedSentimentRequest(*comprehend.DetectTargetedSentimentInput) (*request.Request, *comprehend.DetectTargetedSentimentOutput)

	ImportModel(*comprehend.ImportModelInput) (*comprehend.ImportModelOutput, error)
	ImportModelWithContext(aws.Context, *comprehend.ImportModelInput, ...request.Option) (*comprehend.ImportModelOutput, error)
	ImportModelRequest(*comprehend.ImportModelInput) (*request.Request, *comprehend.ImportModelOutput)

	ListDatasets(*comprehend.ListDatasetsInput) (*comprehend.ListDatasetsOutput, error)
	ListDatasetsWithContext(aws.Context, *comprehend.ListDatasetsInput, ...request.Option) (*comprehend.ListDatasetsOutput, error)
	ListDatasetsRequest(*comprehend.ListDatasetsInput) (*request.Request, *comprehend.ListDatasetsOutput)

	ListDatasetsPages(*comprehend.ListDatasetsInput, func(*comprehend.ListDatasetsOutput, bool) bool) error
	ListDatasetsPagesWithContext(aws.Context, *comprehend.ListDatasetsInput, func(*comprehend.ListDatasetsOutput, bool) bool, ...request.Option) error

	ListDocumentClassificationJobs(*comprehend.ListDocumentClassificationJobsInput) (*comprehend.ListDocumentClassificationJobsOutput, error)
	ListDocumentClassificationJobsWithContext(aws.Context, *comprehend.ListDocumentClassificationJobsInput, ...request.Option) (*comprehend.ListDocumentClassificationJobsOutput, error)
	ListDocumentClassificationJobsRequest(*comprehend.ListDocumentClassificationJobsInput) (*request.Request, *comprehend.ListDocumentClassificationJobsOutput)

	ListDocumentClassificationJobsPages(*comprehend.ListDocumentClassificationJobsInput, func(*comprehend.ListDocumentClassificationJobsOutput, bool) bool) error
	ListDocumentClassificationJobsPagesWithContext(aws.Context, *comprehend.ListDocumentClassificationJobsInput, func(*comprehend.ListDocumentClassificationJobsOutput, bool) bool, ...request.Option) error

	ListDocumentClassifierSummaries(*comprehend.ListDocumentClassifierSummariesInput) (*comprehend.ListDocumentClassifierSummariesOutput, error)
	ListDocumentClassifierSummariesWithContext(aws.Context, *comprehend.ListDocumentClassifierSummariesInput, ...request.Option) (*comprehend.ListDocumentClassifierSummariesOutput, error)
	ListDocumentClassifierSummariesRequest(*comprehend.ListDocumentClassifierSummariesInput) (*request.Request, *comprehend.ListDocumentClassifierSummariesOutput)

	ListDocumentClassifierSummariesPages(*comprehend.ListDocumentClassifierSummariesInput, func(*comprehend.ListDocumentClassifierSummariesOutput, bool) bool) error
	ListDocumentClassifierSummariesPagesWithContext(aws.Context, *comprehend.ListDocumentClassifierSummariesInput, func(*comprehend.ListDocumentClassifierSummariesOutput, bool) bool, ...request.Option) error

	ListDocumentClassifiers(*comprehend.ListDocumentClassifiersInput) (*comprehend.ListDocumentClassifiersOutput, error)
	ListDocumentClassifiersWithContext(aws.Context, *comprehend.ListDocumentClassifiersInput, ...request.Option) (*comprehend.ListDocumentClassifiersOutput, error)
	ListDocumentClassifiersRequest(*comprehend.ListDocumentClassifiersInput) (*request.Request, *comprehend.ListDocumentClassifiersOutput)

	ListDocumentClassifiersPages(*comprehend.ListDocumentClassifiersInput, func(*comprehend.ListDocumentClassifiersOutput, bool) bool) error
	ListDocumentClassifiersPagesWithContext(aws.Context, *comprehend.ListDocumentClassifiersInput, func(*comprehend.ListDocumentClassifiersOutput, bool) bool, ...request.Option) error

	ListDominantLanguageDetectionJobs(*comprehend.ListDominantLanguageDetectionJobsInput) (*comprehend.ListDominantLanguageDetectionJobsOutput, error)
	ListDominantLanguageDetectionJobsWithContext(aws.Context, *comprehend.ListDominantLanguageDetectionJobsInput, ...request.Option) (*comprehend.ListDominantLanguageDetectionJobsOutput, error)
	ListDominantLanguageDetectionJobsRequest(*comprehend.ListDominantLanguageDetectionJobsInput) (*request.Request, *comprehend.ListDominantLanguageDetectionJobsOutput)

	ListDominantLanguageDetectionJobsPages(*comprehend.ListDominantLanguageDetectionJobsInput, func(*comprehend.ListDominantLanguageDetectionJobsOutput, bool) bool) error
	ListDominantLanguageDetectionJobsPagesWithContext(aws.Context, *comprehend.ListDominantLanguageDetectionJobsInput, func(*comprehend.ListDominantLanguageDetectionJobsOutput, bool) bool, ...request.Option) error

	ListEndpoints(*comprehend.ListEndpointsInput) (*comprehend.ListEndpointsOutput, error)
	ListEndpointsWithContext(aws.Context, *comprehend.ListEndpointsInput, ...request.Option) (*comprehend.ListEndpointsOutput, error)
	ListEndpointsRequest(*comprehend.ListEndpointsInput) (*request.Request, *comprehend.ListEndpointsOutput)

	ListEndpointsPages(*comprehend.ListEndpointsInput, func(*comprehend.ListEndpointsOutput, bool) bool) error
	ListEndpointsPagesWithContext(aws.Context, *comprehend.ListEndpointsInput, func(*comprehend.ListEndpointsOutput, bool) bool, ...request.Option) error

	ListEntitiesDetectionJobs(*comprehend.ListEntitiesDetectionJobsInput) (*comprehend.ListEntitiesDetectionJobsOutput, error)
	ListEntitiesDetectionJobsWithContext(aws.Context, *comprehend.ListEntitiesDetectionJobsInput, ...request.Option) (*comprehend.ListEntitiesDetectionJobsOutput, error)
	ListEntitiesDetectionJobsRequest(*comprehend.ListEntitiesDetectionJobsInput) (*request.Request, *comprehend.ListEntitiesDetectionJobsOutput)

	ListEntitiesDetectionJobsPages(*comprehend.ListEntitiesDetectionJobsInput, func(*comprehend.ListEntitiesDetectionJobsOutput, bool) bool) error
	ListEntitiesDetectionJobsPagesWithContext(aws.Context, *comprehend.ListEntitiesDetectionJobsInput, func(*comprehend.ListEntitiesDetectionJobsOutput, bool) bool, ...request.Option) error

	ListEntityRecognizerSummaries(*comprehend.ListEntityRecognizerSummariesInput) (*comprehend.ListEntityRecognizerSummariesOutput, error)
	ListEntityRecognizerSummariesWithContext(aws.Context, *comprehend.ListEntityRecognizerSummariesInput, ...request.Option) (*comprehend.ListEntityRecognizerSummariesOutput, error)
	ListEntityRecognizerSummariesRequest(*comprehend.ListEntityRecognizerSummariesInput) (*request.Request, *comprehend.ListEntityRecognizerSummariesOutput)

	ListEntityRecognizerSummariesPages(*comprehend.ListEntityRecognizerSummariesInput, func(*comprehend.ListEntityRecognizerSummariesOutput, bool) bool) error
	ListEntityRecognizerSummariesPagesWithContext(aws.Context, *comprehend.ListEntityRecognizerSummariesInput, func(*comprehend.ListEntityRecognizerSummariesOutput, bool) bool, ...request.Option) error

	ListEntityRecognizers(*comprehend.ListEntityRecognizersInput) (*comprehend.ListEntityRecognizersOutput, error)
	ListEntityRecognizersWithContext(aws.Context, *comprehend.ListEntityRecognizersInput, ...request.Option) (*comprehend.ListEntityRecognizersOutput, error)
	ListEntityRecognizersRequest(*comprehend.ListEntityRecognizersInput) (*request.Request, *comprehend.ListEntityRecognizersOutput)

	ListEntityRecognizersPages(*comprehend.ListEntityRecognizersInput, func(*comprehend.ListEntityRecognizersOutput, bool) bool) error
	ListEntityRecognizersPagesWithContext(aws.Context, *comprehend.ListEntityRecognizersInput, func(*comprehend.ListEntityRecognizersOutput, bool) bool, ...request.Option) error

	ListEventsDetectionJobs(*comprehend.ListEventsDetectionJobsInput) (*comprehend.ListEventsDetectionJobsOutput, error)
	ListEventsDetectionJobsWithContext(aws.Context, *comprehend.ListEventsDetectionJobsInput, ...request.Option) (*comprehend.ListEventsDetectionJobsOutput, error)
	ListEventsDetectionJobsRequest(*comprehend.ListEventsDetectionJobsInput) (*request.Request, *comprehend.ListEventsDetectionJobsOutput)

	ListEventsDetectionJobsPages(*comprehend.ListEventsDetectionJobsInput, func(*comprehend.ListEventsDetectionJobsOutput, bool) bool) error
	ListEventsDetectionJobsPagesWithContext(aws.Context, *comprehend.ListEventsDetectionJobsInput, func(*comprehend.ListEventsDetectionJobsOutput, bool) bool, ...request.Option) error

	ListFlywheelIterationHistory(*comprehend.ListFlywheelIterationHistoryInput) (*comprehend.ListFlywheelIterationHistoryOutput, error)
	ListFlywheelIterationHistoryWithContext(aws.Context, *comprehend.ListFlywheelIterationHistoryInput, ...request.Option) (*comprehend.ListFlywheelIterationHistoryOutput, error)
	ListFlywheelIterationHistoryRequest(*comprehend.ListFlywheelIterationHistoryInput) (*request.Request, *comprehend.ListFlywheelIterationHistoryOutput)

	ListFlywheelIterationHistoryPages(*comprehend.ListFlywheelIterationHistoryInput, func(*comprehend.ListFlywheelIterationHistoryOutput, bool) bool) error
	ListFlywheelIterationHistoryPagesWithContext(aws.Context, *comprehend.ListFlywheelIterationHistoryInput, func(*comprehend.ListFlywheelIterationHistoryOutput, bool) bool, ...request.Option) error

	ListFlywheels(*comprehend.ListFlywheelsInput) (*comprehend.ListFlywheelsOutput, error)
	ListFlywheelsWithContext(aws.Context, *comprehend.ListFlywheelsInput, ...request.Option) (*comprehend.ListFlywheelsOutput, error)
	ListFlywheelsRequest(*comprehend.ListFlywheelsInput) (*request.Request, *comprehend.ListFlywheelsOutput)

	ListFlywheelsPages(*comprehend.ListFlywheelsInput, func(*comprehend.ListFlywheelsOutput, bool) bool) error
	ListFlywheelsPagesWithContext(aws.Context, *comprehend.ListFlywheelsInput, func(*comprehend.ListFlywheelsOutput, bool) bool, ...request.Option) error

	ListKeyPhrasesDetectionJobs(*comprehend.ListKeyPhrasesDetectionJobsInput) (*comprehend.ListKeyPhrasesDetectionJobsOutput, error)
	ListKeyPhrasesDetectionJobsWithContext(aws.Context, *comprehend.ListKeyPhrasesDetectionJobsInput, ...request.Option) (*comprehend.ListKeyPhrasesDetectionJobsOutput, error)
	ListKeyPhrasesDetectionJobsRequest(*comprehend.ListKeyPhrasesDetectionJobsInput) (*request.Request, *comprehend.ListKeyPhrasesDetectionJobsOutput)

	ListKeyPhrasesDetectionJobsPages(*comprehend.ListKeyPhrasesDetectionJobsInput, func(*comprehend.ListKeyPhrasesDetectionJobsOutput, bool) bool) error
	ListKeyPhrasesDetectionJobsPagesWithContext(aws.Context, *comprehend.ListKeyPhrasesDetectionJobsInput, func(*comprehend.ListKeyPhrasesDetectionJobsOutput, bool) bool, ...request.Option) error

	ListPiiEntitiesDetectionJobs(*comprehend.ListPiiEntitiesDetectionJobsInput) (*comprehend.ListPiiEntitiesDetectionJobsOutput, error)
	ListPiiEntitiesDetectionJobsWithContext(aws.Context, *comprehend.ListPiiEntitiesDetectionJobsInput, ...request.Option) (*comprehend.ListPiiEntitiesDetectionJobsOutput, error)
	ListPiiEntitiesDetectionJobsRequest(*comprehend.ListPiiEntitiesDetectionJobsInput) (*request.Request, *comprehend.ListPiiEntitiesDetectionJobsOutput)

	ListPiiEntitiesDetectionJobsPages(*comprehend.ListPiiEntitiesDetectionJobsInput, func(*comprehend.ListPiiEntitiesDetectionJobsOutput, bool) bool) error
	ListPiiEntitiesDetectionJobsPagesWithContext(aws.Context, *comprehend.ListPiiEntitiesDetectionJobsInput, func(*comprehend.ListPiiEntitiesDetectionJobsOutput, bool) bool, ...request.Option) error

	ListSentimentDetectionJobs(*comprehend.ListSentimentDetectionJobsInput) (*comprehend.ListSentimentDetectionJobsOutput, error)
	ListSentimentDetectionJobsWithContext(aws.Context, *comprehend.ListSentimentDetectionJobsInput, ...request.Option) (*comprehend.ListSentimentDetectionJobsOutput, error)
	ListSentimentDetectionJobsRequest(*comprehend.ListSentimentDetectionJobsInput) (*request.Request, *comprehend.ListSentimentDetectionJobsOutput)

	ListSentimentDetectionJobsPages(*comprehend.ListSentimentDetectionJobsInput, func(*comprehend.ListSentimentDetectionJobsOutput, bool) bool) error
	ListSentimentDetectionJobsPagesWithContext(aws.Context, *comprehend.ListSentimentDetectionJobsInput, func(*comprehend.ListSentimentDetectionJobsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*comprehend.ListTagsForResourceInput) (*comprehend.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *comprehend.ListTagsForResourceInput, ...request.Option) (*comprehend.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*comprehend.ListTagsForResourceInput) (*request.Request, *comprehend.ListTagsForResourceOutput)

	ListTargetedSentimentDetectionJobs(*comprehend.ListTargetedSentimentDetectionJobsInput) (*comprehend.ListTargetedSentimentDetectionJobsOutput, error)
	ListTargetedSentimentDetectionJobsWithContext(aws.Context, *comprehend.ListTargetedSentimentDetectionJobsInput, ...request.Option) (*comprehend.ListTargetedSentimentDetectionJobsOutput, error)
	ListTargetedSentimentDetectionJobsRequest(*comprehend.ListTargetedSentimentDetectionJobsInput) (*request.Request, *comprehend.ListTargetedSentimentDetectionJobsOutput)

	ListTargetedSentimentDetectionJobsPages(*comprehend.ListTargetedSentimentDetectionJobsInput, func(*comprehend.ListTargetedSentimentDetectionJobsOutput, bool) bool) error
	ListTargetedSentimentDetectionJobsPagesWithContext(aws.Context, *comprehend.ListTargetedSentimentDetectionJobsInput, func(*comprehend.ListTargetedSentimentDetectionJobsOutput, bool) bool, ...request.Option) error

	ListTopicsDetectionJobs(*comprehend.ListTopicsDetectionJobsInput) (*comprehend.ListTopicsDetectionJobsOutput, error)
	ListTopicsDetectionJobsWithContext(aws.Context, *comprehend.ListTopicsDetectionJobsInput, ...request.Option) (*comprehend.ListTopicsDetectionJobsOutput, error)
	ListTopicsDetectionJobsRequest(*comprehend.ListTopicsDetectionJobsInput) (*request.Request, *comprehend.ListTopicsDetectionJobsOutput)

	ListTopicsDetectionJobsPages(*comprehend.ListTopicsDetectionJobsInput, func(*comprehend.ListTopicsDetectionJobsOutput, bool) bool) error
	ListTopicsDetectionJobsPagesWithContext(aws.Context, *comprehend.ListTopicsDetectionJobsInput, func(*comprehend.ListTopicsDetectionJobsOutput, bool) bool, ...request.Option) error

	PutResourcePolicy(*comprehend.PutResourcePolicyInput) (*comprehend.PutResourcePolicyOutput, error)
	PutResourcePolicyWithContext(aws.Context, *comprehend.PutResourcePolicyInput, ...request.Option) (*comprehend.PutResourcePolicyOutput, error)
	PutResourcePolicyRequest(*comprehend.PutResourcePolicyInput) (*request.Request, *comprehend.PutResourcePolicyOutput)

	StartDocumentClassificationJob(*comprehend.StartDocumentClassificationJobInput) (*comprehend.StartDocumentClassificationJobOutput, error)
	StartDocumentClassificationJobWithContext(aws.Context, *comprehend.StartDocumentClassificationJobInput, ...request.Option) (*comprehend.StartDocumentClassificationJobOutput, error)
	StartDocumentClassificationJobRequest(*comprehend.StartDocumentClassificationJobInput) (*request.Request, *comprehend.StartDocumentClassificationJobOutput)

	StartDominantLanguageDetectionJob(*comprehend.StartDominantLanguageDetectionJobInput) (*comprehend.StartDominantLanguageDetectionJobOutput, error)
	StartDominantLanguageDetectionJobWithContext(aws.Context, *comprehend.StartDominantLanguageDetectionJobInput, ...request.Option) (*comprehend.StartDominantLanguageDetectionJobOutput, error)
	StartDominantLanguageDetectionJobRequest(*comprehend.StartDominantLanguageDetectionJobInput) (*request.Request, *comprehend.StartDominantLanguageDetectionJobOutput)

	StartEntitiesDetectionJob(*comprehend.StartEntitiesDetectionJobInput) (*comprehend.StartEntitiesDetectionJobOutput, error)
	StartEntitiesDetectionJobWithContext(aws.Context, *comprehend.StartEntitiesDetectionJobInput, ...request.Option) (*comprehend.StartEntitiesDetectionJobOutput, error)
	StartEntitiesDetectionJobRequest(*comprehend.StartEntitiesDetectionJobInput) (*request.Request, *comprehend.StartEntitiesDetectionJobOutput)

	StartEventsDetectionJob(*comprehend.StartEventsDetectionJobInput) (*comprehend.StartEventsDetectionJobOutput, error)
	StartEventsDetectionJobWithContext(aws.Context, *comprehend.StartEventsDetectionJobInput, ...request.Option) (*comprehend.StartEventsDetectionJobOutput, error)
	StartEventsDetectionJobRequest(*comprehend.StartEventsDetectionJobInput) (*request.Request, *comprehend.StartEventsDetectionJobOutput)

	StartFlywheelIteration(*comprehend.StartFlywheelIterationInput) (*comprehend.StartFlywheelIterationOutput, error)
	StartFlywheelIterationWithContext(aws.Context, *comprehend.StartFlywheelIterationInput, ...request.Option) (*comprehend.StartFlywheelIterationOutput, error)
	StartFlywheelIterationRequest(*comprehend.StartFlywheelIterationInput) (*request.Request, *comprehend.StartFlywheelIterationOutput)

	StartKeyPhrasesDetectionJob(*comprehend.StartKeyPhrasesDetectionJobInput) (*comprehend.StartKeyPhrasesDetectionJobOutput, error)
	StartKeyPhrasesDetectionJobWithContext(aws.Context, *comprehend.StartKeyPhrasesDetectionJobInput, ...request.Option) (*comprehend.StartKeyPhrasesDetectionJobOutput, error)
	StartKeyPhrasesDetectionJobRequest(*comprehend.StartKeyPhrasesDetectionJobInput) (*request.Request, *comprehend.StartKeyPhrasesDetectionJobOutput)

	StartPiiEntitiesDetectionJob(*comprehend.StartPiiEntitiesDetectionJobInput) (*comprehend.StartPiiEntitiesDetectionJobOutput, error)
	StartPiiEntitiesDetectionJobWithContext(aws.Context, *comprehend.StartPiiEntitiesDetectionJobInput, ...request.Option) (*comprehend.StartPiiEntitiesDetectionJobOutput, error)
	StartPiiEntitiesDetectionJobRequest(*comprehend.StartPiiEntitiesDetectionJobInput) (*request.Request, *comprehend.StartPiiEntitiesDetectionJobOutput)

	StartSentimentDetectionJob(*comprehend.StartSentimentDetectionJobInput) (*comprehend.StartSentimentDetectionJobOutput, error)
	StartSentimentDetectionJobWithContext(aws.Context, *comprehend.StartSentimentDetectionJobInput, ...request.Option) (*comprehend.StartSentimentDetectionJobOutput, error)
	StartSentimentDetectionJobRequest(*comprehend.StartSentimentDetectionJobInput) (*request.Request, *comprehend.StartSentimentDetectionJobOutput)

	StartTargetedSentimentDetectionJob(*comprehend.StartTargetedSentimentDetectionJobInput) (*comprehend.StartTargetedSentimentDetectionJobOutput, error)
	StartTargetedSentimentDetectionJobWithContext(aws.Context, *comprehend.StartTargetedSentimentDetectionJobInput, ...request.Option) (*comprehend.StartTargetedSentimentDetectionJobOutput, error)
	StartTargetedSentimentDetectionJobRequest(*comprehend.StartTargetedSentimentDetectionJobInput) (*request.Request, *comprehend.StartTargetedSentimentDetectionJobOutput)

	StartTopicsDetectionJob(*comprehend.StartTopicsDetectionJobInput) (*comprehend.StartTopicsDetectionJobOutput, error)
	StartTopicsDetectionJobWithContext(aws.Context, *comprehend.StartTopicsDetectionJobInput, ...request.Option) (*comprehend.StartTopicsDetectionJobOutput, error)
	StartTopicsDetectionJobRequest(*comprehend.StartTopicsDetectionJobInput) (*request.Request, *comprehend.StartTopicsDetectionJobOutput)

	StopDominantLanguageDetectionJob(*comprehend.StopDominantLanguageDetectionJobInput) (*comprehend.StopDominantLanguageDetectionJobOutput, error)
	StopDominantLanguageDetectionJobWithContext(aws.Context, *comprehend.StopDominantLanguageDetectionJobInput, ...request.Option) (*comprehend.StopDominantLanguageDetectionJobOutput, error)
	StopDominantLanguageDetectionJobRequest(*comprehend.StopDominantLanguageDetectionJobInput) (*request.Request, *comprehend.StopDominantLanguageDetectionJobOutput)

	StopEntitiesDetectionJob(*comprehend.StopEntitiesDetectionJobInput) (*comprehend.StopEntitiesDetectionJobOutput, error)
	StopEntitiesDetectionJobWithContext(aws.Context, *comprehend.StopEntitiesDetectionJobInput, ...request.Option) (*comprehend.StopEntitiesDetectionJobOutput, error)
	StopEntitiesDetectionJobRequest(*comprehend.StopEntitiesDetectionJobInput) (*request.Request, *comprehend.StopEntitiesDetectionJobOutput)

	StopEventsDetectionJob(*comprehend.StopEventsDetectionJobInput) (*comprehend.StopEventsDetectionJobOutput, error)
	StopEventsDetectionJobWithContext(aws.Context, *comprehend.StopEventsDetectionJobInput, ...request.Option) (*comprehend.StopEventsDetectionJobOutput, error)
	StopEventsDetectionJobRequest(*comprehend.StopEventsDetectionJobInput) (*request.Request, *comprehend.StopEventsDetectionJobOutput)

	StopKeyPhrasesDetectionJob(*comprehend.StopKeyPhrasesDetectionJobInput) (*comprehend.StopKeyPhrasesDetectionJobOutput, error)
	StopKeyPhrasesDetectionJobWithContext(aws.Context, *comprehend.StopKeyPhrasesDetectionJobInput, ...request.Option) (*comprehend.StopKeyPhrasesDetectionJobOutput, error)
	StopKeyPhrasesDetectionJobRequest(*comprehend.StopKeyPhrasesDetectionJobInput) (*request.Request, *comprehend.StopKeyPhrasesDetectionJobOutput)

	StopPiiEntitiesDetectionJob(*comprehend.StopPiiEntitiesDetectionJobInput) (*comprehend.StopPiiEntitiesDetectionJobOutput, error)
	StopPiiEntitiesDetectionJobWithContext(aws.Context, *comprehend.StopPiiEntitiesDetectionJobInput, ...request.Option) (*comprehend.StopPiiEntitiesDetectionJobOutput, error)
	StopPiiEntitiesDetectionJobRequest(*comprehend.StopPiiEntitiesDetectionJobInput) (*request.Request, *comprehend.StopPiiEntitiesDetectionJobOutput)

	StopSentimentDetectionJob(*comprehend.StopSentimentDetectionJobInput) (*comprehend.StopSentimentDetectionJobOutput, error)
	StopSentimentDetectionJobWithContext(aws.Context, *comprehend.StopSentimentDetectionJobInput, ...request.Option) (*comprehend.StopSentimentDetectionJobOutput, error)
	StopSentimentDetectionJobRequest(*comprehend.StopSentimentDetectionJobInput) (*request.Request, *comprehend.StopSentimentDetectionJobOutput)

	StopTargetedSentimentDetectionJob(*comprehend.StopTargetedSentimentDetectionJobInput) (*comprehend.StopTargetedSentimentDetectionJobOutput, error)
	StopTargetedSentimentDetectionJobWithContext(aws.Context, *comprehend.StopTargetedSentimentDetectionJobInput, ...request.Option) (*comprehend.StopTargetedSentimentDetectionJobOutput, error)
	StopTargetedSentimentDetectionJobRequest(*comprehend.StopTargetedSentimentDetectionJobInput) (*request.Request, *comprehend.StopTargetedSentimentDetectionJobOutput)

	StopTrainingDocumentClassifier(*comprehend.StopTrainingDocumentClassifierInput) (*comprehend.StopTrainingDocumentClassifierOutput, error)
	StopTrainingDocumentClassifierWithContext(aws.Context, *comprehend.StopTrainingDocumentClassifierInput, ...request.Option) (*comprehend.StopTrainingDocumentClassifierOutput, error)
	StopTrainingDocumentClassifierRequest(*comprehend.StopTrainingDocumentClassifierInput) (*request.Request, *comprehend.StopTrainingDocumentClassifierOutput)

	StopTrainingEntityRecognizer(*comprehend.StopTrainingEntityRecognizerInput) (*comprehend.StopTrainingEntityRecognizerOutput, error)
	StopTrainingEntityRecognizerWithContext(aws.Context, *comprehend.StopTrainingEntityRecognizerInput, ...request.Option) (*comprehend.StopTrainingEntityRecognizerOutput, error)
	StopTrainingEntityRecognizerRequest(*comprehend.StopTrainingEntityRecognizerInput) (*request.Request, *comprehend.StopTrainingEntityRecognizerOutput)

	TagResource(*comprehend.TagResourceInput) (*comprehend.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *comprehend.TagResourceInput, ...request.Option) (*comprehend.TagResourceOutput, error)
	TagResourceRequest(*comprehend.TagResourceInput) (*request.Request, *comprehend.TagResourceOutput)

	UntagResource(*comprehend.UntagResourceInput) (*comprehend.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *comprehend.UntagResourceInput, ...request.Option) (*comprehend.UntagResourceOutput, error)
	UntagResourceRequest(*comprehend.UntagResourceInput) (*request.Request, *comprehend.UntagResourceOutput)

	UpdateEndpoint(*comprehend.UpdateEndpointInput) (*comprehend.UpdateEndpointOutput, error)
	UpdateEndpointWithContext(aws.Context, *comprehend.UpdateEndpointInput, ...request.Option) (*comprehend.UpdateEndpointOutput, error)
	UpdateEndpointRequest(*comprehend.UpdateEndpointInput) (*request.Request, *comprehend.UpdateEndpointOutput)

	UpdateFlywheel(*comprehend.UpdateFlywheelInput) (*comprehend.UpdateFlywheelOutput, error)
	UpdateFlywheelWithContext(aws.Context, *comprehend.UpdateFlywheelInput, ...request.Option) (*comprehend.UpdateFlywheelOutput, error)
	UpdateFlywheelRequest(*comprehend.UpdateFlywheelInput) (*request.Request, *comprehend.UpdateFlywheelOutput)
}

var _ ComprehendAPI = (*comprehend.Comprehend)(nil)
