// Copyright 2023 - MinIO, Inc. All rights reserved.
// Use of this source code is governed by the AGPLv3
// license that can be found in the LICENSE file.

// Generate the Go protobuf code by running the protobuf compiler
// from the repository root:
//
//   $ protoc -I=./kms/protobuf --go_out=. ./kms/protobuf/*.proto

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.25.2
// source: response.proto

package protobuf

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ErrResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Message string `protobuf:"bytes,1,opt,name=Message,json=message,proto3" json:"Message,omitempty"`
}

func (x *ErrResponse) Reset() {
	*x = ErrResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_response_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ErrResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ErrResponse) ProtoMessage() {}

func (x *ErrResponse) ProtoReflect() protoreflect.Message {
	mi := &file_response_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ErrResponse.ProtoReflect.Descriptor instead.
func (*ErrResponse) Descriptor() ([]byte, []int) {
	return file_response_proto_rawDescGZIP(), []int{0}
}

func (x *ErrResponse) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

type VersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version is the version of the KMS server. It's the timestamp of
	// the latest commit formatted as 'yyyy-mm-ddThh-mm-ssZ'. For example,
	// "2023-12-01T16-06-52Z"
	Version string `protobuf:"bytes,1,opt,name=Version,json=version,proto3" json:"Version,omitempty"`
	// Commit is the commit ID of the most latest code change of the KMS
	// server.
	Commit string `protobuf:"bytes,2,opt,name=Commit,json=commit,proto3" json:"Commit,omitempty"`
	// APIVersion is the API version supported by the KMS server.
	// For example, "v1".
	APIVersion string `protobuf:"bytes,3,opt,name=APIVersion,json=api_version,proto3" json:"APIVersion,omitempty"`
	// Host is the KMS server host or host:port.
	Host string `protobuf:"bytes,4,opt,name=Host,json=host,proto3" json:"Host,omitempty"`
}

func (x *VersionResponse) Reset() {
	*x = VersionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_response_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionResponse) ProtoMessage() {}

func (x *VersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_response_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionResponse.ProtoReflect.Descriptor instead.
func (*VersionResponse) Descriptor() ([]byte, []int) {
	return file_response_proto_rawDescGZIP(), []int{1}
}

func (x *VersionResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *VersionResponse) GetCommit() string {
	if x != nil {
		return x.Commit
	}
	return ""
}

func (x *VersionResponse) GetAPIVersion() string {
	if x != nil {
		return x.APIVersion
	}
	return ""
}

func (x *VersionResponse) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

type ServerStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version is the version of the KMS server. It's the timestamp of
	// the latest commit formatted as 'yyyy-mm-ddThh-mm-ssZ'. For example,
	// "2023-12-01T16-06-52Z"
	Version string `protobuf:"bytes,1,opt,name=Version,json=version,proto3" json:"Version,omitempty"`
	// APIVersion is the API version supported by the KMS server.
	// For example, "v1".
	APIVersion string `protobuf:"bytes,2,opt,name=APIVersion,json=api_version,proto3" json:"APIVersion,omitempty"`
	// Host is the KMS server host or host:port.
	Host string `protobuf:"bytes,3,opt,name=Host,json=host,proto3" json:"Host,omitempty"`
	// UpTime is the amount of time the KMS server is up and running.
	UpTime *durationpb.Duration `protobuf:"bytes,4,opt,name=UpTime,json=uptime,proto3" json:"UpTime,omitempty"`
	// Role is the current role the KMS server node has within the cluster.
	// Either, "Leader", "Follower" or "Candidate".
	Role string `protobuf:"bytes,5,opt,name=Role,json=role,proto3" json:"Role,omitempty"`
	// Commit is the number of state changes applied to this KMS server.
	Commit uint64 `protobuf:"varint,6,opt,name=Commit,json=commit,proto3" json:"Commit,omitempty"`
	// Nodes is a list of KMS server nodes within the KMS cluster as a map
	// of node IDs to KMS server addresses of the form 'host' or 'host:port'.
	Nodes map[uint32]string `protobuf:"bytes,7,rep,name=Nodes,json=nodes,proto3" json:"Nodes,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID is the node ID of this KMS server. It only changes if the node
	// joins a cluster.
	ID uint32 `protobuf:"varint,8,opt,name=ID,json=node_id,proto3" json:"ID,omitempty"`
	// LeaderID is the ID of the current cluster leader or negative if
	// the cluster has no leader.
	LeaderID int64 `protobuf:"zigzag64,9,opt,name=LeaderID,json=leader_id,proto3" json:"LeaderID,omitempty"`
	// LastHeartbeat is the duration since the KMS server has sent or received
	// a heartbeat. As long as there is a cluster leader, it should be lower
	// than the ElectionTimeout.
	LastHeartbeat *durationpb.Duration `protobuf:"bytes,10,opt,name=LastHeartbeat,json=last_heartbeat,proto3" json:"LastHeartbeat,omitempty"`
	// HeartbeatInterval defines the frequency in which this KMS server, as cluster
	// leader, sends heartbeats to its follower nodes. All nodes within a cluster
	// should use the same heartbeat interval.
	HeartbeatInterval *durationpb.Duration `protobuf:"bytes,11,opt,name=HeartbeatInterval,json=heartbeat_interval,proto3" json:"HeartbeatInterval,omitempty"`
	// ElectionTimeout defines how long a KMS server node waits for heartbeats before
	// it considers the cluster leaders as down and starts a leader election to become
	// the cluster leader itself.
	// Each cluster node should have a slightly different election timeout to avoid
	// spliting votes. Typically, base election timeout + random jitter. The average
	// or base election timeout of all cluster nodes should be balanced with the
	// HeartbeatInterval to prevent nodes from starting elections even though a leader
	// is present. A reasonable default may be ElectionTimeout = 3 * HeartbeatInterval.
	ElectionTimeout *durationpb.Duration `protobuf:"bytes,12,opt,name=ElectionTimeout,json=election_timeout,proto3" json:"ElectionTimeout,omitempty"`
	// OS identifies the operating system the KMS server is running on.
	// For example, "linux" or "darwin".
	OS string `protobuf:"bytes,13,opt,name=OS,json=sys_os,proto3" json:"OS,omitempty"`
	// Arch is the CPU architecture of the KMS server. For example, "amd64".
	Arch string `protobuf:"bytes,14,opt,name=Arch,json=sys_cpu_arch,proto3" json:"Arch,omitempty"`
	// CPUs is the number of logical CPUs that can execite the KMS server process.
	// However, the KMS server may not use all of these CPUs. It might be limited
	// to fewer CPUs.
	CPUs uint32 `protobuf:"varint,15,opt,name=CPUs,json=sys_cpu_num,proto3" json:"CPUs,omitempty"`
	// UsableCPUs is the number of CPUs actually used by the KMS server process.
	// Unless the KMS server has been limited to fewer CPUs, equal to CPUs field.
	UsableCPUs uint32 `protobuf:"varint,16,opt,name=UsableCPUs,json=sys_cpu_used,proto3" json:"UsableCPUs,omitempty"`
	// HeapMemInUse is the amount of heap memory currently occupied by the KMS server.
	// The total amount of memory used by the KMS server process is HeapMemInUse +
	// StackMemInUse.
	HeapMemInUse uint64 `protobuf:"varint,17,opt,name=HeapMemInUse,json=sys_mem_heap_used,proto3" json:"HeapMemInUse,omitempty"`
	// StackMemInUse is the amount of stack memory currently occupied by the KMS server.
	// The total amount of memory used by the KMS server process is HeapMemInUse +
	// StackMemInUse.
	StackMemInUse uint64 `protobuf:"varint,18,opt,name=StackMemInUse,json=sys_mem_stack_used,proto3" json:"StackMemInUse,omitempty"`
}

func (x *ServerStatusResponse) Reset() {
	*x = ServerStatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_response_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerStatusResponse) ProtoMessage() {}

func (x *ServerStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_response_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerStatusResponse.ProtoReflect.Descriptor instead.
func (*ServerStatusResponse) Descriptor() ([]byte, []int) {
	return file_response_proto_rawDescGZIP(), []int{2}
}

func (x *ServerStatusResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ServerStatusResponse) GetAPIVersion() string {
	if x != nil {
		return x.APIVersion
	}
	return ""
}

func (x *ServerStatusResponse) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *ServerStatusResponse) GetUpTime() *durationpb.Duration {
	if x != nil {
		return x.UpTime
	}
	return nil
}

func (x *ServerStatusResponse) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *ServerStatusResponse) GetCommit() uint64 {
	if x != nil {
		return x.Commit
	}
	return 0
}

func (x *ServerStatusResponse) GetNodes() map[uint32]string {
	if x != nil {
		return x.Nodes
	}
	return nil
}

func (x *ServerStatusResponse) GetID() uint32 {
	if x != nil {
		return x.ID
	}
	return 0
}

func (x *ServerStatusResponse) GetLeaderID() int64 {
	if x != nil {
		return x.LeaderID
	}
	return 0
}

func (x *ServerStatusResponse) GetLastHeartbeat() *durationpb.Duration {
	if x != nil {
		return x.LastHeartbeat
	}
	return nil
}

func (x *ServerStatusResponse) GetHeartbeatInterval() *durationpb.Duration {
	if x != nil {
		return x.HeartbeatInterval
	}
	return nil
}

func (x *ServerStatusResponse) GetElectionTimeout() *durationpb.Duration {
	if x != nil {
		return x.ElectionTimeout
	}
	return nil
}

func (x *ServerStatusResponse) GetOS() string {
	if x != nil {
		return x.OS
	}
	return ""
}

func (x *ServerStatusResponse) GetArch() string {
	if x != nil {
		return x.Arch
	}
	return ""
}

func (x *ServerStatusResponse) GetCPUs() uint32 {
	if x != nil {
		return x.CPUs
	}
	return 0
}

func (x *ServerStatusResponse) GetUsableCPUs() uint32 {
	if x != nil {
		return x.UsableCPUs
	}
	return 0
}

func (x *ServerStatusResponse) GetHeapMemInUse() uint64 {
	if x != nil {
		return x.HeapMemInUse
	}
	return 0
}

func (x *ServerStatusResponse) GetStackMemInUse() uint64 {
	if x != nil {
		return x.StackMemInUse
	}
	return 0
}

type ClusterStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NodesUp   map[uint32]*ServerStatusResponse `protobuf:"bytes,1,rep,name=NodesUp,json=nodes_up,proto3" json:"NodesUp,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	NodesDown map[uint32]string                `protobuf:"bytes,2,rep,name=NodesDown,json=nodes_down,proto3" json:"NodesDown,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ClusterStatusResponse) Reset() {
	*x = ClusterStatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_response_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterStatusResponse) ProtoMessage() {}

func (x *ClusterStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_response_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterStatusResponse.ProtoReflect.Descriptor instead.
func (*ClusterStatusResponse) Descriptor() ([]byte, []int) {
	return file_response_proto_rawDescGZIP(), []int{3}
}

func (x *ClusterStatusResponse) GetNodesUp() map[uint32]*ServerStatusResponse {
	if x != nil {
		return x.NodesUp
	}
	return nil
}

func (x *ClusterStatusResponse) GetNodesDown() map[uint32]string {
	if x != nil {
		return x.NodesDown
	}
	return nil
}

type EnclaveStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name is the name of the enclave.
	Name string `protobuf:"bytes,1,opt,name=Name,json=name,proto3" json:"Name,omitempty"`
	// CreatedAt is the point in time when this enclave got created.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=CreatedAt,json=created_at,proto3" json:"CreatedAt,omitempty"`
	// CreatedBy is the identity that created this enclave.
	CreatedBy string `protobuf:"bytes,3,opt,name=CreatedBy,json=created_by,proto3" json:"CreatedBy,omitempty"`
}

func (x *EnclaveStatusResponse) Reset() {
	*x = EnclaveStatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_response_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnclaveStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnclaveStatusResponse) ProtoMessage() {}

func (x *EnclaveStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_response_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnclaveStatusResponse.ProtoReflect.Descriptor instead.
func (*EnclaveStatusResponse) Descriptor() ([]byte, []int) {
	return file_response_proto_rawDescGZIP(), []int{4}
}

func (x *EnclaveStatusResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EnclaveStatusResponse) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *EnclaveStatusResponse) GetCreatedBy() string {
	if x != nil {
		return x.CreatedBy
	}
	return ""
}

type ListEnclavesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Enclaves   []*EnclaveStatusResponse `protobuf:"bytes,1,rep,name=Enclaves,json=enclaves,proto3" json:"Enclaves,omitempty"`
	ContinueAt string                   `protobuf:"bytes,2,opt,name=ContinueAt,json=continue_at,proto3" json:"ContinueAt,omitempty"`
}

func (x *ListEnclavesResponse) Reset() {
	*x = ListEnclavesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_response_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEnclavesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEnclavesResponse) ProtoMessage() {}

func (x *ListEnclavesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_response_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEnclavesResponse.ProtoReflect.Descriptor instead.
func (*ListEnclavesResponse) Descriptor() ([]byte, []int) {
	return file_response_proto_rawDescGZIP(), []int{5}
}

func (x *ListEnclavesResponse) GetEnclaves() []*EnclaveStatusResponse {
	if x != nil {
		return x.Enclaves
	}
	return nil
}

func (x *ListEnclavesResponse) GetContinueAt() string {
	if x != nil {
		return x.ContinueAt
	}
	return ""
}

type KeyStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name is the name of the key.
	Name string `protobuf:"bytes,1,opt,name=Name,json=name,proto3" json:"Name,omitempty"`
	// Version is the this key's version within the key ring.
	Version uint32 `protobuf:"varint,2,opt,name=Version,json=version,proto3" json:"Version,omitempty"`
	// The is the key type. For example, "AES256".
	Type string `protobuf:"bytes,3,opt,name=Type,json=type,proto3" json:"Type,omitempty"`
	// CreatedAt is the point in time when this key version got created.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=CreatedAt,json=created_at,proto3" json:"CreatedAt,omitempty"`
	// CreatedBy is the identity that created the key version.
	CreatedBy string `protobuf:"bytes,5,opt,name=CreatedBy,json=created_by,proto3" json:"CreatedBy,omitempty"`
}

func (x *KeyStatusResponse) Reset() {
	*x = KeyStatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_response_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyStatusResponse) ProtoMessage() {}

func (x *KeyStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_response_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyStatusResponse.ProtoReflect.Descriptor instead.
func (*KeyStatusResponse) Descriptor() ([]byte, []int) {
	return file_response_proto_rawDescGZIP(), []int{6}
}

func (x *KeyStatusResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *KeyStatusResponse) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *KeyStatusResponse) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *KeyStatusResponse) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *KeyStatusResponse) GetCreatedBy() string {
	if x != nil {
		return x.CreatedBy
	}
	return ""
}

type ListKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Keys       []*KeyStatusResponse `protobuf:"bytes,1,rep,name=Keys,json=keys,proto3" json:"Keys,omitempty"`
	ContinueAt string               `protobuf:"bytes,2,opt,name=ContinueAt,json=continue_at,proto3" json:"ContinueAt,omitempty"`
}

func (x *ListKeysResponse) Reset() {
	*x = ListKeysResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_response_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListKeysResponse) ProtoMessage() {}

func (x *ListKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_response_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListKeysResponse.ProtoReflect.Descriptor instead.
func (*ListKeysResponse) Descriptor() ([]byte, []int) {
	return file_response_proto_rawDescGZIP(), []int{7}
}

func (x *ListKeysResponse) GetKeys() []*KeyStatusResponse {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *ListKeysResponse) GetContinueAt() string {
	if x != nil {
		return x.ContinueAt
	}
	return ""
}

type EncryptResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version identifies the particular key within a key ring used to encrypt
	// the message.
	Version uint32 `protobuf:"varint,1,opt,name=Version,json=version,proto3" json:"Version,omitempty"`
	// Ciphertext is the encrypted message.
	Ciphertext []byte `protobuf:"bytes,2,opt,name=Ciphertext,json=ciphertext,proto3" json:"Ciphertext,omitempty"`
}

func (x *EncryptResponse) Reset() {
	*x = EncryptResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_response_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EncryptResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptResponse) ProtoMessage() {}

func (x *EncryptResponse) ProtoReflect() protoreflect.Message {
	mi := &file_response_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptResponse.ProtoReflect.Descriptor instead.
func (*EncryptResponse) Descriptor() ([]byte, []int) {
	return file_response_proto_rawDescGZIP(), []int{8}
}

func (x *EncryptResponse) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *EncryptResponse) GetCiphertext() []byte {
	if x != nil {
		return x.Ciphertext
	}
	return nil
}

type DecryptResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Plaintext is the decrypted message.
	Plaintext []byte `protobuf:"bytes,1,opt,name=Plaintext,json=plaintext,proto3" json:"Plaintext,omitempty"`
}

func (x *DecryptResponse) Reset() {
	*x = DecryptResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_response_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DecryptResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DecryptResponse) ProtoMessage() {}

func (x *DecryptResponse) ProtoReflect() protoreflect.Message {
	mi := &file_response_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DecryptResponse.ProtoReflect.Descriptor instead.
func (*DecryptResponse) Descriptor() ([]byte, []int) {
	return file_response_proto_rawDescGZIP(), []int{9}
}

func (x *DecryptResponse) GetPlaintext() []byte {
	if x != nil {
		return x.Plaintext
	}
	return nil
}

type GenerateKeyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version identifies the particular key within a key ring used to generate
	// and encrypt this data encryption key.
	Version uint32 `protobuf:"varint,1,opt,name=Version,json=version,proto3" json:"Version,omitempty"`
	// Plaintext is the plain data encryption key. It may be used by clients to
	// perform crypto. operations.
	Plaintext []byte `protobuf:"bytes,2,opt,name=Plaintext,json=plaintext,proto3" json:"Plaintext,omitempty"`
	// Ciphertext is the encrypted data encryption key. Clients should store it
	// to obtain the plain data encryption key in the future again.
	Ciphertext []byte `protobuf:"bytes,3,opt,name=Ciphertext,json=ciphertext,proto3" json:"Ciphertext,omitempty"`
}

func (x *GenerateKeyResponse) Reset() {
	*x = GenerateKeyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_response_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateKeyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateKeyResponse) ProtoMessage() {}

func (x *GenerateKeyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_response_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateKeyResponse.ProtoReflect.Descriptor instead.
func (*GenerateKeyResponse) Descriptor() ([]byte, []int) {
	return file_response_proto_rawDescGZIP(), []int{10}
}

func (x *GenerateKeyResponse) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *GenerateKeyResponse) GetPlaintext() []byte {
	if x != nil {
		return x.Plaintext
	}
	return nil
}

func (x *GenerateKeyResponse) GetCiphertext() []byte {
	if x != nil {
		return x.Ciphertext
	}
	return nil
}

type PolicyStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name is the name of the policy.
	Name string `protobuf:"bytes,1,opt,name=Name,json=name,proto3" json:"Name,omitempty"`
	// CreatedAt is the point in time when this policy got created.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=CreatedAt,json=created_at,proto3" json:"CreatedAt,omitempty"`
	// CreatedBy is the identity that created the policy.
	CreatedBy string `protobuf:"bytes,5,opt,name=CreatedBy,json=created_by,proto3" json:"CreatedBy,omitempty"`
}

func (x *PolicyStatusResponse) Reset() {
	*x = PolicyStatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_response_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyStatusResponse) ProtoMessage() {}

func (x *PolicyStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_response_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyStatusResponse.ProtoReflect.Descriptor instead.
func (*PolicyStatusResponse) Descriptor() ([]byte, []int) {
	return file_response_proto_rawDescGZIP(), []int{11}
}

func (x *PolicyStatusResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PolicyStatusResponse) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *PolicyStatusResponse) GetCreatedBy() string {
	if x != nil {
		return x.CreatedBy
	}
	return ""
}

type PolicyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name is the name of the policy.
	Name string `protobuf:"bytes,1,opt,name=Name,json=name,proto3" json:"Name,omitempty"`
	// Allow contains a set of API path patterns and corresponding policy rules.
	// Requests that match at least one path, but not any deny pattern, and
	// pass the corresponding policy rule are accepted by the server.
	Allow map[string]*RuleSet `protobuf:"bytes,2,rep,name=Allow,json=allow,proto3" json:"Allow,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deny contains a set of API path patterns and corresponding policy rules.
	// Requests that match at least one path and pass the corresponding policy
	// rule are rejected by the server.
	Deny map[string]*RuleSet `protobuf:"bytes,3,rep,name=Deny,json=deny,proto3" json:"Deny,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// CreatedAt is the point in time when this policy got created.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=CreatedAt,json=created_at,proto3" json:"CreatedAt,omitempty"`
	// CreatedBy is the identity that created the policy.
	CreatedBy string `protobuf:"bytes,5,opt,name=CreatedBy,json=created_by,proto3" json:"CreatedBy,omitempty"`
}

func (x *PolicyResponse) Reset() {
	*x = PolicyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_response_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyResponse) ProtoMessage() {}

func (x *PolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_response_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyResponse.ProtoReflect.Descriptor instead.
func (*PolicyResponse) Descriptor() ([]byte, []int) {
	return file_response_proto_rawDescGZIP(), []int{12}
}

func (x *PolicyResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PolicyResponse) GetAllow() map[string]*RuleSet {
	if x != nil {
		return x.Allow
	}
	return nil
}

func (x *PolicyResponse) GetDeny() map[string]*RuleSet {
	if x != nil {
		return x.Deny
	}
	return nil
}

func (x *PolicyResponse) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *PolicyResponse) GetCreatedBy() string {
	if x != nil {
		return x.CreatedBy
	}
	return ""
}

type ListPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Policies   []*PolicyStatusResponse `protobuf:"bytes,1,rep,name=Policies,json=policies,proto3" json:"Policies,omitempty"`
	ContinueAt string                  `protobuf:"bytes,2,opt,name=ContinueAt,json=continue_at,proto3" json:"ContinueAt,omitempty"`
}

func (x *ListPoliciesResponse) Reset() {
	*x = ListPoliciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_response_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPoliciesResponse) ProtoMessage() {}

func (x *ListPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_response_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPoliciesResponse.ProtoReflect.Descriptor instead.
func (*ListPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_response_proto_rawDescGZIP(), []int{13}
}

func (x *ListPoliciesResponse) GetPolicies() []*PolicyStatusResponse {
	if x != nil {
		return x.Policies
	}
	return nil
}

func (x *ListPoliciesResponse) GetContinueAt() string {
	if x != nil {
		return x.ContinueAt
	}
	return ""
}

type IdentityResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Identity  string `protobuf:"bytes,1,opt,name=Identity,json=identity,proto3" json:"Identity,omitempty"`
	Privilege uint32 `protobuf:"varint,2,opt,name=Privilege,json=privilege,proto3" json:"Privilege,omitempty"`
	Policy    string `protobuf:"bytes,3,opt,name=Policy,json=policy,proto3" json:"Policy,omitempty"`
	// CreatedAt is the point in time when this identity got created.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=CreatedAt,json=created_at,proto3" json:"CreatedAt,omitempty"`
	// CreatedBy is the identity that created this identity.
	CreatedBy        string   `protobuf:"bytes,5,opt,name=CreatedBy,json=created_by,proto3" json:"CreatedBy,omitempty"`
	IsServiceAccount bool     `protobuf:"varint,6,opt,name=IsServiceAccount,json=is_service_account,proto3" json:"IsServiceAccount,omitempty"`
	ServiceAccounts  []string `protobuf:"bytes,7,rep,name=ServiceAccounts,json=service_accounts,proto3" json:"ServiceAccounts,omitempty"`
}

func (x *IdentityResponse) Reset() {
	*x = IdentityResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_response_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IdentityResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IdentityResponse) ProtoMessage() {}

func (x *IdentityResponse) ProtoReflect() protoreflect.Message {
	mi := &file_response_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IdentityResponse.ProtoReflect.Descriptor instead.
func (*IdentityResponse) Descriptor() ([]byte, []int) {
	return file_response_proto_rawDescGZIP(), []int{14}
}

func (x *IdentityResponse) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *IdentityResponse) GetPrivilege() uint32 {
	if x != nil {
		return x.Privilege
	}
	return 0
}

func (x *IdentityResponse) GetPolicy() string {
	if x != nil {
		return x.Policy
	}
	return ""
}

func (x *IdentityResponse) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *IdentityResponse) GetCreatedBy() string {
	if x != nil {
		return x.CreatedBy
	}
	return ""
}

func (x *IdentityResponse) GetIsServiceAccount() bool {
	if x != nil {
		return x.IsServiceAccount
	}
	return false
}

func (x *IdentityResponse) GetServiceAccounts() []string {
	if x != nil {
		return x.ServiceAccounts
	}
	return nil
}

type ListIdentitiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Identities []*IdentityResponse `protobuf:"bytes,1,rep,name=Identities,json=identities,proto3" json:"Identities,omitempty"`
	ContinueAt string              `protobuf:"bytes,2,opt,name=ContinueAt,json=continue_at,proto3" json:"ContinueAt,omitempty"`
}

func (x *ListIdentitiesResponse) Reset() {
	*x = ListIdentitiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_response_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIdentitiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIdentitiesResponse) ProtoMessage() {}

func (x *ListIdentitiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_response_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIdentitiesResponse.ProtoReflect.Descriptor instead.
func (*ListIdentitiesResponse) Descriptor() ([]byte, []int) {
	return file_response_proto_rawDescGZIP(), []int{15}
}

func (x *ListIdentitiesResponse) GetIdentities() []*IdentityResponse {
	if x != nil {
		return x.Identities
	}
	return nil
}

func (x *ListIdentitiesResponse) GetContinueAt() string {
	if x != nil {
		return x.ContinueAt
	}
	return ""
}

var File_response_proto protoreflect.FileDescriptor

var file_response_proto_rawDesc = []byte{
	0x0a, 0x0e, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x09, 0x6d, 0x69, 0x6e, 0x69, 0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x0a, 0x72, 0x75,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x27, 0x0a, 0x0b, 0x45, 0x72, 0x72, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x22, 0x78, 0x0a, 0x0f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0x1f, 0x0a, 0x0a, 0x41, 0x50, 0x49, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x70, 0x69, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x48, 0x6f, 0x73, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x22, 0x85, 0x06, 0x0a, 0x14,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f,
	0x0a, 0x0a, 0x41, 0x50, 0x49, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x12, 0x0a, 0x04, 0x48, 0x6f, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x68,
	0x6f, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x06, 0x55, 0x70, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x75, 0x70, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x52, 0x6f, 0x6c, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x12, 0x40, 0x0a, 0x05, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x6d, 0x69, 0x6e, 0x69, 0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x05, 0x6e,
	0x6f, 0x64, 0x65, 0x73, 0x12, 0x13, 0x0a, 0x02, 0x49, 0x44, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x07, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x69, 0x64, 0x12, 0x1b, 0x0a, 0x08, 0x4c, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x49, 0x44, 0x18, 0x09, 0x20, 0x01, 0x28, 0x12, 0x52, 0x09, 0x6c, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0d, 0x4c, 0x61, 0x73, 0x74, 0x48, 0x65,
	0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x68,
	0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x12, 0x48, 0x0a, 0x11, 0x48, 0x65, 0x61, 0x72,
	0x74, 0x62, 0x65, 0x61, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12,
	0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x12, 0x44, 0x0a, 0x0f, 0x45, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x12, 0x0a, 0x02, 0x4f, 0x53, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x79, 0x73, 0x5f, 0x6f, 0x73, 0x12, 0x1a, 0x0a, 0x04,
	0x41, 0x72, 0x63, 0x68, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x79, 0x73, 0x5f,
	0x63, 0x70, 0x75, 0x5f, 0x61, 0x72, 0x63, 0x68, 0x12, 0x19, 0x0a, 0x04, 0x43, 0x50, 0x55, 0x73,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x73, 0x79, 0x73, 0x5f, 0x63, 0x70, 0x75, 0x5f,
	0x6e, 0x75, 0x6d, 0x12, 0x20, 0x0a, 0x0a, 0x55, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x50, 0x55,
	0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x73, 0x79, 0x73, 0x5f, 0x63, 0x70, 0x75,
	0x5f, 0x75, 0x73, 0x65, 0x64, 0x12, 0x27, 0x0a, 0x0c, 0x48, 0x65, 0x61, 0x70, 0x4d, 0x65, 0x6d,
	0x49, 0x6e, 0x55, 0x73, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x04, 0x52, 0x11, 0x73, 0x79, 0x73,
	0x5f, 0x6d, 0x65, 0x6d, 0x5f, 0x68, 0x65, 0x61, 0x70, 0x5f, 0x75, 0x73, 0x65, 0x64, 0x12, 0x29,
	0x0a, 0x0d, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x4d, 0x65, 0x6d, 0x49, 0x6e, 0x55, 0x73, 0x65, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x04, 0x52, 0x12, 0x73, 0x79, 0x73, 0x5f, 0x6d, 0x65, 0x6d, 0x5f, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x5f, 0x75, 0x73, 0x65, 0x64, 0x1a, 0x38, 0x0a, 0x0a, 0x4e, 0x6f, 0x64,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0xcc, 0x02, 0x0a, 0x15, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a,
	0x07, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x55, 0x70, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x6d, 0x69, 0x6e, 0x69, 0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x55, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6e,
	0x6f, 0x64, 0x65, 0x73, 0x5f, 0x75, 0x70, 0x12, 0x4e, 0x0a, 0x09, 0x4e, 0x6f, 0x64, 0x65, 0x73,
	0x44, 0x6f, 0x77, 0x6e, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6d, 0x69, 0x6e,
	0x69, 0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4e, 0x6f, 0x64,
	0x65, 0x73, 0x44, 0x6f, 0x77, 0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x6e, 0x6f, 0x64,
	0x65, 0x73, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x1a, 0x5b, 0x0a, 0x0c, 0x4e, 0x6f, 0x64, 0x65, 0x73,
	0x55, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x35, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x6d, 0x69, 0x6e, 0x69, 0x6f,
	0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3c, 0x0a, 0x0e, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x44, 0x6f, 0x77,
	0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x85, 0x01, 0x0a, 0x15, 0x45, 0x6e, 0x63, 0x6c, 0x61, 0x76, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x39, 0x0a, 0x09, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x12, 0x1d, 0x0a, 0x09, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x22, 0x75, 0x0a, 0x14, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x6e, 0x63, 0x6c, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x3c, 0x0a, 0x08, 0x45, 0x6e, 0x63, 0x6c, 0x61, 0x76, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x6d, 0x69, 0x6e, 0x69, 0x6f, 0x2e, 0x6b, 0x6d, 0x73,
	0x2e, 0x45, 0x6e, 0x63, 0x6c, 0x61, 0x76, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6c, 0x61, 0x76, 0x65, 0x73,
	0x12, 0x1f, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65, 0x41, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65, 0x5f, 0x61,
	0x74, 0x22, 0xaf, 0x01, 0x0a, 0x11, 0x4b, 0x65, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x39, 0x0a, 0x09, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x61, 0x74, 0x12, 0x1d, 0x0a, 0x09, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x42,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x62, 0x79, 0x22, 0x65, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x04, 0x4b, 0x65, 0x79, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6d, 0x69, 0x6e, 0x69, 0x6f, 0x2e, 0x6b, 0x6d,
	0x73, 0x2e, 0x4b, 0x65, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x1f, 0x0a, 0x0a, 0x43, 0x6f, 0x6e,
	0x74, 0x69, 0x6e, 0x75, 0x65, 0x41, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63,
	0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65, 0x5f, 0x61, 0x74, 0x22, 0x4b, 0x0a, 0x0f, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x43, 0x69, 0x70, 0x68, 0x65,
	0x72, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x63, 0x69, 0x70,
	0x68, 0x65, 0x72, 0x74, 0x65, 0x78, 0x74, 0x22, 0x2f, 0x0a, 0x0f, 0x44, 0x65, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x6c,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x70,
	0x6c, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x6d, 0x0a, 0x13, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x6c, 0x61,
	0x69, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x70, 0x6c,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x43, 0x69, 0x70, 0x68, 0x65,
	0x72, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x63, 0x69, 0x70,
	0x68, 0x65, 0x72, 0x74, 0x65, 0x78, 0x74, 0x22, 0x84, 0x01, 0x0a, 0x14, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x09, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x12,
	0x1d, 0x0a, 0x09, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x22, 0x8e,
	0x03, 0x0a, 0x0e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x6d, 0x69, 0x6e, 0x69, 0x6f, 0x2e, 0x6b, 0x6d, 0x73,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x05, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x12, 0x37, 0x0a, 0x04, 0x44, 0x65, 0x6e, 0x79, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x6d, 0x69, 0x6e, 0x69, 0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x44, 0x65, 0x6e, 0x79, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x64, 0x65, 0x6e, 0x79, 0x12, 0x39, 0x0a, 0x09, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x61, 0x74, 0x12, 0x1d, 0x0a, 0x09, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x42, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x62, 0x79, 0x1a, 0x4c, 0x0a, 0x0a, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x28, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x69, 0x6e, 0x69, 0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e,
	0x52, 0x75, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x4b, 0x0a, 0x09, 0x44, 0x65, 0x6e, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x28, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x6d, 0x69, 0x6e, 0x69, 0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x52, 0x75, 0x6c,
	0x65, 0x53, 0x65, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x74, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x08, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x6d, 0x69, 0x6e, 0x69,
	0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x08, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65,
	0x41, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e,
	0x75, 0x65, 0x5f, 0x61, 0x74, 0x22, 0x97, 0x02, 0x0a, 0x10, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x72, 0x69, 0x76, 0x69, 0x6c,
	0x65, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x70, 0x72, 0x69, 0x76, 0x69,
	0x6c, 0x65, 0x67, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x39, 0x0a, 0x09,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x12, 0x1d, 0x0a, 0x09, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x42, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x12, 0x2c, 0x0a, 0x10, 0x49, 0x73, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x12, 0x69, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x0f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x22,
	0x76, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x0a, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x6d, 0x69, 0x6e, 0x69, 0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x0a, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6e,
	0x75, 0x65, 0x41, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74,
	0x69, 0x6e, 0x75, 0x65, 0x5f, 0x61, 0x74, 0x42, 0x0e, 0x5a, 0x0c, 0x6b, 0x6d, 0x73, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_response_proto_rawDescOnce sync.Once
	file_response_proto_rawDescData = file_response_proto_rawDesc
)

func file_response_proto_rawDescGZIP() []byte {
	file_response_proto_rawDescOnce.Do(func() {
		file_response_proto_rawDescData = protoimpl.X.CompressGZIP(file_response_proto_rawDescData)
	})
	return file_response_proto_rawDescData
}

var file_response_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_response_proto_goTypes = []interface{}{
	(*ErrResponse)(nil),            // 0: minio.kms.ErrResponse
	(*VersionResponse)(nil),        // 1: minio.kms.VersionResponse
	(*ServerStatusResponse)(nil),   // 2: minio.kms.ServerStatusResponse
	(*ClusterStatusResponse)(nil),  // 3: minio.kms.ClusterStatusResponse
	(*EnclaveStatusResponse)(nil),  // 4: minio.kms.EnclaveStatusResponse
	(*ListEnclavesResponse)(nil),   // 5: minio.kms.ListEnclavesResponse
	(*KeyStatusResponse)(nil),      // 6: minio.kms.KeyStatusResponse
	(*ListKeysResponse)(nil),       // 7: minio.kms.ListKeysResponse
	(*EncryptResponse)(nil),        // 8: minio.kms.EncryptResponse
	(*DecryptResponse)(nil),        // 9: minio.kms.DecryptResponse
	(*GenerateKeyResponse)(nil),    // 10: minio.kms.GenerateKeyResponse
	(*PolicyStatusResponse)(nil),   // 11: minio.kms.PolicyStatusResponse
	(*PolicyResponse)(nil),         // 12: minio.kms.PolicyResponse
	(*ListPoliciesResponse)(nil),   // 13: minio.kms.ListPoliciesResponse
	(*IdentityResponse)(nil),       // 14: minio.kms.IdentityResponse
	(*ListIdentitiesResponse)(nil), // 15: minio.kms.ListIdentitiesResponse
	nil,                            // 16: minio.kms.ServerStatusResponse.NodesEntry
	nil,                            // 17: minio.kms.ClusterStatusResponse.NodesUpEntry
	nil,                            // 18: minio.kms.ClusterStatusResponse.NodesDownEntry
	nil,                            // 19: minio.kms.PolicyResponse.AllowEntry
	nil,                            // 20: minio.kms.PolicyResponse.DenyEntry
	(*durationpb.Duration)(nil),    // 21: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),  // 22: google.protobuf.Timestamp
	(*RuleSet)(nil),                // 23: minio.kms.RuleSet
}
var file_response_proto_depIdxs = []int32{
	21, // 0: minio.kms.ServerStatusResponse.UpTime:type_name -> google.protobuf.Duration
	16, // 1: minio.kms.ServerStatusResponse.Nodes:type_name -> minio.kms.ServerStatusResponse.NodesEntry
	21, // 2: minio.kms.ServerStatusResponse.LastHeartbeat:type_name -> google.protobuf.Duration
	21, // 3: minio.kms.ServerStatusResponse.HeartbeatInterval:type_name -> google.protobuf.Duration
	21, // 4: minio.kms.ServerStatusResponse.ElectionTimeout:type_name -> google.protobuf.Duration
	17, // 5: minio.kms.ClusterStatusResponse.NodesUp:type_name -> minio.kms.ClusterStatusResponse.NodesUpEntry
	18, // 6: minio.kms.ClusterStatusResponse.NodesDown:type_name -> minio.kms.ClusterStatusResponse.NodesDownEntry
	22, // 7: minio.kms.EnclaveStatusResponse.CreatedAt:type_name -> google.protobuf.Timestamp
	4,  // 8: minio.kms.ListEnclavesResponse.Enclaves:type_name -> minio.kms.EnclaveStatusResponse
	22, // 9: minio.kms.KeyStatusResponse.CreatedAt:type_name -> google.protobuf.Timestamp
	6,  // 10: minio.kms.ListKeysResponse.Keys:type_name -> minio.kms.KeyStatusResponse
	22, // 11: minio.kms.PolicyStatusResponse.CreatedAt:type_name -> google.protobuf.Timestamp
	19, // 12: minio.kms.PolicyResponse.Allow:type_name -> minio.kms.PolicyResponse.AllowEntry
	20, // 13: minio.kms.PolicyResponse.Deny:type_name -> minio.kms.PolicyResponse.DenyEntry
	22, // 14: minio.kms.PolicyResponse.CreatedAt:type_name -> google.protobuf.Timestamp
	11, // 15: minio.kms.ListPoliciesResponse.Policies:type_name -> minio.kms.PolicyStatusResponse
	22, // 16: minio.kms.IdentityResponse.CreatedAt:type_name -> google.protobuf.Timestamp
	14, // 17: minio.kms.ListIdentitiesResponse.Identities:type_name -> minio.kms.IdentityResponse
	2,  // 18: minio.kms.ClusterStatusResponse.NodesUpEntry.value:type_name -> minio.kms.ServerStatusResponse
	23, // 19: minio.kms.PolicyResponse.AllowEntry.value:type_name -> minio.kms.RuleSet
	23, // 20: minio.kms.PolicyResponse.DenyEntry.value:type_name -> minio.kms.RuleSet
	21, // [21:21] is the sub-list for method output_type
	21, // [21:21] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_response_proto_init() }
func file_response_proto_init() {
	if File_response_proto != nil {
		return
	}
	file_rule_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_response_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ErrResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_response_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VersionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_response_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerStatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_response_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClusterStatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_response_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnclaveStatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_response_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEnclavesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_response_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyStatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_response_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListKeysResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_response_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EncryptResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_response_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DecryptResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_response_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateKeyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_response_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyStatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_response_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_response_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPoliciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_response_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IdentityResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_response_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIdentitiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_response_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_response_proto_goTypes,
		DependencyIndexes: file_response_proto_depIdxs,
		MessageInfos:      file_response_proto_msgTypes,
	}.Build()
	File_response_proto = out.File
	file_response_proto_rawDesc = nil
	file_response_proto_goTypes = nil
	file_response_proto_depIdxs = nil
}
