// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatchlogs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Use this operation to return the valid and default values that are used when
// creating delivery sources, delivery destinations, and deliveries. For more
// information about deliveries, see [CreateDelivery].
//
// [CreateDelivery]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html
func (c *Client) DescribeConfigurationTemplates(ctx context.Context, params *DescribeConfigurationTemplatesInput, optFns ...func(*Options)) (*DescribeConfigurationTemplatesOutput, error) {
	if params == nil {
		params = &DescribeConfigurationTemplatesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeConfigurationTemplates", params, optFns, c.addOperationDescribeConfigurationTemplatesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeConfigurationTemplatesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeConfigurationTemplatesInput struct {

	// Use this parameter to filter the response to include only the configuration
	// templates that apply to the delivery destination types that you specify here.
	DeliveryDestinationTypes []types.DeliveryDestinationType

	// Use this parameter to limit the number of configuration templates that are
	// returned in the response.
	Limit *int32

	// Use this parameter to filter the response to include only the configuration
	// templates that apply to the log types that you specify here.
	LogTypes []string

	// The token for the next set of items to return. The token expires after 24 hours.
	NextToken *string

	// Use this parameter to filter the response to include only the configuration
	// templates that apply to the resource types that you specify here.
	ResourceTypes []string

	// Use this parameter to filter the response to include only the configuration
	// templates that apply to the Amazon Web Services service that you specify here.
	Service *string

	noSmithyDocumentSerde
}

type DescribeConfigurationTemplatesOutput struct {

	// An array of objects, where each object describes one configuration template
	// that matches the filters that you specified in the request.
	ConfigurationTemplates []types.ConfigurationTemplate

	// The token for the next set of items to return. The token expires after 24 hours.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeConfigurationTemplatesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeConfigurationTemplates{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeConfigurationTemplates{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeConfigurationTemplates"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeConfigurationTemplates(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeConfigurationTemplatesPaginatorOptions is the paginator options for
// DescribeConfigurationTemplates
type DescribeConfigurationTemplatesPaginatorOptions struct {
	// Use this parameter to limit the number of configuration templates that are
	// returned in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeConfigurationTemplatesPaginator is a paginator for
// DescribeConfigurationTemplates
type DescribeConfigurationTemplatesPaginator struct {
	options   DescribeConfigurationTemplatesPaginatorOptions
	client    DescribeConfigurationTemplatesAPIClient
	params    *DescribeConfigurationTemplatesInput
	nextToken *string
	firstPage bool
}

// NewDescribeConfigurationTemplatesPaginator returns a new
// DescribeConfigurationTemplatesPaginator
func NewDescribeConfigurationTemplatesPaginator(client DescribeConfigurationTemplatesAPIClient, params *DescribeConfigurationTemplatesInput, optFns ...func(*DescribeConfigurationTemplatesPaginatorOptions)) *DescribeConfigurationTemplatesPaginator {
	if params == nil {
		params = &DescribeConfigurationTemplatesInput{}
	}

	options := DescribeConfigurationTemplatesPaginatorOptions{}
	if params.Limit != nil {
		options.Limit = *params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeConfigurationTemplatesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeConfigurationTemplatesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeConfigurationTemplates page.
func (p *DescribeConfigurationTemplatesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeConfigurationTemplatesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.Limit = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeConfigurationTemplates(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeConfigurationTemplatesAPIClient is a client that implements the
// DescribeConfigurationTemplates operation.
type DescribeConfigurationTemplatesAPIClient interface {
	DescribeConfigurationTemplates(context.Context, *DescribeConfigurationTemplatesInput, ...func(*Options)) (*DescribeConfigurationTemplatesOutput, error)
}

var _ DescribeConfigurationTemplatesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeConfigurationTemplates(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeConfigurationTemplates",
	}
}
