// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/pubsub/v1/pubsub.proto

package pubsubpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Publisher_CreateTopic_FullMethodName            = "/google.pubsub.v1.Publisher/CreateTopic"
	Publisher_UpdateTopic_FullMethodName            = "/google.pubsub.v1.Publisher/UpdateTopic"
	Publisher_Publish_FullMethodName                = "/google.pubsub.v1.Publisher/Publish"
	Publisher_GetTopic_FullMethodName               = "/google.pubsub.v1.Publisher/GetTopic"
	Publisher_ListTopics_FullMethodName             = "/google.pubsub.v1.Publisher/ListTopics"
	Publisher_ListTopicSubscriptions_FullMethodName = "/google.pubsub.v1.Publisher/ListTopicSubscriptions"
	Publisher_ListTopicSnapshots_FullMethodName     = "/google.pubsub.v1.Publisher/ListTopicSnapshots"
	Publisher_DeleteTopic_FullMethodName            = "/google.pubsub.v1.Publisher/DeleteTopic"
	Publisher_DetachSubscription_FullMethodName     = "/google.pubsub.v1.Publisher/DetachSubscription"
)

// PublisherClient is the client API for Publisher service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PublisherClient interface {
	// Creates the given topic with the given name. See the [resource name rules]
	// (https://cloud.google.com/pubsub/docs/pubsub-basics#resource_names).
	CreateTopic(ctx context.Context, in *Topic, opts ...grpc.CallOption) (*Topic, error)
	// Updates an existing topic by updating the fields specified in the update
	// mask. Note that certain properties of a topic are not modifiable.
	UpdateTopic(ctx context.Context, in *UpdateTopicRequest, opts ...grpc.CallOption) (*Topic, error)
	// Adds one or more messages to the topic. Returns `NOT_FOUND` if the topic
	// does not exist.
	Publish(ctx context.Context, in *PublishRequest, opts ...grpc.CallOption) (*PublishResponse, error)
	// Gets the configuration of a topic.
	GetTopic(ctx context.Context, in *GetTopicRequest, opts ...grpc.CallOption) (*Topic, error)
	// Lists matching topics.
	ListTopics(ctx context.Context, in *ListTopicsRequest, opts ...grpc.CallOption) (*ListTopicsResponse, error)
	// Lists the names of the attached subscriptions on this topic.
	ListTopicSubscriptions(ctx context.Context, in *ListTopicSubscriptionsRequest, opts ...grpc.CallOption) (*ListTopicSubscriptionsResponse, error)
	// Lists the names of the snapshots on this topic. Snapshots are used in
	// [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
	// which allow you to manage message acknowledgments in bulk. That is, you can
	// set the acknowledgment state of messages in an existing subscription to the
	// state captured by a snapshot.
	ListTopicSnapshots(ctx context.Context, in *ListTopicSnapshotsRequest, opts ...grpc.CallOption) (*ListTopicSnapshotsResponse, error)
	// Deletes the topic with the given name. Returns `NOT_FOUND` if the topic
	// does not exist. After a topic is deleted, a new topic may be created with
	// the same name; this is an entirely new topic with none of the old
	// configuration or subscriptions. Existing subscriptions to this topic are
	// not deleted, but their `topic` field is set to `_deleted-topic_`.
	DeleteTopic(ctx context.Context, in *DeleteTopicRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Detaches a subscription from this topic. All messages retained in the
	// subscription are dropped. Subsequent `Pull` and `StreamingPull` requests
	// will return FAILED_PRECONDITION. If the subscription is a push
	// subscription, pushes to the endpoint will stop.
	DetachSubscription(ctx context.Context, in *DetachSubscriptionRequest, opts ...grpc.CallOption) (*DetachSubscriptionResponse, error)
}

type publisherClient struct {
	cc grpc.ClientConnInterface
}

func NewPublisherClient(cc grpc.ClientConnInterface) PublisherClient {
	return &publisherClient{cc}
}

func (c *publisherClient) CreateTopic(ctx context.Context, in *Topic, opts ...grpc.CallOption) (*Topic, error) {
	out := new(Topic)
	err := c.cc.Invoke(ctx, Publisher_CreateTopic_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) UpdateTopic(ctx context.Context, in *UpdateTopicRequest, opts ...grpc.CallOption) (*Topic, error) {
	out := new(Topic)
	err := c.cc.Invoke(ctx, Publisher_UpdateTopic_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) Publish(ctx context.Context, in *PublishRequest, opts ...grpc.CallOption) (*PublishResponse, error) {
	out := new(PublishResponse)
	err := c.cc.Invoke(ctx, Publisher_Publish_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) GetTopic(ctx context.Context, in *GetTopicRequest, opts ...grpc.CallOption) (*Topic, error) {
	out := new(Topic)
	err := c.cc.Invoke(ctx, Publisher_GetTopic_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) ListTopics(ctx context.Context, in *ListTopicsRequest, opts ...grpc.CallOption) (*ListTopicsResponse, error) {
	out := new(ListTopicsResponse)
	err := c.cc.Invoke(ctx, Publisher_ListTopics_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) ListTopicSubscriptions(ctx context.Context, in *ListTopicSubscriptionsRequest, opts ...grpc.CallOption) (*ListTopicSubscriptionsResponse, error) {
	out := new(ListTopicSubscriptionsResponse)
	err := c.cc.Invoke(ctx, Publisher_ListTopicSubscriptions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) ListTopicSnapshots(ctx context.Context, in *ListTopicSnapshotsRequest, opts ...grpc.CallOption) (*ListTopicSnapshotsResponse, error) {
	out := new(ListTopicSnapshotsResponse)
	err := c.cc.Invoke(ctx, Publisher_ListTopicSnapshots_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) DeleteTopic(ctx context.Context, in *DeleteTopicRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Publisher_DeleteTopic_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) DetachSubscription(ctx context.Context, in *DetachSubscriptionRequest, opts ...grpc.CallOption) (*DetachSubscriptionResponse, error) {
	out := new(DetachSubscriptionResponse)
	err := c.cc.Invoke(ctx, Publisher_DetachSubscription_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PublisherServer is the server API for Publisher service.
// All implementations should embed UnimplementedPublisherServer
// for forward compatibility
type PublisherServer interface {
	// Creates the given topic with the given name. See the [resource name rules]
	// (https://cloud.google.com/pubsub/docs/pubsub-basics#resource_names).
	CreateTopic(context.Context, *Topic) (*Topic, error)
	// Updates an existing topic by updating the fields specified in the update
	// mask. Note that certain properties of a topic are not modifiable.
	UpdateTopic(context.Context, *UpdateTopicRequest) (*Topic, error)
	// Adds one or more messages to the topic. Returns `NOT_FOUND` if the topic
	// does not exist.
	Publish(context.Context, *PublishRequest) (*PublishResponse, error)
	// Gets the configuration of a topic.
	GetTopic(context.Context, *GetTopicRequest) (*Topic, error)
	// Lists matching topics.
	ListTopics(context.Context, *ListTopicsRequest) (*ListTopicsResponse, error)
	// Lists the names of the attached subscriptions on this topic.
	ListTopicSubscriptions(context.Context, *ListTopicSubscriptionsRequest) (*ListTopicSubscriptionsResponse, error)
	// Lists the names of the snapshots on this topic. Snapshots are used in
	// [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
	// which allow you to manage message acknowledgments in bulk. That is, you can
	// set the acknowledgment state of messages in an existing subscription to the
	// state captured by a snapshot.
	ListTopicSnapshots(context.Context, *ListTopicSnapshotsRequest) (*ListTopicSnapshotsResponse, error)
	// Deletes the topic with the given name. Returns `NOT_FOUND` if the topic
	// does not exist. After a topic is deleted, a new topic may be created with
	// the same name; this is an entirely new topic with none of the old
	// configuration or subscriptions. Existing subscriptions to this topic are
	// not deleted, but their `topic` field is set to `_deleted-topic_`.
	DeleteTopic(context.Context, *DeleteTopicRequest) (*emptypb.Empty, error)
	// Detaches a subscription from this topic. All messages retained in the
	// subscription are dropped. Subsequent `Pull` and `StreamingPull` requests
	// will return FAILED_PRECONDITION. If the subscription is a push
	// subscription, pushes to the endpoint will stop.
	DetachSubscription(context.Context, *DetachSubscriptionRequest) (*DetachSubscriptionResponse, error)
}

// UnimplementedPublisherServer should be embedded to have forward compatible implementations.
type UnimplementedPublisherServer struct {
}

func (UnimplementedPublisherServer) CreateTopic(context.Context, *Topic) (*Topic, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTopic not implemented")
}
func (UnimplementedPublisherServer) UpdateTopic(context.Context, *UpdateTopicRequest) (*Topic, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTopic not implemented")
}
func (UnimplementedPublisherServer) Publish(context.Context, *PublishRequest) (*PublishResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Publish not implemented")
}
func (UnimplementedPublisherServer) GetTopic(context.Context, *GetTopicRequest) (*Topic, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTopic not implemented")
}
func (UnimplementedPublisherServer) ListTopics(context.Context, *ListTopicsRequest) (*ListTopicsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTopics not implemented")
}
func (UnimplementedPublisherServer) ListTopicSubscriptions(context.Context, *ListTopicSubscriptionsRequest) (*ListTopicSubscriptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTopicSubscriptions not implemented")
}
func (UnimplementedPublisherServer) ListTopicSnapshots(context.Context, *ListTopicSnapshotsRequest) (*ListTopicSnapshotsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTopicSnapshots not implemented")
}
func (UnimplementedPublisherServer) DeleteTopic(context.Context, *DeleteTopicRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTopic not implemented")
}
func (UnimplementedPublisherServer) DetachSubscription(context.Context, *DetachSubscriptionRequest) (*DetachSubscriptionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetachSubscription not implemented")
}

// UnsafePublisherServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PublisherServer will
// result in compilation errors.
type UnsafePublisherServer interface {
	mustEmbedUnimplementedPublisherServer()
}

func RegisterPublisherServer(s grpc.ServiceRegistrar, srv PublisherServer) {
	s.RegisterService(&Publisher_ServiceDesc, srv)
}

func _Publisher_CreateTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Topic)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).CreateTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Publisher_CreateTopic_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).CreateTopic(ctx, req.(*Topic))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_UpdateTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTopicRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).UpdateTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Publisher_UpdateTopic_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).UpdateTopic(ctx, req.(*UpdateTopicRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_Publish_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublishRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).Publish(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Publisher_Publish_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).Publish(ctx, req.(*PublishRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_GetTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTopicRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).GetTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Publisher_GetTopic_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).GetTopic(ctx, req.(*GetTopicRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_ListTopics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTopicsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).ListTopics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Publisher_ListTopics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).ListTopics(ctx, req.(*ListTopicsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_ListTopicSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTopicSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).ListTopicSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Publisher_ListTopicSubscriptions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).ListTopicSubscriptions(ctx, req.(*ListTopicSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_ListTopicSnapshots_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTopicSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).ListTopicSnapshots(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Publisher_ListTopicSnapshots_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).ListTopicSnapshots(ctx, req.(*ListTopicSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_DeleteTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTopicRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).DeleteTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Publisher_DeleteTopic_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).DeleteTopic(ctx, req.(*DeleteTopicRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_DetachSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetachSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).DetachSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Publisher_DetachSubscription_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).DetachSubscription(ctx, req.(*DetachSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Publisher_ServiceDesc is the grpc.ServiceDesc for Publisher service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Publisher_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.v1.Publisher",
	HandlerType: (*PublisherServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTopic",
			Handler:    _Publisher_CreateTopic_Handler,
		},
		{
			MethodName: "UpdateTopic",
			Handler:    _Publisher_UpdateTopic_Handler,
		},
		{
			MethodName: "Publish",
			Handler:    _Publisher_Publish_Handler,
		},
		{
			MethodName: "GetTopic",
			Handler:    _Publisher_GetTopic_Handler,
		},
		{
			MethodName: "ListTopics",
			Handler:    _Publisher_ListTopics_Handler,
		},
		{
			MethodName: "ListTopicSubscriptions",
			Handler:    _Publisher_ListTopicSubscriptions_Handler,
		},
		{
			MethodName: "ListTopicSnapshots",
			Handler:    _Publisher_ListTopicSnapshots_Handler,
		},
		{
			MethodName: "DeleteTopic",
			Handler:    _Publisher_DeleteTopic_Handler,
		},
		{
			MethodName: "DetachSubscription",
			Handler:    _Publisher_DetachSubscription_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/pubsub/v1/pubsub.proto",
}

const (
	Subscriber_CreateSubscription_FullMethodName = "/google.pubsub.v1.Subscriber/CreateSubscription"
	Subscriber_GetSubscription_FullMethodName    = "/google.pubsub.v1.Subscriber/GetSubscription"
	Subscriber_UpdateSubscription_FullMethodName = "/google.pubsub.v1.Subscriber/UpdateSubscription"
	Subscriber_ListSubscriptions_FullMethodName  = "/google.pubsub.v1.Subscriber/ListSubscriptions"
	Subscriber_DeleteSubscription_FullMethodName = "/google.pubsub.v1.Subscriber/DeleteSubscription"
	Subscriber_ModifyAckDeadline_FullMethodName  = "/google.pubsub.v1.Subscriber/ModifyAckDeadline"
	Subscriber_Acknowledge_FullMethodName        = "/google.pubsub.v1.Subscriber/Acknowledge"
	Subscriber_Pull_FullMethodName               = "/google.pubsub.v1.Subscriber/Pull"
	Subscriber_StreamingPull_FullMethodName      = "/google.pubsub.v1.Subscriber/StreamingPull"
	Subscriber_ModifyPushConfig_FullMethodName   = "/google.pubsub.v1.Subscriber/ModifyPushConfig"
	Subscriber_GetSnapshot_FullMethodName        = "/google.pubsub.v1.Subscriber/GetSnapshot"
	Subscriber_ListSnapshots_FullMethodName      = "/google.pubsub.v1.Subscriber/ListSnapshots"
	Subscriber_CreateSnapshot_FullMethodName     = "/google.pubsub.v1.Subscriber/CreateSnapshot"
	Subscriber_UpdateSnapshot_FullMethodName     = "/google.pubsub.v1.Subscriber/UpdateSnapshot"
	Subscriber_DeleteSnapshot_FullMethodName     = "/google.pubsub.v1.Subscriber/DeleteSnapshot"
	Subscriber_Seek_FullMethodName               = "/google.pubsub.v1.Subscriber/Seek"
)

// SubscriberClient is the client API for Subscriber service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SubscriberClient interface {
	// Creates a subscription to a given topic. See the [resource name rules]
	// (https://cloud.google.com/pubsub/docs/pubsub-basics#resource_names).
	// If the subscription already exists, returns `ALREADY_EXISTS`.
	// If the corresponding topic doesn't exist, returns `NOT_FOUND`.
	//
	// If the name is not provided in the request, the server will assign a random
	// name for this subscription on the same project as the topic, conforming
	// to the [resource name format]
	// (https://cloud.google.com/pubsub/docs/pubsub-basics#resource_names). The
	// generated name is populated in the returned Subscription object. Note that
	// for REST API requests, you must specify a name in the request.
	CreateSubscription(ctx context.Context, in *Subscription, opts ...grpc.CallOption) (*Subscription, error)
	// Gets the configuration details of a subscription.
	GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error)
	// Updates an existing subscription by updating the fields specified in the
	// update mask. Note that certain properties of a subscription, such as its
	// topic, are not modifiable.
	UpdateSubscription(ctx context.Context, in *UpdateSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error)
	// Lists matching subscriptions.
	ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription. All messages retained in the subscription
	// are immediately dropped. Calls to `Pull` after deletion will return
	// `NOT_FOUND`. After a subscription is deleted, a new one may be created with
	// the same name, but the new one has no association with the old
	// subscription or its topic unless the same topic is specified.
	DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Modifies the ack deadline for a specific message. This method is useful
	// to indicate that more time is needed to process a message by the
	// subscriber, or to make the message available for redelivery if the
	// processing was interrupted. Note that this does not modify the
	// subscription-level `ackDeadlineSeconds` used for subsequent messages.
	ModifyAckDeadline(ctx context.Context, in *ModifyAckDeadlineRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Acknowledges the messages associated with the `ack_ids` in the
	// `AcknowledgeRequest`. The Pub/Sub system can remove the relevant messages
	// from the subscription.
	//
	// Acknowledging a message whose ack deadline has expired may succeed,
	// but such a message may be redelivered later. Acknowledging a message more
	// than once will not result in an error.
	Acknowledge(ctx context.Context, in *AcknowledgeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Pulls messages from the server.
	Pull(ctx context.Context, in *PullRequest, opts ...grpc.CallOption) (*PullResponse, error)
	// Establishes a stream with the server, which sends messages down to the
	// client. The client streams acknowledgments and ack deadline modifications
	// back to the server. The server will close the stream and return the status
	// on any error. The server may close the stream with status `UNAVAILABLE` to
	// reassign server-side resources, in which case, the client should
	// re-establish the stream. Flow control can be achieved by configuring the
	// underlying RPC channel.
	StreamingPull(ctx context.Context, opts ...grpc.CallOption) (Subscriber_StreamingPullClient, error)
	// Modifies the `PushConfig` for a specified subscription.
	//
	// This may be used to change a push subscription to a pull one (signified by
	// an empty `PushConfig`) or vice versa, or change the endpoint URL and other
	// attributes of a push subscription. Messages will accumulate for delivery
	// continuously through the call regardless of changes to the `PushConfig`.
	ModifyPushConfig(ctx context.Context, in *ModifyPushConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets the configuration details of a snapshot. Snapshots are used in
	// [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
	// which allow you to manage message acknowledgments in bulk. That is, you can
	// set the acknowledgment state of messages in an existing subscription to the
	// state captured by a snapshot.
	GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error)
	// Lists the existing snapshots. Snapshots are used in [Seek](
	// https://cloud.google.com/pubsub/docs/replay-overview) operations, which
	// allow you to manage message acknowledgments in bulk. That is, you can set
	// the acknowledgment state of messages in an existing subscription to the
	// state captured by a snapshot.
	ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error)
	// Creates a snapshot from the requested subscription. Snapshots are used in
	// [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
	// which allow you to manage message acknowledgments in bulk. That is, you can
	// set the acknowledgment state of messages in an existing subscription to the
	// state captured by a snapshot.
	// If the snapshot already exists, returns `ALREADY_EXISTS`.
	// If the requested subscription doesn't exist, returns `NOT_FOUND`.
	// If the backlog in the subscription is too old -- and the resulting snapshot
	// would expire in less than 1 hour -- then `FAILED_PRECONDITION` is returned.
	// See also the `Snapshot.expire_time` field. If the name is not provided in
	// the request, the server will assign a random
	// name for this snapshot on the same project as the subscription, conforming
	// to the [resource name format]
	// (https://cloud.google.com/pubsub/docs/pubsub-basics#resource_names). The
	// generated name is populated in the returned Snapshot object. Note that for
	// REST API requests, you must specify a name in the request.
	CreateSnapshot(ctx context.Context, in *CreateSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error)
	// Updates an existing snapshot by updating the fields specified in the update
	// mask. Snapshots are used in
	// [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
	// which allow you to manage message acknowledgments in bulk. That is, you can
	// set the acknowledgment state of messages in an existing subscription to the
	// state captured by a snapshot.
	UpdateSnapshot(ctx context.Context, in *UpdateSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error)
	// Removes an existing snapshot. Snapshots are used in [Seek]
	// (https://cloud.google.com/pubsub/docs/replay-overview) operations, which
	// allow you to manage message acknowledgments in bulk. That is, you can set
	// the acknowledgment state of messages in an existing subscription to the
	// state captured by a snapshot.
	// When the snapshot is deleted, all messages retained in the snapshot
	// are immediately dropped. After a snapshot is deleted, a new one may be
	// created with the same name, but the new one has no association with the old
	// snapshot or its subscription, unless the same subscription is specified.
	DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Seeks an existing subscription to a point in time or to a given snapshot,
	// whichever is provided in the request. Snapshots are used in [Seek]
	// (https://cloud.google.com/pubsub/docs/replay-overview) operations, which
	// allow you to manage message acknowledgments in bulk. That is, you can set
	// the acknowledgment state of messages in an existing subscription to the
	// state captured by a snapshot. Note that both the subscription and the
	// snapshot must be on the same topic.
	Seek(ctx context.Context, in *SeekRequest, opts ...grpc.CallOption) (*SeekResponse, error)
}

type subscriberClient struct {
	cc grpc.ClientConnInterface
}

func NewSubscriberClient(cc grpc.ClientConnInterface) SubscriberClient {
	return &subscriberClient{cc}
}

func (c *subscriberClient) CreateSubscription(ctx context.Context, in *Subscription, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := c.cc.Invoke(ctx, Subscriber_CreateSubscription_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := c.cc.Invoke(ctx, Subscriber_GetSubscription_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) UpdateSubscription(ctx context.Context, in *UpdateSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := c.cc.Invoke(ctx, Subscriber_UpdateSubscription_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error) {
	out := new(ListSubscriptionsResponse)
	err := c.cc.Invoke(ctx, Subscriber_ListSubscriptions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Subscriber_DeleteSubscription_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ModifyAckDeadline(ctx context.Context, in *ModifyAckDeadlineRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Subscriber_ModifyAckDeadline_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Acknowledge(ctx context.Context, in *AcknowledgeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Subscriber_Acknowledge_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Pull(ctx context.Context, in *PullRequest, opts ...grpc.CallOption) (*PullResponse, error) {
	out := new(PullResponse)
	err := c.cc.Invoke(ctx, Subscriber_Pull_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) StreamingPull(ctx context.Context, opts ...grpc.CallOption) (Subscriber_StreamingPullClient, error) {
	stream, err := c.cc.NewStream(ctx, &Subscriber_ServiceDesc.Streams[0], Subscriber_StreamingPull_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &subscriberStreamingPullClient{stream}
	return x, nil
}

type Subscriber_StreamingPullClient interface {
	Send(*StreamingPullRequest) error
	Recv() (*StreamingPullResponse, error)
	grpc.ClientStream
}

type subscriberStreamingPullClient struct {
	grpc.ClientStream
}

func (x *subscriberStreamingPullClient) Send(m *StreamingPullRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *subscriberStreamingPullClient) Recv() (*StreamingPullResponse, error) {
	m := new(StreamingPullResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *subscriberClient) ModifyPushConfig(ctx context.Context, in *ModifyPushConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Subscriber_ModifyPushConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error) {
	out := new(Snapshot)
	err := c.cc.Invoke(ctx, Subscriber_GetSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error) {
	out := new(ListSnapshotsResponse)
	err := c.cc.Invoke(ctx, Subscriber_ListSnapshots_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) CreateSnapshot(ctx context.Context, in *CreateSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error) {
	out := new(Snapshot)
	err := c.cc.Invoke(ctx, Subscriber_CreateSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) UpdateSnapshot(ctx context.Context, in *UpdateSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error) {
	out := new(Snapshot)
	err := c.cc.Invoke(ctx, Subscriber_UpdateSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Subscriber_DeleteSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Seek(ctx context.Context, in *SeekRequest, opts ...grpc.CallOption) (*SeekResponse, error) {
	out := new(SeekResponse)
	err := c.cc.Invoke(ctx, Subscriber_Seek_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SubscriberServer is the server API for Subscriber service.
// All implementations should embed UnimplementedSubscriberServer
// for forward compatibility
type SubscriberServer interface {
	// Creates a subscription to a given topic. See the [resource name rules]
	// (https://cloud.google.com/pubsub/docs/pubsub-basics#resource_names).
	// If the subscription already exists, returns `ALREADY_EXISTS`.
	// If the corresponding topic doesn't exist, returns `NOT_FOUND`.
	//
	// If the name is not provided in the request, the server will assign a random
	// name for this subscription on the same project as the topic, conforming
	// to the [resource name format]
	// (https://cloud.google.com/pubsub/docs/pubsub-basics#resource_names). The
	// generated name is populated in the returned Subscription object. Note that
	// for REST API requests, you must specify a name in the request.
	CreateSubscription(context.Context, *Subscription) (*Subscription, error)
	// Gets the configuration details of a subscription.
	GetSubscription(context.Context, *GetSubscriptionRequest) (*Subscription, error)
	// Updates an existing subscription by updating the fields specified in the
	// update mask. Note that certain properties of a subscription, such as its
	// topic, are not modifiable.
	UpdateSubscription(context.Context, *UpdateSubscriptionRequest) (*Subscription, error)
	// Lists matching subscriptions.
	ListSubscriptions(context.Context, *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription. All messages retained in the subscription
	// are immediately dropped. Calls to `Pull` after deletion will return
	// `NOT_FOUND`. After a subscription is deleted, a new one may be created with
	// the same name, but the new one has no association with the old
	// subscription or its topic unless the same topic is specified.
	DeleteSubscription(context.Context, *DeleteSubscriptionRequest) (*emptypb.Empty, error)
	// Modifies the ack deadline for a specific message. This method is useful
	// to indicate that more time is needed to process a message by the
	// subscriber, or to make the message available for redelivery if the
	// processing was interrupted. Note that this does not modify the
	// subscription-level `ackDeadlineSeconds` used for subsequent messages.
	ModifyAckDeadline(context.Context, *ModifyAckDeadlineRequest) (*emptypb.Empty, error)
	// Acknowledges the messages associated with the `ack_ids` in the
	// `AcknowledgeRequest`. The Pub/Sub system can remove the relevant messages
	// from the subscription.
	//
	// Acknowledging a message whose ack deadline has expired may succeed,
	// but such a message may be redelivered later. Acknowledging a message more
	// than once will not result in an error.
	Acknowledge(context.Context, *AcknowledgeRequest) (*emptypb.Empty, error)
	// Pulls messages from the server.
	Pull(context.Context, *PullRequest) (*PullResponse, error)
	// Establishes a stream with the server, which sends messages down to the
	// client. The client streams acknowledgments and ack deadline modifications
	// back to the server. The server will close the stream and return the status
	// on any error. The server may close the stream with status `UNAVAILABLE` to
	// reassign server-side resources, in which case, the client should
	// re-establish the stream. Flow control can be achieved by configuring the
	// underlying RPC channel.
	StreamingPull(Subscriber_StreamingPullServer) error
	// Modifies the `PushConfig` for a specified subscription.
	//
	// This may be used to change a push subscription to a pull one (signified by
	// an empty `PushConfig`) or vice versa, or change the endpoint URL and other
	// attributes of a push subscription. Messages will accumulate for delivery
	// continuously through the call regardless of changes to the `PushConfig`.
	ModifyPushConfig(context.Context, *ModifyPushConfigRequest) (*emptypb.Empty, error)
	// Gets the configuration details of a snapshot. Snapshots are used in
	// [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
	// which allow you to manage message acknowledgments in bulk. That is, you can
	// set the acknowledgment state of messages in an existing subscription to the
	// state captured by a snapshot.
	GetSnapshot(context.Context, *GetSnapshotRequest) (*Snapshot, error)
	// Lists the existing snapshots. Snapshots are used in [Seek](
	// https://cloud.google.com/pubsub/docs/replay-overview) operations, which
	// allow you to manage message acknowledgments in bulk. That is, you can set
	// the acknowledgment state of messages in an existing subscription to the
	// state captured by a snapshot.
	ListSnapshots(context.Context, *ListSnapshotsRequest) (*ListSnapshotsResponse, error)
	// Creates a snapshot from the requested subscription. Snapshots are used in
	// [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
	// which allow you to manage message acknowledgments in bulk. That is, you can
	// set the acknowledgment state of messages in an existing subscription to the
	// state captured by a snapshot.
	// If the snapshot already exists, returns `ALREADY_EXISTS`.
	// If the requested subscription doesn't exist, returns `NOT_FOUND`.
	// If the backlog in the subscription is too old -- and the resulting snapshot
	// would expire in less than 1 hour -- then `FAILED_PRECONDITION` is returned.
	// See also the `Snapshot.expire_time` field. If the name is not provided in
	// the request, the server will assign a random
	// name for this snapshot on the same project as the subscription, conforming
	// to the [resource name format]
	// (https://cloud.google.com/pubsub/docs/pubsub-basics#resource_names). The
	// generated name is populated in the returned Snapshot object. Note that for
	// REST API requests, you must specify a name in the request.
	CreateSnapshot(context.Context, *CreateSnapshotRequest) (*Snapshot, error)
	// Updates an existing snapshot by updating the fields specified in the update
	// mask. Snapshots are used in
	// [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
	// which allow you to manage message acknowledgments in bulk. That is, you can
	// set the acknowledgment state of messages in an existing subscription to the
	// state captured by a snapshot.
	UpdateSnapshot(context.Context, *UpdateSnapshotRequest) (*Snapshot, error)
	// Removes an existing snapshot. Snapshots are used in [Seek]
	// (https://cloud.google.com/pubsub/docs/replay-overview) operations, which
	// allow you to manage message acknowledgments in bulk. That is, you can set
	// the acknowledgment state of messages in an existing subscription to the
	// state captured by a snapshot.
	// When the snapshot is deleted, all messages retained in the snapshot
	// are immediately dropped. After a snapshot is deleted, a new one may be
	// created with the same name, but the new one has no association with the old
	// snapshot or its subscription, unless the same subscription is specified.
	DeleteSnapshot(context.Context, *DeleteSnapshotRequest) (*emptypb.Empty, error)
	// Seeks an existing subscription to a point in time or to a given snapshot,
	// whichever is provided in the request. Snapshots are used in [Seek]
	// (https://cloud.google.com/pubsub/docs/replay-overview) operations, which
	// allow you to manage message acknowledgments in bulk. That is, you can set
	// the acknowledgment state of messages in an existing subscription to the
	// state captured by a snapshot. Note that both the subscription and the
	// snapshot must be on the same topic.
	Seek(context.Context, *SeekRequest) (*SeekResponse, error)
}

// UnimplementedSubscriberServer should be embedded to have forward compatible implementations.
type UnimplementedSubscriberServer struct {
}

func (UnimplementedSubscriberServer) CreateSubscription(context.Context, *Subscription) (*Subscription, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSubscription not implemented")
}
func (UnimplementedSubscriberServer) GetSubscription(context.Context, *GetSubscriptionRequest) (*Subscription, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSubscription not implemented")
}
func (UnimplementedSubscriberServer) UpdateSubscription(context.Context, *UpdateSubscriptionRequest) (*Subscription, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSubscription not implemented")
}
func (UnimplementedSubscriberServer) ListSubscriptions(context.Context, *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSubscriptions not implemented")
}
func (UnimplementedSubscriberServer) DeleteSubscription(context.Context, *DeleteSubscriptionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSubscription not implemented")
}
func (UnimplementedSubscriberServer) ModifyAckDeadline(context.Context, *ModifyAckDeadlineRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyAckDeadline not implemented")
}
func (UnimplementedSubscriberServer) Acknowledge(context.Context, *AcknowledgeRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Acknowledge not implemented")
}
func (UnimplementedSubscriberServer) Pull(context.Context, *PullRequest) (*PullResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Pull not implemented")
}
func (UnimplementedSubscriberServer) StreamingPull(Subscriber_StreamingPullServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingPull not implemented")
}
func (UnimplementedSubscriberServer) ModifyPushConfig(context.Context, *ModifyPushConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyPushConfig not implemented")
}
func (UnimplementedSubscriberServer) GetSnapshot(context.Context, *GetSnapshotRequest) (*Snapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSnapshot not implemented")
}
func (UnimplementedSubscriberServer) ListSnapshots(context.Context, *ListSnapshotsRequest) (*ListSnapshotsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSnapshots not implemented")
}
func (UnimplementedSubscriberServer) CreateSnapshot(context.Context, *CreateSnapshotRequest) (*Snapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSnapshot not implemented")
}
func (UnimplementedSubscriberServer) UpdateSnapshot(context.Context, *UpdateSnapshotRequest) (*Snapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSnapshot not implemented")
}
func (UnimplementedSubscriberServer) DeleteSnapshot(context.Context, *DeleteSnapshotRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSnapshot not implemented")
}
func (UnimplementedSubscriberServer) Seek(context.Context, *SeekRequest) (*SeekResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Seek not implemented")
}

// UnsafeSubscriberServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SubscriberServer will
// result in compilation errors.
type UnsafeSubscriberServer interface {
	mustEmbedUnimplementedSubscriberServer()
}

func RegisterSubscriberServer(s grpc.ServiceRegistrar, srv SubscriberServer) {
	s.RegisterService(&Subscriber_ServiceDesc, srv)
}

func _Subscriber_CreateSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Subscription)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).CreateSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Subscriber_CreateSubscription_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).CreateSubscription(ctx, req.(*Subscription))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_GetSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).GetSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Subscriber_GetSubscription_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).GetSubscription(ctx, req.(*GetSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_UpdateSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).UpdateSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Subscriber_UpdateSubscription_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).UpdateSubscription(ctx, req.(*UpdateSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ListSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ListSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Subscriber_ListSubscriptions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ListSubscriptions(ctx, req.(*ListSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_DeleteSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).DeleteSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Subscriber_DeleteSubscription_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).DeleteSubscription(ctx, req.(*DeleteSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ModifyAckDeadline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyAckDeadlineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ModifyAckDeadline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Subscriber_ModifyAckDeadline_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ModifyAckDeadline(ctx, req.(*ModifyAckDeadlineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Acknowledge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcknowledgeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Acknowledge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Subscriber_Acknowledge_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Acknowledge(ctx, req.(*AcknowledgeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Pull_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PullRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Pull(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Subscriber_Pull_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Pull(ctx, req.(*PullRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_StreamingPull_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SubscriberServer).StreamingPull(&subscriberStreamingPullServer{stream})
}

type Subscriber_StreamingPullServer interface {
	Send(*StreamingPullResponse) error
	Recv() (*StreamingPullRequest, error)
	grpc.ServerStream
}

type subscriberStreamingPullServer struct {
	grpc.ServerStream
}

func (x *subscriberStreamingPullServer) Send(m *StreamingPullResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *subscriberStreamingPullServer) Recv() (*StreamingPullRequest, error) {
	m := new(StreamingPullRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Subscriber_ModifyPushConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyPushConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ModifyPushConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Subscriber_ModifyPushConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ModifyPushConfig(ctx, req.(*ModifyPushConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_GetSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).GetSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Subscriber_GetSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).GetSnapshot(ctx, req.(*GetSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ListSnapshots_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ListSnapshots(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Subscriber_ListSnapshots_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ListSnapshots(ctx, req.(*ListSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_CreateSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).CreateSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Subscriber_CreateSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).CreateSnapshot(ctx, req.(*CreateSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_UpdateSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).UpdateSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Subscriber_UpdateSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).UpdateSnapshot(ctx, req.(*UpdateSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_DeleteSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).DeleteSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Subscriber_DeleteSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).DeleteSnapshot(ctx, req.(*DeleteSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Seek_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SeekRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Seek(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Subscriber_Seek_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Seek(ctx, req.(*SeekRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Subscriber_ServiceDesc is the grpc.ServiceDesc for Subscriber service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Subscriber_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.v1.Subscriber",
	HandlerType: (*SubscriberServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSubscription",
			Handler:    _Subscriber_CreateSubscription_Handler,
		},
		{
			MethodName: "GetSubscription",
			Handler:    _Subscriber_GetSubscription_Handler,
		},
		{
			MethodName: "UpdateSubscription",
			Handler:    _Subscriber_UpdateSubscription_Handler,
		},
		{
			MethodName: "ListSubscriptions",
			Handler:    _Subscriber_ListSubscriptions_Handler,
		},
		{
			MethodName: "DeleteSubscription",
			Handler:    _Subscriber_DeleteSubscription_Handler,
		},
		{
			MethodName: "ModifyAckDeadline",
			Handler:    _Subscriber_ModifyAckDeadline_Handler,
		},
		{
			MethodName: "Acknowledge",
			Handler:    _Subscriber_Acknowledge_Handler,
		},
		{
			MethodName: "Pull",
			Handler:    _Subscriber_Pull_Handler,
		},
		{
			MethodName: "ModifyPushConfig",
			Handler:    _Subscriber_ModifyPushConfig_Handler,
		},
		{
			MethodName: "GetSnapshot",
			Handler:    _Subscriber_GetSnapshot_Handler,
		},
		{
			MethodName: "ListSnapshots",
			Handler:    _Subscriber_ListSnapshots_Handler,
		},
		{
			MethodName: "CreateSnapshot",
			Handler:    _Subscriber_CreateSnapshot_Handler,
		},
		{
			MethodName: "UpdateSnapshot",
			Handler:    _Subscriber_UpdateSnapshot_Handler,
		},
		{
			MethodName: "DeleteSnapshot",
			Handler:    _Subscriber_DeleteSnapshot_Handler,
		},
		{
			MethodName: "Seek",
			Handler:    _Subscriber_Seek_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingPull",
			Handler:       _Subscriber_StreamingPull_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/pubsub/v1/pubsub.proto",
}
