// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectortrace "go.opentelemetry.io/proto/slim/otlp/collector/trace/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcollectortrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportTracePartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTracePartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigExportTracePartialSuccess()
				CopyOrigExportTracePartialSuccess(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigExportTracePartialSuccess(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigExportTracePartialSuccessUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigExportTracePartialSuccess()
	UnmarshalJSONOrigExportTracePartialSuccess(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigExportTracePartialSuccess(), dest)
}

func TestMarshalAndUnmarshalJSONOrigExportTracePartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTracePartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigExportTracePartialSuccess(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigExportTracePartialSuccess()
				UnmarshalJSONOrigExportTracePartialSuccess(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigExportTracePartialSuccess(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigExportTracePartialSuccessFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportTracePartialSuccess() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigExportTracePartialSuccess()
			require.Error(t, UnmarshalProtoOrigExportTracePartialSuccess(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportTracePartialSuccessUnknown(t *testing.T) {
	dest := NewOrigExportTracePartialSuccess()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigExportTracePartialSuccess(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigExportTracePartialSuccess(), dest)
}

func TestMarshalAndUnmarshalProtoOrigExportTracePartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTracePartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigExportTracePartialSuccess(src))
				gotSize := MarshalProtoOrigExportTracePartialSuccess(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigExportTracePartialSuccess()
				require.NoError(t, UnmarshalProtoOrigExportTracePartialSuccess(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigExportTracePartialSuccess(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportTracePartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTracePartialSuccess() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportTracePartialSuccess(src))
			gotSize := MarshalProtoOrigExportTracePartialSuccess(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectortrace.ExportTracePartialSuccess{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigExportTracePartialSuccess()
			require.NoError(t, UnmarshalProtoOrigExportTracePartialSuccess(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportTracePartialSuccess() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                 {0x02},
		"RejectedSpans/wrong_wire_type": {0xc},
		"RejectedSpans/missing_value":   {0x8},
		"ErrorMessage/wrong_wire_type":  {0x14},
		"ErrorMessage/missing_value":    {0x12},
	}
}

func genTestEncodingValuesExportTracePartialSuccess() map[string]*otlpcollectortrace.ExportTracePartialSuccess {
	return map[string]*otlpcollectortrace.ExportTracePartialSuccess{
		"empty":              NewOrigExportTracePartialSuccess(),
		"RejectedSpans/test": {RejectedSpans: int64(13)},
		"ErrorMessage/test":  {ErrorMessage: "test_errormessage"},
	}
}
