// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func TestCopyOrigScopeMetricsSlice(t *testing.T) {
	src := []*otlpmetrics.ScopeMetrics{}
	dest := []*otlpmetrics.ScopeMetrics{}
	// Test CopyTo empty
	dest = CopyOrigScopeMetricsSlice(dest, src)
	assert.Equal(t, []*otlpmetrics.ScopeMetrics{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestScopeMetricsSlice()
	dest = CopyOrigScopeMetricsSlice(dest, src)
	assert.Equal(t, GenerateOrigTestScopeMetricsSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigScopeMetricsSlice(dest, src)
	assert.Equal(t, GenerateOrigTestScopeMetricsSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigScopeMetricsSlice(dest, []*otlpmetrics.ScopeMetrics{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigScopeMetricsSlice(dest, src)
	assert.Equal(t, GenerateOrigTestScopeMetricsSlice(), dest)
}
