// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/schedule_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ScheduleService_CreateSchedule_FullMethodName = "/google.cloud.aiplatform.v1beta1.ScheduleService/CreateSchedule"
	ScheduleService_DeleteSchedule_FullMethodName = "/google.cloud.aiplatform.v1beta1.ScheduleService/DeleteSchedule"
	ScheduleService_GetSchedule_FullMethodName    = "/google.cloud.aiplatform.v1beta1.ScheduleService/GetSchedule"
	ScheduleService_ListSchedules_FullMethodName  = "/google.cloud.aiplatform.v1beta1.ScheduleService/ListSchedules"
	ScheduleService_PauseSchedule_FullMethodName  = "/google.cloud.aiplatform.v1beta1.ScheduleService/PauseSchedule"
	ScheduleService_ResumeSchedule_FullMethodName = "/google.cloud.aiplatform.v1beta1.ScheduleService/ResumeSchedule"
	ScheduleService_UpdateSchedule_FullMethodName = "/google.cloud.aiplatform.v1beta1.ScheduleService/UpdateSchedule"
)

// ScheduleServiceClient is the client API for ScheduleService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ScheduleServiceClient interface {
	// Creates a Schedule.
	CreateSchedule(ctx context.Context, in *CreateScheduleRequest, opts ...grpc.CallOption) (*Schedule, error)
	// Deletes a Schedule.
	DeleteSchedule(ctx context.Context, in *DeleteScheduleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a Schedule.
	GetSchedule(ctx context.Context, in *GetScheduleRequest, opts ...grpc.CallOption) (*Schedule, error)
	// Lists Schedules in a Location.
	ListSchedules(ctx context.Context, in *ListSchedulesRequest, opts ...grpc.CallOption) (*ListSchedulesResponse, error)
	// Pauses a Schedule. Will mark
	// [Schedule.state][google.cloud.aiplatform.v1beta1.Schedule.state] to
	// 'PAUSED'. If the schedule is paused, no new runs will be created. Already
	// created runs will NOT be paused or canceled.
	PauseSchedule(ctx context.Context, in *PauseScheduleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Resumes a paused Schedule to start scheduling new runs. Will mark
	// [Schedule.state][google.cloud.aiplatform.v1beta1.Schedule.state] to
	// 'ACTIVE'. Only paused Schedule can be resumed.
	//
	// When the Schedule is resumed, new runs will be scheduled starting from the
	// next execution time after the current time based on the time_specification
	// in the Schedule. If [Schedule.catchUp][] is set up true, all
	// missed runs will be scheduled for backfill first.
	ResumeSchedule(ctx context.Context, in *ResumeScheduleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an active or paused Schedule.
	//
	// When the Schedule is updated, new runs will be scheduled starting from the
	// updated next execution time after the update time based on the
	// time_specification in the updated Schedule. All unstarted runs before the
	// update time will be skipped while already created runs will NOT be paused
	// or canceled.
	UpdateSchedule(ctx context.Context, in *UpdateScheduleRequest, opts ...grpc.CallOption) (*Schedule, error)
}

type scheduleServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewScheduleServiceClient(cc grpc.ClientConnInterface) ScheduleServiceClient {
	return &scheduleServiceClient{cc}
}

func (c *scheduleServiceClient) CreateSchedule(ctx context.Context, in *CreateScheduleRequest, opts ...grpc.CallOption) (*Schedule, error) {
	out := new(Schedule)
	err := c.cc.Invoke(ctx, ScheduleService_CreateSchedule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scheduleServiceClient) DeleteSchedule(ctx context.Context, in *DeleteScheduleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ScheduleService_DeleteSchedule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scheduleServiceClient) GetSchedule(ctx context.Context, in *GetScheduleRequest, opts ...grpc.CallOption) (*Schedule, error) {
	out := new(Schedule)
	err := c.cc.Invoke(ctx, ScheduleService_GetSchedule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scheduleServiceClient) ListSchedules(ctx context.Context, in *ListSchedulesRequest, opts ...grpc.CallOption) (*ListSchedulesResponse, error) {
	out := new(ListSchedulesResponse)
	err := c.cc.Invoke(ctx, ScheduleService_ListSchedules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scheduleServiceClient) PauseSchedule(ctx context.Context, in *PauseScheduleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ScheduleService_PauseSchedule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scheduleServiceClient) ResumeSchedule(ctx context.Context, in *ResumeScheduleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ScheduleService_ResumeSchedule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scheduleServiceClient) UpdateSchedule(ctx context.Context, in *UpdateScheduleRequest, opts ...grpc.CallOption) (*Schedule, error) {
	out := new(Schedule)
	err := c.cc.Invoke(ctx, ScheduleService_UpdateSchedule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ScheduleServiceServer is the server API for ScheduleService service.
// All implementations should embed UnimplementedScheduleServiceServer
// for forward compatibility
type ScheduleServiceServer interface {
	// Creates a Schedule.
	CreateSchedule(context.Context, *CreateScheduleRequest) (*Schedule, error)
	// Deletes a Schedule.
	DeleteSchedule(context.Context, *DeleteScheduleRequest) (*longrunningpb.Operation, error)
	// Gets a Schedule.
	GetSchedule(context.Context, *GetScheduleRequest) (*Schedule, error)
	// Lists Schedules in a Location.
	ListSchedules(context.Context, *ListSchedulesRequest) (*ListSchedulesResponse, error)
	// Pauses a Schedule. Will mark
	// [Schedule.state][google.cloud.aiplatform.v1beta1.Schedule.state] to
	// 'PAUSED'. If the schedule is paused, no new runs will be created. Already
	// created runs will NOT be paused or canceled.
	PauseSchedule(context.Context, *PauseScheduleRequest) (*emptypb.Empty, error)
	// Resumes a paused Schedule to start scheduling new runs. Will mark
	// [Schedule.state][google.cloud.aiplatform.v1beta1.Schedule.state] to
	// 'ACTIVE'. Only paused Schedule can be resumed.
	//
	// When the Schedule is resumed, new runs will be scheduled starting from the
	// next execution time after the current time based on the time_specification
	// in the Schedule. If [Schedule.catchUp][] is set up true, all
	// missed runs will be scheduled for backfill first.
	ResumeSchedule(context.Context, *ResumeScheduleRequest) (*emptypb.Empty, error)
	// Updates an active or paused Schedule.
	//
	// When the Schedule is updated, new runs will be scheduled starting from the
	// updated next execution time after the update time based on the
	// time_specification in the updated Schedule. All unstarted runs before the
	// update time will be skipped while already created runs will NOT be paused
	// or canceled.
	UpdateSchedule(context.Context, *UpdateScheduleRequest) (*Schedule, error)
}

// UnimplementedScheduleServiceServer should be embedded to have forward compatible implementations.
type UnimplementedScheduleServiceServer struct {
}

func (UnimplementedScheduleServiceServer) CreateSchedule(context.Context, *CreateScheduleRequest) (*Schedule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSchedule not implemented")
}
func (UnimplementedScheduleServiceServer) DeleteSchedule(context.Context, *DeleteScheduleRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSchedule not implemented")
}
func (UnimplementedScheduleServiceServer) GetSchedule(context.Context, *GetScheduleRequest) (*Schedule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSchedule not implemented")
}
func (UnimplementedScheduleServiceServer) ListSchedules(context.Context, *ListSchedulesRequest) (*ListSchedulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSchedules not implemented")
}
func (UnimplementedScheduleServiceServer) PauseSchedule(context.Context, *PauseScheduleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PauseSchedule not implemented")
}
func (UnimplementedScheduleServiceServer) ResumeSchedule(context.Context, *ResumeScheduleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeSchedule not implemented")
}
func (UnimplementedScheduleServiceServer) UpdateSchedule(context.Context, *UpdateScheduleRequest) (*Schedule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSchedule not implemented")
}

// UnsafeScheduleServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ScheduleServiceServer will
// result in compilation errors.
type UnsafeScheduleServiceServer interface {
	mustEmbedUnimplementedScheduleServiceServer()
}

func RegisterScheduleServiceServer(s grpc.ServiceRegistrar, srv ScheduleServiceServer) {
	s.RegisterService(&ScheduleService_ServiceDesc, srv)
}

func _ScheduleService_CreateSchedule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateScheduleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScheduleServiceServer).CreateSchedule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScheduleService_CreateSchedule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScheduleServiceServer).CreateSchedule(ctx, req.(*CreateScheduleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScheduleService_DeleteSchedule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteScheduleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScheduleServiceServer).DeleteSchedule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScheduleService_DeleteSchedule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScheduleServiceServer).DeleteSchedule(ctx, req.(*DeleteScheduleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScheduleService_GetSchedule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetScheduleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScheduleServiceServer).GetSchedule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScheduleService_GetSchedule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScheduleServiceServer).GetSchedule(ctx, req.(*GetScheduleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScheduleService_ListSchedules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSchedulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScheduleServiceServer).ListSchedules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScheduleService_ListSchedules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScheduleServiceServer).ListSchedules(ctx, req.(*ListSchedulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScheduleService_PauseSchedule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseScheduleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScheduleServiceServer).PauseSchedule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScheduleService_PauseSchedule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScheduleServiceServer).PauseSchedule(ctx, req.(*PauseScheduleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScheduleService_ResumeSchedule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeScheduleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScheduleServiceServer).ResumeSchedule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScheduleService_ResumeSchedule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScheduleServiceServer).ResumeSchedule(ctx, req.(*ResumeScheduleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScheduleService_UpdateSchedule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateScheduleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScheduleServiceServer).UpdateSchedule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScheduleService_UpdateSchedule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScheduleServiceServer).UpdateSchedule(ctx, req.(*UpdateScheduleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ScheduleService_ServiceDesc is the grpc.ServiceDesc for ScheduleService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ScheduleService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.ScheduleService",
	HandlerType: (*ScheduleServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSchedule",
			Handler:    _ScheduleService_CreateSchedule_Handler,
		},
		{
			MethodName: "DeleteSchedule",
			Handler:    _ScheduleService_DeleteSchedule_Handler,
		},
		{
			MethodName: "GetSchedule",
			Handler:    _ScheduleService_GetSchedule_Handler,
		},
		{
			MethodName: "ListSchedules",
			Handler:    _ScheduleService_ListSchedules_Handler,
		},
		{
			MethodName: "PauseSchedule",
			Handler:    _ScheduleService_PauseSchedule_Handler,
		},
		{
			MethodName: "ResumeSchedule",
			Handler:    _ScheduleService_ResumeSchedule_Handler,
		},
		{
			MethodName: "UpdateSchedule",
			Handler:    _ScheduleService_UpdateSchedule_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/schedule_service.proto",
}
