// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/evaluation_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	EvaluationService_EvaluateInstances_FullMethodName = "/google.cloud.aiplatform.v1beta1.EvaluationService/EvaluateInstances"
	EvaluationService_EvaluateDataset_FullMethodName   = "/google.cloud.aiplatform.v1beta1.EvaluationService/EvaluateDataset"
)

// EvaluationServiceClient is the client API for EvaluationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type EvaluationServiceClient interface {
	// Evaluates instances based on a given metric.
	EvaluateInstances(ctx context.Context, in *EvaluateInstancesRequest, opts ...grpc.CallOption) (*EvaluateInstancesResponse, error)
	// Evaluates a dataset based on a set of given metrics.
	EvaluateDataset(ctx context.Context, in *EvaluateDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type evaluationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewEvaluationServiceClient(cc grpc.ClientConnInterface) EvaluationServiceClient {
	return &evaluationServiceClient{cc}
}

func (c *evaluationServiceClient) EvaluateInstances(ctx context.Context, in *EvaluateInstancesRequest, opts ...grpc.CallOption) (*EvaluateInstancesResponse, error) {
	out := new(EvaluateInstancesResponse)
	err := c.cc.Invoke(ctx, EvaluationService_EvaluateInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *evaluationServiceClient) EvaluateDataset(ctx context.Context, in *EvaluateDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EvaluationService_EvaluateDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EvaluationServiceServer is the server API for EvaluationService service.
// All implementations should embed UnimplementedEvaluationServiceServer
// for forward compatibility
type EvaluationServiceServer interface {
	// Evaluates instances based on a given metric.
	EvaluateInstances(context.Context, *EvaluateInstancesRequest) (*EvaluateInstancesResponse, error)
	// Evaluates a dataset based on a set of given metrics.
	EvaluateDataset(context.Context, *EvaluateDatasetRequest) (*longrunningpb.Operation, error)
}

// UnimplementedEvaluationServiceServer should be embedded to have forward compatible implementations.
type UnimplementedEvaluationServiceServer struct {
}

func (UnimplementedEvaluationServiceServer) EvaluateInstances(context.Context, *EvaluateInstancesRequest) (*EvaluateInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EvaluateInstances not implemented")
}
func (UnimplementedEvaluationServiceServer) EvaluateDataset(context.Context, *EvaluateDatasetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EvaluateDataset not implemented")
}

// UnsafeEvaluationServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to EvaluationServiceServer will
// result in compilation errors.
type UnsafeEvaluationServiceServer interface {
	mustEmbedUnimplementedEvaluationServiceServer()
}

func RegisterEvaluationServiceServer(s grpc.ServiceRegistrar, srv EvaluationServiceServer) {
	s.RegisterService(&EvaluationService_ServiceDesc, srv)
}

func _EvaluationService_EvaluateInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EvaluateInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EvaluationServiceServer).EvaluateInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EvaluationService_EvaluateInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EvaluationServiceServer).EvaluateInstances(ctx, req.(*EvaluateInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EvaluationService_EvaluateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EvaluateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EvaluationServiceServer).EvaluateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EvaluationService_EvaluateDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EvaluationServiceServer).EvaluateDataset(ctx, req.(*EvaluateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// EvaluationService_ServiceDesc is the grpc.ServiceDesc for EvaluationService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var EvaluationService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.EvaluationService",
	HandlerType: (*EvaluationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "EvaluateInstances",
			Handler:    _EvaluationService_EvaluateInstances_Handler,
		},
		{
			MethodName: "EvaluateDataset",
			Handler:    _EvaluationService_EvaluateDataset_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/evaluation_service.proto",
}
