// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/datacatalog/v1beta1/policytagmanagerserialization.proto

package datacatalogpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	PolicyTagManagerSerialization_ImportTaxonomies_FullMethodName = "/google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization/ImportTaxonomies"
	PolicyTagManagerSerialization_ExportTaxonomies_FullMethodName = "/google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization/ExportTaxonomies"
)

// PolicyTagManagerSerializationClient is the client API for PolicyTagManagerSerialization service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PolicyTagManagerSerializationClient interface {
	// Imports all taxonomies and their policy tags to a project as new
	// taxonomies.
	//
	// This method provides a bulk taxonomy / policy tag creation using nested
	// proto structure.
	ImportTaxonomies(ctx context.Context, in *ImportTaxonomiesRequest, opts ...grpc.CallOption) (*ImportTaxonomiesResponse, error)
	// Exports all taxonomies and their policy tags in a project.
	//
	// This method generates SerializedTaxonomy protos with nested policy tags
	// that can be used as an input for future ImportTaxonomies calls.
	ExportTaxonomies(ctx context.Context, in *ExportTaxonomiesRequest, opts ...grpc.CallOption) (*ExportTaxonomiesResponse, error)
}

type policyTagManagerSerializationClient struct {
	cc grpc.ClientConnInterface
}

func NewPolicyTagManagerSerializationClient(cc grpc.ClientConnInterface) PolicyTagManagerSerializationClient {
	return &policyTagManagerSerializationClient{cc}
}

func (c *policyTagManagerSerializationClient) ImportTaxonomies(ctx context.Context, in *ImportTaxonomiesRequest, opts ...grpc.CallOption) (*ImportTaxonomiesResponse, error) {
	out := new(ImportTaxonomiesResponse)
	err := c.cc.Invoke(ctx, PolicyTagManagerSerialization_ImportTaxonomies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerSerializationClient) ExportTaxonomies(ctx context.Context, in *ExportTaxonomiesRequest, opts ...grpc.CallOption) (*ExportTaxonomiesResponse, error) {
	out := new(ExportTaxonomiesResponse)
	err := c.cc.Invoke(ctx, PolicyTagManagerSerialization_ExportTaxonomies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PolicyTagManagerSerializationServer is the server API for PolicyTagManagerSerialization service.
// All implementations should embed UnimplementedPolicyTagManagerSerializationServer
// for forward compatibility
type PolicyTagManagerSerializationServer interface {
	// Imports all taxonomies and their policy tags to a project as new
	// taxonomies.
	//
	// This method provides a bulk taxonomy / policy tag creation using nested
	// proto structure.
	ImportTaxonomies(context.Context, *ImportTaxonomiesRequest) (*ImportTaxonomiesResponse, error)
	// Exports all taxonomies and their policy tags in a project.
	//
	// This method generates SerializedTaxonomy protos with nested policy tags
	// that can be used as an input for future ImportTaxonomies calls.
	ExportTaxonomies(context.Context, *ExportTaxonomiesRequest) (*ExportTaxonomiesResponse, error)
}

// UnimplementedPolicyTagManagerSerializationServer should be embedded to have forward compatible implementations.
type UnimplementedPolicyTagManagerSerializationServer struct {
}

func (UnimplementedPolicyTagManagerSerializationServer) ImportTaxonomies(context.Context, *ImportTaxonomiesRequest) (*ImportTaxonomiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportTaxonomies not implemented")
}
func (UnimplementedPolicyTagManagerSerializationServer) ExportTaxonomies(context.Context, *ExportTaxonomiesRequest) (*ExportTaxonomiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportTaxonomies not implemented")
}

// UnsafePolicyTagManagerSerializationServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PolicyTagManagerSerializationServer will
// result in compilation errors.
type UnsafePolicyTagManagerSerializationServer interface {
	mustEmbedUnimplementedPolicyTagManagerSerializationServer()
}

func RegisterPolicyTagManagerSerializationServer(s grpc.ServiceRegistrar, srv PolicyTagManagerSerializationServer) {
	s.RegisterService(&PolicyTagManagerSerialization_ServiceDesc, srv)
}

func _PolicyTagManagerSerialization_ImportTaxonomies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportTaxonomiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerSerializationServer).ImportTaxonomies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyTagManagerSerialization_ImportTaxonomies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerSerializationServer).ImportTaxonomies(ctx, req.(*ImportTaxonomiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManagerSerialization_ExportTaxonomies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportTaxonomiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerSerializationServer).ExportTaxonomies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyTagManagerSerialization_ExportTaxonomies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerSerializationServer).ExportTaxonomies(ctx, req.(*ExportTaxonomiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PolicyTagManagerSerialization_ServiceDesc is the grpc.ServiceDesc for PolicyTagManagerSerialization service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PolicyTagManagerSerialization_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datacatalog.v1beta1.PolicyTagManagerSerialization",
	HandlerType: (*PolicyTagManagerSerializationServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ImportTaxonomies",
			Handler:    _PolicyTagManagerSerialization_ImportTaxonomies_Handler,
		},
		{
			MethodName: "ExportTaxonomies",
			Handler:    _PolicyTagManagerSerialization_ExportTaxonomies_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datacatalog/v1beta1/policytagmanagerserialization.proto",
}
