// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package iam

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	iampb "cloud.google.com/go/iam/apiv3/iampb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newPrincipalAccessBoundaryPoliciesClientHook clientHook

// PrincipalAccessBoundaryPoliciesCallOptions contains the retry settings for each method of PrincipalAccessBoundaryPoliciesClient.
type PrincipalAccessBoundaryPoliciesCallOptions struct {
	CreatePrincipalAccessBoundaryPolicy         []gax.CallOption
	GetPrincipalAccessBoundaryPolicy            []gax.CallOption
	UpdatePrincipalAccessBoundaryPolicy         []gax.CallOption
	DeletePrincipalAccessBoundaryPolicy         []gax.CallOption
	ListPrincipalAccessBoundaryPolicies         []gax.CallOption
	SearchPrincipalAccessBoundaryPolicyBindings []gax.CallOption
	GetOperation                                []gax.CallOption
}

func defaultPrincipalAccessBoundaryPoliciesGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("iam.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("iam.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("iam.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://iam.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultPrincipalAccessBoundaryPoliciesCallOptions() *PrincipalAccessBoundaryPoliciesCallOptions {
	return &PrincipalAccessBoundaryPoliciesCallOptions{
		CreatePrincipalAccessBoundaryPolicy: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
		},
		GetPrincipalAccessBoundaryPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdatePrincipalAccessBoundaryPolicy: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
		},
		DeletePrincipalAccessBoundaryPolicy: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
		},
		ListPrincipalAccessBoundaryPolicies: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		SearchPrincipalAccessBoundaryPolicyBindings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetOperation: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

func defaultPrincipalAccessBoundaryPoliciesRESTCallOptions() *PrincipalAccessBoundaryPoliciesCallOptions {
	return &PrincipalAccessBoundaryPoliciesCallOptions{
		CreatePrincipalAccessBoundaryPolicy: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
		},
		GetPrincipalAccessBoundaryPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdatePrincipalAccessBoundaryPolicy: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
		},
		DeletePrincipalAccessBoundaryPolicy: []gax.CallOption{
			gax.WithTimeout(30000 * time.Millisecond),
		},
		ListPrincipalAccessBoundaryPolicies: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		SearchPrincipalAccessBoundaryPolicyBindings: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetOperation: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
	}
}

// internalPrincipalAccessBoundaryPoliciesClient is an interface that defines the methods available from Identity and Access Management (IAM) API.
type internalPrincipalAccessBoundaryPoliciesClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreatePrincipalAccessBoundaryPolicy(context.Context, *iampb.CreatePrincipalAccessBoundaryPolicyRequest, ...gax.CallOption) (*CreatePrincipalAccessBoundaryPolicyOperation, error)
	CreatePrincipalAccessBoundaryPolicyOperation(name string) *CreatePrincipalAccessBoundaryPolicyOperation
	GetPrincipalAccessBoundaryPolicy(context.Context, *iampb.GetPrincipalAccessBoundaryPolicyRequest, ...gax.CallOption) (*iampb.PrincipalAccessBoundaryPolicy, error)
	UpdatePrincipalAccessBoundaryPolicy(context.Context, *iampb.UpdatePrincipalAccessBoundaryPolicyRequest, ...gax.CallOption) (*UpdatePrincipalAccessBoundaryPolicyOperation, error)
	UpdatePrincipalAccessBoundaryPolicyOperation(name string) *UpdatePrincipalAccessBoundaryPolicyOperation
	DeletePrincipalAccessBoundaryPolicy(context.Context, *iampb.DeletePrincipalAccessBoundaryPolicyRequest, ...gax.CallOption) (*DeletePrincipalAccessBoundaryPolicyOperation, error)
	DeletePrincipalAccessBoundaryPolicyOperation(name string) *DeletePrincipalAccessBoundaryPolicyOperation
	ListPrincipalAccessBoundaryPolicies(context.Context, *iampb.ListPrincipalAccessBoundaryPoliciesRequest, ...gax.CallOption) *PrincipalAccessBoundaryPolicyIterator
	SearchPrincipalAccessBoundaryPolicyBindings(context.Context, *iampb.SearchPrincipalAccessBoundaryPolicyBindingsRequest, ...gax.CallOption) *PolicyBindingIterator
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
}

// PrincipalAccessBoundaryPoliciesClient is a client for interacting with Identity and Access Management (IAM) API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Manages Identity and Access Management (IAM) principal access boundary
// policies.
type PrincipalAccessBoundaryPoliciesClient struct {
	// The internal transport-dependent client.
	internalClient internalPrincipalAccessBoundaryPoliciesClient

	// The call options for this service.
	CallOptions *PrincipalAccessBoundaryPoliciesCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *PrincipalAccessBoundaryPoliciesClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *PrincipalAccessBoundaryPoliciesClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *PrincipalAccessBoundaryPoliciesClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreatePrincipalAccessBoundaryPolicy creates a principal access boundary policy, and returns a long running
// operation.
func (c *PrincipalAccessBoundaryPoliciesClient) CreatePrincipalAccessBoundaryPolicy(ctx context.Context, req *iampb.CreatePrincipalAccessBoundaryPolicyRequest, opts ...gax.CallOption) (*CreatePrincipalAccessBoundaryPolicyOperation, error) {
	return c.internalClient.CreatePrincipalAccessBoundaryPolicy(ctx, req, opts...)
}

// CreatePrincipalAccessBoundaryPolicyOperation returns a new CreatePrincipalAccessBoundaryPolicyOperation from a given name.
// The name must be that of a previously created CreatePrincipalAccessBoundaryPolicyOperation, possibly from a different process.
func (c *PrincipalAccessBoundaryPoliciesClient) CreatePrincipalAccessBoundaryPolicyOperation(name string) *CreatePrincipalAccessBoundaryPolicyOperation {
	return c.internalClient.CreatePrincipalAccessBoundaryPolicyOperation(name)
}

// GetPrincipalAccessBoundaryPolicy gets a principal access boundary policy.
func (c *PrincipalAccessBoundaryPoliciesClient) GetPrincipalAccessBoundaryPolicy(ctx context.Context, req *iampb.GetPrincipalAccessBoundaryPolicyRequest, opts ...gax.CallOption) (*iampb.PrincipalAccessBoundaryPolicy, error) {
	return c.internalClient.GetPrincipalAccessBoundaryPolicy(ctx, req, opts...)
}

// UpdatePrincipalAccessBoundaryPolicy updates a principal access boundary policy.
func (c *PrincipalAccessBoundaryPoliciesClient) UpdatePrincipalAccessBoundaryPolicy(ctx context.Context, req *iampb.UpdatePrincipalAccessBoundaryPolicyRequest, opts ...gax.CallOption) (*UpdatePrincipalAccessBoundaryPolicyOperation, error) {
	return c.internalClient.UpdatePrincipalAccessBoundaryPolicy(ctx, req, opts...)
}

// UpdatePrincipalAccessBoundaryPolicyOperation returns a new UpdatePrincipalAccessBoundaryPolicyOperation from a given name.
// The name must be that of a previously created UpdatePrincipalAccessBoundaryPolicyOperation, possibly from a different process.
func (c *PrincipalAccessBoundaryPoliciesClient) UpdatePrincipalAccessBoundaryPolicyOperation(name string) *UpdatePrincipalAccessBoundaryPolicyOperation {
	return c.internalClient.UpdatePrincipalAccessBoundaryPolicyOperation(name)
}

// DeletePrincipalAccessBoundaryPolicy deletes a principal access boundary policy.
func (c *PrincipalAccessBoundaryPoliciesClient) DeletePrincipalAccessBoundaryPolicy(ctx context.Context, req *iampb.DeletePrincipalAccessBoundaryPolicyRequest, opts ...gax.CallOption) (*DeletePrincipalAccessBoundaryPolicyOperation, error) {
	return c.internalClient.DeletePrincipalAccessBoundaryPolicy(ctx, req, opts...)
}

// DeletePrincipalAccessBoundaryPolicyOperation returns a new DeletePrincipalAccessBoundaryPolicyOperation from a given name.
// The name must be that of a previously created DeletePrincipalAccessBoundaryPolicyOperation, possibly from a different process.
func (c *PrincipalAccessBoundaryPoliciesClient) DeletePrincipalAccessBoundaryPolicyOperation(name string) *DeletePrincipalAccessBoundaryPolicyOperation {
	return c.internalClient.DeletePrincipalAccessBoundaryPolicyOperation(name)
}

// ListPrincipalAccessBoundaryPolicies lists principal access boundary policies.
func (c *PrincipalAccessBoundaryPoliciesClient) ListPrincipalAccessBoundaryPolicies(ctx context.Context, req *iampb.ListPrincipalAccessBoundaryPoliciesRequest, opts ...gax.CallOption) *PrincipalAccessBoundaryPolicyIterator {
	return c.internalClient.ListPrincipalAccessBoundaryPolicies(ctx, req, opts...)
}

// SearchPrincipalAccessBoundaryPolicyBindings returns all policy bindings that bind a specific policy if a user has
// searchPolicyBindings permission on that policy.
func (c *PrincipalAccessBoundaryPoliciesClient) SearchPrincipalAccessBoundaryPolicyBindings(ctx context.Context, req *iampb.SearchPrincipalAccessBoundaryPolicyBindingsRequest, opts ...gax.CallOption) *PolicyBindingIterator {
	return c.internalClient.SearchPrincipalAccessBoundaryPolicyBindings(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *PrincipalAccessBoundaryPoliciesClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// principalAccessBoundaryPoliciesGRPCClient is a client for interacting with Identity and Access Management (IAM) API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type principalAccessBoundaryPoliciesGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing PrincipalAccessBoundaryPoliciesClient
	CallOptions **PrincipalAccessBoundaryPoliciesCallOptions

	// The gRPC API client.
	principalAccessBoundaryPoliciesClient iampb.PrincipalAccessBoundaryPoliciesClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewPrincipalAccessBoundaryPoliciesClient creates a new principal access boundary policies client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Manages Identity and Access Management (IAM) principal access boundary
// policies.
func NewPrincipalAccessBoundaryPoliciesClient(ctx context.Context, opts ...option.ClientOption) (*PrincipalAccessBoundaryPoliciesClient, error) {
	clientOpts := defaultPrincipalAccessBoundaryPoliciesGRPCClientOptions()
	if newPrincipalAccessBoundaryPoliciesClientHook != nil {
		hookOpts, err := newPrincipalAccessBoundaryPoliciesClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := PrincipalAccessBoundaryPoliciesClient{CallOptions: defaultPrincipalAccessBoundaryPoliciesCallOptions()}

	c := &principalAccessBoundaryPoliciesGRPCClient{
		connPool:                              connPool,
		principalAccessBoundaryPoliciesClient: iampb.NewPrincipalAccessBoundaryPoliciesClient(connPool),
		CallOptions:                           &client.CallOptions,
		logger:                                internaloption.GetLogger(opts),
		operationsClient:                      longrunningpb.NewOperationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *principalAccessBoundaryPoliciesGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *principalAccessBoundaryPoliciesGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version, "pb", protoVersion)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *principalAccessBoundaryPoliciesGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type principalAccessBoundaryPoliciesRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing PrincipalAccessBoundaryPoliciesClient
	CallOptions **PrincipalAccessBoundaryPoliciesCallOptions

	logger *slog.Logger
}

// NewPrincipalAccessBoundaryPoliciesRESTClient creates a new principal access boundary policies rest client.
//
// Manages Identity and Access Management (IAM) principal access boundary
// policies.
func NewPrincipalAccessBoundaryPoliciesRESTClient(ctx context.Context, opts ...option.ClientOption) (*PrincipalAccessBoundaryPoliciesClient, error) {
	clientOpts := append(defaultPrincipalAccessBoundaryPoliciesRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultPrincipalAccessBoundaryPoliciesRESTCallOptions()
	c := &principalAccessBoundaryPoliciesRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &PrincipalAccessBoundaryPoliciesClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultPrincipalAccessBoundaryPoliciesRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://iam.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://iam.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://iam.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://iam.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *principalAccessBoundaryPoliciesRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN", "pb", protoVersion)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *principalAccessBoundaryPoliciesRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *principalAccessBoundaryPoliciesRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *principalAccessBoundaryPoliciesGRPCClient) CreatePrincipalAccessBoundaryPolicy(ctx context.Context, req *iampb.CreatePrincipalAccessBoundaryPolicyRequest, opts ...gax.CallOption) (*CreatePrincipalAccessBoundaryPolicyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreatePrincipalAccessBoundaryPolicy[0:len((*c.CallOptions).CreatePrincipalAccessBoundaryPolicy):len((*c.CallOptions).CreatePrincipalAccessBoundaryPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.principalAccessBoundaryPoliciesClient.CreatePrincipalAccessBoundaryPolicy, req, settings.GRPC, c.logger, "CreatePrincipalAccessBoundaryPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreatePrincipalAccessBoundaryPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *principalAccessBoundaryPoliciesGRPCClient) GetPrincipalAccessBoundaryPolicy(ctx context.Context, req *iampb.GetPrincipalAccessBoundaryPolicyRequest, opts ...gax.CallOption) (*iampb.PrincipalAccessBoundaryPolicy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetPrincipalAccessBoundaryPolicy[0:len((*c.CallOptions).GetPrincipalAccessBoundaryPolicy):len((*c.CallOptions).GetPrincipalAccessBoundaryPolicy)], opts...)
	var resp *iampb.PrincipalAccessBoundaryPolicy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.principalAccessBoundaryPoliciesClient.GetPrincipalAccessBoundaryPolicy, req, settings.GRPC, c.logger, "GetPrincipalAccessBoundaryPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *principalAccessBoundaryPoliciesGRPCClient) UpdatePrincipalAccessBoundaryPolicy(ctx context.Context, req *iampb.UpdatePrincipalAccessBoundaryPolicyRequest, opts ...gax.CallOption) (*UpdatePrincipalAccessBoundaryPolicyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "principal_access_boundary_policy.name", url.QueryEscape(req.GetPrincipalAccessBoundaryPolicy().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdatePrincipalAccessBoundaryPolicy[0:len((*c.CallOptions).UpdatePrincipalAccessBoundaryPolicy):len((*c.CallOptions).UpdatePrincipalAccessBoundaryPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.principalAccessBoundaryPoliciesClient.UpdatePrincipalAccessBoundaryPolicy, req, settings.GRPC, c.logger, "UpdatePrincipalAccessBoundaryPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdatePrincipalAccessBoundaryPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *principalAccessBoundaryPoliciesGRPCClient) DeletePrincipalAccessBoundaryPolicy(ctx context.Context, req *iampb.DeletePrincipalAccessBoundaryPolicyRequest, opts ...gax.CallOption) (*DeletePrincipalAccessBoundaryPolicyOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeletePrincipalAccessBoundaryPolicy[0:len((*c.CallOptions).DeletePrincipalAccessBoundaryPolicy):len((*c.CallOptions).DeletePrincipalAccessBoundaryPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.principalAccessBoundaryPoliciesClient.DeletePrincipalAccessBoundaryPolicy, req, settings.GRPC, c.logger, "DeletePrincipalAccessBoundaryPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeletePrincipalAccessBoundaryPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *principalAccessBoundaryPoliciesGRPCClient) ListPrincipalAccessBoundaryPolicies(ctx context.Context, req *iampb.ListPrincipalAccessBoundaryPoliciesRequest, opts ...gax.CallOption) *PrincipalAccessBoundaryPolicyIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListPrincipalAccessBoundaryPolicies[0:len((*c.CallOptions).ListPrincipalAccessBoundaryPolicies):len((*c.CallOptions).ListPrincipalAccessBoundaryPolicies)], opts...)
	it := &PrincipalAccessBoundaryPolicyIterator{}
	req = proto.Clone(req).(*iampb.ListPrincipalAccessBoundaryPoliciesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*iampb.PrincipalAccessBoundaryPolicy, string, error) {
		resp := &iampb.ListPrincipalAccessBoundaryPoliciesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.principalAccessBoundaryPoliciesClient.ListPrincipalAccessBoundaryPolicies, req, settings.GRPC, c.logger, "ListPrincipalAccessBoundaryPolicies")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetPrincipalAccessBoundaryPolicies(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *principalAccessBoundaryPoliciesGRPCClient) SearchPrincipalAccessBoundaryPolicyBindings(ctx context.Context, req *iampb.SearchPrincipalAccessBoundaryPolicyBindingsRequest, opts ...gax.CallOption) *PolicyBindingIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SearchPrincipalAccessBoundaryPolicyBindings[0:len((*c.CallOptions).SearchPrincipalAccessBoundaryPolicyBindings):len((*c.CallOptions).SearchPrincipalAccessBoundaryPolicyBindings)], opts...)
	it := &PolicyBindingIterator{}
	req = proto.Clone(req).(*iampb.SearchPrincipalAccessBoundaryPolicyBindingsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*iampb.PolicyBinding, string, error) {
		resp := &iampb.SearchPrincipalAccessBoundaryPolicyBindingsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.principalAccessBoundaryPoliciesClient.SearchPrincipalAccessBoundaryPolicyBindings, req, settings.GRPC, c.logger, "SearchPrincipalAccessBoundaryPolicyBindings")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetPolicyBindings(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *principalAccessBoundaryPoliciesGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CreatePrincipalAccessBoundaryPolicy creates a principal access boundary policy, and returns a long running
// operation.
func (c *principalAccessBoundaryPoliciesRESTClient) CreatePrincipalAccessBoundaryPolicy(ctx context.Context, req *iampb.CreatePrincipalAccessBoundaryPolicyRequest, opts ...gax.CallOption) (*CreatePrincipalAccessBoundaryPolicyOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetPrincipalAccessBoundaryPolicy()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v3/%v/principalAccessBoundaryPolicies", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("principalAccessBoundaryPolicyId", fmt.Sprintf("%v", req.GetPrincipalAccessBoundaryPolicyId()))
	if req.GetValidateOnly() {
		params.Add("validateOnly", fmt.Sprintf("%v", req.GetValidateOnly()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreatePrincipalAccessBoundaryPolicy")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v3/%s", resp.GetName())
	return &CreatePrincipalAccessBoundaryPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetPrincipalAccessBoundaryPolicy gets a principal access boundary policy.
func (c *principalAccessBoundaryPoliciesRESTClient) GetPrincipalAccessBoundaryPolicy(ctx context.Context, req *iampb.GetPrincipalAccessBoundaryPolicyRequest, opts ...gax.CallOption) (*iampb.PrincipalAccessBoundaryPolicy, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v3/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetPrincipalAccessBoundaryPolicy[0:len((*c.CallOptions).GetPrincipalAccessBoundaryPolicy):len((*c.CallOptions).GetPrincipalAccessBoundaryPolicy)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &iampb.PrincipalAccessBoundaryPolicy{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetPrincipalAccessBoundaryPolicy")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdatePrincipalAccessBoundaryPolicy updates a principal access boundary policy.
func (c *principalAccessBoundaryPoliciesRESTClient) UpdatePrincipalAccessBoundaryPolicy(ctx context.Context, req *iampb.UpdatePrincipalAccessBoundaryPolicyRequest, opts ...gax.CallOption) (*UpdatePrincipalAccessBoundaryPolicyOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetPrincipalAccessBoundaryPolicy()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v3/%v", req.GetPrincipalAccessBoundaryPolicy().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}
	if req.GetValidateOnly() {
		params.Add("validateOnly", fmt.Sprintf("%v", req.GetValidateOnly()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "principal_access_boundary_policy.name", url.QueryEscape(req.GetPrincipalAccessBoundaryPolicy().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdatePrincipalAccessBoundaryPolicy")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v3/%s", resp.GetName())
	return &UpdatePrincipalAccessBoundaryPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeletePrincipalAccessBoundaryPolicy deletes a principal access boundary policy.
func (c *principalAccessBoundaryPoliciesRESTClient) DeletePrincipalAccessBoundaryPolicy(ctx context.Context, req *iampb.DeletePrincipalAccessBoundaryPolicyRequest, opts ...gax.CallOption) (*DeletePrincipalAccessBoundaryPolicyOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v3/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetEtag() != "" {
		params.Add("etag", fmt.Sprintf("%v", req.GetEtag()))
	}
	if req.GetForce() {
		params.Add("force", fmt.Sprintf("%v", req.GetForce()))
	}
	if req.GetValidateOnly() {
		params.Add("validateOnly", fmt.Sprintf("%v", req.GetValidateOnly()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeletePrincipalAccessBoundaryPolicy")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v3/%s", resp.GetName())
	return &DeletePrincipalAccessBoundaryPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListPrincipalAccessBoundaryPolicies lists principal access boundary policies.
func (c *principalAccessBoundaryPoliciesRESTClient) ListPrincipalAccessBoundaryPolicies(ctx context.Context, req *iampb.ListPrincipalAccessBoundaryPoliciesRequest, opts ...gax.CallOption) *PrincipalAccessBoundaryPolicyIterator {
	it := &PrincipalAccessBoundaryPolicyIterator{}
	req = proto.Clone(req).(*iampb.ListPrincipalAccessBoundaryPoliciesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*iampb.PrincipalAccessBoundaryPolicy, string, error) {
		resp := &iampb.ListPrincipalAccessBoundaryPoliciesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v3/%v/principalAccessBoundaryPolicies", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListPrincipalAccessBoundaryPolicies")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetPrincipalAccessBoundaryPolicies(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// SearchPrincipalAccessBoundaryPolicyBindings returns all policy bindings that bind a specific policy if a user has
// searchPolicyBindings permission on that policy.
func (c *principalAccessBoundaryPoliciesRESTClient) SearchPrincipalAccessBoundaryPolicyBindings(ctx context.Context, req *iampb.SearchPrincipalAccessBoundaryPolicyBindingsRequest, opts ...gax.CallOption) *PolicyBindingIterator {
	it := &PolicyBindingIterator{}
	req = proto.Clone(req).(*iampb.SearchPrincipalAccessBoundaryPolicyBindingsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*iampb.PolicyBinding, string, error) {
		resp := &iampb.SearchPrincipalAccessBoundaryPolicyBindingsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v3/%v:searchPolicyBindings", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "SearchPrincipalAccessBoundaryPolicyBindings")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetPolicyBindings(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *principalAccessBoundaryPoliciesRESTClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v3/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreatePrincipalAccessBoundaryPolicyOperation returns a new CreatePrincipalAccessBoundaryPolicyOperation from a given name.
// The name must be that of a previously created CreatePrincipalAccessBoundaryPolicyOperation, possibly from a different process.
func (c *principalAccessBoundaryPoliciesGRPCClient) CreatePrincipalAccessBoundaryPolicyOperation(name string) *CreatePrincipalAccessBoundaryPolicyOperation {
	return &CreatePrincipalAccessBoundaryPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreatePrincipalAccessBoundaryPolicyOperation returns a new CreatePrincipalAccessBoundaryPolicyOperation from a given name.
// The name must be that of a previously created CreatePrincipalAccessBoundaryPolicyOperation, possibly from a different process.
func (c *principalAccessBoundaryPoliciesRESTClient) CreatePrincipalAccessBoundaryPolicyOperation(name string) *CreatePrincipalAccessBoundaryPolicyOperation {
	override := fmt.Sprintf("/v3/%s", name)
	return &CreatePrincipalAccessBoundaryPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeletePrincipalAccessBoundaryPolicyOperation returns a new DeletePrincipalAccessBoundaryPolicyOperation from a given name.
// The name must be that of a previously created DeletePrincipalAccessBoundaryPolicyOperation, possibly from a different process.
func (c *principalAccessBoundaryPoliciesGRPCClient) DeletePrincipalAccessBoundaryPolicyOperation(name string) *DeletePrincipalAccessBoundaryPolicyOperation {
	return &DeletePrincipalAccessBoundaryPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeletePrincipalAccessBoundaryPolicyOperation returns a new DeletePrincipalAccessBoundaryPolicyOperation from a given name.
// The name must be that of a previously created DeletePrincipalAccessBoundaryPolicyOperation, possibly from a different process.
func (c *principalAccessBoundaryPoliciesRESTClient) DeletePrincipalAccessBoundaryPolicyOperation(name string) *DeletePrincipalAccessBoundaryPolicyOperation {
	override := fmt.Sprintf("/v3/%s", name)
	return &DeletePrincipalAccessBoundaryPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdatePrincipalAccessBoundaryPolicyOperation returns a new UpdatePrincipalAccessBoundaryPolicyOperation from a given name.
// The name must be that of a previously created UpdatePrincipalAccessBoundaryPolicyOperation, possibly from a different process.
func (c *principalAccessBoundaryPoliciesGRPCClient) UpdatePrincipalAccessBoundaryPolicyOperation(name string) *UpdatePrincipalAccessBoundaryPolicyOperation {
	return &UpdatePrincipalAccessBoundaryPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdatePrincipalAccessBoundaryPolicyOperation returns a new UpdatePrincipalAccessBoundaryPolicyOperation from a given name.
// The name must be that of a previously created UpdatePrincipalAccessBoundaryPolicyOperation, possibly from a different process.
func (c *principalAccessBoundaryPoliciesRESTClient) UpdatePrincipalAccessBoundaryPolicyOperation(name string) *UpdatePrincipalAccessBoundaryPolicyOperation {
	override := fmt.Sprintf("/v3/%s", name)
	return &UpdatePrincipalAccessBoundaryPolicyOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
