// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/maps/fleetengine/delivery/v1/delivery_api.proto

package deliverypb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DeliveryService_CreateDeliveryVehicle_FullMethodName = "/maps.fleetengine.delivery.v1.DeliveryService/CreateDeliveryVehicle"
	DeliveryService_GetDeliveryVehicle_FullMethodName    = "/maps.fleetengine.delivery.v1.DeliveryService/GetDeliveryVehicle"
	DeliveryService_DeleteDeliveryVehicle_FullMethodName = "/maps.fleetengine.delivery.v1.DeliveryService/DeleteDeliveryVehicle"
	DeliveryService_UpdateDeliveryVehicle_FullMethodName = "/maps.fleetengine.delivery.v1.DeliveryService/UpdateDeliveryVehicle"
	DeliveryService_BatchCreateTasks_FullMethodName      = "/maps.fleetengine.delivery.v1.DeliveryService/BatchCreateTasks"
	DeliveryService_CreateTask_FullMethodName            = "/maps.fleetengine.delivery.v1.DeliveryService/CreateTask"
	DeliveryService_GetTask_FullMethodName               = "/maps.fleetengine.delivery.v1.DeliveryService/GetTask"
	DeliveryService_DeleteTask_FullMethodName            = "/maps.fleetengine.delivery.v1.DeliveryService/DeleteTask"
	DeliveryService_UpdateTask_FullMethodName            = "/maps.fleetengine.delivery.v1.DeliveryService/UpdateTask"
	DeliveryService_ListTasks_FullMethodName             = "/maps.fleetengine.delivery.v1.DeliveryService/ListTasks"
	DeliveryService_GetTaskTrackingInfo_FullMethodName   = "/maps.fleetengine.delivery.v1.DeliveryService/GetTaskTrackingInfo"
	DeliveryService_ListDeliveryVehicles_FullMethodName  = "/maps.fleetengine.delivery.v1.DeliveryService/ListDeliveryVehicles"
)

// DeliveryServiceClient is the client API for DeliveryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DeliveryServiceClient interface {
	// Creates and returns a new `DeliveryVehicle`.
	CreateDeliveryVehicle(ctx context.Context, in *CreateDeliveryVehicleRequest, opts ...grpc.CallOption) (*DeliveryVehicle, error)
	// Returns the specified `DeliveryVehicle` instance.
	GetDeliveryVehicle(ctx context.Context, in *GetDeliveryVehicleRequest, opts ...grpc.CallOption) (*DeliveryVehicle, error)
	// Deletes a DeliveryVehicle from the Fleet Engine.
	//
	// Returns FAILED_PRECONDITION if the DeliveryVehicle has OPEN Tasks
	// assigned to it.
	DeleteDeliveryVehicle(ctx context.Context, in *DeleteDeliveryVehicleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Writes updated `DeliveryVehicle` data to Fleet Engine, and assigns
	// `Tasks` to the `DeliveryVehicle`. You cannot update the name of the
	// `DeliveryVehicle`. You *can* update `remaining_vehicle_journey_segments`,
	// but it must contain all of the `VehicleJourneySegment`s to be persisted on
	// the `DeliveryVehicle`. The `task_id`s are retrieved from
	// `remaining_vehicle_journey_segments`, and their corresponding `Tasks` are
	// assigned to the `DeliveryVehicle` if they have not yet been assigned.
	UpdateDeliveryVehicle(ctx context.Context, in *UpdateDeliveryVehicleRequest, opts ...grpc.CallOption) (*DeliveryVehicle, error)
	// Creates and returns a batch of new `Task` objects.
	BatchCreateTasks(ctx context.Context, in *BatchCreateTasksRequest, opts ...grpc.CallOption) (*BatchCreateTasksResponse, error)
	// Creates and returns a new `Task` object.
	CreateTask(ctx context.Context, in *CreateTaskRequest, opts ...grpc.CallOption) (*Task, error)
	// Gets information about a `Task`.
	GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*Task, error)
	// Deletes a single Task.
	//
	// Returns FAILED_PRECONDITION if the Task is OPEN and assigned to a
	// DeliveryVehicle.
	DeleteTask(ctx context.Context, in *DeleteTaskRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates `Task` data.
	UpdateTask(ctx context.Context, in *UpdateTaskRequest, opts ...grpc.CallOption) (*Task, error)
	// Gets all `Task`s that meet the specified filtering criteria.
	ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error)
	// Returns the specified `TaskTrackingInfo` instance.
	GetTaskTrackingInfo(ctx context.Context, in *GetTaskTrackingInfoRequest, opts ...grpc.CallOption) (*TaskTrackingInfo, error)
	// Gets all `DeliveryVehicle`s that meet the specified filtering criteria.
	ListDeliveryVehicles(ctx context.Context, in *ListDeliveryVehiclesRequest, opts ...grpc.CallOption) (*ListDeliveryVehiclesResponse, error)
}

type deliveryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDeliveryServiceClient(cc grpc.ClientConnInterface) DeliveryServiceClient {
	return &deliveryServiceClient{cc}
}

func (c *deliveryServiceClient) CreateDeliveryVehicle(ctx context.Context, in *CreateDeliveryVehicleRequest, opts ...grpc.CallOption) (*DeliveryVehicle, error) {
	out := new(DeliveryVehicle)
	err := c.cc.Invoke(ctx, DeliveryService_CreateDeliveryVehicle_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) GetDeliveryVehicle(ctx context.Context, in *GetDeliveryVehicleRequest, opts ...grpc.CallOption) (*DeliveryVehicle, error) {
	out := new(DeliveryVehicle)
	err := c.cc.Invoke(ctx, DeliveryService_GetDeliveryVehicle_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) DeleteDeliveryVehicle(ctx context.Context, in *DeleteDeliveryVehicleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DeliveryService_DeleteDeliveryVehicle_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) UpdateDeliveryVehicle(ctx context.Context, in *UpdateDeliveryVehicleRequest, opts ...grpc.CallOption) (*DeliveryVehicle, error) {
	out := new(DeliveryVehicle)
	err := c.cc.Invoke(ctx, DeliveryService_UpdateDeliveryVehicle_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) BatchCreateTasks(ctx context.Context, in *BatchCreateTasksRequest, opts ...grpc.CallOption) (*BatchCreateTasksResponse, error) {
	out := new(BatchCreateTasksResponse)
	err := c.cc.Invoke(ctx, DeliveryService_BatchCreateTasks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) CreateTask(ctx context.Context, in *CreateTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, DeliveryService_CreateTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, DeliveryService_GetTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) DeleteTask(ctx context.Context, in *DeleteTaskRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DeliveryService_DeleteTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) UpdateTask(ctx context.Context, in *UpdateTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, DeliveryService_UpdateTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error) {
	out := new(ListTasksResponse)
	err := c.cc.Invoke(ctx, DeliveryService_ListTasks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) GetTaskTrackingInfo(ctx context.Context, in *GetTaskTrackingInfoRequest, opts ...grpc.CallOption) (*TaskTrackingInfo, error) {
	out := new(TaskTrackingInfo)
	err := c.cc.Invoke(ctx, DeliveryService_GetTaskTrackingInfo_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deliveryServiceClient) ListDeliveryVehicles(ctx context.Context, in *ListDeliveryVehiclesRequest, opts ...grpc.CallOption) (*ListDeliveryVehiclesResponse, error) {
	out := new(ListDeliveryVehiclesResponse)
	err := c.cc.Invoke(ctx, DeliveryService_ListDeliveryVehicles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DeliveryServiceServer is the server API for DeliveryService service.
// All implementations should embed UnimplementedDeliveryServiceServer
// for forward compatibility
type DeliveryServiceServer interface {
	// Creates and returns a new `DeliveryVehicle`.
	CreateDeliveryVehicle(context.Context, *CreateDeliveryVehicleRequest) (*DeliveryVehicle, error)
	// Returns the specified `DeliveryVehicle` instance.
	GetDeliveryVehicle(context.Context, *GetDeliveryVehicleRequest) (*DeliveryVehicle, error)
	// Deletes a DeliveryVehicle from the Fleet Engine.
	//
	// Returns FAILED_PRECONDITION if the DeliveryVehicle has OPEN Tasks
	// assigned to it.
	DeleteDeliveryVehicle(context.Context, *DeleteDeliveryVehicleRequest) (*emptypb.Empty, error)
	// Writes updated `DeliveryVehicle` data to Fleet Engine, and assigns
	// `Tasks` to the `DeliveryVehicle`. You cannot update the name of the
	// `DeliveryVehicle`. You *can* update `remaining_vehicle_journey_segments`,
	// but it must contain all of the `VehicleJourneySegment`s to be persisted on
	// the `DeliveryVehicle`. The `task_id`s are retrieved from
	// `remaining_vehicle_journey_segments`, and their corresponding `Tasks` are
	// assigned to the `DeliveryVehicle` if they have not yet been assigned.
	UpdateDeliveryVehicle(context.Context, *UpdateDeliveryVehicleRequest) (*DeliveryVehicle, error)
	// Creates and returns a batch of new `Task` objects.
	BatchCreateTasks(context.Context, *BatchCreateTasksRequest) (*BatchCreateTasksResponse, error)
	// Creates and returns a new `Task` object.
	CreateTask(context.Context, *CreateTaskRequest) (*Task, error)
	// Gets information about a `Task`.
	GetTask(context.Context, *GetTaskRequest) (*Task, error)
	// Deletes a single Task.
	//
	// Returns FAILED_PRECONDITION if the Task is OPEN and assigned to a
	// DeliveryVehicle.
	DeleteTask(context.Context, *DeleteTaskRequest) (*emptypb.Empty, error)
	// Updates `Task` data.
	UpdateTask(context.Context, *UpdateTaskRequest) (*Task, error)
	// Gets all `Task`s that meet the specified filtering criteria.
	ListTasks(context.Context, *ListTasksRequest) (*ListTasksResponse, error)
	// Returns the specified `TaskTrackingInfo` instance.
	GetTaskTrackingInfo(context.Context, *GetTaskTrackingInfoRequest) (*TaskTrackingInfo, error)
	// Gets all `DeliveryVehicle`s that meet the specified filtering criteria.
	ListDeliveryVehicles(context.Context, *ListDeliveryVehiclesRequest) (*ListDeliveryVehiclesResponse, error)
}

// UnimplementedDeliveryServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDeliveryServiceServer struct {
}

func (UnimplementedDeliveryServiceServer) CreateDeliveryVehicle(context.Context, *CreateDeliveryVehicleRequest) (*DeliveryVehicle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDeliveryVehicle not implemented")
}
func (UnimplementedDeliveryServiceServer) GetDeliveryVehicle(context.Context, *GetDeliveryVehicleRequest) (*DeliveryVehicle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeliveryVehicle not implemented")
}
func (UnimplementedDeliveryServiceServer) DeleteDeliveryVehicle(context.Context, *DeleteDeliveryVehicleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDeliveryVehicle not implemented")
}
func (UnimplementedDeliveryServiceServer) UpdateDeliveryVehicle(context.Context, *UpdateDeliveryVehicleRequest) (*DeliveryVehicle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDeliveryVehicle not implemented")
}
func (UnimplementedDeliveryServiceServer) BatchCreateTasks(context.Context, *BatchCreateTasksRequest) (*BatchCreateTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateTasks not implemented")
}
func (UnimplementedDeliveryServiceServer) CreateTask(context.Context, *CreateTaskRequest) (*Task, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTask not implemented")
}
func (UnimplementedDeliveryServiceServer) GetTask(context.Context, *GetTaskRequest) (*Task, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTask not implemented")
}
func (UnimplementedDeliveryServiceServer) DeleteTask(context.Context, *DeleteTaskRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTask not implemented")
}
func (UnimplementedDeliveryServiceServer) UpdateTask(context.Context, *UpdateTaskRequest) (*Task, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTask not implemented")
}
func (UnimplementedDeliveryServiceServer) ListTasks(context.Context, *ListTasksRequest) (*ListTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTasks not implemented")
}
func (UnimplementedDeliveryServiceServer) GetTaskTrackingInfo(context.Context, *GetTaskTrackingInfoRequest) (*TaskTrackingInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTaskTrackingInfo not implemented")
}
func (UnimplementedDeliveryServiceServer) ListDeliveryVehicles(context.Context, *ListDeliveryVehiclesRequest) (*ListDeliveryVehiclesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeliveryVehicles not implemented")
}

// UnsafeDeliveryServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DeliveryServiceServer will
// result in compilation errors.
type UnsafeDeliveryServiceServer interface {
	mustEmbedUnimplementedDeliveryServiceServer()
}

func RegisterDeliveryServiceServer(s grpc.ServiceRegistrar, srv DeliveryServiceServer) {
	s.RegisterService(&DeliveryService_ServiceDesc, srv)
}

func _DeliveryService_CreateDeliveryVehicle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeliveryVehicleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).CreateDeliveryVehicle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeliveryService_CreateDeliveryVehicle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).CreateDeliveryVehicle(ctx, req.(*CreateDeliveryVehicleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_GetDeliveryVehicle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeliveryVehicleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).GetDeliveryVehicle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeliveryService_GetDeliveryVehicle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).GetDeliveryVehicle(ctx, req.(*GetDeliveryVehicleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_DeleteDeliveryVehicle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeliveryVehicleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).DeleteDeliveryVehicle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeliveryService_DeleteDeliveryVehicle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).DeleteDeliveryVehicle(ctx, req.(*DeleteDeliveryVehicleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_UpdateDeliveryVehicle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeliveryVehicleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).UpdateDeliveryVehicle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeliveryService_UpdateDeliveryVehicle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).UpdateDeliveryVehicle(ctx, req.(*UpdateDeliveryVehicleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_BatchCreateTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).BatchCreateTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeliveryService_BatchCreateTasks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).BatchCreateTasks(ctx, req.(*BatchCreateTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_CreateTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).CreateTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeliveryService_CreateTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).CreateTask(ctx, req.(*CreateTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_GetTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).GetTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeliveryService_GetTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).GetTask(ctx, req.(*GetTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_DeleteTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).DeleteTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeliveryService_DeleteTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).DeleteTask(ctx, req.(*DeleteTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_UpdateTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).UpdateTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeliveryService_UpdateTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).UpdateTask(ctx, req.(*UpdateTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_ListTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).ListTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeliveryService_ListTasks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).ListTasks(ctx, req.(*ListTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_GetTaskTrackingInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTaskTrackingInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).GetTaskTrackingInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeliveryService_GetTaskTrackingInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).GetTaskTrackingInfo(ctx, req.(*GetTaskTrackingInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeliveryService_ListDeliveryVehicles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeliveryVehiclesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeliveryServiceServer).ListDeliveryVehicles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DeliveryService_ListDeliveryVehicles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeliveryServiceServer).ListDeliveryVehicles(ctx, req.(*ListDeliveryVehiclesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DeliveryService_ServiceDesc is the grpc.ServiceDesc for DeliveryService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DeliveryService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "maps.fleetengine.delivery.v1.DeliveryService",
	HandlerType: (*DeliveryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDeliveryVehicle",
			Handler:    _DeliveryService_CreateDeliveryVehicle_Handler,
		},
		{
			MethodName: "GetDeliveryVehicle",
			Handler:    _DeliveryService_GetDeliveryVehicle_Handler,
		},
		{
			MethodName: "DeleteDeliveryVehicle",
			Handler:    _DeliveryService_DeleteDeliveryVehicle_Handler,
		},
		{
			MethodName: "UpdateDeliveryVehicle",
			Handler:    _DeliveryService_UpdateDeliveryVehicle_Handler,
		},
		{
			MethodName: "BatchCreateTasks",
			Handler:    _DeliveryService_BatchCreateTasks_Handler,
		},
		{
			MethodName: "CreateTask",
			Handler:    _DeliveryService_CreateTask_Handler,
		},
		{
			MethodName: "GetTask",
			Handler:    _DeliveryService_GetTask_Handler,
		},
		{
			MethodName: "DeleteTask",
			Handler:    _DeliveryService_DeleteTask_Handler,
		},
		{
			MethodName: "UpdateTask",
			Handler:    _DeliveryService_UpdateTask_Handler,
		},
		{
			MethodName: "ListTasks",
			Handler:    _DeliveryService_ListTasks_Handler,
		},
		{
			MethodName: "GetTaskTrackingInfo",
			Handler:    _DeliveryService_GetTaskTrackingInfo_Handler,
		},
		{
			MethodName: "ListDeliveryVehicles",
			Handler:    _DeliveryService_ListDeliveryVehicles_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/maps/fleetengine/delivery/v1/delivery_api.proto",
}
