// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto

package agentendpointpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AgentEndpointService_ReceiveTaskNotification_FullMethodName = "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/ReceiveTaskNotification"
	AgentEndpointService_StartNextTask_FullMethodName           = "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/StartNextTask"
	AgentEndpointService_ReportTaskProgress_FullMethodName      = "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/ReportTaskProgress"
	AgentEndpointService_ReportTaskComplete_FullMethodName      = "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/ReportTaskComplete"
	AgentEndpointService_RegisterAgent_FullMethodName           = "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/RegisterAgent"
	AgentEndpointService_ReportInventory_FullMethodName         = "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/ReportInventory"
)

// AgentEndpointServiceClient is the client API for AgentEndpointService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AgentEndpointServiceClient interface {
	// Stream established by client to receive Task notifications.
	ReceiveTaskNotification(ctx context.Context, in *ReceiveTaskNotificationRequest, opts ...grpc.CallOption) (AgentEndpointService_ReceiveTaskNotificationClient, error)
	// Signals the start of a task execution and returns the task info.
	StartNextTask(ctx context.Context, in *StartNextTaskRequest, opts ...grpc.CallOption) (*StartNextTaskResponse, error)
	// Signals an intermediary progress checkpoint in task execution.
	ReportTaskProgress(ctx context.Context, in *ReportTaskProgressRequest, opts ...grpc.CallOption) (*ReportTaskProgressResponse, error)
	// Signals that the task execution is complete and optionally returns the next
	// task.
	ReportTaskComplete(ctx context.Context, in *ReportTaskCompleteRequest, opts ...grpc.CallOption) (*ReportTaskCompleteResponse, error)
	// Registers the agent running on the VM.
	RegisterAgent(ctx context.Context, in *RegisterAgentRequest, opts ...grpc.CallOption) (*RegisterAgentResponse, error)
	// Reports the VMs current inventory.
	ReportInventory(ctx context.Context, in *ReportInventoryRequest, opts ...grpc.CallOption) (*ReportInventoryResponse, error)
}

type agentEndpointServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAgentEndpointServiceClient(cc grpc.ClientConnInterface) AgentEndpointServiceClient {
	return &agentEndpointServiceClient{cc}
}

func (c *agentEndpointServiceClient) ReceiveTaskNotification(ctx context.Context, in *ReceiveTaskNotificationRequest, opts ...grpc.CallOption) (AgentEndpointService_ReceiveTaskNotificationClient, error) {
	stream, err := c.cc.NewStream(ctx, &AgentEndpointService_ServiceDesc.Streams[0], AgentEndpointService_ReceiveTaskNotification_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &agentEndpointServiceReceiveTaskNotificationClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AgentEndpointService_ReceiveTaskNotificationClient interface {
	Recv() (*ReceiveTaskNotificationResponse, error)
	grpc.ClientStream
}

type agentEndpointServiceReceiveTaskNotificationClient struct {
	grpc.ClientStream
}

func (x *agentEndpointServiceReceiveTaskNotificationClient) Recv() (*ReceiveTaskNotificationResponse, error) {
	m := new(ReceiveTaskNotificationResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *agentEndpointServiceClient) StartNextTask(ctx context.Context, in *StartNextTaskRequest, opts ...grpc.CallOption) (*StartNextTaskResponse, error) {
	out := new(StartNextTaskResponse)
	err := c.cc.Invoke(ctx, AgentEndpointService_StartNextTask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentEndpointServiceClient) ReportTaskProgress(ctx context.Context, in *ReportTaskProgressRequest, opts ...grpc.CallOption) (*ReportTaskProgressResponse, error) {
	out := new(ReportTaskProgressResponse)
	err := c.cc.Invoke(ctx, AgentEndpointService_ReportTaskProgress_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentEndpointServiceClient) ReportTaskComplete(ctx context.Context, in *ReportTaskCompleteRequest, opts ...grpc.CallOption) (*ReportTaskCompleteResponse, error) {
	out := new(ReportTaskCompleteResponse)
	err := c.cc.Invoke(ctx, AgentEndpointService_ReportTaskComplete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentEndpointServiceClient) RegisterAgent(ctx context.Context, in *RegisterAgentRequest, opts ...grpc.CallOption) (*RegisterAgentResponse, error) {
	out := new(RegisterAgentResponse)
	err := c.cc.Invoke(ctx, AgentEndpointService_RegisterAgent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentEndpointServiceClient) ReportInventory(ctx context.Context, in *ReportInventoryRequest, opts ...grpc.CallOption) (*ReportInventoryResponse, error) {
	out := new(ReportInventoryResponse)
	err := c.cc.Invoke(ctx, AgentEndpointService_ReportInventory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AgentEndpointServiceServer is the server API for AgentEndpointService service.
// All implementations should embed UnimplementedAgentEndpointServiceServer
// for forward compatibility
type AgentEndpointServiceServer interface {
	// Stream established by client to receive Task notifications.
	ReceiveTaskNotification(*ReceiveTaskNotificationRequest, AgentEndpointService_ReceiveTaskNotificationServer) error
	// Signals the start of a task execution and returns the task info.
	StartNextTask(context.Context, *StartNextTaskRequest) (*StartNextTaskResponse, error)
	// Signals an intermediary progress checkpoint in task execution.
	ReportTaskProgress(context.Context, *ReportTaskProgressRequest) (*ReportTaskProgressResponse, error)
	// Signals that the task execution is complete and optionally returns the next
	// task.
	ReportTaskComplete(context.Context, *ReportTaskCompleteRequest) (*ReportTaskCompleteResponse, error)
	// Registers the agent running on the VM.
	RegisterAgent(context.Context, *RegisterAgentRequest) (*RegisterAgentResponse, error)
	// Reports the VMs current inventory.
	ReportInventory(context.Context, *ReportInventoryRequest) (*ReportInventoryResponse, error)
}

// UnimplementedAgentEndpointServiceServer should be embedded to have forward compatible implementations.
type UnimplementedAgentEndpointServiceServer struct {
}

func (UnimplementedAgentEndpointServiceServer) ReceiveTaskNotification(*ReceiveTaskNotificationRequest, AgentEndpointService_ReceiveTaskNotificationServer) error {
	return status.Errorf(codes.Unimplemented, "method ReceiveTaskNotification not implemented")
}
func (UnimplementedAgentEndpointServiceServer) StartNextTask(context.Context, *StartNextTaskRequest) (*StartNextTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartNextTask not implemented")
}
func (UnimplementedAgentEndpointServiceServer) ReportTaskProgress(context.Context, *ReportTaskProgressRequest) (*ReportTaskProgressResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportTaskProgress not implemented")
}
func (UnimplementedAgentEndpointServiceServer) ReportTaskComplete(context.Context, *ReportTaskCompleteRequest) (*ReportTaskCompleteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportTaskComplete not implemented")
}
func (UnimplementedAgentEndpointServiceServer) RegisterAgent(context.Context, *RegisterAgentRequest) (*RegisterAgentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterAgent not implemented")
}
func (UnimplementedAgentEndpointServiceServer) ReportInventory(context.Context, *ReportInventoryRequest) (*ReportInventoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportInventory not implemented")
}

// UnsafeAgentEndpointServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AgentEndpointServiceServer will
// result in compilation errors.
type UnsafeAgentEndpointServiceServer interface {
	mustEmbedUnimplementedAgentEndpointServiceServer()
}

func RegisterAgentEndpointServiceServer(s grpc.ServiceRegistrar, srv AgentEndpointServiceServer) {
	s.RegisterService(&AgentEndpointService_ServiceDesc, srv)
}

func _AgentEndpointService_ReceiveTaskNotification_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReceiveTaskNotificationRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AgentEndpointServiceServer).ReceiveTaskNotification(m, &agentEndpointServiceReceiveTaskNotificationServer{stream})
}

type AgentEndpointService_ReceiveTaskNotificationServer interface {
	Send(*ReceiveTaskNotificationResponse) error
	grpc.ServerStream
}

type agentEndpointServiceReceiveTaskNotificationServer struct {
	grpc.ServerStream
}

func (x *agentEndpointServiceReceiveTaskNotificationServer) Send(m *ReceiveTaskNotificationResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _AgentEndpointService_StartNextTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartNextTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).StartNextTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AgentEndpointService_StartNextTask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).StartNextTask(ctx, req.(*StartNextTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AgentEndpointService_ReportTaskProgress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportTaskProgressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).ReportTaskProgress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AgentEndpointService_ReportTaskProgress_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).ReportTaskProgress(ctx, req.(*ReportTaskProgressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AgentEndpointService_ReportTaskComplete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportTaskCompleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).ReportTaskComplete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AgentEndpointService_ReportTaskComplete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).ReportTaskComplete(ctx, req.(*ReportTaskCompleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AgentEndpointService_RegisterAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).RegisterAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AgentEndpointService_RegisterAgent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).RegisterAgent(ctx, req.(*RegisterAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AgentEndpointService_ReportInventory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportInventoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).ReportInventory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AgentEndpointService_ReportInventory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).ReportInventory(ctx, req.(*ReportInventoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AgentEndpointService_ServiceDesc is the grpc.ServiceDesc for AgentEndpointService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AgentEndpointService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.osconfig.agentendpoint.v1.AgentEndpointService",
	HandlerType: (*AgentEndpointServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "StartNextTask",
			Handler:    _AgentEndpointService_StartNextTask_Handler,
		},
		{
			MethodName: "ReportTaskProgress",
			Handler:    _AgentEndpointService_ReportTaskProgress_Handler,
		},
		{
			MethodName: "ReportTaskComplete",
			Handler:    _AgentEndpointService_ReportTaskComplete_Handler,
		},
		{
			MethodName: "RegisterAgent",
			Handler:    _AgentEndpointService_RegisterAgent_Handler,
		},
		{
			MethodName: "ReportInventory",
			Handler:    _AgentEndpointService_ReportInventory_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReceiveTaskNotification",
			Handler:       _AgentEndpointService_ReceiveTaskNotification_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto",
}
