// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/privatecatalog/v1beta1/private_catalog.proto

package privatecatalogpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible validation steates of an asset reference.
type AssetReference_AssetValidationState int32

const (
	// Unknown state.
	AssetReference_ASSET_VALIDATION_STATE_UNSPECIFIED AssetReference_AssetValidationState = 0
	// The validation is still in process.
	AssetReference_PENDING AssetReference_AssetValidationState = 1
	// The validation is done and the asset reference is valid.
	AssetReference_VALID AssetReference_AssetValidationState = 2
	// The validation is done and the asset reference is invalid.
	AssetReference_INVALID AssetReference_AssetValidationState = 3
)

// Enum value maps for AssetReference_AssetValidationState.
var (
	AssetReference_AssetValidationState_name = map[int32]string{
		0: "ASSET_VALIDATION_STATE_UNSPECIFIED",
		1: "PENDING",
		2: "VALID",
		3: "INVALID",
	}
	AssetReference_AssetValidationState_value = map[string]int32{
		"ASSET_VALIDATION_STATE_UNSPECIFIED": 0,
		"PENDING":                            1,
		"VALID":                              2,
		"INVALID":                            3,
	}
)

func (x AssetReference_AssetValidationState) Enum() *AssetReference_AssetValidationState {
	p := new(AssetReference_AssetValidationState)
	*p = x
	return p
}

func (x AssetReference_AssetValidationState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AssetReference_AssetValidationState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_enumTypes[0].Descriptor()
}

func (AssetReference_AssetValidationState) Type() protoreflect.EnumType {
	return &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_enumTypes[0]
}

func (x AssetReference_AssetValidationState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AssetReference_AssetValidationState.Descriptor instead.
func (AssetReference_AssetValidationState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescGZIP(), []int{8, 0}
}

// Request message for [PrivateCatalog.SearchCatalogs][google.cloud.privatecatalog.v1beta1.PrivateCatalog.SearchCatalogs].
type SearchCatalogsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the resource context. It can be in following formats:
	//
	// * `projects/{project}`
	// * `folders/{folder}`
	// * `organizations/{organization}`
	Resource string `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// The query to filter the catalogs. The supported queries are:
	//
	// * Get a single catalog: `name=catalogs/{catalog}`
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// The maximum number of entries that are requested.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A pagination token returned from a previous call to SearchCatalogs that
	// indicates where this listing should continue from.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchCatalogsRequest) Reset() {
	*x = SearchCatalogsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchCatalogsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCatalogsRequest) ProtoMessage() {}

func (x *SearchCatalogsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCatalogsRequest.ProtoReflect.Descriptor instead.
func (*SearchCatalogsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescGZIP(), []int{0}
}

func (x *SearchCatalogsRequest) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *SearchCatalogsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchCatalogsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchCatalogsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for [PrivateCatalog.SearchCatalogs][google.cloud.privatecatalog.v1beta1.PrivateCatalog.SearchCatalogs].
type SearchCatalogsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `Catalog`s computed from the resource context.
	Catalogs []*Catalog `protobuf:"bytes,1,rep,name=catalogs,proto3" json:"catalogs,omitempty"`
	// A pagination token returned from a previous call to SearchCatalogs that
	// indicates from where listing should continue.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchCatalogsResponse) Reset() {
	*x = SearchCatalogsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchCatalogsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCatalogsResponse) ProtoMessage() {}

func (x *SearchCatalogsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCatalogsResponse.ProtoReflect.Descriptor instead.
func (*SearchCatalogsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescGZIP(), []int{1}
}

func (x *SearchCatalogsResponse) GetCatalogs() []*Catalog {
	if x != nil {
		return x.Catalogs
	}
	return nil
}

func (x *SearchCatalogsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for [PrivateCatalog.SearchProducts][google.cloud.privatecatalog.v1beta1.PrivateCatalog.SearchProducts].
type SearchProductsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the resource context. See [SearchCatalogsRequest.resource][google.cloud.privatecatalog.v1beta1.SearchCatalogsRequest.resource]
	// for details.
	Resource string `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// The query to filter the products.
	//
	// The supported queries are:
	// * List products of all catalogs: empty
	// * List products under a catalog: `parent=catalogs/{catalog}`
	// * Get a product by name:
	// `name=catalogs/{catalog}/products/{product}`
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// The maximum number of entries that are requested.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A pagination token returned from a previous call to SearchProducts that
	// indicates where this listing should continue from.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchProductsRequest) Reset() {
	*x = SearchProductsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchProductsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchProductsRequest) ProtoMessage() {}

func (x *SearchProductsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchProductsRequest.ProtoReflect.Descriptor instead.
func (*SearchProductsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescGZIP(), []int{2}
}

func (x *SearchProductsRequest) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *SearchProductsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchProductsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchProductsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for [PrivateCatalog.SearchProducts][google.cloud.privatecatalog.v1beta1.PrivateCatalog.SearchProducts].
type SearchProductsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `Product` resources computed from the resource context.
	Products []*Product `protobuf:"bytes,1,rep,name=products,proto3" json:"products,omitempty"`
	// A pagination token returned from a previous call to SearchProducts that
	// indicates from where listing should continue.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchProductsResponse) Reset() {
	*x = SearchProductsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchProductsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchProductsResponse) ProtoMessage() {}

func (x *SearchProductsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchProductsResponse.ProtoReflect.Descriptor instead.
func (*SearchProductsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescGZIP(), []int{3}
}

func (x *SearchProductsResponse) GetProducts() []*Product {
	if x != nil {
		return x.Products
	}
	return nil
}

func (x *SearchProductsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for [PrivateCatalog.SearchVersions][google.cloud.privatecatalog.v1beta1.PrivateCatalog.SearchVersions].
type SearchVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the resource context. See [SearchCatalogsRequest.resource][google.cloud.privatecatalog.v1beta1.SearchCatalogsRequest.resource]
	// for details.
	Resource string `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// Required. The query to filter the versions.
	//
	// The supported queries are:
	// * List versions under a product:
	// `parent=catalogs/{catalog}/products/{product}`
	// * Get a version by name:
	// `name=catalogs/{catalog}/products/{product}/versions/{version}`
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// The maximum number of entries that are requested.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A pagination token returned from a previous call to SearchVersions
	// that indicates where this listing should continue from.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchVersionsRequest) Reset() {
	*x = SearchVersionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchVersionsRequest) ProtoMessage() {}

func (x *SearchVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchVersionsRequest.ProtoReflect.Descriptor instead.
func (*SearchVersionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescGZIP(), []int{4}
}

func (x *SearchVersionsRequest) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *SearchVersionsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchVersionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchVersionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for [PrivateCatalog.SearchVersions][google.cloud.privatecatalog.v1beta1.PrivateCatalog.SearchVersions].
type SearchVersionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `Version` resources computed from the resource context.
	Versions []*Version `protobuf:"bytes,1,rep,name=versions,proto3" json:"versions,omitempty"`
	// A pagination token returned from a previous call to SearchVersions that
	// indicates from where the listing should continue.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchVersionsResponse) Reset() {
	*x = SearchVersionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchVersionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchVersionsResponse) ProtoMessage() {}

func (x *SearchVersionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchVersionsResponse.ProtoReflect.Descriptor instead.
func (*SearchVersionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescGZIP(), []int{5}
}

func (x *SearchVersionsResponse) GetVersions() []*Version {
	if x != nil {
		return x.Versions
	}
	return nil
}

func (x *SearchVersionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The readonly representation of a catalog computed with a given resource
// context.
type Catalog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the target catalog, in the format of
	// `catalogs/{catalog}'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The descriptive name of the catalog as it appears in UIs.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The description of the catalog.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The time when the catalog was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the catalog was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *Catalog) Reset() {
	*x = Catalog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Catalog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Catalog) ProtoMessage() {}

func (x *Catalog) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Catalog.ProtoReflect.Descriptor instead.
func (*Catalog) Descriptor() ([]byte, []int) {
	return file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescGZIP(), []int{6}
}

func (x *Catalog) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Catalog) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Catalog) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Catalog) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Catalog) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// The readonly representation of a product computed with a given resource
// context.
type Product struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the target product, in the format of
	// `products/[a-z][-a-z0-9]*[a-z0-9]'.
	//
	// A unique identifier for the product under a catalog.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The type of the product asset. It can be one of the following values:
	//
	// * `google.deploymentmanager.Template`
	// * `google.cloudprivatecatalog.ListingOnly`
	// * `google.cloudprivatecatalog.Terraform`
	AssetType string `protobuf:"bytes,2,opt,name=asset_type,json=assetType,proto3" json:"asset_type,omitempty"`
	// Required. Output only. The display metadata to describe the product. The JSON schema of the
	// metadata differs by [Product.asset_type][google.cloud.privatecatalog.v1beta1.Product.asset_type].
	// When the type is `google.deploymentmanager.Template`, the schema is as
	// follows:
	//
	// ```
	// "$schema": http://json-schema.org/draft-04/schema#
	// type: object
	// properties:
	//
	//	name:
	//	  type: string
	//	  minLength: 1
	//	  maxLength: 64
	//	description:
	//	  type: string
	//	  minLength: 1
	//	  maxLength: 2048
	//	tagline:
	//	  type: string
	//	  minLength: 1
	//	  maxLength: 100
	//	support_info:
	//	  type: string
	//	  minLength: 1
	//	  maxLength: 2048
	//	creator:
	//	  type: string
	//	  minLength: 1
	//	  maxLength: 100
	//	documentations:
	//	  type: array
	//	  items:
	//	    type: object
	//	    properties:
	//	      url:
	//	        type: string
	//	        pattern:
	//	        "^(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]"
	//	      title:
	//	        type: string
	//	        minLength: 1
	//	        maxLength: 64
	//	      description:
	//	        type: string
	//	        minLength: 1
	//	        maxLength: 2048
	//
	// required:
	// - name
	// - description
	// additionalProperties: false
	//
	// ```
	//
	// When the asset type is `google.cloudprivatecatalog.ListingOnly`, the schema
	// is as follows:
	//
	// ```
	// "$schema": http://json-schema.org/draft-04/schema#
	// type: object
	// properties:
	//
	//	name:
	//	  type: string
	//	  minLength: 1
	//	  maxLength: 64
	//	description:
	//	  type: string
	//	  minLength: 1
	//	  maxLength: 2048
	//	tagline:
	//	  type: string
	//	  minLength: 1
	//	  maxLength: 100
	//	support_info:
	//	  type: string
	//	  minLength: 1
	//	  maxLength: 2048
	//	creator:
	//	  type: string
	//	  minLength: 1
	//	  maxLength: 100
	//	documentations:
	//	  type: array
	//	  items:
	//	    type: object
	//	    properties:
	//	      url:
	//	        type: string
	//	        pattern:
	//	        "^(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]"
	//	      title:
	//	        type: string
	//	        minLength: 1
	//	        maxLength: 64
	//	      description:
	//	        type: string
	//	        minLength: 1
	//	        maxLength: 2048
	//	signup_url:
	//	  type: string
	//	  pattern:
	//	  "^(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]"
	//
	// required:
	// - name
	// - description
	// - signup_url
	// additionalProperties: false
	//
	// ```
	//
	// When the asset type is `google.cloudprivatecatalog.Terraform`, the schema
	// is as follows:
	//
	// ```
	// "$schema": http://json-schema.org/draft-04/schema#
	// type: object
	// properties:
	//
	//	name:
	//	  type: string
	//	  minLength: 1
	//	  maxLength: 64
	//	description:
	//	  type: string
	//	  minLength: 1
	//	  maxLength: 2048
	//	tagline:
	//	  type: string
	//	  minLength: 1
	//	  maxLength: 100
	//	support_info:
	//	  type: string
	//	  minLength: 1
	//	  maxLength: 2048
	//	creator:
	//	  type: string
	//	  minLength: 1
	//	  maxLength: 100
	//	documentations:
	//	  type: array
	//	  items:
	//	    type: object
	//	    properties:
	//	      url:
	//	        type: string
	//	        pattern:
	//	        "^(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]"
	//	      title:
	//	        type: string
	//	        minLength: 1
	//	        maxLength: 64
	//	      description:
	//	        type: string
	//	        minLength: 1
	//	        maxLength: 2048
	//
	// required:
	// - name
	// - description
	// additionalProperties: true
	DisplayMetadata *structpb.Struct `protobuf:"bytes,3,opt,name=display_metadata,json=displayMetadata,proto3" json:"display_metadata,omitempty"`
	// Output only. The icon URI of the product.
	IconUri string `protobuf:"bytes,4,opt,name=icon_uri,json=iconUri,proto3" json:"icon_uri,omitempty"`
	// Output only. A collection of assets referred by a product.
	// This field is set for Terraform Products only.
	AssetReferences []*AssetReference `protobuf:"bytes,10,rep,name=asset_references,json=assetReferences,proto3" json:"asset_references,omitempty"`
	// Output only. The time when the product was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the product was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *Product) Reset() {
	*x = Product{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Product) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Product) ProtoMessage() {}

func (x *Product) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Product.ProtoReflect.Descriptor instead.
func (*Product) Descriptor() ([]byte, []int) {
	return file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescGZIP(), []int{7}
}

func (x *Product) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Product) GetAssetType() string {
	if x != nil {
		return x.AssetType
	}
	return ""
}

func (x *Product) GetDisplayMetadata() *structpb.Struct {
	if x != nil {
		return x.DisplayMetadata
	}
	return nil
}

func (x *Product) GetIconUri() string {
	if x != nil {
		return x.IconUri
	}
	return ""
}

func (x *Product) GetAssetReferences() []*AssetReference {
	if x != nil {
		return x.AssetReferences
	}
	return nil
}

func (x *Product) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Product) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Defines the reference of an asset belonging to a product.
type AssetReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. A unique identifier among asset references in a product.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. The human-readable description of the referenced asset. Maximum 256
	// characters in length.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The definition of input parameters to hydrate the asset template.
	Inputs *Inputs `protobuf:"bytes,6,opt,name=inputs,proto3" json:"inputs,omitempty"`
	// Output only. The current state of the asset reference.
	ValidationStatus AssetReference_AssetValidationState `protobuf:"varint,7,opt,name=validation_status,json=validationStatus,proto3,enum=google.cloud.privatecatalog.v1beta1.AssetReference_AssetValidationState" json:"validation_status,omitempty"`
	// Output only. The validation process metadata.
	ValidationOperation *longrunningpb.Operation `protobuf:"bytes,8,opt,name=validation_operation,json=validationOperation,proto3" json:"validation_operation,omitempty"`
	// The destination of the asset.
	//
	// Types that are assignable to Source:
	//
	//	*AssetReference_Asset
	//	*AssetReference_GcsPath
	//	*AssetReference_GitSource
	Source isAssetReference_Source `protobuf_oneof:"source"`
	// Output only. The cloud storage source.
	GcsSource *GcsSource `protobuf:"bytes,16,opt,name=gcs_source,json=gcsSource,proto3" json:"gcs_source,omitempty"`
	// Output only. The creation timestamp of the asset reference.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update timestamp of the asset reference.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The version of the source used for this asset reference.
	//
	// Deprecated: Marked as deprecated in google/cloud/privatecatalog/v1beta1/private_catalog.proto.
	Version string `protobuf:"bytes,14,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *AssetReference) Reset() {
	*x = AssetReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AssetReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssetReference) ProtoMessage() {}

func (x *AssetReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssetReference.ProtoReflect.Descriptor instead.
func (*AssetReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescGZIP(), []int{8}
}

func (x *AssetReference) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AssetReference) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *AssetReference) GetInputs() *Inputs {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *AssetReference) GetValidationStatus() AssetReference_AssetValidationState {
	if x != nil {
		return x.ValidationStatus
	}
	return AssetReference_ASSET_VALIDATION_STATE_UNSPECIFIED
}

func (x *AssetReference) GetValidationOperation() *longrunningpb.Operation {
	if x != nil {
		return x.ValidationOperation
	}
	return nil
}

func (m *AssetReference) GetSource() isAssetReference_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *AssetReference) GetAsset() string {
	if x, ok := x.GetSource().(*AssetReference_Asset); ok {
		return x.Asset
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/privatecatalog/v1beta1/private_catalog.proto.
func (x *AssetReference) GetGcsPath() string {
	if x, ok := x.GetSource().(*AssetReference_GcsPath); ok {
		return x.GcsPath
	}
	return ""
}

func (x *AssetReference) GetGitSource() *GitSource {
	if x, ok := x.GetSource().(*AssetReference_GitSource); ok {
		return x.GitSource
	}
	return nil
}

func (x *AssetReference) GetGcsSource() *GcsSource {
	if x != nil {
		return x.GcsSource
	}
	return nil
}

func (x *AssetReference) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AssetReference) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/privatecatalog/v1beta1/private_catalog.proto.
func (x *AssetReference) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type isAssetReference_Source interface {
	isAssetReference_Source()
}

type AssetReference_Asset struct {
	// Output only. The asset resource name if an asset is hosted by Private Catalog.
	Asset string `protobuf:"bytes,10,opt,name=asset,proto3,oneof"`
}

type AssetReference_GcsPath struct {
	// Output only. The cloud storage object path.
	//
	// Deprecated: Marked as deprecated in google/cloud/privatecatalog/v1beta1/private_catalog.proto.
	GcsPath string `protobuf:"bytes,11,opt,name=gcs_path,json=gcsPath,proto3,oneof"`
}

type AssetReference_GitSource struct {
	// Output only. The git source.
	GitSource *GitSource `protobuf:"bytes,15,opt,name=git_source,json=gitSource,proto3,oneof"`
}

func (*AssetReference_Asset) isAssetReference_Source() {}

func (*AssetReference_GcsPath) isAssetReference_Source() {}

func (*AssetReference_GitSource) isAssetReference_Source() {}

// Defines definition of input parameters of asset templates.
type Inputs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The JSON schema defining the inputs and their formats.
	Parameters *structpb.Struct `protobuf:"bytes,1,opt,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *Inputs) Reset() {
	*x = Inputs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Inputs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inputs) ProtoMessage() {}

func (x *Inputs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inputs.ProtoReflect.Descriptor instead.
func (*Inputs) Descriptor() ([]byte, []int) {
	return file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescGZIP(), []int{9}
}

func (x *Inputs) GetParameters() *structpb.Struct {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Defines how to access Cloud Storage source.
type GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. the cloud storage object path.
	GcsPath string `protobuf:"bytes,1,opt,name=gcs_path,json=gcsPath,proto3" json:"gcs_path,omitempty"`
	// Output only. Generation of the object, which is set when the content of an object starts
	// being written.
	Generation int64 `protobuf:"varint,2,opt,name=generation,proto3" json:"generation,omitempty"`
	// Output only. The time when the object metadata was last changed.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *GcsSource) Reset() {
	*x = GcsSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsSource) ProtoMessage() {}

func (x *GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsSource.ProtoReflect.Descriptor instead.
func (*GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescGZIP(), []int{10}
}

func (x *GcsSource) GetGcsPath() string {
	if x != nil {
		return x.GcsPath
	}
	return ""
}

func (x *GcsSource) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *GcsSource) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Defines how to access a Git Source.
type GitSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location of the Git repo to build.
	Repo string `protobuf:"bytes,1,opt,name=repo,proto3" json:"repo,omitempty"`
	// Directory, relative to the source root, in which to run the build.
	//
	// This must be a relative path. If a step's `dir` is specified and is an
	// absolute path, this value is ignored for that step's execution.
	Dir string `protobuf:"bytes,2,opt,name=dir,proto3" json:"dir,omitempty"`
	// The revision to fetch from the Git repository such as a branch, a tag, a
	// commit SHA, or any Git ref.
	//
	// Types that are assignable to Ref:
	//
	//	*GitSource_Commit
	//	*GitSource_Branch
	//	*GitSource_Tag
	Ref isGitSource_Ref `protobuf_oneof:"ref"`
}

func (x *GitSource) Reset() {
	*x = GitSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GitSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GitSource) ProtoMessage() {}

func (x *GitSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GitSource.ProtoReflect.Descriptor instead.
func (*GitSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescGZIP(), []int{11}
}

func (x *GitSource) GetRepo() string {
	if x != nil {
		return x.Repo
	}
	return ""
}

func (x *GitSource) GetDir() string {
	if x != nil {
		return x.Dir
	}
	return ""
}

func (m *GitSource) GetRef() isGitSource_Ref {
	if m != nil {
		return m.Ref
	}
	return nil
}

func (x *GitSource) GetCommit() string {
	if x, ok := x.GetRef().(*GitSource_Commit); ok {
		return x.Commit
	}
	return ""
}

func (x *GitSource) GetBranch() string {
	if x, ok := x.GetRef().(*GitSource_Branch); ok {
		return x.Branch
	}
	return ""
}

func (x *GitSource) GetTag() string {
	if x, ok := x.GetRef().(*GitSource_Tag); ok {
		return x.Tag
	}
	return ""
}

type isGitSource_Ref interface {
	isGitSource_Ref()
}

type GitSource_Commit struct {
	// The revision commit to use.
	Commit string `protobuf:"bytes,3,opt,name=commit,proto3,oneof"`
}

type GitSource_Branch struct {
	// The revision branch to use.
	Branch string `protobuf:"bytes,4,opt,name=branch,proto3,oneof"`
}

type GitSource_Tag struct {
	// The revision tag to use.
	Tag string `protobuf:"bytes,5,opt,name=tag,proto3,oneof"`
}

func (*GitSource_Commit) isGitSource_Ref() {}

func (*GitSource_Branch) isGitSource_Ref() {}

func (*GitSource_Tag) isGitSource_Ref() {}

// The consumer representation of a version which is a child resource under a
// `Product` with asset data.
type Version struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the version, in the format
	// `catalogs/{catalog}/products/{product}/versions/[a-z][-a-z0-9]*[a-z0-9]'.
	//
	// A unique identifier for the version under a product.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The user-supplied description of the version. Maximum of 256
	// characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The asset which has been validated and is ready to be
	// provisioned. See
	// [google.cloud.privatecatalogproducer.v1beta.Version.asset][] for details.
	Asset *structpb.Struct `protobuf:"bytes,3,opt,name=asset,proto3" json:"asset,omitempty"`
	// Output only. The time when the version was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the version was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *Version) Reset() {
	*x = Version{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Version) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Version) ProtoMessage() {}

func (x *Version) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Version.ProtoReflect.Descriptor instead.
func (*Version) Descriptor() ([]byte, []int) {
	return file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescGZIP(), []int{12}
}

func (x *Version) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Version) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Version) GetAsset() *structpb.Struct {
	if x != nil {
		return x.Asset
	}
	return nil
}

func (x *Version) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Version) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

var File_google_cloud_privatecatalog_v1beta1_private_catalog_proto protoreflect.FileDescriptor

var file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8a, 0x01, 0x0a, 0x15, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1f, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8a, 0x01, 0x0a, 0x16, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x48, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52,
	0x08, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x8a, 0x01, 0x0a, 0x15, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8a,
	0x01, 0x0a, 0x16, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x08, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8f, 0x01, 0x0a, 0x15,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8a, 0x01,
	0x0a, 0x16, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x08, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xba, 0x02, 0x0a, 0x07, 0x43,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x3a, 0x43, 0xea, 0x41, 0x40, 0x0a, 0x2a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x12, 0x12, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x7b, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x7d, 0x22, 0xe0, 0x03, 0x0a, 0x07, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x61, 0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x4a, 0x0a, 0x10, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1e, 0x0a, 0x08,
	0x69, 0x63, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x69, 0x63, 0x6f, 0x6e, 0x55, 0x72, 0x69, 0x12, 0x63, 0x0a, 0x10,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x43, 0xea, 0x41, 0x40, 0x0a, 0x2a, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x12, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x7d, 0x22, 0xe5, 0x06, 0x0a, 0x0e, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x13, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x06, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x73, 0x12, 0x7a, 0x0a, 0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x55, 0x0a, 0x14, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x13, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x12, 0x22, 0x0a, 0x08, 0x67, 0x63, 0x73, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01, 0x48, 0x00, 0x52, 0x07,
	0x67, 0x63, 0x73, 0x50, 0x61, 0x74, 0x68, 0x12, 0x54, 0x0a, 0x0a, 0x67, 0x69, 0x74, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x47, 0x69, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x48, 0x00, 0x52, 0x09, 0x67, 0x69, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x52, 0x0a,
	0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x22, 0x63, 0x0a, 0x14, 0x41, 0x73, 0x73, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x22, 0x41,
	0x53, 0x53, 0x45, 0x54, 0x5f, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x09, 0x0a, 0x05, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x49,
	0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x03, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0x46, 0x0a, 0x06, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x3c, 0x0a, 0x0a,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x92, 0x01, 0x0a, 0x09, 0x47,
	0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x67, 0x63, 0x73, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x67, 0x63, 0x73, 0x50, 0x61, 0x74, 0x68, 0x12, 0x23, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22,
	0x80, 0x01, 0x0a, 0x09, 0x47, 0x69, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x72, 0x65, 0x70, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x65, 0x70,
	0x6f, 0x12, 0x10, 0x0a, 0x03, 0x64, 0x69, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x64, 0x69, 0x72, 0x12, 0x18, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0x18, 0x0a,
	0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x12, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x74, 0x61, 0x67, 0x42, 0x05, 0x0a, 0x03, 0x72,
	0x65, 0x66, 0x22, 0xec, 0x02, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32,
	0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x69, 0xea, 0x41, 0x66, 0x0a, 0x2a, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x73, 0x2f, 0x7b, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x7d, 0x2f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x7d, 0x32, 0xf2, 0x07, 0x0a, 0x0e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x12, 0xab, 0x02, 0x0a, 0x0e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x9f, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x98, 0x01, 0x5a, 0x35, 0x12, 0x33, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5a, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x12, 0xab, 0x02, 0x0a, 0x0e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9f,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x98, 0x01, 0x5a, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5a,
	0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x12, 0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x12, 0xab, 0x02, 0x0a, 0x0e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9f, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x98, 0x01, 0x5a, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5a, 0x2f, 0x12,
	0x2d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x2e,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x1a, 0x56,
	0xca, 0x41, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x86, 0x02, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x42, 0x13, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x70, 0x62, 0x3b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x70, 0x62, 0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31,
	0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x5c, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescOnce sync.Once
	file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescData = file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDesc
)

func file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescGZIP() []byte {
	file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescOnce.Do(func() {
		file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescData)
	})
	return file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDescData
}

var file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_goTypes = []any{
	(AssetReference_AssetValidationState)(0), // 0: google.cloud.privatecatalog.v1beta1.AssetReference.AssetValidationState
	(*SearchCatalogsRequest)(nil),            // 1: google.cloud.privatecatalog.v1beta1.SearchCatalogsRequest
	(*SearchCatalogsResponse)(nil),           // 2: google.cloud.privatecatalog.v1beta1.SearchCatalogsResponse
	(*SearchProductsRequest)(nil),            // 3: google.cloud.privatecatalog.v1beta1.SearchProductsRequest
	(*SearchProductsResponse)(nil),           // 4: google.cloud.privatecatalog.v1beta1.SearchProductsResponse
	(*SearchVersionsRequest)(nil),            // 5: google.cloud.privatecatalog.v1beta1.SearchVersionsRequest
	(*SearchVersionsResponse)(nil),           // 6: google.cloud.privatecatalog.v1beta1.SearchVersionsResponse
	(*Catalog)(nil),                          // 7: google.cloud.privatecatalog.v1beta1.Catalog
	(*Product)(nil),                          // 8: google.cloud.privatecatalog.v1beta1.Product
	(*AssetReference)(nil),                   // 9: google.cloud.privatecatalog.v1beta1.AssetReference
	(*Inputs)(nil),                           // 10: google.cloud.privatecatalog.v1beta1.Inputs
	(*GcsSource)(nil),                        // 11: google.cloud.privatecatalog.v1beta1.GcsSource
	(*GitSource)(nil),                        // 12: google.cloud.privatecatalog.v1beta1.GitSource
	(*Version)(nil),                          // 13: google.cloud.privatecatalog.v1beta1.Version
	(*timestamppb.Timestamp)(nil),            // 14: google.protobuf.Timestamp
	(*structpb.Struct)(nil),                  // 15: google.protobuf.Struct
	(*longrunningpb.Operation)(nil),          // 16: google.longrunning.Operation
}
var file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_depIdxs = []int32{
	7,  // 0: google.cloud.privatecatalog.v1beta1.SearchCatalogsResponse.catalogs:type_name -> google.cloud.privatecatalog.v1beta1.Catalog
	8,  // 1: google.cloud.privatecatalog.v1beta1.SearchProductsResponse.products:type_name -> google.cloud.privatecatalog.v1beta1.Product
	13, // 2: google.cloud.privatecatalog.v1beta1.SearchVersionsResponse.versions:type_name -> google.cloud.privatecatalog.v1beta1.Version
	14, // 3: google.cloud.privatecatalog.v1beta1.Catalog.create_time:type_name -> google.protobuf.Timestamp
	14, // 4: google.cloud.privatecatalog.v1beta1.Catalog.update_time:type_name -> google.protobuf.Timestamp
	15, // 5: google.cloud.privatecatalog.v1beta1.Product.display_metadata:type_name -> google.protobuf.Struct
	9,  // 6: google.cloud.privatecatalog.v1beta1.Product.asset_references:type_name -> google.cloud.privatecatalog.v1beta1.AssetReference
	14, // 7: google.cloud.privatecatalog.v1beta1.Product.create_time:type_name -> google.protobuf.Timestamp
	14, // 8: google.cloud.privatecatalog.v1beta1.Product.update_time:type_name -> google.protobuf.Timestamp
	10, // 9: google.cloud.privatecatalog.v1beta1.AssetReference.inputs:type_name -> google.cloud.privatecatalog.v1beta1.Inputs
	0,  // 10: google.cloud.privatecatalog.v1beta1.AssetReference.validation_status:type_name -> google.cloud.privatecatalog.v1beta1.AssetReference.AssetValidationState
	16, // 11: google.cloud.privatecatalog.v1beta1.AssetReference.validation_operation:type_name -> google.longrunning.Operation
	12, // 12: google.cloud.privatecatalog.v1beta1.AssetReference.git_source:type_name -> google.cloud.privatecatalog.v1beta1.GitSource
	11, // 13: google.cloud.privatecatalog.v1beta1.AssetReference.gcs_source:type_name -> google.cloud.privatecatalog.v1beta1.GcsSource
	14, // 14: google.cloud.privatecatalog.v1beta1.AssetReference.create_time:type_name -> google.protobuf.Timestamp
	14, // 15: google.cloud.privatecatalog.v1beta1.AssetReference.update_time:type_name -> google.protobuf.Timestamp
	15, // 16: google.cloud.privatecatalog.v1beta1.Inputs.parameters:type_name -> google.protobuf.Struct
	14, // 17: google.cloud.privatecatalog.v1beta1.GcsSource.update_time:type_name -> google.protobuf.Timestamp
	15, // 18: google.cloud.privatecatalog.v1beta1.Version.asset:type_name -> google.protobuf.Struct
	14, // 19: google.cloud.privatecatalog.v1beta1.Version.create_time:type_name -> google.protobuf.Timestamp
	14, // 20: google.cloud.privatecatalog.v1beta1.Version.update_time:type_name -> google.protobuf.Timestamp
	1,  // 21: google.cloud.privatecatalog.v1beta1.PrivateCatalog.SearchCatalogs:input_type -> google.cloud.privatecatalog.v1beta1.SearchCatalogsRequest
	3,  // 22: google.cloud.privatecatalog.v1beta1.PrivateCatalog.SearchProducts:input_type -> google.cloud.privatecatalog.v1beta1.SearchProductsRequest
	5,  // 23: google.cloud.privatecatalog.v1beta1.PrivateCatalog.SearchVersions:input_type -> google.cloud.privatecatalog.v1beta1.SearchVersionsRequest
	2,  // 24: google.cloud.privatecatalog.v1beta1.PrivateCatalog.SearchCatalogs:output_type -> google.cloud.privatecatalog.v1beta1.SearchCatalogsResponse
	4,  // 25: google.cloud.privatecatalog.v1beta1.PrivateCatalog.SearchProducts:output_type -> google.cloud.privatecatalog.v1beta1.SearchProductsResponse
	6,  // 26: google.cloud.privatecatalog.v1beta1.PrivateCatalog.SearchVersions:output_type -> google.cloud.privatecatalog.v1beta1.SearchVersionsResponse
	24, // [24:27] is the sub-list for method output_type
	21, // [21:24] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_init() }
func file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_init() {
	if File_google_cloud_privatecatalog_v1beta1_private_catalog_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*SearchCatalogsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*SearchCatalogsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*SearchProductsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*SearchProductsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*SearchVersionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*SearchVersionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*Catalog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*Product); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*AssetReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*Inputs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*GcsSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*GitSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*Version); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[8].OneofWrappers = []any{
		(*AssetReference_Asset)(nil),
		(*AssetReference_GcsPath)(nil),
		(*AssetReference_GitSource)(nil),
	}
	file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes[11].OneofWrappers = []any{
		(*GitSource_Commit)(nil),
		(*GitSource_Branch)(nil),
		(*GitSource_Tag)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_goTypes,
		DependencyIndexes: file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_depIdxs,
		EnumInfos:         file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_enumTypes,
		MessageInfos:      file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_msgTypes,
	}.Build()
	File_google_cloud_privatecatalog_v1beta1_private_catalog_proto = out.File
	file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_rawDesc = nil
	file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_goTypes = nil
	file_google_cloud_privatecatalog_v1beta1_private_catalog_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PrivateCatalogClient is the client API for PrivateCatalog service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PrivateCatalogClient interface {
	// Search [Catalog][google.cloud.privatecatalog.v1beta1.Catalog] resources that consumers have access to, within the
	// scope of the consumer cloud resource hierarchy context.
	SearchCatalogs(ctx context.Context, in *SearchCatalogsRequest, opts ...grpc.CallOption) (*SearchCatalogsResponse, error)
	// Search [Product][google.cloud.privatecatalog.v1beta1.Product] resources that consumers have access to, within the
	// scope of the consumer cloud resource hierarchy context.
	SearchProducts(ctx context.Context, in *SearchProductsRequest, opts ...grpc.CallOption) (*SearchProductsResponse, error)
	// Search [Version][google.cloud.privatecatalog.v1beta1.Version] resources that consumers have access to, within the
	// scope of the consumer cloud resource hierarchy context.
	SearchVersions(ctx context.Context, in *SearchVersionsRequest, opts ...grpc.CallOption) (*SearchVersionsResponse, error)
}

type privateCatalogClient struct {
	cc grpc.ClientConnInterface
}

func NewPrivateCatalogClient(cc grpc.ClientConnInterface) PrivateCatalogClient {
	return &privateCatalogClient{cc}
}

func (c *privateCatalogClient) SearchCatalogs(ctx context.Context, in *SearchCatalogsRequest, opts ...grpc.CallOption) (*SearchCatalogsResponse, error) {
	out := new(SearchCatalogsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.privatecatalog.v1beta1.PrivateCatalog/SearchCatalogs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privateCatalogClient) SearchProducts(ctx context.Context, in *SearchProductsRequest, opts ...grpc.CallOption) (*SearchProductsResponse, error) {
	out := new(SearchProductsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.privatecatalog.v1beta1.PrivateCatalog/SearchProducts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privateCatalogClient) SearchVersions(ctx context.Context, in *SearchVersionsRequest, opts ...grpc.CallOption) (*SearchVersionsResponse, error) {
	out := new(SearchVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.privatecatalog.v1beta1.PrivateCatalog/SearchVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PrivateCatalogServer is the server API for PrivateCatalog service.
type PrivateCatalogServer interface {
	// Search [Catalog][google.cloud.privatecatalog.v1beta1.Catalog] resources that consumers have access to, within the
	// scope of the consumer cloud resource hierarchy context.
	SearchCatalogs(context.Context, *SearchCatalogsRequest) (*SearchCatalogsResponse, error)
	// Search [Product][google.cloud.privatecatalog.v1beta1.Product] resources that consumers have access to, within the
	// scope of the consumer cloud resource hierarchy context.
	SearchProducts(context.Context, *SearchProductsRequest) (*SearchProductsResponse, error)
	// Search [Version][google.cloud.privatecatalog.v1beta1.Version] resources that consumers have access to, within the
	// scope of the consumer cloud resource hierarchy context.
	SearchVersions(context.Context, *SearchVersionsRequest) (*SearchVersionsResponse, error)
}

// UnimplementedPrivateCatalogServer can be embedded to have forward compatible implementations.
type UnimplementedPrivateCatalogServer struct {
}

func (*UnimplementedPrivateCatalogServer) SearchCatalogs(context.Context, *SearchCatalogsRequest) (*SearchCatalogsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchCatalogs not implemented")
}
func (*UnimplementedPrivateCatalogServer) SearchProducts(context.Context, *SearchProductsRequest) (*SearchProductsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchProducts not implemented")
}
func (*UnimplementedPrivateCatalogServer) SearchVersions(context.Context, *SearchVersionsRequest) (*SearchVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchVersions not implemented")
}

func RegisterPrivateCatalogServer(s *grpc.Server, srv PrivateCatalogServer) {
	s.RegisterService(&_PrivateCatalog_serviceDesc, srv)
}

func _PrivateCatalog_SearchCatalogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchCatalogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivateCatalogServer).SearchCatalogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privatecatalog.v1beta1.PrivateCatalog/SearchCatalogs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivateCatalogServer).SearchCatalogs(ctx, req.(*SearchCatalogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivateCatalog_SearchProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivateCatalogServer).SearchProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privatecatalog.v1beta1.PrivateCatalog/SearchProducts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivateCatalogServer).SearchProducts(ctx, req.(*SearchProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivateCatalog_SearchVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivateCatalogServer).SearchVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privatecatalog.v1beta1.PrivateCatalog/SearchVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivateCatalogServer).SearchVersions(ctx, req.(*SearchVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PrivateCatalog_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.privatecatalog.v1beta1.PrivateCatalog",
	HandlerType: (*PrivateCatalogServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchCatalogs",
			Handler:    _PrivateCatalog_SearchCatalogs_Handler,
		},
		{
			MethodName: "SearchProducts",
			Handler:    _PrivateCatalog_SearchProducts_Handler,
		},
		{
			MethodName: "SearchVersions",
			Handler:    _PrivateCatalog_SearchVersions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/privatecatalog/v1beta1/private_catalog.proto",
}
