// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/resourcemanager/v3/projects.proto

package resourcemanagerpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Projects_GetProject_FullMethodName         = "/google.cloud.resourcemanager.v3.Projects/GetProject"
	Projects_ListProjects_FullMethodName       = "/google.cloud.resourcemanager.v3.Projects/ListProjects"
	Projects_SearchProjects_FullMethodName     = "/google.cloud.resourcemanager.v3.Projects/SearchProjects"
	Projects_CreateProject_FullMethodName      = "/google.cloud.resourcemanager.v3.Projects/CreateProject"
	Projects_UpdateProject_FullMethodName      = "/google.cloud.resourcemanager.v3.Projects/UpdateProject"
	Projects_MoveProject_FullMethodName        = "/google.cloud.resourcemanager.v3.Projects/MoveProject"
	Projects_DeleteProject_FullMethodName      = "/google.cloud.resourcemanager.v3.Projects/DeleteProject"
	Projects_UndeleteProject_FullMethodName    = "/google.cloud.resourcemanager.v3.Projects/UndeleteProject"
	Projects_GetIamPolicy_FullMethodName       = "/google.cloud.resourcemanager.v3.Projects/GetIamPolicy"
	Projects_SetIamPolicy_FullMethodName       = "/google.cloud.resourcemanager.v3.Projects/SetIamPolicy"
	Projects_TestIamPermissions_FullMethodName = "/google.cloud.resourcemanager.v3.Projects/TestIamPermissions"
)

// ProjectsClient is the client API for Projects service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ProjectsClient interface {
	// Retrieves the project identified by the specified `name` (for example,
	// `projects/415104041262`).
	//
	// The caller must have `resourcemanager.projects.get` permission
	// for this project.
	GetProject(ctx context.Context, in *GetProjectRequest, opts ...grpc.CallOption) (*Project, error)
	// Lists projects that are direct children of the specified folder or
	// organization resource. `list()` provides a strongly consistent view of the
	// projects underneath the specified parent resource. `list()` returns
	// projects sorted based upon the (ascending) lexical ordering of their
	// `display_name`. The caller must have `resourcemanager.projects.list`
	// permission on the identified parent.
	ListProjects(ctx context.Context, in *ListProjectsRequest, opts ...grpc.CallOption) (*ListProjectsResponse, error)
	// Search for projects that the caller has both `resourcemanager.projects.get`
	// permission on, and also satisfy the specified query.
	//
	// This method returns projects in an unspecified order.
	//
	// This method is eventually consistent with project mutations; this means
	// that a newly created project may not appear in the results or recent
	// updates to an existing project may not be reflected in the results. To
	// retrieve the latest state of a project, use the
	// [GetProject][google.cloud.resourcemanager.v3.Projects.GetProject] method.
	SearchProjects(ctx context.Context, in *SearchProjectsRequest, opts ...grpc.CallOption) (*SearchProjectsResponse, error)
	// Request that a new project be created. The result is an `Operation` which
	// can be used to track the creation process. This process usually takes a few
	// seconds, but can sometimes take much longer. The tracking `Operation` is
	// automatically deleted after a few hours, so there is no need to call
	// `DeleteOperation`.
	CreateProject(ctx context.Context, in *CreateProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the `display_name` and labels of the project identified by the
	// specified `name` (for example, `projects/415104041262`). Deleting all
	// labels requires an update mask for labels field.
	//
	// The caller must have `resourcemanager.projects.update` permission for this
	// project.
	UpdateProject(ctx context.Context, in *UpdateProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Move a project to another place in your resource hierarchy, under a new
	// resource parent.
	//
	// Returns an operation which can be used to track the process of the project
	// move workflow.
	// Upon success, the `Operation.response` field will be populated with the
	// moved project.
	//
	// The caller must have `resourcemanager.projects.move` permission on the
	// project, on the project's current and proposed new parent.
	//
	// If project has no current parent, or it currently does not have an
	// associated organization resource, you will also need the
	// `resourcemanager.projects.setIamPolicy` permission in the project.
	MoveProject(ctx context.Context, in *MoveProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Marks the project identified by the specified
	// `name` (for example, `projects/415104041262`) for deletion.
	//
	// This method will only affect the project if it has a lifecycle state of
	// [ACTIVE][google.cloud.resourcemanager.v3.Project.State.ACTIVE].
	//
	// This method changes the Project's lifecycle state from
	// [ACTIVE][google.cloud.resourcemanager.v3.Project.State.ACTIVE]
	// to
	// [DELETE_REQUESTED][google.cloud.resourcemanager.v3.Project.State.DELETE_REQUESTED].
	// The deletion starts at an unspecified time,
	// at which point the Project is no longer accessible.
	//
	// Until the deletion completes, you can check the lifecycle state
	// checked by retrieving the project with [GetProject]
	// [google.cloud.resourcemanager.v3.Projects.GetProject],
	// and the project remains visible to [ListProjects]
	// [google.cloud.resourcemanager.v3.Projects.ListProjects].
	// However, you cannot update the project.
	//
	// After the deletion completes, the project is not retrievable by
	// the  [GetProject]
	// [google.cloud.resourcemanager.v3.Projects.GetProject],
	// [ListProjects]
	// [google.cloud.resourcemanager.v3.Projects.ListProjects], and
	// [SearchProjects][google.cloud.resourcemanager.v3.Projects.SearchProjects]
	// methods.
	//
	// This method behaves idempotently, such that deleting a `DELETE_REQUESTED`
	// project will not cause an error, but also won't do anything.
	//
	// The caller must have `resourcemanager.projects.delete` permissions for this
	// project.
	DeleteProject(ctx context.Context, in *DeleteProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Restores the project identified by the specified
	// `name` (for example, `projects/415104041262`).
	// You can only use this method for a project that has a lifecycle state of
	// [DELETE_REQUESTED]
	// [Projects.State.DELETE_REQUESTED].
	// After deletion starts, the project cannot be restored.
	//
	// The caller must have `resourcemanager.projects.undelete` permission for
	// this project.
	UndeleteProject(ctx context.Context, in *UndeleteProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns the IAM access control policy for the specified project, in the
	// format `projects/{ProjectIdOrNumber}` e.g. projects/123.
	// Permission is denied if the policy or the resource do not exist.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the IAM access control policy for the specified project, in the
	// format `projects/{ProjectIdOrNumber}` e.g. projects/123.
	//
	// CAUTION: This method will replace the existing policy, and cannot be used
	// to append additional IAM settings.
	//
	// Note: Removing service accounts from policies or changing their roles can
	// render services completely inoperable. It is important to understand how
	// the service account is being used before removing or updating its roles.
	//
	// The following constraints apply when using `setIamPolicy()`:
	//
	// + Project does not support `allUsers` and `allAuthenticatedUsers` as
	// `members` in a `Binding` of a `Policy`.
	//
	// + The owner role can be granted to a `user`, `serviceAccount`, or a group
	// that is part of an organization. For example,
	// group@myownpersonaldomain.com could be added as an owner to a project in
	// the myownpersonaldomain.com organization, but not the examplepetstore.com
	// organization.
	//
	// + Service accounts can be made owners of a project directly
	// without any restrictions. However, to be added as an owner, a user must be
	// invited using the Cloud Platform console and must accept the invitation.
	//
	// + A user cannot be granted the owner role using `setIamPolicy()`. The user
	// must be granted the owner role using the Cloud Platform Console and must
	// explicitly accept the invitation.
	//
	// + Invitations to grant the owner role cannot be sent using
	// `setIamPolicy()`;
	// they must be sent only using the Cloud Platform Console.
	//
	// + If the project is not part of an organization, there must be at least
	// one owner who has accepted the Terms of Service (ToS) agreement in the
	// policy. Calling `setIamPolicy()` to remove the last ToS-accepted owner
	// from the policy will fail. This restriction also applies to legacy
	// projects that no longer have owners who have accepted the ToS. Edits to
	// IAM policies will be rejected until the lack of a ToS-accepting owner is
	// rectified. If the project is part of an organization, you can remove all
	// owners, potentially making the organization inaccessible.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns permissions that a caller has on the specified project, in the
	// format `projects/{ProjectIdOrNumber}` e.g. projects/123..
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type projectsClient struct {
	cc grpc.ClientConnInterface
}

func NewProjectsClient(cc grpc.ClientConnInterface) ProjectsClient {
	return &projectsClient{cc}
}

func (c *projectsClient) GetProject(ctx context.Context, in *GetProjectRequest, opts ...grpc.CallOption) (*Project, error) {
	out := new(Project)
	err := c.cc.Invoke(ctx, Projects_GetProject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectsClient) ListProjects(ctx context.Context, in *ListProjectsRequest, opts ...grpc.CallOption) (*ListProjectsResponse, error) {
	out := new(ListProjectsResponse)
	err := c.cc.Invoke(ctx, Projects_ListProjects_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectsClient) SearchProjects(ctx context.Context, in *SearchProjectsRequest, opts ...grpc.CallOption) (*SearchProjectsResponse, error) {
	out := new(SearchProjectsResponse)
	err := c.cc.Invoke(ctx, Projects_SearchProjects_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectsClient) CreateProject(ctx context.Context, in *CreateProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Projects_CreateProject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectsClient) UpdateProject(ctx context.Context, in *UpdateProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Projects_UpdateProject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectsClient) MoveProject(ctx context.Context, in *MoveProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Projects_MoveProject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectsClient) DeleteProject(ctx context.Context, in *DeleteProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Projects_DeleteProject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectsClient) UndeleteProject(ctx context.Context, in *UndeleteProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Projects_UndeleteProject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectsClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, Projects_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectsClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, Projects_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectsClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, Projects_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProjectsServer is the server API for Projects service.
// All implementations should embed UnimplementedProjectsServer
// for forward compatibility
type ProjectsServer interface {
	// Retrieves the project identified by the specified `name` (for example,
	// `projects/415104041262`).
	//
	// The caller must have `resourcemanager.projects.get` permission
	// for this project.
	GetProject(context.Context, *GetProjectRequest) (*Project, error)
	// Lists projects that are direct children of the specified folder or
	// organization resource. `list()` provides a strongly consistent view of the
	// projects underneath the specified parent resource. `list()` returns
	// projects sorted based upon the (ascending) lexical ordering of their
	// `display_name`. The caller must have `resourcemanager.projects.list`
	// permission on the identified parent.
	ListProjects(context.Context, *ListProjectsRequest) (*ListProjectsResponse, error)
	// Search for projects that the caller has both `resourcemanager.projects.get`
	// permission on, and also satisfy the specified query.
	//
	// This method returns projects in an unspecified order.
	//
	// This method is eventually consistent with project mutations; this means
	// that a newly created project may not appear in the results or recent
	// updates to an existing project may not be reflected in the results. To
	// retrieve the latest state of a project, use the
	// [GetProject][google.cloud.resourcemanager.v3.Projects.GetProject] method.
	SearchProjects(context.Context, *SearchProjectsRequest) (*SearchProjectsResponse, error)
	// Request that a new project be created. The result is an `Operation` which
	// can be used to track the creation process. This process usually takes a few
	// seconds, but can sometimes take much longer. The tracking `Operation` is
	// automatically deleted after a few hours, so there is no need to call
	// `DeleteOperation`.
	CreateProject(context.Context, *CreateProjectRequest) (*longrunningpb.Operation, error)
	// Updates the `display_name` and labels of the project identified by the
	// specified `name` (for example, `projects/415104041262`). Deleting all
	// labels requires an update mask for labels field.
	//
	// The caller must have `resourcemanager.projects.update` permission for this
	// project.
	UpdateProject(context.Context, *UpdateProjectRequest) (*longrunningpb.Operation, error)
	// Move a project to another place in your resource hierarchy, under a new
	// resource parent.
	//
	// Returns an operation which can be used to track the process of the project
	// move workflow.
	// Upon success, the `Operation.response` field will be populated with the
	// moved project.
	//
	// The caller must have `resourcemanager.projects.move` permission on the
	// project, on the project's current and proposed new parent.
	//
	// If project has no current parent, or it currently does not have an
	// associated organization resource, you will also need the
	// `resourcemanager.projects.setIamPolicy` permission in the project.
	MoveProject(context.Context, *MoveProjectRequest) (*longrunningpb.Operation, error)
	// Marks the project identified by the specified
	// `name` (for example, `projects/415104041262`) for deletion.
	//
	// This method will only affect the project if it has a lifecycle state of
	// [ACTIVE][google.cloud.resourcemanager.v3.Project.State.ACTIVE].
	//
	// This method changes the Project's lifecycle state from
	// [ACTIVE][google.cloud.resourcemanager.v3.Project.State.ACTIVE]
	// to
	// [DELETE_REQUESTED][google.cloud.resourcemanager.v3.Project.State.DELETE_REQUESTED].
	// The deletion starts at an unspecified time,
	// at which point the Project is no longer accessible.
	//
	// Until the deletion completes, you can check the lifecycle state
	// checked by retrieving the project with [GetProject]
	// [google.cloud.resourcemanager.v3.Projects.GetProject],
	// and the project remains visible to [ListProjects]
	// [google.cloud.resourcemanager.v3.Projects.ListProjects].
	// However, you cannot update the project.
	//
	// After the deletion completes, the project is not retrievable by
	// the  [GetProject]
	// [google.cloud.resourcemanager.v3.Projects.GetProject],
	// [ListProjects]
	// [google.cloud.resourcemanager.v3.Projects.ListProjects], and
	// [SearchProjects][google.cloud.resourcemanager.v3.Projects.SearchProjects]
	// methods.
	//
	// This method behaves idempotently, such that deleting a `DELETE_REQUESTED`
	// project will not cause an error, but also won't do anything.
	//
	// The caller must have `resourcemanager.projects.delete` permissions for this
	// project.
	DeleteProject(context.Context, *DeleteProjectRequest) (*longrunningpb.Operation, error)
	// Restores the project identified by the specified
	// `name` (for example, `projects/415104041262`).
	// You can only use this method for a project that has a lifecycle state of
	// [DELETE_REQUESTED]
	// [Projects.State.DELETE_REQUESTED].
	// After deletion starts, the project cannot be restored.
	//
	// The caller must have `resourcemanager.projects.undelete` permission for
	// this project.
	UndeleteProject(context.Context, *UndeleteProjectRequest) (*longrunningpb.Operation, error)
	// Returns the IAM access control policy for the specified project, in the
	// format `projects/{ProjectIdOrNumber}` e.g. projects/123.
	// Permission is denied if the policy or the resource do not exist.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the IAM access control policy for the specified project, in the
	// format `projects/{ProjectIdOrNumber}` e.g. projects/123.
	//
	// CAUTION: This method will replace the existing policy, and cannot be used
	// to append additional IAM settings.
	//
	// Note: Removing service accounts from policies or changing their roles can
	// render services completely inoperable. It is important to understand how
	// the service account is being used before removing or updating its roles.
	//
	// The following constraints apply when using `setIamPolicy()`:
	//
	// + Project does not support `allUsers` and `allAuthenticatedUsers` as
	// `members` in a `Binding` of a `Policy`.
	//
	// + The owner role can be granted to a `user`, `serviceAccount`, or a group
	// that is part of an organization. For example,
	// group@myownpersonaldomain.com could be added as an owner to a project in
	// the myownpersonaldomain.com organization, but not the examplepetstore.com
	// organization.
	//
	// + Service accounts can be made owners of a project directly
	// without any restrictions. However, to be added as an owner, a user must be
	// invited using the Cloud Platform console and must accept the invitation.
	//
	// + A user cannot be granted the owner role using `setIamPolicy()`. The user
	// must be granted the owner role using the Cloud Platform Console and must
	// explicitly accept the invitation.
	//
	// + Invitations to grant the owner role cannot be sent using
	// `setIamPolicy()`;
	// they must be sent only using the Cloud Platform Console.
	//
	// + If the project is not part of an organization, there must be at least
	// one owner who has accepted the Terms of Service (ToS) agreement in the
	// policy. Calling `setIamPolicy()` to remove the last ToS-accepted owner
	// from the policy will fail. This restriction also applies to legacy
	// projects that no longer have owners who have accepted the ToS. Edits to
	// IAM policies will be rejected until the lack of a ToS-accepting owner is
	// rectified. If the project is part of an organization, you can remove all
	// owners, potentially making the organization inaccessible.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns permissions that a caller has on the specified project, in the
	// format `projects/{ProjectIdOrNumber}` e.g. projects/123..
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedProjectsServer should be embedded to have forward compatible implementations.
type UnimplementedProjectsServer struct {
}

func (UnimplementedProjectsServer) GetProject(context.Context, *GetProjectRequest) (*Project, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProject not implemented")
}
func (UnimplementedProjectsServer) ListProjects(context.Context, *ListProjectsRequest) (*ListProjectsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProjects not implemented")
}
func (UnimplementedProjectsServer) SearchProjects(context.Context, *SearchProjectsRequest) (*SearchProjectsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchProjects not implemented")
}
func (UnimplementedProjectsServer) CreateProject(context.Context, *CreateProjectRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProject not implemented")
}
func (UnimplementedProjectsServer) UpdateProject(context.Context, *UpdateProjectRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProject not implemented")
}
func (UnimplementedProjectsServer) MoveProject(context.Context, *MoveProjectRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MoveProject not implemented")
}
func (UnimplementedProjectsServer) DeleteProject(context.Context, *DeleteProjectRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProject not implemented")
}
func (UnimplementedProjectsServer) UndeleteProject(context.Context, *UndeleteProjectRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeleteProject not implemented")
}
func (UnimplementedProjectsServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedProjectsServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedProjectsServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeProjectsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ProjectsServer will
// result in compilation errors.
type UnsafeProjectsServer interface {
	mustEmbedUnimplementedProjectsServer()
}

func RegisterProjectsServer(s grpc.ServiceRegistrar, srv ProjectsServer) {
	s.RegisterService(&Projects_ServiceDesc, srv)
}

func _Projects_GetProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectsServer).GetProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Projects_GetProject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectsServer).GetProject(ctx, req.(*GetProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Projects_ListProjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectsServer).ListProjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Projects_ListProjects_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectsServer).ListProjects(ctx, req.(*ListProjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Projects_SearchProjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchProjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectsServer).SearchProjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Projects_SearchProjects_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectsServer).SearchProjects(ctx, req.(*SearchProjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Projects_CreateProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectsServer).CreateProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Projects_CreateProject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectsServer).CreateProject(ctx, req.(*CreateProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Projects_UpdateProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectsServer).UpdateProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Projects_UpdateProject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectsServer).UpdateProject(ctx, req.(*UpdateProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Projects_MoveProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectsServer).MoveProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Projects_MoveProject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectsServer).MoveProject(ctx, req.(*MoveProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Projects_DeleteProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectsServer).DeleteProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Projects_DeleteProject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectsServer).DeleteProject(ctx, req.(*DeleteProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Projects_UndeleteProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectsServer).UndeleteProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Projects_UndeleteProject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectsServer).UndeleteProject(ctx, req.(*UndeleteProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Projects_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectsServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Projects_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectsServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Projects_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectsServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Projects_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectsServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Projects_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectsServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Projects_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectsServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Projects_ServiceDesc is the grpc.ServiceDesc for Projects service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Projects_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.resourcemanager.v3.Projects",
	HandlerType: (*ProjectsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetProject",
			Handler:    _Projects_GetProject_Handler,
		},
		{
			MethodName: "ListProjects",
			Handler:    _Projects_ListProjects_Handler,
		},
		{
			MethodName: "SearchProjects",
			Handler:    _Projects_SearchProjects_Handler,
		},
		{
			MethodName: "CreateProject",
			Handler:    _Projects_CreateProject_Handler,
		},
		{
			MethodName: "UpdateProject",
			Handler:    _Projects_UpdateProject_Handler,
		},
		{
			MethodName: "MoveProject",
			Handler:    _Projects_MoveProject_Handler,
		},
		{
			MethodName: "DeleteProject",
			Handler:    _Projects_DeleteProject_Handler,
		},
		{
			MethodName: "UndeleteProject",
			Handler:    _Projects_UndeleteProject_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _Projects_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _Projects_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _Projects_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/resourcemanager/v3/projects.proto",
}
