// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/retail/v2alpha/conversational_search_service.proto

package retailpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ConversationalSearchService_ConversationalSearch_FullMethodName = "/google.cloud.retail.v2alpha.ConversationalSearchService/ConversationalSearch"
)

// ConversationalSearchServiceClient is the client API for ConversationalSearchService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ConversationalSearchServiceClient interface {
	// Performs a conversational search.
	//
	// This feature is only available for users who have Conversational Search
	// enabled.
	ConversationalSearch(ctx context.Context, in *ConversationalSearchRequest, opts ...grpc.CallOption) (ConversationalSearchService_ConversationalSearchClient, error)
}

type conversationalSearchServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewConversationalSearchServiceClient(cc grpc.ClientConnInterface) ConversationalSearchServiceClient {
	return &conversationalSearchServiceClient{cc}
}

func (c *conversationalSearchServiceClient) ConversationalSearch(ctx context.Context, in *ConversationalSearchRequest, opts ...grpc.CallOption) (ConversationalSearchService_ConversationalSearchClient, error) {
	stream, err := c.cc.NewStream(ctx, &ConversationalSearchService_ServiceDesc.Streams[0], ConversationalSearchService_ConversationalSearch_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &conversationalSearchServiceConversationalSearchClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ConversationalSearchService_ConversationalSearchClient interface {
	Recv() (*ConversationalSearchResponse, error)
	grpc.ClientStream
}

type conversationalSearchServiceConversationalSearchClient struct {
	grpc.ClientStream
}

func (x *conversationalSearchServiceConversationalSearchClient) Recv() (*ConversationalSearchResponse, error) {
	m := new(ConversationalSearchResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ConversationalSearchServiceServer is the server API for ConversationalSearchService service.
// All implementations should embed UnimplementedConversationalSearchServiceServer
// for forward compatibility
type ConversationalSearchServiceServer interface {
	// Performs a conversational search.
	//
	// This feature is only available for users who have Conversational Search
	// enabled.
	ConversationalSearch(*ConversationalSearchRequest, ConversationalSearchService_ConversationalSearchServer) error
}

// UnimplementedConversationalSearchServiceServer should be embedded to have forward compatible implementations.
type UnimplementedConversationalSearchServiceServer struct {
}

func (UnimplementedConversationalSearchServiceServer) ConversationalSearch(*ConversationalSearchRequest, ConversationalSearchService_ConversationalSearchServer) error {
	return status.Errorf(codes.Unimplemented, "method ConversationalSearch not implemented")
}

// UnsafeConversationalSearchServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ConversationalSearchServiceServer will
// result in compilation errors.
type UnsafeConversationalSearchServiceServer interface {
	mustEmbedUnimplementedConversationalSearchServiceServer()
}

func RegisterConversationalSearchServiceServer(s grpc.ServiceRegistrar, srv ConversationalSearchServiceServer) {
	s.RegisterService(&ConversationalSearchService_ServiceDesc, srv)
}

func _ConversationalSearchService_ConversationalSearch_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ConversationalSearchRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ConversationalSearchServiceServer).ConversationalSearch(m, &conversationalSearchServiceConversationalSearchServer{stream})
}

type ConversationalSearchService_ConversationalSearchServer interface {
	Send(*ConversationalSearchResponse) error
	grpc.ServerStream
}

type conversationalSearchServiceConversationalSearchServer struct {
	grpc.ServerStream
}

func (x *conversationalSearchServiceConversationalSearchServer) Send(m *ConversationalSearchResponse) error {
	return x.ServerStream.SendMsg(m)
}

// ConversationalSearchService_ServiceDesc is the grpc.ServiceDesc for ConversationalSearchService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ConversationalSearchService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.retail.v2alpha.ConversationalSearchService",
	HandlerType: (*ConversationalSearchServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ConversationalSearch",
			Handler:       _ConversationalSearchService_ConversationalSearch_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/retail/v2alpha/conversational_search_service.proto",
}
