// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/run/v2/revision.proto

package runpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Revisions_GetRevision_FullMethodName    = "/google.cloud.run.v2.Revisions/GetRevision"
	Revisions_ListRevisions_FullMethodName  = "/google.cloud.run.v2.Revisions/ListRevisions"
	Revisions_DeleteRevision_FullMethodName = "/google.cloud.run.v2.Revisions/DeleteRevision"
)

// RevisionsClient is the client API for Revisions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type RevisionsClient interface {
	// Gets information about a Revision.
	GetRevision(ctx context.Context, in *GetRevisionRequest, opts ...grpc.CallOption) (*Revision, error)
	// Lists Revisions from a given Service, or from a given location.  Results
	// are sorted by creation time, descending.
	ListRevisions(ctx context.Context, in *ListRevisionsRequest, opts ...grpc.CallOption) (*ListRevisionsResponse, error)
	// Deletes a Revision.
	DeleteRevision(ctx context.Context, in *DeleteRevisionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type revisionsClient struct {
	cc grpc.ClientConnInterface
}

func NewRevisionsClient(cc grpc.ClientConnInterface) RevisionsClient {
	return &revisionsClient{cc}
}

func (c *revisionsClient) GetRevision(ctx context.Context, in *GetRevisionRequest, opts ...grpc.CallOption) (*Revision, error) {
	out := new(Revision)
	err := c.cc.Invoke(ctx, Revisions_GetRevision_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *revisionsClient) ListRevisions(ctx context.Context, in *ListRevisionsRequest, opts ...grpc.CallOption) (*ListRevisionsResponse, error) {
	out := new(ListRevisionsResponse)
	err := c.cc.Invoke(ctx, Revisions_ListRevisions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *revisionsClient) DeleteRevision(ctx context.Context, in *DeleteRevisionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Revisions_DeleteRevision_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RevisionsServer is the server API for Revisions service.
// All implementations should embed UnimplementedRevisionsServer
// for forward compatibility
type RevisionsServer interface {
	// Gets information about a Revision.
	GetRevision(context.Context, *GetRevisionRequest) (*Revision, error)
	// Lists Revisions from a given Service, or from a given location.  Results
	// are sorted by creation time, descending.
	ListRevisions(context.Context, *ListRevisionsRequest) (*ListRevisionsResponse, error)
	// Deletes a Revision.
	DeleteRevision(context.Context, *DeleteRevisionRequest) (*longrunningpb.Operation, error)
}

// UnimplementedRevisionsServer should be embedded to have forward compatible implementations.
type UnimplementedRevisionsServer struct {
}

func (UnimplementedRevisionsServer) GetRevision(context.Context, *GetRevisionRequest) (*Revision, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRevision not implemented")
}
func (UnimplementedRevisionsServer) ListRevisions(context.Context, *ListRevisionsRequest) (*ListRevisionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRevisions not implemented")
}
func (UnimplementedRevisionsServer) DeleteRevision(context.Context, *DeleteRevisionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRevision not implemented")
}

// UnsafeRevisionsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RevisionsServer will
// result in compilation errors.
type UnsafeRevisionsServer interface {
	mustEmbedUnimplementedRevisionsServer()
}

func RegisterRevisionsServer(s grpc.ServiceRegistrar, srv RevisionsServer) {
	s.RegisterService(&Revisions_ServiceDesc, srv)
}

func _Revisions_GetRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RevisionsServer).GetRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Revisions_GetRevision_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RevisionsServer).GetRevision(ctx, req.(*GetRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Revisions_ListRevisions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRevisionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RevisionsServer).ListRevisions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Revisions_ListRevisions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RevisionsServer).ListRevisions(ctx, req.(*ListRevisionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Revisions_DeleteRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RevisionsServer).DeleteRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Revisions_DeleteRevision_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RevisionsServer).DeleteRevision(ctx, req.(*DeleteRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Revisions_ServiceDesc is the grpc.ServiceDesc for Revisions service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Revisions_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.run.v2.Revisions",
	HandlerType: (*RevisionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRevision",
			Handler:    _Revisions_GetRevision_Handler,
		},
		{
			MethodName: "ListRevisions",
			Handler:    _Revisions_ListRevisions_Handler,
		},
		{
			MethodName: "DeleteRevision",
			Handler:    _Revisions_DeleteRevision_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/run/v2/revision.proto",
}
