// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/security/publicca/v1/service.proto

package publiccapb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	PublicCertificateAuthorityService_CreateExternalAccountKey_FullMethodName = "/google.cloud.security.publicca.v1.PublicCertificateAuthorityService/CreateExternalAccountKey"
)

// PublicCertificateAuthorityServiceClient is the client API for PublicCertificateAuthorityService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PublicCertificateAuthorityServiceClient interface {
	// Creates a new
	// [ExternalAccountKey][google.cloud.security.publicca.v1.ExternalAccountKey]
	// bound to the project.
	CreateExternalAccountKey(ctx context.Context, in *CreateExternalAccountKeyRequest, opts ...grpc.CallOption) (*ExternalAccountKey, error)
}

type publicCertificateAuthorityServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPublicCertificateAuthorityServiceClient(cc grpc.ClientConnInterface) PublicCertificateAuthorityServiceClient {
	return &publicCertificateAuthorityServiceClient{cc}
}

func (c *publicCertificateAuthorityServiceClient) CreateExternalAccountKey(ctx context.Context, in *CreateExternalAccountKeyRequest, opts ...grpc.CallOption) (*ExternalAccountKey, error) {
	out := new(ExternalAccountKey)
	err := c.cc.Invoke(ctx, PublicCertificateAuthorityService_CreateExternalAccountKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PublicCertificateAuthorityServiceServer is the server API for PublicCertificateAuthorityService service.
// All implementations should embed UnimplementedPublicCertificateAuthorityServiceServer
// for forward compatibility
type PublicCertificateAuthorityServiceServer interface {
	// Creates a new
	// [ExternalAccountKey][google.cloud.security.publicca.v1.ExternalAccountKey]
	// bound to the project.
	CreateExternalAccountKey(context.Context, *CreateExternalAccountKeyRequest) (*ExternalAccountKey, error)
}

// UnimplementedPublicCertificateAuthorityServiceServer should be embedded to have forward compatible implementations.
type UnimplementedPublicCertificateAuthorityServiceServer struct {
}

func (UnimplementedPublicCertificateAuthorityServiceServer) CreateExternalAccountKey(context.Context, *CreateExternalAccountKeyRequest) (*ExternalAccountKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExternalAccountKey not implemented")
}

// UnsafePublicCertificateAuthorityServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PublicCertificateAuthorityServiceServer will
// result in compilation errors.
type UnsafePublicCertificateAuthorityServiceServer interface {
	mustEmbedUnimplementedPublicCertificateAuthorityServiceServer()
}

func RegisterPublicCertificateAuthorityServiceServer(s grpc.ServiceRegistrar, srv PublicCertificateAuthorityServiceServer) {
	s.RegisterService(&PublicCertificateAuthorityService_ServiceDesc, srv)
}

func _PublicCertificateAuthorityService_CreateExternalAccountKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateExternalAccountKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublicCertificateAuthorityServiceServer).CreateExternalAccountKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PublicCertificateAuthorityService_CreateExternalAccountKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublicCertificateAuthorityServiceServer).CreateExternalAccountKey(ctx, req.(*CreateExternalAccountKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PublicCertificateAuthorityService_ServiceDesc is the grpc.ServiceDesc for PublicCertificateAuthorityService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PublicCertificateAuthorityService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.security.publicca.v1.PublicCertificateAuthorityService",
	HandlerType: (*PublicCertificateAuthorityServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateExternalAccountKey",
			Handler:    _PublicCertificateAuthorityService_CreateExternalAccountKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/security/publicca/v1/service.proto",
}
