// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/shell/v1/cloudshell.proto

package shellpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible execution states for an environment.
type Environment_State int32

const (
	// The environment's states is unknown.
	Environment_STATE_UNSPECIFIED Environment_State = 0
	// The environment is not running and can't be connected to. Starting the
	// environment will transition it to the PENDING state.
	Environment_SUSPENDED Environment_State = 1
	// The environment is being started but is not yet ready to accept
	// connections.
	Environment_PENDING Environment_State = 2
	// The environment is running and ready to accept connections. It will
	// automatically transition back to DISABLED after a period of inactivity or
	// if another environment is started.
	Environment_RUNNING Environment_State = 3
	// The environment is being deleted and can't be connected to.
	Environment_DELETING Environment_State = 4
)

// Enum value maps for Environment_State.
var (
	Environment_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SUSPENDED",
		2: "PENDING",
		3: "RUNNING",
		4: "DELETING",
	}
	Environment_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SUSPENDED":         1,
		"PENDING":           2,
		"RUNNING":           3,
		"DELETING":          4,
	}
)

func (x Environment_State) Enum() *Environment_State {
	p := new(Environment_State)
	*p = x
	return p
}

func (x Environment_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Environment_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_shell_v1_cloudshell_proto_enumTypes[0].Descriptor()
}

func (Environment_State) Type() protoreflect.EnumType {
	return &file_google_cloud_shell_v1_cloudshell_proto_enumTypes[0]
}

func (x Environment_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Environment_State.Descriptor instead.
func (Environment_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{0, 0}
}

// Possible states an environment might transition between during startup.
// These states are not normally actionable by clients, but may be used to
// show a progress message to the user. An environment won't necessarily go
// through all of these states when starting. More states are likely to be
// added in the future.
type StartEnvironmentMetadata_State int32

const (
	// The environment's start state is unknown.
	StartEnvironmentMetadata_STATE_UNSPECIFIED StartEnvironmentMetadata_State = 0
	// The environment is in the process of being started, but no additional
	// details are available.
	StartEnvironmentMetadata_STARTING StartEnvironmentMetadata_State = 1
	// Startup is waiting for the user's disk to be unarchived. This can happen
	// when the user returns to Cloud Shell after not having used it for a
	// while, and suggests that startup will take longer than normal.
	StartEnvironmentMetadata_UNARCHIVING_DISK StartEnvironmentMetadata_State = 2
	// Startup is waiting for compute resources to be assigned to the
	// environment. This should normally happen very quickly, but an environment
	// might stay in this state for an extended period of time if the system is
	// experiencing heavy load.
	StartEnvironmentMetadata_AWAITING_COMPUTE_RESOURCES StartEnvironmentMetadata_State = 4
	// Startup has completed. If the start operation was successful, the user
	// should be able to establish an SSH connection to their environment.
	// Otherwise, the operation will contain details of the failure.
	StartEnvironmentMetadata_FINISHED StartEnvironmentMetadata_State = 3
)

// Enum value maps for StartEnvironmentMetadata_State.
var (
	StartEnvironmentMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STARTING",
		2: "UNARCHIVING_DISK",
		4: "AWAITING_COMPUTE_RESOURCES",
		3: "FINISHED",
	}
	StartEnvironmentMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED":          0,
		"STARTING":                   1,
		"UNARCHIVING_DISK":           2,
		"AWAITING_COMPUTE_RESOURCES": 4,
		"FINISHED":                   3,
	}
)

func (x StartEnvironmentMetadata_State) Enum() *StartEnvironmentMetadata_State {
	p := new(StartEnvironmentMetadata_State)
	*p = x
	return p
}

func (x StartEnvironmentMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StartEnvironmentMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_shell_v1_cloudshell_proto_enumTypes[1].Descriptor()
}

func (StartEnvironmentMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_shell_v1_cloudshell_proto_enumTypes[1]
}

func (x StartEnvironmentMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StartEnvironmentMetadata_State.Descriptor instead.
func (StartEnvironmentMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{8, 0}
}

// Set of possible errors returned from API calls.
type CloudShellErrorDetails_CloudShellErrorCode int32

const (
	// An unknown error occurred.
	CloudShellErrorDetails_CLOUD_SHELL_ERROR_CODE_UNSPECIFIED CloudShellErrorDetails_CloudShellErrorCode = 0
	// The image used by the Cloud Shell environment either does not exist or
	// the user does not have access to it.
	CloudShellErrorDetails_IMAGE_UNAVAILABLE CloudShellErrorDetails_CloudShellErrorCode = 1
	// Cloud Shell has been disabled by an administrator for the user making the
	// request.
	CloudShellErrorDetails_CLOUD_SHELL_DISABLED CloudShellErrorDetails_CloudShellErrorCode = 2
	// Cloud Shell has been permanently disabled due to a Terms of Service
	// violation by the user.
	CloudShellErrorDetails_TOS_VIOLATION CloudShellErrorDetails_CloudShellErrorCode = 4
	// The user has exhausted their weekly Cloud Shell quota, and Cloud Shell
	// will be disabled until the quota resets.
	CloudShellErrorDetails_QUOTA_EXCEEDED CloudShellErrorDetails_CloudShellErrorCode = 5
	// The Cloud Shell environment is unavailable and cannot be connected to at
	// the moment.
	CloudShellErrorDetails_ENVIRONMENT_UNAVAILABLE CloudShellErrorDetails_CloudShellErrorCode = 6
)

// Enum value maps for CloudShellErrorDetails_CloudShellErrorCode.
var (
	CloudShellErrorDetails_CloudShellErrorCode_name = map[int32]string{
		0: "CLOUD_SHELL_ERROR_CODE_UNSPECIFIED",
		1: "IMAGE_UNAVAILABLE",
		2: "CLOUD_SHELL_DISABLED",
		4: "TOS_VIOLATION",
		5: "QUOTA_EXCEEDED",
		6: "ENVIRONMENT_UNAVAILABLE",
	}
	CloudShellErrorDetails_CloudShellErrorCode_value = map[string]int32{
		"CLOUD_SHELL_ERROR_CODE_UNSPECIFIED": 0,
		"IMAGE_UNAVAILABLE":                  1,
		"CLOUD_SHELL_DISABLED":               2,
		"TOS_VIOLATION":                      4,
		"QUOTA_EXCEEDED":                     5,
		"ENVIRONMENT_UNAVAILABLE":            6,
	}
)

func (x CloudShellErrorDetails_CloudShellErrorCode) Enum() *CloudShellErrorDetails_CloudShellErrorCode {
	p := new(CloudShellErrorDetails_CloudShellErrorCode)
	*p = x
	return p
}

func (x CloudShellErrorDetails_CloudShellErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudShellErrorDetails_CloudShellErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_shell_v1_cloudshell_proto_enumTypes[2].Descriptor()
}

func (CloudShellErrorDetails_CloudShellErrorCode) Type() protoreflect.EnumType {
	return &file_google_cloud_shell_v1_cloudshell_proto_enumTypes[2]
}

func (x CloudShellErrorDetails_CloudShellErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudShellErrorDetails_CloudShellErrorCode.Descriptor instead.
func (CloudShellErrorDetails_CloudShellErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{16, 0}
}

// A Cloud Shell environment, which is defined as the combination of a Docker
// image specifying what is installed on the environment and a home directory
// containing the user's data that will remain across sessions. Each user has
// at least an environment with the ID "default".
type Environment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Full name of this resource, in the format
	// `users/{owner_email}/environments/{environment_id}`. `{owner_email}` is the
	// email address of the user to whom this environment belongs, and
	// `{environment_id}` is the identifier of this environment. For example,
	// `users/someone@example.com/environments/default`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The environment's identifier, unique among the user's
	// environments.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Required. Immutable. Full path to the Docker image used to run this environment, e.g.
	// "gcr.io/dev-con/cloud-devshell:latest".
	DockerImage string `protobuf:"bytes,3,opt,name=docker_image,json=dockerImage,proto3" json:"docker_image,omitempty"`
	// Output only. Current execution state of this environment.
	State Environment_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.shell.v1.Environment_State" json:"state,omitempty"`
	// Output only. Host to which clients can connect to initiate HTTPS or WSS
	// connections with the environment.
	WebHost string `protobuf:"bytes,12,opt,name=web_host,json=webHost,proto3" json:"web_host,omitempty"`
	// Output only. Username that clients should use when initiating SSH sessions
	// with the environment.
	SshUsername string `protobuf:"bytes,5,opt,name=ssh_username,json=sshUsername,proto3" json:"ssh_username,omitempty"`
	// Output only. Host to which clients can connect to initiate SSH sessions
	// with the environment.
	SshHost string `protobuf:"bytes,6,opt,name=ssh_host,json=sshHost,proto3" json:"ssh_host,omitempty"`
	// Output only. Port to which clients can connect to initiate SSH sessions
	// with the environment.
	SshPort int32 `protobuf:"varint,7,opt,name=ssh_port,json=sshPort,proto3" json:"ssh_port,omitempty"`
	// Output only. Public keys associated with the environment. Clients can
	// connect to this environment via SSH only if they possess a private key
	// corresponding to at least one of these public keys. Keys can be added to or
	// removed from the environment using the AddPublicKey and RemovePublicKey
	// methods.
	PublicKeys []string `protobuf:"bytes,8,rep,name=public_keys,json=publicKeys,proto3" json:"public_keys,omitempty"`
}

func (x *Environment) Reset() {
	*x = Environment{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Environment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Environment) ProtoMessage() {}

func (x *Environment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Environment.ProtoReflect.Descriptor instead.
func (*Environment) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{0}
}

func (x *Environment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Environment) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Environment) GetDockerImage() string {
	if x != nil {
		return x.DockerImage
	}
	return ""
}

func (x *Environment) GetState() Environment_State {
	if x != nil {
		return x.State
	}
	return Environment_STATE_UNSPECIFIED
}

func (x *Environment) GetWebHost() string {
	if x != nil {
		return x.WebHost
	}
	return ""
}

func (x *Environment) GetSshUsername() string {
	if x != nil {
		return x.SshUsername
	}
	return ""
}

func (x *Environment) GetSshHost() string {
	if x != nil {
		return x.SshHost
	}
	return ""
}

func (x *Environment) GetSshPort() int32 {
	if x != nil {
		return x.SshPort
	}
	return 0
}

func (x *Environment) GetPublicKeys() []string {
	if x != nil {
		return x.PublicKeys
	}
	return nil
}

// Request message for
// [GetEnvironment][google.cloud.shell.v1.CloudShellService.GetEnvironment].
type GetEnvironmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the requested resource, for example `users/me/environments/default`
	// or `users/someone@example.com/environments/default`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEnvironmentRequest) Reset() {
	*x = GetEnvironmentRequest{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEnvironmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEnvironmentRequest) ProtoMessage() {}

func (x *GetEnvironmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEnvironmentRequest.ProtoReflect.Descriptor instead.
func (*GetEnvironmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{1}
}

func (x *GetEnvironmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message included in the metadata field of operations returned from
// [CreateEnvironment][google.cloud.shell.v1.CloudShellService.CreateEnvironment].
type CreateEnvironmentMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreateEnvironmentMetadata) Reset() {
	*x = CreateEnvironmentMetadata{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateEnvironmentMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEnvironmentMetadata) ProtoMessage() {}

func (x *CreateEnvironmentMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEnvironmentMetadata.ProtoReflect.Descriptor instead.
func (*CreateEnvironmentMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{2}
}

// Message included in the metadata field of operations returned from
// [DeleteEnvironment][google.cloud.shell.v1.CloudShellService.DeleteEnvironment].
type DeleteEnvironmentMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteEnvironmentMetadata) Reset() {
	*x = DeleteEnvironmentMetadata{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteEnvironmentMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEnvironmentMetadata) ProtoMessage() {}

func (x *DeleteEnvironmentMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEnvironmentMetadata.ProtoReflect.Descriptor instead.
func (*DeleteEnvironmentMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{3}
}

// Request message for
// [StartEnvironment][google.cloud.shell.v1.CloudShellService.StartEnvironment].
type StartEnvironmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the resource that should be started, for example
	// `users/me/environments/default` or
	// `users/someone@example.com/environments/default`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The initial access token passed to the environment. If this is present and
	// valid, the environment will be pre-authenticated with gcloud so that the
	// user can run gcloud commands in Cloud Shell without having to log in. This
	// code can be updated later by calling AuthorizeEnvironment.
	AccessToken string `protobuf:"bytes,2,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	// Public keys that should be added to the environment before it is started.
	PublicKeys []string `protobuf:"bytes,3,rep,name=public_keys,json=publicKeys,proto3" json:"public_keys,omitempty"`
}

func (x *StartEnvironmentRequest) Reset() {
	*x = StartEnvironmentRequest{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartEnvironmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartEnvironmentRequest) ProtoMessage() {}

func (x *StartEnvironmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartEnvironmentRequest.ProtoReflect.Descriptor instead.
func (*StartEnvironmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{4}
}

func (x *StartEnvironmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StartEnvironmentRequest) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

func (x *StartEnvironmentRequest) GetPublicKeys() []string {
	if x != nil {
		return x.PublicKeys
	}
	return nil
}

// Request message for
// [AuthorizeEnvironment][google.cloud.shell.v1.CloudShellService.AuthorizeEnvironment].
type AuthorizeEnvironmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the resource that should receive the credentials, for example
	// `users/me/environments/default` or
	// `users/someone@example.com/environments/default`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The OAuth access token that should be sent to the environment.
	AccessToken string `protobuf:"bytes,2,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	// The OAuth ID token that should be sent to the environment.
	IdToken string `protobuf:"bytes,4,opt,name=id_token,json=idToken,proto3" json:"id_token,omitempty"`
	// The time when the credentials expire. If not set, defaults to one hour from
	// when the server received the request.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
}

func (x *AuthorizeEnvironmentRequest) Reset() {
	*x = AuthorizeEnvironmentRequest{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AuthorizeEnvironmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizeEnvironmentRequest) ProtoMessage() {}

func (x *AuthorizeEnvironmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizeEnvironmentRequest.ProtoReflect.Descriptor instead.
func (*AuthorizeEnvironmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{5}
}

func (x *AuthorizeEnvironmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AuthorizeEnvironmentRequest) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

func (x *AuthorizeEnvironmentRequest) GetIdToken() string {
	if x != nil {
		return x.IdToken
	}
	return ""
}

func (x *AuthorizeEnvironmentRequest) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

// Response message for
// [AuthorizeEnvironment][google.cloud.shell.v1.CloudShellService.AuthorizeEnvironment].
type AuthorizeEnvironmentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AuthorizeEnvironmentResponse) Reset() {
	*x = AuthorizeEnvironmentResponse{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AuthorizeEnvironmentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizeEnvironmentResponse) ProtoMessage() {}

func (x *AuthorizeEnvironmentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizeEnvironmentResponse.ProtoReflect.Descriptor instead.
func (*AuthorizeEnvironmentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{6}
}

// Message included in the metadata field of operations returned from
// [AuthorizeEnvironment][google.cloud.shell.v1.CloudShellService.AuthorizeEnvironment].
type AuthorizeEnvironmentMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AuthorizeEnvironmentMetadata) Reset() {
	*x = AuthorizeEnvironmentMetadata{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AuthorizeEnvironmentMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizeEnvironmentMetadata) ProtoMessage() {}

func (x *AuthorizeEnvironmentMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizeEnvironmentMetadata.ProtoReflect.Descriptor instead.
func (*AuthorizeEnvironmentMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{7}
}

// Message included in the metadata field of operations returned from
// [StartEnvironment][google.cloud.shell.v1.CloudShellService.StartEnvironment].
type StartEnvironmentMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Current state of the environment being started.
	State StartEnvironmentMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.shell.v1.StartEnvironmentMetadata_State" json:"state,omitempty"`
}

func (x *StartEnvironmentMetadata) Reset() {
	*x = StartEnvironmentMetadata{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartEnvironmentMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartEnvironmentMetadata) ProtoMessage() {}

func (x *StartEnvironmentMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartEnvironmentMetadata.ProtoReflect.Descriptor instead.
func (*StartEnvironmentMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{8}
}

func (x *StartEnvironmentMetadata) GetState() StartEnvironmentMetadata_State {
	if x != nil {
		return x.State
	}
	return StartEnvironmentMetadata_STATE_UNSPECIFIED
}

// Message included in the response field of operations returned from
// [StartEnvironment][google.cloud.shell.v1.CloudShellService.StartEnvironment]
// once the operation is complete.
type StartEnvironmentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Environment that was started.
	Environment *Environment `protobuf:"bytes,1,opt,name=environment,proto3" json:"environment,omitempty"`
}

func (x *StartEnvironmentResponse) Reset() {
	*x = StartEnvironmentResponse{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartEnvironmentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartEnvironmentResponse) ProtoMessage() {}

func (x *StartEnvironmentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartEnvironmentResponse.ProtoReflect.Descriptor instead.
func (*StartEnvironmentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{9}
}

func (x *StartEnvironmentResponse) GetEnvironment() *Environment {
	if x != nil {
		return x.Environment
	}
	return nil
}

// Request message for
// [AddPublicKey][google.cloud.shell.v1.CloudShellService.AddPublicKey].
type AddPublicKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Environment this key should be added to, e.g.
	// `users/me/environments/default`.
	Environment string `protobuf:"bytes,1,opt,name=environment,proto3" json:"environment,omitempty"`
	// Key that should be added to the environment. Supported formats are
	// `ssh-dss` (see RFC4253), `ssh-rsa` (see RFC4253), `ecdsa-sha2-nistp256`
	// (see RFC5656), `ecdsa-sha2-nistp384` (see RFC5656) and
	// `ecdsa-sha2-nistp521` (see RFC5656). It should be structured as
	// &lt;format&gt; &lt;content&gt;, where &lt;content&gt; part is encoded with
	// Base64.
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *AddPublicKeyRequest) Reset() {
	*x = AddPublicKeyRequest{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddPublicKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddPublicKeyRequest) ProtoMessage() {}

func (x *AddPublicKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddPublicKeyRequest.ProtoReflect.Descriptor instead.
func (*AddPublicKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{10}
}

func (x *AddPublicKeyRequest) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

func (x *AddPublicKeyRequest) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

// Response message for
// [AddPublicKey][google.cloud.shell.v1.CloudShellService.AddPublicKey].
type AddPublicKeyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key that was added to the environment.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *AddPublicKeyResponse) Reset() {
	*x = AddPublicKeyResponse{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddPublicKeyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddPublicKeyResponse) ProtoMessage() {}

func (x *AddPublicKeyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddPublicKeyResponse.ProtoReflect.Descriptor instead.
func (*AddPublicKeyResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{11}
}

func (x *AddPublicKeyResponse) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

// Message included in the metadata field of operations returned from
// [AddPublicKey][google.cloud.shell.v1.CloudShellService.AddPublicKey].
type AddPublicKeyMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AddPublicKeyMetadata) Reset() {
	*x = AddPublicKeyMetadata{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddPublicKeyMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddPublicKeyMetadata) ProtoMessage() {}

func (x *AddPublicKeyMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddPublicKeyMetadata.ProtoReflect.Descriptor instead.
func (*AddPublicKeyMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{12}
}

// Request message for
// [RemovePublicKey][google.cloud.shell.v1.CloudShellService.RemovePublicKey].
type RemovePublicKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Environment this key should be removed from, e.g.
	// `users/me/environments/default`.
	Environment string `protobuf:"bytes,1,opt,name=environment,proto3" json:"environment,omitempty"`
	// Key that should be removed from the environment.
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *RemovePublicKeyRequest) Reset() {
	*x = RemovePublicKeyRequest{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemovePublicKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemovePublicKeyRequest) ProtoMessage() {}

func (x *RemovePublicKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemovePublicKeyRequest.ProtoReflect.Descriptor instead.
func (*RemovePublicKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{13}
}

func (x *RemovePublicKeyRequest) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

func (x *RemovePublicKeyRequest) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

// Response message for
// [RemovePublicKey][google.cloud.shell.v1.CloudShellService.RemovePublicKey].
type RemovePublicKeyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemovePublicKeyResponse) Reset() {
	*x = RemovePublicKeyResponse{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemovePublicKeyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemovePublicKeyResponse) ProtoMessage() {}

func (x *RemovePublicKeyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemovePublicKeyResponse.ProtoReflect.Descriptor instead.
func (*RemovePublicKeyResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{14}
}

// Message included in the metadata field of operations returned from
// [RemovePublicKey][google.cloud.shell.v1.CloudShellService.RemovePublicKey].
type RemovePublicKeyMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemovePublicKeyMetadata) Reset() {
	*x = RemovePublicKeyMetadata{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemovePublicKeyMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemovePublicKeyMetadata) ProtoMessage() {}

func (x *RemovePublicKeyMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemovePublicKeyMetadata.ProtoReflect.Descriptor instead.
func (*RemovePublicKeyMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{15}
}

// Cloud-shell specific information that will be included as details in failure
// responses.
type CloudShellErrorDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Code indicating the specific error the occurred.
	Code CloudShellErrorDetails_CloudShellErrorCode `protobuf:"varint,1,opt,name=code,proto3,enum=google.cloud.shell.v1.CloudShellErrorDetails_CloudShellErrorCode" json:"code,omitempty"`
}

func (x *CloudShellErrorDetails) Reset() {
	*x = CloudShellErrorDetails{}
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudShellErrorDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudShellErrorDetails) ProtoMessage() {}

func (x *CloudShellErrorDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_shell_v1_cloudshell_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudShellErrorDetails.ProtoReflect.Descriptor instead.
func (*CloudShellErrorDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP(), []int{16}
}

func (x *CloudShellErrorDetails) GetCode() CloudShellErrorDetails_CloudShellErrorCode {
	if x != nil {
		return x.Code
	}
	return CloudShellErrorDetails_CLOUD_SHELL_ERROR_CODE_UNSPECIFIED
}

var File_google_cloud_shell_v1_cloudshell_proto protoreflect.FileDescriptor

var file_google_cloud_shell_v1_cloudshell_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x68, 0x65, 0x6c, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x68, 0x65,
	0x6c, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x68, 0x65, 0x6c, 0x6c, 0x2e, 0x76, 0x31, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x85, 0x04, 0x0a, 0x0b, 0x45, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x29, 0x0a, 0x0c, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72,
	0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41,
	0x02, 0xe0, 0x41, 0x05, 0x52, 0x0b, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x12, 0x43, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x68, 0x65, 0x6c, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x77, 0x65, 0x62, 0x5f, 0x68, 0x6f,
	0x73, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x77,
	0x65, 0x62, 0x48, 0x6f, 0x73, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x73, 0x68, 0x5f, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x73, 0x73, 0x68, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e,
	0x0a, 0x08, 0x73, 0x73, 0x68, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x73, 0x73, 0x68, 0x48, 0x6f, 0x73, 0x74, 0x12, 0x1e,
	0x0a, 0x08, 0x73, 0x73, 0x68, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x73, 0x73, 0x68, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x24,
	0x0a, 0x0b, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x4b, 0x65, 0x79, 0x73, 0x22, 0x55, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a,
	0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x3a, 0x53, 0xea, 0x41, 0x50,
	0x0a, 0x25, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x68, 0x65, 0x6c, 0x6c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x27, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x7b,
	0x75, 0x73, 0x65, 0x72, 0x7d, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x7d,
	0x22, 0x5a, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a,
	0x25, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x68, 0x65, 0x6c, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x1b, 0x0a, 0x19,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x1b, 0x0a, 0x19, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x71, 0x0a, 0x17, 0x53, 0x74, 0x61, 0x72, 0x74, 0x45,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x22, 0xac, 0x01, 0x0a, 0x1b, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x19, 0x0a, 0x08, 0x69, 0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x69, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x65, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x1e, 0x0a, 0x1c, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1e, 0x0a, 0x1c, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xd9, 0x01, 0x0a, 0x18, 0x53, 0x74, 0x61,
	0x72, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x68, 0x65, 0x6c, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61,
	0x72, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x22, 0x70, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x14, 0x0a, 0x10, 0x55, 0x4e, 0x41, 0x52, 0x43, 0x48, 0x49, 0x56, 0x49, 0x4e, 0x47, 0x5f,
	0x44, 0x49, 0x53, 0x4b, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x57, 0x41, 0x49, 0x54, 0x49,
	0x4e, 0x47, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55,
	0x52, 0x43, 0x45, 0x53, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x49, 0x4e, 0x49, 0x53, 0x48,
	0x45, 0x44, 0x10, 0x03, 0x22, 0x60, 0x0a, 0x18, 0x53, 0x74, 0x61, 0x72, 0x74, 0x45, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x44, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x68, 0x65, 0x6c, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x49, 0x0a, 0x13, 0x41, 0x64, 0x64, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a,
	0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x22, 0x28, 0x0a, 0x14, 0x41, 0x64, 0x64, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65,
	0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x16, 0x0a, 0x14, 0x41,
	0x64, 0x64, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x22, 0x4c, 0x0a, 0x16, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a,
	0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x22, 0x19, 0x0a, 0x17, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x19, 0x0a, 0x17,
	0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xa4, 0x02, 0x0a, 0x16, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x53, 0x68, 0x65, 0x6c, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x55, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x68, 0x65, 0x6c, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x68,
	0x65, 0x6c, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x68, 0x65, 0x6c, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43,
	0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x22, 0xb2, 0x01, 0x0a, 0x13, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x53, 0x68, 0x65, 0x6c, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x26, 0x0a, 0x22, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x48, 0x45, 0x4c, 0x4c,
	0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x49, 0x4d, 0x41,
	0x47, 0x45, 0x5f, 0x55, 0x4e, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01,
	0x12, 0x18, 0x0a, 0x14, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x48, 0x45, 0x4c, 0x4c, 0x5f,
	0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x54, 0x4f,
	0x53, 0x5f, 0x56, 0x49, 0x4f, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x12, 0x0a,
	0x0e, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10,
	0x05, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x55, 0x4e, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x06, 0x32, 0xd4,
	0x08, 0x0a, 0x11, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x68, 0x65, 0x6c, 0x6c, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x94, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x68, 0x65, 0x6c, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x68, 0x65, 0x6c, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x30, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x12, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcc, 0x01, 0x0a, 0x10,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x68, 0x65, 0x6c, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x45, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x69, 0xca, 0x41, 0x34, 0x0a, 0x18, 0x53, 0x74, 0x61, 0x72, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x3a, 0x01,
	0x2a, 0x22, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x75, 0x73, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0xe0, 0x01, 0x0a, 0x14, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x68, 0x65, 0x6c, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0xca, 0x41, 0x3c, 0x0a, 0x1c, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1c, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x65, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x3a, 0x01, 0x2a,
	0x22, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x75, 0x73, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x12, 0xca, 0x01,
	0x0a, 0x0c, 0x41, 0x64, 0x64, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x68,
	0x65, 0x6c, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0xca, 0x41, 0x2c, 0x0a, 0x14,
	0x41, 0x64, 0x64, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x41, 0x64, 0x64, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b,
	0x65, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a,
	0x3a, 0x01, 0x2a, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x3d, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x64,
	0x64, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0xd9, 0x01, 0x0a, 0x0f, 0x52,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x68,
	0x65, 0x6c, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x78, 0xca, 0x41,
	0x32, 0x0a, 0x17, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b,
	0x65, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x17, 0x52, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x3d, 0x75,
	0x73, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x73, 0x68, 0x65, 0x6c, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x5f, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x68, 0x65, 0x6c, 0x6c, 0x2e,
	0x76, 0x31, 0x42, 0x0f, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x68, 0x65, 0x6c, 0x6c, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x65, 0x6c, 0x6c,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x68, 0x65, 0x6c, 0x6c, 0x70, 0x62, 0x3b, 0x73,
	0x68, 0x65, 0x6c, 0x6c, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_shell_v1_cloudshell_proto_rawDescOnce sync.Once
	file_google_cloud_shell_v1_cloudshell_proto_rawDescData = file_google_cloud_shell_v1_cloudshell_proto_rawDesc
)

func file_google_cloud_shell_v1_cloudshell_proto_rawDescGZIP() []byte {
	file_google_cloud_shell_v1_cloudshell_proto_rawDescOnce.Do(func() {
		file_google_cloud_shell_v1_cloudshell_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_shell_v1_cloudshell_proto_rawDescData)
	})
	return file_google_cloud_shell_v1_cloudshell_proto_rawDescData
}

var file_google_cloud_shell_v1_cloudshell_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_shell_v1_cloudshell_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_shell_v1_cloudshell_proto_goTypes = []any{
	(Environment_State)(0),                          // 0: google.cloud.shell.v1.Environment.State
	(StartEnvironmentMetadata_State)(0),             // 1: google.cloud.shell.v1.StartEnvironmentMetadata.State
	(CloudShellErrorDetails_CloudShellErrorCode)(0), // 2: google.cloud.shell.v1.CloudShellErrorDetails.CloudShellErrorCode
	(*Environment)(nil),                             // 3: google.cloud.shell.v1.Environment
	(*GetEnvironmentRequest)(nil),                   // 4: google.cloud.shell.v1.GetEnvironmentRequest
	(*CreateEnvironmentMetadata)(nil),               // 5: google.cloud.shell.v1.CreateEnvironmentMetadata
	(*DeleteEnvironmentMetadata)(nil),               // 6: google.cloud.shell.v1.DeleteEnvironmentMetadata
	(*StartEnvironmentRequest)(nil),                 // 7: google.cloud.shell.v1.StartEnvironmentRequest
	(*AuthorizeEnvironmentRequest)(nil),             // 8: google.cloud.shell.v1.AuthorizeEnvironmentRequest
	(*AuthorizeEnvironmentResponse)(nil),            // 9: google.cloud.shell.v1.AuthorizeEnvironmentResponse
	(*AuthorizeEnvironmentMetadata)(nil),            // 10: google.cloud.shell.v1.AuthorizeEnvironmentMetadata
	(*StartEnvironmentMetadata)(nil),                // 11: google.cloud.shell.v1.StartEnvironmentMetadata
	(*StartEnvironmentResponse)(nil),                // 12: google.cloud.shell.v1.StartEnvironmentResponse
	(*AddPublicKeyRequest)(nil),                     // 13: google.cloud.shell.v1.AddPublicKeyRequest
	(*AddPublicKeyResponse)(nil),                    // 14: google.cloud.shell.v1.AddPublicKeyResponse
	(*AddPublicKeyMetadata)(nil),                    // 15: google.cloud.shell.v1.AddPublicKeyMetadata
	(*RemovePublicKeyRequest)(nil),                  // 16: google.cloud.shell.v1.RemovePublicKeyRequest
	(*RemovePublicKeyResponse)(nil),                 // 17: google.cloud.shell.v1.RemovePublicKeyResponse
	(*RemovePublicKeyMetadata)(nil),                 // 18: google.cloud.shell.v1.RemovePublicKeyMetadata
	(*CloudShellErrorDetails)(nil),                  // 19: google.cloud.shell.v1.CloudShellErrorDetails
	(*timestamppb.Timestamp)(nil),                   // 20: google.protobuf.Timestamp
	(*longrunningpb.Operation)(nil),                 // 21: google.longrunning.Operation
}
var file_google_cloud_shell_v1_cloudshell_proto_depIdxs = []int32{
	0,  // 0: google.cloud.shell.v1.Environment.state:type_name -> google.cloud.shell.v1.Environment.State
	20, // 1: google.cloud.shell.v1.AuthorizeEnvironmentRequest.expire_time:type_name -> google.protobuf.Timestamp
	1,  // 2: google.cloud.shell.v1.StartEnvironmentMetadata.state:type_name -> google.cloud.shell.v1.StartEnvironmentMetadata.State
	3,  // 3: google.cloud.shell.v1.StartEnvironmentResponse.environment:type_name -> google.cloud.shell.v1.Environment
	2,  // 4: google.cloud.shell.v1.CloudShellErrorDetails.code:type_name -> google.cloud.shell.v1.CloudShellErrorDetails.CloudShellErrorCode
	4,  // 5: google.cloud.shell.v1.CloudShellService.GetEnvironment:input_type -> google.cloud.shell.v1.GetEnvironmentRequest
	7,  // 6: google.cloud.shell.v1.CloudShellService.StartEnvironment:input_type -> google.cloud.shell.v1.StartEnvironmentRequest
	8,  // 7: google.cloud.shell.v1.CloudShellService.AuthorizeEnvironment:input_type -> google.cloud.shell.v1.AuthorizeEnvironmentRequest
	13, // 8: google.cloud.shell.v1.CloudShellService.AddPublicKey:input_type -> google.cloud.shell.v1.AddPublicKeyRequest
	16, // 9: google.cloud.shell.v1.CloudShellService.RemovePublicKey:input_type -> google.cloud.shell.v1.RemovePublicKeyRequest
	3,  // 10: google.cloud.shell.v1.CloudShellService.GetEnvironment:output_type -> google.cloud.shell.v1.Environment
	21, // 11: google.cloud.shell.v1.CloudShellService.StartEnvironment:output_type -> google.longrunning.Operation
	21, // 12: google.cloud.shell.v1.CloudShellService.AuthorizeEnvironment:output_type -> google.longrunning.Operation
	21, // 13: google.cloud.shell.v1.CloudShellService.AddPublicKey:output_type -> google.longrunning.Operation
	21, // 14: google.cloud.shell.v1.CloudShellService.RemovePublicKey:output_type -> google.longrunning.Operation
	10, // [10:15] is the sub-list for method output_type
	5,  // [5:10] is the sub-list for method input_type
	5,  // [5:5] is the sub-list for extension type_name
	5,  // [5:5] is the sub-list for extension extendee
	0,  // [0:5] is the sub-list for field type_name
}

func init() { file_google_cloud_shell_v1_cloudshell_proto_init() }
func file_google_cloud_shell_v1_cloudshell_proto_init() {
	if File_google_cloud_shell_v1_cloudshell_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_shell_v1_cloudshell_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_shell_v1_cloudshell_proto_goTypes,
		DependencyIndexes: file_google_cloud_shell_v1_cloudshell_proto_depIdxs,
		EnumInfos:         file_google_cloud_shell_v1_cloudshell_proto_enumTypes,
		MessageInfos:      file_google_cloud_shell_v1_cloudshell_proto_msgTypes,
	}.Build()
	File_google_cloud_shell_v1_cloudshell_proto = out.File
	file_google_cloud_shell_v1_cloudshell_proto_rawDesc = nil
	file_google_cloud_shell_v1_cloudshell_proto_goTypes = nil
	file_google_cloud_shell_v1_cloudshell_proto_depIdxs = nil
}
