// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/speech/v1p1beta1/resource.proto

package speechpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Set of states that define the lifecycle of a CustomClass.
type CustomClass_State int32

const (
	// Unspecified state.  This is only used/useful for distinguishing
	// unset values.
	CustomClass_STATE_UNSPECIFIED CustomClass_State = 0
	// The normal and active state.
	CustomClass_ACTIVE CustomClass_State = 2
	// This CustomClass has been deleted.
	CustomClass_DELETED CustomClass_State = 4
)

// Enum value maps for CustomClass_State.
var (
	CustomClass_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		2: "ACTIVE",
		4: "DELETED",
	}
	CustomClass_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            2,
		"DELETED":           4,
	}
)

func (x CustomClass_State) Enum() *CustomClass_State {
	p := new(CustomClass_State)
	*p = x
	return p
}

func (x CustomClass_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CustomClass_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_speech_v1p1beta1_resource_proto_enumTypes[0].Descriptor()
}

func (CustomClass_State) Type() protoreflect.EnumType {
	return &file_google_cloud_speech_v1p1beta1_resource_proto_enumTypes[0]
}

func (x CustomClass_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CustomClass_State.Descriptor instead.
func (CustomClass_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_resource_proto_rawDescGZIP(), []int{0, 0}
}

// Set of states that define the lifecycle of a CustomClass.
type PhraseSet_State int32

const (
	// Unspecified state.  This is only used/useful for distinguishing
	// unset values.
	PhraseSet_STATE_UNSPECIFIED PhraseSet_State = 0
	// The normal and active state.
	PhraseSet_ACTIVE PhraseSet_State = 2
	// This CustomClass has been deleted.
	PhraseSet_DELETED PhraseSet_State = 4
)

// Enum value maps for PhraseSet_State.
var (
	PhraseSet_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		2: "ACTIVE",
		4: "DELETED",
	}
	PhraseSet_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            2,
		"DELETED":           4,
	}
)

func (x PhraseSet_State) Enum() *PhraseSet_State {
	p := new(PhraseSet_State)
	*p = x
	return p
}

func (x PhraseSet_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PhraseSet_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_speech_v1p1beta1_resource_proto_enumTypes[1].Descriptor()
}

func (PhraseSet_State) Type() protoreflect.EnumType {
	return &file_google_cloud_speech_v1p1beta1_resource_proto_enumTypes[1]
}

func (x PhraseSet_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PhraseSet_State.Descriptor instead.
func (PhraseSet_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_resource_proto_rawDescGZIP(), []int{1, 0}
}

// A set of words or phrases that represents a common concept likely to appear
// in your audio, for example a list of passenger ship names. CustomClass items
// can be substituted into placeholders that you set in PhraseSet phrases.
type CustomClass struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the custom class.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If this custom class is a resource, the custom_class_id is the resource id
	// of the CustomClass. Case sensitive.
	CustomClassId string `protobuf:"bytes,2,opt,name=custom_class_id,json=customClassId,proto3" json:"custom_class_id,omitempty"`
	// A collection of class items.
	Items []*CustomClass_ClassItem `protobuf:"bytes,3,rep,name=items,proto3" json:"items,omitempty"`
	// Output only. The [KMS key
	// name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
	// the content of the ClassItem is encrypted. The expected format is
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
	KmsKeyName string `protobuf:"bytes,6,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Output only. The [KMS key version
	// name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
	// with which content of the ClassItem is encrypted. The expected format is
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
	KmsKeyVersionName string `protobuf:"bytes,7,opt,name=kms_key_version_name,json=kmsKeyVersionName,proto3" json:"kms_key_version_name,omitempty"`
	// Output only. System-assigned unique identifier for the CustomClass.
	// This field is not used.
	Uid string `protobuf:"bytes,8,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. User-settable, human-readable name for the CustomClass. Must
	// be 63 characters or less. This field is not used.
	DisplayName string `protobuf:"bytes,9,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The CustomClass lifecycle state.
	// This field is not used.
	State CustomClass_State `protobuf:"varint,10,opt,name=state,proto3,enum=google.cloud.speech.v1p1beta1.CustomClass_State" json:"state,omitempty"`
	// Output only. The time at which this resource was requested for deletion.
	// This field is not used.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Output only. The time at which this resource will be purged.
	// This field is not used.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. Allows users to store small amounts of arbitrary data.
	// Both the key and the value must be 63 characters or less each.
	// At most 100 annotations.
	// This field is not used.
	Annotations map[string]string `protobuf:"bytes,13,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. This checksum is computed by the server based on the value of
	// other fields. This may be sent on update, undelete, and delete requests to
	// ensure the client has an up-to-date value before proceeding. This field is
	// not used.
	Etag string `protobuf:"bytes,14,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. Whether or not this CustomClass is in the process of being
	// updated. This field is not used.
	Reconciling bool `protobuf:"varint,15,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
}

func (x *CustomClass) Reset() {
	*x = CustomClass{}
	mi := &file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CustomClass) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomClass) ProtoMessage() {}

func (x *CustomClass) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomClass.ProtoReflect.Descriptor instead.
func (*CustomClass) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_resource_proto_rawDescGZIP(), []int{0}
}

func (x *CustomClass) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CustomClass) GetCustomClassId() string {
	if x != nil {
		return x.CustomClassId
	}
	return ""
}

func (x *CustomClass) GetItems() []*CustomClass_ClassItem {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *CustomClass) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *CustomClass) GetKmsKeyVersionName() string {
	if x != nil {
		return x.KmsKeyVersionName
	}
	return ""
}

func (x *CustomClass) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *CustomClass) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *CustomClass) GetState() CustomClass_State {
	if x != nil {
		return x.State
	}
	return CustomClass_STATE_UNSPECIFIED
}

func (x *CustomClass) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *CustomClass) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *CustomClass) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *CustomClass) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *CustomClass) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results.
type PhraseSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the phrase set.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of word and phrases.
	Phrases []*PhraseSet_Phrase `protobuf:"bytes,2,rep,name=phrases,proto3" json:"phrases,omitempty"`
	// Hint Boost. Positive value will increase the probability that a specific
	// phrase will be recognized over other similar sounding phrases. The higher
	// the boost, the higher the chance of false positive recognition as well.
	// Negative boost values would correspond to anti-biasing. Anti-biasing is not
	// enabled, so negative boost will simply be ignored. Though `boost` can
	// accept a wide range of positive values, most use cases are best served with
	// values between 0 (exclusive) and 20. We recommend using a binary search
	// approach to finding the optimal value for your use case as well as adding
	// phrases both with and without boost to your requests.
	Boost float32 `protobuf:"fixed32,4,opt,name=boost,proto3" json:"boost,omitempty"`
	// Output only. The [KMS key
	// name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
	// the content of the PhraseSet is encrypted. The expected format is
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
	KmsKeyName string `protobuf:"bytes,7,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Output only. The [KMS key version
	// name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
	// with which content of the PhraseSet is encrypted. The expected format is
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
	KmsKeyVersionName string `protobuf:"bytes,8,opt,name=kms_key_version_name,json=kmsKeyVersionName,proto3" json:"kms_key_version_name,omitempty"`
	// Output only. System-assigned unique identifier for the PhraseSet.
	// This field is not used.
	Uid string `protobuf:"bytes,9,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. User-settable, human-readable name for the PhraseSet. Must be
	// 63 characters or less. This field is not used.
	DisplayName string `protobuf:"bytes,10,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The CustomClass lifecycle state.
	// This field is not used.
	State PhraseSet_State `protobuf:"varint,11,opt,name=state,proto3,enum=google.cloud.speech.v1p1beta1.PhraseSet_State" json:"state,omitempty"`
	// Output only. The time at which this resource was requested for deletion.
	// This field is not used.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Output only. The time at which this resource will be purged.
	// This field is not used.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. Allows users to store small amounts of arbitrary data.
	// Both the key and the value must be 63 characters or less each.
	// At most 100 annotations.
	// This field is not used.
	Annotations map[string]string `protobuf:"bytes,14,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. This checksum is computed by the server based on the value of
	// other fields. This may be sent on update, undelete, and delete requests to
	// ensure the client has an up-to-date value before proceeding. This field is
	// not used.
	Etag string `protobuf:"bytes,15,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. Whether or not this PhraseSet is in the process of being
	// updated. This field is not used.
	Reconciling bool `protobuf:"varint,16,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
}

func (x *PhraseSet) Reset() {
	*x = PhraseSet{}
	mi := &file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PhraseSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhraseSet) ProtoMessage() {}

func (x *PhraseSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhraseSet.ProtoReflect.Descriptor instead.
func (*PhraseSet) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_resource_proto_rawDescGZIP(), []int{1}
}

func (x *PhraseSet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PhraseSet) GetPhrases() []*PhraseSet_Phrase {
	if x != nil {
		return x.Phrases
	}
	return nil
}

func (x *PhraseSet) GetBoost() float32 {
	if x != nil {
		return x.Boost
	}
	return 0
}

func (x *PhraseSet) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *PhraseSet) GetKmsKeyVersionName() string {
	if x != nil {
		return x.KmsKeyVersionName
	}
	return ""
}

func (x *PhraseSet) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *PhraseSet) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PhraseSet) GetState() PhraseSet_State {
	if x != nil {
		return x.State
	}
	return PhraseSet_STATE_UNSPECIFIED
}

func (x *PhraseSet) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *PhraseSet) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *PhraseSet) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *PhraseSet) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *PhraseSet) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

// Speech adaptation configuration.
type SpeechAdaptation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A collection of phrase sets. To specify the hints inline, leave the
	// phrase set's `name` blank and fill in the rest of its fields. Any
	// phrase set can use any custom class.
	PhraseSets []*PhraseSet `protobuf:"bytes,1,rep,name=phrase_sets,json=phraseSets,proto3" json:"phrase_sets,omitempty"`
	// A collection of phrase set resource names to use.
	PhraseSetReferences []string `protobuf:"bytes,2,rep,name=phrase_set_references,json=phraseSetReferences,proto3" json:"phrase_set_references,omitempty"`
	// A collection of custom classes. To specify the classes inline, leave the
	// class' `name` blank and fill in the rest of its fields, giving it a unique
	// `custom_class_id`. Refer to the inline defined class in phrase hints by its
	// `custom_class_id`.
	CustomClasses []*CustomClass `protobuf:"bytes,3,rep,name=custom_classes,json=customClasses,proto3" json:"custom_classes,omitempty"`
	// Augmented Backus-Naur form (ABNF) is a standardized grammar notation
	// comprised by a set of derivation rules.
	// See specifications: https://www.w3.org/TR/speech-grammar
	AbnfGrammar *SpeechAdaptation_ABNFGrammar `protobuf:"bytes,4,opt,name=abnf_grammar,json=abnfGrammar,proto3" json:"abnf_grammar,omitempty"`
}

func (x *SpeechAdaptation) Reset() {
	*x = SpeechAdaptation{}
	mi := &file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeechAdaptation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechAdaptation) ProtoMessage() {}

func (x *SpeechAdaptation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechAdaptation.ProtoReflect.Descriptor instead.
func (*SpeechAdaptation) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_resource_proto_rawDescGZIP(), []int{2}
}

func (x *SpeechAdaptation) GetPhraseSets() []*PhraseSet {
	if x != nil {
		return x.PhraseSets
	}
	return nil
}

func (x *SpeechAdaptation) GetPhraseSetReferences() []string {
	if x != nil {
		return x.PhraseSetReferences
	}
	return nil
}

func (x *SpeechAdaptation) GetCustomClasses() []*CustomClass {
	if x != nil {
		return x.CustomClasses
	}
	return nil
}

func (x *SpeechAdaptation) GetAbnfGrammar() *SpeechAdaptation_ABNFGrammar {
	if x != nil {
		return x.AbnfGrammar
	}
	return nil
}

// Transcription normalization configuration. Use transcription normalization
// to automatically replace parts of the transcript with phrases of your
// choosing. For StreamingRecognize, this normalization only applies to stable
// partial transcripts (stability > 0.8) and final transcripts.
type TranscriptNormalization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of replacement entries. We will perform replacement with one entry
	// at a time. For example, the second entry in ["cat" => "dog", "mountain cat"
	// => "mountain dog"] will never be applied because we will always process the
	// first entry before it. At most 100 entries.
	Entries []*TranscriptNormalization_Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *TranscriptNormalization) Reset() {
	*x = TranscriptNormalization{}
	mi := &file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TranscriptNormalization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranscriptNormalization) ProtoMessage() {}

func (x *TranscriptNormalization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranscriptNormalization.ProtoReflect.Descriptor instead.
func (*TranscriptNormalization) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_resource_proto_rawDescGZIP(), []int{3}
}

func (x *TranscriptNormalization) GetEntries() []*TranscriptNormalization_Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// An item of the class.
type CustomClass_ClassItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The class item's value.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *CustomClass_ClassItem) Reset() {
	*x = CustomClass_ClassItem{}
	mi := &file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CustomClass_ClassItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomClass_ClassItem) ProtoMessage() {}

func (x *CustomClass_ClassItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomClass_ClassItem.ProtoReflect.Descriptor instead.
func (*CustomClass_ClassItem) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_resource_proto_rawDescGZIP(), []int{0, 0}
}

func (x *CustomClass_ClassItem) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// A phrases containing words and phrase "hints" so that
// the speech recognition is more likely to recognize them. This can be used
// to improve the accuracy for specific words and phrases, for example, if
// specific commands are typically spoken by the user. This can also be used
// to add additional words to the vocabulary of the recognizer. See
// [usage limits](https://cloud.google.com/speech-to-text/quotas#content).
//
// List items can also include pre-built or custom classes containing groups
// of words that represent common concepts that occur in natural language. For
// example, rather than providing a phrase hint for every month of the
// year (e.g. "i was born in january", "i was born in febuary", ...), use the
// pre-built `$MONTH` class improves the likelihood of correctly transcribing
// audio that includes months (e.g. "i was born in $month").
// To refer to pre-built classes, use the class' symbol prepended with `$`
// e.g. `$MONTH`. To refer to custom classes that were defined inline in the
// request, set the class's `custom_class_id` to a string unique to all class
// resources and inline classes. Then use the class' id wrapped in $`{...}`
// e.g. "${my-months}". To refer to custom classes resources, use the class'
// id wrapped in `${}` (e.g. `${my-months}`).
//
// Speech-to-Text supports three locations: `global`, `us` (US North America),
// and `eu` (Europe). If you are calling the `speech.googleapis.com`
// endpoint, use the `global` location. To specify a region, use a
// [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints)
// with matching `us` or `eu` location value.
type PhraseSet_Phrase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The phrase itself.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Hint Boost. Overrides the boost set at the phrase set level.
	// Positive value will increase the probability that a specific phrase will
	// be recognized over other similar sounding phrases. The higher the boost,
	// the higher the chance of false positive recognition as well. Negative
	// boost will simply be ignored. Though `boost` can accept a wide range of
	// positive values, most use cases are best served
	// with values between 0 and 20. We recommend using a binary search approach
	// to finding the optimal value for your use case as well as adding
	// phrases both with and without boost to your requests.
	Boost float32 `protobuf:"fixed32,2,opt,name=boost,proto3" json:"boost,omitempty"`
}

func (x *PhraseSet_Phrase) Reset() {
	*x = PhraseSet_Phrase{}
	mi := &file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PhraseSet_Phrase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhraseSet_Phrase) ProtoMessage() {}

func (x *PhraseSet_Phrase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhraseSet_Phrase.ProtoReflect.Descriptor instead.
func (*PhraseSet_Phrase) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_resource_proto_rawDescGZIP(), []int{1, 0}
}

func (x *PhraseSet_Phrase) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *PhraseSet_Phrase) GetBoost() float32 {
	if x != nil {
		return x.Boost
	}
	return 0
}

type SpeechAdaptation_ABNFGrammar struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All declarations and rules of an ABNF grammar broken up into multiple
	// strings that will end up concatenated.
	AbnfStrings []string `protobuf:"bytes,1,rep,name=abnf_strings,json=abnfStrings,proto3" json:"abnf_strings,omitempty"`
}

func (x *SpeechAdaptation_ABNFGrammar) Reset() {
	*x = SpeechAdaptation_ABNFGrammar{}
	mi := &file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeechAdaptation_ABNFGrammar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechAdaptation_ABNFGrammar) ProtoMessage() {}

func (x *SpeechAdaptation_ABNFGrammar) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechAdaptation_ABNFGrammar.ProtoReflect.Descriptor instead.
func (*SpeechAdaptation_ABNFGrammar) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_resource_proto_rawDescGZIP(), []int{2, 0}
}

func (x *SpeechAdaptation_ABNFGrammar) GetAbnfStrings() []string {
	if x != nil {
		return x.AbnfStrings
	}
	return nil
}

// A single replacement configuration.
type TranscriptNormalization_Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// What to replace. Max length is 100 characters.
	Search string `protobuf:"bytes,1,opt,name=search,proto3" json:"search,omitempty"`
	// What to replace with. Max length is 100 characters.
	Replace string `protobuf:"bytes,2,opt,name=replace,proto3" json:"replace,omitempty"`
	// Whether the search is case sensitive.
	CaseSensitive bool `protobuf:"varint,3,opt,name=case_sensitive,json=caseSensitive,proto3" json:"case_sensitive,omitempty"`
}

func (x *TranscriptNormalization_Entry) Reset() {
	*x = TranscriptNormalization_Entry{}
	mi := &file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TranscriptNormalization_Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranscriptNormalization_Entry) ProtoMessage() {}

func (x *TranscriptNormalization_Entry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranscriptNormalization_Entry.ProtoReflect.Descriptor instead.
func (*TranscriptNormalization_Entry) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v1p1beta1_resource_proto_rawDescGZIP(), []int{3, 0}
}

func (x *TranscriptNormalization_Entry) GetSearch() string {
	if x != nil {
		return x.Search
	}
	return ""
}

func (x *TranscriptNormalization_Entry) GetReplace() string {
	if x != nil {
		return x.Replace
	}
	return ""
}

func (x *TranscriptNormalization_Entry) GetCaseSensitive() bool {
	if x != nil {
		return x.CaseSensitive
	}
	return false
}

var File_google_cloud_speech_v1p1beta1_resource_proto protoreflect.FileDescriptor

var file_google_cloud_speech_v1p1beta1_resource_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x83, 0x08, 0x0a, 0x0b, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26,
	0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x49, 0x64, 0x12, 0x4a, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x05, 0x69, 0x74, 0x65,
	0x6d, 0x73, 0x12, 0x4b, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x4b, 0x65, 0x79, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x61, 0x0a, 0x14, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x03, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x11, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x4b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x62, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12,
	0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e,
	0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0x21, 0x0a, 0x09, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x49,
	0x74, 0x65, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x37, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54,
	0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44,
	0x10, 0x04, 0x3a, 0x6c, 0xea, 0x41, 0x69, 0x0a, 0x21, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x44, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65,
	0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x7d,
	0x22, 0xf6, 0x07, 0x0a, 0x09, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x49, 0x0a, 0x07, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x2e, 0x50, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x52, 0x07, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x12, 0x14, 0x0a,
	0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x62, 0x6f,
	0x6f, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x03, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x61, 0x0a, 0x14, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30,
	0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x11, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x49, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x60, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74,
	0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x25, 0x0a, 0x0b,
	0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c,
	0x69, 0x6e, 0x67, 0x1a, 0x34, 0x0a, 0x06, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x37, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54,
	0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44,
	0x10, 0x04, 0x3a, 0x65, 0xea, 0x41, 0x62, 0x0a, 0x1f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x7d, 0x22, 0x9c, 0x03, 0x0a, 0x10, 0x53, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49,
	0x0a, 0x0b, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x0a, 0x70,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x12, 0x58, 0x0a, 0x15, 0x70, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x13,
	0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x12, 0x5e, 0x0a, 0x0c, 0x61, 0x62, 0x6e, 0x66, 0x5f, 0x67,
	0x72, 0x61, 0x6d, 0x6d, 0x61, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x42,
	0x4e, 0x46, 0x47, 0x72, 0x61, 0x6d, 0x6d, 0x61, 0x72, 0x52, 0x0b, 0x61, 0x62, 0x6e, 0x66, 0x47,
	0x72, 0x61, 0x6d, 0x6d, 0x61, 0x72, 0x1a, 0x30, 0x0a, 0x0b, 0x41, 0x42, 0x4e, 0x46, 0x47, 0x72,
	0x61, 0x6d, 0x6d, 0x61, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x62, 0x6e, 0x66, 0x5f, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x62, 0x6e,
	0x66, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xd3, 0x01, 0x0a, 0x17, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x70, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a, 0x60, 0x0a, 0x05,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x18, 0x0a,
	0x07, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x73, 0x65, 0x5f,
	0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0d, 0x63, 0x61, 0x73, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x42, 0xa0,
	0x03, 0xea, 0x41, 0x78, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f, 0x72,
	0x69, 0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x73, 0x2f,
	0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0xea, 0x41, 0xa6, 0x01,
	0x0a, 0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x7a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65,
	0x79, 0x5f, 0x72, 0x69, 0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65,
	0x79, 0x73, 0x2f, 0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0x2f,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x13, 0x53, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x39, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x70, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x70, 0x62, 0x3b, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x70, 0x62, 0xa2, 0x02, 0x03, 0x47, 0x43,
	0x53, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_speech_v1p1beta1_resource_proto_rawDescOnce sync.Once
	file_google_cloud_speech_v1p1beta1_resource_proto_rawDescData = file_google_cloud_speech_v1p1beta1_resource_proto_rawDesc
)

func file_google_cloud_speech_v1p1beta1_resource_proto_rawDescGZIP() []byte {
	file_google_cloud_speech_v1p1beta1_resource_proto_rawDescOnce.Do(func() {
		file_google_cloud_speech_v1p1beta1_resource_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_speech_v1p1beta1_resource_proto_rawDescData)
	})
	return file_google_cloud_speech_v1p1beta1_resource_proto_rawDescData
}

var file_google_cloud_speech_v1p1beta1_resource_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_speech_v1p1beta1_resource_proto_goTypes = []any{
	(CustomClass_State)(0),                // 0: google.cloud.speech.v1p1beta1.CustomClass.State
	(PhraseSet_State)(0),                  // 1: google.cloud.speech.v1p1beta1.PhraseSet.State
	(*CustomClass)(nil),                   // 2: google.cloud.speech.v1p1beta1.CustomClass
	(*PhraseSet)(nil),                     // 3: google.cloud.speech.v1p1beta1.PhraseSet
	(*SpeechAdaptation)(nil),              // 4: google.cloud.speech.v1p1beta1.SpeechAdaptation
	(*TranscriptNormalization)(nil),       // 5: google.cloud.speech.v1p1beta1.TranscriptNormalization
	(*CustomClass_ClassItem)(nil),         // 6: google.cloud.speech.v1p1beta1.CustomClass.ClassItem
	nil,                                   // 7: google.cloud.speech.v1p1beta1.CustomClass.AnnotationsEntry
	(*PhraseSet_Phrase)(nil),              // 8: google.cloud.speech.v1p1beta1.PhraseSet.Phrase
	nil,                                   // 9: google.cloud.speech.v1p1beta1.PhraseSet.AnnotationsEntry
	(*SpeechAdaptation_ABNFGrammar)(nil),  // 10: google.cloud.speech.v1p1beta1.SpeechAdaptation.ABNFGrammar
	(*TranscriptNormalization_Entry)(nil), // 11: google.cloud.speech.v1p1beta1.TranscriptNormalization.Entry
	(*timestamppb.Timestamp)(nil),         // 12: google.protobuf.Timestamp
}
var file_google_cloud_speech_v1p1beta1_resource_proto_depIdxs = []int32{
	6,  // 0: google.cloud.speech.v1p1beta1.CustomClass.items:type_name -> google.cloud.speech.v1p1beta1.CustomClass.ClassItem
	0,  // 1: google.cloud.speech.v1p1beta1.CustomClass.state:type_name -> google.cloud.speech.v1p1beta1.CustomClass.State
	12, // 2: google.cloud.speech.v1p1beta1.CustomClass.delete_time:type_name -> google.protobuf.Timestamp
	12, // 3: google.cloud.speech.v1p1beta1.CustomClass.expire_time:type_name -> google.protobuf.Timestamp
	7,  // 4: google.cloud.speech.v1p1beta1.CustomClass.annotations:type_name -> google.cloud.speech.v1p1beta1.CustomClass.AnnotationsEntry
	8,  // 5: google.cloud.speech.v1p1beta1.PhraseSet.phrases:type_name -> google.cloud.speech.v1p1beta1.PhraseSet.Phrase
	1,  // 6: google.cloud.speech.v1p1beta1.PhraseSet.state:type_name -> google.cloud.speech.v1p1beta1.PhraseSet.State
	12, // 7: google.cloud.speech.v1p1beta1.PhraseSet.delete_time:type_name -> google.protobuf.Timestamp
	12, // 8: google.cloud.speech.v1p1beta1.PhraseSet.expire_time:type_name -> google.protobuf.Timestamp
	9,  // 9: google.cloud.speech.v1p1beta1.PhraseSet.annotations:type_name -> google.cloud.speech.v1p1beta1.PhraseSet.AnnotationsEntry
	3,  // 10: google.cloud.speech.v1p1beta1.SpeechAdaptation.phrase_sets:type_name -> google.cloud.speech.v1p1beta1.PhraseSet
	2,  // 11: google.cloud.speech.v1p1beta1.SpeechAdaptation.custom_classes:type_name -> google.cloud.speech.v1p1beta1.CustomClass
	10, // 12: google.cloud.speech.v1p1beta1.SpeechAdaptation.abnf_grammar:type_name -> google.cloud.speech.v1p1beta1.SpeechAdaptation.ABNFGrammar
	11, // 13: google.cloud.speech.v1p1beta1.TranscriptNormalization.entries:type_name -> google.cloud.speech.v1p1beta1.TranscriptNormalization.Entry
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_cloud_speech_v1p1beta1_resource_proto_init() }
func file_google_cloud_speech_v1p1beta1_resource_proto_init() {
	if File_google_cloud_speech_v1p1beta1_resource_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_speech_v1p1beta1_resource_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_speech_v1p1beta1_resource_proto_goTypes,
		DependencyIndexes: file_google_cloud_speech_v1p1beta1_resource_proto_depIdxs,
		EnumInfos:         file_google_cloud_speech_v1p1beta1_resource_proto_enumTypes,
		MessageInfos:      file_google_cloud_speech_v1p1beta1_resource_proto_msgTypes,
	}.Build()
	File_google_cloud_speech_v1p1beta1_resource_proto = out.File
	file_google_cloud_speech_v1p1beta1_resource_proto_rawDesc = nil
	file_google_cloud_speech_v1p1beta1_resource_proto_goTypes = nil
	file_google_cloud_speech_v1p1beta1_resource_proto_depIdxs = nil
}
