// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/storage/control/v2/storage_control.proto

package controlpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Contains information about a pending rename operation.
type PendingRenameInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the rename operation.
	Operation string `protobuf:"bytes,1,opt,name=operation,proto3" json:"operation,omitempty"`
}

func (x *PendingRenameInfo) Reset() {
	*x = PendingRenameInfo{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PendingRenameInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PendingRenameInfo) ProtoMessage() {}

func (x *PendingRenameInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PendingRenameInfo.ProtoReflect.Descriptor instead.
func (*PendingRenameInfo) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{0}
}

func (x *PendingRenameInfo) GetOperation() string {
	if x != nil {
		return x.Operation
	}
	return ""
}

// A folder resource. This resource can only exist in a hierarchical namespace
// enabled bucket.
type Folder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of this folder.
	// Format: `projects/{project}/buckets/{bucket}/folders/{folder}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The version of the metadata for this folder. Used for
	// preconditions and for detecting changes in metadata.
	Metageneration int64 `protobuf:"varint,3,opt,name=metageneration,proto3" json:"metageneration,omitempty"`
	// Output only. The creation time of the folder.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The modification time of the folder.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Only present if the folder is part of an ongoing RenameFolder
	// operation. Contains information which can be used to query the operation
	// status. The presence of this field also indicates all write operations are
	// blocked for this folder, including folder, managed folder, and object
	// operations.
	PendingRenameInfo *PendingRenameInfo `protobuf:"bytes,7,opt,name=pending_rename_info,json=pendingRenameInfo,proto3" json:"pending_rename_info,omitempty"`
}

func (x *Folder) Reset() {
	*x = Folder{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Folder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Folder) ProtoMessage() {}

func (x *Folder) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Folder.ProtoReflect.Descriptor instead.
func (*Folder) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{1}
}

func (x *Folder) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Folder) GetMetageneration() int64 {
	if x != nil {
		return x.Metageneration
	}
	return 0
}

func (x *Folder) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Folder) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Folder) GetPendingRenameInfo() *PendingRenameInfo {
	if x != nil {
		return x.PendingRenameInfo
	}
	return nil
}

// Request message for GetFolder. This operation is only applicable to a
// hierarchical namespace enabled bucket.
type GetFolderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the folder.
	// Format: `projects/{project}/buckets/{bucket}/folders/{folder}`
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// Makes the operation only succeed conditional on whether the folder's
	// current metageneration matches the given value.
	IfMetagenerationMatch *int64 `protobuf:"varint,3,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3,oneof" json:"if_metageneration_match,omitempty"`
	// Makes the operation only succeed conditional on whether the folder's
	// current metageneration does not match the given value.
	IfMetagenerationNotMatch *int64 `protobuf:"varint,4,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3,oneof" json:"if_metageneration_not_match,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted.
	RequestId string `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *GetFolderRequest) Reset() {
	*x = GetFolderRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFolderRequest) ProtoMessage() {}

func (x *GetFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFolderRequest.ProtoReflect.Descriptor instead.
func (*GetFolderRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{2}
}

func (x *GetFolderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetFolderRequest) GetIfMetagenerationMatch() int64 {
	if x != nil && x.IfMetagenerationMatch != nil {
		return *x.IfMetagenerationMatch
	}
	return 0
}

func (x *GetFolderRequest) GetIfMetagenerationNotMatch() int64 {
	if x != nil && x.IfMetagenerationNotMatch != nil {
		return *x.IfMetagenerationNotMatch
	}
	return 0
}

func (x *GetFolderRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for CreateFolder. This operation is only applicable to a
// hierarchical namespace enabled bucket.
type CreateFolderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the bucket in which the folder will reside. The bucket
	// must be a hierarchical namespace enabled bucket.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Properties of the new folder being created.
	// The bucket and name of the folder are specified in the parent and folder_id
	// fields, respectively. Populating those fields in `folder` will result in an
	// error.
	Folder *Folder `protobuf:"bytes,2,opt,name=folder,proto3" json:"folder,omitempty"`
	// Required. The full name of a folder, including all its parent folders.
	// Folders use single '/' characters as a delimiter.
	// The folder_id must end with a slash.
	// For example, the folder_id of "books/biographies/" would create a new
	// "biographies/" folder under the "books/" folder.
	FolderId string `protobuf:"bytes,3,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Optional. If true, parent folder doesn't have to be present and all missing
	// ancestor folders will be created atomically.
	Recursive bool `protobuf:"varint,4,opt,name=recursive,proto3" json:"recursive,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted.
	RequestId string `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateFolderRequest) Reset() {
	*x = CreateFolderRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFolderRequest) ProtoMessage() {}

func (x *CreateFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFolderRequest.ProtoReflect.Descriptor instead.
func (*CreateFolderRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{3}
}

func (x *CreateFolderRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFolderRequest) GetFolder() *Folder {
	if x != nil {
		return x.Folder
	}
	return nil
}

func (x *CreateFolderRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *CreateFolderRequest) GetRecursive() bool {
	if x != nil {
		return x.Recursive
	}
	return false
}

func (x *CreateFolderRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for DeleteFolder. This operation is only applicable to a
// hierarchical namespace enabled bucket.
type DeleteFolderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the folder.
	// Format: `projects/{project}/buckets/{bucket}/folders/{folder}`
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// Makes the operation only succeed conditional on whether the folder's
	// current metageneration matches the given value.
	IfMetagenerationMatch *int64 `protobuf:"varint,3,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3,oneof" json:"if_metageneration_match,omitempty"`
	// Makes the operation only succeed conditional on whether the folder's
	// current metageneration does not match the given value.
	IfMetagenerationNotMatch *int64 `protobuf:"varint,4,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3,oneof" json:"if_metageneration_not_match,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted.
	RequestId string `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteFolderRequest) Reset() {
	*x = DeleteFolderRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFolderRequest) ProtoMessage() {}

func (x *DeleteFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFolderRequest.ProtoReflect.Descriptor instead.
func (*DeleteFolderRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteFolderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteFolderRequest) GetIfMetagenerationMatch() int64 {
	if x != nil && x.IfMetagenerationMatch != nil {
		return *x.IfMetagenerationMatch
	}
	return 0
}

func (x *DeleteFolderRequest) GetIfMetagenerationNotMatch() int64 {
	if x != nil && x.IfMetagenerationNotMatch != nil {
		return *x.IfMetagenerationNotMatch
	}
	return 0
}

func (x *DeleteFolderRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for ListFolders. This operation is only applicable to a
// hierarchical namespace enabled bucket.
type ListFoldersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the bucket in which to look for folders. The bucket must
	// be a hierarchical namespace enabled bucket.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of folders to return in a single response. The
	// service will use this parameter or 1,000 items, whichever is smaller.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A previously-returned page token representing part of the larger
	// set of results to view.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter results to folders whose names begin with this prefix.
	// If set, the value must either be an empty string or end with a '/'.
	Prefix string `protobuf:"bytes,4,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// Optional. If set, returns results in a directory-like mode. The results
	// will only include folders that either exactly match the above prefix, or
	// are one level below the prefix. The only supported value is '/'.
	Delimiter string `protobuf:"bytes,8,opt,name=delimiter,proto3" json:"delimiter,omitempty"`
	// Optional. Filter results to folders whose names are lexicographically equal
	// to or after lexicographic_start. If lexicographic_end is also set, the
	// folders listed have names between lexicographic_start (inclusive) and
	// lexicographic_end (exclusive).
	LexicographicStart string `protobuf:"bytes,6,opt,name=lexicographic_start,json=lexicographicStart,proto3" json:"lexicographic_start,omitempty"`
	// Optional. Filter results to folders whose names are lexicographically
	// before lexicographic_end. If lexicographic_start is also set, the folders
	// listed have names between lexicographic_start (inclusive) and
	// lexicographic_end (exclusive).
	LexicographicEnd string `protobuf:"bytes,7,opt,name=lexicographic_end,json=lexicographicEnd,proto3" json:"lexicographic_end,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted.
	RequestId string `protobuf:"bytes,9,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ListFoldersRequest) Reset() {
	*x = ListFoldersRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFoldersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFoldersRequest) ProtoMessage() {}

func (x *ListFoldersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFoldersRequest.ProtoReflect.Descriptor instead.
func (*ListFoldersRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{5}
}

func (x *ListFoldersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFoldersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFoldersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListFoldersRequest) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

func (x *ListFoldersRequest) GetDelimiter() string {
	if x != nil {
		return x.Delimiter
	}
	return ""
}

func (x *ListFoldersRequest) GetLexicographicStart() string {
	if x != nil {
		return x.LexicographicStart
	}
	return ""
}

func (x *ListFoldersRequest) GetLexicographicEnd() string {
	if x != nil {
		return x.LexicographicEnd
	}
	return ""
}

func (x *ListFoldersRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Response message for ListFolders.
type ListFoldersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of child folders
	Folders []*Folder `protobuf:"bytes,1,rep,name=folders,proto3" json:"folders,omitempty"`
	// The continuation token, used to page through large result sets. Provide
	// this value in a subsequent request to return the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListFoldersResponse) Reset() {
	*x = ListFoldersResponse{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFoldersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFoldersResponse) ProtoMessage() {}

func (x *ListFoldersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFoldersResponse.ProtoReflect.Descriptor instead.
func (*ListFoldersResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{6}
}

func (x *ListFoldersResponse) GetFolders() []*Folder {
	if x != nil {
		return x.Folders
	}
	return nil
}

func (x *ListFoldersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for RenameFolder. This operation is only applicable to a
// hierarchical namespace enabled bucket.
type RenameFolderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the source folder being renamed.
	// Format: `projects/{project}/buckets/{bucket}/folders/{folder}`
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The destination folder ID, e.g. `foo/bar/`.
	DestinationFolderId string `protobuf:"bytes,8,opt,name=destination_folder_id,json=destinationFolderId,proto3" json:"destination_folder_id,omitempty"`
	// Makes the operation only succeed conditional on whether the source
	// folder's current metageneration matches the given value.
	IfMetagenerationMatch *int64 `protobuf:"varint,4,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3,oneof" json:"if_metageneration_match,omitempty"`
	// Makes the operation only succeed conditional on whether the source
	// folder's current metageneration does not match the given value.
	IfMetagenerationNotMatch *int64 `protobuf:"varint,5,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3,oneof" json:"if_metageneration_not_match,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted. This request is only
	// idempotent if a `request_id` is provided.
	RequestId string `protobuf:"bytes,6,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *RenameFolderRequest) Reset() {
	*x = RenameFolderRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RenameFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameFolderRequest) ProtoMessage() {}

func (x *RenameFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenameFolderRequest.ProtoReflect.Descriptor instead.
func (*RenameFolderRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{7}
}

func (x *RenameFolderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RenameFolderRequest) GetDestinationFolderId() string {
	if x != nil {
		return x.DestinationFolderId
	}
	return ""
}

func (x *RenameFolderRequest) GetIfMetagenerationMatch() int64 {
	if x != nil && x.IfMetagenerationMatch != nil {
		return *x.IfMetagenerationMatch
	}
	return 0
}

func (x *RenameFolderRequest) GetIfMetagenerationNotMatch() int64 {
	if x != nil && x.IfMetagenerationNotMatch != nil {
		return *x.IfMetagenerationNotMatch
	}
	return 0
}

func (x *RenameFolderRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The message contains metadata that is common to all Storage Control
// long-running operations, present in its `google.longrunning.Operation`
// messages, and accessible via `metadata.common_metadata`.
type CommonLongRunningOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The time the operation was last modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The type of operation invoked.
	Type string `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	// Output only. Identifies whether the user has requested cancellation.
	RequestedCancellation bool `protobuf:"varint,5,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. The estimated progress of the operation in percentage [0,
	// 100]. The value -1 means the progress is unknown.
	ProgressPercent int32 `protobuf:"varint,6,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
}

func (x *CommonLongRunningOperationMetadata) Reset() {
	*x = CommonLongRunningOperationMetadata{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CommonLongRunningOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommonLongRunningOperationMetadata) ProtoMessage() {}

func (x *CommonLongRunningOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommonLongRunningOperationMetadata.ProtoReflect.Descriptor instead.
func (*CommonLongRunningOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{8}
}

func (x *CommonLongRunningOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CommonLongRunningOperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *CommonLongRunningOperationMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *CommonLongRunningOperationMetadata) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *CommonLongRunningOperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *CommonLongRunningOperationMetadata) GetProgressPercent() int32 {
	if x != nil {
		return x.ProgressPercent
	}
	return 0
}

// Message returned in the metadata field of the Operation resource for
// RenameFolder operations.
type RenameFolderMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Generic metadata for the long running operation.
	CommonMetadata *CommonLongRunningOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
	// The path of the source folder.
	SourceFolderId string `protobuf:"bytes,2,opt,name=source_folder_id,json=sourceFolderId,proto3" json:"source_folder_id,omitempty"`
	// The path of the destination folder.
	DestinationFolderId string `protobuf:"bytes,3,opt,name=destination_folder_id,json=destinationFolderId,proto3" json:"destination_folder_id,omitempty"`
}

func (x *RenameFolderMetadata) Reset() {
	*x = RenameFolderMetadata{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RenameFolderMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameFolderMetadata) ProtoMessage() {}

func (x *RenameFolderMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenameFolderMetadata.ProtoReflect.Descriptor instead.
func (*RenameFolderMetadata) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{9}
}

func (x *RenameFolderMetadata) GetCommonMetadata() *CommonLongRunningOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

func (x *RenameFolderMetadata) GetSourceFolderId() string {
	if x != nil {
		return x.SourceFolderId
	}
	return ""
}

func (x *RenameFolderMetadata) GetDestinationFolderId() string {
	if x != nil {
		return x.DestinationFolderId
	}
	return ""
}

// The storage layout configuration of a bucket.
type StorageLayout struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the StorageLayout resource.
	// Format: `projects/{project}/buckets/{bucket}/storageLayout`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The location of the bucket.
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Output only. The location type of the bucket (region, dual-region,
	// multi-region, etc).
	LocationType string `protobuf:"bytes,3,opt,name=location_type,json=locationType,proto3" json:"location_type,omitempty"`
	// Output only. The data placement configuration for custom dual region. If
	// there is no configuration, this is not a custom dual region bucket.
	CustomPlacementConfig *StorageLayout_CustomPlacementConfig `protobuf:"bytes,4,opt,name=custom_placement_config,json=customPlacementConfig,proto3" json:"custom_placement_config,omitempty"`
	// Output only. The bucket's hierarchical namespace configuration. If there is
	// no configuration, the hierarchical namespace is disabled.
	HierarchicalNamespace *StorageLayout_HierarchicalNamespace `protobuf:"bytes,5,opt,name=hierarchical_namespace,json=hierarchicalNamespace,proto3" json:"hierarchical_namespace,omitempty"`
}

func (x *StorageLayout) Reset() {
	*x = StorageLayout{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageLayout) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageLayout) ProtoMessage() {}

func (x *StorageLayout) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageLayout.ProtoReflect.Descriptor instead.
func (*StorageLayout) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{10}
}

func (x *StorageLayout) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StorageLayout) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *StorageLayout) GetLocationType() string {
	if x != nil {
		return x.LocationType
	}
	return ""
}

func (x *StorageLayout) GetCustomPlacementConfig() *StorageLayout_CustomPlacementConfig {
	if x != nil {
		return x.CustomPlacementConfig
	}
	return nil
}

func (x *StorageLayout) GetHierarchicalNamespace() *StorageLayout_HierarchicalNamespace {
	if x != nil {
		return x.HierarchicalNamespace
	}
	return nil
}

// Request message for GetStorageLayout.
type GetStorageLayoutRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the StorageLayout resource.
	// Format: `projects/{project}/buckets/{bucket}/storageLayout`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An optional prefix used for permission check. It is useful when the caller
	// only has limited permissions under a specific prefix.
	Prefix string `protobuf:"bytes,2,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *GetStorageLayoutRequest) Reset() {
	*x = GetStorageLayoutRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetStorageLayoutRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStorageLayoutRequest) ProtoMessage() {}

func (x *GetStorageLayoutRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStorageLayoutRequest.ProtoReflect.Descriptor instead.
func (*GetStorageLayoutRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{11}
}

func (x *GetStorageLayoutRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetStorageLayoutRequest) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

func (x *GetStorageLayoutRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A managed folder.
type ManagedFolder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of this managed folder.
	// Format:
	// `projects/{project}/buckets/{bucket}/managedFolders/{managedFolder}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The metadata version of this managed folder. It increases
	// whenever the metadata is updated. Used for preconditions and for detecting
	// changes in metadata. Managed folders don't have a generation number.
	Metageneration int64 `protobuf:"varint,3,opt,name=metageneration,proto3" json:"metageneration,omitempty"`
	// Output only. The creation time of the managed folder.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The modification time of the managed folder.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *ManagedFolder) Reset() {
	*x = ManagedFolder{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ManagedFolder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedFolder) ProtoMessage() {}

func (x *ManagedFolder) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedFolder.ProtoReflect.Descriptor instead.
func (*ManagedFolder) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{12}
}

func (x *ManagedFolder) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ManagedFolder) GetMetageneration() int64 {
	if x != nil {
		return x.Metageneration
	}
	return 0
}

func (x *ManagedFolder) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ManagedFolder) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Request message for GetManagedFolder.
type GetManagedFolderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the managed folder.
	// Format:
	// `projects/{project}/buckets/{bucket}/managedFolders/{managedFolder}`
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// The operation succeeds conditional on the managed folder's current
	// metageneration matching the value here specified.
	IfMetagenerationMatch *int64 `protobuf:"varint,3,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3,oneof" json:"if_metageneration_match,omitempty"`
	// The operation succeeds conditional on the managed folder's current
	// metageneration NOT matching the value here specified.
	IfMetagenerationNotMatch *int64 `protobuf:"varint,4,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3,oneof" json:"if_metageneration_not_match,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted.
	RequestId string `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *GetManagedFolderRequest) Reset() {
	*x = GetManagedFolderRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetManagedFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetManagedFolderRequest) ProtoMessage() {}

func (x *GetManagedFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetManagedFolderRequest.ProtoReflect.Descriptor instead.
func (*GetManagedFolderRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{13}
}

func (x *GetManagedFolderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetManagedFolderRequest) GetIfMetagenerationMatch() int64 {
	if x != nil && x.IfMetagenerationMatch != nil {
		return *x.IfMetagenerationMatch
	}
	return 0
}

func (x *GetManagedFolderRequest) GetIfMetagenerationNotMatch() int64 {
	if x != nil && x.IfMetagenerationNotMatch != nil {
		return *x.IfMetagenerationNotMatch
	}
	return 0
}

func (x *GetManagedFolderRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for CreateManagedFolder.
type CreateManagedFolderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the bucket this managed folder belongs to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Properties of the managed folder being created.
	// The bucket and managed folder names are specified in the `parent` and
	// `managed_folder_id` fields. Populating these fields in `managed_folder`
	// will result in an error.
	ManagedFolder *ManagedFolder `protobuf:"bytes,2,opt,name=managed_folder,json=managedFolder,proto3" json:"managed_folder,omitempty"`
	// Required. The name of the managed folder. It uses a single `/` as delimiter
	// and leading and trailing `/` are allowed.
	ManagedFolderId string `protobuf:"bytes,3,opt,name=managed_folder_id,json=managedFolderId,proto3" json:"managed_folder_id,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateManagedFolderRequest) Reset() {
	*x = CreateManagedFolderRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateManagedFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateManagedFolderRequest) ProtoMessage() {}

func (x *CreateManagedFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateManagedFolderRequest.ProtoReflect.Descriptor instead.
func (*CreateManagedFolderRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{14}
}

func (x *CreateManagedFolderRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateManagedFolderRequest) GetManagedFolder() *ManagedFolder {
	if x != nil {
		return x.ManagedFolder
	}
	return nil
}

func (x *CreateManagedFolderRequest) GetManagedFolderId() string {
	if x != nil {
		return x.ManagedFolderId
	}
	return ""
}

func (x *CreateManagedFolderRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// DeleteManagedFolder RPC request message.
type DeleteManagedFolderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the managed folder.
	// Format:
	// `projects/{project}/buckets/{bucket}/managedFolders/{managedFolder}`
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	// The operation succeeds conditional on the managed folder's current
	// metageneration matching the value here specified.
	IfMetagenerationMatch *int64 `protobuf:"varint,3,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3,oneof" json:"if_metageneration_match,omitempty"`
	// The operation succeeds conditional on the managed folder's current
	// metageneration NOT matching the value here specified.
	IfMetagenerationNotMatch *int64 `protobuf:"varint,4,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3,oneof" json:"if_metageneration_not_match,omitempty"`
	// Allows deletion of a managed folder even if it is not empty.
	// A managed folder is empty if it manages no child managed folders or
	// objects. Caller must have permission for
	// storage.managedFolders.setIamPolicy.
	AllowNonEmpty bool `protobuf:"varint,5,opt,name=allow_non_empty,json=allowNonEmpty,proto3" json:"allow_non_empty,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted.
	RequestId string `protobuf:"bytes,6,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteManagedFolderRequest) Reset() {
	*x = DeleteManagedFolderRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteManagedFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteManagedFolderRequest) ProtoMessage() {}

func (x *DeleteManagedFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteManagedFolderRequest.ProtoReflect.Descriptor instead.
func (*DeleteManagedFolderRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteManagedFolderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteManagedFolderRequest) GetIfMetagenerationMatch() int64 {
	if x != nil && x.IfMetagenerationMatch != nil {
		return *x.IfMetagenerationMatch
	}
	return 0
}

func (x *DeleteManagedFolderRequest) GetIfMetagenerationNotMatch() int64 {
	if x != nil && x.IfMetagenerationNotMatch != nil {
		return *x.IfMetagenerationNotMatch
	}
	return 0
}

func (x *DeleteManagedFolderRequest) GetAllowNonEmpty() bool {
	if x != nil {
		return x.AllowNonEmpty
	}
	return false
}

func (x *DeleteManagedFolderRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for ListManagedFolders.
type ListManagedFoldersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the bucket this managed folder belongs to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of managed folders to return in a single response.
	// The service will use this parameter or 1,000 items, whichever is smaller.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A previously-returned page token representing part of the larger
	// set of results to view.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter results to match managed folders with name starting with
	// this prefix.
	Prefix string `protobuf:"bytes,4,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted.
	RequestId string `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ListManagedFoldersRequest) Reset() {
	*x = ListManagedFoldersRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListManagedFoldersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListManagedFoldersRequest) ProtoMessage() {}

func (x *ListManagedFoldersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListManagedFoldersRequest.ProtoReflect.Descriptor instead.
func (*ListManagedFoldersRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{16}
}

func (x *ListManagedFoldersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListManagedFoldersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListManagedFoldersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListManagedFoldersRequest) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

func (x *ListManagedFoldersRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Response message for ListManagedFolders.
type ListManagedFoldersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of matching managed folders
	ManagedFolders []*ManagedFolder `protobuf:"bytes,1,rep,name=managed_folders,json=managedFolders,proto3" json:"managed_folders,omitempty"`
	// The continuation token, used to page through large result sets. Provide
	// this value in a subsequent request to return the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListManagedFoldersResponse) Reset() {
	*x = ListManagedFoldersResponse{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListManagedFoldersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListManagedFoldersResponse) ProtoMessage() {}

func (x *ListManagedFoldersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListManagedFoldersResponse.ProtoReflect.Descriptor instead.
func (*ListManagedFoldersResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{17}
}

func (x *ListManagedFoldersResponse) GetManagedFolders() []*ManagedFolder {
	if x != nil {
		return x.ManagedFolders
	}
	return nil
}

func (x *ListManagedFoldersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message returned in the metadata field of the Operation resource for
// CreateAnywhereCache operations.
type CreateAnywhereCacheMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Generic metadata for the long running operation.
	CommonMetadata *CommonLongRunningOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
	// Anywhere Cache ID.
	AnywhereCacheId *string `protobuf:"bytes,2,opt,name=anywhere_cache_id,json=anywhereCacheId,proto3,oneof" json:"anywhere_cache_id,omitempty"`
	// The zone in which the cache instance is running. For example,
	// us-central1-a.
	Zone *string `protobuf:"bytes,6,opt,name=zone,proto3,oneof" json:"zone,omitempty"`
	// Anywhere Cache entry's TTL. A cache-level config that is applied to all new
	// cache entries on admission. Default ttl value (24hrs) is applied if not
	// specified in the create request.
	Ttl *durationpb.Duration `protobuf:"bytes,3,opt,name=ttl,proto3,oneof" json:"ttl,omitempty"`
	// Anywhere Cache entry Admission Policy in kebab-case (e.g.,
	// "admit-on-first-miss"). Default admission policy (admit-on-first-miss) is
	// applied if not specified in the create request.
	AdmissionPolicy *string `protobuf:"bytes,5,opt,name=admission_policy,json=admissionPolicy,proto3,oneof" json:"admission_policy,omitempty"`
}

func (x *CreateAnywhereCacheMetadata) Reset() {
	*x = CreateAnywhereCacheMetadata{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateAnywhereCacheMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnywhereCacheMetadata) ProtoMessage() {}

func (x *CreateAnywhereCacheMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnywhereCacheMetadata.ProtoReflect.Descriptor instead.
func (*CreateAnywhereCacheMetadata) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{18}
}

func (x *CreateAnywhereCacheMetadata) GetCommonMetadata() *CommonLongRunningOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

func (x *CreateAnywhereCacheMetadata) GetAnywhereCacheId() string {
	if x != nil && x.AnywhereCacheId != nil {
		return *x.AnywhereCacheId
	}
	return ""
}

func (x *CreateAnywhereCacheMetadata) GetZone() string {
	if x != nil && x.Zone != nil {
		return *x.Zone
	}
	return ""
}

func (x *CreateAnywhereCacheMetadata) GetTtl() *durationpb.Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

func (x *CreateAnywhereCacheMetadata) GetAdmissionPolicy() string {
	if x != nil && x.AdmissionPolicy != nil {
		return *x.AdmissionPolicy
	}
	return ""
}

// Message returned in the metadata field of the Operation resource for
// UpdateAnywhereCache operation.
type UpdateAnywhereCacheMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Generic metadata for the long running operation.
	CommonMetadata *CommonLongRunningOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
	// Anywhere Cache ID.
	AnywhereCacheId *string `protobuf:"bytes,2,opt,name=anywhere_cache_id,json=anywhereCacheId,proto3,oneof" json:"anywhere_cache_id,omitempty"`
	// The zone in which the cache instance is running. For example,
	// us-central1-a.
	Zone *string `protobuf:"bytes,5,opt,name=zone,proto3,oneof" json:"zone,omitempty"`
	// Anywhere Cache entry's TTL between 1h and 7days. A cache-level config that
	// is applied to all new cache entries on admission. If `ttl` is pending
	// update, this field equals to the new value specified in the Update request.
	Ttl *durationpb.Duration `protobuf:"bytes,3,opt,name=ttl,proto3,oneof" json:"ttl,omitempty"`
	// L4 Cache entry Admission Policy in kebab-case (e.g.,
	// "admit-on-first-miss"). If `admission_policy` is pending
	// update, this field equals to the new value specified in the Update request.
	AdmissionPolicy *string `protobuf:"bytes,4,opt,name=admission_policy,json=admissionPolicy,proto3,oneof" json:"admission_policy,omitempty"`
}

func (x *UpdateAnywhereCacheMetadata) Reset() {
	*x = UpdateAnywhereCacheMetadata{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateAnywhereCacheMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAnywhereCacheMetadata) ProtoMessage() {}

func (x *UpdateAnywhereCacheMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAnywhereCacheMetadata.ProtoReflect.Descriptor instead.
func (*UpdateAnywhereCacheMetadata) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{19}
}

func (x *UpdateAnywhereCacheMetadata) GetCommonMetadata() *CommonLongRunningOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

func (x *UpdateAnywhereCacheMetadata) GetAnywhereCacheId() string {
	if x != nil && x.AnywhereCacheId != nil {
		return *x.AnywhereCacheId
	}
	return ""
}

func (x *UpdateAnywhereCacheMetadata) GetZone() string {
	if x != nil && x.Zone != nil {
		return *x.Zone
	}
	return ""
}

func (x *UpdateAnywhereCacheMetadata) GetTtl() *durationpb.Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

func (x *UpdateAnywhereCacheMetadata) GetAdmissionPolicy() string {
	if x != nil && x.AdmissionPolicy != nil {
		return *x.AdmissionPolicy
	}
	return ""
}

// An Anywhere Cache Instance.
type AnywhereCache struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of this AnywhereCache.
	// Format:
	// `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. The zone in which the cache instance is running. For example,
	// us-central1-a.
	Zone string `protobuf:"bytes,10,opt,name=zone,proto3" json:"zone,omitempty"`
	// Cache entry TTL (ranges between 1h to 7d). This is a cache-level config
	// that defines how long a cache entry can live. Default ttl value (24hrs)
	// is applied if not specified in the create request. TTL must be in whole
	// seconds.
	Ttl *durationpb.Duration `protobuf:"bytes,3,opt,name=ttl,proto3" json:"ttl,omitempty"`
	// Cache admission policy. Valid policies includes:
	// `admit-on-first-miss` and `admit-on-second-miss`. Defaults to
	// `admit-on-first-miss`. Default value is applied if not specified in the
	// create request.
	AdmissionPolicy string `protobuf:"bytes,9,opt,name=admission_policy,json=admissionPolicy,proto3" json:"admission_policy,omitempty"`
	// Output only. Cache state including RUNNING, CREATING, DISABLED and PAUSED.
	State string `protobuf:"bytes,5,opt,name=state,proto3" json:"state,omitempty"`
	// Output only. Time when Anywhere cache instance is allocated.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when Anywhere cache instance is last updated, including
	// creation.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. True if there is an active update operation against this cache
	// instance. Subsequential update requests will be rejected if this field is
	// true. Output only.
	PendingUpdate bool `protobuf:"varint,8,opt,name=pending_update,json=pendingUpdate,proto3" json:"pending_update,omitempty"`
}

func (x *AnywhereCache) Reset() {
	*x = AnywhereCache{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AnywhereCache) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnywhereCache) ProtoMessage() {}

func (x *AnywhereCache) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnywhereCache.ProtoReflect.Descriptor instead.
func (*AnywhereCache) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{20}
}

func (x *AnywhereCache) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AnywhereCache) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *AnywhereCache) GetTtl() *durationpb.Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

func (x *AnywhereCache) GetAdmissionPolicy() string {
	if x != nil {
		return x.AdmissionPolicy
	}
	return ""
}

func (x *AnywhereCache) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *AnywhereCache) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AnywhereCache) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AnywhereCache) GetPendingUpdate() bool {
	if x != nil {
		return x.PendingUpdate
	}
	return false
}

// Request message for CreateAnywhereCache.
type CreateAnywhereCacheRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The bucket to which this cache belongs.
	// Format: `projects/{project}/buckets/{bucket}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Properties of the Anywhere Cache instance being created.
	// The parent bucket name is specified in the `parent` field. Server uses the
	// default value of `ttl` or `admission_policy` if not specified in
	// request.
	AnywhereCache *AnywhereCache `protobuf:"bytes,3,opt,name=anywhere_cache,json=anywhereCache,proto3" json:"anywhere_cache,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted. This request is only
	// idempotent if a `request_id` is provided.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateAnywhereCacheRequest) Reset() {
	*x = CreateAnywhereCacheRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateAnywhereCacheRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnywhereCacheRequest) ProtoMessage() {}

func (x *CreateAnywhereCacheRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnywhereCacheRequest.ProtoReflect.Descriptor instead.
func (*CreateAnywhereCacheRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{21}
}

func (x *CreateAnywhereCacheRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAnywhereCacheRequest) GetAnywhereCache() *AnywhereCache {
	if x != nil {
		return x.AnywhereCache
	}
	return nil
}

func (x *CreateAnywhereCacheRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for UpdateAnywhereCache.
type UpdateAnywhereCacheRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Anywhere Cache instance to be updated.
	AnywhereCache *AnywhereCache `protobuf:"bytes,1,opt,name=anywhere_cache,json=anywhereCache,proto3" json:"anywhere_cache,omitempty"`
	// Required. List of fields to be updated. Mutable fields of AnywhereCache
	// include `ttl` and `admission_policy`.
	//
	// To specify ALL fields, specify a single field with the value `*`. Note: We
	// recommend against doing this. If a new field is introduced at a later time,
	// an older client updating with the `*` may accidentally reset the new
	// field's value.
	//
	// Not specifying any fields is an error.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted. This request is only
	// idempotent if a `request_id` is provided.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateAnywhereCacheRequest) Reset() {
	*x = UpdateAnywhereCacheRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateAnywhereCacheRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAnywhereCacheRequest) ProtoMessage() {}

func (x *UpdateAnywhereCacheRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAnywhereCacheRequest.ProtoReflect.Descriptor instead.
func (*UpdateAnywhereCacheRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{22}
}

func (x *UpdateAnywhereCacheRequest) GetAnywhereCache() *AnywhereCache {
	if x != nil {
		return x.AnywhereCache
	}
	return nil
}

func (x *UpdateAnywhereCacheRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateAnywhereCacheRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for DisableAnywhereCache.
type DisableAnywhereCacheRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name field in the request should be:
	// `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted. This request is only
	// idempotent if a `request_id` is provided.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DisableAnywhereCacheRequest) Reset() {
	*x = DisableAnywhereCacheRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisableAnywhereCacheRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableAnywhereCacheRequest) ProtoMessage() {}

func (x *DisableAnywhereCacheRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableAnywhereCacheRequest.ProtoReflect.Descriptor instead.
func (*DisableAnywhereCacheRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{23}
}

func (x *DisableAnywhereCacheRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DisableAnywhereCacheRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for PauseAnywhereCache.
type PauseAnywhereCacheRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name field in the request should be:
	// `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted. This request is only
	// idempotent if a `request_id` is provided.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *PauseAnywhereCacheRequest) Reset() {
	*x = PauseAnywhereCacheRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PauseAnywhereCacheRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PauseAnywhereCacheRequest) ProtoMessage() {}

func (x *PauseAnywhereCacheRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PauseAnywhereCacheRequest.ProtoReflect.Descriptor instead.
func (*PauseAnywhereCacheRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{24}
}

func (x *PauseAnywhereCacheRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PauseAnywhereCacheRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for ResumeAnywhereCache.
type ResumeAnywhereCacheRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name field in the request should be:
	// `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted. This request is only
	// idempotent if a `request_id` is provided.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ResumeAnywhereCacheRequest) Reset() {
	*x = ResumeAnywhereCacheRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResumeAnywhereCacheRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResumeAnywhereCacheRequest) ProtoMessage() {}

func (x *ResumeAnywhereCacheRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResumeAnywhereCacheRequest.ProtoReflect.Descriptor instead.
func (*ResumeAnywhereCacheRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{25}
}

func (x *ResumeAnywhereCacheRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ResumeAnywhereCacheRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for GetAnywhereCache.
type GetAnywhereCacheRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name field in the request should be:
	// `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *GetAnywhereCacheRequest) Reset() {
	*x = GetAnywhereCacheRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAnywhereCacheRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAnywhereCacheRequest) ProtoMessage() {}

func (x *GetAnywhereCacheRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAnywhereCacheRequest.ProtoReflect.Descriptor instead.
func (*GetAnywhereCacheRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{26}
}

func (x *GetAnywhereCacheRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetAnywhereCacheRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for ListAnywhereCaches.
type ListAnywhereCachesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The bucket to which this cache belongs.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of caches to return in a single response.
	// The service will use this parameter or 1,000 items, whichever is smaller.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A previously-returned page token representing part of the larger set of
	// results to view.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A unique identifier for this request. UUID is the recommended
	// format, but other formats are still accepted.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ListAnywhereCachesRequest) Reset() {
	*x = ListAnywhereCachesRequest{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAnywhereCachesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnywhereCachesRequest) ProtoMessage() {}

func (x *ListAnywhereCachesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnywhereCachesRequest.ProtoReflect.Descriptor instead.
func (*ListAnywhereCachesRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{27}
}

func (x *ListAnywhereCachesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAnywhereCachesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAnywhereCachesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAnywhereCachesRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Response message for ListAnywhereCaches.
type ListAnywhereCachesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of items.
	AnywhereCaches []*AnywhereCache `protobuf:"bytes,1,rep,name=anywhere_caches,json=anywhereCaches,proto3" json:"anywhere_caches,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAnywhereCachesResponse) Reset() {
	*x = ListAnywhereCachesResponse{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAnywhereCachesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnywhereCachesResponse) ProtoMessage() {}

func (x *ListAnywhereCachesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnywhereCachesResponse.ProtoReflect.Descriptor instead.
func (*ListAnywhereCachesResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{28}
}

func (x *ListAnywhereCachesResponse) GetAnywhereCaches() []*AnywhereCache {
	if x != nil {
		return x.AnywhereCaches
	}
	return nil
}

func (x *ListAnywhereCachesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Configuration for Custom Dual Regions.  It should specify precisely two
// eligible regions within the same Multiregion. More information on regions
// may be found [here](https://cloud.google.com/storage/docs/locations).
type StorageLayout_CustomPlacementConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of locations to use for data placement.
	DataLocations []string `protobuf:"bytes,1,rep,name=data_locations,json=dataLocations,proto3" json:"data_locations,omitempty"`
}

func (x *StorageLayout_CustomPlacementConfig) Reset() {
	*x = StorageLayout_CustomPlacementConfig{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageLayout_CustomPlacementConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageLayout_CustomPlacementConfig) ProtoMessage() {}

func (x *StorageLayout_CustomPlacementConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageLayout_CustomPlacementConfig.ProtoReflect.Descriptor instead.
func (*StorageLayout_CustomPlacementConfig) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{10, 0}
}

func (x *StorageLayout_CustomPlacementConfig) GetDataLocations() []string {
	if x != nil {
		return x.DataLocations
	}
	return nil
}

// Configuration for a bucket's hierarchical namespace feature.
type StorageLayout_HierarchicalNamespace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enables the hierarchical namespace feature.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *StorageLayout_HierarchicalNamespace) Reset() {
	*x = StorageLayout_HierarchicalNamespace{}
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StorageLayout_HierarchicalNamespace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageLayout_HierarchicalNamespace) ProtoMessage() {}

func (x *StorageLayout_HierarchicalNamespace) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_control_v2_storage_control_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageLayout_HierarchicalNamespace.ProtoReflect.Descriptor instead.
func (*StorageLayout_HierarchicalNamespace) Descriptor() ([]byte, []int) {
	return file_google_storage_control_v2_storage_control_proto_rawDescGZIP(), []int{10, 1}
}

func (x *StorageLayout_HierarchicalNamespace) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

var File_google_storage_control_v2_storage_control_proto protoreflect.FileDescriptor

var file_google_storage_control_v2_storage_control_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x36, 0x0a,
	0x11, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x21, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa3, 0x03, 0x0a, 0x06, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x0e, 0x6d, 0x65, 0x74,
	0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x13, 0x70, 0x65,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x2e, 0x76, 0x32, 0x2e, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x6e, 0x61, 0x6d,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x70, 0x65, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x3a, 0x6c, 0xea,
	0x41, 0x69, 0x0a, 0x1d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x12, 0x37, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x7d, 0x2f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x3d, 0x2a, 0x2a, 0x7d, 0x2a, 0x07, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x73, 0x32, 0x06, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x22, 0xb6, 0x02, 0x0a, 0x10,
	0x47, 0x65, 0x74, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x17, 0x69,
	0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x15,
	0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x88, 0x01, 0x01, 0x12, 0x42, 0x0a, 0x1b, 0x69, 0x66, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f,
	0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52,
	0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x69, 0x66, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x22, 0x85, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x21, 0x0a,
	0x09, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x69, 0x76, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x69, 0x76, 0x65,
	0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xb9, 0x02, 0x0a,
	0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x3b, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x48, 0x00, 0x52, 0x15, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x88, 0x01, 0x01, 0x12, 0x42, 0x0a, 0x1b,
	0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x01, 0x52, 0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x88, 0x01, 0x01,
	0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x42, 0x1a, 0x0a, 0x18,
	0x5f, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x69, 0x66, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e,
	0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x22, 0xed, 0x02, 0x0a, 0x12, 0x4c, 0x69, 0x73,
	0x74, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x12, 0x21, 0x0a, 0x09, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x64, 0x65, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x65, 0x72, 0x12, 0x34, 0x0a, 0x13, 0x6c, 0x65, 0x78, 0x69, 0x63, 0x6f, 0x67, 0x72,
	0x61, 0x70, 0x68, 0x69, 0x63, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x6c, 0x65, 0x78, 0x69, 0x63, 0x6f, 0x67, 0x72,
	0x61, 0x70, 0x68, 0x69, 0x63, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x30, 0x0a, 0x11, 0x6c, 0x65,
	0x78, 0x69, 0x63, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x5f, 0x65, 0x6e, 0x64, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6c, 0x65, 0x78, 0x69,
	0x63, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x45, 0x6e, 0x64, 0x12, 0x2a, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x7a, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74,
	0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3b, 0x0a, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x52, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xf2, 0x02, 0x0a, 0x13, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x46,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x1f, 0x0a, 0x1d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x15, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x3b, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x00, 0x52, 0x15, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x88, 0x01, 0x01, 0x12, 0x42, 0x0a,
	0x1b, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x03, 0x48, 0x01, 0x52, 0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x88, 0x01,
	0x01, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02,
	0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x42, 0x1a, 0x0a,
	0x18, 0x5f, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x69, 0x66,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x22, 0xe9, 0x02, 0x0a, 0x22, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x4c, 0x6f, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x22, 0xdc, 0x01, 0x0a, 0x14, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65,
	0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x66,
	0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4c, 0x6f, 0x6e, 0x67, 0x52, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x32, 0x0a, 0x15, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x13, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x49, 0x64, 0x22, 0xdc, 0x04, 0x0a, 0x0d, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1f, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x7b, 0x0a, 0x17, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x6c, 0x61, 0x63,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x15, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7a, 0x0a, 0x16, 0x68, 0x69, 0x65, 0x72, 0x61,
	0x72, 0x63, 0x68, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x61, 0x79, 0x6f, 0x75,
	0x74, 0x2e, 0x48, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x69, 0x63, 0x61, 0x6c, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x68, 0x69,
	0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x69, 0x63, 0x61, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x1a, 0x3e, 0x0a, 0x15, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x6c, 0x61,
	0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x25, 0x0a, 0x0e,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x1a, 0x31, 0x0a, 0x15, 0x48, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x69,
	0x63, 0x61, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x3a, 0x7b, 0xea, 0x41, 0x78, 0x0a, 0x24, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x61, 0x79, 0x6f, 0x75,
	0x74, 0x12, 0x31, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x7d, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x61,
	0x79, 0x6f, 0x75, 0x74, 0x2a, 0x0e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x61, 0x79,
	0x6f, 0x75, 0x74, 0x73, 0x32, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x61, 0x79,
	0x6f, 0x75, 0x74, 0x22, 0x9f, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0,
	0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xed, 0x02, 0x0a, 0x0d, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x2b, 0x0a, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6d,
	0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x3a, 0x91, 0x01, 0xea, 0x41, 0x8d, 0x01, 0x0a, 0x24, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x46,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x7d, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x2f, 0x7b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x3d, 0x2a, 0x2a, 0x7d, 0x2a, 0x0e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x32, 0x0d, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x22, 0xc4, 0x02, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x15, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x88, 0x01, 0x01,
	0x12, 0x42, 0x0a, 0x1b, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf,
	0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x1e, 0x0a, 0x1c,
	0x5f, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x22, 0x95, 0x02, 0x0a,
	0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x26, 0x12, 0x24, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x54, 0x0a, 0x0e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x2f, 0x0a, 0x11, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41,
	0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x22, 0xef, 0x02, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x15, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x88,
	0x01, 0x01, 0x12, 0x42, 0x0a, 0x1b, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x18, 0x69, 0x66, 0x4d, 0x65, 0x74,
	0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f,
	0x6e, 0x6f, 0x6e, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4e, 0x6f, 0x6e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x2a,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x69,
	0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x69, 0x66, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x22, 0xf0, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1b, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x2a, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x97, 0x01, 0x0a, 0x1a, 0x4c, 0x69,
	0x73, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x0f, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x0e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xed, 0x02, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e,
	0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x66, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4c,
	0x6f, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2f, 0x0a, 0x11, 0x61,
	0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0f, 0x61, 0x6e, 0x79, 0x77, 0x68, 0x65,
	0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04,
	0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x04, 0x7a, 0x6f,
	0x6e, 0x65, 0x88, 0x01, 0x01, 0x12, 0x30, 0x0a, 0x03, 0x74, 0x74, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x02, 0x52,
	0x03, 0x74, 0x74, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x2e, 0x0a, 0x10, 0x61, 0x64, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x03, 0x52, 0x0f, 0x61, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x88, 0x01, 0x01, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x61, 0x6e, 0x79, 0x77,
	0x68, 0x65, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x69, 0x64, 0x42, 0x07, 0x0a,
	0x05, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x74, 0x74, 0x6c, 0x42, 0x13,
	0x0a, 0x11, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x22, 0xed, 0x02, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e,
	0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x66, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4c,
	0x6f, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2f, 0x0a, 0x11, 0x61,
	0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0f, 0x61, 0x6e, 0x79, 0x77, 0x68, 0x65,
	0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04,
	0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x04, 0x7a, 0x6f,
	0x6e, 0x65, 0x88, 0x01, 0x01, 0x12, 0x30, 0x0a, 0x03, 0x74, 0x74, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x02, 0x52,
	0x03, 0x74, 0x74, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x2e, 0x0a, 0x10, 0x61, 0x64, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x03, 0x52, 0x0f, 0x61, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x88, 0x01, 0x01, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x61, 0x6e, 0x79, 0x77,
	0x68, 0x65, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x69, 0x64, 0x42, 0x07, 0x0a,
	0x05, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x74, 0x74, 0x6c, 0x42, 0x13,
	0x0a, 0x11, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x22, 0xf5, 0x03, 0x0a, 0x0d, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65,
	0x43, 0x61, 0x63, 0x68, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x2b, 0x0a, 0x03, 0x74, 0x74, 0x6c, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x03, 0x74, 0x74, 0x6c, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x61, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x19, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2a,
	0x0a, 0x0e, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x70, 0x65, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x8e, 0x01, 0xea, 0x41, 0x8a,
	0x01, 0x0a, 0x24, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65,
	0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x12, 0x43, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x2f, 0x7b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x7d, 0x2f, 0x61, 0x6e, 0x79,
	0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x6e, 0x79,
	0x77, 0x68, 0x65, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x7d, 0x2a, 0x0e, 0x61, 0x6e,
	0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x73, 0x32, 0x0d, 0x61, 0x6e,
	0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x22, 0xe4, 0x01, 0x0a, 0x1a,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61,
	0x63, 0x68, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x26, 0x12, 0x24, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x79, 0x77, 0x68,
	0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x54, 0x0a, 0x0e, 0x61, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x63,
	0x68, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63,
	0x68, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72,
	0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2,
	0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0xe0, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x79,
	0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x54, 0x0a, 0x0e, 0x61, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x5f, 0x63, 0x61,
	0x63, 0x68, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61,
	0x63, 0x68, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x6e, 0x79, 0x77, 0x68, 0x65,
	0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0,
	0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x8b, 0x01, 0x0a, 0x1b, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01,
	0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0x89, 0x01, 0x0a, 0x19, 0x50, 0x61, 0x75, 0x73, 0x65, 0x41, 0x6e, 0x79,
	0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7,
	0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0x8a, 0x01, 0x0a, 0x1a, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65,
	0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x79,
	0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x87, 0x01, 0x0a,
	0x17, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43,
	0x61, 0x63, 0x68, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b,
	0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xc9, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63,
	0x68, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2,
	0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0x97, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x79, 0x77, 0x68,
	0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x51, 0x0a, 0x0f, 0x61, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x5f, 0x63, 0x61,
	0x63, 0x68, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43,
	0x61, 0x63, 0x68, 0x65, 0x52, 0x0e, 0x61, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61,
	0x63, 0x68, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0x8b, 0x1a, 0x0a,
	0x0e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12,
	0x9a, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x22, 0x37, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x2c, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x8a,
	0xd3, 0xe4, 0x93, 0x02, 0x17, 0x12, 0x15, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x0b, 0x7b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x3d, 0x2a, 0x2a, 0x7d, 0x12, 0x8f, 0x01, 0x0a,
	0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x37, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x8a, 0xd3,
	0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x7b, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x2a, 0x2a, 0x12, 0x94,
	0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x22, 0x37, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x20, 0x7b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x2a, 0x2a, 0x12, 0x94, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76,
	0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x26, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x8a,
	0xd3, 0xe4, 0x93, 0x02, 0x17, 0x12, 0x15, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x0b, 0x7b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x3d, 0x2a, 0x2a, 0x7d, 0x12, 0xcd, 0x01, 0x0a,
	0x0c, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65,
	0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6e, 0xca, 0x41,
	0x1e, 0x0a, 0x06, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x14, 0x52, 0x65, 0x6e, 0x61, 0x6d,
	0x65, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x1a, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x8a, 0xd3, 0xe4, 0x93,
	0x02, 0x2a, 0x12, 0x28, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x7b, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x2a, 0x2a, 0x12, 0xa9, 0x01, 0x0a,
	0x10, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x61, 0x79, 0x6f, 0x75,
	0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65,
	0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x22,
	0x37, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x7b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x2a, 0x2a, 0x12, 0xbf, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x22, 0x47, 0xda, 0x41, 0x27, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x2c, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x8a, 0xd3, 0xe4,
	0x93, 0x02, 0x17, 0x12, 0x15, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x0b, 0x7b,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x3d, 0x2a, 0x2a, 0x7d, 0x12, 0x9d, 0x01, 0x0a, 0x13, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x37, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x2a,
	0x12, 0x28, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x7b, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x2a, 0x2a, 0x12, 0xa9, 0x01, 0x0a, 0x10, 0x47,
	0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x22, 0x37, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x7b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x2a, 0x2a, 0x12, 0xa9, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x12, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x26, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x17, 0x12, 0x15, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x0b, 0x7b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x3d, 0x2a,
	0x2a, 0x7d, 0x12, 0xd1, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x79,
	0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x79,
	0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x64, 0xca, 0x41, 0x2c, 0x0a, 0x0d, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43,
	0x61, 0x63, 0x68, 0x65, 0x12, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x79, 0x77,
	0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x15, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x6e, 0x79, 0x77, 0x68,
	0x65, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x17, 0x12,
	0x15, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x0b, 0x7b, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x3d, 0x2a, 0x2a, 0x7d, 0x12, 0xf9, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8b, 0x01, 0xca, 0x41, 0x2c, 0x0a, 0x0d, 0x41, 0x6e, 0x79, 0x77,
	0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x12, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1a, 0x61, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72,
	0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x0a, 0x13, 0x61, 0x6e, 0x79,
	0x77, 0x68, 0x65, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x20, 0x7b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x2a, 0x2a, 0x12, 0xb1, 0x01, 0x0a, 0x14, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x6e,
	0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x41,
	0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e,
	0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x22, 0x37, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x7b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x2a, 0x2a, 0x12, 0xad, 0x01, 0x0a, 0x12, 0x50, 0x61, 0x75, 0x73, 0x65,
	0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x12, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x61, 0x75, 0x73, 0x65, 0x41,
	0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e,
	0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x22, 0x37, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x7b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x2a, 0x2a, 0x12, 0xaf, 0x01, 0x0a, 0x13, 0x52, 0x65, 0x73, 0x75, 0x6d,
	0x65, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6d,
	0x65, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76,
	0x32, 0x2e, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x22,
	0x37, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x7b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x2a, 0x2a, 0x12, 0xa9, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74,
	0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x12, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x79,
	0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e,
	0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x22, 0x37, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x20, 0x7b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x2a, 0x2a, 0x12, 0xa9, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x79,
	0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x79, 0x77,
	0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x6e, 0x79, 0x77, 0x68, 0x65, 0x72, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x26, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x17, 0x12, 0x15, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x0b, 0x7b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x3d, 0x2a, 0x2a, 0x7d,
	0x1a, 0xa7, 0x02, 0xca, 0x41, 0x16, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x8a, 0x02,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x72, 0x65,
	0x61, 0x64, 0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x65, 0x76, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x64, 0x65, 0x76, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x5f,
	0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x65, 0x76, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x42, 0xa6, 0x02, 0xea, 0x41, 0x44,
	0x0a, 0x1d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12,
	0x23, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x7d, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x2e, 0x76, 0x32, 0x42, 0x13, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3d, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x70, 0x62, 0x3b,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x1f, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x5c, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x23,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x3a,
	0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_storage_control_v2_storage_control_proto_rawDescOnce sync.Once
	file_google_storage_control_v2_storage_control_proto_rawDescData = file_google_storage_control_v2_storage_control_proto_rawDesc
)

func file_google_storage_control_v2_storage_control_proto_rawDescGZIP() []byte {
	file_google_storage_control_v2_storage_control_proto_rawDescOnce.Do(func() {
		file_google_storage_control_v2_storage_control_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_storage_control_v2_storage_control_proto_rawDescData)
	})
	return file_google_storage_control_v2_storage_control_proto_rawDescData
}

var file_google_storage_control_v2_storage_control_proto_msgTypes = make([]protoimpl.MessageInfo, 31)
var file_google_storage_control_v2_storage_control_proto_goTypes = []any{
	(*PendingRenameInfo)(nil),                   // 0: google.storage.control.v2.PendingRenameInfo
	(*Folder)(nil),                              // 1: google.storage.control.v2.Folder
	(*GetFolderRequest)(nil),                    // 2: google.storage.control.v2.GetFolderRequest
	(*CreateFolderRequest)(nil),                 // 3: google.storage.control.v2.CreateFolderRequest
	(*DeleteFolderRequest)(nil),                 // 4: google.storage.control.v2.DeleteFolderRequest
	(*ListFoldersRequest)(nil),                  // 5: google.storage.control.v2.ListFoldersRequest
	(*ListFoldersResponse)(nil),                 // 6: google.storage.control.v2.ListFoldersResponse
	(*RenameFolderRequest)(nil),                 // 7: google.storage.control.v2.RenameFolderRequest
	(*CommonLongRunningOperationMetadata)(nil),  // 8: google.storage.control.v2.CommonLongRunningOperationMetadata
	(*RenameFolderMetadata)(nil),                // 9: google.storage.control.v2.RenameFolderMetadata
	(*StorageLayout)(nil),                       // 10: google.storage.control.v2.StorageLayout
	(*GetStorageLayoutRequest)(nil),             // 11: google.storage.control.v2.GetStorageLayoutRequest
	(*ManagedFolder)(nil),                       // 12: google.storage.control.v2.ManagedFolder
	(*GetManagedFolderRequest)(nil),             // 13: google.storage.control.v2.GetManagedFolderRequest
	(*CreateManagedFolderRequest)(nil),          // 14: google.storage.control.v2.CreateManagedFolderRequest
	(*DeleteManagedFolderRequest)(nil),          // 15: google.storage.control.v2.DeleteManagedFolderRequest
	(*ListManagedFoldersRequest)(nil),           // 16: google.storage.control.v2.ListManagedFoldersRequest
	(*ListManagedFoldersResponse)(nil),          // 17: google.storage.control.v2.ListManagedFoldersResponse
	(*CreateAnywhereCacheMetadata)(nil),         // 18: google.storage.control.v2.CreateAnywhereCacheMetadata
	(*UpdateAnywhereCacheMetadata)(nil),         // 19: google.storage.control.v2.UpdateAnywhereCacheMetadata
	(*AnywhereCache)(nil),                       // 20: google.storage.control.v2.AnywhereCache
	(*CreateAnywhereCacheRequest)(nil),          // 21: google.storage.control.v2.CreateAnywhereCacheRequest
	(*UpdateAnywhereCacheRequest)(nil),          // 22: google.storage.control.v2.UpdateAnywhereCacheRequest
	(*DisableAnywhereCacheRequest)(nil),         // 23: google.storage.control.v2.DisableAnywhereCacheRequest
	(*PauseAnywhereCacheRequest)(nil),           // 24: google.storage.control.v2.PauseAnywhereCacheRequest
	(*ResumeAnywhereCacheRequest)(nil),          // 25: google.storage.control.v2.ResumeAnywhereCacheRequest
	(*GetAnywhereCacheRequest)(nil),             // 26: google.storage.control.v2.GetAnywhereCacheRequest
	(*ListAnywhereCachesRequest)(nil),           // 27: google.storage.control.v2.ListAnywhereCachesRequest
	(*ListAnywhereCachesResponse)(nil),          // 28: google.storage.control.v2.ListAnywhereCachesResponse
	(*StorageLayout_CustomPlacementConfig)(nil), // 29: google.storage.control.v2.StorageLayout.CustomPlacementConfig
	(*StorageLayout_HierarchicalNamespace)(nil), // 30: google.storage.control.v2.StorageLayout.HierarchicalNamespace
	(*timestamppb.Timestamp)(nil),               // 31: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                 // 32: google.protobuf.Duration
	(*fieldmaskpb.FieldMask)(nil),               // 33: google.protobuf.FieldMask
	(*emptypb.Empty)(nil),                       // 34: google.protobuf.Empty
	(*longrunningpb.Operation)(nil),             // 35: google.longrunning.Operation
}
var file_google_storage_control_v2_storage_control_proto_depIdxs = []int32{
	31, // 0: google.storage.control.v2.Folder.create_time:type_name -> google.protobuf.Timestamp
	31, // 1: google.storage.control.v2.Folder.update_time:type_name -> google.protobuf.Timestamp
	0,  // 2: google.storage.control.v2.Folder.pending_rename_info:type_name -> google.storage.control.v2.PendingRenameInfo
	1,  // 3: google.storage.control.v2.CreateFolderRequest.folder:type_name -> google.storage.control.v2.Folder
	1,  // 4: google.storage.control.v2.ListFoldersResponse.folders:type_name -> google.storage.control.v2.Folder
	31, // 5: google.storage.control.v2.CommonLongRunningOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	31, // 6: google.storage.control.v2.CommonLongRunningOperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	31, // 7: google.storage.control.v2.CommonLongRunningOperationMetadata.update_time:type_name -> google.protobuf.Timestamp
	8,  // 8: google.storage.control.v2.RenameFolderMetadata.common_metadata:type_name -> google.storage.control.v2.CommonLongRunningOperationMetadata
	29, // 9: google.storage.control.v2.StorageLayout.custom_placement_config:type_name -> google.storage.control.v2.StorageLayout.CustomPlacementConfig
	30, // 10: google.storage.control.v2.StorageLayout.hierarchical_namespace:type_name -> google.storage.control.v2.StorageLayout.HierarchicalNamespace
	31, // 11: google.storage.control.v2.ManagedFolder.create_time:type_name -> google.protobuf.Timestamp
	31, // 12: google.storage.control.v2.ManagedFolder.update_time:type_name -> google.protobuf.Timestamp
	12, // 13: google.storage.control.v2.CreateManagedFolderRequest.managed_folder:type_name -> google.storage.control.v2.ManagedFolder
	12, // 14: google.storage.control.v2.ListManagedFoldersResponse.managed_folders:type_name -> google.storage.control.v2.ManagedFolder
	8,  // 15: google.storage.control.v2.CreateAnywhereCacheMetadata.common_metadata:type_name -> google.storage.control.v2.CommonLongRunningOperationMetadata
	32, // 16: google.storage.control.v2.CreateAnywhereCacheMetadata.ttl:type_name -> google.protobuf.Duration
	8,  // 17: google.storage.control.v2.UpdateAnywhereCacheMetadata.common_metadata:type_name -> google.storage.control.v2.CommonLongRunningOperationMetadata
	32, // 18: google.storage.control.v2.UpdateAnywhereCacheMetadata.ttl:type_name -> google.protobuf.Duration
	32, // 19: google.storage.control.v2.AnywhereCache.ttl:type_name -> google.protobuf.Duration
	31, // 20: google.storage.control.v2.AnywhereCache.create_time:type_name -> google.protobuf.Timestamp
	31, // 21: google.storage.control.v2.AnywhereCache.update_time:type_name -> google.protobuf.Timestamp
	20, // 22: google.storage.control.v2.CreateAnywhereCacheRequest.anywhere_cache:type_name -> google.storage.control.v2.AnywhereCache
	20, // 23: google.storage.control.v2.UpdateAnywhereCacheRequest.anywhere_cache:type_name -> google.storage.control.v2.AnywhereCache
	33, // 24: google.storage.control.v2.UpdateAnywhereCacheRequest.update_mask:type_name -> google.protobuf.FieldMask
	20, // 25: google.storage.control.v2.ListAnywhereCachesResponse.anywhere_caches:type_name -> google.storage.control.v2.AnywhereCache
	3,  // 26: google.storage.control.v2.StorageControl.CreateFolder:input_type -> google.storage.control.v2.CreateFolderRequest
	4,  // 27: google.storage.control.v2.StorageControl.DeleteFolder:input_type -> google.storage.control.v2.DeleteFolderRequest
	2,  // 28: google.storage.control.v2.StorageControl.GetFolder:input_type -> google.storage.control.v2.GetFolderRequest
	5,  // 29: google.storage.control.v2.StorageControl.ListFolders:input_type -> google.storage.control.v2.ListFoldersRequest
	7,  // 30: google.storage.control.v2.StorageControl.RenameFolder:input_type -> google.storage.control.v2.RenameFolderRequest
	11, // 31: google.storage.control.v2.StorageControl.GetStorageLayout:input_type -> google.storage.control.v2.GetStorageLayoutRequest
	14, // 32: google.storage.control.v2.StorageControl.CreateManagedFolder:input_type -> google.storage.control.v2.CreateManagedFolderRequest
	15, // 33: google.storage.control.v2.StorageControl.DeleteManagedFolder:input_type -> google.storage.control.v2.DeleteManagedFolderRequest
	13, // 34: google.storage.control.v2.StorageControl.GetManagedFolder:input_type -> google.storage.control.v2.GetManagedFolderRequest
	16, // 35: google.storage.control.v2.StorageControl.ListManagedFolders:input_type -> google.storage.control.v2.ListManagedFoldersRequest
	21, // 36: google.storage.control.v2.StorageControl.CreateAnywhereCache:input_type -> google.storage.control.v2.CreateAnywhereCacheRequest
	22, // 37: google.storage.control.v2.StorageControl.UpdateAnywhereCache:input_type -> google.storage.control.v2.UpdateAnywhereCacheRequest
	23, // 38: google.storage.control.v2.StorageControl.DisableAnywhereCache:input_type -> google.storage.control.v2.DisableAnywhereCacheRequest
	24, // 39: google.storage.control.v2.StorageControl.PauseAnywhereCache:input_type -> google.storage.control.v2.PauseAnywhereCacheRequest
	25, // 40: google.storage.control.v2.StorageControl.ResumeAnywhereCache:input_type -> google.storage.control.v2.ResumeAnywhereCacheRequest
	26, // 41: google.storage.control.v2.StorageControl.GetAnywhereCache:input_type -> google.storage.control.v2.GetAnywhereCacheRequest
	27, // 42: google.storage.control.v2.StorageControl.ListAnywhereCaches:input_type -> google.storage.control.v2.ListAnywhereCachesRequest
	1,  // 43: google.storage.control.v2.StorageControl.CreateFolder:output_type -> google.storage.control.v2.Folder
	34, // 44: google.storage.control.v2.StorageControl.DeleteFolder:output_type -> google.protobuf.Empty
	1,  // 45: google.storage.control.v2.StorageControl.GetFolder:output_type -> google.storage.control.v2.Folder
	6,  // 46: google.storage.control.v2.StorageControl.ListFolders:output_type -> google.storage.control.v2.ListFoldersResponse
	35, // 47: google.storage.control.v2.StorageControl.RenameFolder:output_type -> google.longrunning.Operation
	10, // 48: google.storage.control.v2.StorageControl.GetStorageLayout:output_type -> google.storage.control.v2.StorageLayout
	12, // 49: google.storage.control.v2.StorageControl.CreateManagedFolder:output_type -> google.storage.control.v2.ManagedFolder
	34, // 50: google.storage.control.v2.StorageControl.DeleteManagedFolder:output_type -> google.protobuf.Empty
	12, // 51: google.storage.control.v2.StorageControl.GetManagedFolder:output_type -> google.storage.control.v2.ManagedFolder
	17, // 52: google.storage.control.v2.StorageControl.ListManagedFolders:output_type -> google.storage.control.v2.ListManagedFoldersResponse
	35, // 53: google.storage.control.v2.StorageControl.CreateAnywhereCache:output_type -> google.longrunning.Operation
	35, // 54: google.storage.control.v2.StorageControl.UpdateAnywhereCache:output_type -> google.longrunning.Operation
	20, // 55: google.storage.control.v2.StorageControl.DisableAnywhereCache:output_type -> google.storage.control.v2.AnywhereCache
	20, // 56: google.storage.control.v2.StorageControl.PauseAnywhereCache:output_type -> google.storage.control.v2.AnywhereCache
	20, // 57: google.storage.control.v2.StorageControl.ResumeAnywhereCache:output_type -> google.storage.control.v2.AnywhereCache
	20, // 58: google.storage.control.v2.StorageControl.GetAnywhereCache:output_type -> google.storage.control.v2.AnywhereCache
	28, // 59: google.storage.control.v2.StorageControl.ListAnywhereCaches:output_type -> google.storage.control.v2.ListAnywhereCachesResponse
	43, // [43:60] is the sub-list for method output_type
	26, // [26:43] is the sub-list for method input_type
	26, // [26:26] is the sub-list for extension type_name
	26, // [26:26] is the sub-list for extension extendee
	0,  // [0:26] is the sub-list for field type_name
}

func init() { file_google_storage_control_v2_storage_control_proto_init() }
func file_google_storage_control_v2_storage_control_proto_init() {
	if File_google_storage_control_v2_storage_control_proto != nil {
		return
	}
	file_google_storage_control_v2_storage_control_proto_msgTypes[2].OneofWrappers = []any{}
	file_google_storage_control_v2_storage_control_proto_msgTypes[4].OneofWrappers = []any{}
	file_google_storage_control_v2_storage_control_proto_msgTypes[7].OneofWrappers = []any{}
	file_google_storage_control_v2_storage_control_proto_msgTypes[13].OneofWrappers = []any{}
	file_google_storage_control_v2_storage_control_proto_msgTypes[15].OneofWrappers = []any{}
	file_google_storage_control_v2_storage_control_proto_msgTypes[18].OneofWrappers = []any{}
	file_google_storage_control_v2_storage_control_proto_msgTypes[19].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_storage_control_v2_storage_control_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   31,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_storage_control_v2_storage_control_proto_goTypes,
		DependencyIndexes: file_google_storage_control_v2_storage_control_proto_depIdxs,
		MessageInfos:      file_google_storage_control_v2_storage_control_proto_msgTypes,
	}.Build()
	File_google_storage_control_v2_storage_control_proto = out.File
	file_google_storage_control_v2_storage_control_proto_rawDesc = nil
	file_google_storage_control_v2_storage_control_proto_goTypes = nil
	file_google_storage_control_v2_storage_control_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// StorageControlClient is the client API for StorageControl service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StorageControlClient interface {
	// Creates a new folder. This operation is only applicable to a hierarchical
	// namespace enabled bucket.
	CreateFolder(ctx context.Context, in *CreateFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Permanently deletes an empty folder. This operation is only applicable to a
	// hierarchical namespace enabled bucket.
	DeleteFolder(ctx context.Context, in *DeleteFolderRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns metadata for the specified folder. This operation is only
	// applicable to a hierarchical namespace enabled bucket.
	GetFolder(ctx context.Context, in *GetFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Retrieves a list of folders. This operation is only applicable to a
	// hierarchical namespace enabled bucket.
	ListFolders(ctx context.Context, in *ListFoldersRequest, opts ...grpc.CallOption) (*ListFoldersResponse, error)
	// Renames a source folder to a destination folder. This operation is only
	// applicable to a hierarchical namespace enabled bucket. During a rename, the
	// source and destination folders are locked until the long running operation
	// completes.
	RenameFolder(ctx context.Context, in *RenameFolderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns the storage layout configuration for a given bucket.
	GetStorageLayout(ctx context.Context, in *GetStorageLayoutRequest, opts ...grpc.CallOption) (*StorageLayout, error)
	// Creates a new managed folder.
	CreateManagedFolder(ctx context.Context, in *CreateManagedFolderRequest, opts ...grpc.CallOption) (*ManagedFolder, error)
	// Permanently deletes an empty managed folder.
	DeleteManagedFolder(ctx context.Context, in *DeleteManagedFolderRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns metadata for the specified managed folder.
	GetManagedFolder(ctx context.Context, in *GetManagedFolderRequest, opts ...grpc.CallOption) (*ManagedFolder, error)
	// Retrieves a list of managed folders for a given bucket.
	ListManagedFolders(ctx context.Context, in *ListManagedFoldersRequest, opts ...grpc.CallOption) (*ListManagedFoldersResponse, error)
	// Creates an Anywhere Cache instance.
	CreateAnywhereCache(ctx context.Context, in *CreateAnywhereCacheRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an Anywhere Cache instance. Mutable fields include `ttl` and
	// `admission_policy`.
	UpdateAnywhereCache(ctx context.Context, in *UpdateAnywhereCacheRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Disables an Anywhere Cache instance. A disabled instance is read-only. The
	// disablement could be revoked by calling ResumeAnywhereCache. The cache
	// instance will be deleted automatically if it remains in the disabled state
	// for at least one hour.
	DisableAnywhereCache(ctx context.Context, in *DisableAnywhereCacheRequest, opts ...grpc.CallOption) (*AnywhereCache, error)
	// Pauses an Anywhere Cache instance.
	PauseAnywhereCache(ctx context.Context, in *PauseAnywhereCacheRequest, opts ...grpc.CallOption) (*AnywhereCache, error)
	// Resumes a disabled or paused Anywhere Cache instance.
	ResumeAnywhereCache(ctx context.Context, in *ResumeAnywhereCacheRequest, opts ...grpc.CallOption) (*AnywhereCache, error)
	// Gets an Anywhere Cache instance.
	GetAnywhereCache(ctx context.Context, in *GetAnywhereCacheRequest, opts ...grpc.CallOption) (*AnywhereCache, error)
	// Lists Anywhere Cache instances for a given bucket.
	ListAnywhereCaches(ctx context.Context, in *ListAnywhereCachesRequest, opts ...grpc.CallOption) (*ListAnywhereCachesResponse, error)
}

type storageControlClient struct {
	cc grpc.ClientConnInterface
}

func NewStorageControlClient(cc grpc.ClientConnInterface) StorageControlClient {
	return &storageControlClient{cc}
}

func (c *storageControlClient) CreateFolder(ctx context.Context, in *CreateFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/CreateFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) DeleteFolder(ctx context.Context, in *DeleteFolderRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/DeleteFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) GetFolder(ctx context.Context, in *GetFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/GetFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) ListFolders(ctx context.Context, in *ListFoldersRequest, opts ...grpc.CallOption) (*ListFoldersResponse, error) {
	out := new(ListFoldersResponse)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/ListFolders", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) RenameFolder(ctx context.Context, in *RenameFolderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/RenameFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) GetStorageLayout(ctx context.Context, in *GetStorageLayoutRequest, opts ...grpc.CallOption) (*StorageLayout, error) {
	out := new(StorageLayout)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/GetStorageLayout", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) CreateManagedFolder(ctx context.Context, in *CreateManagedFolderRequest, opts ...grpc.CallOption) (*ManagedFolder, error) {
	out := new(ManagedFolder)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/CreateManagedFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) DeleteManagedFolder(ctx context.Context, in *DeleteManagedFolderRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/DeleteManagedFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) GetManagedFolder(ctx context.Context, in *GetManagedFolderRequest, opts ...grpc.CallOption) (*ManagedFolder, error) {
	out := new(ManagedFolder)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/GetManagedFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) ListManagedFolders(ctx context.Context, in *ListManagedFoldersRequest, opts ...grpc.CallOption) (*ListManagedFoldersResponse, error) {
	out := new(ListManagedFoldersResponse)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/ListManagedFolders", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) CreateAnywhereCache(ctx context.Context, in *CreateAnywhereCacheRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/CreateAnywhereCache", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) UpdateAnywhereCache(ctx context.Context, in *UpdateAnywhereCacheRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/UpdateAnywhereCache", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) DisableAnywhereCache(ctx context.Context, in *DisableAnywhereCacheRequest, opts ...grpc.CallOption) (*AnywhereCache, error) {
	out := new(AnywhereCache)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/DisableAnywhereCache", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) PauseAnywhereCache(ctx context.Context, in *PauseAnywhereCacheRequest, opts ...grpc.CallOption) (*AnywhereCache, error) {
	out := new(AnywhereCache)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/PauseAnywhereCache", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) ResumeAnywhereCache(ctx context.Context, in *ResumeAnywhereCacheRequest, opts ...grpc.CallOption) (*AnywhereCache, error) {
	out := new(AnywhereCache)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/ResumeAnywhereCache", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) GetAnywhereCache(ctx context.Context, in *GetAnywhereCacheRequest, opts ...grpc.CallOption) (*AnywhereCache, error) {
	out := new(AnywhereCache)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/GetAnywhereCache", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageControlClient) ListAnywhereCaches(ctx context.Context, in *ListAnywhereCachesRequest, opts ...grpc.CallOption) (*ListAnywhereCachesResponse, error) {
	out := new(ListAnywhereCachesResponse)
	err := c.cc.Invoke(ctx, "/google.storage.control.v2.StorageControl/ListAnywhereCaches", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StorageControlServer is the server API for StorageControl service.
type StorageControlServer interface {
	// Creates a new folder. This operation is only applicable to a hierarchical
	// namespace enabled bucket.
	CreateFolder(context.Context, *CreateFolderRequest) (*Folder, error)
	// Permanently deletes an empty folder. This operation is only applicable to a
	// hierarchical namespace enabled bucket.
	DeleteFolder(context.Context, *DeleteFolderRequest) (*emptypb.Empty, error)
	// Returns metadata for the specified folder. This operation is only
	// applicable to a hierarchical namespace enabled bucket.
	GetFolder(context.Context, *GetFolderRequest) (*Folder, error)
	// Retrieves a list of folders. This operation is only applicable to a
	// hierarchical namespace enabled bucket.
	ListFolders(context.Context, *ListFoldersRequest) (*ListFoldersResponse, error)
	// Renames a source folder to a destination folder. This operation is only
	// applicable to a hierarchical namespace enabled bucket. During a rename, the
	// source and destination folders are locked until the long running operation
	// completes.
	RenameFolder(context.Context, *RenameFolderRequest) (*longrunningpb.Operation, error)
	// Returns the storage layout configuration for a given bucket.
	GetStorageLayout(context.Context, *GetStorageLayoutRequest) (*StorageLayout, error)
	// Creates a new managed folder.
	CreateManagedFolder(context.Context, *CreateManagedFolderRequest) (*ManagedFolder, error)
	// Permanently deletes an empty managed folder.
	DeleteManagedFolder(context.Context, *DeleteManagedFolderRequest) (*emptypb.Empty, error)
	// Returns metadata for the specified managed folder.
	GetManagedFolder(context.Context, *GetManagedFolderRequest) (*ManagedFolder, error)
	// Retrieves a list of managed folders for a given bucket.
	ListManagedFolders(context.Context, *ListManagedFoldersRequest) (*ListManagedFoldersResponse, error)
	// Creates an Anywhere Cache instance.
	CreateAnywhereCache(context.Context, *CreateAnywhereCacheRequest) (*longrunningpb.Operation, error)
	// Updates an Anywhere Cache instance. Mutable fields include `ttl` and
	// `admission_policy`.
	UpdateAnywhereCache(context.Context, *UpdateAnywhereCacheRequest) (*longrunningpb.Operation, error)
	// Disables an Anywhere Cache instance. A disabled instance is read-only. The
	// disablement could be revoked by calling ResumeAnywhereCache. The cache
	// instance will be deleted automatically if it remains in the disabled state
	// for at least one hour.
	DisableAnywhereCache(context.Context, *DisableAnywhereCacheRequest) (*AnywhereCache, error)
	// Pauses an Anywhere Cache instance.
	PauseAnywhereCache(context.Context, *PauseAnywhereCacheRequest) (*AnywhereCache, error)
	// Resumes a disabled or paused Anywhere Cache instance.
	ResumeAnywhereCache(context.Context, *ResumeAnywhereCacheRequest) (*AnywhereCache, error)
	// Gets an Anywhere Cache instance.
	GetAnywhereCache(context.Context, *GetAnywhereCacheRequest) (*AnywhereCache, error)
	// Lists Anywhere Cache instances for a given bucket.
	ListAnywhereCaches(context.Context, *ListAnywhereCachesRequest) (*ListAnywhereCachesResponse, error)
}

// UnimplementedStorageControlServer can be embedded to have forward compatible implementations.
type UnimplementedStorageControlServer struct {
}

func (*UnimplementedStorageControlServer) CreateFolder(context.Context, *CreateFolderRequest) (*Folder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFolder not implemented")
}
func (*UnimplementedStorageControlServer) DeleteFolder(context.Context, *DeleteFolderRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFolder not implemented")
}
func (*UnimplementedStorageControlServer) GetFolder(context.Context, *GetFolderRequest) (*Folder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFolder not implemented")
}
func (*UnimplementedStorageControlServer) ListFolders(context.Context, *ListFoldersRequest) (*ListFoldersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFolders not implemented")
}
func (*UnimplementedStorageControlServer) RenameFolder(context.Context, *RenameFolderRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameFolder not implemented")
}
func (*UnimplementedStorageControlServer) GetStorageLayout(context.Context, *GetStorageLayoutRequest) (*StorageLayout, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStorageLayout not implemented")
}
func (*UnimplementedStorageControlServer) CreateManagedFolder(context.Context, *CreateManagedFolderRequest) (*ManagedFolder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateManagedFolder not implemented")
}
func (*UnimplementedStorageControlServer) DeleteManagedFolder(context.Context, *DeleteManagedFolderRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteManagedFolder not implemented")
}
func (*UnimplementedStorageControlServer) GetManagedFolder(context.Context, *GetManagedFolderRequest) (*ManagedFolder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetManagedFolder not implemented")
}
func (*UnimplementedStorageControlServer) ListManagedFolders(context.Context, *ListManagedFoldersRequest) (*ListManagedFoldersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListManagedFolders not implemented")
}
func (*UnimplementedStorageControlServer) CreateAnywhereCache(context.Context, *CreateAnywhereCacheRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAnywhereCache not implemented")
}
func (*UnimplementedStorageControlServer) UpdateAnywhereCache(context.Context, *UpdateAnywhereCacheRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAnywhereCache not implemented")
}
func (*UnimplementedStorageControlServer) DisableAnywhereCache(context.Context, *DisableAnywhereCacheRequest) (*AnywhereCache, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableAnywhereCache not implemented")
}
func (*UnimplementedStorageControlServer) PauseAnywhereCache(context.Context, *PauseAnywhereCacheRequest) (*AnywhereCache, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PauseAnywhereCache not implemented")
}
func (*UnimplementedStorageControlServer) ResumeAnywhereCache(context.Context, *ResumeAnywhereCacheRequest) (*AnywhereCache, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeAnywhereCache not implemented")
}
func (*UnimplementedStorageControlServer) GetAnywhereCache(context.Context, *GetAnywhereCacheRequest) (*AnywhereCache, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAnywhereCache not implemented")
}
func (*UnimplementedStorageControlServer) ListAnywhereCaches(context.Context, *ListAnywhereCachesRequest) (*ListAnywhereCachesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAnywhereCaches not implemented")
}

func RegisterStorageControlServer(s *grpc.Server, srv StorageControlServer) {
	s.RegisterService(&_StorageControl_serviceDesc, srv)
}

func _StorageControl_CreateFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).CreateFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/CreateFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).CreateFolder(ctx, req.(*CreateFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_DeleteFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).DeleteFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/DeleteFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).DeleteFolder(ctx, req.(*DeleteFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_GetFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).GetFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/GetFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).GetFolder(ctx, req.(*GetFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_ListFolders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFoldersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).ListFolders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/ListFolders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).ListFolders(ctx, req.(*ListFoldersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_RenameFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).RenameFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/RenameFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).RenameFolder(ctx, req.(*RenameFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_GetStorageLayout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStorageLayoutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).GetStorageLayout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/GetStorageLayout",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).GetStorageLayout(ctx, req.(*GetStorageLayoutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_CreateManagedFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateManagedFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).CreateManagedFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/CreateManagedFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).CreateManagedFolder(ctx, req.(*CreateManagedFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_DeleteManagedFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteManagedFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).DeleteManagedFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/DeleteManagedFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).DeleteManagedFolder(ctx, req.(*DeleteManagedFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_GetManagedFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetManagedFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).GetManagedFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/GetManagedFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).GetManagedFolder(ctx, req.(*GetManagedFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_ListManagedFolders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListManagedFoldersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).ListManagedFolders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/ListManagedFolders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).ListManagedFolders(ctx, req.(*ListManagedFoldersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_CreateAnywhereCache_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnywhereCacheRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).CreateAnywhereCache(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/CreateAnywhereCache",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).CreateAnywhereCache(ctx, req.(*CreateAnywhereCacheRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_UpdateAnywhereCache_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAnywhereCacheRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).UpdateAnywhereCache(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/UpdateAnywhereCache",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).UpdateAnywhereCache(ctx, req.(*UpdateAnywhereCacheRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_DisableAnywhereCache_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableAnywhereCacheRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).DisableAnywhereCache(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/DisableAnywhereCache",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).DisableAnywhereCache(ctx, req.(*DisableAnywhereCacheRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_PauseAnywhereCache_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseAnywhereCacheRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).PauseAnywhereCache(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/PauseAnywhereCache",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).PauseAnywhereCache(ctx, req.(*PauseAnywhereCacheRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_ResumeAnywhereCache_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeAnywhereCacheRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).ResumeAnywhereCache(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/ResumeAnywhereCache",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).ResumeAnywhereCache(ctx, req.(*ResumeAnywhereCacheRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_GetAnywhereCache_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnywhereCacheRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).GetAnywhereCache(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/GetAnywhereCache",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).GetAnywhereCache(ctx, req.(*GetAnywhereCacheRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageControl_ListAnywhereCaches_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnywhereCachesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageControlServer).ListAnywhereCaches(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.control.v2.StorageControl/ListAnywhereCaches",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageControlServer).ListAnywhereCaches(ctx, req.(*ListAnywhereCachesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _StorageControl_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.storage.control.v2.StorageControl",
	HandlerType: (*StorageControlServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateFolder",
			Handler:    _StorageControl_CreateFolder_Handler,
		},
		{
			MethodName: "DeleteFolder",
			Handler:    _StorageControl_DeleteFolder_Handler,
		},
		{
			MethodName: "GetFolder",
			Handler:    _StorageControl_GetFolder_Handler,
		},
		{
			MethodName: "ListFolders",
			Handler:    _StorageControl_ListFolders_Handler,
		},
		{
			MethodName: "RenameFolder",
			Handler:    _StorageControl_RenameFolder_Handler,
		},
		{
			MethodName: "GetStorageLayout",
			Handler:    _StorageControl_GetStorageLayout_Handler,
		},
		{
			MethodName: "CreateManagedFolder",
			Handler:    _StorageControl_CreateManagedFolder_Handler,
		},
		{
			MethodName: "DeleteManagedFolder",
			Handler:    _StorageControl_DeleteManagedFolder_Handler,
		},
		{
			MethodName: "GetManagedFolder",
			Handler:    _StorageControl_GetManagedFolder_Handler,
		},
		{
			MethodName: "ListManagedFolders",
			Handler:    _StorageControl_ListManagedFolders_Handler,
		},
		{
			MethodName: "CreateAnywhereCache",
			Handler:    _StorageControl_CreateAnywhereCache_Handler,
		},
		{
			MethodName: "UpdateAnywhereCache",
			Handler:    _StorageControl_UpdateAnywhereCache_Handler,
		},
		{
			MethodName: "DisableAnywhereCache",
			Handler:    _StorageControl_DisableAnywhereCache_Handler,
		},
		{
			MethodName: "PauseAnywhereCache",
			Handler:    _StorageControl_PauseAnywhereCache_Handler,
		},
		{
			MethodName: "ResumeAnywhereCache",
			Handler:    _StorageControl_ResumeAnywhereCache_Handler,
		},
		{
			MethodName: "GetAnywhereCache",
			Handler:    _StorageControl_GetAnywhereCache_Handler,
		},
		{
			MethodName: "ListAnywhereCaches",
			Handler:    _StorageControl_ListAnywhereCaches_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/storage/control/v2/storage_control.proto",
}
