// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/vmwareengine/v1/vmwareengine.proto

package vmwareenginepb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	VmwareEngine_ListPrivateClouds_FullMethodName                   = "/google.cloud.vmwareengine.v1.VmwareEngine/ListPrivateClouds"
	VmwareEngine_GetPrivateCloud_FullMethodName                     = "/google.cloud.vmwareengine.v1.VmwareEngine/GetPrivateCloud"
	VmwareEngine_CreatePrivateCloud_FullMethodName                  = "/google.cloud.vmwareengine.v1.VmwareEngine/CreatePrivateCloud"
	VmwareEngine_UpdatePrivateCloud_FullMethodName                  = "/google.cloud.vmwareengine.v1.VmwareEngine/UpdatePrivateCloud"
	VmwareEngine_DeletePrivateCloud_FullMethodName                  = "/google.cloud.vmwareengine.v1.VmwareEngine/DeletePrivateCloud"
	VmwareEngine_UndeletePrivateCloud_FullMethodName                = "/google.cloud.vmwareengine.v1.VmwareEngine/UndeletePrivateCloud"
	VmwareEngine_ListClusters_FullMethodName                        = "/google.cloud.vmwareengine.v1.VmwareEngine/ListClusters"
	VmwareEngine_GetCluster_FullMethodName                          = "/google.cloud.vmwareengine.v1.VmwareEngine/GetCluster"
	VmwareEngine_CreateCluster_FullMethodName                       = "/google.cloud.vmwareengine.v1.VmwareEngine/CreateCluster"
	VmwareEngine_UpdateCluster_FullMethodName                       = "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateCluster"
	VmwareEngine_DeleteCluster_FullMethodName                       = "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteCluster"
	VmwareEngine_ListNodes_FullMethodName                           = "/google.cloud.vmwareengine.v1.VmwareEngine/ListNodes"
	VmwareEngine_GetNode_FullMethodName                             = "/google.cloud.vmwareengine.v1.VmwareEngine/GetNode"
	VmwareEngine_ListExternalAddresses_FullMethodName               = "/google.cloud.vmwareengine.v1.VmwareEngine/ListExternalAddresses"
	VmwareEngine_FetchNetworkPolicyExternalAddresses_FullMethodName = "/google.cloud.vmwareengine.v1.VmwareEngine/FetchNetworkPolicyExternalAddresses"
	VmwareEngine_GetExternalAddress_FullMethodName                  = "/google.cloud.vmwareengine.v1.VmwareEngine/GetExternalAddress"
	VmwareEngine_CreateExternalAddress_FullMethodName               = "/google.cloud.vmwareengine.v1.VmwareEngine/CreateExternalAddress"
	VmwareEngine_UpdateExternalAddress_FullMethodName               = "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateExternalAddress"
	VmwareEngine_DeleteExternalAddress_FullMethodName               = "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteExternalAddress"
	VmwareEngine_ListSubnets_FullMethodName                         = "/google.cloud.vmwareengine.v1.VmwareEngine/ListSubnets"
	VmwareEngine_GetSubnet_FullMethodName                           = "/google.cloud.vmwareengine.v1.VmwareEngine/GetSubnet"
	VmwareEngine_UpdateSubnet_FullMethodName                        = "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateSubnet"
	VmwareEngine_ListExternalAccessRules_FullMethodName             = "/google.cloud.vmwareengine.v1.VmwareEngine/ListExternalAccessRules"
	VmwareEngine_GetExternalAccessRule_FullMethodName               = "/google.cloud.vmwareengine.v1.VmwareEngine/GetExternalAccessRule"
	VmwareEngine_CreateExternalAccessRule_FullMethodName            = "/google.cloud.vmwareengine.v1.VmwareEngine/CreateExternalAccessRule"
	VmwareEngine_UpdateExternalAccessRule_FullMethodName            = "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateExternalAccessRule"
	VmwareEngine_DeleteExternalAccessRule_FullMethodName            = "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteExternalAccessRule"
	VmwareEngine_ListLoggingServers_FullMethodName                  = "/google.cloud.vmwareengine.v1.VmwareEngine/ListLoggingServers"
	VmwareEngine_GetLoggingServer_FullMethodName                    = "/google.cloud.vmwareengine.v1.VmwareEngine/GetLoggingServer"
	VmwareEngine_CreateLoggingServer_FullMethodName                 = "/google.cloud.vmwareengine.v1.VmwareEngine/CreateLoggingServer"
	VmwareEngine_UpdateLoggingServer_FullMethodName                 = "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateLoggingServer"
	VmwareEngine_DeleteLoggingServer_FullMethodName                 = "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteLoggingServer"
	VmwareEngine_ListNodeTypes_FullMethodName                       = "/google.cloud.vmwareengine.v1.VmwareEngine/ListNodeTypes"
	VmwareEngine_GetNodeType_FullMethodName                         = "/google.cloud.vmwareengine.v1.VmwareEngine/GetNodeType"
	VmwareEngine_ShowNsxCredentials_FullMethodName                  = "/google.cloud.vmwareengine.v1.VmwareEngine/ShowNsxCredentials"
	VmwareEngine_ShowVcenterCredentials_FullMethodName              = "/google.cloud.vmwareengine.v1.VmwareEngine/ShowVcenterCredentials"
	VmwareEngine_ResetNsxCredentials_FullMethodName                 = "/google.cloud.vmwareengine.v1.VmwareEngine/ResetNsxCredentials"
	VmwareEngine_ResetVcenterCredentials_FullMethodName             = "/google.cloud.vmwareengine.v1.VmwareEngine/ResetVcenterCredentials"
	VmwareEngine_GetDnsForwarding_FullMethodName                    = "/google.cloud.vmwareengine.v1.VmwareEngine/GetDnsForwarding"
	VmwareEngine_UpdateDnsForwarding_FullMethodName                 = "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateDnsForwarding"
	VmwareEngine_GetNetworkPeering_FullMethodName                   = "/google.cloud.vmwareengine.v1.VmwareEngine/GetNetworkPeering"
	VmwareEngine_ListNetworkPeerings_FullMethodName                 = "/google.cloud.vmwareengine.v1.VmwareEngine/ListNetworkPeerings"
	VmwareEngine_CreateNetworkPeering_FullMethodName                = "/google.cloud.vmwareengine.v1.VmwareEngine/CreateNetworkPeering"
	VmwareEngine_DeleteNetworkPeering_FullMethodName                = "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteNetworkPeering"
	VmwareEngine_UpdateNetworkPeering_FullMethodName                = "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateNetworkPeering"
	VmwareEngine_ListPeeringRoutes_FullMethodName                   = "/google.cloud.vmwareengine.v1.VmwareEngine/ListPeeringRoutes"
	VmwareEngine_CreateHcxActivationKey_FullMethodName              = "/google.cloud.vmwareengine.v1.VmwareEngine/CreateHcxActivationKey"
	VmwareEngine_ListHcxActivationKeys_FullMethodName               = "/google.cloud.vmwareengine.v1.VmwareEngine/ListHcxActivationKeys"
	VmwareEngine_GetHcxActivationKey_FullMethodName                 = "/google.cloud.vmwareengine.v1.VmwareEngine/GetHcxActivationKey"
	VmwareEngine_GetNetworkPolicy_FullMethodName                    = "/google.cloud.vmwareengine.v1.VmwareEngine/GetNetworkPolicy"
	VmwareEngine_ListNetworkPolicies_FullMethodName                 = "/google.cloud.vmwareengine.v1.VmwareEngine/ListNetworkPolicies"
	VmwareEngine_CreateNetworkPolicy_FullMethodName                 = "/google.cloud.vmwareengine.v1.VmwareEngine/CreateNetworkPolicy"
	VmwareEngine_UpdateNetworkPolicy_FullMethodName                 = "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateNetworkPolicy"
	VmwareEngine_DeleteNetworkPolicy_FullMethodName                 = "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteNetworkPolicy"
	VmwareEngine_ListManagementDnsZoneBindings_FullMethodName       = "/google.cloud.vmwareengine.v1.VmwareEngine/ListManagementDnsZoneBindings"
	VmwareEngine_GetManagementDnsZoneBinding_FullMethodName         = "/google.cloud.vmwareengine.v1.VmwareEngine/GetManagementDnsZoneBinding"
	VmwareEngine_CreateManagementDnsZoneBinding_FullMethodName      = "/google.cloud.vmwareengine.v1.VmwareEngine/CreateManagementDnsZoneBinding"
	VmwareEngine_UpdateManagementDnsZoneBinding_FullMethodName      = "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateManagementDnsZoneBinding"
	VmwareEngine_DeleteManagementDnsZoneBinding_FullMethodName      = "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteManagementDnsZoneBinding"
	VmwareEngine_RepairManagementDnsZoneBinding_FullMethodName      = "/google.cloud.vmwareengine.v1.VmwareEngine/RepairManagementDnsZoneBinding"
	VmwareEngine_CreateVmwareEngineNetwork_FullMethodName           = "/google.cloud.vmwareengine.v1.VmwareEngine/CreateVmwareEngineNetwork"
	VmwareEngine_UpdateVmwareEngineNetwork_FullMethodName           = "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateVmwareEngineNetwork"
	VmwareEngine_DeleteVmwareEngineNetwork_FullMethodName           = "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteVmwareEngineNetwork"
	VmwareEngine_GetVmwareEngineNetwork_FullMethodName              = "/google.cloud.vmwareengine.v1.VmwareEngine/GetVmwareEngineNetwork"
	VmwareEngine_ListVmwareEngineNetworks_FullMethodName            = "/google.cloud.vmwareengine.v1.VmwareEngine/ListVmwareEngineNetworks"
	VmwareEngine_CreatePrivateConnection_FullMethodName             = "/google.cloud.vmwareengine.v1.VmwareEngine/CreatePrivateConnection"
	VmwareEngine_GetPrivateConnection_FullMethodName                = "/google.cloud.vmwareengine.v1.VmwareEngine/GetPrivateConnection"
	VmwareEngine_ListPrivateConnections_FullMethodName              = "/google.cloud.vmwareengine.v1.VmwareEngine/ListPrivateConnections"
	VmwareEngine_UpdatePrivateConnection_FullMethodName             = "/google.cloud.vmwareengine.v1.VmwareEngine/UpdatePrivateConnection"
	VmwareEngine_DeletePrivateConnection_FullMethodName             = "/google.cloud.vmwareengine.v1.VmwareEngine/DeletePrivateConnection"
	VmwareEngine_ListPrivateConnectionPeeringRoutes_FullMethodName  = "/google.cloud.vmwareengine.v1.VmwareEngine/ListPrivateConnectionPeeringRoutes"
	VmwareEngine_GrantDnsBindPermission_FullMethodName              = "/google.cloud.vmwareengine.v1.VmwareEngine/GrantDnsBindPermission"
	VmwareEngine_GetDnsBindPermission_FullMethodName                = "/google.cloud.vmwareengine.v1.VmwareEngine/GetDnsBindPermission"
	VmwareEngine_RevokeDnsBindPermission_FullMethodName             = "/google.cloud.vmwareengine.v1.VmwareEngine/RevokeDnsBindPermission"
)

// VmwareEngineClient is the client API for VmwareEngine service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type VmwareEngineClient interface {
	// Lists `PrivateCloud` resources in a given project and location.
	ListPrivateClouds(ctx context.Context, in *ListPrivateCloudsRequest, opts ...grpc.CallOption) (*ListPrivateCloudsResponse, error)
	// Retrieves a `PrivateCloud` resource by its resource name.
	GetPrivateCloud(ctx context.Context, in *GetPrivateCloudRequest, opts ...grpc.CallOption) (*PrivateCloud, error)
	// Creates a new `PrivateCloud` resource in a given project and location.
	// Private clouds of type `STANDARD` and
	// `TIME_LIMITED` are zonal resources, `STRETCHED` private clouds are
	// regional.
	// Creating a private cloud also creates a [management
	// cluster](https://cloud.google.com/vmware-engine/docs/concepts-vmware-components)
	// for that private cloud.
	CreatePrivateCloud(ctx context.Context, in *CreatePrivateCloudRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Modifies a `PrivateCloud` resource. Only the following fields can be
	// updated: `description`.
	// Only fields specified in `updateMask` are applied.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdatePrivateCloud(ctx context.Context, in *UpdatePrivateCloudRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Schedules a `PrivateCloud` resource for deletion.
	//
	// A `PrivateCloud` resource scheduled for deletion has `PrivateCloud.state`
	// set to `DELETED` and `expireTime` set to the time when deletion is final
	// and can no longer be reversed. The delete operation is marked as done
	// as soon as the `PrivateCloud` is successfully scheduled for deletion
	// (this also applies when `delayHours` is set to zero), and the operation is
	// not kept in pending state until `PrivateCloud` is purged.
	// `PrivateCloud` can be restored using `UndeletePrivateCloud` method before
	// the `expireTime` elapses. When `expireTime` is reached, deletion is final
	// and all private cloud resources are irreversibly removed and billing stops.
	// During the final removal process, `PrivateCloud.state` is set to `PURGING`.
	// `PrivateCloud` can be polled using standard `GET` method for the whole
	// period of deletion and purging. It will not be returned only
	// when it is completely purged.
	DeletePrivateCloud(ctx context.Context, in *DeletePrivateCloudRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Restores a private cloud that was previously scheduled for deletion by
	// `DeletePrivateCloud`. A `PrivateCloud` resource scheduled for deletion has
	// `PrivateCloud.state` set to `DELETED` and `PrivateCloud.expireTime` set to
	// the time when deletion can no longer be reversed.
	UndeletePrivateCloud(ctx context.Context, in *UndeletePrivateCloudRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists `Cluster` resources in a given private cloud.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Retrieves a `Cluster` resource by its resource name.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Creates a new cluster in a given private cloud.
	// Creating a new cluster provides additional nodes for
	// use in the parent private cloud and requires sufficient [node
	// quota](https://cloud.google.com/vmware-engine/quotas).
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Modifies a `Cluster` resource. Only fields specified in `updateMask` are
	// applied.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a `Cluster` resource. To avoid unintended data loss, migrate or
	// gracefully shut down any workloads running on the cluster before deletion.
	// You cannot delete the management cluster of a private cloud using this
	// method.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists nodes in a given cluster.
	ListNodes(ctx context.Context, in *ListNodesRequest, opts ...grpc.CallOption) (*ListNodesResponse, error)
	// Gets details of a single node.
	GetNode(ctx context.Context, in *GetNodeRequest, opts ...grpc.CallOption) (*Node, error)
	// Lists external IP addresses assigned to VMware workload VMs in a given
	// private cloud.
	ListExternalAddresses(ctx context.Context, in *ListExternalAddressesRequest, opts ...grpc.CallOption) (*ListExternalAddressesResponse, error)
	// Lists external IP addresses assigned to VMware workload VMs within the
	// scope of the given network policy.
	FetchNetworkPolicyExternalAddresses(ctx context.Context, in *FetchNetworkPolicyExternalAddressesRequest, opts ...grpc.CallOption) (*FetchNetworkPolicyExternalAddressesResponse, error)
	// Gets details of a single external IP address.
	GetExternalAddress(ctx context.Context, in *GetExternalAddressRequest, opts ...grpc.CallOption) (*ExternalAddress, error)
	// Creates a new `ExternalAddress` resource in a given private cloud. The
	// network policy that corresponds to the private cloud must have the external
	// IP address network service enabled (`NetworkPolicy.external_ip`).
	CreateExternalAddress(ctx context.Context, in *CreateExternalAddressRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single external IP address.
	// Only fields specified in `update_mask` are applied.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdateExternalAddress(ctx context.Context, in *UpdateExternalAddressRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single external IP address. When you delete an external IP
	// address, connectivity between the external IP address and the corresponding
	// internal IP address is lost.
	DeleteExternalAddress(ctx context.Context, in *DeleteExternalAddressRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists subnets in a given private cloud.
	ListSubnets(ctx context.Context, in *ListSubnetsRequest, opts ...grpc.CallOption) (*ListSubnetsResponse, error)
	// Gets details of a single subnet.
	GetSubnet(ctx context.Context, in *GetSubnetRequest, opts ...grpc.CallOption) (*Subnet, error)
	// Updates the parameters of a single subnet. Only fields specified in
	// `update_mask` are applied.
	//
	// *Note*: This API is synchronous and always returns a successful
	// `google.longrunning.Operation` (LRO). The returned LRO will only have
	// `done` and `response` fields.
	UpdateSubnet(ctx context.Context, in *UpdateSubnetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists `ExternalAccessRule` resources in the specified network policy.
	ListExternalAccessRules(ctx context.Context, in *ListExternalAccessRulesRequest, opts ...grpc.CallOption) (*ListExternalAccessRulesResponse, error)
	// Gets details of a single external access rule.
	GetExternalAccessRule(ctx context.Context, in *GetExternalAccessRuleRequest, opts ...grpc.CallOption) (*ExternalAccessRule, error)
	// Creates a new external access rule in a given network policy.
	CreateExternalAccessRule(ctx context.Context, in *CreateExternalAccessRuleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single external access rule.
	// Only fields specified in `update_mask` are applied.
	UpdateExternalAccessRule(ctx context.Context, in *UpdateExternalAccessRuleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single external access rule.
	DeleteExternalAccessRule(ctx context.Context, in *DeleteExternalAccessRuleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists logging servers configured for a given private
	// cloud.
	ListLoggingServers(ctx context.Context, in *ListLoggingServersRequest, opts ...grpc.CallOption) (*ListLoggingServersResponse, error)
	// Gets details of a logging server.
	GetLoggingServer(ctx context.Context, in *GetLoggingServerRequest, opts ...grpc.CallOption) (*LoggingServer, error)
	// Create a new logging server for a given private cloud.
	CreateLoggingServer(ctx context.Context, in *CreateLoggingServerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single logging server.
	// Only fields specified in `update_mask` are applied.
	UpdateLoggingServer(ctx context.Context, in *UpdateLoggingServerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single logging server.
	DeleteLoggingServer(ctx context.Context, in *DeleteLoggingServerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists node types
	ListNodeTypes(ctx context.Context, in *ListNodeTypesRequest, opts ...grpc.CallOption) (*ListNodeTypesResponse, error)
	// Gets details of a single `NodeType`.
	GetNodeType(ctx context.Context, in *GetNodeTypeRequest, opts ...grpc.CallOption) (*NodeType, error)
	// Gets details of credentials for NSX appliance.
	ShowNsxCredentials(ctx context.Context, in *ShowNsxCredentialsRequest, opts ...grpc.CallOption) (*Credentials, error)
	// Gets details of credentials for Vcenter appliance.
	ShowVcenterCredentials(ctx context.Context, in *ShowVcenterCredentialsRequest, opts ...grpc.CallOption) (*Credentials, error)
	// Resets credentials of the NSX appliance.
	ResetNsxCredentials(ctx context.Context, in *ResetNsxCredentialsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Resets credentials of the Vcenter appliance.
	ResetVcenterCredentials(ctx context.Context, in *ResetVcenterCredentialsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of the `DnsForwarding` config.
	GetDnsForwarding(ctx context.Context, in *GetDnsForwardingRequest, opts ...grpc.CallOption) (*DnsForwarding, error)
	// Updates the parameters of the `DnsForwarding` config, like associated
	// domains. Only fields specified in `update_mask` are applied.
	UpdateDnsForwarding(ctx context.Context, in *UpdateDnsForwardingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retrieves a `NetworkPeering` resource by its resource name. The resource
	// contains details of the network peering, such as peered
	// networks, import and export custom route configurations, and peering state.
	// NetworkPeering is a global resource and location can only be global.
	GetNetworkPeering(ctx context.Context, in *GetNetworkPeeringRequest, opts ...grpc.CallOption) (*NetworkPeering, error)
	// Lists `NetworkPeering` resources in a given project. NetworkPeering is a
	// global resource and location can only be global.
	ListNetworkPeerings(ctx context.Context, in *ListNetworkPeeringsRequest, opts ...grpc.CallOption) (*ListNetworkPeeringsResponse, error)
	// Creates a new network peering between the peer network and VMware Engine
	// network provided in a `NetworkPeering` resource. NetworkPeering is a
	// global resource and location can only be global.
	CreateNetworkPeering(ctx context.Context, in *CreateNetworkPeeringRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a `NetworkPeering` resource. When a network peering is deleted for
	// a VMware Engine network, the peer network becomes inaccessible to that
	// VMware Engine network. NetworkPeering is a global resource and location can
	// only be global.
	DeleteNetworkPeering(ctx context.Context, in *DeleteNetworkPeeringRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Modifies a `NetworkPeering` resource. Only the `description` field can be
	// updated. Only fields specified in `updateMask` are applied. NetworkPeering
	// is a global resource and location can only be global.
	UpdateNetworkPeering(ctx context.Context, in *UpdateNetworkPeeringRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the network peering routes exchanged over a peering connection.
	// NetworkPeering is a global resource and location can only be global.
	ListPeeringRoutes(ctx context.Context, in *ListPeeringRoutesRequest, opts ...grpc.CallOption) (*ListPeeringRoutesResponse, error)
	// Creates a new HCX activation key in a given private cloud.
	CreateHcxActivationKey(ctx context.Context, in *CreateHcxActivationKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists `HcxActivationKey` resources in a given private cloud.
	ListHcxActivationKeys(ctx context.Context, in *ListHcxActivationKeysRequest, opts ...grpc.CallOption) (*ListHcxActivationKeysResponse, error)
	// Retrieves a `HcxActivationKey` resource by its resource name.
	GetHcxActivationKey(ctx context.Context, in *GetHcxActivationKeyRequest, opts ...grpc.CallOption) (*HcxActivationKey, error)
	// Retrieves a `NetworkPolicy` resource by its resource name.
	GetNetworkPolicy(ctx context.Context, in *GetNetworkPolicyRequest, opts ...grpc.CallOption) (*NetworkPolicy, error)
	// Lists `NetworkPolicy` resources in a specified project and location.
	ListNetworkPolicies(ctx context.Context, in *ListNetworkPoliciesRequest, opts ...grpc.CallOption) (*ListNetworkPoliciesResponse, error)
	// Creates a new network policy in a given VMware Engine network of a
	// project and location (region). A new network policy cannot be created if
	// another network policy already exists in the same scope.
	CreateNetworkPolicy(ctx context.Context, in *CreateNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Modifies a `NetworkPolicy` resource. Only the following fields can be
	// updated: `internet_access`, `external_ip`, `edge_services_cidr`.
	// Only fields specified in `updateMask` are applied. When updating a network
	// policy, the external IP network service can only be disabled if there are
	// no external IP addresses present in the scope of the policy. Also, a
	// `NetworkService` cannot be updated when `NetworkService.state` is set
	// to `RECONCILING`.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdateNetworkPolicy(ctx context.Context, in *UpdateNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a `NetworkPolicy` resource. A network policy cannot be deleted
	// when `NetworkService.state` is set to `RECONCILING` for either its external
	// IP or internet access service.
	DeleteNetworkPolicy(ctx context.Context, in *DeleteNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists Consumer VPCs bound to Management DNS Zone of a given private cloud.
	ListManagementDnsZoneBindings(ctx context.Context, in *ListManagementDnsZoneBindingsRequest, opts ...grpc.CallOption) (*ListManagementDnsZoneBindingsResponse, error)
	// Retrieves a 'ManagementDnsZoneBinding' resource by its resource name.
	GetManagementDnsZoneBinding(ctx context.Context, in *GetManagementDnsZoneBindingRequest, opts ...grpc.CallOption) (*ManagementDnsZoneBinding, error)
	// Creates a new `ManagementDnsZoneBinding` resource in a private cloud.
	// This RPC creates the DNS binding and the resource that represents the
	// DNS binding of the consumer VPC network to the management DNS zone. A
	// management DNS zone is the Cloud DNS cross-project binding zone that
	// VMware Engine creates for each private cloud. It contains FQDNs and
	// corresponding IP addresses for the private cloud's ESXi hosts and
	// management VM appliances like vCenter and NSX Manager.
	CreateManagementDnsZoneBinding(ctx context.Context, in *CreateManagementDnsZoneBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a `ManagementDnsZoneBinding` resource.
	// Only fields specified in `update_mask` are applied.
	UpdateManagementDnsZoneBinding(ctx context.Context, in *UpdateManagementDnsZoneBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a `ManagementDnsZoneBinding` resource. When a management DNS zone
	// binding is deleted, the corresponding consumer VPC network is no longer
	// bound to the management DNS zone.
	DeleteManagementDnsZoneBinding(ctx context.Context, in *DeleteManagementDnsZoneBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retries to create a `ManagementDnsZoneBinding` resource that is
	// in failed state.
	RepairManagementDnsZoneBinding(ctx context.Context, in *RepairManagementDnsZoneBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new VMware Engine network that can be used by a private cloud.
	CreateVmwareEngineNetwork(ctx context.Context, in *CreateVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Modifies a VMware Engine network resource. Only the following fields can be
	// updated: `description`. Only fields specified in `updateMask` are
	// applied.
	UpdateVmwareEngineNetwork(ctx context.Context, in *UpdateVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a `VmwareEngineNetwork` resource. You can only delete a VMware
	// Engine network after all resources that refer to it are deleted. For
	// example, a private cloud, a network peering, and a network policy can all
	// refer to the same VMware Engine network.
	DeleteVmwareEngineNetwork(ctx context.Context, in *DeleteVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retrieves a `VmwareEngineNetwork` resource by its resource name. The
	// resource contains details of the VMware Engine network, such as its VMware
	// Engine network type, peered networks in a service project, and state
	// (for example, `CREATING`, `ACTIVE`, `DELETING`).
	GetVmwareEngineNetwork(ctx context.Context, in *GetVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*VmwareEngineNetwork, error)
	// Lists `VmwareEngineNetwork` resources in a given project and location.
	ListVmwareEngineNetworks(ctx context.Context, in *ListVmwareEngineNetworksRequest, opts ...grpc.CallOption) (*ListVmwareEngineNetworksResponse, error)
	// Creates a new private connection that can be used for accessing private
	// Clouds.
	CreatePrivateConnection(ctx context.Context, in *CreatePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retrieves a `PrivateConnection` resource by its resource name. The resource
	// contains details of the private connection, such as connected
	// network, routing mode and state.
	GetPrivateConnection(ctx context.Context, in *GetPrivateConnectionRequest, opts ...grpc.CallOption) (*PrivateConnection, error)
	// Lists `PrivateConnection` resources in a given project and location.
	ListPrivateConnections(ctx context.Context, in *ListPrivateConnectionsRequest, opts ...grpc.CallOption) (*ListPrivateConnectionsResponse, error)
	// Modifies a `PrivateConnection` resource. Only `description` and
	// `routing_mode` fields can be updated. Only fields specified in `updateMask`
	// are applied.
	UpdatePrivateConnection(ctx context.Context, in *UpdatePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a `PrivateConnection` resource. When a private connection is
	// deleted for a VMware Engine network, the connected network becomes
	// inaccessible to that VMware Engine network.
	DeletePrivateConnection(ctx context.Context, in *DeletePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the private connection routes exchanged over a peering connection.
	ListPrivateConnectionPeeringRoutes(ctx context.Context, in *ListPrivateConnectionPeeringRoutesRequest, opts ...grpc.CallOption) (*ListPrivateConnectionPeeringRoutesResponse, error)
	// Grants the bind permission to the customer provided principal(user /
	// service account) to bind their DNS zone with the intranet VPC associated
	// with the project. DnsBindPermission is a global resource and location can
	// only be global.
	GrantDnsBindPermission(ctx context.Context, in *GrantDnsBindPermissionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets all the principals having bind permission on the intranet VPC
	// associated with the consumer project granted by the Grant API.
	// DnsBindPermission is a global resource and location can only be global.
	GetDnsBindPermission(ctx context.Context, in *GetDnsBindPermissionRequest, opts ...grpc.CallOption) (*DnsBindPermission, error)
	// Revokes the bind permission from the customer provided principal(user /
	// service account) on the intranet VPC associated with the consumer project.
	// DnsBindPermission is a global resource and location can only be global.
	RevokeDnsBindPermission(ctx context.Context, in *RevokeDnsBindPermissionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type vmwareEngineClient struct {
	cc grpc.ClientConnInterface
}

func NewVmwareEngineClient(cc grpc.ClientConnInterface) VmwareEngineClient {
	return &vmwareEngineClient{cc}
}

func (c *vmwareEngineClient) ListPrivateClouds(ctx context.Context, in *ListPrivateCloudsRequest, opts ...grpc.CallOption) (*ListPrivateCloudsResponse, error) {
	out := new(ListPrivateCloudsResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_ListPrivateClouds_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetPrivateCloud(ctx context.Context, in *GetPrivateCloudRequest, opts ...grpc.CallOption) (*PrivateCloud, error) {
	out := new(PrivateCloud)
	err := c.cc.Invoke(ctx, VmwareEngine_GetPrivateCloud_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreatePrivateCloud(ctx context.Context, in *CreatePrivateCloudRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_CreatePrivateCloud_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdatePrivateCloud(ctx context.Context, in *UpdatePrivateCloudRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_UpdatePrivateCloud_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeletePrivateCloud(ctx context.Context, in *DeletePrivateCloudRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_DeletePrivateCloud_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UndeletePrivateCloud(ctx context.Context, in *UndeletePrivateCloudRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_UndeletePrivateCloud_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_ListClusters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, VmwareEngine_GetCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_CreateCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_UpdateCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_DeleteCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListNodes(ctx context.Context, in *ListNodesRequest, opts ...grpc.CallOption) (*ListNodesResponse, error) {
	out := new(ListNodesResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_ListNodes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetNode(ctx context.Context, in *GetNodeRequest, opts ...grpc.CallOption) (*Node, error) {
	out := new(Node)
	err := c.cc.Invoke(ctx, VmwareEngine_GetNode_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListExternalAddresses(ctx context.Context, in *ListExternalAddressesRequest, opts ...grpc.CallOption) (*ListExternalAddressesResponse, error) {
	out := new(ListExternalAddressesResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_ListExternalAddresses_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) FetchNetworkPolicyExternalAddresses(ctx context.Context, in *FetchNetworkPolicyExternalAddressesRequest, opts ...grpc.CallOption) (*FetchNetworkPolicyExternalAddressesResponse, error) {
	out := new(FetchNetworkPolicyExternalAddressesResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_FetchNetworkPolicyExternalAddresses_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetExternalAddress(ctx context.Context, in *GetExternalAddressRequest, opts ...grpc.CallOption) (*ExternalAddress, error) {
	out := new(ExternalAddress)
	err := c.cc.Invoke(ctx, VmwareEngine_GetExternalAddress_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateExternalAddress(ctx context.Context, in *CreateExternalAddressRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_CreateExternalAddress_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateExternalAddress(ctx context.Context, in *UpdateExternalAddressRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_UpdateExternalAddress_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeleteExternalAddress(ctx context.Context, in *DeleteExternalAddressRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_DeleteExternalAddress_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListSubnets(ctx context.Context, in *ListSubnetsRequest, opts ...grpc.CallOption) (*ListSubnetsResponse, error) {
	out := new(ListSubnetsResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_ListSubnets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetSubnet(ctx context.Context, in *GetSubnetRequest, opts ...grpc.CallOption) (*Subnet, error) {
	out := new(Subnet)
	err := c.cc.Invoke(ctx, VmwareEngine_GetSubnet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateSubnet(ctx context.Context, in *UpdateSubnetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_UpdateSubnet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListExternalAccessRules(ctx context.Context, in *ListExternalAccessRulesRequest, opts ...grpc.CallOption) (*ListExternalAccessRulesResponse, error) {
	out := new(ListExternalAccessRulesResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_ListExternalAccessRules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetExternalAccessRule(ctx context.Context, in *GetExternalAccessRuleRequest, opts ...grpc.CallOption) (*ExternalAccessRule, error) {
	out := new(ExternalAccessRule)
	err := c.cc.Invoke(ctx, VmwareEngine_GetExternalAccessRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateExternalAccessRule(ctx context.Context, in *CreateExternalAccessRuleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_CreateExternalAccessRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateExternalAccessRule(ctx context.Context, in *UpdateExternalAccessRuleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_UpdateExternalAccessRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeleteExternalAccessRule(ctx context.Context, in *DeleteExternalAccessRuleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_DeleteExternalAccessRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListLoggingServers(ctx context.Context, in *ListLoggingServersRequest, opts ...grpc.CallOption) (*ListLoggingServersResponse, error) {
	out := new(ListLoggingServersResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_ListLoggingServers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetLoggingServer(ctx context.Context, in *GetLoggingServerRequest, opts ...grpc.CallOption) (*LoggingServer, error) {
	out := new(LoggingServer)
	err := c.cc.Invoke(ctx, VmwareEngine_GetLoggingServer_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateLoggingServer(ctx context.Context, in *CreateLoggingServerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_CreateLoggingServer_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateLoggingServer(ctx context.Context, in *UpdateLoggingServerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_UpdateLoggingServer_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeleteLoggingServer(ctx context.Context, in *DeleteLoggingServerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_DeleteLoggingServer_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListNodeTypes(ctx context.Context, in *ListNodeTypesRequest, opts ...grpc.CallOption) (*ListNodeTypesResponse, error) {
	out := new(ListNodeTypesResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_ListNodeTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetNodeType(ctx context.Context, in *GetNodeTypeRequest, opts ...grpc.CallOption) (*NodeType, error) {
	out := new(NodeType)
	err := c.cc.Invoke(ctx, VmwareEngine_GetNodeType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ShowNsxCredentials(ctx context.Context, in *ShowNsxCredentialsRequest, opts ...grpc.CallOption) (*Credentials, error) {
	out := new(Credentials)
	err := c.cc.Invoke(ctx, VmwareEngine_ShowNsxCredentials_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ShowVcenterCredentials(ctx context.Context, in *ShowVcenterCredentialsRequest, opts ...grpc.CallOption) (*Credentials, error) {
	out := new(Credentials)
	err := c.cc.Invoke(ctx, VmwareEngine_ShowVcenterCredentials_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ResetNsxCredentials(ctx context.Context, in *ResetNsxCredentialsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_ResetNsxCredentials_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ResetVcenterCredentials(ctx context.Context, in *ResetVcenterCredentialsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_ResetVcenterCredentials_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetDnsForwarding(ctx context.Context, in *GetDnsForwardingRequest, opts ...grpc.CallOption) (*DnsForwarding, error) {
	out := new(DnsForwarding)
	err := c.cc.Invoke(ctx, VmwareEngine_GetDnsForwarding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateDnsForwarding(ctx context.Context, in *UpdateDnsForwardingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_UpdateDnsForwarding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetNetworkPeering(ctx context.Context, in *GetNetworkPeeringRequest, opts ...grpc.CallOption) (*NetworkPeering, error) {
	out := new(NetworkPeering)
	err := c.cc.Invoke(ctx, VmwareEngine_GetNetworkPeering_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListNetworkPeerings(ctx context.Context, in *ListNetworkPeeringsRequest, opts ...grpc.CallOption) (*ListNetworkPeeringsResponse, error) {
	out := new(ListNetworkPeeringsResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_ListNetworkPeerings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateNetworkPeering(ctx context.Context, in *CreateNetworkPeeringRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_CreateNetworkPeering_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeleteNetworkPeering(ctx context.Context, in *DeleteNetworkPeeringRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_DeleteNetworkPeering_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateNetworkPeering(ctx context.Context, in *UpdateNetworkPeeringRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_UpdateNetworkPeering_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListPeeringRoutes(ctx context.Context, in *ListPeeringRoutesRequest, opts ...grpc.CallOption) (*ListPeeringRoutesResponse, error) {
	out := new(ListPeeringRoutesResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_ListPeeringRoutes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateHcxActivationKey(ctx context.Context, in *CreateHcxActivationKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_CreateHcxActivationKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListHcxActivationKeys(ctx context.Context, in *ListHcxActivationKeysRequest, opts ...grpc.CallOption) (*ListHcxActivationKeysResponse, error) {
	out := new(ListHcxActivationKeysResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_ListHcxActivationKeys_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetHcxActivationKey(ctx context.Context, in *GetHcxActivationKeyRequest, opts ...grpc.CallOption) (*HcxActivationKey, error) {
	out := new(HcxActivationKey)
	err := c.cc.Invoke(ctx, VmwareEngine_GetHcxActivationKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetNetworkPolicy(ctx context.Context, in *GetNetworkPolicyRequest, opts ...grpc.CallOption) (*NetworkPolicy, error) {
	out := new(NetworkPolicy)
	err := c.cc.Invoke(ctx, VmwareEngine_GetNetworkPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListNetworkPolicies(ctx context.Context, in *ListNetworkPoliciesRequest, opts ...grpc.CallOption) (*ListNetworkPoliciesResponse, error) {
	out := new(ListNetworkPoliciesResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_ListNetworkPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateNetworkPolicy(ctx context.Context, in *CreateNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_CreateNetworkPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateNetworkPolicy(ctx context.Context, in *UpdateNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_UpdateNetworkPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeleteNetworkPolicy(ctx context.Context, in *DeleteNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_DeleteNetworkPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListManagementDnsZoneBindings(ctx context.Context, in *ListManagementDnsZoneBindingsRequest, opts ...grpc.CallOption) (*ListManagementDnsZoneBindingsResponse, error) {
	out := new(ListManagementDnsZoneBindingsResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_ListManagementDnsZoneBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetManagementDnsZoneBinding(ctx context.Context, in *GetManagementDnsZoneBindingRequest, opts ...grpc.CallOption) (*ManagementDnsZoneBinding, error) {
	out := new(ManagementDnsZoneBinding)
	err := c.cc.Invoke(ctx, VmwareEngine_GetManagementDnsZoneBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateManagementDnsZoneBinding(ctx context.Context, in *CreateManagementDnsZoneBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_CreateManagementDnsZoneBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateManagementDnsZoneBinding(ctx context.Context, in *UpdateManagementDnsZoneBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_UpdateManagementDnsZoneBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeleteManagementDnsZoneBinding(ctx context.Context, in *DeleteManagementDnsZoneBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_DeleteManagementDnsZoneBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) RepairManagementDnsZoneBinding(ctx context.Context, in *RepairManagementDnsZoneBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_RepairManagementDnsZoneBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateVmwareEngineNetwork(ctx context.Context, in *CreateVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_CreateVmwareEngineNetwork_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateVmwareEngineNetwork(ctx context.Context, in *UpdateVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_UpdateVmwareEngineNetwork_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeleteVmwareEngineNetwork(ctx context.Context, in *DeleteVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_DeleteVmwareEngineNetwork_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetVmwareEngineNetwork(ctx context.Context, in *GetVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*VmwareEngineNetwork, error) {
	out := new(VmwareEngineNetwork)
	err := c.cc.Invoke(ctx, VmwareEngine_GetVmwareEngineNetwork_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListVmwareEngineNetworks(ctx context.Context, in *ListVmwareEngineNetworksRequest, opts ...grpc.CallOption) (*ListVmwareEngineNetworksResponse, error) {
	out := new(ListVmwareEngineNetworksResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_ListVmwareEngineNetworks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreatePrivateConnection(ctx context.Context, in *CreatePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_CreatePrivateConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetPrivateConnection(ctx context.Context, in *GetPrivateConnectionRequest, opts ...grpc.CallOption) (*PrivateConnection, error) {
	out := new(PrivateConnection)
	err := c.cc.Invoke(ctx, VmwareEngine_GetPrivateConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListPrivateConnections(ctx context.Context, in *ListPrivateConnectionsRequest, opts ...grpc.CallOption) (*ListPrivateConnectionsResponse, error) {
	out := new(ListPrivateConnectionsResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_ListPrivateConnections_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdatePrivateConnection(ctx context.Context, in *UpdatePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_UpdatePrivateConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeletePrivateConnection(ctx context.Context, in *DeletePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_DeletePrivateConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListPrivateConnectionPeeringRoutes(ctx context.Context, in *ListPrivateConnectionPeeringRoutesRequest, opts ...grpc.CallOption) (*ListPrivateConnectionPeeringRoutesResponse, error) {
	out := new(ListPrivateConnectionPeeringRoutesResponse)
	err := c.cc.Invoke(ctx, VmwareEngine_ListPrivateConnectionPeeringRoutes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GrantDnsBindPermission(ctx context.Context, in *GrantDnsBindPermissionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_GrantDnsBindPermission_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetDnsBindPermission(ctx context.Context, in *GetDnsBindPermissionRequest, opts ...grpc.CallOption) (*DnsBindPermission, error) {
	out := new(DnsBindPermission)
	err := c.cc.Invoke(ctx, VmwareEngine_GetDnsBindPermission_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) RevokeDnsBindPermission(ctx context.Context, in *RevokeDnsBindPermissionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmwareEngine_RevokeDnsBindPermission_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VmwareEngineServer is the server API for VmwareEngine service.
// All implementations should embed UnimplementedVmwareEngineServer
// for forward compatibility
type VmwareEngineServer interface {
	// Lists `PrivateCloud` resources in a given project and location.
	ListPrivateClouds(context.Context, *ListPrivateCloudsRequest) (*ListPrivateCloudsResponse, error)
	// Retrieves a `PrivateCloud` resource by its resource name.
	GetPrivateCloud(context.Context, *GetPrivateCloudRequest) (*PrivateCloud, error)
	// Creates a new `PrivateCloud` resource in a given project and location.
	// Private clouds of type `STANDARD` and
	// `TIME_LIMITED` are zonal resources, `STRETCHED` private clouds are
	// regional.
	// Creating a private cloud also creates a [management
	// cluster](https://cloud.google.com/vmware-engine/docs/concepts-vmware-components)
	// for that private cloud.
	CreatePrivateCloud(context.Context, *CreatePrivateCloudRequest) (*longrunningpb.Operation, error)
	// Modifies a `PrivateCloud` resource. Only the following fields can be
	// updated: `description`.
	// Only fields specified in `updateMask` are applied.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdatePrivateCloud(context.Context, *UpdatePrivateCloudRequest) (*longrunningpb.Operation, error)
	// Schedules a `PrivateCloud` resource for deletion.
	//
	// A `PrivateCloud` resource scheduled for deletion has `PrivateCloud.state`
	// set to `DELETED` and `expireTime` set to the time when deletion is final
	// and can no longer be reversed. The delete operation is marked as done
	// as soon as the `PrivateCloud` is successfully scheduled for deletion
	// (this also applies when `delayHours` is set to zero), and the operation is
	// not kept in pending state until `PrivateCloud` is purged.
	// `PrivateCloud` can be restored using `UndeletePrivateCloud` method before
	// the `expireTime` elapses. When `expireTime` is reached, deletion is final
	// and all private cloud resources are irreversibly removed and billing stops.
	// During the final removal process, `PrivateCloud.state` is set to `PURGING`.
	// `PrivateCloud` can be polled using standard `GET` method for the whole
	// period of deletion and purging. It will not be returned only
	// when it is completely purged.
	DeletePrivateCloud(context.Context, *DeletePrivateCloudRequest) (*longrunningpb.Operation, error)
	// Restores a private cloud that was previously scheduled for deletion by
	// `DeletePrivateCloud`. A `PrivateCloud` resource scheduled for deletion has
	// `PrivateCloud.state` set to `DELETED` and `PrivateCloud.expireTime` set to
	// the time when deletion can no longer be reversed.
	UndeletePrivateCloud(context.Context, *UndeletePrivateCloudRequest) (*longrunningpb.Operation, error)
	// Lists `Cluster` resources in a given private cloud.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Retrieves a `Cluster` resource by its resource name.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Creates a new cluster in a given private cloud.
	// Creating a new cluster provides additional nodes for
	// use in the parent private cloud and requires sufficient [node
	// quota](https://cloud.google.com/vmware-engine/quotas).
	CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error)
	// Modifies a `Cluster` resource. Only fields specified in `updateMask` are
	// applied.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunningpb.Operation, error)
	// Deletes a `Cluster` resource. To avoid unintended data loss, migrate or
	// gracefully shut down any workloads running on the cluster before deletion.
	// You cannot delete the management cluster of a private cloud using this
	// method.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunningpb.Operation, error)
	// Lists nodes in a given cluster.
	ListNodes(context.Context, *ListNodesRequest) (*ListNodesResponse, error)
	// Gets details of a single node.
	GetNode(context.Context, *GetNodeRequest) (*Node, error)
	// Lists external IP addresses assigned to VMware workload VMs in a given
	// private cloud.
	ListExternalAddresses(context.Context, *ListExternalAddressesRequest) (*ListExternalAddressesResponse, error)
	// Lists external IP addresses assigned to VMware workload VMs within the
	// scope of the given network policy.
	FetchNetworkPolicyExternalAddresses(context.Context, *FetchNetworkPolicyExternalAddressesRequest) (*FetchNetworkPolicyExternalAddressesResponse, error)
	// Gets details of a single external IP address.
	GetExternalAddress(context.Context, *GetExternalAddressRequest) (*ExternalAddress, error)
	// Creates a new `ExternalAddress` resource in a given private cloud. The
	// network policy that corresponds to the private cloud must have the external
	// IP address network service enabled (`NetworkPolicy.external_ip`).
	CreateExternalAddress(context.Context, *CreateExternalAddressRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single external IP address.
	// Only fields specified in `update_mask` are applied.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdateExternalAddress(context.Context, *UpdateExternalAddressRequest) (*longrunningpb.Operation, error)
	// Deletes a single external IP address. When you delete an external IP
	// address, connectivity between the external IP address and the corresponding
	// internal IP address is lost.
	DeleteExternalAddress(context.Context, *DeleteExternalAddressRequest) (*longrunningpb.Operation, error)
	// Lists subnets in a given private cloud.
	ListSubnets(context.Context, *ListSubnetsRequest) (*ListSubnetsResponse, error)
	// Gets details of a single subnet.
	GetSubnet(context.Context, *GetSubnetRequest) (*Subnet, error)
	// Updates the parameters of a single subnet. Only fields specified in
	// `update_mask` are applied.
	//
	// *Note*: This API is synchronous and always returns a successful
	// `google.longrunning.Operation` (LRO). The returned LRO will only have
	// `done` and `response` fields.
	UpdateSubnet(context.Context, *UpdateSubnetRequest) (*longrunningpb.Operation, error)
	// Lists `ExternalAccessRule` resources in the specified network policy.
	ListExternalAccessRules(context.Context, *ListExternalAccessRulesRequest) (*ListExternalAccessRulesResponse, error)
	// Gets details of a single external access rule.
	GetExternalAccessRule(context.Context, *GetExternalAccessRuleRequest) (*ExternalAccessRule, error)
	// Creates a new external access rule in a given network policy.
	CreateExternalAccessRule(context.Context, *CreateExternalAccessRuleRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single external access rule.
	// Only fields specified in `update_mask` are applied.
	UpdateExternalAccessRule(context.Context, *UpdateExternalAccessRuleRequest) (*longrunningpb.Operation, error)
	// Deletes a single external access rule.
	DeleteExternalAccessRule(context.Context, *DeleteExternalAccessRuleRequest) (*longrunningpb.Operation, error)
	// Lists logging servers configured for a given private
	// cloud.
	ListLoggingServers(context.Context, *ListLoggingServersRequest) (*ListLoggingServersResponse, error)
	// Gets details of a logging server.
	GetLoggingServer(context.Context, *GetLoggingServerRequest) (*LoggingServer, error)
	// Create a new logging server for a given private cloud.
	CreateLoggingServer(context.Context, *CreateLoggingServerRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single logging server.
	// Only fields specified in `update_mask` are applied.
	UpdateLoggingServer(context.Context, *UpdateLoggingServerRequest) (*longrunningpb.Operation, error)
	// Deletes a single logging server.
	DeleteLoggingServer(context.Context, *DeleteLoggingServerRequest) (*longrunningpb.Operation, error)
	// Lists node types
	ListNodeTypes(context.Context, *ListNodeTypesRequest) (*ListNodeTypesResponse, error)
	// Gets details of a single `NodeType`.
	GetNodeType(context.Context, *GetNodeTypeRequest) (*NodeType, error)
	// Gets details of credentials for NSX appliance.
	ShowNsxCredentials(context.Context, *ShowNsxCredentialsRequest) (*Credentials, error)
	// Gets details of credentials for Vcenter appliance.
	ShowVcenterCredentials(context.Context, *ShowVcenterCredentialsRequest) (*Credentials, error)
	// Resets credentials of the NSX appliance.
	ResetNsxCredentials(context.Context, *ResetNsxCredentialsRequest) (*longrunningpb.Operation, error)
	// Resets credentials of the Vcenter appliance.
	ResetVcenterCredentials(context.Context, *ResetVcenterCredentialsRequest) (*longrunningpb.Operation, error)
	// Gets details of the `DnsForwarding` config.
	GetDnsForwarding(context.Context, *GetDnsForwardingRequest) (*DnsForwarding, error)
	// Updates the parameters of the `DnsForwarding` config, like associated
	// domains. Only fields specified in `update_mask` are applied.
	UpdateDnsForwarding(context.Context, *UpdateDnsForwardingRequest) (*longrunningpb.Operation, error)
	// Retrieves a `NetworkPeering` resource by its resource name. The resource
	// contains details of the network peering, such as peered
	// networks, import and export custom route configurations, and peering state.
	// NetworkPeering is a global resource and location can only be global.
	GetNetworkPeering(context.Context, *GetNetworkPeeringRequest) (*NetworkPeering, error)
	// Lists `NetworkPeering` resources in a given project. NetworkPeering is a
	// global resource and location can only be global.
	ListNetworkPeerings(context.Context, *ListNetworkPeeringsRequest) (*ListNetworkPeeringsResponse, error)
	// Creates a new network peering between the peer network and VMware Engine
	// network provided in a `NetworkPeering` resource. NetworkPeering is a
	// global resource and location can only be global.
	CreateNetworkPeering(context.Context, *CreateNetworkPeeringRequest) (*longrunningpb.Operation, error)
	// Deletes a `NetworkPeering` resource. When a network peering is deleted for
	// a VMware Engine network, the peer network becomes inaccessible to that
	// VMware Engine network. NetworkPeering is a global resource and location can
	// only be global.
	DeleteNetworkPeering(context.Context, *DeleteNetworkPeeringRequest) (*longrunningpb.Operation, error)
	// Modifies a `NetworkPeering` resource. Only the `description` field can be
	// updated. Only fields specified in `updateMask` are applied. NetworkPeering
	// is a global resource and location can only be global.
	UpdateNetworkPeering(context.Context, *UpdateNetworkPeeringRequest) (*longrunningpb.Operation, error)
	// Lists the network peering routes exchanged over a peering connection.
	// NetworkPeering is a global resource and location can only be global.
	ListPeeringRoutes(context.Context, *ListPeeringRoutesRequest) (*ListPeeringRoutesResponse, error)
	// Creates a new HCX activation key in a given private cloud.
	CreateHcxActivationKey(context.Context, *CreateHcxActivationKeyRequest) (*longrunningpb.Operation, error)
	// Lists `HcxActivationKey` resources in a given private cloud.
	ListHcxActivationKeys(context.Context, *ListHcxActivationKeysRequest) (*ListHcxActivationKeysResponse, error)
	// Retrieves a `HcxActivationKey` resource by its resource name.
	GetHcxActivationKey(context.Context, *GetHcxActivationKeyRequest) (*HcxActivationKey, error)
	// Retrieves a `NetworkPolicy` resource by its resource name.
	GetNetworkPolicy(context.Context, *GetNetworkPolicyRequest) (*NetworkPolicy, error)
	// Lists `NetworkPolicy` resources in a specified project and location.
	ListNetworkPolicies(context.Context, *ListNetworkPoliciesRequest) (*ListNetworkPoliciesResponse, error)
	// Creates a new network policy in a given VMware Engine network of a
	// project and location (region). A new network policy cannot be created if
	// another network policy already exists in the same scope.
	CreateNetworkPolicy(context.Context, *CreateNetworkPolicyRequest) (*longrunningpb.Operation, error)
	// Modifies a `NetworkPolicy` resource. Only the following fields can be
	// updated: `internet_access`, `external_ip`, `edge_services_cidr`.
	// Only fields specified in `updateMask` are applied. When updating a network
	// policy, the external IP network service can only be disabled if there are
	// no external IP addresses present in the scope of the policy. Also, a
	// `NetworkService` cannot be updated when `NetworkService.state` is set
	// to `RECONCILING`.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdateNetworkPolicy(context.Context, *UpdateNetworkPolicyRequest) (*longrunningpb.Operation, error)
	// Deletes a `NetworkPolicy` resource. A network policy cannot be deleted
	// when `NetworkService.state` is set to `RECONCILING` for either its external
	// IP or internet access service.
	DeleteNetworkPolicy(context.Context, *DeleteNetworkPolicyRequest) (*longrunningpb.Operation, error)
	// Lists Consumer VPCs bound to Management DNS Zone of a given private cloud.
	ListManagementDnsZoneBindings(context.Context, *ListManagementDnsZoneBindingsRequest) (*ListManagementDnsZoneBindingsResponse, error)
	// Retrieves a 'ManagementDnsZoneBinding' resource by its resource name.
	GetManagementDnsZoneBinding(context.Context, *GetManagementDnsZoneBindingRequest) (*ManagementDnsZoneBinding, error)
	// Creates a new `ManagementDnsZoneBinding` resource in a private cloud.
	// This RPC creates the DNS binding and the resource that represents the
	// DNS binding of the consumer VPC network to the management DNS zone. A
	// management DNS zone is the Cloud DNS cross-project binding zone that
	// VMware Engine creates for each private cloud. It contains FQDNs and
	// corresponding IP addresses for the private cloud's ESXi hosts and
	// management VM appliances like vCenter and NSX Manager.
	CreateManagementDnsZoneBinding(context.Context, *CreateManagementDnsZoneBindingRequest) (*longrunningpb.Operation, error)
	// Updates a `ManagementDnsZoneBinding` resource.
	// Only fields specified in `update_mask` are applied.
	UpdateManagementDnsZoneBinding(context.Context, *UpdateManagementDnsZoneBindingRequest) (*longrunningpb.Operation, error)
	// Deletes a `ManagementDnsZoneBinding` resource. When a management DNS zone
	// binding is deleted, the corresponding consumer VPC network is no longer
	// bound to the management DNS zone.
	DeleteManagementDnsZoneBinding(context.Context, *DeleteManagementDnsZoneBindingRequest) (*longrunningpb.Operation, error)
	// Retries to create a `ManagementDnsZoneBinding` resource that is
	// in failed state.
	RepairManagementDnsZoneBinding(context.Context, *RepairManagementDnsZoneBindingRequest) (*longrunningpb.Operation, error)
	// Creates a new VMware Engine network that can be used by a private cloud.
	CreateVmwareEngineNetwork(context.Context, *CreateVmwareEngineNetworkRequest) (*longrunningpb.Operation, error)
	// Modifies a VMware Engine network resource. Only the following fields can be
	// updated: `description`. Only fields specified in `updateMask` are
	// applied.
	UpdateVmwareEngineNetwork(context.Context, *UpdateVmwareEngineNetworkRequest) (*longrunningpb.Operation, error)
	// Deletes a `VmwareEngineNetwork` resource. You can only delete a VMware
	// Engine network after all resources that refer to it are deleted. For
	// example, a private cloud, a network peering, and a network policy can all
	// refer to the same VMware Engine network.
	DeleteVmwareEngineNetwork(context.Context, *DeleteVmwareEngineNetworkRequest) (*longrunningpb.Operation, error)
	// Retrieves a `VmwareEngineNetwork` resource by its resource name. The
	// resource contains details of the VMware Engine network, such as its VMware
	// Engine network type, peered networks in a service project, and state
	// (for example, `CREATING`, `ACTIVE`, `DELETING`).
	GetVmwareEngineNetwork(context.Context, *GetVmwareEngineNetworkRequest) (*VmwareEngineNetwork, error)
	// Lists `VmwareEngineNetwork` resources in a given project and location.
	ListVmwareEngineNetworks(context.Context, *ListVmwareEngineNetworksRequest) (*ListVmwareEngineNetworksResponse, error)
	// Creates a new private connection that can be used for accessing private
	// Clouds.
	CreatePrivateConnection(context.Context, *CreatePrivateConnectionRequest) (*longrunningpb.Operation, error)
	// Retrieves a `PrivateConnection` resource by its resource name. The resource
	// contains details of the private connection, such as connected
	// network, routing mode and state.
	GetPrivateConnection(context.Context, *GetPrivateConnectionRequest) (*PrivateConnection, error)
	// Lists `PrivateConnection` resources in a given project and location.
	ListPrivateConnections(context.Context, *ListPrivateConnectionsRequest) (*ListPrivateConnectionsResponse, error)
	// Modifies a `PrivateConnection` resource. Only `description` and
	// `routing_mode` fields can be updated. Only fields specified in `updateMask`
	// are applied.
	UpdatePrivateConnection(context.Context, *UpdatePrivateConnectionRequest) (*longrunningpb.Operation, error)
	// Deletes a `PrivateConnection` resource. When a private connection is
	// deleted for a VMware Engine network, the connected network becomes
	// inaccessible to that VMware Engine network.
	DeletePrivateConnection(context.Context, *DeletePrivateConnectionRequest) (*longrunningpb.Operation, error)
	// Lists the private connection routes exchanged over a peering connection.
	ListPrivateConnectionPeeringRoutes(context.Context, *ListPrivateConnectionPeeringRoutesRequest) (*ListPrivateConnectionPeeringRoutesResponse, error)
	// Grants the bind permission to the customer provided principal(user /
	// service account) to bind their DNS zone with the intranet VPC associated
	// with the project. DnsBindPermission is a global resource and location can
	// only be global.
	GrantDnsBindPermission(context.Context, *GrantDnsBindPermissionRequest) (*longrunningpb.Operation, error)
	// Gets all the principals having bind permission on the intranet VPC
	// associated with the consumer project granted by the Grant API.
	// DnsBindPermission is a global resource and location can only be global.
	GetDnsBindPermission(context.Context, *GetDnsBindPermissionRequest) (*DnsBindPermission, error)
	// Revokes the bind permission from the customer provided principal(user /
	// service account) on the intranet VPC associated with the consumer project.
	// DnsBindPermission is a global resource and location can only be global.
	RevokeDnsBindPermission(context.Context, *RevokeDnsBindPermissionRequest) (*longrunningpb.Operation, error)
}

// UnimplementedVmwareEngineServer should be embedded to have forward compatible implementations.
type UnimplementedVmwareEngineServer struct {
}

func (UnimplementedVmwareEngineServer) ListPrivateClouds(context.Context, *ListPrivateCloudsRequest) (*ListPrivateCloudsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPrivateClouds not implemented")
}
func (UnimplementedVmwareEngineServer) GetPrivateCloud(context.Context, *GetPrivateCloudRequest) (*PrivateCloud, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPrivateCloud not implemented")
}
func (UnimplementedVmwareEngineServer) CreatePrivateCloud(context.Context, *CreatePrivateCloudRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePrivateCloud not implemented")
}
func (UnimplementedVmwareEngineServer) UpdatePrivateCloud(context.Context, *UpdatePrivateCloudRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePrivateCloud not implemented")
}
func (UnimplementedVmwareEngineServer) DeletePrivateCloud(context.Context, *DeletePrivateCloudRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePrivateCloud not implemented")
}
func (UnimplementedVmwareEngineServer) UndeletePrivateCloud(context.Context, *UndeletePrivateCloudRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeletePrivateCloud not implemented")
}
func (UnimplementedVmwareEngineServer) ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClusters not implemented")
}
func (UnimplementedVmwareEngineServer) GetCluster(context.Context, *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (UnimplementedVmwareEngineServer) CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCluster not implemented")
}
func (UnimplementedVmwareEngineServer) UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCluster not implemented")
}
func (UnimplementedVmwareEngineServer) DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (UnimplementedVmwareEngineServer) ListNodes(context.Context, *ListNodesRequest) (*ListNodesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNodes not implemented")
}
func (UnimplementedVmwareEngineServer) GetNode(context.Context, *GetNodeRequest) (*Node, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNode not implemented")
}
func (UnimplementedVmwareEngineServer) ListExternalAddresses(context.Context, *ListExternalAddressesRequest) (*ListExternalAddressesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExternalAddresses not implemented")
}
func (UnimplementedVmwareEngineServer) FetchNetworkPolicyExternalAddresses(context.Context, *FetchNetworkPolicyExternalAddressesRequest) (*FetchNetworkPolicyExternalAddressesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchNetworkPolicyExternalAddresses not implemented")
}
func (UnimplementedVmwareEngineServer) GetExternalAddress(context.Context, *GetExternalAddressRequest) (*ExternalAddress, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExternalAddress not implemented")
}
func (UnimplementedVmwareEngineServer) CreateExternalAddress(context.Context, *CreateExternalAddressRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExternalAddress not implemented")
}
func (UnimplementedVmwareEngineServer) UpdateExternalAddress(context.Context, *UpdateExternalAddressRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExternalAddress not implemented")
}
func (UnimplementedVmwareEngineServer) DeleteExternalAddress(context.Context, *DeleteExternalAddressRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteExternalAddress not implemented")
}
func (UnimplementedVmwareEngineServer) ListSubnets(context.Context, *ListSubnetsRequest) (*ListSubnetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSubnets not implemented")
}
func (UnimplementedVmwareEngineServer) GetSubnet(context.Context, *GetSubnetRequest) (*Subnet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSubnet not implemented")
}
func (UnimplementedVmwareEngineServer) UpdateSubnet(context.Context, *UpdateSubnetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSubnet not implemented")
}
func (UnimplementedVmwareEngineServer) ListExternalAccessRules(context.Context, *ListExternalAccessRulesRequest) (*ListExternalAccessRulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExternalAccessRules not implemented")
}
func (UnimplementedVmwareEngineServer) GetExternalAccessRule(context.Context, *GetExternalAccessRuleRequest) (*ExternalAccessRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExternalAccessRule not implemented")
}
func (UnimplementedVmwareEngineServer) CreateExternalAccessRule(context.Context, *CreateExternalAccessRuleRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExternalAccessRule not implemented")
}
func (UnimplementedVmwareEngineServer) UpdateExternalAccessRule(context.Context, *UpdateExternalAccessRuleRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExternalAccessRule not implemented")
}
func (UnimplementedVmwareEngineServer) DeleteExternalAccessRule(context.Context, *DeleteExternalAccessRuleRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteExternalAccessRule not implemented")
}
func (UnimplementedVmwareEngineServer) ListLoggingServers(context.Context, *ListLoggingServersRequest) (*ListLoggingServersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLoggingServers not implemented")
}
func (UnimplementedVmwareEngineServer) GetLoggingServer(context.Context, *GetLoggingServerRequest) (*LoggingServer, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLoggingServer not implemented")
}
func (UnimplementedVmwareEngineServer) CreateLoggingServer(context.Context, *CreateLoggingServerRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLoggingServer not implemented")
}
func (UnimplementedVmwareEngineServer) UpdateLoggingServer(context.Context, *UpdateLoggingServerRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateLoggingServer not implemented")
}
func (UnimplementedVmwareEngineServer) DeleteLoggingServer(context.Context, *DeleteLoggingServerRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteLoggingServer not implemented")
}
func (UnimplementedVmwareEngineServer) ListNodeTypes(context.Context, *ListNodeTypesRequest) (*ListNodeTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNodeTypes not implemented")
}
func (UnimplementedVmwareEngineServer) GetNodeType(context.Context, *GetNodeTypeRequest) (*NodeType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNodeType not implemented")
}
func (UnimplementedVmwareEngineServer) ShowNsxCredentials(context.Context, *ShowNsxCredentialsRequest) (*Credentials, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ShowNsxCredentials not implemented")
}
func (UnimplementedVmwareEngineServer) ShowVcenterCredentials(context.Context, *ShowVcenterCredentialsRequest) (*Credentials, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ShowVcenterCredentials not implemented")
}
func (UnimplementedVmwareEngineServer) ResetNsxCredentials(context.Context, *ResetNsxCredentialsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetNsxCredentials not implemented")
}
func (UnimplementedVmwareEngineServer) ResetVcenterCredentials(context.Context, *ResetVcenterCredentialsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetVcenterCredentials not implemented")
}
func (UnimplementedVmwareEngineServer) GetDnsForwarding(context.Context, *GetDnsForwardingRequest) (*DnsForwarding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDnsForwarding not implemented")
}
func (UnimplementedVmwareEngineServer) UpdateDnsForwarding(context.Context, *UpdateDnsForwardingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDnsForwarding not implemented")
}
func (UnimplementedVmwareEngineServer) GetNetworkPeering(context.Context, *GetNetworkPeeringRequest) (*NetworkPeering, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNetworkPeering not implemented")
}
func (UnimplementedVmwareEngineServer) ListNetworkPeerings(context.Context, *ListNetworkPeeringsRequest) (*ListNetworkPeeringsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNetworkPeerings not implemented")
}
func (UnimplementedVmwareEngineServer) CreateNetworkPeering(context.Context, *CreateNetworkPeeringRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNetworkPeering not implemented")
}
func (UnimplementedVmwareEngineServer) DeleteNetworkPeering(context.Context, *DeleteNetworkPeeringRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNetworkPeering not implemented")
}
func (UnimplementedVmwareEngineServer) UpdateNetworkPeering(context.Context, *UpdateNetworkPeeringRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNetworkPeering not implemented")
}
func (UnimplementedVmwareEngineServer) ListPeeringRoutes(context.Context, *ListPeeringRoutesRequest) (*ListPeeringRoutesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPeeringRoutes not implemented")
}
func (UnimplementedVmwareEngineServer) CreateHcxActivationKey(context.Context, *CreateHcxActivationKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateHcxActivationKey not implemented")
}
func (UnimplementedVmwareEngineServer) ListHcxActivationKeys(context.Context, *ListHcxActivationKeysRequest) (*ListHcxActivationKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHcxActivationKeys not implemented")
}
func (UnimplementedVmwareEngineServer) GetHcxActivationKey(context.Context, *GetHcxActivationKeyRequest) (*HcxActivationKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHcxActivationKey not implemented")
}
func (UnimplementedVmwareEngineServer) GetNetworkPolicy(context.Context, *GetNetworkPolicyRequest) (*NetworkPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNetworkPolicy not implemented")
}
func (UnimplementedVmwareEngineServer) ListNetworkPolicies(context.Context, *ListNetworkPoliciesRequest) (*ListNetworkPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNetworkPolicies not implemented")
}
func (UnimplementedVmwareEngineServer) CreateNetworkPolicy(context.Context, *CreateNetworkPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNetworkPolicy not implemented")
}
func (UnimplementedVmwareEngineServer) UpdateNetworkPolicy(context.Context, *UpdateNetworkPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNetworkPolicy not implemented")
}
func (UnimplementedVmwareEngineServer) DeleteNetworkPolicy(context.Context, *DeleteNetworkPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNetworkPolicy not implemented")
}
func (UnimplementedVmwareEngineServer) ListManagementDnsZoneBindings(context.Context, *ListManagementDnsZoneBindingsRequest) (*ListManagementDnsZoneBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListManagementDnsZoneBindings not implemented")
}
func (UnimplementedVmwareEngineServer) GetManagementDnsZoneBinding(context.Context, *GetManagementDnsZoneBindingRequest) (*ManagementDnsZoneBinding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetManagementDnsZoneBinding not implemented")
}
func (UnimplementedVmwareEngineServer) CreateManagementDnsZoneBinding(context.Context, *CreateManagementDnsZoneBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateManagementDnsZoneBinding not implemented")
}
func (UnimplementedVmwareEngineServer) UpdateManagementDnsZoneBinding(context.Context, *UpdateManagementDnsZoneBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateManagementDnsZoneBinding not implemented")
}
func (UnimplementedVmwareEngineServer) DeleteManagementDnsZoneBinding(context.Context, *DeleteManagementDnsZoneBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteManagementDnsZoneBinding not implemented")
}
func (UnimplementedVmwareEngineServer) RepairManagementDnsZoneBinding(context.Context, *RepairManagementDnsZoneBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RepairManagementDnsZoneBinding not implemented")
}
func (UnimplementedVmwareEngineServer) CreateVmwareEngineNetwork(context.Context, *CreateVmwareEngineNetworkRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVmwareEngineNetwork not implemented")
}
func (UnimplementedVmwareEngineServer) UpdateVmwareEngineNetwork(context.Context, *UpdateVmwareEngineNetworkRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVmwareEngineNetwork not implemented")
}
func (UnimplementedVmwareEngineServer) DeleteVmwareEngineNetwork(context.Context, *DeleteVmwareEngineNetworkRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVmwareEngineNetwork not implemented")
}
func (UnimplementedVmwareEngineServer) GetVmwareEngineNetwork(context.Context, *GetVmwareEngineNetworkRequest) (*VmwareEngineNetwork, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVmwareEngineNetwork not implemented")
}
func (UnimplementedVmwareEngineServer) ListVmwareEngineNetworks(context.Context, *ListVmwareEngineNetworksRequest) (*ListVmwareEngineNetworksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVmwareEngineNetworks not implemented")
}
func (UnimplementedVmwareEngineServer) CreatePrivateConnection(context.Context, *CreatePrivateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePrivateConnection not implemented")
}
func (UnimplementedVmwareEngineServer) GetPrivateConnection(context.Context, *GetPrivateConnectionRequest) (*PrivateConnection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPrivateConnection not implemented")
}
func (UnimplementedVmwareEngineServer) ListPrivateConnections(context.Context, *ListPrivateConnectionsRequest) (*ListPrivateConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPrivateConnections not implemented")
}
func (UnimplementedVmwareEngineServer) UpdatePrivateConnection(context.Context, *UpdatePrivateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePrivateConnection not implemented")
}
func (UnimplementedVmwareEngineServer) DeletePrivateConnection(context.Context, *DeletePrivateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePrivateConnection not implemented")
}
func (UnimplementedVmwareEngineServer) ListPrivateConnectionPeeringRoutes(context.Context, *ListPrivateConnectionPeeringRoutesRequest) (*ListPrivateConnectionPeeringRoutesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPrivateConnectionPeeringRoutes not implemented")
}
func (UnimplementedVmwareEngineServer) GrantDnsBindPermission(context.Context, *GrantDnsBindPermissionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GrantDnsBindPermission not implemented")
}
func (UnimplementedVmwareEngineServer) GetDnsBindPermission(context.Context, *GetDnsBindPermissionRequest) (*DnsBindPermission, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDnsBindPermission not implemented")
}
func (UnimplementedVmwareEngineServer) RevokeDnsBindPermission(context.Context, *RevokeDnsBindPermissionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevokeDnsBindPermission not implemented")
}

// UnsafeVmwareEngineServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to VmwareEngineServer will
// result in compilation errors.
type UnsafeVmwareEngineServer interface {
	mustEmbedUnimplementedVmwareEngineServer()
}

func RegisterVmwareEngineServer(s grpc.ServiceRegistrar, srv VmwareEngineServer) {
	s.RegisterService(&VmwareEngine_ServiceDesc, srv)
}

func _VmwareEngine_ListPrivateClouds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPrivateCloudsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListPrivateClouds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ListPrivateClouds_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListPrivateClouds(ctx, req.(*ListPrivateCloudsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetPrivateCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPrivateCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetPrivateCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GetPrivateCloud_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetPrivateCloud(ctx, req.(*GetPrivateCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreatePrivateCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePrivateCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreatePrivateCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_CreatePrivateCloud_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreatePrivateCloud(ctx, req.(*CreatePrivateCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdatePrivateCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePrivateCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdatePrivateCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_UpdatePrivateCloud_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdatePrivateCloud(ctx, req.(*UpdatePrivateCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeletePrivateCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePrivateCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeletePrivateCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_DeletePrivateCloud_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeletePrivateCloud(ctx, req.(*DeletePrivateCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UndeletePrivateCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeletePrivateCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UndeletePrivateCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_UndeletePrivateCloud_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UndeletePrivateCloud(ctx, req.(*UndeletePrivateCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ListClusters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GetCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_CreateCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_UpdateCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_DeleteCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ListNodes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListNodes(ctx, req.(*ListNodesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GetNode_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetNode(ctx, req.(*GetNodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListExternalAddresses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExternalAddressesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListExternalAddresses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ListExternalAddresses_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListExternalAddresses(ctx, req.(*ListExternalAddressesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_FetchNetworkPolicyExternalAddresses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchNetworkPolicyExternalAddressesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).FetchNetworkPolicyExternalAddresses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_FetchNetworkPolicyExternalAddresses_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).FetchNetworkPolicyExternalAddresses(ctx, req.(*FetchNetworkPolicyExternalAddressesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetExternalAddress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExternalAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetExternalAddress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GetExternalAddress_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetExternalAddress(ctx, req.(*GetExternalAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateExternalAddress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateExternalAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateExternalAddress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_CreateExternalAddress_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateExternalAddress(ctx, req.(*CreateExternalAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateExternalAddress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExternalAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateExternalAddress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_UpdateExternalAddress_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateExternalAddress(ctx, req.(*UpdateExternalAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeleteExternalAddress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteExternalAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeleteExternalAddress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_DeleteExternalAddress_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeleteExternalAddress(ctx, req.(*DeleteExternalAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListSubnets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubnetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListSubnets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ListSubnets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListSubnets(ctx, req.(*ListSubnetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetSubnet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubnetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetSubnet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GetSubnet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetSubnet(ctx, req.(*GetSubnetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateSubnet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSubnetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateSubnet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_UpdateSubnet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateSubnet(ctx, req.(*UpdateSubnetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListExternalAccessRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExternalAccessRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListExternalAccessRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ListExternalAccessRules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListExternalAccessRules(ctx, req.(*ListExternalAccessRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetExternalAccessRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExternalAccessRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetExternalAccessRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GetExternalAccessRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetExternalAccessRule(ctx, req.(*GetExternalAccessRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateExternalAccessRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateExternalAccessRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateExternalAccessRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_CreateExternalAccessRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateExternalAccessRule(ctx, req.(*CreateExternalAccessRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateExternalAccessRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExternalAccessRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateExternalAccessRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_UpdateExternalAccessRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateExternalAccessRule(ctx, req.(*UpdateExternalAccessRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeleteExternalAccessRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteExternalAccessRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeleteExternalAccessRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_DeleteExternalAccessRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeleteExternalAccessRule(ctx, req.(*DeleteExternalAccessRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListLoggingServers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLoggingServersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListLoggingServers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ListLoggingServers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListLoggingServers(ctx, req.(*ListLoggingServersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetLoggingServer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLoggingServerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetLoggingServer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GetLoggingServer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetLoggingServer(ctx, req.(*GetLoggingServerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateLoggingServer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLoggingServerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateLoggingServer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_CreateLoggingServer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateLoggingServer(ctx, req.(*CreateLoggingServerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateLoggingServer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateLoggingServerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateLoggingServer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_UpdateLoggingServer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateLoggingServer(ctx, req.(*UpdateLoggingServerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeleteLoggingServer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLoggingServerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeleteLoggingServer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_DeleteLoggingServer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeleteLoggingServer(ctx, req.(*DeleteLoggingServerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListNodeTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodeTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListNodeTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ListNodeTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListNodeTypes(ctx, req.(*ListNodeTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetNodeType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodeTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetNodeType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GetNodeType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetNodeType(ctx, req.(*GetNodeTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ShowNsxCredentials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ShowNsxCredentialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ShowNsxCredentials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ShowNsxCredentials_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ShowNsxCredentials(ctx, req.(*ShowNsxCredentialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ShowVcenterCredentials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ShowVcenterCredentialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ShowVcenterCredentials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ShowVcenterCredentials_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ShowVcenterCredentials(ctx, req.(*ShowVcenterCredentialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ResetNsxCredentials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetNsxCredentialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ResetNsxCredentials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ResetNsxCredentials_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ResetNsxCredentials(ctx, req.(*ResetNsxCredentialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ResetVcenterCredentials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetVcenterCredentialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ResetVcenterCredentials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ResetVcenterCredentials_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ResetVcenterCredentials(ctx, req.(*ResetVcenterCredentialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetDnsForwarding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDnsForwardingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetDnsForwarding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GetDnsForwarding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetDnsForwarding(ctx, req.(*GetDnsForwardingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateDnsForwarding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDnsForwardingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateDnsForwarding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_UpdateDnsForwarding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateDnsForwarding(ctx, req.(*UpdateDnsForwardingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetNetworkPeering_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkPeeringRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetNetworkPeering(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GetNetworkPeering_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetNetworkPeering(ctx, req.(*GetNetworkPeeringRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListNetworkPeerings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkPeeringsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListNetworkPeerings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ListNetworkPeerings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListNetworkPeerings(ctx, req.(*ListNetworkPeeringsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateNetworkPeering_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNetworkPeeringRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateNetworkPeering(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_CreateNetworkPeering_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateNetworkPeering(ctx, req.(*CreateNetworkPeeringRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeleteNetworkPeering_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNetworkPeeringRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeleteNetworkPeering(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_DeleteNetworkPeering_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeleteNetworkPeering(ctx, req.(*DeleteNetworkPeeringRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateNetworkPeering_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNetworkPeeringRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateNetworkPeering(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_UpdateNetworkPeering_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateNetworkPeering(ctx, req.(*UpdateNetworkPeeringRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListPeeringRoutes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPeeringRoutesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListPeeringRoutes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ListPeeringRoutes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListPeeringRoutes(ctx, req.(*ListPeeringRoutesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateHcxActivationKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateHcxActivationKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateHcxActivationKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_CreateHcxActivationKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateHcxActivationKey(ctx, req.(*CreateHcxActivationKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListHcxActivationKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHcxActivationKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListHcxActivationKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ListHcxActivationKeys_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListHcxActivationKeys(ctx, req.(*ListHcxActivationKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetHcxActivationKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHcxActivationKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetHcxActivationKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GetHcxActivationKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetHcxActivationKey(ctx, req.(*GetHcxActivationKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GetNetworkPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetNetworkPolicy(ctx, req.(*GetNetworkPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListNetworkPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListNetworkPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ListNetworkPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListNetworkPolicies(ctx, req.(*ListNetworkPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNetworkPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_CreateNetworkPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateNetworkPolicy(ctx, req.(*CreateNetworkPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNetworkPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_UpdateNetworkPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateNetworkPolicy(ctx, req.(*UpdateNetworkPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeleteNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNetworkPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeleteNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_DeleteNetworkPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeleteNetworkPolicy(ctx, req.(*DeleteNetworkPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListManagementDnsZoneBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListManagementDnsZoneBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListManagementDnsZoneBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ListManagementDnsZoneBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListManagementDnsZoneBindings(ctx, req.(*ListManagementDnsZoneBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetManagementDnsZoneBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetManagementDnsZoneBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetManagementDnsZoneBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GetManagementDnsZoneBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetManagementDnsZoneBinding(ctx, req.(*GetManagementDnsZoneBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateManagementDnsZoneBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateManagementDnsZoneBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateManagementDnsZoneBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_CreateManagementDnsZoneBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateManagementDnsZoneBinding(ctx, req.(*CreateManagementDnsZoneBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateManagementDnsZoneBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateManagementDnsZoneBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateManagementDnsZoneBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_UpdateManagementDnsZoneBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateManagementDnsZoneBinding(ctx, req.(*UpdateManagementDnsZoneBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeleteManagementDnsZoneBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteManagementDnsZoneBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeleteManagementDnsZoneBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_DeleteManagementDnsZoneBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeleteManagementDnsZoneBinding(ctx, req.(*DeleteManagementDnsZoneBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_RepairManagementDnsZoneBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RepairManagementDnsZoneBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).RepairManagementDnsZoneBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_RepairManagementDnsZoneBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).RepairManagementDnsZoneBinding(ctx, req.(*RepairManagementDnsZoneBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateVmwareEngineNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVmwareEngineNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateVmwareEngineNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_CreateVmwareEngineNetwork_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateVmwareEngineNetwork(ctx, req.(*CreateVmwareEngineNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateVmwareEngineNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVmwareEngineNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateVmwareEngineNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_UpdateVmwareEngineNetwork_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateVmwareEngineNetwork(ctx, req.(*UpdateVmwareEngineNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeleteVmwareEngineNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVmwareEngineNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeleteVmwareEngineNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_DeleteVmwareEngineNetwork_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeleteVmwareEngineNetwork(ctx, req.(*DeleteVmwareEngineNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetVmwareEngineNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVmwareEngineNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetVmwareEngineNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GetVmwareEngineNetwork_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetVmwareEngineNetwork(ctx, req.(*GetVmwareEngineNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListVmwareEngineNetworks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVmwareEngineNetworksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListVmwareEngineNetworks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ListVmwareEngineNetworks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListVmwareEngineNetworks(ctx, req.(*ListVmwareEngineNetworksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreatePrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreatePrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_CreatePrivateConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreatePrivateConnection(ctx, req.(*CreatePrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetPrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetPrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GetPrivateConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetPrivateConnection(ctx, req.(*GetPrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListPrivateConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPrivateConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListPrivateConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ListPrivateConnections_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListPrivateConnections(ctx, req.(*ListPrivateConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdatePrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdatePrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_UpdatePrivateConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdatePrivateConnection(ctx, req.(*UpdatePrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeletePrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeletePrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_DeletePrivateConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeletePrivateConnection(ctx, req.(*DeletePrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListPrivateConnectionPeeringRoutes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPrivateConnectionPeeringRoutesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListPrivateConnectionPeeringRoutes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_ListPrivateConnectionPeeringRoutes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListPrivateConnectionPeeringRoutes(ctx, req.(*ListPrivateConnectionPeeringRoutesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GrantDnsBindPermission_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GrantDnsBindPermissionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GrantDnsBindPermission(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GrantDnsBindPermission_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GrantDnsBindPermission(ctx, req.(*GrantDnsBindPermissionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetDnsBindPermission_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDnsBindPermissionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetDnsBindPermission(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_GetDnsBindPermission_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetDnsBindPermission(ctx, req.(*GetDnsBindPermissionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_RevokeDnsBindPermission_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevokeDnsBindPermissionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).RevokeDnsBindPermission(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmwareEngine_RevokeDnsBindPermission_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).RevokeDnsBindPermission(ctx, req.(*RevokeDnsBindPermissionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// VmwareEngine_ServiceDesc is the grpc.ServiceDesc for VmwareEngine service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var VmwareEngine_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vmwareengine.v1.VmwareEngine",
	HandlerType: (*VmwareEngineServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListPrivateClouds",
			Handler:    _VmwareEngine_ListPrivateClouds_Handler,
		},
		{
			MethodName: "GetPrivateCloud",
			Handler:    _VmwareEngine_GetPrivateCloud_Handler,
		},
		{
			MethodName: "CreatePrivateCloud",
			Handler:    _VmwareEngine_CreatePrivateCloud_Handler,
		},
		{
			MethodName: "UpdatePrivateCloud",
			Handler:    _VmwareEngine_UpdatePrivateCloud_Handler,
		},
		{
			MethodName: "DeletePrivateCloud",
			Handler:    _VmwareEngine_DeletePrivateCloud_Handler,
		},
		{
			MethodName: "UndeletePrivateCloud",
			Handler:    _VmwareEngine_UndeletePrivateCloud_Handler,
		},
		{
			MethodName: "ListClusters",
			Handler:    _VmwareEngine_ListClusters_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _VmwareEngine_GetCluster_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _VmwareEngine_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _VmwareEngine_UpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _VmwareEngine_DeleteCluster_Handler,
		},
		{
			MethodName: "ListNodes",
			Handler:    _VmwareEngine_ListNodes_Handler,
		},
		{
			MethodName: "GetNode",
			Handler:    _VmwareEngine_GetNode_Handler,
		},
		{
			MethodName: "ListExternalAddresses",
			Handler:    _VmwareEngine_ListExternalAddresses_Handler,
		},
		{
			MethodName: "FetchNetworkPolicyExternalAddresses",
			Handler:    _VmwareEngine_FetchNetworkPolicyExternalAddresses_Handler,
		},
		{
			MethodName: "GetExternalAddress",
			Handler:    _VmwareEngine_GetExternalAddress_Handler,
		},
		{
			MethodName: "CreateExternalAddress",
			Handler:    _VmwareEngine_CreateExternalAddress_Handler,
		},
		{
			MethodName: "UpdateExternalAddress",
			Handler:    _VmwareEngine_UpdateExternalAddress_Handler,
		},
		{
			MethodName: "DeleteExternalAddress",
			Handler:    _VmwareEngine_DeleteExternalAddress_Handler,
		},
		{
			MethodName: "ListSubnets",
			Handler:    _VmwareEngine_ListSubnets_Handler,
		},
		{
			MethodName: "GetSubnet",
			Handler:    _VmwareEngine_GetSubnet_Handler,
		},
		{
			MethodName: "UpdateSubnet",
			Handler:    _VmwareEngine_UpdateSubnet_Handler,
		},
		{
			MethodName: "ListExternalAccessRules",
			Handler:    _VmwareEngine_ListExternalAccessRules_Handler,
		},
		{
			MethodName: "GetExternalAccessRule",
			Handler:    _VmwareEngine_GetExternalAccessRule_Handler,
		},
		{
			MethodName: "CreateExternalAccessRule",
			Handler:    _VmwareEngine_CreateExternalAccessRule_Handler,
		},
		{
			MethodName: "UpdateExternalAccessRule",
			Handler:    _VmwareEngine_UpdateExternalAccessRule_Handler,
		},
		{
			MethodName: "DeleteExternalAccessRule",
			Handler:    _VmwareEngine_DeleteExternalAccessRule_Handler,
		},
		{
			MethodName: "ListLoggingServers",
			Handler:    _VmwareEngine_ListLoggingServers_Handler,
		},
		{
			MethodName: "GetLoggingServer",
			Handler:    _VmwareEngine_GetLoggingServer_Handler,
		},
		{
			MethodName: "CreateLoggingServer",
			Handler:    _VmwareEngine_CreateLoggingServer_Handler,
		},
		{
			MethodName: "UpdateLoggingServer",
			Handler:    _VmwareEngine_UpdateLoggingServer_Handler,
		},
		{
			MethodName: "DeleteLoggingServer",
			Handler:    _VmwareEngine_DeleteLoggingServer_Handler,
		},
		{
			MethodName: "ListNodeTypes",
			Handler:    _VmwareEngine_ListNodeTypes_Handler,
		},
		{
			MethodName: "GetNodeType",
			Handler:    _VmwareEngine_GetNodeType_Handler,
		},
		{
			MethodName: "ShowNsxCredentials",
			Handler:    _VmwareEngine_ShowNsxCredentials_Handler,
		},
		{
			MethodName: "ShowVcenterCredentials",
			Handler:    _VmwareEngine_ShowVcenterCredentials_Handler,
		},
		{
			MethodName: "ResetNsxCredentials",
			Handler:    _VmwareEngine_ResetNsxCredentials_Handler,
		},
		{
			MethodName: "ResetVcenterCredentials",
			Handler:    _VmwareEngine_ResetVcenterCredentials_Handler,
		},
		{
			MethodName: "GetDnsForwarding",
			Handler:    _VmwareEngine_GetDnsForwarding_Handler,
		},
		{
			MethodName: "UpdateDnsForwarding",
			Handler:    _VmwareEngine_UpdateDnsForwarding_Handler,
		},
		{
			MethodName: "GetNetworkPeering",
			Handler:    _VmwareEngine_GetNetworkPeering_Handler,
		},
		{
			MethodName: "ListNetworkPeerings",
			Handler:    _VmwareEngine_ListNetworkPeerings_Handler,
		},
		{
			MethodName: "CreateNetworkPeering",
			Handler:    _VmwareEngine_CreateNetworkPeering_Handler,
		},
		{
			MethodName: "DeleteNetworkPeering",
			Handler:    _VmwareEngine_DeleteNetworkPeering_Handler,
		},
		{
			MethodName: "UpdateNetworkPeering",
			Handler:    _VmwareEngine_UpdateNetworkPeering_Handler,
		},
		{
			MethodName: "ListPeeringRoutes",
			Handler:    _VmwareEngine_ListPeeringRoutes_Handler,
		},
		{
			MethodName: "CreateHcxActivationKey",
			Handler:    _VmwareEngine_CreateHcxActivationKey_Handler,
		},
		{
			MethodName: "ListHcxActivationKeys",
			Handler:    _VmwareEngine_ListHcxActivationKeys_Handler,
		},
		{
			MethodName: "GetHcxActivationKey",
			Handler:    _VmwareEngine_GetHcxActivationKey_Handler,
		},
		{
			MethodName: "GetNetworkPolicy",
			Handler:    _VmwareEngine_GetNetworkPolicy_Handler,
		},
		{
			MethodName: "ListNetworkPolicies",
			Handler:    _VmwareEngine_ListNetworkPolicies_Handler,
		},
		{
			MethodName: "CreateNetworkPolicy",
			Handler:    _VmwareEngine_CreateNetworkPolicy_Handler,
		},
		{
			MethodName: "UpdateNetworkPolicy",
			Handler:    _VmwareEngine_UpdateNetworkPolicy_Handler,
		},
		{
			MethodName: "DeleteNetworkPolicy",
			Handler:    _VmwareEngine_DeleteNetworkPolicy_Handler,
		},
		{
			MethodName: "ListManagementDnsZoneBindings",
			Handler:    _VmwareEngine_ListManagementDnsZoneBindings_Handler,
		},
		{
			MethodName: "GetManagementDnsZoneBinding",
			Handler:    _VmwareEngine_GetManagementDnsZoneBinding_Handler,
		},
		{
			MethodName: "CreateManagementDnsZoneBinding",
			Handler:    _VmwareEngine_CreateManagementDnsZoneBinding_Handler,
		},
		{
			MethodName: "UpdateManagementDnsZoneBinding",
			Handler:    _VmwareEngine_UpdateManagementDnsZoneBinding_Handler,
		},
		{
			MethodName: "DeleteManagementDnsZoneBinding",
			Handler:    _VmwareEngine_DeleteManagementDnsZoneBinding_Handler,
		},
		{
			MethodName: "RepairManagementDnsZoneBinding",
			Handler:    _VmwareEngine_RepairManagementDnsZoneBinding_Handler,
		},
		{
			MethodName: "CreateVmwareEngineNetwork",
			Handler:    _VmwareEngine_CreateVmwareEngineNetwork_Handler,
		},
		{
			MethodName: "UpdateVmwareEngineNetwork",
			Handler:    _VmwareEngine_UpdateVmwareEngineNetwork_Handler,
		},
		{
			MethodName: "DeleteVmwareEngineNetwork",
			Handler:    _VmwareEngine_DeleteVmwareEngineNetwork_Handler,
		},
		{
			MethodName: "GetVmwareEngineNetwork",
			Handler:    _VmwareEngine_GetVmwareEngineNetwork_Handler,
		},
		{
			MethodName: "ListVmwareEngineNetworks",
			Handler:    _VmwareEngine_ListVmwareEngineNetworks_Handler,
		},
		{
			MethodName: "CreatePrivateConnection",
			Handler:    _VmwareEngine_CreatePrivateConnection_Handler,
		},
		{
			MethodName: "GetPrivateConnection",
			Handler:    _VmwareEngine_GetPrivateConnection_Handler,
		},
		{
			MethodName: "ListPrivateConnections",
			Handler:    _VmwareEngine_ListPrivateConnections_Handler,
		},
		{
			MethodName: "UpdatePrivateConnection",
			Handler:    _VmwareEngine_UpdatePrivateConnection_Handler,
		},
		{
			MethodName: "DeletePrivateConnection",
			Handler:    _VmwareEngine_DeletePrivateConnection_Handler,
		},
		{
			MethodName: "ListPrivateConnectionPeeringRoutes",
			Handler:    _VmwareEngine_ListPrivateConnectionPeeringRoutes_Handler,
		},
		{
			MethodName: "GrantDnsBindPermission",
			Handler:    _VmwareEngine_GrantDnsBindPermission_Handler,
		},
		{
			MethodName: "GetDnsBindPermission",
			Handler:    _VmwareEngine_GetDnsBindPermission_Handler,
		},
		{
			MethodName: "RevokeDnsBindPermission",
			Handler:    _VmwareEngine_RevokeDnsBindPermission_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vmwareengine/v1/vmwareengine.proto",
}
