// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/webrisk/v1/webrisk.proto

package webriskpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	WebRiskService_ComputeThreatListDiff_FullMethodName = "/google.cloud.webrisk.v1.WebRiskService/ComputeThreatListDiff"
	WebRiskService_SearchUris_FullMethodName            = "/google.cloud.webrisk.v1.WebRiskService/SearchUris"
	WebRiskService_SearchHashes_FullMethodName          = "/google.cloud.webrisk.v1.WebRiskService/SearchHashes"
	WebRiskService_CreateSubmission_FullMethodName      = "/google.cloud.webrisk.v1.WebRiskService/CreateSubmission"
	WebRiskService_SubmitUri_FullMethodName             = "/google.cloud.webrisk.v1.WebRiskService/SubmitUri"
)

// WebRiskServiceClient is the client API for WebRiskService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type WebRiskServiceClient interface {
	// Gets the most recent threat list diffs. These diffs should be applied to
	// a local database of hashes to keep it up-to-date. If the local database is
	// empty or excessively out-of-date, a complete snapshot of the database will
	// be returned. This Method only updates a single ThreatList at a time. To
	// update multiple ThreatList databases, this method needs to be called once
	// for each list.
	ComputeThreatListDiff(ctx context.Context, in *ComputeThreatListDiffRequest, opts ...grpc.CallOption) (*ComputeThreatListDiffResponse, error)
	// This method is used to check whether a URI is on a given threatList.
	// Multiple threatLists may be searched in a single query.
	// The response will list all requested threatLists the URI was found to
	// match. If the URI is not found on any of the requested ThreatList an
	// empty response will be returned.
	SearchUris(ctx context.Context, in *SearchUrisRequest, opts ...grpc.CallOption) (*SearchUrisResponse, error)
	// Gets the full hashes that match the requested hash prefix.
	// This is used after a hash prefix is looked up in a threatList
	// and there is a match. The client side threatList only holds partial hashes
	// so the client must query this method to determine if there is a full
	// hash match of a threat.
	SearchHashes(ctx context.Context, in *SearchHashesRequest, opts ...grpc.CallOption) (*SearchHashesResponse, error)
	// Creates a Submission of a URI suspected of containing phishing content to
	// be reviewed. If the result verifies the existence of malicious phishing
	// content, the site will be added to the [Google's Social Engineering
	// lists](https://support.google.com/webmasters/answer/6350487/) in order to
	// protect users that could get exposed to this threat in the future. Only
	// allowlisted projects can use this method during Early Access. Please reach
	// out to Sales or your customer engineer to obtain access.
	CreateSubmission(ctx context.Context, in *CreateSubmissionRequest, opts ...grpc.CallOption) (*Submission, error)
	// Submits a URI suspected of containing malicious content to be reviewed.
	// Returns a google.longrunning.Operation which, once the review is complete,
	// is updated with its result. You can use the [Pub/Sub API]
	// (https://cloud.google.com/pubsub) to receive notifications for the returned
	// Operation. If the result verifies the existence of malicious content, the
	// site will be added to the [Google's Social Engineering lists]
	// (https://support.google.com/webmasters/answer/6350487/) in order to
	// protect users that could get exposed to this threat in the future. Only
	// allowlisted projects can use this method during Early Access. Please reach
	// out to Sales or your customer engineer to obtain access.
	SubmitUri(ctx context.Context, in *SubmitUriRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type webRiskServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewWebRiskServiceClient(cc grpc.ClientConnInterface) WebRiskServiceClient {
	return &webRiskServiceClient{cc}
}

func (c *webRiskServiceClient) ComputeThreatListDiff(ctx context.Context, in *ComputeThreatListDiffRequest, opts ...grpc.CallOption) (*ComputeThreatListDiffResponse, error) {
	out := new(ComputeThreatListDiffResponse)
	err := c.cc.Invoke(ctx, WebRiskService_ComputeThreatListDiff_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webRiskServiceClient) SearchUris(ctx context.Context, in *SearchUrisRequest, opts ...grpc.CallOption) (*SearchUrisResponse, error) {
	out := new(SearchUrisResponse)
	err := c.cc.Invoke(ctx, WebRiskService_SearchUris_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webRiskServiceClient) SearchHashes(ctx context.Context, in *SearchHashesRequest, opts ...grpc.CallOption) (*SearchHashesResponse, error) {
	out := new(SearchHashesResponse)
	err := c.cc.Invoke(ctx, WebRiskService_SearchHashes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webRiskServiceClient) CreateSubmission(ctx context.Context, in *CreateSubmissionRequest, opts ...grpc.CallOption) (*Submission, error) {
	out := new(Submission)
	err := c.cc.Invoke(ctx, WebRiskService_CreateSubmission_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webRiskServiceClient) SubmitUri(ctx context.Context, in *SubmitUriRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, WebRiskService_SubmitUri_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WebRiskServiceServer is the server API for WebRiskService service.
// All implementations should embed UnimplementedWebRiskServiceServer
// for forward compatibility
type WebRiskServiceServer interface {
	// Gets the most recent threat list diffs. These diffs should be applied to
	// a local database of hashes to keep it up-to-date. If the local database is
	// empty or excessively out-of-date, a complete snapshot of the database will
	// be returned. This Method only updates a single ThreatList at a time. To
	// update multiple ThreatList databases, this method needs to be called once
	// for each list.
	ComputeThreatListDiff(context.Context, *ComputeThreatListDiffRequest) (*ComputeThreatListDiffResponse, error)
	// This method is used to check whether a URI is on a given threatList.
	// Multiple threatLists may be searched in a single query.
	// The response will list all requested threatLists the URI was found to
	// match. If the URI is not found on any of the requested ThreatList an
	// empty response will be returned.
	SearchUris(context.Context, *SearchUrisRequest) (*SearchUrisResponse, error)
	// Gets the full hashes that match the requested hash prefix.
	// This is used after a hash prefix is looked up in a threatList
	// and there is a match. The client side threatList only holds partial hashes
	// so the client must query this method to determine if there is a full
	// hash match of a threat.
	SearchHashes(context.Context, *SearchHashesRequest) (*SearchHashesResponse, error)
	// Creates a Submission of a URI suspected of containing phishing content to
	// be reviewed. If the result verifies the existence of malicious phishing
	// content, the site will be added to the [Google's Social Engineering
	// lists](https://support.google.com/webmasters/answer/6350487/) in order to
	// protect users that could get exposed to this threat in the future. Only
	// allowlisted projects can use this method during Early Access. Please reach
	// out to Sales or your customer engineer to obtain access.
	CreateSubmission(context.Context, *CreateSubmissionRequest) (*Submission, error)
	// Submits a URI suspected of containing malicious content to be reviewed.
	// Returns a google.longrunning.Operation which, once the review is complete,
	// is updated with its result. You can use the [Pub/Sub API]
	// (https://cloud.google.com/pubsub) to receive notifications for the returned
	// Operation. If the result verifies the existence of malicious content, the
	// site will be added to the [Google's Social Engineering lists]
	// (https://support.google.com/webmasters/answer/6350487/) in order to
	// protect users that could get exposed to this threat in the future. Only
	// allowlisted projects can use this method during Early Access. Please reach
	// out to Sales or your customer engineer to obtain access.
	SubmitUri(context.Context, *SubmitUriRequest) (*longrunningpb.Operation, error)
}

// UnimplementedWebRiskServiceServer should be embedded to have forward compatible implementations.
type UnimplementedWebRiskServiceServer struct {
}

func (UnimplementedWebRiskServiceServer) ComputeThreatListDiff(context.Context, *ComputeThreatListDiffRequest) (*ComputeThreatListDiffResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ComputeThreatListDiff not implemented")
}
func (UnimplementedWebRiskServiceServer) SearchUris(context.Context, *SearchUrisRequest) (*SearchUrisResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchUris not implemented")
}
func (UnimplementedWebRiskServiceServer) SearchHashes(context.Context, *SearchHashesRequest) (*SearchHashesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchHashes not implemented")
}
func (UnimplementedWebRiskServiceServer) CreateSubmission(context.Context, *CreateSubmissionRequest) (*Submission, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSubmission not implemented")
}
func (UnimplementedWebRiskServiceServer) SubmitUri(context.Context, *SubmitUriRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubmitUri not implemented")
}

// UnsafeWebRiskServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to WebRiskServiceServer will
// result in compilation errors.
type UnsafeWebRiskServiceServer interface {
	mustEmbedUnimplementedWebRiskServiceServer()
}

func RegisterWebRiskServiceServer(s grpc.ServiceRegistrar, srv WebRiskServiceServer) {
	s.RegisterService(&WebRiskService_ServiceDesc, srv)
}

func _WebRiskService_ComputeThreatListDiff_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComputeThreatListDiffRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceServer).ComputeThreatListDiff(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebRiskService_ComputeThreatListDiff_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceServer).ComputeThreatListDiff(ctx, req.(*ComputeThreatListDiffRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebRiskService_SearchUris_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchUrisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceServer).SearchUris(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebRiskService_SearchUris_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceServer).SearchUris(ctx, req.(*SearchUrisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebRiskService_SearchHashes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchHashesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceServer).SearchHashes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebRiskService_SearchHashes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceServer).SearchHashes(ctx, req.(*SearchHashesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebRiskService_CreateSubmission_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSubmissionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceServer).CreateSubmission(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebRiskService_CreateSubmission_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceServer).CreateSubmission(ctx, req.(*CreateSubmissionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebRiskService_SubmitUri_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubmitUriRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceServer).SubmitUri(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: WebRiskService_SubmitUri_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceServer).SubmitUri(ctx, req.(*SubmitUriRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// WebRiskService_ServiceDesc is the grpc.ServiceDesc for WebRiskService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var WebRiskService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.webrisk.v1.WebRiskService",
	HandlerType: (*WebRiskServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ComputeThreatListDiff",
			Handler:    _WebRiskService_ComputeThreatListDiff_Handler,
		},
		{
			MethodName: "SearchUris",
			Handler:    _WebRiskService_SearchUris_Handler,
		},
		{
			MethodName: "SearchHashes",
			Handler:    _WebRiskService_SearchHashes_Handler,
		},
		{
			MethodName: "CreateSubmission",
			Handler:    _WebRiskService_CreateSubmission_Handler,
		},
		{
			MethodName: "SubmitUri",
			Handler:    _WebRiskService_SubmitUri_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/webrisk/v1/webrisk.proto",
}
