package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTablePartitionDiagnose invokes the adb.DescribeTablePartitionDiagnose API synchronously
func (client *Client) DescribeTablePartitionDiagnose(request *DescribeTablePartitionDiagnoseRequest) (response *DescribeTablePartitionDiagnoseResponse, err error) {
	response = CreateDescribeTablePartitionDiagnoseResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTablePartitionDiagnoseWithChan invokes the adb.DescribeTablePartitionDiagnose API asynchronously
func (client *Client) DescribeTablePartitionDiagnoseWithChan(request *DescribeTablePartitionDiagnoseRequest) (<-chan *DescribeTablePartitionDiagnoseResponse, <-chan error) {
	responseChan := make(chan *DescribeTablePartitionDiagnoseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTablePartitionDiagnose(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTablePartitionDiagnoseWithCallback invokes the adb.DescribeTablePartitionDiagnose API asynchronously
func (client *Client) DescribeTablePartitionDiagnoseWithCallback(request *DescribeTablePartitionDiagnoseRequest, callback func(response *DescribeTablePartitionDiagnoseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTablePartitionDiagnoseResponse
		var err error
		defer close(result)
		response, err = client.DescribeTablePartitionDiagnose(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTablePartitionDiagnoseRequest is the request struct for api DescribeTablePartitionDiagnose
type DescribeTablePartitionDiagnoseRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeTablePartitionDiagnoseResponse is the response struct for api DescribeTablePartitionDiagnose
type DescribeTablePartitionDiagnoseResponse struct {
	*responses.BaseResponse
	TotalCount                    int                      `json:"TotalCount" xml:"TotalCount"`
	RequestId                     string                   `json:"RequestId" xml:"RequestId"`
	PageSize                      int                      `json:"PageSize" xml:"PageSize"`
	PageNumber                    int                      `json:"PageNumber" xml:"PageNumber"`
	DBClusterId                   string                   `json:"DBClusterId" xml:"DBClusterId"`
	SuggestMaxRecordsPerPartition int64                    `json:"SuggestMaxRecordsPerPartition" xml:"SuggestMaxRecordsPerPartition"`
	SuggestMinRecordsPerPartition int64                    `json:"SuggestMinRecordsPerPartition" xml:"SuggestMinRecordsPerPartition"`
	Items                         []TablePartitionDiagnose `json:"Items" xml:"Items"`
}

// CreateDescribeTablePartitionDiagnoseRequest creates a request to invoke DescribeTablePartitionDiagnose API
func CreateDescribeTablePartitionDiagnoseRequest() (request *DescribeTablePartitionDiagnoseRequest) {
	request = &DescribeTablePartitionDiagnoseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeTablePartitionDiagnose", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTablePartitionDiagnoseResponse creates a response to parse from DescribeTablePartitionDiagnose response
func CreateDescribeTablePartitionDiagnoseResponse() (response *DescribeTablePartitionDiagnoseResponse) {
	response = &DescribeTablePartitionDiagnoseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
