package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDegradeRulesOfResource invokes the ahas_openapi.ListDegradeRulesOfResource API synchronously
func (client *Client) ListDegradeRulesOfResource(request *ListDegradeRulesOfResourceRequest) (response *ListDegradeRulesOfResourceResponse, err error) {
	response = CreateListDegradeRulesOfResourceResponse()
	err = client.DoAction(request, response)
	return
}

// ListDegradeRulesOfResourceWithChan invokes the ahas_openapi.ListDegradeRulesOfResource API asynchronously
func (client *Client) ListDegradeRulesOfResourceWithChan(request *ListDegradeRulesOfResourceRequest) (<-chan *ListDegradeRulesOfResourceResponse, <-chan error) {
	responseChan := make(chan *ListDegradeRulesOfResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDegradeRulesOfResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDegradeRulesOfResourceWithCallback invokes the ahas_openapi.ListDegradeRulesOfResource API asynchronously
func (client *Client) ListDegradeRulesOfResourceWithCallback(request *ListDegradeRulesOfResourceRequest, callback func(response *ListDegradeRulesOfResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDegradeRulesOfResourceResponse
		var err error
		defer close(result)
		response, err = client.ListDegradeRulesOfResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDegradeRulesOfResourceRequest is the request struct for api ListDegradeRulesOfResource
type ListDegradeRulesOfResourceRequest struct {
	*requests.RpcRequest
	Resource     string           `position:"Query" name:"Resource"`
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	AppName      string           `position:"Query" name:"AppName"`
	Namespace    string           `position:"Query" name:"Namespace"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	PageIndex    requests.Integer `position:"Query" name:"PageIndex"`
}

// ListDegradeRulesOfResourceResponse is the response struct for api ListDegradeRulesOfResource
type ListDegradeRulesOfResourceResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListDegradeRulesOfResourceRequest creates a request to invoke ListDegradeRulesOfResource API
func CreateListDegradeRulesOfResourceRequest() (request *ListDegradeRulesOfResourceRequest) {
	request = &ListDegradeRulesOfResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "ListDegradeRulesOfResource", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDegradeRulesOfResourceResponse creates a response to parse from ListDegradeRulesOfResource response
func CreateListDegradeRulesOfResourceResponse() (response *ListDegradeRulesOfResourceResponse) {
	response = &ListDegradeRulesOfResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
