package aicontent

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Personalizedtxt2imgQueryModelTrainStatus invokes the aicontent.Personalizedtxt2imgQueryModelTrainStatus API synchronously
func (client *Client) Personalizedtxt2imgQueryModelTrainStatus(request *Personalizedtxt2imgQueryModelTrainStatusRequest) (response *Personalizedtxt2imgQueryModelTrainStatusResponse, err error) {
	response = CreatePersonalizedtxt2imgQueryModelTrainStatusResponse()
	err = client.DoAction(request, response)
	return
}

// Personalizedtxt2imgQueryModelTrainStatusWithChan invokes the aicontent.Personalizedtxt2imgQueryModelTrainStatus API asynchronously
func (client *Client) Personalizedtxt2imgQueryModelTrainStatusWithChan(request *Personalizedtxt2imgQueryModelTrainStatusRequest) (<-chan *Personalizedtxt2imgQueryModelTrainStatusResponse, <-chan error) {
	responseChan := make(chan *Personalizedtxt2imgQueryModelTrainStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Personalizedtxt2imgQueryModelTrainStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// Personalizedtxt2imgQueryModelTrainStatusWithCallback invokes the aicontent.Personalizedtxt2imgQueryModelTrainStatus API asynchronously
func (client *Client) Personalizedtxt2imgQueryModelTrainStatusWithCallback(request *Personalizedtxt2imgQueryModelTrainStatusRequest, callback func(response *Personalizedtxt2imgQueryModelTrainStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *Personalizedtxt2imgQueryModelTrainStatusResponse
		var err error
		defer close(result)
		response, err = client.Personalizedtxt2imgQueryModelTrainStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// Personalizedtxt2imgQueryModelTrainStatusRequest is the request struct for api Personalizedtxt2imgQueryModelTrainStatus
type Personalizedtxt2imgQueryModelTrainStatusRequest struct {
	*requests.RoaRequest
	ModelId string `position:"Query" name:"modelId"`
}

// Personalizedtxt2imgQueryModelTrainStatusResponse is the response struct for api Personalizedtxt2imgQueryModelTrainStatus
type Personalizedtxt2imgQueryModelTrainStatusResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"requestId" xml:"requestId"`
	Success        bool   `json:"success" xml:"success"`
	ErrCode        string `json:"errCode" xml:"errCode"`
	ErrMessage     string `json:"errMessage" xml:"errMessage"`
	HttpStatusCode int    `json:"httpStatusCode" xml:"httpStatusCode"`
	Data           Data   `json:"data" xml:"data"`
}

// CreatePersonalizedtxt2imgQueryModelTrainStatusRequest creates a request to invoke Personalizedtxt2imgQueryModelTrainStatus API
func CreatePersonalizedtxt2imgQueryModelTrainStatusRequest() (request *Personalizedtxt2imgQueryModelTrainStatusRequest) {
	request = &Personalizedtxt2imgQueryModelTrainStatusRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("AiContent", "20240611", "Personalizedtxt2imgQueryModelTrainStatus", "/api/v1/personalizedtxt2img/queryModelTrainStatus", "", "")
	request.Method = requests.GET
	return
}

// CreatePersonalizedtxt2imgQueryModelTrainStatusResponse creates a response to parse from Personalizedtxt2imgQueryModelTrainStatus response
func CreatePersonalizedtxt2imgQueryModelTrainStatusResponse() (response *Personalizedtxt2imgQueryModelTrainStatusResponse) {
	response = &Personalizedtxt2imgQueryModelTrainStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
