package aimath

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenAnalysis invokes the aimath.GenAnalysis API synchronously
func (client *Client) GenAnalysis(request *GenAnalysisRequest) (response *GenAnalysisResponse, err error) {
	response = CreateGenAnalysisResponse()
	err = client.DoAction(request, response)
	return
}

// GenAnalysisWithChan invokes the aimath.GenAnalysis API asynchronously
func (client *Client) GenAnalysisWithChan(request *GenAnalysisRequest) (<-chan *GenAnalysisResponse, <-chan error) {
	responseChan := make(chan *GenAnalysisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenAnalysis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenAnalysisWithCallback invokes the aimath.GenAnalysis API asynchronously
func (client *Client) GenAnalysisWithCallback(request *GenAnalysisRequest, callback func(response *GenAnalysisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenAnalysisResponse
		var err error
		defer close(result)
		response, err = client.GenAnalysis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenAnalysisRequest is the request struct for api GenAnalysis
type GenAnalysisRequest struct {
	*requests.RpcRequest
	ExerciseContent string `position:"Body" name:"ExerciseContent"`
}

// GenAnalysisResponse is the response struct for api GenAnalysis
type GenAnalysisResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	EventType string `json:"EventType" xml:"EventType"`
	Content   string `json:"Content" xml:"Content"`
	ErrCode   string `json:"ErrCode" xml:"ErrCode"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
}

// CreateGenAnalysisRequest creates a request to invoke GenAnalysis API
func CreateGenAnalysisRequest() (request *GenAnalysisRequest) {
	request = &GenAnalysisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("AIMath", "2024-11-14", "GenAnalysis", "", "")
	request.Method = requests.POST
	return
}

// CreateGenAnalysisResponse creates a response to parse from GenAnalysis response
func CreateGenAnalysisResponse() (response *GenAnalysisResponse) {
	response = &GenAnalysisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
